/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.entity.RkProcurePaymentPlanEntity;
import com.bringspring.contract.model.rkprocuremanage.RkProcureManageInfoVO;
import com.bringspring.contract.model.rkprocurepaymentplan.RkProcurePaymentPlanCrForm;
import com.bringspring.contract.model.rkprocurepaymentplan.RkProcurePaymentPlanInfoVO;
import com.bringspring.contract.model.rkprocurepaymentplan.RkProcurePaymentPlanListVO;
import com.bringspring.contract.model.rkprocurepaymentplan.RkProcurePaymentPlanPagination;
import com.bringspring.contract.model.rkprocurepaymentplan.RkProcurePaymentPlanPaginationExportModel;
import com.bringspring.contract.model.rkprocurepaymentplan.RkProcurePaymentPlanUpForm;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.service.RkProcurePaymentPlanService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u91c7\u8d2d\u4ed8\u6b3e\u8ba1\u5212"}, value="contract")
@RequestMapping(value={"/api/contract/RkProcurePaymentPlan"})
public class RkProcurePaymentPlanController {
    private static final Logger log = LoggerFactory.getLogger(RkProcurePaymentPlanController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProcurePaymentPlanService rkProcurePaymentPlanService;
    @Autowired
    private RkProcureManageService rkProcureManageService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProcurePaymentPlanPagination rkProcurePaymentPlanPagination) throws IOException {
        List<RkProcurePaymentPlanEntity> list = this.rkProcurePaymentPlanService.getList(rkProcurePaymentPlanPagination);
        for (RkProcurePaymentPlanEntity rkProcurePaymentPlanEntity : list) {
            rkProcurePaymentPlanEntity.setPaymentType(this.baseDataUtil.getDictName(rkProcurePaymentPlanEntity.getPaymentType(), Constants.RETURN_PLAN_PAYMENT_TYPE_DICT_ID));
        }
        List listVO = JsonUtil.getJsonToList(list, RkProcurePaymentPlanListVO.class);
        for (RkProcurePaymentPlanListVO vo : listVO) {
            RkProcureManageEntity procureInfo = this.rkProcureManageService.getInfo(vo.getProcureId());
            if (ObjectUtil.isNotEmpty((Object)procureInfo)) {
                RkProcureManageInfoVO procureManageInfoVO = (RkProcureManageInfoVO)JsonUtil.getJsonToBean((Object)procureInfo, RkProcureManageInfoVO.class);
                procureManageInfoVO.setApplyName(this.baseDataUtil.userSelectValue(procureManageInfoVO.getApplyId()));
                vo.setProcureInfo(procureManageInfoVO);
                if (ObjectUtil.isNotEmpty((Object)procureInfo) && ObjectUtil.isNotEmpty((Object)procureInfo.getProjectId())) {
                    vo.setProjectList(this.rkContractProjectService.getInfo(procureInfo.getProjectId()));
                }
            }
            vo.setCompanyName(this.baseDataUtil.getDictName(vo.getCompanyId(), "companyName"));
            vo.setPaymentTypeName(this.baseDataUtil.getDictName(vo.getPaymentType(), "paymentType"));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProcurePaymentPlanPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @Transactional
    @RepeatSubmit
    public ActionResult create(@RequestBody @Valid RkProcurePaymentPlanCrForm rkProcurePaymentPlanCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            rkProcurePaymentPlanCrForm.setCompanyId(userInfo.getOrganizeId());
            RkProcurePaymentPlanEntity entity = (RkProcurePaymentPlanEntity)JsonUtil.getJsonToBean((Object)rkProcurePaymentPlanCrForm, RkProcurePaymentPlanEntity.class);
            HashMap map = this.rkProcurePaymentPlanService.createPlan(rkProcurePaymentPlanCrForm);
            if (ObjectUtil.isEmpty(map.get("error"))) {
                return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
            }
            return ActionResult.fail((String)map.get("error").toString());
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProcurePaymentPlanInfoVO> info(@PathVariable(value="id") String id) {
        RkProcurePaymentPlanEntity entity = this.rkProcurePaymentPlanService.getInfo(id);
        RkProcurePaymentPlanInfoVO vo = (RkProcurePaymentPlanInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProcurePaymentPlanInfoVO.class);
        vo.setPaymentType(this.baseDataUtil.getDictName(vo.getPaymentType(), Constants.RETURN_PLAN_PAYMENT_TYPE_DICT_ID));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkProcurePaymentPlanInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkProcurePaymentPlanEntity entity = this.rkProcurePaymentPlanService.getInfo(id);
        RkProcurePaymentPlanInfoVO vo = (RkProcurePaymentPlanInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProcurePaymentPlanInfoVO.class);
        vo.setPaymentType(this.baseDataUtil.getDictName(vo.getPaymentType(), Constants.RETURN_PLAN_PAYMENT_TYPE_DICT_ID));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProcurePaymentPlanUpForm rkProcurePaymentPlanUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkProcurePaymentPlanEntity entity = this.rkProcurePaymentPlanService.getInfo(id);
        if (entity != null) {
            RkProcurePaymentPlanEntity subentity = (RkProcurePaymentPlanEntity)JsonUtil.getJsonToBean((Object)rkProcurePaymentPlanUpForm, RkProcurePaymentPlanEntity.class);
            this.rkProcurePaymentPlanService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/updatePlan"})
    public ActionResult updatePlan(@RequestBody @Valid List<RkProcurePaymentPlanUpForm> list) {
        Object object = this.$lock;
        synchronized (object) {
            if (CollectionUtil.isEmpty(list)) {
                return ActionResult.success((String)"\u65e0\u4ed8\u6b3e\u8ba1\u5212");
            }
            HashMap map = this.rkProcurePaymentPlanService.updatePlan(list);
            if (ObjectUtil.isEmpty(map.get("error"))) {
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)map.get("error").toString());
        }
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProcurePaymentPlanEntity entity = this.rkProcurePaymentPlanService.getInfo(id);
        if (entity != null) {
            this.rkProcurePaymentPlanService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/deleteBatch"})
    public ActionResult deleteBatch(@RequestBody List<String> idList) {
        Object object = this.$lock;
        synchronized (object) {
            HashMap map = this.rkProcurePaymentPlanService.deleteBatch(idList);
            if (ObjectUtil.isEmpty(map.get("error"))) {
                return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
            }
            return ActionResult.fail((String)map.get("error").toString());
        }
    }

    @GetMapping(value={"/getPlanByProcureId/{procureId}"})
    public ActionResult getPlanByProcureId(@PathVariable(value="procureId") String procureId) {
        List<RkProcurePaymentPlanEntity> listByProcureId = this.rkProcurePaymentPlanService.getListByProcureId(procureId);
        RkProcureManageEntity procureInfo = this.rkProcureManageService.getInfo(procureId);
        List jsonToList = JsonUtil.getJsonToList(listByProcureId, RkProcurePaymentPlanCrForm.class);
        for (int i = 0; i < jsonToList.size(); ++i) {
            RkProcurePaymentPlanCrForm plan = (RkProcurePaymentPlanCrForm)jsonToList.get(i);
            plan.setPaymentTypeName(this.baseDataUtil.getDictName(plan.getPaymentType(), "paymentType"));
            DictionaryDataEntity dataEntity = (DictionaryDataEntity)this.dictionaryDataService.getById((Serializable)((Object)plan.getPaymentType()));
            if (ObjectUtil.isNotNull((Object)dataEntity)) {
                plan.setPaymentTypeEnCode(dataEntity.getEnCode());
            }
            if (ObjectUtil.isEmpty((Object)plan.getPaidRatio())) {
                plan.setPaidRatio(BigDecimal.ZERO);
            }
            plan.setProcureName(procureInfo.getProcureName());
            plan.setProcureAmount(procureInfo.getProcureAmount());
            plan.setPlanNum("\u7b2c" + (i + 1) + "\u671f(\u5171" + jsonToList.size() + "\u671f)");
        }
        List sortedList = jsonToList.stream().sorted(Comparator.comparing(RkProcurePaymentPlanCrForm::getPayDate)).collect(Collectors.toList());
        return ActionResult.success(sortedList);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkProcurePaymentPlanPaginationExportModel rkProcurePaymentPlanPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkProcurePaymentPlanPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkProcurePaymentPlanPagination procurePagination = (RkProcurePaymentPlanPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkProcurePaymentPlanPaginationExportModel), RkProcurePaymentPlanPagination.class));
        List<RkProcurePaymentPlanEntity> list = this.rkProcurePaymentPlanService.getTypeList(procurePagination, rkProcurePaymentPlanPaginationExportModel.getSelectKey());
        List listVO = JsonUtil.getJsonToList(list, RkProcurePaymentPlanListVO.class);
        for (RkProcurePaymentPlanListVO vo : listVO) {
            RkProcureManageEntity procureInfo = this.rkProcureManageService.getInfo(vo.getProcureId());
            if (ObjectUtil.isNotEmpty((Object)procureInfo)) {
                RkContractProjectEntity project;
                RkProcureManageInfoVO procureManageInfoVO = (RkProcureManageInfoVO)JsonUtil.getJsonToBean((Object)procureInfo, RkProcureManageInfoVO.class);
                procureManageInfoVO.setApplyName(this.baseDataUtil.userSelectValue(procureManageInfoVO.getApplyId()));
                if (ObjectUtil.isNotEmpty((Object)procureManageInfoVO.getProcureStatus())) {
                    if (procureManageInfoVO.getProcureStatus().equals("execute")) {
                        vo.setProcureStatus("\u6267\u884c\u4e2d");
                    } else if (procureManageInfoVO.getProcureStatus().equals("cancel")) {
                        vo.setProcureStatus("\u5df2\u4f5c\u5e9f");
                    } else if (procureManageInfoVO.getProcureStatus().equals("canceling")) {
                        vo.setProcureStatus("\u6b63\u5728\u4f5c\u5e9f");
                    } else if (procureManageInfoVO.getProcureStatus().equals("termination")) {
                        vo.setProcureStatus("\u5df2\u7ec8\u6b62");
                    } else if (procureManageInfoVO.getProcureStatus().equals("terminating")) {
                        vo.setProcureStatus("\u6b63\u5728\u7ec8\u6b62");
                    } else if (procureManageInfoVO.getProcureStatus().equals("break")) {
                        vo.setProcureStatus("\u5df2\u4e2d\u6b62");
                    } else if (procureManageInfoVO.getProcureStatus().equals("breaking")) {
                        vo.setProcureStatus("\u6b63\u5728\u4e2d\u6b62");
                    } else if (procureManageInfoVO.getProcureStatus().equals("changing")) {
                        vo.setProcureStatus("\u6b63\u5728\u53d8\u66f4");
                    } else if (procureManageInfoVO.getProcureStatus().equals("change")) {
                        vo.setProcureStatus("\u5df2\u53d8\u66f4");
                    }
                } else {
                    vo.setProcureStatus("\u8349\u7a3f");
                }
                vo.setProcureInfo(procureManageInfoVO);
                vo.setProcureCode(procureManageInfoVO.getProcureCode());
                vo.setProcureName(procureManageInfoVO.getProcureName());
                vo.setSupplierName(procureManageInfoVO.getSupplierName());
                vo.setProcureAmount(procureManageInfoVO.getProcureAmount());
                vo.setApplyDate(com.bringspring.common.util.DateUtil.daFormatYmd((Long)procureManageInfoVO.getApplyDate()));
                vo.setApplyId(this.baseDataUtil.userSelectValue(procureManageInfoVO.getApplyId()));
                if (ObjectUtil.isNotEmpty((Object)procureInfo) && ObjectUtil.isNotEmpty((Object)procureInfo.getProjectId()) && ObjectUtil.isNotEmpty((Object)(project = this.rkContractProjectService.getInfo(procureInfo.getProjectId())))) {
                    vo.setProjectCode(project.getProjectCode());
                }
            }
            vo.setCompanyName(this.baseDataUtil.getDictName(vo.getCompanyId(), "companyName"));
            vo.setPaymentTypeName(this.baseDataUtil.getDictName(vo.getPaymentType(), "paymentType"));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd"));
        if (CollectionUtil.isNotEmpty((Collection)mapList)) {
            mapList.stream().forEach(m -> {
                if (ObjectUtil.isNotNull(m.get("payDate"))) {
                    DateTime expectedSigningDate = DateUtil.date((long)Long.valueOf(m.get("payDate").toString()));
                    String s = DateUtil.formatDate((Date)expectedSigningDate);
                    m.put("payDate", s);
                }
            });
        }
        String[] keys = !StringUtil.isEmpty((String)rkProcurePaymentPlanPaginationExportModel.getSelectKey()) ? rkProcurePaymentPlanPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block38: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "procureName": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u540d\u79f0", (Object)"procureName"));
                        continue block38;
                    }
                    case "procureCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u7f16\u53f7", (Object)"procureCode"));
                        continue block38;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u540d\u79f0", (Object)"supplierName"));
                        continue block38;
                    }
                    case "payDate": {
                        entitys.add(new ExcelExportEntity("\u5e94\u4ed8\u6b3e\u65e5\u671f", (Object)"payDate"));
                        continue block38;
                    }
                    case "paymentAmount": {
                        entitys.add(new ExcelExportEntity("\u5e94\u4ed8\u6b3e\u91d1\u989d(\u5143)", (Object)"paymentAmount"));
                        continue block38;
                    }
                    case "paymentRatio": {
                        entitys.add(new ExcelExportEntity("\u5e94\u4ed8\u6b3e\u6bd4\u4f8b(%)", (Object)"paymentRatio"));
                        continue block38;
                    }
                    case "paymentTypeName": {
                        entitys.add(new ExcelExportEntity("\u6b3e\u9879\u7c7b\u578b", (Object)"paymentTypeName"));
                        continue block38;
                    }
                    case "paidAmount": {
                        entitys.add(new ExcelExportEntity("\u5df2\u4ed8\u6b3e\u91d1\u989d(\u5143)", (Object)"paidAmount"));
                        continue block38;
                    }
                    case "paidRatio": {
                        entitys.add(new ExcelExportEntity("\u5df2\u4ed8\u6b3e\u6bd4\u4f8b(%)", (Object)"paidRatio"));
                        continue block38;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block38;
                    }
                    case "procureAmount": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u91d1\u989d(\u5143)", (Object)"procureAmount"));
                        continue block38;
                    }
                    case "applyId": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5458", (Object)"applyId"));
                        continue block38;
                    }
                    case "applyDate": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u65e5\u671f", (Object)"applyDate"));
                        continue block38;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u91c7\u8d2d\u5408\u540c\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + com.bringspring.common.util.DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

