/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkContractTaxEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.entity.RkProcureTerminationEntity;
import com.bringspring.contract.entity.RkpurchaseapplydetaillistEntity;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.model.rkcontracttax.RkContractTaxInfoVO;
import com.bringspring.contract.model.rkprocuretermination.RkProcureTerminationCrForm;
import com.bringspring.contract.model.rkprocuretermination.RkProcureTerminationInfoVO;
import com.bringspring.contract.model.rkprocuretermination.RkProcureTerminationListVO;
import com.bringspring.contract.model.rkprocuretermination.RkProcureTerminationPagination;
import com.bringspring.contract.model.rkprocuretermination.RkProcureTerminationUpForm;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractTaxService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.service.RkProcureTerminationService;
import com.bringspring.contract.service.RkpurchaseapplydetaillistService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u91c7\u8d2d\u5408\u540c\u7ec8\u6b62"}, value="contract")
@RequestMapping(value={"/api/contract/RkProcureTermination"})
public class RkProcureTerminationController {
    private static final Logger log = LoggerFactory.getLogger(RkProcureTerminationController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProcureTerminationService rkProcureTerminationService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkContractPaymentService rkContractPaymentService;
    @Autowired
    private RkContractTaxService rkContractTaxService;
    @Autowired
    private RkProcureManageService rkProcureManageService;
    @Autowired
    private RkpurchaseapplydetaillistService rkpurchaseapplydetaillistService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProcureTerminationPagination rkProcureTerminationPagination) throws IOException {
        List<RkProcureTerminationEntity> list = this.rkProcureTerminationService.getList(rkProcureTerminationPagination);
        List listVO = JsonUtil.getJsonToList(list, RkProcureTerminationListVO.class);
        for (RkProcureTerminationListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProcureTerminationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkProcureTerminationCrForm rkProcureTerminationCrForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "501643745805160261";
            UserInfo userInfo = this.userProvider.get();
            String mainId = RandomUtil.uuId();
            RkProcureTerminationEntity entity = (RkProcureTerminationEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcureTerminationCrForm), RkProcureTerminationEntity.class);
            entity.setId(mainId);
            if (entity != null) {
                if (!ObjectUtil.isEmpty((Object)entity.getAccumulatePaymentAmount()) && entity.getAccumulatePaymentAmount().compareTo(BigDecimal.ZERO) == 1) {
                    return ActionResult.fail((String)"\u8be5\u5408\u540c\u5df2\u7ecf\u5173\u8054\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u7ec8\u6b62");
                }
                if (!ObjectUtil.isEmpty((Object)entity.getNotPaymentAmount()) && entity.getNotPaymentAmount().compareTo(BigDecimal.ZERO) == 1) {
                    return ActionResult.fail((String)"\u8be5\u5408\u540c\u5df2\u7ecf\u5173\u8054\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u7ec8\u6b62");
                }
            }
            entity.setProcureType("1");
            entity.setProcureId(rkProcureTerminationCrForm.getProcureId());
            RkContractProjectListVO projectInfo = rkProcureTerminationCrForm.getProjectList();
            entity.setProjectId(projectInfo.getId());
            entity.setCreatorTime(new Date());
            entity.setCreatorUserId(userInfo.getUserId());
            RkContractProcureEntity info = this.rkContractProcureService.getInfo(rkProcureTerminationCrForm.getProcureId());
            info.setProcureStatus("terminating");
            this.rkContractProcureService.updateById(info);
            RkProcureManageEntity procureInfo = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)entity.getProcureId()));
            procureInfo.setProcureStatus("terminating");
            this.rkProcureManageService.updateById(procureInfo);
            if (!ObjectUtil.isEmpty((Object)entity.getStampType())) {
                entity.setStampTypeName(this.baseDataUtil.getDictName(entity.getStampType(), Constants.STAMP_TYPE_DICT_ID));
            }
            this.rkProcureTerminationService.save(entity);
            rkProcureTerminationCrForm.setStampTypeName(entity.getStampTypeName());
            FlowUtil.saveOrSubmit((String)rkProcureTerminationCrForm.getTaskId(), (String)flowEngineId, (String)rkProcureTerminationCrForm.getTemplateId(), (String)mainId, (Object)((Object)rkProcureTerminationCrForm), (Integer)rkProcureTerminationCrForm.getStatus(), (String)procureInfo.getProcureName());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProcureTerminationInfoVO> info(@PathVariable(value="id") String id) {
        RkProcureTerminationEntity entity = this.rkProcureTerminationService.getInfo(id);
        RkProcureTerminationInfoVO vo = (RkProcureTerminationInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProcureTerminationInfoVO.class);
        vo.setProcureId(entity.getProcureId());
        List<RkContractTaxEntity> taxEntities = this.rkContractTaxService.listByContractId(id);
        if (CollectionUtil.isNotEmpty(taxEntities)) {
            List taxInfoList = JsonUtil.getJsonToList(taxEntities, RkContractTaxInfoVO.class);
            vo.setTaxList(taxInfoList);
        } else {
            vo.setTaxList(new ArrayList<RkContractTaxInfoVO>());
        }
        List<RkContractPaymentEntity> listByContractId = this.rkContractPaymentService.getListByContractId(entity.getProcureId());
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
        vo.setPaymentMethodList(jsonToList);
        List<RkpurchaseapplydetaillistEntity> listByPurchaseApply = this.rkpurchaseapplydetaillistService.listByProcureCode(entity.getProcureCode());
        vo.setPurchaseApplyList(listByPurchaseApply);
        if (ObjectUtil.isNotEmpty((Object)entity.getProjectId())) {
            RkContractProjectListVO projectInfo1 = this.rkContractProcureService.getProjectInfo(entity.getProjectId());
            vo.setProjectList(projectInfo1);
        }
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProcureTerminationUpForm rkProcureTerminationUpForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "501643745805160261";
            RkProcureTerminationEntity entity = this.rkProcureTerminationService.getInfo(id);
            if (entity != null) {
                RkProcureTerminationEntity subentity = (RkProcureTerminationEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcureTerminationUpForm), RkProcureTerminationEntity.class);
                RkContractProcureEntity info = this.rkContractProcureService.getInfo(rkProcureTerminationUpForm.getProcureId());
                info.setProcureStatus("terminating");
                this.rkContractProcureService.updateById(info);
                RkProcureManageEntity procureInfo = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)rkProcureTerminationUpForm.getProcureId()));
                procureInfo.setProcureStatus("terminating");
                this.rkProcureManageService.updateById(procureInfo);
                this.rkProcureTerminationService.update(id, subentity);
                FlowUtil.saveOrSubmit((String)rkProcureTerminationUpForm.getTaskId(), (String)flowEngineId, (String)rkProcureTerminationUpForm.getTemplateId(), (String)id, (Object)((Object)rkProcureTerminationUpForm), (Integer)rkProcureTerminationUpForm.getStatus(), (String)procureInfo.getProcureName());
                return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkProcureTerminationEntity entity = this.rkProcureTerminationService.getInfo(id);
            if (entity != null) {
                FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
                if (taskEntity != null) {
                    try {
                        FlowUtil.deleteByProcessId((String)id);
                    }
                    catch (WorkFlowException e) {
                        e.printStackTrace();
                    }
                }
                this.rkProcureTerminationService.delete(entity);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/termination/{id}"})
    @DSTransactional
    public ActionResult procureTermination(@PathVariable(value="id") String id, @RequestBody @Valid RkProcureTerminationUpForm rkProcureTerminationUpForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "501643745805160261";
            UserInfo userInfo = this.userProvider.get();
            RkProcureTerminationEntity entity = this.rkProcureTerminationService.getInfo(id);
            entity.setEnableMark(entity.getEnableMark());
            if (entity != null) {
                if (!ObjectUtil.isEmpty((Object)entity.getAccumulatePaymentAmount()) && entity.getAccumulatePaymentAmount().compareTo(BigDecimal.ZERO) == 1) {
                    return ActionResult.fail((String)"\u8be5\u5408\u540c\u5df2\u7ecf\u5173\u8054\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u7ec8\u6b62");
                }
                if (!ObjectUtil.isEmpty((Object)entity.getNotPaymentAmount()) && entity.getNotPaymentAmount().compareTo(BigDecimal.ZERO) == 1) {
                    return ActionResult.fail((String)"\u8be5\u5408\u540c\u5df2\u7ecf\u5173\u8054\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u7ec8\u6b62");
                }
            }
            RkProcureTerminationEntity subentity = (RkProcureTerminationEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcureTerminationUpForm), RkProcureTerminationEntity.class);
            this.rkProcureTerminationService.update(id, entity);
            if (FlowTaskStatusEnum.Handle.getCode().equals(rkProcureTerminationUpForm.getStatus())) {
                FlowUtil.saveOrSubmit((String)rkProcureTerminationUpForm.getTaskId(), (String)flowEngineId, (String)rkProcureTerminationUpForm.getTemplateId(), (String)id, (Object)subentity, (Integer)rkProcureTerminationUpForm.getStatus());
            }
            return ActionResult.success((String)"\u4f5c\u5e9f\u6210\u529f");
        }
    }
}

