/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkProjectAcceptEntity;
import com.bringspring.contract.model.rkprojectaccept.RkProjectAcceptCrForm;
import com.bringspring.contract.model.rkprojectaccept.RkProjectAcceptInfoVO;
import com.bringspring.contract.model.rkprojectaccept.RkProjectAcceptListVO;
import com.bringspring.contract.model.rkprojectaccept.RkProjectAcceptPagination;
import com.bringspring.contract.model.rkprojectaccept.RkProjectAcceptUpForm;
import com.bringspring.contract.service.RkProjectAcceptService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u9a8c\u6536\u4fe1\u606f"}, value="contract")
@RequestMapping(value={"/api/contract/RkProjectAccept"})
public class RkProjectAcceptController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectAcceptController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectAcceptService rkProjectAcceptService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectAcceptPagination rkProjectAcceptPagination) throws IOException {
        List<RkProjectAcceptEntity> list = this.rkProjectAcceptService.getList(rkProjectAcceptPagination);
        for (RkProjectAcceptEntity rkProjectAcceptEntity : list) {
            rkProjectAcceptEntity.setAcceptedBy(this.baseDataUtil.userSelectValues(rkProjectAcceptEntity.getAcceptedBy()));
        }
        List listVO = JsonUtil.getJsonToList(list, RkProjectAcceptListVO.class);
        for (RkProjectAcceptListVO rkProjectAcceptListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectAcceptPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid RkProjectAcceptCrForm rkProjectAcceptCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkProjectAcceptEntity entity = (RkProjectAcceptEntity)JsonUtil.getJsonToBean((Object)rkProjectAcceptCrForm, RkProjectAcceptEntity.class);
        entity.setId(mainId);
        this.rkProjectAcceptService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectAcceptInfoVO> info(@PathVariable(value="id") String id) {
        RkProjectAcceptEntity entity = this.rkProjectAcceptService.getInfo(id);
        RkProjectAcceptInfoVO vo = (RkProjectAcceptInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectAcceptInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkProjectAcceptInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkProjectAcceptEntity entity = this.rkProjectAcceptService.getInfo(id);
        RkProjectAcceptInfoVO vo = (RkProjectAcceptInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectAcceptInfoVO.class);
        vo.setAcceptedBy(this.baseDataUtil.userSelectValues(vo.getAcceptedBy()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectAcceptUpForm rkProjectAcceptUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkProjectAcceptEntity entity = this.rkProjectAcceptService.getInfo(id);
        if (entity != null) {
            RkProjectAcceptEntity subentity = (RkProjectAcceptEntity)JsonUtil.getJsonToBean((Object)rkProjectAcceptUpForm, RkProjectAcceptEntity.class);
            this.rkProjectAcceptService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProjectAcceptEntity entity = this.rkProjectAcceptService.getInfo(id);
        if (entity != null) {
            this.rkProjectAcceptService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

