/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectAuthorizationBussEntity;
import com.bringspring.contract.model.rkProjectAuthorization.RkProjectAuthorizationBussCrForm;
import com.bringspring.contract.model.rkProjectAuthorization.RkProjectAuthorizationBussListVO;
import com.bringspring.contract.model.rkProjectAuthorization.RkProjectAuthorizationBussPagination;
import com.bringspring.contract.model.rkProjectAuthorization.RkProjectAuthorizationBussPaginationExportModel;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectAuthorizationBussService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.MessageUtils;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u6388\u6743\u4fe1\u606f"}, value="crm")
@RequestMapping(value={"/api/contract/RkProjectAuthorizationBuss"})
public class RkProjectAuthorizationBussController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectAuthorizationBussController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectAuthorizationBussService rkProjectAuthorizationBussService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkAttachmentService rkAttachmentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectAuthorizationBussPagination rkProjectAuthorizationBussPagination) throws IOException {
        List<RkProjectAuthorizationBussEntity> list = this.rkProjectAuthorizationBussService.getList(rkProjectAuthorizationBussPagination);
        List<RkProjectAuthorizationBussListVO> listVO = JsonUtil.getJsonToList(list, RkProjectAuthorizationBussListVO.class);
        listVO = this.rkProjectAuthorizationBussService.setAllNameById(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectAuthorizationBussPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListByProjectId/{projectId}"})
    public ActionResult getAuthorizationListByProjectId(@PathVariable(value="projectId") String projectId) throws IOException {
        List<RkProjectAuthorizationBussListVO> listVO = this.rkProjectAuthorizationBussService.getListByProjectId(projectId);
        List allCompanyList = this.organizeService.getAllCompanyList("");
        block0: for (RkProjectAuthorizationBussListVO task : listVO) {
            for (OrganizeEntity company : allCompanyList) {
                if (!StringUtils.isNotEmpty((String)task.getCompanyId()) || !company.getId().equals(task.getCompanyId())) continue;
                task.setCompanyName(company.getFullName());
                continue block0;
            }
        }
        return ActionResult.success(listVO);
    }

    @PostMapping(value={"countByAuthorizationResult"})
    public ActionResult countByAuthorizationResult(@RequestBody RkProjectAuthorizationBussPagination rkProjectAuthorizationBussPagination) {
        List<Map<String, Object>> maps = this.rkProjectAuthorizationBussService.countByAuthorizationResult(rkProjectAuthorizationBussPagination);
        return ActionResult.success(maps);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkProjectAuthorizationBussCrForm rkProjectAuthorizationBussCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "581480104639611141";
        String mainId = RandomUtil.uuId();
        rkProjectAuthorizationBussCrForm.setCreatorTime(DateUtil.getNow());
        RkProjectAuthorizationBussEntity entity = (RkProjectAuthorizationBussEntity)JsonUtil.getJsonToBean((Object)((Object)rkProjectAuthorizationBussCrForm), RkProjectAuthorizationBussEntity.class);
        entity = this.rkProjectAuthorizationBussService.getRkProjectAuthorizationBussEntityInfo(entity);
        entity.setId(mainId);
        this.rkProjectAuthorizationBussService.save(entity);
        if (StrUtil.isNotBlank((CharSequence)rkProjectAuthorizationBussCrForm.getFlowId())) {
            flowEngineId = rkProjectAuthorizationBussCrForm.getFlowId();
        }
        FlowUtil.saveOrSubmit((String)rkProjectAuthorizationBussCrForm.getTaskId(), (String)flowEngineId, (String)rkProjectAuthorizationBussCrForm.getTemplateId(), (String)mainId, (Object)((Object)rkProjectAuthorizationBussCrForm), (Integer)rkProjectAuthorizationBussCrForm.getStatus(), (String)rkProjectAuthorizationBussCrForm.getProjectName());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectAuthorizationBussCrForm rkProjectAuthorizationBussCrForm) throws DataException, WorkFlowException {
        RkProjectAuthorizationBussEntity entity = this.rkProjectAuthorizationBussService.getInfo(id);
        if (entity != null) {
            RkProjectAuthorizationBussEntity subentity = (RkProjectAuthorizationBussEntity)JsonUtil.getJsonToBean((Object)((Object)rkProjectAuthorizationBussCrForm), RkProjectAuthorizationBussEntity.class);
            subentity.setLastModifyTime(entity.getCreatorTime());
            subentity.setLastModifyUserId(entity.getCreatorUserId());
            this.rkProjectAuthorizationBussService.update(id, subentity);
            String flowEngineId = "581480104639611141";
            if (StrUtil.isNotBlank((CharSequence)rkProjectAuthorizationBussCrForm.getFlowId())) {
                flowEngineId = rkProjectAuthorizationBussCrForm.getFlowId();
            }
            FlowUtil.saveOrSubmit((String)rkProjectAuthorizationBussCrForm.getTaskId(), (String)flowEngineId, (String)rkProjectAuthorizationBussCrForm.getTemplateId(), (String)entity.getId(), (Object)((Object)rkProjectAuthorizationBussCrForm), (Integer)rkProjectAuthorizationBussCrForm.getStatus(), (String)rkProjectAuthorizationBussCrForm.getProjectName());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"authorization/{id}"})
    @DSTransactional
    public ActionResult updateAuthorization(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectAuthorizationBussCrForm rkProjectAuthorizationBussCrForm) throws DataException {
        RkProjectAuthorizationBussEntity entity = this.rkProjectAuthorizationBussService.getInfo(id);
        if (entity != null) {
            this.rkAttachmentService.deleteByObjId(id);
            List jsonToList = JsonUtil.getJsonToList(rkProjectAuthorizationBussCrForm.getAttachmentList(), RkAttachmentEntity.class);
            for (RkAttachmentEntity rkAttachmentEntity : jsonToList) {
                rkAttachmentEntity.setProjectId(entity.getProjectId());
                rkAttachmentEntity.setObjId(id);
                rkAttachmentEntity.setFileType(AttachmentTypeEnum.PROJECT_AUTHORIZATION_TYPE.getType());
            }
            this.rkAttachmentService.saveBatch(jsonToList);
            RkProjectAuthorizationBussEntity subentity = (RkProjectAuthorizationBussEntity)JsonUtil.getJsonToBean((Object)((Object)rkProjectAuthorizationBussCrForm), RkProjectAuthorizationBussEntity.class);
            subentity.setAuthorizedResult(1);
            UserInfo userInfo = this.userProvider.get();
            subentity.setLastModifyTime(new Date());
            subentity.setLastModifyUserId(userInfo.getUserId());
            subentity.setAuthorizedUser(userInfo.getUserId());
            subentity.setAuthorizedTime(new Date());
            this.rkProjectAuthorizationBussService.update(id, subentity);
            RkContractProjectEntity project = new RkContractProjectEntity();
            project.setActualStartDate(rkProjectAuthorizationBussCrForm.getActualStartDate());
            project.setActualEndDate(rkProjectAuthorizationBussCrForm.getActualEndDate());
            project.setActualDays(rkProjectAuthorizationBussCrForm.getActualDays());
            project.setId(entity.getProjectId());
            project.setAuthorizedUser(userInfo.getUserId());
            project.setAuthorizedTime(new Date());
            this.rkContractProjectService.update(entity.getProjectId(), project);
            this.rkProjectAuthorizationBussService.setAuthorizationRemainingDays();
            String messageTime = DateUtil.dateFormat((Date)new Date());
            try {
                String userId = subentity.getCreatorUserId();
                String taskCode = MessageTypeEnum.PROJECT_AUTHORIZATION_TEMPLATE.getMessage();
                String sendCode = MessageTypeEnum.PROJECT_AUTHORIZATION_TEMPLATE.getTemplateCode();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                HashMap keys = MapUtil.newHashMap();
                keys.put("title", subentity.getProjectName() + "\u9879\u76ee\u6388\u6743\u901a\u8fc7");
                keys.put("content", "\u9879\u76ee\u540d\u79f0\uff1a" + subentity.getProjectName() + "\n\u6388\u6743\u5f00\u59cb\u65f6\u95f4\uff1a" + sdf.format(subentity.getActualStartDate()) + "\n\u6388\u6743\u7ed3\u675f\u65f6\u95f4\uff1a" + sdf.format(subentity.getActualEndDate()) + "\n\u6388\u6743\u5929\u6570\uff1a" + subentity.getActualDays() + "\n\u521b\u5efa\u65f6\u95f4\uff1a" + messageTime);
                String pcUrl = "/#/contract/project/authorizationBuss";
                String termType = TermTypeEnum.TERM_PC.getCode();
                String termTypeDesc = "\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4";
                this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, null, pcUrl, userId, termType, termTypeDesc);
            }
            catch (Exception e) {
                log.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Object)e.getMessage());
                e.printStackTrace();
            }
            return ActionResult.success((String)"\u6388\u6743\u6210\u529f");
        }
        return ActionResult.fail((String)"\u6388\u6743\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkProjectAuthorizationBussPaginationExportModel rkProjectAuthorizationBussPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkProjectAuthorizationBussPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkProjectAuthorizationBussPagination RkProjectAuthorizationBussPagination2 = (RkProjectAuthorizationBussPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkProjectAuthorizationBussPaginationExportModel), RkProjectAuthorizationBussPagination.class));
        List<RkProjectAuthorizationBussEntity> list = this.rkProjectAuthorizationBussService.getTypeList(RkProjectAuthorizationBussPagination2, rkProjectAuthorizationBussPaginationExportModel.getDataType());
        List<RkProjectAuthorizationBussListVO> listVO = JsonUtil.getJsonToList(list, RkProjectAuthorizationBussListVO.class);
        listVO = this.rkProjectAuthorizationBussService.setAllNameById(listVO);
        for (RkProjectAuthorizationBussListVO vo : listVO) {
            vo.setAuthorizedStateName(this.baseDataUtil.getDictName(vo.getAuthorizedState(), "projectAuthorization"));
            vo.setAuthorizedResultName(vo.getAuthorizedResult().equals("1") ? "\u5df2\u6388\u6743" : "\u672a\u6388\u6743");
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkProjectAuthorizationBussPaginationExportModel.getSelectKey()) ? rkProjectAuthorizationBussPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block52: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u5ba2\u6237", (Object)"customerName"));
                        continue block52;
                    }
                    case "agentId": {
                        entitys.add(new ExcelExportEntity("\u7b7e\u8ba2\u5bf9\u8c61", (Object)"agentName"));
                        continue block52;
                    }
                    case "projectId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block52;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u7801", (Object)"projectCode"));
                        continue block52;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block52;
                    }
                    case "authorizedTypeName": {
                        entitys.add(new ExcelExportEntity("\u6388\u6743\u7c7b\u578b", (Object)"authorizedTypeName"));
                        continue block52;
                    }
                    case "startDate": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u5f00\u59cb\u65e5\u671f", (Object)"startDate"));
                        continue block52;
                    }
                    case "endDate": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u7ed3\u675f\u65e5\u671f", (Object)"endDate"));
                        continue block52;
                    }
                    case "authorizedDays": {
                        entitys.add(new ExcelExportEntity("\u6388\u6743\u5929\u6570", (Object)"authorizedDays"));
                        continue block52;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"creatorUserId"));
                        continue block52;
                    }
                    case "remainingDays": {
                        entitys.add(new ExcelExportEntity("\u6388\u6743\u5269\u4f59\u5929\u6570", (Object)"remainingDays"));
                        continue block52;
                    }
                    case "deptId": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"deptId"));
                        continue block52;
                    }
                    case "productId": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1", (Object)"productName"));
                        continue block52;
                    }
                    case "productCategoryName": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5927\u7c7b", (Object)"productCategoryName"));
                        continue block52;
                    }
                    case "authorizedResult": {
                        entitys.add(new ExcelExportEntity("\u6388\u6743\u72b6\u6001", (Object)"authorizedResultName"));
                        continue block52;
                    }
                    case "authorizedState": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u5269\u4f59\u7b49\u7ea7", (Object)"authorizedStateName"));
                        continue block52;
                    }
                    case "authorizedFile": {
                        entitys.add(new ExcelExportEntity("\u6388\u6743\u6587\u4ef6", (Object)"authorizedFile"));
                        continue block52;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block52;
                    }
                    case "actualStartDate": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4", (Object)"actualStartDate"));
                        continue block52;
                    }
                    case "actualEndDate": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u7ed3\u675f\u65e5\u671f", (Object)"actualEndDate"));
                        continue block52;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u9879\u76ee\u6388\u6743\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectAuthorizationBussListVO> info(@PathVariable(value="id") String id) {
        RkProjectAuthorizationBussListVO vo = this.rkProjectAuthorizationBussService.getRkProjectAuthorizationBussListVOInfoById(id);
        if (StrUtil.isNotEmpty((CharSequence)vo.getCompanyId())) {
            vo.setCompanyName(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"projectInfo/{projectId}"})
    public ActionResult<RkProjectAuthorizationBussListVO> infoProject(@PathVariable(value="projectId") String projectId) {
        RkProjectAuthorizationBussListVO vo = this.rkProjectAuthorizationBussService.getRkProjectAuthorizationBussListVOInfoByProjectId(projectId);
        if (StrUtil.isNotEmpty((CharSequence)vo.getCompanyId())) {
            vo.setCompanyName(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
        }
        return ActionResult.success((Object)vo);
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProjectAuthorizationBussEntity entity = this.rkProjectAuthorizationBussService.getInfo(id);
        this.rkProjectAuthorizationBussService.delete(entity);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"generateAuthorizeCode"})
    public ActionResult generateAuthorizeCode(@RequestBody @Valid RkProjectAuthorizationBussCrForm rkProjectAuthorizationBussCrForm) throws DataException {
        String authorizeCode = this.rkProjectAuthorizationBussService.generateAuthorizeCode(rkProjectAuthorizationBussCrForm);
        return ActionResult.success((String)"\u53d1\u653e\u6210\u529f", (Object)authorizeCode);
    }
}

