/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkProjectPlanChangeEntity;
import com.bringspring.contract.model.rkprojectplanchange.RkProjectPlanChangeCrForm;
import com.bringspring.contract.model.rkprojectplanchange.RkProjectPlanChangeInfoVO;
import com.bringspring.contract.model.rkprojectplanchange.RkProjectPlanChangeUpForm;
import com.bringspring.contract.service.RkProjectPlanChangeService;
import io.swagger.annotations.Api;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u8ba1\u5212\u53d8\u52a8\u8bb0\u5f55"}, value="contract")
@RequestMapping(value={"/api/contract/RkProjectPlanChange"})
public class RkProjectPlanChangeController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectPlanChangeController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectPlanChangeService rkProjectPlanChangeService;

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid RkProjectPlanChangeCrForm rkProjectPlanChangeCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkProjectPlanChangeEntity entity = (RkProjectPlanChangeEntity)JsonUtil.getJsonToBean((Object)rkProjectPlanChangeCrForm, RkProjectPlanChangeEntity.class);
        entity.setId(mainId);
        this.rkProjectPlanChangeService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectPlanChangeInfoVO> info(@PathVariable(value="id") String id) {
        RkProjectPlanChangeEntity entity = this.rkProjectPlanChangeService.getInfo(id);
        RkProjectPlanChangeInfoVO vo = (RkProjectPlanChangeInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectPlanChangeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkProjectPlanChangeInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkProjectPlanChangeEntity entity = this.rkProjectPlanChangeService.getInfo(id);
        RkProjectPlanChangeInfoVO vo = (RkProjectPlanChangeInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectPlanChangeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectPlanChangeUpForm rkProjectPlanChangeUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkProjectPlanChangeEntity entity = this.rkProjectPlanChangeService.getInfo(id);
        if (entity != null) {
            RkProjectPlanChangeEntity subentity = (RkProjectPlanChangeEntity)JsonUtil.getJsonToBean((Object)rkProjectPlanChangeUpForm, RkProjectPlanChangeEntity.class);
            this.rkProjectPlanChangeService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProjectPlanChangeEntity entity = this.rkProjectPlanChangeService.getInfo(id);
        if (entity != null) {
            this.rkProjectPlanChangeService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

