/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectPlanDetailEntity;
import com.bringspring.contract.entity.RkProjectPlanEntity;
import com.bringspring.contract.entity.RkProjectTaskEntity;
import com.bringspring.contract.model.rk_project_plan.RkProjectPlanDetailModel;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkprojectplan.RkProjectPlanCrForm;
import com.bringspring.contract.model.rkprojectplan.RkProjectPlanInfoVO;
import com.bringspring.contract.model.rkprojectplan.RkProjectPlanListVO;
import com.bringspring.contract.model.rkprojectplan.RkProjectPlanPagination;
import com.bringspring.contract.model.rkprojectplan.RkProjectPlanPaginationExportModel;
import com.bringspring.contract.model.rkprojectplan.RkProjectPlanPaginationExportModelAll;
import com.bringspring.contract.model.rkprojectplan.RkProjectPlanUpForm;
import com.bringspring.contract.model.rkprojectplanchange.RkProjectPlanChangeCrForm;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectPlanDetailService;
import com.bringspring.contract.service.RkProjectPlanService;
import com.bringspring.contract.service.RkProjectTaskService;
import com.bringspring.contract.utils.ProjectPlanExecutionResultEnum;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u8ba1\u5212"}, value="contract")
@RequestMapping(value={"/api/contract/RkProjectPlan"})
public class RkProjectPlanController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectPlanController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectPlanService rkProjectPlanService;
    @Autowired
    private RkProjectPlanDetailService rkProjectPlanDetailService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private RkProjectTaskService rkProjectTaskService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectPlanPagination rkProjectPlanPagination) throws IOException {
        List<RkProjectPlanEntity> list = this.rkProjectPlanService.getList(rkProjectPlanPagination);
        for (RkProjectPlanEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkProjectPlanListVO.class);
        for (RkProjectPlanListVO rkProjectPlanListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectPlanPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @RepeatSubmit
    @PostMapping
    @Transactional
    public synchronized ActionResult create(@RequestBody @Valid RkProjectPlanCrForm rkProjectPlanCrForm) throws DataException {
        UserInfo userInfo;
        String mainId = RandomUtil.uuId();
        Boolean isSuccess = this.rkProjectPlanService.createForm(rkProjectPlanCrForm, mainId, userInfo = this.userProvider.get());
        if (isSuccess.booleanValue()) {
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
        return ActionResult.fail((String)"\u5df2\u7ecf\u5236\u5b9a\u8fc7\u8ba1\u5212");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectPlanInfoVO> info(@PathVariable(value="id") String id) {
        RkProjectPlanEntity entity = this.rkProjectPlanService.getInfo(id);
        RkProjectPlanInfoVO vo = (RkProjectPlanInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectPlanInfoVO.class);
        List<RkProjectPlanDetailEntity> RkProjectPlanDetailList = this.rkProjectPlanService.GetRkProjectPlanDetailList(id);
        for (RkProjectPlanDetailEntity rkProjectPlanDetailEntity : RkProjectPlanDetailList) {
        }
        vo.setRkProjectPlanDetailList(JsonUtil.getJsonToList(RkProjectPlanDetailList, RkProjectPlanDetailModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkProjectPlanInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkProjectPlanEntity entity = this.rkProjectPlanService.getInfo(id);
        RkProjectPlanInfoVO vo = (RkProjectPlanInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectPlanInfoVO.class);
        List<RkProjectPlanDetailEntity> rkProjectPlanDetailList = this.rkProjectPlanService.GetRkProjectPlanDetailList(id);
        List rkProjectPlanDetailModelList = JsonUtil.getJsonToList(rkProjectPlanDetailList, RkProjectPlanDetailModel.class);
        for (RkProjectPlanDetailModel rkProjectPlanDetailModel : rkProjectPlanDetailModelList) {
        }
        vo.setRkProjectPlanDetailList(rkProjectPlanDetailModelList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/planTaskDetail/{id}/{type}"})
    public ActionResult planTaskDetailInfo(@PathVariable(value="id") String id, @PathVariable(value="type") String type) {
        List<RkProjectTaskEntity> rkProjectTaskDetailList = this.rkProjectTaskService.listByPlanDetailId(id);
        List<Object> list = new ArrayList();
        if ("cancel".equals(type)) {
            list = rkProjectTaskDetailList;
        } else {
            for (RkProjectTaskEntity detail : rkProjectTaskDetailList) {
                if ("complete".equals(detail.getState())) continue;
                list.add(detail);
            }
        }
        return ActionResult.success(list);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectPlanUpForm rkProjectPlanUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkProjectPlanEntity entity = this.rkProjectPlanService.getInfo(id);
        if (entity != null) {
            RkProjectPlanEntity subentity = (RkProjectPlanEntity)JsonUtil.getJsonToBean((Object)rkProjectPlanUpForm, RkProjectPlanEntity.class);
            this.rkProjectPlanService.update(id, subentity);
            QueryWrapper RkProjectPlanDetailqueryWrapper = new QueryWrapper();
            RkProjectPlanDetailqueryWrapper.lambda().eq(RkProjectPlanDetailEntity::getPlanId, (Object)entity.getId());
            this.rkProjectPlanDetailService.remove((Wrapper)RkProjectPlanDetailqueryWrapper);
            List RkProjectPlanDetailList = JsonUtil.getJsonToList(rkProjectPlanUpForm.getRkprojectplandetailList(), RkProjectPlanDetailEntity.class);
            for (RkProjectPlanDetailEntity entitys : RkProjectPlanDetailList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setPlanId(entity.getId());
                this.rkProjectPlanDetailService.save(entitys);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProjectPlanEntity entity = this.rkProjectPlanService.getInfo(id);
        if (entity != null) {
            this.rkProjectPlanService.delete(entity);
            QueryWrapper queryWrapperRkProjectPlanDetail = new QueryWrapper();
            queryWrapperRkProjectPlanDetail.lambda().eq(RkProjectPlanDetailEntity::getPlanId, (Object)entity.getId());
            this.rkProjectPlanDetailService.remove((Wrapper)queryWrapperRkProjectPlanDetail);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"planDetail/{id}"})
    @Transactional
    public ActionResult planDetail(@PathVariable(value="id") String id) {
        RkProjectPlanDetailEntity entity = this.rkProjectPlanDetailService.getInfo(id);
        if (entity != null) {
            if (entity.getIsMilestone() == 1) {
                return ActionResult.fail((String)"\u8be5\u9879\u76ee\u8ba1\u5212\u662f\u91cc\u7a0b\u7891,\u4e0d\u80fd\u5220\u9664");
            }
            if (CollectionUtil.isNotEmpty(this.rkProjectTaskService.listByPlanDetailId(id))) {
                return ActionResult.fail((String)"\u9879\u76ee\u8ba1\u5212\u4e0b\u5b58\u5728\u4efb\u52a1,\u4e0d\u80fd\u5220\u9664");
            }
            this.rkProjectPlanDetailService.delete(entity);
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
        return ActionResult.fail((String)"\u9879\u76ee\u8ba1\u5212\u4e0d\u5b58\u5728!");
    }

    @GetMapping(value={"planByProjectId/{projectId}"})
    public ActionResult planByProjectId(@PathVariable(value="projectId") String projectId) {
        RkProjectPlanEntity infoByProjectId = this.rkProjectPlanService.getInfoByProjectId(projectId);
        if (ObjectUtil.isNull((Object)infoByProjectId)) {
            return ActionResult.success();
        }
        RkProjectPlanInfoVO infoVO = (RkProjectPlanInfoVO)JsonUtil.getJsonToBean((Object)infoByProjectId, RkProjectPlanInfoVO.class);
        List<RkProjectPlanDetailEntity> rkProjectPlanDetailEntities = this.rkProjectPlanDetailService.listByPlanId(infoByProjectId.getId());
        List rkProjectPlanDetailModelList = JsonUtil.getJsonToList(rkProjectPlanDetailEntities, RkProjectPlanDetailModel.class);
        this.getPlanDetailList(rkProjectPlanDetailModelList, projectId);
        infoVO.setRkProjectPlanDetailList(rkProjectPlanDetailModelList);
        return ActionResult.success((Object)infoVO);
    }

    public List<RkProjectPlanDetailModel> getPlanDetailList(List<RkProjectPlanDetailModel> rkProjectPlanDetailModelList, String projectId) {
        RkProjectPlanEntity infoByProjectId = this.rkProjectPlanService.getInfoByProjectId(projectId);
        if (ObjectUtil.isNull((Object)infoByProjectId)) {
            return rkProjectPlanDetailModelList;
        }
        for (RkProjectPlanDetailModel model : rkProjectPlanDetailModelList) {
            List<RkProjectPlanDetailEntity> subPlan;
            List subPlanModel;
            RkContractProjectEntity info = this.rkContractProjectService.getInfo(projectId);
            model.setProjectHeader(info.getProjectHeader());
            model.setCompanyId(info.getCompanyId());
            model.setRegionalHead(info.getRegionalHead());
            model.setProjectId(projectId);
            model.setPlanId(infoByProjectId.getId());
            List<RkProjectTaskEntity> rkProjectTaskEntities = this.rkProjectTaskService.listByPlanDetailId(model.getId());
            if (CollectionUtil.isNotEmpty(rkProjectTaskEntities)) {
                model.setTaskList(this.rkProjectTaskService.getTaskDetail(rkProjectTaskEntities));
            }
            if (CollectionUtil.isNotEmpty((Collection)(subPlanModel = JsonUtil.getJsonToList(subPlan = this.rkProjectPlanDetailService.getSubPlan(model.getId()), RkProjectPlanDetailModel.class)))) {
                model.setSubPlanChildren(subPlanModel);
                this.getPlanDetailList(subPlanModel, projectId);
            }
            if (!StrUtil.isBlank((CharSequence)model.getExecutionResult())) continue;
            Long startTime = null;
            Long endTime = null;
            startTime = ObjectUtil.isNotNull((Object)model.getChangeStartTime()) ? model.getChangeStartTime() : model.getPlanStartTime();
            endTime = ObjectUtil.isNotNull((Object)model.getChangeEndTime()) ? model.getChangeEndTime() : model.getPlanEndTime();
            if (ObjectUtil.isNotNull((Object)startTime) && startTime > DateUtil.date().getTime()) {
                model.setExecutionResult(ProjectPlanExecutionResultEnum.not_start.getResult());
                continue;
            }
            if (ObjectUtil.isNotNull((Object)endTime) && endTime < DateUtil.date().getTime()) {
                model.setExecutionResult(ProjectPlanExecutionResultEnum.overdue.getResult());
                continue;
            }
            if (!ObjectUtil.isNotNull((Object)startTime)) continue;
            model.setExecutionResult(ProjectPlanExecutionResultEnum.ing.getResult());
        }
        return rkProjectPlanDetailModelList;
    }

    @PutMapping(value={"changePlan"})
    public ActionResult changePlanDetail(@RequestBody RkProjectPlanChangeCrForm changeCrForm) {
        if (StrUtil.isBlank((CharSequence)changeCrForm.getPlanDetailId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u8981\u53d8\u52a8\u7684\u8ba1\u5212\u9879");
        }
        RkProjectPlanDetailEntity byId = (RkProjectPlanDetailEntity)this.rkProjectPlanDetailService.getById((Serializable)((Object)changeCrForm.getPlanDetailId()));
        if (ObjectUtil.isNull((Object)byId)) {
            return ActionResult.fail((String)"\u8ba1\u5212\u9879\u4e0d\u5b58\u5728");
        }
        this.rkProjectPlanDetailService.planChange(changeCrForm);
        return ActionResult.success((String)"\u4fee\u6539\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping(value={"uploadFile/{detailId}"})
    @DSTransactional
    public ActionResult createBatch(@PathVariable(value="detailId") String detailId, @RequestBody @Valid List<RkAttachmentCrForm> list) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            if (StrUtil.isNotBlank((CharSequence)detailId)) {
                this.rkAttachmentService.deleteByObjId(detailId);
            }
            RkProjectPlanDetailEntity byId = (RkProjectPlanDetailEntity)this.rkProjectPlanDetailService.getById((Serializable)((Object)detailId));
            if (CollectionUtil.isNotEmpty(list)) {
                List entityList = JsonUtil.getJsonToList(list, RkAttachmentEntity.class);
                entityList.stream().forEach(entity -> entity.setId(RandomUtil.uuId()));
                this.rkAttachmentService.saveBatch(entityList);
                byId.setIsUploadDeliverables(1);
                this.rkProjectPlanDetailService.updateById(byId);
            } else {
                byId.setIsUploadDeliverables(0);
                this.rkProjectPlanDetailService.updateById(byId);
            }
            return ActionResult.success((String)"\u4e0a\u4f20\u6210\u529f");
        }
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkProjectPlanPaginationExportModel rkProjectPlanPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkProjectPlanPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkProjectPlanEntity infoByProjectId = this.rkProjectPlanService.getInfoByProjectId(rkProjectPlanPaginationExportModel.getProjectId());
        if (ObjectUtil.isNull((Object)infoByProjectId)) {
            return ActionResult.fail((String)"\u9879\u76ee\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        RkProjectPlanInfoVO infoVO = (RkProjectPlanInfoVO)JsonUtil.getJsonToBean((Object)infoByProjectId, RkProjectPlanInfoVO.class);
        List<RkProjectPlanDetailEntity> rkProjectPlanDetailEntities = this.rkProjectPlanDetailService.listByPlanId(infoByProjectId.getId());
        List rkProjectPlanDetailModelList = JsonUtil.getJsonToList(rkProjectPlanDetailEntities, RkProjectPlanDetailModel.class);
        for (RkProjectPlanDetailModel model : rkProjectPlanDetailModelList) {
            model.setProjectId(rkProjectPlanPaginationExportModel.getProjectId());
            model.setPlanId(infoByProjectId.getId());
            Iterator rkProjectTaskEntities = this.rkProjectTaskService.listByPlanDetailId(model.getId());
            if (CollectionUtil.isNotEmpty((Collection)((Object)rkProjectTaskEntities))) {
                model.setTaskList(this.rkProjectTaskService.getTaskDetail((List<RkProjectTaskEntity>)((Object)rkProjectTaskEntities)));
            }
            if (!StrUtil.isBlank((CharSequence)model.getExecutionResult())) continue;
            Long startTime = null;
            Long endTime = null;
            startTime = ObjectUtil.isNotNull((Object)model.getChangeStartTime()) ? model.getChangeStartTime() : model.getPlanStartTime();
            endTime = ObjectUtil.isNotNull((Object)model.getChangeEndTime()) ? model.getChangeEndTime() : model.getPlanEndTime();
            if (ObjectUtil.isNotNull((Object)startTime) && startTime > DateUtil.date().getTime()) {
                model.setExecutionResult(ProjectPlanExecutionResultEnum.not_start.getResult());
                continue;
            }
            if (ObjectUtil.isNotNull((Object)endTime) && endTime < DateUtil.date().getTime()) {
                model.setExecutionResult(ProjectPlanExecutionResultEnum.overdue.getResult());
                continue;
            }
            if (!ObjectUtil.isNotNull((Object)startTime)) continue;
            model.setExecutionResult(ProjectPlanExecutionResultEnum.ing.getResult());
        }
        infoVO.setRkProjectPlanDetailList(rkProjectPlanDetailModelList);
        List rkProjectPlanAll = JsonUtil.getJsonToList(infoVO.getRkProjectPlanDetailList(), RkProjectPlanPaginationExportModelAll.class);
        ArrayList rkProjectPlanTaskAll = new ArrayList();
        for (RkProjectPlanPaginationExportModelAll model : rkProjectPlanAll) {
            List rkProjectPlanTaskList = JsonUtil.getJsonToList(model.getTaskList(), RkProjectPlanPaginationExportModelAll.class);
            if (!CollectionUtil.isNotEmpty((Collection)rkProjectPlanTaskList)) continue;
            rkProjectPlanTaskAll.addAll(rkProjectPlanTaskList);
        }
        rkProjectPlanAll.addAll(rkProjectPlanTaskAll);
        for (RkProjectPlanPaginationExportModelAll all : rkProjectPlanAll) {
            String end;
            String start;
            if (StringUtils.isNotEmpty((String)all.getIsMilestone())) {
                if (all.getIsMilestone().equals("1")) {
                    all.setIsMilestone("\u662f");
                } else {
                    all.setIsMilestone("\u5426");
                }
            }
            if (StringUtils.isNotEmpty((String)all.getDescription())) {
                all.setContent(all.getDescription());
            }
            if (ObjectUtil.isNotEmpty((Object)all.getIsRequired())) {
                if (all.getIsRequired() == 1) {
                    all.setIsRequiredName("\u662f");
                } else {
                    all.setIsRequiredName("\u5426");
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (ObjectUtil.isNotEmpty((Object)all.getPlanStartTime()) && ObjectUtil.isNotEmpty((Object)all.getPlanEndTime())) {
                start = sdf.format(new Date(all.getPlanStartTime()));
                end = sdf.format(new Date(all.getPlanEndTime()));
                all.setPlanStartEndTime(start + "--" + end);
            }
            if (ObjectUtil.isNotEmpty((Object)all.getActStartTime()) && ObjectUtil.isNotEmpty((Object)all.getActEndTime())) {
                start = sdf.format(new Date(all.getActStartTime()));
                end = sdf.format(new Date(all.getActEndTime()));
                all.setActStartEndTime(start + "--" + end);
            }
            if (!StringUtils.isNotEmpty((String)all.getExecutionResult()) || !StringUtils.isNotEmpty((String)all.getState())) continue;
            switch (all.getExecutionResult()) {
                case "overdue": {
                    all.setExecutionResult("\u903e\u671f");
                    break;
                }
                case "complete": {
                    all.setExecutionResult("\u5df2\u5b8c\u6210");
                    break;
                }
                case "stop": {
                    all.setExecutionResult("\u5df2\u6682\u505c");
                    break;
                }
                case "notStart": {
                    all.setExecutionResult("\u672a\u5f00\u59cb");
                    break;
                }
                case "ing": {
                    all.setExecutionResult("\u8fdb\u884c\u4e2d");
                    break;
                }
                case "cancel": {
                    all.setExecutionResult("\u53d6\u6d88");
                    break;
                }
            }
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)rkProjectPlanAll, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkProjectPlanPaginationExportModel.getSelectKey()) ? rkProjectPlanPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block34: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "isMilestone": {
                        entitys.add(new ExcelExportEntity("\u91cc\u7a0b\u7891", (Object)"isMilestone"));
                        continue block34;
                    }
                    case "content": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u8ba1\u5212", (Object)"content"));
                        continue block34;
                    }
                    case "planStartTime": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u65e5\u671f", (Object)"planStartEndTime"));
                        continue block34;
                    }
                    case "actStartEndTime": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u65f6\u95f4", (Object)"actStartEndTime"));
                        continue block34;
                    }
                    case "executionResult": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001 ", (Object)"executionResult"));
                        continue block34;
                    }
                    case "ratio": {
                        entitys.add(new ExcelExportEntity("\u5360\u6bd4", (Object)"ratio"));
                        continue block34;
                    }
                    case "executorUser": {
                        entitys.add(new ExcelExportEntity("\u6267\u884c\u4eba", (Object)"executorUser"));
                        continue block34;
                    }
                    case "assistantsUser": {
                        entitys.add(new ExcelExportEntity("\u534f\u52a9\u4eba", (Object)"assistantsUser"));
                        continue block34;
                    }
                    case "plannedDeliverables": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u4ea4\u4ed8\u7269", (Object)"plannedDeliverables"));
                        continue block34;
                    }
                    case "isRequired": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u5fc5\u987b", (Object)"isRequiredName"));
                        continue block34;
                    }
                    case "executionDesc": {
                        entitys.add(new ExcelExportEntity("\u6267\u884c\u60c5\u51b5\u8bf4\u660e", (Object)"executionDesc"));
                        continue block34;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + com.bringspring.common.util.DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

