/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkProjectPlanEntity;
import com.bringspring.contract.entity.RkProjectPlanTemplateDetailEntity;
import com.bringspring.contract.entity.RkProjectPlanTemplateEntity;
import com.bringspring.contract.model.rk_project_plan_template.RkProjectPlanTemplateDetailModel;
import com.bringspring.contract.model.rkprojectplantemplate.RkProjectPlanTemplateCrForm;
import com.bringspring.contract.model.rkprojectplantemplate.RkProjectPlanTemplateInfoVO;
import com.bringspring.contract.model.rkprojectplantemplate.RkProjectPlanTemplateListVO;
import com.bringspring.contract.model.rkprojectplantemplate.RkProjectPlanTemplatePagination;
import com.bringspring.contract.model.rkprojectplantemplate.RkProjectPlanTemplateUpForm;
import com.bringspring.contract.service.RkProjectPlanService;
import com.bringspring.contract.service.RkProjectPlanTemplateDetailService;
import com.bringspring.contract.service.RkProjectPlanTemplateService;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u8ba1\u5212\u6a21\u677f"}, value="contract")
@RequestMapping(value={"/api/contract/RkProjectPlanTemplate"})
public class RkProjectPlanTemplateController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectPlanTemplateController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectPlanTemplateService rkProjectPlanTemplateService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private RkProjectPlanTemplateDetailService rkProjectPlanTemplateDetailService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkProjectPlanService rkProjectPlanService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectPlanTemplatePagination rkProjectPlanTemplatePagination) throws IOException {
        List<RkProjectPlanTemplateEntity> list = this.rkProjectPlanTemplateService.getList(rkProjectPlanTemplatePagination);
        for (RkProjectPlanTemplateEntity rkProjectPlanTemplateEntity : list) {
            rkProjectPlanTemplateEntity.setType(this.baseDataUtil.getDictName(rkProjectPlanTemplateEntity.getType(), "projectPlanTemplateType"));
            rkProjectPlanTemplateEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(rkProjectPlanTemplateEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, RkProjectPlanTemplateListVO.class);
        for (RkProjectPlanTemplateListVO rkProjectPlanTemplateVO : listVO) {
            OrganizeEntity byId = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)rkProjectPlanTemplateVO.getCompanyId()));
            OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId.getPropertyJson(), OrganizeCrModel.class);
            rkProjectPlanTemplateVO.setCompanyName(jsonToBean.getShortName());
            List<RkProjectPlanEntity> planList = this.rkProjectPlanService.getListByTemplateId(rkProjectPlanTemplateVO.getId());
            if (!CollectionUtil.isNotEmpty(planList)) continue;
            rkProjectPlanTemplateVO.setHavePlan(true);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectPlanTemplatePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @RepeatSubmit
    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid RkProjectPlanTemplateCrForm rkProjectPlanTemplateCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        rkProjectPlanTemplateCrForm.setCreatorUserId(userInfo.getUserId());
        rkProjectPlanTemplateCrForm.setCreatorTime(DateUtil.getNow());
        RkProjectPlanTemplateEntity entity = (RkProjectPlanTemplateEntity)JsonUtil.getJsonToBean((Object)rkProjectPlanTemplateCrForm, RkProjectPlanTemplateEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        if (StrUtil.isNotEmpty((CharSequence)rkProjectPlanTemplateCrForm.getProductCategoryId())) {
            List<String> productIdList = Arrays.asList(rkProjectPlanTemplateCrForm.getProductCategoryId().split(","));
            List<CrmProductCategoryEntity> infoByIdList = this.crmProductCategoryService.getInfoByIdList(productIdList);
            String collect = infoByIdList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
            entity.setProductCategoryName(collect);
        }
        this.rkProjectPlanTemplateService.save(entity);
        List RkProjectPlanTemplateDetailList = JsonUtil.getJsonToList(rkProjectPlanTemplateCrForm.getRkprojectplantemplatedetailList(), RkProjectPlanTemplateDetailEntity.class);
        for (RkProjectPlanTemplateDetailEntity entitys : RkProjectPlanTemplateDetailList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setTemplateId(entity.getId());
            entitys.setCompanyId(userInfo.getOrganizeId());
            this.rkProjectPlanTemplateDetailService.save(entitys);
            if (!CollectionUtil.isNotEmpty(entitys.getChildren())) continue;
            List RkProjectPlanTemplateDetailSubPlanIdList = JsonUtil.getJsonToList(entitys.getChildren(), RkProjectPlanTemplateDetailEntity.class);
            for (RkProjectPlanTemplateDetailEntity entitysSub : RkProjectPlanTemplateDetailSubPlanIdList) {
                entitysSub.setId(RandomUtil.uuId());
                entitysSub.setCompanyId(userInfo.getOrganizeId());
                entitysSub.setSubPlanId(entitys.getId());
                this.rkProjectPlanTemplateDetailService.save(entitysSub);
            }
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectPlanTemplateInfoVO> info(@PathVariable(value="id") String id) {
        RkProjectPlanTemplateEntity entity = this.rkProjectPlanTemplateService.getInfo(id);
        RkProjectPlanTemplateInfoVO vo = (RkProjectPlanTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectPlanTemplateInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        List<RkProjectPlanTemplateDetailEntity> RkProjectPlanTemplateDetailList = this.rkProjectPlanTemplateService.GetRkProjectPlanTemplateDetailList(id);
        for (RkProjectPlanTemplateDetailEntity rkprojectplantemplatedetailEntity : RkProjectPlanTemplateDetailList) {
            if (!CollectionUtil.isEmpty(rkprojectplantemplatedetailEntity.getChildren())) continue;
            List<RkProjectPlanTemplateDetailEntity> subPlan = this.rkProjectPlanTemplateDetailService.getSubPlan(rkprojectplantemplatedetailEntity.getId());
            List subPlanModel = JsonUtil.getJsonToList(subPlan, RkProjectPlanTemplateDetailModel.class);
            rkprojectplantemplatedetailEntity.setChildren(subPlanModel);
        }
        vo.setRkProjectPlanTemplateDetailList(JsonUtil.getJsonToList(RkProjectPlanTemplateDetailList, RkProjectPlanTemplateDetailModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkProjectPlanTemplateInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkProjectPlanTemplateEntity entity = this.rkProjectPlanTemplateService.getInfo(id);
        RkProjectPlanTemplateInfoVO vo = (RkProjectPlanTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectPlanTemplateInfoVO.class);
        List<RkProjectPlanTemplateDetailEntity> rkProjectPlanTemplateDetailList = this.rkProjectPlanTemplateService.GetRkProjectPlanTemplateDetailList(id);
        List rkProjectPlanTemplateDetailModelList = JsonUtil.getJsonToList(rkProjectPlanTemplateDetailList, RkProjectPlanTemplateDetailModel.class);
        for (RkProjectPlanTemplateDetailModel rkProjectPlanTemplateDetailModel : rkProjectPlanTemplateDetailModelList) {
            if (!CollectionUtil.isEmpty(rkProjectPlanTemplateDetailModel.getChildren())) continue;
            List<RkProjectPlanTemplateDetailEntity> subPlan = this.rkProjectPlanTemplateDetailService.getSubPlan(rkProjectPlanTemplateDetailModel.getId());
            List subPlanModel = JsonUtil.getJsonToList(subPlan, RkProjectPlanTemplateDetailModel.class);
            rkProjectPlanTemplateDetailModel.setChildren(subPlanModel);
        }
        vo.setRkProjectPlanTemplateDetailList(rkProjectPlanTemplateDetailModelList);
        vo.setType(this.baseDataUtil.getDictName(vo.getType(), "projectPlanTemplateType"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectPlanTemplateUpForm rkProjectPlanTemplateUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkProjectPlanTemplateEntity entity = this.rkProjectPlanTemplateService.getInfo(id);
        if (entity != null) {
            RkProjectPlanTemplateEntity subentity = (RkProjectPlanTemplateEntity)JsonUtil.getJsonToBean((Object)rkProjectPlanTemplateUpForm, RkProjectPlanTemplateEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            if (StrUtil.isNotEmpty((CharSequence)rkProjectPlanTemplateUpForm.getProductCategoryId())) {
                List<String> productIdList = Arrays.asList(rkProjectPlanTemplateUpForm.getProductCategoryId().split(","));
                List<CrmProductCategoryEntity> infoByIdList = this.crmProductCategoryService.getInfoByIdList(productIdList);
                String collect = infoByIdList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(","));
                subentity.setProductCategoryName(collect);
            }
            this.rkProjectPlanTemplateService.update(id, subentity);
            QueryWrapper RkProjectPlanTemplateDetailqueryWrapper = new QueryWrapper();
            RkProjectPlanTemplateDetailqueryWrapper.lambda().eq(RkProjectPlanTemplateDetailEntity::getTemplateId, (Object)entity.getId());
            this.rkProjectPlanTemplateDetailService.remove((Wrapper)RkProjectPlanTemplateDetailqueryWrapper);
            List RkProjectPlanTemplateDetailList = JsonUtil.getJsonToList(rkProjectPlanTemplateUpForm.getRkprojectplantemplatedetailList(), RkProjectPlanTemplateDetailEntity.class);
            for (RkProjectPlanTemplateDetailEntity entitys : RkProjectPlanTemplateDetailList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setTemplateId(entity.getId());
                this.rkProjectPlanTemplateDetailService.save(entitys);
                if (!CollectionUtil.isNotEmpty(entitys.getChildren())) continue;
                List RkProjectPlanTemplateDetailSubPlanIdList = JsonUtil.getJsonToList(entitys.getChildren(), RkProjectPlanTemplateDetailEntity.class);
                for (RkProjectPlanTemplateDetailEntity entitysSub : RkProjectPlanTemplateDetailSubPlanIdList) {
                    entitysSub.setId(RandomUtil.uuId());
                    entitysSub.setCompanyId(userInfo.getOrganizeId());
                    entitysSub.setSubPlanId(entitys.getId());
                    this.rkProjectPlanTemplateDetailService.save(entitysSub);
                }
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProjectPlanTemplateEntity entity = this.rkProjectPlanTemplateService.getInfo(id);
        if (entity != null) {
            this.rkProjectPlanTemplateService.delete(entity);
            QueryWrapper queryWrapperRkProjectPlanTemplateDetail = new QueryWrapper();
            queryWrapperRkProjectPlanTemplateDetail.lambda().eq(RkProjectPlanTemplateDetailEntity::getTemplateId, (Object)entity.getId());
            this.rkProjectPlanTemplateDetailService.remove((Wrapper)queryWrapperRkProjectPlanTemplateDetail);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"updateEnabledMark/{id}/{enabledMark}"})
    public ActionResult updateEnabledMark(@PathVariable(value="id") String id, @PathVariable(value="enabledMark") Integer enabledMark) {
        RkProjectPlanTemplateEntity entity = this.rkProjectPlanTemplateService.getInfo(id);
        if (ObjectUtil.isNotNull((Object)entity)) {
            entity.setEnabledMark(enabledMark);
            this.rkProjectPlanTemplateService.updateById(entity);
        }
        return ActionResult.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"/company"})
    public ActionResult getCompanyTemplate() {
        UserInfo userInfo = this.userProvider.get();
        return ActionResult.success(this.rkProjectPlanTemplateService.companyList(userInfo.getOrganizeId()));
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkProjectPlanTemplatePagination rkProjectPlanTemplatePagination) throws IOException {
        if (StringUtils.isEmpty((String)rkProjectPlanTemplatePagination.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        List<RkProjectPlanTemplateEntity> list = this.rkProjectPlanTemplateService.getTypeList(rkProjectPlanTemplatePagination, rkProjectPlanTemplatePagination.getDataType());
        for (RkProjectPlanTemplateEntity rkProjectPlanTemplateEntity : list) {
            rkProjectPlanTemplateEntity.setType(this.baseDataUtil.getDictName(rkProjectPlanTemplateEntity.getType(), "projectPlanTemplateType"));
            rkProjectPlanTemplateEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(rkProjectPlanTemplateEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, RkProjectPlanTemplateListVO.class);
        for (RkProjectPlanTemplateListVO rkProjectPlanTemplateVO : listVO) {
            OrganizeEntity byId = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)rkProjectPlanTemplateVO.getCompanyId()));
            OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId.getPropertyJson(), OrganizeCrModel.class);
            rkProjectPlanTemplateVO.setCompanyName(jsonToBean.getShortName());
            List<RkProjectPlanEntity> planList = this.rkProjectPlanService.getListByTemplateId(rkProjectPlanTemplateVO.getId());
            if (CollectionUtil.isNotEmpty(planList)) {
                rkProjectPlanTemplateVO.setHavePlanName("\u5df2\u4f7f\u7528");
            } else {
                rkProjectPlanTemplateVO.setHavePlanName("\u672a\u4f7f\u7528");
            }
            if (rkProjectPlanTemplateVO.getEnabledMark() == 1) {
                rkProjectPlanTemplateVO.setEnabledMarkName("\u542f\u7528");
                continue;
            }
            rkProjectPlanTemplateVO.setEnabledMarkName("\u7981\u7528");
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)rkProjectPlanTemplatePagination.getSelectKey()) ? rkProjectPlanTemplatePagination.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block32: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block32;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u6a21\u677f\u540d\u79f0", (Object)"name"));
                        continue block32;
                    }
                    case "type": {
                        entitys.add(new ExcelExportEntity("\u6a21\u677f\u7c7b\u578b", (Object)"type"));
                        continue block32;
                    }
                    case "productCategoryName": {
                        entitys.add(new ExcelExportEntity("\u9002\u5e94\u4ea7\u54c1\u7c7b\u578b", (Object)"productCategoryName"));
                        continue block32;
                    }
                    case "trialScope": {
                        entitys.add(new ExcelExportEntity("\u9002\u7528\u8303\u56f4", (Object)"trialScope"));
                        continue block32;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block32;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block32;
                    }
                    case "havePlan": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4f7f\u7528", (Object)"havePlanName"));
                        continue block32;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMarkName"));
                        continue block32;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block32;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u9879\u76ee\u8ba1\u5212\u6a21\u677f\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

