/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectQuestionEntity;
import com.bringspring.contract.entity.RkProjectQuestionTrendsEntity;
import com.bringspring.contract.model.rkprojectquestion.RkProjectQuestionAssignCrForm;
import com.bringspring.contract.model.rkprojectquestion.RkProjectQuestionCrForm;
import com.bringspring.contract.model.rkprojectquestion.RkProjectQuestionDealCrForm;
import com.bringspring.contract.model.rkprojectquestion.RkProjectQuestionInfoVO;
import com.bringspring.contract.model.rkprojectquestion.RkProjectQuestionListVO;
import com.bringspring.contract.model.rkprojectquestion.RkProjectQuestionPagination;
import com.bringspring.contract.model.rkprojectquestion.RkProjectQuestionPaginationExportModel;
import com.bringspring.contract.model.rkprojectquestion.RkProjectQuestionUpForm;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectQuestionService;
import com.bringspring.contract.service.RkProjectQuestionTrendsService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmRichTextEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.CrmRichTextService;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.utils.DateUtil;
import com.bringspring.workitem.entity.CrmWorkitemEntity;
import com.bringspring.workitem.service.CrmWorkitemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u95ee\u9898\u63d0\u62a5\u8bb0\u5f55"}, value="contract")
@RequestMapping(value={"/api/contract/RkProjectQuestion"})
public class RkProjectQuestionController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectQuestionController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private CrmWorkitemService crmWorkitemService;
    @Autowired
    private CrmRichTextService crmRichTextService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectQuestionService rkProjectQuestionService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private UserService userService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkProjectQuestionTrendsService rkProjectQuestionTrendsService;
    @Autowired
    private RkAttachmentService rkAttachmentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectQuestionPagination rkProjectQuestionPagination) throws IOException {
        List<RkProjectQuestionEntity> list = this.rkProjectQuestionService.getList(rkProjectQuestionPagination);
        List listVO = JsonUtil.getJsonToList(list, RkProjectQuestionListVO.class);
        for (RkProjectQuestionListVO rkProjectQuestionVO : listVO) {
            rkProjectQuestionVO.setDevelopStateName(this.baseDataUtil.getDictName(rkProjectQuestionVO.getDevelopState(), "demandMark"));
            rkProjectQuestionVO.setTypeName(this.baseDataUtil.getDictName(rkProjectQuestionVO.getType(), "projectQuestionType"));
            rkProjectQuestionVO.setPriorityName(this.baseDataUtil.getDictName(rkProjectQuestionVO.getPriority(), "projectPriority"));
            rkProjectQuestionVO.setStateName(this.baseDataUtil.getDictName(rkProjectQuestionVO.getState(), "projectQuestionState"));
            RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkProjectQuestionVO.getProjectId()));
            rkProjectQuestionVO.setProjectName(ObjectUtil.isNotEmpty((Object)projectEntity) ? projectEntity.getProjectName() : "");
            if (StrUtil.isNotEmpty((CharSequence)rkProjectQuestionVO.getCustomerName())) {
                CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)rkProjectQuestionVO.getCustomerId()));
                rkProjectQuestionVO.setCustomerName(ObjectUtil.isNotNull((Object)byId) ? byId.getName() : "");
            }
            rkProjectQuestionVO.setProjectHeaderName(this.baseDataUtil.userSelectValue(rkProjectQuestionVO.getProjectHeader()));
            rkProjectQuestionVO.setDealUserName(this.baseDataUtil.userSelectValue(rkProjectQuestionVO.getDealUser()));
            rkProjectQuestionVO.setProcessedUserName(this.baseDataUtil.userSelectValue(rkProjectQuestionVO.getProcessedUser()));
            rkProjectQuestionVO.setCreatorUserName(this.baseDataUtil.userSelectValue(rkProjectQuestionVO.getCreatorUserId()));
            rkProjectQuestionVO.setProductCatagoryName(this.crmProductCategoryService.getNameByIds(rkProjectQuestionVO.getProductCatagory()));
            CrmProductEntity info = this.crmProductService.getInfo(rkProjectQuestionVO.getProductId());
            if (!ObjectUtil.isNotEmpty((Object)info)) continue;
            rkProjectQuestionVO.setProductName(info.getProductName());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectQuestionPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkProjectQuestionCrForm rkProjectQuestionCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkProjectQuestionEntity entity = (RkProjectQuestionEntity)JsonUtil.getJsonToBean((Object)rkProjectQuestionCrForm, RkProjectQuestionEntity.class);
        entity.setId(mainId);
        this.rkProjectQuestionService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @PostMapping(value={"assign"})
    public ActionResult assign(@RequestBody RkProjectQuestionAssignCrForm assignCrForm) throws PermissionException {
        if (StrUtil.isEmpty((CharSequence)assignCrForm.getId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5206\u6d3e\u7684\u95ee\u9898");
        }
        this.rkProjectQuestionService.assginQuestion(assignCrForm);
        return ActionResult.success((String)"\u5206\u6d3e\u6210\u529f");
    }

    @PostMapping(value={"deal"})
    public ActionResult deal(@RequestBody RkProjectQuestionDealCrForm dealCrForm) throws PermissionException {
        if (StrUtil.isEmpty((CharSequence)dealCrForm.getId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5ba1\u6838\u7684\u95ee\u9898");
        }
        this.rkProjectQuestionService.dealQuestion(dealCrForm);
        return ActionResult.success((String)"\u5904\u7406\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectQuestionInfoVO> info(@PathVariable(value="id") String id) {
        RkProjectQuestionInfoVO vo;
        RkProjectQuestionEntity entity = this.rkProjectQuestionService.getInfo(id);
        RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)(vo = (RkProjectQuestionInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectQuestionInfoVO.class)).getProjectId()));
        vo.setProjectName(ObjectUtil.isNotEmpty((Object)projectEntity) ? projectEntity.getProjectName() : "");
        List<RkAttachmentEntity> attachmentEntityList = this.rkAttachmentService.getListByObjId(id);
        vo.setAttachmentList(attachmentEntityList);
        vo.setDevelopStateName(this.baseDataUtil.getDictName(vo.getDevelopState(), "demandMark"));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkProjectQuestionInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmWorkitemEntity workitemEntity;
        RkProjectQuestionEntity entity = this.rkProjectQuestionService.getInfo(id);
        RkProjectQuestionInfoVO vo = (RkProjectQuestionInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectQuestionInfoVO.class);
        CrmRichTextEntity textEntity = this.crmRichTextService.getInfo(entity.getId());
        if (ObjectUtil.isNotEmpty((Object)textEntity)) {
            vo.setDescriptionText(textEntity.getDescriptionText());
        }
        vo.setType(this.baseDataUtil.getDictName(vo.getType(), "projectQuestionType"));
        vo.setPriority(this.baseDataUtil.getDictName(vo.getPriority(), "projectPriority"));
        vo.setStateName(this.baseDataUtil.getDictName(vo.getState(), "projectQuestionState"));
        RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)vo.getProjectId()));
        vo.setProjectName(ObjectUtil.isNotEmpty((Object)projectEntity) ? projectEntity.getProjectName() : "");
        vo.setProjectHeaderName(this.baseDataUtil.userSelectValue(vo.getProjectHeader()));
        vo.setDealUserName(this.baseDataUtil.userSelectValue(vo.getDealUser()));
        vo.setProcessedUserName(this.baseDataUtil.userSelectValue(vo.getProcessedUser()));
        vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setSalerId(this.baseDataUtil.userSelectValue(vo.getSalerId()));
        vo.setProductCatagoryName(this.crmProductCategoryService.getNameByIds(vo.getProductCatagory()));
        CrmProductEntity info = this.crmProductService.getInfo(vo.getProductId());
        if (ObjectUtil.isNotEmpty((Object)info)) {
            vo.setProductName(info.getProductName());
        }
        List<RkAttachmentEntity> attachmentEntityList = this.rkAttachmentService.getListByObjId(id);
        vo.setAttachmentList(attachmentEntityList);
        vo.setDevelopStateName(this.baseDataUtil.getDictName(vo.getDevelopState(), "demandMark"));
        if (entity.getIsGenerate().equals("0") && ObjectUtil.isNotEmpty((Object)(workitemEntity = this.crmWorkitemService.getProjectQuestionId(entity.getId())))) {
            vo.setWorkitemId(workitemEntity.getId());
            vo.setWorkitemState(this.baseDataUtil.getDictName(workitemEntity.getEnabledMark(), "demandMark"));
            vo.setWorkitemName(workitemEntity.getName());
            vo.setPersonInCharge(this.baseDataUtil.userSelectValues(workitemEntity.getPersonInCharge()));
            vo.setWorkType(this.baseDataUtil.getDictName(workitemEntity.getType(), "demandType"));
            vo.setWorkPriority(this.baseDataUtil.getDictName(workitemEntity.getPriority(), "demandPriority"));
            vo.setStartDateWorkitem(workitemEntity.getStartDate());
            vo.setEndDate(workitemEntity.getEndDate());
            vo.setActualStartDate(workitemEntity.getActualStartDate());
            vo.setActualEndDate(workitemEntity.getActualEndDate());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"trends/{questionId}"})
    public ActionResult trends(@PathVariable(value="questionId") String questionId) {
        return ActionResult.success((Object)this.dealTrends(questionId));
    }

    private List dealTrends(String questionId) {
        RkProjectQuestionEntity byId = (RkProjectQuestionEntity)this.rkProjectQuestionService.getById((Serializable)((Object)questionId));
        if (ObjectUtil.isNotNull((Object)byId)) {
            List<RkProjectQuestionTrendsEntity> list = this.rkProjectQuestionTrendsService.getListByQuestionId(questionId);
            list.stream().forEach(entity -> {
                entity.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(entity.getCreatorUserId()));
                entity.setNextProcessedUser(this.baseDataUtil.userSelectValueNoAccount(entity.getNextProcessedUser()));
                entity.setType(this.baseDataUtil.getDictName(entity.getType(), "problemTrendsType"));
            });
            return list;
        }
        return CollectionUtil.list((boolean)false);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectQuestionUpForm rkProjectQuestionUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkProjectQuestionEntity entity = this.rkProjectQuestionService.getInfo(id);
        if (entity != null) {
            RkProjectQuestionEntity subentity = (RkProjectQuestionEntity)JsonUtil.getJsonToBean((Object)rkProjectQuestionUpForm, RkProjectQuestionEntity.class);
            this.rkProjectQuestionService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProjectQuestionEntity entity = this.rkProjectQuestionService.getInfo(id);
        if (entity != null) {
            this.rkProjectQuestionService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkProjectQuestionPaginationExportModel rkProjectQuestionPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)rkProjectQuestionPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkProjectQuestionPagination rkProjectQuestionPagination = (RkProjectQuestionPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkProjectQuestionPaginationExportModel), RkProjectQuestionPagination.class));
        List<RkProjectQuestionEntity> list = this.rkProjectQuestionService.getTypeList(rkProjectQuestionPagination, rkProjectQuestionPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, RkProjectQuestionListVO.class);
        for (RkProjectQuestionListVO rkProjectQuestionVO : listVO) {
            rkProjectQuestionVO.setDevelopStateName(this.baseDataUtil.getDictName(rkProjectQuestionVO.getDevelopState(), "demandMark"));
            rkProjectQuestionVO.setType(this.baseDataUtil.getDictName(rkProjectQuestionVO.getType(), "projectQuestionType"));
            rkProjectQuestionVO.setPriority(this.baseDataUtil.getDictName(rkProjectQuestionVO.getPriority(), "projectPriority"));
            rkProjectQuestionVO.setState(this.baseDataUtil.getDictName(rkProjectQuestionVO.getState(), "projectQuestionState"));
            RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkProjectQuestionVO.getProjectId()));
            rkProjectQuestionVO.setProjectId(ObjectUtil.isNotEmpty((Object)projectEntity) ? projectEntity.getProjectName() : "");
            rkProjectQuestionVO.setCompanyId(this.baseDataUtil.comSelectValues(rkProjectQuestionVO.getCompanyId()));
            rkProjectQuestionVO.setProjectHeader(this.baseDataUtil.userSelectValue(rkProjectQuestionVO.getProjectHeader()));
            rkProjectQuestionVO.setDealUser(this.baseDataUtil.userSelectValue(rkProjectQuestionVO.getDealUser()));
            if (StrUtil.isNotEmpty((CharSequence)rkProjectQuestionVO.getCustomerName())) {
                CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)rkProjectQuestionVO.getCustomerId()));
                rkProjectQuestionVO.setCustomerName(ObjectUtil.isNotNull((Object)byId) ? byId.getName() : "");
            }
            rkProjectQuestionVO.setProcessedUser(this.baseDataUtil.userSelectValue(rkProjectQuestionVO.getProcessedUser()));
            rkProjectQuestionVO.setCreatorUserName(this.baseDataUtil.userSelectValue(rkProjectQuestionVO.getCreatorUserId()));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)rkProjectQuestionPaginationExportModel.getSelectKey()) ? rkProjectQuestionPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block44: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyId"));
                        continue block44;
                    }
                    case "questionCode": {
                        entitys.add(new ExcelExportEntity("\u95ee\u9898\u7f16\u53f7", (Object)"questionCode"));
                        continue block44;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"customerName"));
                        continue block44;
                    }
                    case "projectId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectId"));
                        continue block44;
                    }
                    case "type": {
                        entitys.add(new ExcelExportEntity("\u95ee\u9898\u7c7b\u578b", (Object)"type"));
                        continue block44;
                    }
                    case "startDate": {
                        entitys.add(new ExcelExportEntity("\u5f00\u59cb\u65f6\u95f4", (Object)"startDate"));
                        continue block44;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u95ee\u9898\u63cf\u8ff0", (Object)"description"));
                        continue block44;
                    }
                    case "state": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"state"));
                        continue block44;
                    }
                    case "developState": {
                        entitys.add(new ExcelExportEntity("\u7814\u53d1\u72b6\u6001", (Object)"developStateName"));
                        continue block44;
                    }
                    case "priority": {
                        entitys.add(new ExcelExportEntity("\u4f18\u5148\u7ea7", (Object)"priority"));
                        continue block44;
                    }
                    case "projectHeader": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"projectHeader"));
                        continue block44;
                    }
                    case "creatorUserName": {
                        entitys.add(new ExcelExportEntity("\u63d0\u62a5\u4eba", (Object)"creatorUserName"));
                        continue block44;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u63d0\u62a5\u65f6\u95f4", (Object)"creatorTime"));
                        continue block44;
                    }
                    case "processedUser": {
                        entitys.add(new ExcelExportEntity("\u5904\u7406\u4eba", (Object)"processedUser"));
                        continue block44;
                    }
                    case "dealUser": {
                        entitys.add(new ExcelExportEntity("\u89e3\u51b3\u4eba", (Object)"dealUser"));
                        continue block44;
                    }
                    case "dealTime": {
                        entitys.add(new ExcelExportEntity("\u89e3\u51b3\u65f6\u95f4", (Object)"dealTime"));
                        continue block44;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u9879\u76ee\u95ee\u9898" + DateUtil.dateNow("yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

