/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkProjectReportPlanEntity;
import com.bringspring.contract.model.rkprojectreportplan.RkProjectReportPlanCrForm;
import com.bringspring.contract.model.rkprojectreportplan.RkProjectReportPlanInfoVO;
import com.bringspring.contract.model.rkprojectreportplan.RkProjectReportPlanListVO;
import com.bringspring.contract.model.rkprojectreportplan.RkProjectReportPlanPagination;
import com.bringspring.contract.model.rkprojectreportplan.RkProjectReportPlanUpForm;
import com.bringspring.contract.service.RkProjectReportPlanService;
import com.bringspring.contract.utils.ProjectTaskStateEnum;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5546\u673a\u62a5\u5907\u8ba1\u5212"}, value="project")
@RequestMapping(value={"/api/project/RkProjectReportPlan"})
public class RkProjectReportPlanController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectReportPlanController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectReportPlanService rkProjectReportPlanService;
    @Autowired
    private UserService userService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectReportPlanPagination rkProjectReportPlanPagination) throws IOException {
        List<RkProjectReportPlanEntity> list = this.rkProjectReportPlanService.getList(rkProjectReportPlanPagination);
        List listVO = JsonUtil.getJsonToList(list, RkProjectReportPlanListVO.class);
        List userEntities = this.userService.list();
        for (RkProjectReportPlanListVO rkProjectReportPlanVO : listVO) {
            rkProjectReportPlanVO.setExecutorUserId(rkProjectReportPlanVO.getExecutorUser());
            rkProjectReportPlanVO.setStateCode(rkProjectReportPlanVO.getState());
            rkProjectReportPlanVO.setType(this.baseDataUtil.getDictName(rkProjectReportPlanVO.getType(), "opporPlanType"));
            rkProjectReportPlanVO.setState(this.baseDataUtil.getDictName(rkProjectReportPlanVO.getState(), "projectTaskState"));
            rkProjectReportPlanVO.setSalesStage(this.baseDataUtil.getDictName(rkProjectReportPlanVO.getSalesStage(), "ReportingSaleStage"));
            rkProjectReportPlanVO.setAssistantsUser(this.baseDataUtil.userSelectValue(rkProjectReportPlanVO.getAssistantsUser()));
            rkProjectReportPlanVO.setExecutorUser(this.baseDataUtil.userSelectValue(rkProjectReportPlanVO.getExecutorUser()));
            List strings = userEntities.stream().filter(item -> item.getId().equals(rkProjectReportPlanVO.getExecutorUserId())).map(UserEntity::getManagerId).collect(Collectors.toList());
            if (!ObjectUtil.isNotEmpty(strings)) continue;
            rkProjectReportPlanVO.setManagerId((String)strings.get(0));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectReportPlanPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkProjectReportPlanCrForm rkProjectReportPlanCrForm) throws DataException {
        this.rkProjectReportPlanService.create(rkProjectReportPlanCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectReportPlanInfoVO> info(@PathVariable(value="id") String id) {
        RkProjectReportPlanEntity entity = this.rkProjectReportPlanService.getInfo(id);
        RkProjectReportPlanInfoVO vo = (RkProjectReportPlanInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectReportPlanInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkProjectReportPlanInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkProjectReportPlanEntity entity = this.rkProjectReportPlanService.getInfo(id);
        RkProjectReportPlanInfoVO vo = (RkProjectReportPlanInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectReportPlanInfoVO.class);
        vo.setType(this.baseDataUtil.getDictName(vo.getType(), "opporPlanType"));
        vo.setState(this.baseDataUtil.getDictName(vo.getState(), "projectTaskState"));
        vo.setSalesStage(this.baseDataUtil.getDictName(vo.getSalesStage(), "ReportingSaleStage"));
        vo.setAssistantsUser(this.baseDataUtil.userSelectValue(vo.getAssistantsUser()));
        vo.setExecutorUser(this.baseDataUtil.userSelectValue(vo.getExecutorUser()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectReportPlanUpForm rkProjectReportPlanUpForm) throws DataException {
        this.rkProjectReportPlanService.update(id, rkProjectReportPlanUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProjectReportPlanEntity entity = this.rkProjectReportPlanService.getInfo(id);
        if (entity != null) {
            this.rkProjectReportPlanService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"complete"})
    public ActionResult complete(@RequestBody RkProjectReportPlanUpForm rkProjectReportPlanUpForm) {
        RkProjectReportPlanEntity entity = this.rkProjectReportPlanService.getInfo(rkProjectReportPlanUpForm.getId());
        if (entity != null) {
            entity.setState(ProjectTaskStateEnum.complete.getResult());
            entity.setActEndTime((Date)DateUtil.date((long)rkProjectReportPlanUpForm.getActTime().get(1)));
            entity.setActStartTime((Date)DateUtil.date((long)rkProjectReportPlanUpForm.getActTime().get(0)));
            entity.setCompleteRemark(rkProjectReportPlanUpForm.getCompleteRemark());
            this.rkProjectReportPlanService.updateById(entity);
        }
        return ActionResult.success((String)"\u5b8c\u6210\u8ba1\u5212\u6210\u529f");
    }
}

