/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectStartEntity;
import com.bringspring.contract.entity.RkProjectStartProductRelationEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.model.rkprojectstart.RkProjectStartCrForm;
import com.bringspring.contract.model.rkprojectstart.RkProjectStartInfoVO;
import com.bringspring.contract.model.rkprojectstart.RkProjectStartListVO;
import com.bringspring.contract.model.rkprojectstart.RkProjectStartPagination;
import com.bringspring.contract.model.rkprojectstart.RkProjectStartPaginationExportModel;
import com.bringspring.contract.model.rkprojectstart.RkProjectStartUpForm;
import com.bringspring.contract.model.rkprojectstartproduct.RkProjectStartProductRelationModel;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectStartProductRelationService;
import com.bringspring.contract.service.RkProjectStartService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.ProjectStateEnum;
import com.bringspring.crm.entity.CrmProductVersionEntity;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionListVO;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductVersionService;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u5f00\u5de5\u7533\u8bf7"}, value="contract")
@RequestMapping(value={"/api/contract/RkProjectStart"})
public class RkProjectStartController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectStartController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectStartService rkProjectStartService;
    @Autowired
    private CrmProductVersionService crmProductVersionService;
    @Autowired
    private RkProjectStartProductRelationService rkProjectStartProductRelationService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectStartPagination rkProjectStartPagination) throws IOException {
        List<RkProjectStartEntity> list = this.rkProjectStartService.getList(rkProjectStartPagination);
        for (RkProjectStartEntity rkProjectStartEntity : list) {
            rkProjectStartEntity.setHardwareCondition(this.baseDataUtil.getDictName(rkProjectStartEntity.getHardwareCondition(), "509637416412263045"));
            rkProjectStartEntity.setElectricalCondition(this.baseDataUtil.getDictName(rkProjectStartEntity.getElectricalCondition(), "509637665801384581"));
            rkProjectStartEntity.setInterfaceCondition(this.baseDataUtil.getDictName(rkProjectStartEntity.getInterfaceCondition(), "509637814032282245"));
            rkProjectStartEntity.setArrivalStatus(this.baseDataUtil.getDictName(rkProjectStartEntity.getArrivalStatus(), "509638396105208453"));
        }
        List listVO = JsonUtil.getJsonToList(list, RkProjectStartListVO.class);
        for (RkProjectStartListVO rkProjectStartListVO : listVO) {
        }
        for (RkProjectStartListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectStartPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        RkProjectStartCrForm rkProjectStartCrForm = (RkProjectStartCrForm)((Object)JsonUtil.getJsonToBean(crData, RkProjectStartCrForm.class));
        if (ObjectUtil.isEmpty((Object)rkProjectStartCrForm.getProjectId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5f00\u5de5\u7684\u9879\u76ee");
        }
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkProjectStartCrForm.getProjectId()));
        if (ObjectUtil.isEmpty((Object)byId)) {
            return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        if (byId.getIsAcceptance() == 1) {
            return ActionResult.fail((String)"\u9879\u76ee\u5df2\u9a8c\u6536\uff0c\u4e0d\u80fd\u518d\u7533\u8bf7\u5f00\u5de5");
        }
        if (!ObjectUtil.isEmpty((Object)byId.getState()) && !StringUtils.equals((CharSequence)byId.getState(), (CharSequence)ProjectStateEnum.notStartApply_state.getState())) {
            return ActionResult.fail((String)"\u9879\u76ee\u5df2\u7533\u8bf7\u8fc7\u5f00\u5de5,\u4e0d\u80fd\u518d\u6b21\u7533\u8bf7");
        }
        String state = "";
        state = FlowTaskStatusEnum.Handle.getCode().equals(rkProjectStartCrForm.getStatus()) ? ProjectStateEnum.startAudit_state.getState() : ProjectStateEnum.notStartApply_state.getState();
        byId.setState(state);
        String flowEngineId = "509621384276619909";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkProjectStartEntity entity = (RkProjectStartEntity)JsonUtil.getJsonToBean((Object)((Object)rkProjectStartCrForm), RkProjectStartEntity.class);
        entity.setId(mainId);
        entity.setState(state);
        this.rkProjectStartService.save(entity);
        this.rkContractProjectService.updateById(byId);
        List rkProjectStartProductRelationList = JsonUtil.getJsonToList(rkProjectStartCrForm.getRkProjectStartProductRelationModels(), RkProjectStartProductRelationEntity.class);
        for (RkProjectStartProductRelationEntity entitys : rkProjectStartProductRelationList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setContractId(entity.getContractId());
            entitys.setCustomerId(entity.getCustomerId());
            entitys.setProjectStartId(entity.getId());
            this.rkProjectStartProductRelationService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)rkProjectStartCrForm.getTaskId(), (String)flowEngineId, (String)rkProjectStartCrForm.getTemplateId(), (String)mainId, (Object)((Object)rkProjectStartCrForm), (Integer)rkProjectStartCrForm.getStatus(), (String)byId.getProjectName());
        if (rkProjectStartCrForm.getStatus() == 0) {
            return ActionResult.success((String)CrmReminderEnum.TS.getType());
        }
        return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkProjectStartPaginationExportModel rkProjectStartPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)rkProjectStartPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkProjectStartPagination rkProjectStartPagination = (RkProjectStartPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkProjectStartPaginationExportModel), RkProjectStartPagination.class));
        List<RkProjectStartEntity> list = this.rkProjectStartService.getTypeList(rkProjectStartPagination, rkProjectStartPaginationExportModel.getDataType());
        for (RkProjectStartEntity rkProjectStartEntity : list) {
            rkProjectStartEntity.setHardwareCondition(this.baseDataUtil.getDictName(rkProjectStartEntity.getHardwareCondition(), "509637416412263045"));
            rkProjectStartEntity.setElectricalCondition(this.baseDataUtil.getDictName(rkProjectStartEntity.getElectricalCondition(), "509637665801384581"));
            rkProjectStartEntity.setInterfaceCondition(this.baseDataUtil.getDictName(rkProjectStartEntity.getInterfaceCondition(), "509637814032282245"));
            rkProjectStartEntity.setArrivalStatus(this.baseDataUtil.getDictName(rkProjectStartEntity.getArrivalStatus(), "509638396105208453"));
        }
        List listVO = JsonUtil.getJsonToList(list, RkProjectStartListVO.class);
        for (RkProjectStartListVO rkProjectStartListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkProjectStartPaginationExportModel.getSelectKey()) ? rkProjectStartPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block54: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u5ba2\u6237", (Object)"customerId"));
                        continue block54;
                    }
                    case "contractId": {
                        entitys.add(new ExcelExportEntity("\u5408\u540cID", (Object)"contractId"));
                        continue block54;
                    }
                    case "projectId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76eeID", (Object)"projectId"));
                        continue block54;
                    }
                    case "constructionLocation": {
                        entitys.add(new ExcelExportEntity("\u65bd\u5de5\u5730\u70b9", (Object)"constructionLocation"));
                        continue block54;
                    }
                    case "startDate": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u5f00\u5de5\u65e5\u671f", (Object)"startDate"));
                        continue block54;
                    }
                    case "expectedCompletionDate": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u5b8c\u6210\u65e5\u671f", (Object)"expectedCompletionDate"));
                        continue block54;
                    }
                    case "aContactPerson": {
                        entitys.add(new ExcelExportEntity("\u7532\u65b9\u8054\u7cfb\u4eba", (Object)"aContactPerson"));
                        continue block54;
                    }
                    case "aContactPhone": {
                        entitys.add(new ExcelExportEntity("\u7532\u65b9\u7535\u8bdd", (Object)"aContactPhone"));
                        continue block54;
                    }
                    case "aContactDepartment": {
                        entitys.add(new ExcelExportEntity("\u79d1\u5ba4", (Object)"aContactDepartment"));
                        continue block54;
                    }
                    case "agentContactPerson": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546\u8054\u7cfb\u4eba", (Object)"agentContactPerson"));
                        continue block54;
                    }
                    case "agentContactPhone": {
                        entitys.add(new ExcelExportEntity("\u4e2d\u95f4\u5546\u7535\u8bdd", (Object)"agentContactPhone"));
                        continue block54;
                    }
                    case "hardwareCondition": {
                        entitys.add(new ExcelExportEntity("\u786c\u4ef6\u60c5\u51b5", (Object)"hardwareCondition"));
                        continue block54;
                    }
                    case "electricalCondition": {
                        entitys.add(new ExcelExportEntity("\u5f3a\u5f31\u7535\u60c5\u51b5", (Object)"electricalCondition"));
                        continue block54;
                    }
                    case "interfaceCondition": {
                        entitys.add(new ExcelExportEntity("\u63a5\u53e3\u60c5\u51b5", (Object)"interfaceCondition"));
                        continue block54;
                    }
                    case "softwareVendor": {
                        entitys.add(new ExcelExportEntity("\u7b2c\u4e09\u65b9\u8f6f\u4ef6\u5382\u5546", (Object)"softwareVendor"));
                        continue block54;
                    }
                    case "arrivalStatus": {
                        entitys.add(new ExcelExportEntity("\u8d27\u7269\u5230\u8fbe\u60c5\u51b5", (Object)"arrivalStatus"));
                        continue block54;
                    }
                    case "projectConditionRemarks": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u60c5\u51b5\u5907\u6ce8", (Object)"projectConditionRemarks"));
                        continue block54;
                    }
                    case "productIncomeType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5927\u7c7b", (Object)"productIncomeType"));
                        continue block54;
                    }
                    case "productAuthModule": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u6388\u6743\u6a21\u5757", (Object)"productAuthModule"));
                        continue block54;
                    }
                    case "productCustomFunction": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5b9a\u5236\u529f\u80fd", (Object)"productCustomFunction"));
                        continue block54;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u65bd\u5de5\u8ba1\u5212\u53ca\u8981\u70b9\u5907\u6ce8", (Object)"description"));
                        continue block54;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectStartInfoVO> info(@PathVariable(value="id") String id) {
        RkProjectStartEntity entity = this.rkProjectStartService.getInfo(id);
        RkProjectStartInfoVO vo = (RkProjectStartInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectStartInfoVO.class);
        if (!ObjectUtil.isEmpty((Object)vo.getCustomerId())) {
            vo.setCustomerName(this.crmCustomerService.getInfo(vo.getCustomerId()).getName());
        }
        String contractName = "";
        Integer isAgent = 0;
        String agentName = "";
        if (StringUtils.isNotEmpty((String)vo.getContractId())) {
            Object contract;
            if (vo.getContractId().equals(vo.getNoContractId())) {
                contract = this.saleNoContractService.getInfo(vo.getNoContractId());
                if (null != contract) {
                    isAgent = 0;
                    agentName = this.saleContractCustomerService.getCustomerNamesByContractId(((SaleNoContractEntity)contract).getId());
                }
            } else {
                contract = this.rkContractService.getInfo(vo.getContractId());
                if (null != contract) {
                    isAgent = ((RkContractEntity)contract).getIsAgent();
                    agentName = this.saleContractCustomerService.getCustomerNamesByContractId(((RkContractEntity)contract).getId());
                }
            }
        }
        vo.setContractName(contractName);
        vo.setIsAgent(isAgent);
        vo.setAgentName(agentName);
        List<RkProjectStartProductRelationEntity> rkProjectStartProductRelationList = this.rkProjectStartService.getRkProjectStartProductRelationList(id);
        for (RkProjectStartProductRelationEntity rk_project_start_product_relationEntity : rkProjectStartProductRelationList) {
            List<CrmProductVersionEntity> listByProductId = this.crmProductVersionService.getListByProductId(rk_project_start_product_relationEntity.getProductId());
            List versionListVOS = JsonUtil.getJsonToList(listByProductId, CrmProductVersionListVO.class);
            rk_project_start_product_relationEntity.setVersionList(versionListVOS);
        }
        vo.setRkProjectStartProductRelationModels(JsonUtil.getJsonToList(rkProjectStartProductRelationList, RkProjectStartProductRelationModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        RkProjectStartUpForm rkProjectStartUpForm = (RkProjectStartUpForm)((Object)JsonUtil.getJsonToBean(upData, RkProjectStartUpForm.class));
        if (ObjectUtil.isEmpty((Object)rkProjectStartUpForm.getProjectId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5f00\u5de5\u7684\u9879\u76ee");
        }
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkProjectStartUpForm.getProjectId()));
        if (ObjectUtil.isEmpty((Object)byId)) {
            return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        if (byId.getIsAcceptance() == 1) {
            return ActionResult.fail((String)"\u9879\u76ee\u5df2\u9a8c\u6536\uff0c\u4e0d\u80fd\u518d\u7533\u8bf7\u5f00\u5de5");
        }
        if (!ObjectUtil.isEmpty((Object)byId.getState()) && !StringUtils.equals((CharSequence)byId.getState(), (CharSequence)ProjectStateEnum.notStartApply_state.getState())) {
            return ActionResult.fail((String)"\u9879\u76ee\u5df2\u7533\u8bf7\u8fc7\u5f00\u5de5,\u4e0d\u80fd\u518d\u6b21\u7533\u8bf7");
        }
        String state = "";
        state = FlowTaskStatusEnum.Handle.getCode().equals(rkProjectStartUpForm.getStatus()) ? ProjectStateEnum.startAudit_state.getState() : ProjectStateEnum.notStartApply_state.getState();
        byId.setState(state);
        this.rkContractProjectService.updateById(byId);
        String flowEngineId = "509621384276619909";
        UserInfo userInfo = this.userProvider.get();
        RkProjectStartEntity entity = this.rkProjectStartService.getInfo(id);
        if (entity != null) {
            RkProjectStartEntity subentity = (RkProjectStartEntity)JsonUtil.getJsonToBean((Object)((Object)rkProjectStartUpForm), RkProjectStartEntity.class);
            this.rkProjectStartService.update(id, subentity);
            QueryWrapper Rk_project_start_product_relationqueryWrapper = new QueryWrapper();
            Rk_project_start_product_relationqueryWrapper.lambda().eq(RkProjectStartProductRelationEntity::getProjectStartId, (Object)entity.getId());
            this.rkProjectStartProductRelationService.remove((Wrapper)Rk_project_start_product_relationqueryWrapper);
            List rkProjectStartProductRelationList = JsonUtil.getJsonToList(rkProjectStartUpForm.getRkProjectStartProductRelationModels(), RkProjectStartProductRelationEntity.class);
            for (RkProjectStartProductRelationEntity entitys : rkProjectStartProductRelationList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setProjectStartId(entity.getId());
                this.rkProjectStartProductRelationService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)rkProjectStartUpForm.getTaskId(), (String)flowEngineId, (String)rkProjectStartUpForm.getTemplateId(), (String)id, (Object)((Object)rkProjectStartUpForm), (Integer)rkProjectStartUpForm.getStatus(), (String)byId.getProjectName());
            if (rkProjectStartUpForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProjectStartEntity entity = this.rkProjectStartService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.rkProjectStartService.delete(entity);
            QueryWrapper queryWrapperRk_project_start_product_relation = new QueryWrapper();
            queryWrapperRk_project_start_product_relation.lambda().eq(RkProjectStartProductRelationEntity::getProjectStartId, (Object)entity.getId());
            this.rkProjectStartProductRelationService.remove((Wrapper)queryWrapperRk_project_start_product_relation);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

