/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProductEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectStopRecordEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.model.RkProjectStopRecordForm;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectInfoVO;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectStopRecordService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.ProjectStateEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"rk_project_stop_record"}, value="contract")
@RequestMapping(value={"/api/contract/RkProjectStopRecord"})
public class RkProjectStopRecordController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectStopRecordController.class);
    @Autowired
    private RkProjectStopRecordService rkProjectStopRecordService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkContractProductService rkContractProductService;
    @Autowired
    private SaleNoContractService saleNoContractService;

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkProjectStopRecordForm rkProjectStopRecordForm) throws Exception {
        String flowEngineId = "592699512984774341";
        RkProjectStopRecordEntity entity = (RkProjectStopRecordEntity)JsonUtil.getJsonToBean((Object)((Object)rkProjectStopRecordForm), RkProjectStopRecordEntity.class);
        entity.setAttachmentList(rkProjectStopRecordForm.getAttachmentListAll());
        String mainId = RandomUtil.uuId();
        entity.setId(mainId);
        entity.setProjectId(rkProjectStopRecordForm.getProjectId());
        this.rkProjectStopRecordService.create(entity);
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()));
        if (ObjectUtils.isNotEmpty((Object)byId)) {
            byId.setStopRemark(entity.getRemark());
            byId.setStopApplyId(mainId);
            this.rkContractProjectService.updateById(byId);
            rkProjectStopRecordForm.setProjectHeader(byId.getProjectHeader());
            rkProjectStopRecordForm.setRegionalHead(byId.getRegionalHead());
        }
        if (CollectionUtil.isNotEmpty(rkProjectStopRecordForm.getAttachmentList())) {
            List jsonToList = JsonUtil.getJsonToList(rkProjectStopRecordForm.getAttachmentList(), RkAttachmentEntity.class);
            jsonToList.stream().forEach(att -> {
                att.setId(RandomUtil.uuId());
                att.setObjId(mainId);
                att.setProjectId(rkProjectStopRecordForm.getProjectId());
                att.setFileType("project_stop");
            });
            this.attachmentService.saveBatch(jsonToList);
        }
        FlowUtil.saveOrSubmit((String)rkProjectStopRecordForm.getTaskId(), (String)flowEngineId, (String)rkProjectStopRecordForm.getTemplateId(), (String)mainId, (Object)((Object)rkProjectStopRecordForm), (Integer)rkProjectStopRecordForm.getStatus(), (String)byId.getProjectName());
        if (rkProjectStopRecordForm.getStatus() == 0) {
            return ActionResult.success((String)CrmReminderEnum.TS.getType());
        }
        return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectStopRecordForm oaProjectAuthorizationCrForm) throws DataException, WorkFlowException {
        RkProjectStopRecordEntity entity = this.rkProjectStopRecordService.getInfo(id);
        if (entity != null) {
            RkProjectStopRecordEntity subentity = (RkProjectStopRecordEntity)JsonUtil.getJsonToBean((Object)((Object)oaProjectAuthorizationCrForm), RkProjectStopRecordEntity.class);
            entity.setAttachmentList(oaProjectAuthorizationCrForm.getAttachmentListAll());
            UserInfo userInfo = this.userProvider.get();
            subentity.setLastModifyTime(new Date());
            subentity.setLastModifyUserId(userInfo.getUserId());
            this.rkProjectStopRecordService.update(id, subentity);
            RkContractProjectEntity info = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()));
            if (ObjectUtils.isEmpty((Object)info)) {
                return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            if (ObjectUtils.isNotEmpty((Object)info)) {
                info.setStopRemark(entity.getRemark());
            }
            if (ObjectUtils.isNotEmpty((Object)info)) {
                this.rkContractProjectService.updateById(info);
                oaProjectAuthorizationCrForm.setProjectHeader(info.getProjectHeader());
                oaProjectAuthorizationCrForm.setRegionalHead(info.getRegionalHead());
            }
            String flowEngineId = "592699512984774341";
            if (StrUtil.isNotBlank((CharSequence)oaProjectAuthorizationCrForm.getFlowId())) {
                flowEngineId = oaProjectAuthorizationCrForm.getFlowId();
            }
            this.attachmentService.deleteByObjId(entity.getId());
            if (CollectionUtil.isNotEmpty(oaProjectAuthorizationCrForm.getAttachmentList())) {
                List jsonToList = JsonUtil.getJsonToList(oaProjectAuthorizationCrForm.getAttachmentList(), RkAttachmentEntity.class);
                jsonToList.stream().forEach(att -> {
                    att.setId(RandomUtil.uuId());
                    att.setObjId(entity.getId());
                    att.setProjectId(entity.getProjectId());
                    att.setFileType("project_stop");
                });
                this.attachmentService.saveBatch(jsonToList);
            }
            FlowUtil.saveOrSubmit((String)oaProjectAuthorizationCrForm.getTaskId(), (String)flowEngineId, (String)oaProjectAuthorizationCrForm.getTemplateId(), (String)entity.getId(), (Object)((Object)oaProjectAuthorizationCrForm), (Integer)oaProjectAuthorizationCrForm.getStatus(), (String)info.getProjectName());
            if (oaProjectAuthorizationCrForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectStopRecordEntity> info(@PathVariable(value="id") String id) {
        RkProjectStopRecordEntity entity = this.rkProjectStopRecordService.getInfo(id);
        return ActionResult.success((Object)entity);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractProjectInfoVO> detail(@PathVariable(value="id") String id) {
        RkProjectStopRecordEntity entity = this.rkProjectStopRecordService.getInfo(id);
        RkContractProjectEntity projectEntity = this.rkContractProjectService.getInfo(entity.getProjectId());
        RkContractProjectInfoVO vo = (RkContractProjectInfoVO)JsonUtil.getJsonToBean((Object)projectEntity, RkContractProjectInfoVO.class);
        vo.setId(entity.getId());
        vo.setAttachmentList(this.attachmentService.getListByObjId(id));
        if (StringUtils.isNotEmpty((String)vo.getAuthorizedUser())) {
            vo.setAuthorizedUserName(this.baseDataUtil.userSelectValues(vo.getAuthorizedUser()));
        }
        vo.setStateCode(vo.getState());
        Map<String, ProjectStateEnum> allToMap = ProjectStateEnum.getAllToMap();
        vo.setState(StringUtils.isEmpty((String)vo.getState()) ? "" : allToMap.get(vo.getState()).getDesc());
        vo.setProjectNature(this.baseDataUtil.getDictName(vo.getProjectNature(), "projectNature"));
        vo.setRegionalHeadId(vo.getRegionalHead());
        vo.setRegionalHead(this.baseDataUtil.userSelectValueNoAccount(vo.getRegionalHead()));
        vo.setProjectHeader(this.baseDataUtil.userSelectValueNoAccount(vo.getProjectHeader()));
        vo.setExecuteUserCode(vo.getExecuteUser());
        vo.setExecuteUser(this.baseDataUtil.userSelectValues(vo.getExecuteUser()));
        if (StrUtil.isNotEmpty((CharSequence)vo.getExecuteAssistantsUser())) {
            vo.setExecuteAssistantsUser(this.baseDataUtil.userSelectValues(vo.getExecuteAssistantsUser()));
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getAssistantsUser())) {
            vo.setAssistantsUser(this.baseDataUtil.userSelectValues(vo.getAssistantsUser()));
        }
        vo.setIncomeType(this.baseDataUtil.getDictName(vo.getIncomeType(), "incomeType"));
        vo.setTaxRate(this.baseDataUtil.getDictName(vo.getTaxRate(), "projectTaxRate"));
        vo.setDepartmentOne(this.baseDataUtil.comSelectValue(vo.getDepartmentOne(), ""));
        if (!StrUtil.isBlank((CharSequence)vo.getContractId())) {
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)projectEntity.getContractId()));
            vo.setSaler(byId.getSalerName());
            vo.setSaleDepartment(byId.getDepartmentName());
            vo.setCustomerName(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)byId.getCustomerId()))).getName());
        } else if (!StrUtil.isBlank((CharSequence)vo.getNoContractId())) {
            List<RkContractProductEntity> listByContractId = this.rkContractProductService.getListByContractId(vo.getNoContractId());
            String collect = listByContractId.stream().map(RkContractProductEntity::getProductName).collect(Collectors.joining(","));
            vo.setProductName(collect);
            SaleNoContractEntity noContract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)vo.getNoContractId()));
            if (ObjectUtil.isNotEmpty((Object)noContract)) {
                vo.setContractCode(noContract.getContractCode());
                vo.setCustomerName(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)noContract.getCustomerId()))).getName());
                vo.setIsAgent(0);
                vo.setAgentName(vo.getCustomerName());
                vo.setContractName(noContract.getContractName());
                vo.setContractAmount(noContract.getExpectedContractAmount());
            }
        }
        vo.setRemark(entity.getRemark());
        return ActionResult.success((Object)vo);
    }
}

