/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectPlanDetailEntity;
import com.bringspring.contract.entity.RkProjectTaskEntity;
import com.bringspring.contract.model.RkProjectTaskDetailCrForm;
import com.bringspring.contract.model.rk_project_plan.RkProjectPlanDetailModel;
import com.bringspring.contract.model.rkprojecttask.RkProjectTaskCrForm;
import com.bringspring.contract.model.rkprojecttask.RkProjectTaskInfoVO;
import com.bringspring.contract.model.rkprojecttask.RkProjectTaskListVO;
import com.bringspring.contract.model.rkprojecttask.RkProjectTaskPagination;
import com.bringspring.contract.model.rkprojecttask.RkProjectTaskUpForm;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectPlanDetailService;
import com.bringspring.contract.service.RkProjectTaskDetailService;
import com.bringspring.contract.service.RkProjectTaskService;
import com.bringspring.contract.utils.ProjectTaskStateEnum;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.MessageUtils;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u4efb\u52a1"}, value="contract")
@RequestMapping(value={"/api/contract/RkProjectTask"})
public class RkProjectTaskController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectTaskController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectTaskService rkProjectTaskService;
    @Autowired
    private RkProjectTaskDetailService rkProjectTaskDetailService;
    @Autowired
    private RkProjectPlanDetailService rkProjectPlanDetailService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private MessageUtils messageUtils;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectTaskPagination rkProjectTaskPagination) throws IOException {
        List<RkProjectTaskEntity> list = this.rkProjectTaskService.getList(rkProjectTaskPagination);
        List listVO = JsonUtil.getJsonToList(list, RkProjectTaskListVO.class);
        for (RkProjectTaskListVO vo : listVO) {
            vo.setType(this.baseDataUtil.getDictName(vo.getType(), "projectTaskType"));
            RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)vo.getProjectId()));
            if (ObjectUtil.isNotNull((Object)byId)) {
                vo.setProjectId(byId.getProjectName());
            }
            vo.setExecutorUser(this.baseDataUtil.userSelectValue(vo.getExecutorUser()));
            vo.setAssistantsUser(this.baseDataUtil.userSelectValue(vo.getAssistantsUser()));
            if (StrUtil.isBlank((CharSequence)vo.getState())) {
                Long startTime = null;
                Long endTime = null;
                if (ObjectUtil.isNotNull((Object)vo.getPlanStartTime()) && vo.getPlanStartTime() > 0L) {
                    startTime = vo.getPlanStartTime();
                }
                if (ObjectUtil.isNotNull((Object)vo.getPlanEndTime()) && vo.getPlanEndTime() > 0L) {
                    endTime = vo.getPlanEndTime();
                }
                if (ObjectUtil.isNotNull(startTime) && startTime > DateUtil.date().getTime()) {
                    vo.setState(ProjectTaskStateEnum.not_start.getResult());
                    vo.setStateCode(vo.getState());
                    vo.setState(this.baseDataUtil.getDictName(vo.getState(), "projectTaskState"));
                    continue;
                }
                if (ObjectUtil.isNotNull(endTime) && endTime < DateUtil.date().getTime()) {
                    vo.setState(ProjectTaskStateEnum.overdue.getResult());
                    vo.setStateCode(vo.getState());
                    vo.setState(this.baseDataUtil.getDictName(vo.getState(), "projectTaskState"));
                    continue;
                }
                if (!ObjectUtil.isNotNull((Object)startTime)) continue;
                vo.setState(ProjectTaskStateEnum.ing.getResult());
                vo.setStateCode(vo.getState());
                vo.setState(this.baseDataUtil.getDictName(vo.getState(), "projectTaskState"));
                continue;
            }
            vo.setStateCode(vo.getState());
            vo.setState(this.baseDataUtil.getDictName(vo.getState(), "projectTaskState"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectTaskPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"getByProjectId/{projectId}"})
    public ActionResult getByProjectId(@PathVariable(value="projectId") String projectId) {
        List<RkProjectPlanDetailEntity> detailEntityList = this.rkProjectPlanDetailService.listByProjectId(projectId);
        List jsonToList = JsonUtil.getJsonToList(detailEntityList, RkProjectPlanDetailModel.class);
        for (RkProjectPlanDetailModel detailModel : jsonToList) {
            detailModel.setDescription(detailModel.getContent());
            List<RkProjectTaskEntity> rkProjectTaskEntities = this.rkProjectTaskService.listByPlanDetailId(detailModel.getId());
            List taskInfoVOList = JsonUtil.getJsonToList(rkProjectTaskEntities, RkProjectTaskInfoVO.class);
            for (int i = 0; i < taskInfoVOList.size(); ++i) {
                RkProjectTaskInfoVO vo = (RkProjectTaskInfoVO)taskInfoVOList.get(i);
                vo.setIndex(i + 1);
                vo.setType(this.baseDataUtil.getDictName(vo.getType(), "projectTaskType"));
                vo.setExecutorUser(this.baseDataUtil.userSelectValue(vo.getExecutorUser()));
                vo.setAssistantsUser(this.baseDataUtil.userSelectValue(vo.getAssistantsUser()));
                if (!StrUtil.isBlank((CharSequence)vo.getState())) continue;
                Long startTime = null;
                Long endTime = null;
                if (ObjectUtil.isNotNull((Object)vo.getPlanStartTime()) && vo.getPlanStartTime() > 0L) {
                    startTime = vo.getPlanStartTime();
                }
                if (ObjectUtil.isNotNull((Object)vo.getPlanEndTime()) && vo.getPlanEndTime() > 0L) {
                    endTime = vo.getPlanEndTime();
                }
                if (ObjectUtil.isNotNull(startTime) && startTime > DateUtil.date().getTime()) {
                    vo.setState(ProjectTaskStateEnum.not_start.getResult());
                    continue;
                }
                if (ObjectUtil.isNotNull(endTime) && endTime < DateUtil.date().getTime()) {
                    vo.setState(ProjectTaskStateEnum.overdue.getResult());
                    continue;
                }
                if (!ObjectUtil.isNotNull((Object)startTime)) continue;
                vo.setState(ProjectTaskStateEnum.ing.getResult());
            }
            detailModel.setTaskList(taskInfoVOList);
        }
        return ActionResult.success((Object)jsonToList);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid RkProjectTaskCrForm rkProjectTaskCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkProjectTaskCrForm.getProjectId()));
        RkProjectTaskEntity entity = (RkProjectTaskEntity)JsonUtil.getJsonToBean((Object)rkProjectTaskCrForm, RkProjectTaskEntity.class);
        entity.setId(mainId);
        entity.setProjectHeader(byId.getProjectHeader());
        entity.setRegionalHead(byId.getRegionalHead());
        entity.setProjectAssistantsUser(byId.getAssistantsUser());
        entity.setCompanyId(byId.getCompanyId());
        this.rkProjectTaskService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectTaskInfoVO> info(@PathVariable(value="id") String id) {
        RkProjectTaskEntity entity = this.rkProjectTaskService.getInfo(id);
        RkProjectTaskInfoVO vo = (RkProjectTaskInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectTaskInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkProjectTaskInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkProjectTaskEntity entity = this.rkProjectTaskService.getInfo(id);
        RkProjectTaskInfoVO vo = (RkProjectTaskInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectTaskInfoVO.class);
        vo.setType(this.baseDataUtil.getDictName(vo.getType(), "projectTaskType"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectTaskUpForm rkProjectTaskUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkProjectTaskEntity entity = this.rkProjectTaskService.getInfo(id);
        if (entity != null) {
            String description = rkProjectTaskUpForm.getDescription();
            String replace = StrUtil.replace((CharSequence)StrUtil.trim((CharSequence)description), (CharSequence)" ", (CharSequence)"");
            rkProjectTaskUpForm.setDescription(replace);
            RkProjectTaskEntity subentity = (RkProjectTaskEntity)JsonUtil.getJsonToBean((Object)rkProjectTaskUpForm, RkProjectTaskEntity.class);
            this.rkProjectTaskService.update(id, subentity);
            RkContractProjectEntity info = this.rkContractProjectService.getInfo(subentity.getProjectId());
            RkProjectTaskDetailCrForm rkProjectTaskDetailCrForm = new RkProjectTaskDetailCrForm();
            rkProjectTaskDetailCrForm.setProjectId(subentity.getProjectId());
            rkProjectTaskDetailCrForm.setCustomerId(info.getCustomerId());
            rkProjectTaskDetailCrForm.setTaskId(subentity.getId());
            rkProjectTaskDetailCrForm.setTaskName(subentity.getDescription());
            rkProjectTaskDetailCrForm.setTaskControls("\u4fee\u6539");
            this.rkProjectTaskDetailService.create(rkProjectTaskDetailCrForm);
            RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()));
            if (!(StrUtil.equals((CharSequence)this.userProvider.get().getUserId(), (CharSequence)projectEntity.getProjectHeader()) || ObjectUtil.equals((Object)entity.getPlanStartTime(), (Object)subentity.getPlanStartTime()) && ObjectUtil.equals((Object)entity.getPlanEndTime(), (Object)subentity.getPlanEndTime()) && StrUtil.equals((CharSequence)subentity.getDescription(), (CharSequence)entity.getDescription()))) {
                String title;
                String content = title = projectEntity.getProjectName() + "\u4e2d\u7684\u9879\u76ee\u4efb\u52a1\u53d1\u751f\u4e86\u53d8\u52a8\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8";
                this.pushToAssgin(title, content, projectEntity.getProjectHeader(), projectEntity.getProjectName(), "\u66f4\u65b0", id);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    public static void main(String[] args) {
        String s = "23423 222";
        System.out.println(StrUtil.replace((CharSequence)s, (CharSequence)" ", (CharSequence)""));
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public synchronized ActionResult delete(@PathVariable(value="id") String id) {
        RkProjectTaskEntity entity = this.rkProjectTaskService.getInfo(id);
        if (entity != null) {
            List list = CollectionUtil.list((boolean)false, (Object[])new String[]{ProjectTaskStateEnum.cancel.getResult(), ProjectTaskStateEnum.not_start.getResult(), ProjectTaskStateEnum.stop.getResult()});
            if (StrUtil.isBlank((CharSequence)entity.getState()) || !list.contains(entity.getState())) {
                return ActionResult.fail((String)"\u53ea\u6709\u672a\u5f00\u59cb\u3001\u5df2\u6682\u505c\u3001\u5df2\u53d6\u6d88\u7684\u53ef\u4ee5\u5220\u9664");
            }
            entity.setEnabledMark(0);
            this.rkProjectTaskService.updateById(entity);
            RkContractProjectEntity info = this.rkContractProjectService.getInfo(entity.getProjectId());
            RkProjectTaskDetailCrForm rkProjectTaskDetailCrForm = new RkProjectTaskDetailCrForm();
            rkProjectTaskDetailCrForm.setProjectId(entity.getProjectId());
            rkProjectTaskDetailCrForm.setCustomerId(info.getCustomerId());
            rkProjectTaskDetailCrForm.setTaskId(entity.getId());
            rkProjectTaskDetailCrForm.setTaskName(entity.getDescription());
            rkProjectTaskDetailCrForm.setTaskControls("\u5220\u9664");
            this.rkProjectTaskDetailService.create(rkProjectTaskDetailCrForm);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"complete"})
    public ActionResult complete(@RequestBody RkProjectTaskUpForm rkProjectTaskUpForm) {
        RkProjectTaskEntity entity = this.rkProjectTaskService.getInfo(rkProjectTaskUpForm.getId());
        if (entity != null) {
            entity.setState(ProjectTaskStateEnum.complete.getResult());
            entity.setActEndTime((Date)DateUtil.date((long)rkProjectTaskUpForm.getActTime().get(1)));
            entity.setActStartTime((Date)DateUtil.date((long)rkProjectTaskUpForm.getActTime().get(0)));
            entity.setCompleteRemark(rkProjectTaskUpForm.getCompleteRemark());
            this.rkProjectTaskService.updateById(entity);
            RkContractProjectEntity info = this.rkContractProjectService.getInfo(entity.getProjectId());
            RkProjectTaskDetailCrForm rkProjectTaskDetailCrForm = new RkProjectTaskDetailCrForm();
            rkProjectTaskDetailCrForm.setProjectId(entity.getProjectId());
            rkProjectTaskDetailCrForm.setCustomerId(info.getCustomerId());
            rkProjectTaskDetailCrForm.setTaskId(entity.getId());
            rkProjectTaskDetailCrForm.setTaskName(entity.getDescription());
            rkProjectTaskDetailCrForm.setTaskControls("\u5b8c\u6210");
            this.rkProjectTaskDetailService.create(rkProjectTaskDetailCrForm);
            RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()));
            if (!StrUtil.equals((CharSequence)this.userProvider.get().getUserId(), (CharSequence)projectEntity.getProjectHeader())) {
                String title;
                String content = title = projectEntity.getProjectName() + "\u4e2d\u7684\u9879\u76ee\u4efb\u52a1\u53d1\u751f\u4e86\u53d8\u52a8\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8";
                this.pushToAssgin(title, content, projectEntity.getProjectHeader(), projectEntity.getProjectName(), "\u5b8c\u6210", rkProjectTaskUpForm.getId());
            }
        }
        return ActionResult.success((String)"\u5b8c\u6210\u6210\u529f");
    }

    public void pushToAssgin(String title, String content, String userId, String name, String changeType, String id) {
        String userName = this.userProvider.get().getUserName();
        String taskCode = MessageTypeEnum.PROJECT_TASK_CHANGE_TEMPLATE.getMessage();
        String sendCode = MessageTypeEnum.PROJECT_TASK_CHANGE_TEMPLATE.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", title);
        keys.put("content", content);
        keys.put("name", name);
        keys.put("changeType", changeType);
        keys.put("changeUser", userName);
        keys.put("changeTime", com.bringspring.common.util.DateUtil.getNow());
        String appUrl = "/#/pages/project/projectTask/editForm?menuId=565513592036665349&jurisdictionType=btn_detail&id=" + id;
        String pcUrl = "/#/contract/project/task/index.vue?id=" + id;
        String termType = TermTypeEnum.TERM_APP_PC.getCode();
        this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, userId, termType, null);
    }
}

