/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkProjectTaskDetailEntity;
import com.bringspring.contract.model.RkProjectTaskDetailPagination;
import com.bringspring.contract.model.RkProjectTaskDetailVo;
import com.bringspring.contract.service.RkProjectTaskDetailService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.AfterSalesQuestionTrendsEntity;
import com.bringspring.visit.service.AfterSalesQuestionTrendsService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u4efb\u52a1\u64cd\u4f5c\u660e\u7ec6"}, value="contract")
@RequestMapping(value={"/api/contract/RkProjectTaskDetail"})
public class RkProjectTaskDetailController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectTaskDetailController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectTaskDetailService rkProjectTaskDetailService;
    @Autowired
    private AfterSalesQuestionTrendsService afterSalesQuestionTrendsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectTaskDetailPagination rkProjectTaskDetailPagination) throws IOException {
        List<RkProjectTaskDetailEntity> list = this.rkProjectTaskDetailService.getByProjectIdList(rkProjectTaskDetailPagination);
        RkProjectTaskDetailVo rkProjectTaskDetailVo = new RkProjectTaskDetailVo();
        rkProjectTaskDetailVo.setProjectCount(list.stream().map(RkProjectTaskDetailEntity::getProjectId).distinct().collect(Collectors.toList()).size());
        rkProjectTaskDetailVo.setCustomerCount(list.stream().map(RkProjectTaskDetailEntity::getCustomerId).distinct().collect(Collectors.toList()).size());
        rkProjectTaskDetailVo.setTaskDetailEntityList(list);
        return ActionResult.success((Object)rkProjectTaskDetailVo);
    }

    @PostMapping(value={"/getAfterSalesList"})
    public ActionResult afterSalesList(@RequestBody RkProjectTaskDetailPagination rkProjectTaskDetailPagination) throws IOException {
        List<AfterSalesQuestionTrendsEntity> list = this.afterSalesQuestionTrendsService.getByDailyPaperDateList(rkProjectTaskDetailPagination);
        RkProjectTaskDetailVo rkProjectTaskDetailVo = new RkProjectTaskDetailVo();
        rkProjectTaskDetailVo.setAfterSalesAddCount(list.stream().filter(x -> StrUtil.equals((CharSequence)x.getType(), (CharSequence)"create")).distinct().collect(Collectors.toList()).size());
        rkProjectTaskDetailVo.setResolvedCount(list.stream().filter(x -> StrUtil.equals((CharSequence)x.getType(), (CharSequence)"resolved")).distinct().collect(Collectors.toList()).size());
        return ActionResult.success((Object)rkProjectTaskDetailVo);
    }
}

