/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkProjectTrendsEntity;
import com.bringspring.contract.model.rkprojecttrends.RkProjectTrendsCrForm;
import com.bringspring.contract.model.rkprojecttrends.RkProjectTrendsInfoVO;
import com.bringspring.contract.model.rkprojecttrends.RkProjectTrendsListVO;
import com.bringspring.contract.model.rkprojecttrends.RkProjectTrendsPagination;
import com.bringspring.contract.model.rkprojecttrends.RkProjectTrendsUpForm;
import com.bringspring.contract.service.RkProjectTrendsService;
import com.bringspring.contract.utils.ProjectTrendsEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u52a8\u6001\u8bb0\u5f55"}, value="contract")
@RequestMapping(value={"/api/contract/RkProjectTrends"})
public class RkProjectTrendsController {
    private static final Logger log = LoggerFactory.getLogger(RkProjectTrendsController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectTrendsService rkProjectTrendsService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProjectTrendsPagination rkProjectTrendsPagination) throws IOException {
        List<RkProjectTrendsEntity> list = this.rkProjectTrendsService.getList(rkProjectTrendsPagination);
        for (RkProjectTrendsEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkProjectTrendsListVO.class);
        for (RkProjectTrendsListVO rkProjectTrendsListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProjectTrendsPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid RkProjectTrendsCrForm rkProjectTrendsCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkProjectTrendsEntity entity = (RkProjectTrendsEntity)JsonUtil.getJsonToBean((Object)rkProjectTrendsCrForm, RkProjectTrendsEntity.class);
        entity.setId(mainId);
        this.rkProjectTrendsService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectTrendsInfoVO> info(@PathVariable(value="id") String id) {
        RkProjectTrendsEntity entity = this.rkProjectTrendsService.getInfo(id);
        RkProjectTrendsInfoVO vo = (RkProjectTrendsInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectTrendsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkProjectTrendsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkProjectTrendsEntity entity = this.rkProjectTrendsService.getInfo(id);
        RkProjectTrendsInfoVO vo = (RkProjectTrendsInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectTrendsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProjectTrendsUpForm rkProjectTrendsUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkProjectTrendsEntity entity = this.rkProjectTrendsService.getInfo(id);
        if (entity != null) {
            RkProjectTrendsEntity subentity = (RkProjectTrendsEntity)JsonUtil.getJsonToBean((Object)rkProjectTrendsUpForm, RkProjectTrendsEntity.class);
            this.rkProjectTrendsService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProjectTrendsEntity entity = this.rkProjectTrendsService.getInfo(id);
        if (entity != null) {
            this.rkProjectTrendsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"getByProjectId/{projectId}/{isAssign}"})
    public ActionResult getByProjectId(@PathVariable(value="projectId") String projectId, @PathVariable(value="isAssign") Integer isAssign) {
        List<RkProjectTrendsEntity> list = this.rkProjectTrendsService.getListByProjectId(projectId, isAssign);
        Map<String, ProjectTrendsEnum> allToMap = ProjectTrendsEnum.getAllToMap();
        for (RkProjectTrendsEntity entity : list) {
            entity.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(entity.getCreatorUserId()));
            if (!ObjectUtil.isNotNull((Object)((Object)allToMap.get(entity.getNodeType())))) continue;
            entity.setNodeType(allToMap.get(entity.getNodeType()).getDesc());
        }
        return ActionResult.success(list);
    }
}

