/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractProjectHelpEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkReturnPlanFollowEntity;
import com.bringspring.contract.model.rkattachment.RkAttachmentListVO;
import com.bringspring.contract.model.rkreturnplanfollow.RkReturnPlanFollowCrForm;
import com.bringspring.contract.model.rkreturnplanfollow.RkReturnPlanFollowInfoVO;
import com.bringspring.contract.model.rkreturnplanfollow.RkReturnPlanFollowListVO;
import com.bringspring.contract.model.rkreturnplanfollow.RkReturnPlanFollowPagination;
import com.bringspring.contract.model.rkreturnplanfollow.RkReturnPlanFollowUpForm;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectHelpService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkReturnPlanFollowService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56de\u6b3e\u8ba1\u5212\u8ddf\u8fdb\u8bb0\u5f55"}, value="contract")
@RequestMapping(value={"/api/contract/RkReturnPlanFollow"})
public class RkReturnPlanFollowController {
    private static final Logger log = LoggerFactory.getLogger(RkReturnPlanFollowController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkReturnPlanFollowService rkReturnPlanFollowService;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private RkContractProjectHelpService rkContractProjectHelpService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkReturnPlanFollowPagination rkReturnPlanFollowPagination) throws IOException {
        List<RkReturnPlanFollowEntity> list = this.rkReturnPlanFollowService.getList(rkReturnPlanFollowPagination);
        List listVO = JsonUtil.getJsonToList(list, RkReturnPlanFollowListVO.class);
        for (RkReturnPlanFollowListVO rkReturnPlanMarkListVO : listVO) {
            List<String> products;
            List<CrmProductEntity> infoByListId;
            RkContractReturnPlanEntity byId = (RkContractReturnPlanEntity)this.rkContractReturnPlanService.getById((Serializable)((Object)rkReturnPlanMarkListVO.getPlanId()));
            RkContractEntity rkContractEntity = null;
            if (StrUtil.isNotEmpty((CharSequence)byId.getContractId())) {
                rkContractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)byId.getContractId()));
            }
            if (ObjectUtil.isNotNull(rkContractEntity)) {
                rkReturnPlanMarkListVO.setContractCode(rkContractEntity.getContractCode());
                rkReturnPlanMarkListVO.setContractAmount(rkContractEntity.getContractAmount());
            }
            RkContractProjectEntity rkContractProjectEntity = null;
            if (StrUtil.isNotEmpty((CharSequence)byId.getProjectId())) {
                rkContractProjectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)byId.getProjectId()));
            }
            rkReturnPlanMarkListVO.setFeedBackSourceName(this.baseDataUtil.getDictName(rkReturnPlanMarkListVO.getFeedBackSource(), "feedBackSource"));
            if (ObjectUtil.isNotNull((Object)rkContractProjectEntity)) {
                rkReturnPlanMarkListVO.setProjectCode(rkContractProjectEntity.getProjectCode());
                rkReturnPlanMarkListVO.setProjectAmount(rkContractProjectEntity.getProjectAmount());
            }
            if (ObjectUtil.isNotEmpty((Object)rkReturnPlanMarkListVO.getProjectHelpId())) {
                RkContractProjectHelpEntity helpEntity = (RkContractProjectHelpEntity)this.rkContractProjectHelpService.getById((Serializable)((Object)rkReturnPlanMarkListVO.getProjectHelpId()));
                rkReturnPlanMarkListVO.setCompleteTime(helpEntity.getCreatorTime());
                rkReturnPlanMarkListVO.setCompleteDescribe(helpEntity.getCompleteDescribe());
                if (rkReturnPlanMarkListVO.getCompleteState() == 1) {
                    rkReturnPlanMarkListVO.setCompleteStateName("\u662f");
                } else if (rkReturnPlanMarkListVO.getCompleteState() == 0) {
                    rkReturnPlanMarkListVO.setCompleteStateName("\u5426");
                } else {
                    rkReturnPlanMarkListVO.setCompleteStateName("");
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)rkReturnPlanMarkListVO.getProduct()) && CollectionUtil.isNotEmpty(infoByListId = this.crmProductService.getInfoByListId((products = Arrays.asList(rkReturnPlanMarkListVO.getProduct())).toString()))) {
                rkReturnPlanMarkListVO.setProduct(infoByListId.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(",")));
            }
            List<RkAttachmentEntity> listByObjId = this.rkAttachmentService.getListByObjId(rkReturnPlanMarkListVO.getId());
            List jsonToList = JsonUtil.getJsonToList(listByObjId, RkAttachmentListVO.class);
            rkReturnPlanMarkListVO.setAttachmentList(jsonToList);
            rkReturnPlanMarkListVO.setPaymentType(ObjectUtil.isNull((Object)byId) ? "" : this.baseDataUtil.getDictName(byId.getPaymentType(), Constants.RETURN_PLAN_PAYMENT_TYPE_DICT_ID));
            rkReturnPlanMarkListVO.setCreatorUserId(this.baseDataUtil.userSelectValues(rkReturnPlanMarkListVO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkReturnPlanFollowPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @RepeatSubmit
    @ResponseBody
    public ActionResult create(@RequestBody @Valid RkReturnPlanFollowCrForm rkReturnPlanFollowCrForm) throws DataException {
        this.rkReturnPlanFollowService.create(rkReturnPlanFollowCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/updateFile/{id}"})
    @DSTransactional
    public ActionResult updateFile(@PathVariable(value="id") String id, @RequestBody @Valid RkReturnPlanFollowUpForm rkReturnPlanFollowUpForm) {
        Object object = this.$lock;
        synchronized (object) {
            RkReturnPlanFollowEntity entity = this.rkReturnPlanFollowService.getInfo(id);
            if (entity != null) {
                this.rkReturnPlanFollowService.updateFollow(id, rkReturnPlanFollowUpForm);
                return ActionResult.success((String)"\u64cd\u4f5c\u6210\u529f");
            }
            return ActionResult.fail((String)"\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkReturnPlanFollowInfoVO> info(@PathVariable(value="id") String id) {
        RkReturnPlanFollowEntity entity = this.rkReturnPlanFollowService.getInfo(id);
        RkReturnPlanFollowInfoVO vo = (RkReturnPlanFollowInfoVO)JsonUtil.getJsonToBean((Object)entity, RkReturnPlanFollowInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkReturnPlanFollowInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkReturnPlanFollowEntity entity = this.rkReturnPlanFollowService.getInfo(id);
        RkReturnPlanFollowInfoVO vo = (RkReturnPlanFollowInfoVO)JsonUtil.getJsonToBean((Object)entity, RkReturnPlanFollowInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkReturnPlanFollowUpForm rkReturnPlanFollowUpForm) throws DataException {
        this.rkReturnPlanFollowService.updateFollow(id, rkReturnPlanFollowUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkReturnPlanFollowEntity entity = this.rkReturnPlanFollowService.getInfo(id);
        if (entity != null) {
            this.rkReturnPlanFollowService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

