/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkReturnPlanMarkEntity;
import com.bringspring.contract.model.rkreturnplanmark.RkReturnPlanMarkCrForm;
import com.bringspring.contract.model.rkreturnplanmark.RkReturnPlanMarkInfoVO;
import com.bringspring.contract.model.rkreturnplanmark.RkReturnPlanMarkListVO;
import com.bringspring.contract.model.rkreturnplanmark.RkReturnPlanMarkPagination;
import com.bringspring.contract.model.rkreturnplanmark.RkReturnPlanMarkUpForm;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkReturnPlanMarkService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56de\u6b3e\u8ba1\u5212\u6807\u8bb0\u8bb0\u5f55"}, value="contract")
@RequestMapping(value={"/api/contract/RkReturnPlanMark"})
public class RkReturnPlanMarkController {
    private static final Logger log = LoggerFactory.getLogger(RkReturnPlanMarkController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkReturnPlanMarkService rkReturnPlanMarkService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkReturnPlanMarkPagination rkReturnPlanMarkPagination) throws IOException {
        List<RkReturnPlanMarkEntity> list = this.rkReturnPlanMarkService.getList(rkReturnPlanMarkPagination);
        List listVO = JsonUtil.getJsonToList(list, RkReturnPlanMarkListVO.class);
        for (RkReturnPlanMarkListVO rkReturnPlanMarkListVO : listVO) {
            RkContractReturnPlanEntity byId = (RkContractReturnPlanEntity)this.rkContractReturnPlanService.getById((Serializable)((Object)rkReturnPlanMarkListVO.getPlanId()));
            RkContractEntity rkContractEntity = null;
            if (StrUtil.isNotEmpty((CharSequence)byId.getContractId())) {
                rkContractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)byId.getContractId()));
            }
            if (ObjectUtil.isNotNull(rkContractEntity)) {
                rkReturnPlanMarkListVO.setContractCode(rkContractEntity.getContractCode());
                rkReturnPlanMarkListVO.setContractAmount(rkContractEntity.getContractAmount());
            }
            RkContractProjectEntity rkContractProjectEntity = null;
            if (StrUtil.isNotEmpty((CharSequence)byId.getProjectId())) {
                rkContractProjectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)byId.getProjectId()));
            }
            if (ObjectUtil.isNotNull(rkContractProjectEntity)) {
                rkReturnPlanMarkListVO.setProjectCode(rkContractProjectEntity.getProjectCode());
                rkReturnPlanMarkListVO.setProjectAmount(rkContractProjectEntity.getProjectAmount());
            }
            rkReturnPlanMarkListVO.setPaymentType(ObjectUtil.isNull((Object)byId) ? "" : this.baseDataUtil.getDictName(byId.getPaymentType(), Constants.RETURN_PLAN_PAYMENT_TYPE_DICT_ID));
            rkReturnPlanMarkListVO.setCreatorUserId(this.baseDataUtil.userSelectValues(rkReturnPlanMarkListVO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkReturnPlanMarkPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @RepeatSubmit
    public ActionResult create(@RequestBody @Valid RkReturnPlanMarkCrForm rkReturnPlanMarkCrForm) throws DataException {
        this.rkReturnPlanMarkService.create(rkReturnPlanMarkCrForm);
        return ActionResult.success((String)"\u6807\u8bb0\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkReturnPlanMarkInfoVO> info(@PathVariable(value="id") String id) {
        RkReturnPlanMarkEntity entity = this.rkReturnPlanMarkService.getInfo(id);
        RkReturnPlanMarkInfoVO vo = (RkReturnPlanMarkInfoVO)JsonUtil.getJsonToBean((Object)entity, RkReturnPlanMarkInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkReturnPlanMarkInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkReturnPlanMarkEntity entity = this.rkReturnPlanMarkService.getInfo(id);
        RkReturnPlanMarkInfoVO vo = (RkReturnPlanMarkInfoVO)JsonUtil.getJsonToBean((Object)entity, RkReturnPlanMarkInfoVO.class);
        vo.setMark(this.baseDataUtil.getDictName(vo.getMark(), "636195123457236357"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkReturnPlanMarkUpForm rkReturnPlanMarkUpForm) throws DataException {
        this.rkReturnPlanMarkService.updatePlan(id, rkReturnPlanMarkUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkReturnPlanMarkEntity entity = this.rkReturnPlanMarkService.getInfo(id);
        if (entity != null) {
            this.rkReturnPlanMarkService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

