/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkReturnPlanSalerEntity;
import com.bringspring.contract.model.rkreturnplansaler.RkReturnPlanSalerCrForm;
import com.bringspring.contract.model.rkreturnplansaler.RkReturnPlanSalerInfoVO;
import com.bringspring.contract.model.rkreturnplansaler.RkReturnPlanSalerListVO;
import com.bringspring.contract.model.rkreturnplansaler.RkReturnPlanSalerPagination;
import com.bringspring.contract.model.rkreturnplansaler.RkReturnPlanSalerUpForm;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkReturnPlanSalerService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56de\u6b3e\u8ba1\u5212\u5bf9\u63a5\u4eba\u8c03\u6574\u8bb0\u5f55"}, value="contract")
@RequestMapping(value={"/api/contract/RkReturnPlanSaler"})
public class RkReturnPlanSalerController {
    private static final Logger log = LoggerFactory.getLogger(RkReturnPlanSalerController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkReturnPlanSalerService rkReturnPlanSalerService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkReturnPlanSalerPagination rkReturnPlanSalerPagination) throws IOException {
        List<RkReturnPlanSalerEntity> list = this.rkReturnPlanSalerService.getList(rkReturnPlanSalerPagination);
        List listVO = JsonUtil.getJsonToList(list, RkReturnPlanSalerListVO.class);
        for (RkReturnPlanSalerListVO rkReturnPlanSalerVO : listVO) {
            RkContractReturnPlanEntity byId = (RkContractReturnPlanEntity)this.rkContractReturnPlanService.getById((Serializable)((Object)rkReturnPlanSalerVO.getPlanId()));
            RkContractEntity rkContractEntity = null;
            if (StrUtil.isNotEmpty((CharSequence)byId.getContractId())) {
                rkContractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)byId.getContractId()));
            }
            if (ObjectUtil.isNotNull(rkContractEntity)) {
                rkReturnPlanSalerVO.setContractCode(rkContractEntity.getContractCode());
                rkReturnPlanSalerVO.setContractAmount(rkContractEntity.getContractAmount());
            }
            RkContractProjectEntity rkContractProjectEntity = null;
            if (StrUtil.isNotEmpty((CharSequence)byId.getProjectId())) {
                rkContractProjectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)byId.getProjectId()));
            }
            if (ObjectUtil.isNotNull(rkContractProjectEntity)) {
                rkReturnPlanSalerVO.setProjectCode(rkContractProjectEntity.getProjectCode());
                rkReturnPlanSalerVO.setProjectAmount(rkContractProjectEntity.getProjectAmount());
            }
            rkReturnPlanSalerVO.setPaymentType(ObjectUtil.isNull((Object)byId) ? "" : this.baseDataUtil.getDictName(byId.getPaymentType(), Constants.RETURN_PLAN_PAYMENT_TYPE_DICT_ID));
            rkReturnPlanSalerVO.setCreatorUserId(this.baseDataUtil.userSelectValues(rkReturnPlanSalerVO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkReturnPlanSalerPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @RepeatSubmit
    public ActionResult create(@RequestBody @Valid RkReturnPlanSalerCrForm rkReturnPlanSalerCrForm) throws DataException {
        this.rkReturnPlanSalerService.create(rkReturnPlanSalerCrForm);
        return ActionResult.success((String)"\u53d8\u66f4\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkReturnPlanSalerInfoVO> info(@PathVariable(value="id") String id) {
        RkReturnPlanSalerEntity entity = this.rkReturnPlanSalerService.getInfo(id);
        RkReturnPlanSalerInfoVO vo = (RkReturnPlanSalerInfoVO)JsonUtil.getJsonToBean((Object)entity, RkReturnPlanSalerInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkReturnPlanSalerInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkReturnPlanSalerEntity entity = this.rkReturnPlanSalerService.getInfo(id);
        RkReturnPlanSalerInfoVO vo = (RkReturnPlanSalerInfoVO)JsonUtil.getJsonToBean((Object)entity, RkReturnPlanSalerInfoVO.class);
        vo.setSalerId(this.baseDataUtil.userSelectValues(vo.getSalerId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkReturnPlanSalerUpForm rkReturnPlanSalerUpForm) throws DataException {
        this.rkReturnPlanSalerService.updateSaler(id, rkReturnPlanSalerUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkReturnPlanSalerEntity entity = this.rkReturnPlanSalerService.getInfo(id);
        if (entity != null) {
            this.rkReturnPlanSalerService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

