/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkReturnPlanTrackingEntity;
import com.bringspring.contract.model.rkreturnplantracking.RkReturnPlanTrackingCrForm;
import com.bringspring.contract.model.rkreturnplantracking.RkReturnPlanTrackingInfoVO;
import com.bringspring.contract.model.rkreturnplantracking.RkReturnPlanTrackingListVO;
import com.bringspring.contract.model.rkreturnplantracking.RkReturnPlanTrackingPagination;
import com.bringspring.contract.model.rkreturnplantracking.RkReturnPlanTrackingUpForm;
import com.bringspring.contract.service.RkReturnPlanTrackingService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56de\u6b3e\u8ba1\u5212\u8ddf\u8e2a\u8bb0\u5f55"}, value="contract")
@RequestMapping(value={"/api/contract/RkReturnPlanTracking"})
public class RkReturnPlanTrackingController {
    private static final Logger log = LoggerFactory.getLogger(RkReturnPlanTrackingController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkReturnPlanTrackingService rkReturnPlanTrackingService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkReturnPlanTrackingPagination rkReturnPlanTrackingPagination) throws IOException {
        List<RkReturnPlanTrackingEntity> list = this.rkReturnPlanTrackingService.getList(rkReturnPlanTrackingPagination);
        for (RkReturnPlanTrackingEntity entity : list) {
            entity.setNotReturnType(this.baseDataUtil.getDictName(entity.getNotReturnType(), "notReturnType"));
            entity.setCommunicationProgress(this.baseDataUtil.getDictName(entity.getCommunicationProgress(), "communicationProgress"));
            entity.setTrackingPersonnel(this.baseDataUtil.userSelectValueNoAccount(entity.getTrackingPersonnel()));
            entity.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(entity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, RkReturnPlanTrackingListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkReturnPlanTrackingPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @DSTransactional
    @RepeatSubmit
    public ActionResult create(@RequestBody @Valid RkReturnPlanTrackingCrForm rkReturnPlanTrackingCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            RkReturnPlanTrackingEntity entity = (RkReturnPlanTrackingEntity)JsonUtil.getJsonToBean((Object)rkReturnPlanTrackingCrForm, RkReturnPlanTrackingEntity.class);
            entity.setId(mainId);
            this.rkReturnPlanTrackingService.save(entity);
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkReturnPlanTrackingInfoVO> info(@PathVariable(value="id") String id) {
        RkReturnPlanTrackingEntity entity = this.rkReturnPlanTrackingService.getInfo(id);
        RkReturnPlanTrackingInfoVO vo = (RkReturnPlanTrackingInfoVO)JsonUtil.getJsonToBean((Object)entity, RkReturnPlanTrackingInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkReturnPlanTrackingInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkReturnPlanTrackingEntity entity = this.rkReturnPlanTrackingService.getInfo(id);
        RkReturnPlanTrackingInfoVO vo = (RkReturnPlanTrackingInfoVO)JsonUtil.getJsonToBean((Object)entity, RkReturnPlanTrackingInfoVO.class);
        vo.setNotReturnType(this.baseDataUtil.getDictName(vo.getNotReturnType(), null));
        vo.setTrackingPersonnel(this.baseDataUtil.userSelectValues(vo.getTrackingPersonnel()));
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/{id}"})
    @DSTransactional
    @RepeatSubmit
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkReturnPlanTrackingUpForm rkReturnPlanTrackingUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkReturnPlanTrackingEntity entity = this.rkReturnPlanTrackingService.getInfo(id);
            if (entity != null) {
                RkReturnPlanTrackingEntity subentity = (RkReturnPlanTrackingEntity)JsonUtil.getJsonToBean((Object)rkReturnPlanTrackingUpForm, RkReturnPlanTrackingEntity.class);
                this.rkReturnPlanTrackingService.update(id, subentity);
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkReturnPlanTrackingEntity entity = this.rkReturnPlanTrackingService.getInfo(id);
            if (entity != null) {
                this.rkReturnPlanTrackingService.delete(entity);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }
}

