/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkSaleCompanyPersonEntity;
import com.bringspring.contract.model.rksalecompanyperson.RkSaleCompanyPersonCrForm;
import com.bringspring.contract.model.rksalecompanyperson.RkSaleCompanyPersonInfoVO;
import com.bringspring.contract.model.rksalecompanyperson.RkSaleCompanyPersonListVO;
import com.bringspring.contract.model.rksalecompanyperson.RkSaleCompanyPersonPagination;
import com.bringspring.contract.model.rksalecompanyperson.RkSaleCompanyPersonUpForm;
import com.bringspring.contract.service.RkSaleCompanyPersonService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u667a\u533b\u5bf9\u63a5\u4eba"}, value="contract")
@RequestMapping(value={"/api/contract/RkSaleCompanyPerson"})
public class RkSaleCompanyPersonController {
    private static final Logger log = LoggerFactory.getLogger(RkSaleCompanyPersonController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkSaleCompanyPersonService rkSaleCompanyPersonService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkSaleCompanyPersonPagination rkSaleCompanyPersonPagination) throws IOException {
        List<RkSaleCompanyPersonEntity> list = this.rkSaleCompanyPersonService.getList(rkSaleCompanyPersonPagination);
        List listVO = JsonUtil.getJsonToList(list, RkSaleCompanyPersonListVO.class);
        for (RkSaleCompanyPersonListVO rkSaleCompanyPersonVO : listVO) {
            rkSaleCompanyPersonVO.setContractPersonId(this.baseDataUtil.userSelectValues(rkSaleCompanyPersonVO.getContractPersonId()));
            rkSaleCompanyPersonVO.setStatus(this.baseDataUtil.switchSelectValue(rkSaleCompanyPersonVO.getStatus(), "\u751f\u6548", "\u5173"));
            rkSaleCompanyPersonVO.setCreatorUserId(this.baseDataUtil.userSelectValue(rkSaleCompanyPersonVO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkSaleCompanyPersonPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid RkSaleCompanyPersonCrForm rkSaleCompanyPersonCrForm) throws DataException {
        this.rkSaleCompanyPersonService.create(rkSaleCompanyPersonCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/getSaleCompanyPerson/{companyId}/{saleCompanyId}"})
    public ActionResult<RkSaleCompanyPersonInfoVO> getSaleCompanyPerson(@PathVariable(value="companyId") String companyId, @PathVariable(value="saleCompanyId") String saleCompanyId) {
        RkSaleCompanyPersonEntity entity = this.rkSaleCompanyPersonService.getSaleCompanyPerson(companyId, saleCompanyId);
        RkSaleCompanyPersonInfoVO vo = (RkSaleCompanyPersonInfoVO)JsonUtil.getJsonToBean((Object)entity, RkSaleCompanyPersonInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkSaleCompanyPersonInfoVO> info(@PathVariable(value="id") String id) {
        RkSaleCompanyPersonEntity entity = this.rkSaleCompanyPersonService.getInfo(id);
        RkSaleCompanyPersonInfoVO vo = (RkSaleCompanyPersonInfoVO)JsonUtil.getJsonToBean((Object)entity, RkSaleCompanyPersonInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkSaleCompanyPersonInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkSaleCompanyPersonEntity entity = this.rkSaleCompanyPersonService.getInfo(id);
        RkSaleCompanyPersonInfoVO vo = (RkSaleCompanyPersonInfoVO)JsonUtil.getJsonToBean((Object)entity, RkSaleCompanyPersonInfoVO.class);
        vo.setSaleCompanyId(this.baseDataUtil.getDictName(vo.getSaleCompanyId(), "499248793733047493"));
        vo.setCompanyId(this.baseDataUtil.getDictName(vo.getCompanyId(), "643718528016370693"));
        vo.setContractPersonId(this.baseDataUtil.userSelectValues(vo.getContractPersonId()));
        vo.setStatus(this.baseDataUtil.switchSelectValue(vo.getStatus(), "\u5f0033333333333333333", "\u5173"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkSaleCompanyPersonUpForm rkSaleCompanyPersonUpForm) throws DataException {
        this.rkSaleCompanyPersonService.update(id, rkSaleCompanyPersonUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkSaleCompanyPersonEntity entity = this.rkSaleCompanyPersonService.getInfo(id);
        if (entity != null) {
            this.rkSaleCompanyPersonService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

