/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkSaleGoalTemplateEntity;
import com.bringspring.contract.entity.RkSalePlanEntity;
import com.bringspring.contract.model.rksalegoaltemplate.RkSaleGoalTemplateCrForm;
import com.bringspring.contract.model.rksalegoaltemplate.RkSaleGoalTemplateInfoVO;
import com.bringspring.contract.model.rksalegoaltemplate.RkSaleGoalTemplateListVO;
import com.bringspring.contract.model.rksalegoaltemplate.RkSaleGoalTemplatePagination;
import com.bringspring.contract.model.rksalegoaltemplate.RkSaleGoalTemplatePaginationExportModel;
import com.bringspring.contract.model.rksalegoaltemplate.RkSaleGoalTemplateUpForm;
import com.bringspring.contract.service.RkSaleGoalTemplateService;
import com.bringspring.contract.service.RkSalePlanService;
import com.bringspring.meeting.utils.ObjectComparator;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9500\u552e\u76ee\u6807\u6a21\u677f"}, value="contract")
@RequestMapping(value={"/api/contract/RkSaleGoalTemplate"})
public class RkSaleGoalTemplateController {
    private static final Logger log = LoggerFactory.getLogger(RkSaleGoalTemplateController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkSaleGoalTemplateService rkSaleGoalTemplateService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkSalePlanService rkSalePlanService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkSaleGoalTemplatePagination rkSaleGoalTemplatePagination) throws IOException {
        List<RkSaleGoalTemplateEntity> list = this.rkSaleGoalTemplateService.getList(rkSaleGoalTemplatePagination);
        List listVO = JsonUtil.getJsonToList(list, RkSaleGoalTemplateListVO.class);
        for (RkSaleGoalTemplateListVO rkSaleGoalTemplateVO : listVO) {
            String s = this.baseDataUtil.userSelectValue(rkSaleGoalTemplateVO.getCreatorUserId());
            rkSaleGoalTemplateVO.setCreatorUserName(s);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkSaleGoalTemplatePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid RkSaleGoalTemplateCrForm rkSaleGoalTemplateCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkSaleGoalTemplateEntity entity = (RkSaleGoalTemplateEntity)JsonUtil.getJsonToBean((Object)rkSaleGoalTemplateCrForm, RkSaleGoalTemplateEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        this.rkSaleGoalTemplateService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkSaleGoalTemplateInfoVO> info(@PathVariable(value="id") String id) {
        RkSaleGoalTemplateEntity entity = this.rkSaleGoalTemplateService.getInfo(id);
        RkSaleGoalTemplateInfoVO vo = (RkSaleGoalTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, RkSaleGoalTemplateInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkSaleGoalTemplateInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkSaleGoalTemplateEntity entity = this.rkSaleGoalTemplateService.getInfo(id);
        RkSaleGoalTemplateInfoVO vo = (RkSaleGoalTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, RkSaleGoalTemplateInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkSaleGoalTemplateUpForm rkSaleGoalTemplateUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkSaleGoalTemplateEntity entity = this.rkSaleGoalTemplateService.getInfo(id);
        if (entity != null) {
            boolean b;
            RkSaleGoalTemplateEntity subentity = (RkSaleGoalTemplateEntity)JsonUtil.getJsonToBean((Object)rkSaleGoalTemplateUpForm, RkSaleGoalTemplateEntity.class);
            Map<String, String> compare = ObjectComparator.compare(entity, subentity);
            ArrayList keyList = new ArrayList();
            if (ObjectUtil.isNotEmpty(compare)) {
                compare.keySet().stream().forEach(key -> keyList.add(key));
            }
            if (keyList.contains("templateYear") && (b = this.rkSaleGoalTemplateService.judgeUniqueByYear(subentity))) {
                return ActionResult.success((String)"duplication");
            }
            this.rkSaleGoalTemplateService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkSaleGoalTemplateEntity entity = this.rkSaleGoalTemplateService.getInfo(id);
        List<RkSalePlanEntity> listByYear = this.rkSalePlanService.getListById(entity.getId());
        if (ObjectUtil.isNotEmpty(listByYear)) {
            return ActionResult.success((String)"duplication");
        }
        if (entity != null) {
            this.rkSaleGoalTemplateService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkSaleGoalTemplatePaginationExportModel rkSaleGoalTemplatePaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkSaleGoalTemplatePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        DownloadVO vo = this.rkSaleGoalTemplateService.export(rkSaleGoalTemplatePaginationExportModel);
        return ActionResult.success((Object)vo);
    }
}

