/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkSaleGoalTemplateEntity;
import com.bringspring.contract.entity.RkSalePlanEntity;
import com.bringspring.contract.entity.RkSalePlanItemEntity;
import com.bringspring.contract.model.rksaleplan.RkSalePlanCrForm;
import com.bringspring.contract.model.rksaleplan.RkSalePlanInfoVO;
import com.bringspring.contract.model.rksaleplan.RkSalePlanListVO;
import com.bringspring.contract.model.rksaleplan.RkSalePlanPagination;
import com.bringspring.contract.model.rksaleplan.RkSalePlanPaginationExportModel;
import com.bringspring.contract.model.rksaleplan.RkSalePlanUpForm;
import com.bringspring.contract.model.rksaleplanitem.RkSalePlanItemModel;
import com.bringspring.contract.service.RkSaleGoalTemplateService;
import com.bringspring.contract.service.RkSalePlanItemService;
import com.bringspring.contract.service.RkSalePlanService;
import com.bringspring.meeting.utils.ObjectComparator;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9500\u552e\u8ba1\u5212\u8868"}, value="contract")
@RequestMapping(value={"/api/contract/RkSalePlan"})
public class RkSalePlanController {
    private static final Logger log = LoggerFactory.getLogger(RkSalePlanController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkSalePlanService rkSalePlanService;
    @Autowired
    private RkSalePlanItemService rkSalePlanItemService;
    @Autowired
    private RkSaleGoalTemplateService rkSaleGoalTemplateService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkSalePlanPagination rkSalePlanPagination) throws IOException {
        List<RkSalePlanEntity> list = this.rkSalePlanService.getList(rkSalePlanPagination);
        List listVO = JsonUtil.getJsonToList(list, RkSalePlanListVO.class);
        List<Object> parentListAndChildren = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)listVO)) {
            parentListAndChildren = this.rkSalePlanService.getParentListAndChildren(listVO);
        }
        PageListVO vo = new PageListVO();
        vo.setList(parentListAndChildren);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkSalePlanPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkSalePlanCrForm rkSalePlanCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkSalePlanEntity entity = (RkSalePlanEntity)JsonUtil.getJsonToBean((Object)rkSalePlanCrForm, RkSalePlanEntity.class);
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setId(mainId);
        List<RkSalePlanEntity> whetherRepeatByYear = this.rkSalePlanService.getWhetherRepeatByYear(entity);
        if (ObjectUtil.isNotEmpty(whetherRepeatByYear)) {
            return ActionResult.success((String)"duplication");
        }
        this.rkSalePlanService.save(entity);
        List RkSalePlanItemList = JsonUtil.getJsonToList(rkSalePlanCrForm.getRksaleplanitemList(), RkSalePlanItemEntity.class);
        for (RkSalePlanItemEntity entitys : RkSalePlanItemList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setPlanId(entity.getId());
            this.rkSalePlanItemService.save(entitys);
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkSalePlanPaginationExportModel rkSalePlanPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkSalePlanPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        DownloadVO vo = this.rkSalePlanService.exportData(rkSalePlanPaginationExportModel);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkSalePlanInfoVO> info(@PathVariable(value="id") String id) {
        RkSalePlanEntity entity = this.rkSalePlanService.getInfo(id);
        RkSalePlanInfoVO vo = (RkSalePlanInfoVO)JsonUtil.getJsonToBean((Object)entity, RkSalePlanInfoVO.class);
        RkSaleGoalTemplateEntity templateEntity = this.rkSaleGoalTemplateService.getInfo(entity.getTemplateId());
        vo.setTemplateName(templateEntity.getName());
        List<RkSalePlanItemEntity> RkSalePlanItemList = this.rkSalePlanService.GetRkSalePlanItemList(id);
        vo.setRkSalePlanItemList(JsonUtil.getJsonToList(RkSalePlanItemList, RkSalePlanItemModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkSalePlanInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkSalePlanEntity entity = this.rkSalePlanService.getInfo(id);
        RkSalePlanInfoVO vo = (RkSalePlanInfoVO)JsonUtil.getJsonToBean((Object)entity, RkSalePlanInfoVO.class);
        RkSalePlanInfoVO rkSalePlanInfoVO = this.rkSalePlanService.whetherCompleteTarget(id);
        return ActionResult.success((Object)rkSalePlanInfoVO);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkSalePlanUpForm rkSalePlanUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkSalePlanEntity entity = this.rkSalePlanService.getInfo(id);
        if (entity != null) {
            List<RkSalePlanEntity> whetherRepeatByYear;
            RkSalePlanEntity subentity = (RkSalePlanEntity)JsonUtil.getJsonToBean((Object)rkSalePlanUpForm, RkSalePlanEntity.class);
            Map<String, String> compare = ObjectComparator.compare(entity, subentity);
            ArrayList keyList = new ArrayList();
            if (ObjectUtil.isNotEmpty(compare)) {
                compare.keySet().stream().forEach(key -> keyList.add(key));
            }
            if ((keyList.contains("templateId") || keyList.contains("planYear") || keyList.contains("saleUserId")) && ObjectUtil.isNotEmpty(whetherRepeatByYear = this.rkSalePlanService.getWhetherRepeatByYear(subentity))) {
                return ActionResult.success((String)"duplication");
            }
            this.rkSalePlanService.update(id, subentity);
            QueryWrapper RkSalePlanItemqueryWrapper = new QueryWrapper();
            RkSalePlanItemqueryWrapper.lambda().eq(RkSalePlanItemEntity::getPlanId, (Object)entity.getId());
            this.rkSalePlanItemService.remove((Wrapper)RkSalePlanItemqueryWrapper);
            List RkSalePlanItemList = JsonUtil.getJsonToList(rkSalePlanUpForm.getRksaleplanitemList(), RkSalePlanItemEntity.class);
            for (RkSalePlanItemEntity entitys : RkSalePlanItemList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setPlanId(entity.getId());
                this.rkSalePlanItemService.save(entitys);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkSalePlanEntity entity = this.rkSalePlanService.getInfo(id);
        if (entity != null) {
            this.rkSalePlanService.delete(entity);
            QueryWrapper queryWrapperRkSalePlanItem = new QueryWrapper();
            queryWrapperRkSalePlanItem.lambda().eq(RkSalePlanItemEntity::getPlanId, (Object)entity.getId());
            this.rkSalePlanItemService.remove((Wrapper)queryWrapperRkSalePlanItem);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/getWhetherRepeatByYear"})
    @DSTransactional
    public ActionResult getWhetherRepeatByYear(@RequestBody @Valid RkSalePlanUpForm rkSalePlanUpForm) {
        RkSalePlanEntity jsonToBean = (RkSalePlanEntity)JsonUtil.getJsonToBean((Object)rkSalePlanUpForm, RkSalePlanEntity.class);
        List<RkSalePlanEntity> whetherRepeatByYear = this.rkSalePlanService.getWhetherRepeatByYear(jsonToBean);
        if (ObjectUtil.isNotEmpty(whetherRepeatByYear) && whetherRepeatByYear.size() > 1) {
            return ActionResult.success((String)"duplication");
        }
        return ActionResult.success((String)"success");
    }
}

