/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.SaleConfirmIncomeEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.model.rkcontract.RkContractListVO;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.model.saleconfirmincome.SaleConfirmIncomeCrForm;
import com.bringspring.contract.model.saleconfirmincome.SaleConfirmIncomeInfoVO;
import com.bringspring.contract.model.saleconfirmincome.SaleConfirmIncomeListQuery;
import com.bringspring.contract.model.saleconfirmincome.SaleConfirmIncomeListVO;
import com.bringspring.contract.model.saleconfirmincome.SaleConfirmIncomePagination;
import com.bringspring.contract.model.saleconfirmincome.SaleConfirmIncomePaginationExportModel;
import com.bringspring.contract.model.saleconfirmincome.SaleConfirmIncomeUpForm;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectAcceptService;
import com.bringspring.contract.service.SaleConfirmIncomeService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ProjectStateEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.ecs.exception.VoucherPushException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u786e\u8ba4\u6536\u5165"}, value="contract")
@RequestMapping(value={"/api/contract/SaleConfirmIncome"})
public class SaleConfirmIncomeController {
    private static final Logger log = LoggerFactory.getLogger(SaleConfirmIncomeController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private SaleConfirmIncomeService saleConfirmIncomeService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private RkProjectAcceptService rkProjectAcceptService;
    @Autowired
    private RkAgentService rkAgentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SaleConfirmIncomePagination saleConfirmIncomePagination) throws IOException {
        List<SaleConfirmIncomeEntity> list = this.saleConfirmIncomeService.getList(saleConfirmIncomePagination);
        List<SaleConfirmIncomeListVO> listVO = this.appendListVo(list);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleConfirmIncomePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<SaleConfirmIncomeListVO> appendListVo(List<SaleConfirmIncomeEntity> list) {
        List listVO = JsonUtil.getJsonToList(list, SaleConfirmIncomeListVO.class);
        CrmCustomerEntity customer = null;
        RkContractEntity contract = null;
        SaleNoContractEntity noContract = null;
        Map<String, ProjectStateEnum> allToMap = ProjectStateEnum.getAllToMap();
        for (SaleConfirmIncomeListVO vo : listVO) {
            RkContractProjectEntity project;
            vo.setCompanyName(((OrganizeEntity)this.organizeService.getById((Serializable)((Object)vo.getCompanyId()))).getShortName());
            vo.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
            vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
            vo.setToBeConfirmedIncome(MathUtils.substract(vo.getSureIncome(), vo.getAllConfirmIncome()));
            if (StringUtils.isNotEmpty((String)vo.getCustomerId()) && null != (customer = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo.getCustomerId())))) {
                vo.setCustomerName(customer.getName());
            }
            if (!StrUtil.isBlank((CharSequence)vo.getContractId())) {
                contract = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)vo.getContractId()));
                if (null != contract) {
                    vo.setContractCode(contract.getContractCode());
                    vo.setContractName(contract.getContractName());
                }
            } else if (!StrUtil.isBlank((CharSequence)vo.getNoContractId()) && null != (noContract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)vo.getNoContractId())))) {
                vo.setContractCode(noContract.getContractCode());
                vo.setContractName(noContract.getContractName());
            }
            if (null == (project = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)vo.getProjectId())))) continue;
            vo.setProjectName(project.getProjectName());
            vo.setProjectCode(project.getProjectCode());
        }
        return listVO;
    }

    @GetMapping(value={"/initData/{projectId}"})
    public ActionResult<SaleConfirmIncomeInfoVO> initData(@PathVariable(value="projectId") String projectId) {
        SaleConfirmIncomeInfoVO vo = this.saleConfirmIncomeService.initData(projectId);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid SaleConfirmIncomeCrForm saleConfirmIncomeCrForm) throws DataException {
        this.saleConfirmIncomeService.insertInfo(saleConfirmIncomeCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(SaleConfirmIncomePaginationExportModel saleConfirmIncomePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)saleConfirmIncomePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        SaleConfirmIncomePagination saleConfirmIncomePagination = (SaleConfirmIncomePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)saleConfirmIncomePaginationExportModel), SaleConfirmIncomePagination.class));
        List<SaleConfirmIncomeEntity> list = this.saleConfirmIncomeService.getTypeList(saleConfirmIncomePagination, saleConfirmIncomePaginationExportModel.getDataType());
        List<SaleConfirmIncomeListVO> listVO = this.appendListVo(list);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)saleConfirmIncomePaginationExportModel.getSelectKey()) ? saleConfirmIncomePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            ExcelExportEntity entity = null;
            String[] stringArray = keys;
            int n = stringArray.length;
            block34: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "customerName": {
                        entity = new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName");
                        entity.setWidth(30.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "contractCode": {
                        entity = new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "contractName": {
                        entity = new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName");
                        entity.setWidth(30.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "projectCode": {
                        entity = new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "projectName": {
                        entity = new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName");
                        entity.setWidth(30.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "salerName": {
                        entity = new ExcelExportEntity("\u9500\u552e\u4eba\u5458", (Object)"salerName");
                        entitys.add(entity);
                        continue block34;
                    }
                    case "confirmDate": {
                        entity = new ExcelExportEntity("\u786e\u8ba4\u6536\u5165\u65e5\u671f", (Object)"confirmDate");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "confirmAmount": {
                        entity = new ExcelExportEntity("\u672c\u6b21\u786e\u8ba4\u6536\u5165\u91d1\u989d(\u5143)", (Object)"confirmAmount");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "description": {
                        entity = new ExcelExportEntity("\u5907\u6ce8", (Object)"description");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "creatorUserName": {
                        entity = new ExcelExportEntity("\u521b\u5efa\u4eba\u5458", (Object)"creatorUserName");
                        entitys.add(entity);
                        continue block34;
                    }
                    case "creatorTime": {
                        entity = new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block34;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<SaleConfirmIncomeInfoVO> info(@PathVariable(value="id") String id) {
        SaleConfirmIncomeInfoVO vo = this.saleConfirmIncomeService.queryInfo(id);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<SaleConfirmIncomeInfoVO> detailInfo(@PathVariable(value="id") String id) {
        SaleConfirmIncomeInfoVO vo = this.saleConfirmIncomeService.detailInfo(id);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid SaleConfirmIncomeUpForm saleConfirmIncomeUpForm) throws DataException {
        this.saleConfirmIncomeService.editInfo(saleConfirmIncomeUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        this.saleConfirmIncomeService.removeInfo(id);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getProjectList"})
    public ActionResult getProjectList(@RequestBody SaleConfirmIncomePagination pagination) throws IOException {
        List<RkContractProjectEntity> list = this.saleConfirmIncomeService.getProjectList(pagination);
        List listVO = JsonUtil.getJsonToList(list, RkContractProjectListVO.class);
        CrmCustomerEntity customer = null;
        RkContractEntity contract = null;
        SaleNoContractEntity noContract = null;
        for (RkContractProjectListVO vo : listVO) {
            vo.setCompanyName(((OrganizeEntity)this.organizeService.getById((Serializable)((Object)vo.getCompanyId()))).getShortName());
            if (StringUtils.isNotEmpty((String)vo.getCustomerId()) && null != (customer = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo.getCustomerId())))) {
                vo.setCustomerName(customer.getName());
            }
            vo.setIsDoubleSign(0);
            if (!StrUtil.isBlank((CharSequence)vo.getContractId())) {
                contract = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)vo.getContractId()));
                if (null != contract) {
                    if (null != contract.getIsArchived() && 1 == contract.getIsArchived()) {
                        vo.setIsDoubleSign(1);
                    }
                    vo.setContractCode(contract.getContractCode());
                    vo.setContractName(contract.getContractName());
                }
            } else if (!StrUtil.isBlank((CharSequence)vo.getNoContractId()) && null != (noContract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)vo.getNoContractId())))) {
                vo.setContractCode(noContract.getContractCode());
                vo.setContractName(noContract.getContractName());
            }
            vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
            vo.setTaxRateDesc(this.baseDataUtil.getDictName(vo.getTaxRate(), "projectTaxRate"));
            vo.setToBeConfirmedIncome(MathUtils.substract(vo.getSureIncome(), vo.getAllConfirmIncome()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/countProjectByStatus"})
    public ActionResult countProjectByStatus(@RequestBody SaleConfirmIncomePagination pagination) throws IOException {
        Map<String, Integer> map = this.saleConfirmIncomeService.countProjectByStatus(pagination);
        return ActionResult.success(map);
    }

    @PutMapping(value={"/contract/{id}"})
    @DSTransactional
    public ActionResult contractIncomeUpdate(@PathVariable(value="id") String id, @RequestBody @Valid SaleConfirmIncomeUpForm saleConfirmIncomeUpForm) throws DataException {
        this.saleConfirmIncomeService.contractIncomeUpdate(saleConfirmIncomeUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @PostMapping(value={"/contract/getList"})
    public ActionResult contractIncomeList(@RequestBody SaleConfirmIncomePagination saleConfirmIncomePagination) throws IOException {
        List<SaleConfirmIncomeEntity> list = this.saleConfirmIncomeService.getList(saleConfirmIncomePagination);
        List<SaleConfirmIncomeListVO> listVO = this.appendContractListVo(list);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleConfirmIncomePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<SaleConfirmIncomeListVO> appendContractListVo(List<SaleConfirmIncomeEntity> list) {
        List listVO = JsonUtil.getJsonToList(list, SaleConfirmIncomeListVO.class);
        CrmCustomerEntity customer = null;
        RkContractEntity contract = null;
        SaleNoContractEntity noContract = null;
        Map<String, ProjectStateEnum> allToMap = ProjectStateEnum.getAllToMap();
        for (SaleConfirmIncomeListVO vo : listVO) {
            vo.setCompanyName(((OrganizeEntity)this.organizeService.getById((Serializable)((Object)vo.getCompanyId()))).getShortName());
            vo.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
            vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
            vo.setToBeConfirmedIncome(MathUtils.substract(vo.getSureIncome(), vo.getAllConfirmIncome()));
            if (!StrUtil.isBlank((CharSequence)vo.getContractId())) {
                contract = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)vo.getContractId()));
                if (null == contract) continue;
                vo.setContractCode(contract.getContractCode());
                vo.setContractName(contract.getContractName());
                if (1 == contract.getIsAgent()) {
                    String agentId = contract.getAgentId();
                    RkAgentEntity byId = (RkAgentEntity)this.rkAgentService.getById((Serializable)((Object)agentId));
                    vo.setAgentId(agentId);
                    vo.setAgentName(byId == null ? "" : byId.getName());
                }
                if (!StringUtils.isNotEmpty((String)contract.getCustomerId()) || null == (customer = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)contract.getCustomerId())))) continue;
                vo.setCustomerName(customer.getName());
                vo.setCustomerCode(customer.getCode());
                continue;
            }
            if (StrUtil.isBlank((CharSequence)vo.getNoContractId()) || null == (noContract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)vo.getNoContractId())))) continue;
            vo.setContractCode(noContract.getContractCode());
            vo.setContractName(noContract.getContractName());
        }
        return listVO;
    }

    @PostMapping(value={"/contract/batchCreateConfirmRecords"})
    @DSTransactional
    public ActionResult createContractIncome(@RequestBody SaleConfirmIncomePagination pagination) throws DataException {
        this.saleConfirmIncomeService.createContractIncome(pagination.getContractIds());
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/contract/{id}"})
    public ActionResult<SaleConfirmIncomeInfoVO> contractIncomeInfo(@PathVariable(value="id") String id) {
        SaleConfirmIncomeInfoVO vo = this.saleConfirmIncomeService.contractIncomeInfo(id);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getContractList"})
    public ActionResult<?> getContractList(@RequestBody SaleConfirmIncomePagination pagination) throws IOException {
        List<RkContractEntity> list = this.saleConfirmIncomeService.getContractList(pagination);
        List listVO = JsonUtil.getJsonToList(list, RkContractListVO.class);
        CrmCustomerEntity customer = null;
        Object contract = null;
        Object noContract = null;
        for (RkContractListVO vo : listVO) {
            if (StringUtils.isNotEmpty((String)vo.getCustomerId()) && null != (customer = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo.getCustomerId())))) {
                vo.setCustomerName(customer.getName());
                vo.setCustomerCode(customer.getCode());
            }
            if ("1".equals(vo.getIsAgent())) {
                String agentId = vo.getAgentId();
                RkAgentEntity byId = (RkAgentEntity)this.rkAgentService.getById((Serializable)((Object)agentId));
                vo.setAgentName(byId == null ? "" : byId.getName());
            }
            vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), "contractType"));
            vo.setContractTaxRate(this.baseDataUtil.getDictName(vo.getContractTaxRate(), "contractRate"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"contractBatchConfirm"})
    @DSTransactional
    public ActionResult<?> contractBatchConfirm(@RequestBody SaleConfirmIncomeListQuery query) throws DataException {
        if (query.getIds() == null || query.getIds().isEmpty()) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6279\u91cf\u64cd\u4f5c\u7684\u8bb0\u5f55");
        }
        if (StringUtils.isBlank((CharSequence)query.getStatus())) {
            return ActionResult.fail((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.saleConfirmIncomeService.contractBatchConfirm(query);
        return ActionResult.success((String)"\u6279\u91cf\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/contract/countByStatus"})
    public ActionResult<?> countVoucherByStatus(@RequestBody SaleConfirmIncomePagination pagination) throws IOException {
        Map<String, Integer> map = this.saleConfirmIncomeService.countVoucherByStatus(pagination);
        return ActionResult.success(map);
    }

    @PostMapping(value={"batchPushVoucher"})
    @DSTransactional
    public ActionResult<?> batchPushVoucher(@RequestBody SaleConfirmIncomeListQuery query) throws DataException, VoucherPushException {
        if (query.getIds() == null || query.getIds().isEmpty()) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6279\u91cf\u64cd\u4f5c\u7684\u8bb0\u5f55");
        }
        this.saleConfirmIncomeService.batchPushVoucher(query);
        return ActionResult.success((String)"\u6279\u91cf\u64cd\u4f5c\u6210\u529f");
    }
}

