/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.SaleFrameworkAgreementEntity;
import com.bringspring.contract.model.saleframeworkagreement.SaleFrameworkAgreementCrForm;
import com.bringspring.contract.model.saleframeworkagreement.SaleFrameworkAgreementInfoVO;
import com.bringspring.contract.model.saleframeworkagreement.SaleFrameworkAgreementListVO;
import com.bringspring.contract.model.saleframeworkagreement.SaleFrameworkAgreementPagination;
import com.bringspring.contract.model.saleframeworkagreement.SaleFrameworkAgreementPaginationExportModel;
import com.bringspring.contract.model.saleframeworkagreement.SaleFrameworkAgreementUpForm;
import com.bringspring.contract.service.SaleFrameworkAgreementService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6846\u67b6\u534f\u8bae"}, value="contract")
@RequestMapping(value={"/api/contract/SaleFrameworkAgreement"})
public class SaleFrameworkAgreementController {
    private static final Logger log = LoggerFactory.getLogger(SaleFrameworkAgreementController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SaleFrameworkAgreementService saleFrameworkAgreementService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SaleFrameworkAgreementPagination saleFrameworkAgreementPagination) throws IOException {
        List<SaleFrameworkAgreementEntity> list = this.saleFrameworkAgreementService.getList(saleFrameworkAgreementPagination);
        List<SaleFrameworkAgreementListVO> listVO = this.appendListVo(list);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleFrameworkAgreementPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<SaleFrameworkAgreementListVO> appendListVo(List<SaleFrameworkAgreementEntity> list) {
        List listVO = JsonUtil.getJsonToList(list, SaleFrameworkAgreementListVO.class);
        for (SaleFrameworkAgreementListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity;
            vo.setIncomeTypeName(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
            vo.setStatusName(this.baseDataUtil.getDictName(vo.getStatus(), "frameworkStatus"));
            if (StringUtils.isNotEmpty((String)vo.getCompanyId())) {
                vo.setCompanyName(((OrganizeEntity)this.organizeService.getById((Serializable)((Object)vo.getCompanyId()))).getShortName());
            }
            if ((flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus})) != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(-9);
        }
        return listVO;
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid SaleFrameworkAgreementCrForm saleFrameworkAgreementCrForm) throws DataException {
        this.saleFrameworkAgreementService.create(saleFrameworkAgreementCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(SaleFrameworkAgreementPaginationExportModel saleFrameworkAgreementPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)saleFrameworkAgreementPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        SaleFrameworkAgreementPagination saleFrameworkAgreementPagination = (SaleFrameworkAgreementPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)saleFrameworkAgreementPaginationExportModel), SaleFrameworkAgreementPagination.class));
        if ("all".equals(saleFrameworkAgreementPagination.getStatus())) {
            saleFrameworkAgreementPagination.setStatus(null);
        }
        List<SaleFrameworkAgreementEntity> list = this.saleFrameworkAgreementService.getTypeList(saleFrameworkAgreementPagination, saleFrameworkAgreementPaginationExportModel.getDataType());
        List<SaleFrameworkAgreementListVO> listVO = this.appendListVo(list);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)saleFrameworkAgreementPaginationExportModel.getSelectKey()) ? saleFrameworkAgreementPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block30;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block30;
                    }
                    case "incomeTypeName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u4ea7\u54c1\u5927\u7c7b", (Object)"incomeTypeName"));
                        continue block30;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5bf9\u8c61", (Object)"agentName"));
                        continue block30;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName"));
                        continue block30;
                    }
                    case "salesName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u4eba\u5458", (Object)"salesName"));
                        continue block30;
                    }
                    case "salesDepartmentName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u90e8\u95e8", (Object)"salesDepartmentName"));
                        continue block30;
                    }
                    case "statusName": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"statusName"));
                        continue block30;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block30;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<SaleFrameworkAgreementInfoVO> info(@PathVariable(value="id") String id) {
        SaleFrameworkAgreementEntity entity = this.saleFrameworkAgreementService.getInfo(id);
        SaleFrameworkAgreementInfoVO vo = (SaleFrameworkAgreementInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleFrameworkAgreementInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<SaleFrameworkAgreementInfoVO> detailInfo(@PathVariable(value="id") String id) {
        SaleFrameworkAgreementEntity entity = this.saleFrameworkAgreementService.getInfo(id);
        SaleFrameworkAgreementInfoVO vo = (SaleFrameworkAgreementInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleFrameworkAgreementInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid SaleFrameworkAgreementUpForm saleFrameworkAgreementUpForm) throws DataException {
        this.saleFrameworkAgreementService.update(id, saleFrameworkAgreementUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        this.saleFrameworkAgreementService.delete(id);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/countByStatus"})
    public ActionResult countByStatus(@RequestBody SaleFrameworkAgreementPagination pagination) throws IOException {
        Map<String, Integer> map = this.saleFrameworkAgreementService.countByStatus(pagination);
        return ActionResult.success(map);
    }
}

