/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.model.salenocontract.SaleNoContractCrForm;
import com.bringspring.contract.model.salenocontract.SaleNoContractInfoVO;
import com.bringspring.contract.model.salenocontract.SaleNoContractListVO;
import com.bringspring.contract.model.salenocontract.SaleNoContractPagination;
import com.bringspring.contract.model.salenocontract.SaleNoContractPaginationExportModel;
import com.bringspring.contract.model.salenocontract.SaleNoContractUpForm;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.ContractEnableMarkEnum;
import com.bringspring.contract.utils.SaleNoContractStatusEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.purchase.entity.OaContractPurchasePlanEntity;
import com.bringspring.purchase.service.OaContractPurchasePlanService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.utils.AfterSalesRoleUtils;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u65e0\u5408\u540c\u4e1a\u52a1"}, value="contract")
@RequestMapping(value={"/api/contract/SaleNoContract"})
public class SaleNoContractController {
    private static final Logger log = LoggerFactory.getLogger(SaleNoContractController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private RkContractProductService rkContractProductService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private SaleQuotationProfitService saleQuotationProfitService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private AfterSalesRoleUtils afterSalesRoleUtils;
    @Autowired
    private OaContractPurchasePlanService oaContractPurchasePlanService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SaleNoContractPagination saleNoContractPagination) throws IOException {
        List<SaleNoContractEntity> list = this.saleNoContractService.getList(saleNoContractPagination);
        List<SaleNoContractListVO> listVO = this.appendListVo(list, false);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleNoContractPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<SaleNoContractListVO> appendListVo(List<SaleNoContractEntity> list, Boolean isExport) {
        List listVO = JsonUtil.getJsonToList(list, SaleNoContractListVO.class);
        RkAgentEntity agent = null;
        QueryWrapper contractQueryWrapper = null;
        for (SaleNoContractListVO saleNoContractVO : listVO) {
            saleNoContractVO.setSalerName(this.baseDataUtil.userSelectValueNoAccount(saleNoContractVO.getSalerId()));
            if (StringUtils.isNotEmpty((String)saleNoContractVO.getSalerCompanyId())) {
                saleNoContractVO.setSalerCompanyName(this.organizeService.getInfo(saleNoContractVO.getSalerCompanyId()).getShortName());
            }
            saleNoContractVO.setIncomeTypeName(this.crmProductCategoryService.getNameByIds(saleNoContractVO.getIncomeType()));
            if (StringUtils.isNotEmpty((String)saleNoContractVO.getCustomerIds())) {
                saleNoContractVO.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(saleNoContractVO.getId()));
                saleNoContractVO.setCustomerName(saleNoContractVO.getCustomerNames().split(",")[0]);
            }
            if ("1".equals(saleNoContractVO.getIsAgent())) {
                if (StringUtils.isNotEmpty((String)saleNoContractVO.getAgentId()) && null != (agent = this.agentService.getInfo(saleNoContractVO.getAgentId()))) {
                    saleNoContractVO.setAgentName(agent.getName());
                    saleNoContractVO.setAgentType(agent.getType());
                    saleNoContractVO.setAgentTypeName(this.baseDataUtil.getDictName(agent.getType(), "agentType"));
                }
            } else {
                saleNoContractVO.setAgentName(saleNoContractVO.getCustomerNames());
            }
            saleNoContractVO.setCreatorUserName(this.baseDataUtil.userSelectValue(saleNoContractVO.getCreatorUserId()));
            saleNoContractVO.setStatusName(this.baseDataUtil.getDictName(saleNoContractVO.getStatus(), "noContractStatus"));
            if (StringUtils.isNotEmpty((String)saleNoContractVO.getCompanyId())) {
                saleNoContractVO.setCompanyName(((OrganizeEntity)this.organizeService.getById((Serializable)((Object)saleNoContractVO.getCompanyId()))).getShortName());
            }
            if (isExport.booleanValue()) continue;
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)saleNoContractVO.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                saleNoContractVO.setFlowState(flowTaskEntity.getStatus());
            } else {
                saleNoContractVO.setFlowState(-9);
            }
            if (!SaleNoContractStatusEnum.UNRECOGNIZED_STATUS.getStatus().equals(saleNoContractVO.getStatus()) || !StringUtils.isNotEmpty((String)saleNoContractVO.getCustomerIds()) || !StringUtils.isNotEmpty((String)saleNoContractVO.getIncomeType())) continue;
            List<String> incomeTypeList = Arrays.asList(saleNoContractVO.getIncomeType().split(","));
            List<String> customerList = Arrays.asList(saleNoContractVO.getCustomerIds().split(","));
            contractQueryWrapper = new QueryWrapper();
            contractQueryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)saleNoContractVO.getCompanyId());
            contractQueryWrapper.and(wrapper -> {
                for (String customerId : customerList) {
                    ((LambdaQueryWrapper)wrapper.lambda().or()).like(RkContractEntity::getCustomerIds, (Object)customerId);
                }
            });
            contractQueryWrapper.lambda().eq(RkContractEntity::getCustomerId, (Object)saleNoContractVO.getCustomerId());
            contractQueryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().isNull(RkContractEntity::getNoContractId)).or()).eq(RkContractEntity::getNoContractId, (Object)"");
            });
            contractQueryWrapper.lambda().ne(RkContractEntity::getEnableMark, (Object)ContractEnableMarkEnum.ENABLE_VOIDED.getEnableMark());
            contractQueryWrapper.and(wrapper -> {
                for (String incomeType : incomeTypeList) {
                    ((LambdaQueryWrapper)wrapper.lambda().or()).like(RkContractEntity::getIncomeType, (Object)incomeType);
                }
            });
            saleNoContractVO.setSameContractCount(this.rkContractService.count((Wrapper)contractQueryWrapper));
        }
        return listVO;
    }

    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid SaleNoContractCrForm saleNoContractCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        saleNoContractCrForm.setId(mainId);
        this.saleNoContractService.insertInfo(saleNoContractCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(SaleNoContractPaginationExportModel saleNoContractPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)saleNoContractPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        SaleNoContractPagination saleNoContractPagination = (SaleNoContractPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)saleNoContractPaginationExportModel), SaleNoContractPagination.class));
        List<SaleNoContractEntity> list = this.saleNoContractService.getTypeList(saleNoContractPagination, saleNoContractPaginationExportModel.getDataType());
        List<SaleNoContractListVO> listVO = this.appendListVo(list, true);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)saleNoContractPaginationExportModel.getSelectKey()) ? saleNoContractPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            ExcelExportEntity entity = null;
            String[] stringArray = keys;
            int n = stringArray.length;
            block34: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "contractName": {
                        entity = new ExcelExportEntity("\u65e0\u9500\u552e\u5408\u540c\u540d\u79f0", (Object)"contractName");
                        entity.setWidth(30.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "contractCode": {
                        entity = new ExcelExportEntity("\u65e0\u9500\u552e\u5408\u540c\u7f16\u53f7", (Object)"contractCode");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "incomeTypeName": {
                        entity = new ExcelExportEntity("\u5408\u540c\u4ea7\u54c1\u5927\u7c7b", (Object)"incomeTypeName");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "customerName": {
                        entity = new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName");
                        entity.setWidth(30.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5bf9\u8c61", (Object)"agentName"));
                        continue block34;
                    }
                    case "customerNames": {
                        entity = new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerNames");
                        entity.setWidth(40.0);
                        entitys.add(entity);
                        continue block34;
                    }
                    case "expectedContractAmount": {
                        entity = new ExcelExportEntity("\u5408\u540c\u9884\u6d4b\u91d1\u989d\uff08\u5143\uff09", (Object)"expectedContractAmount");
                        entitys.add(entity);
                        entity.setWidth(20.0);
                        continue block34;
                    }
                    case "salerName": {
                        entity = new ExcelExportEntity("\u9500\u552e", (Object)"salerName");
                        entitys.add(entity);
                        continue block34;
                    }
                    case "creatorUserName": {
                        entity = new ExcelExportEntity("\u521b\u5efa\u4eba", (Object)"creatorUserName");
                        entitys.add(entity);
                        continue block34;
                    }
                    case "statusName": {
                        entity = new ExcelExportEntity("\u72b6\u6001", (Object)"statusName");
                        entitys.add(entity);
                        continue block34;
                    }
                    case "creatorTime": {
                        entity = new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime");
                        entity.setWidth(20.0);
                        entitys.add(entity);
                        continue block34;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<SaleNoContractInfoVO> info(@PathVariable(value="id") String id) {
        SaleQuotationProfitEntity profit;
        String userSelectValue;
        SaleQuotationEntity quotation;
        RkAgentEntity agent;
        SaleNoContractEntity entity = this.saleNoContractService.getInfo(id);
        SaleNoContractInfoVO vo = (SaleNoContractInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleNoContractInfoVO.class);
        vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
        if (StringUtils.isNotEmpty((String)vo.getContractType())) {
            vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), "contractType"));
        }
        if ("1".equals(vo.getIsAgent()) && StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.agentService.getInfo(vo.getAgentId()))) {
            vo.setAgentName(agent.getName());
        }
        if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
            vo.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId()));
            vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            vo.setCustomerList(this.saleContractCustomerService.getListByContractId(vo.getId()));
        }
        if (StringUtils.isNotEmpty((String)entity.getOpportunityId())) {
            List<String> idList = Arrays.asList(entity.getOpportunityId().split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(RkProjectReportingEntity::getId, idList);
            List reportingList = this.rkProjectReportingService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)reportingList)) {
                String opportunityName = reportingList.stream().map(RkProjectReportingEntity::getReportingProject).collect(Collectors.joining(","));
                vo.setOpportunityName(opportunityName);
            }
        }
        String quotationPrefix = "";
        if (StringUtils.isNotEmpty((String)entity.getQuotationId()) && null != (quotation = this.saleQuotationService.getInfo(entity.getQuotationId()))) {
            if (StringUtils.isNotEmpty((String)quotation.getSerialNumber())) {
                quotationPrefix = quotation.getSerialNumber();
            } else {
                CrmCustomerEntity customer;
                RkProjectReportingEntity reporting = this.rkProjectReportingService.getInfo(quotation.getOpportunityId());
                if (StringUtils.isNotEmpty((String)reporting.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(reporting.getCustomerId()))) {
                    quotationPrefix = customer.getName();
                }
            }
            userSelectValue = this.baseDataUtil.userSelectValue(quotation.getQuotationUser());
            String quotationName = quotationPrefix + "-" + userSelectValue;
            vo.setQuotationName(quotationName);
        }
        if (StringUtils.isNotEmpty((String)entity.getQuotationProfitId()) && null != (profit = this.saleQuotationProfitService.getInfo(entity.getQuotationProfitId()))) {
            userSelectValue = this.baseDataUtil.userSelectValue(profit.getSaleId());
            vo.setQuotationProfitName(quotationPrefix + "-" + userSelectValue);
        }
        List<RkAttachmentEntity> oaAttachmentEntityList = this.rkAttachmentService.getListByContractId(id);
        vo.setAttachmentList(oaAttachmentEntityList);
        List<RkContractProjectEntity> projectList = this.rkContractProjectService.getListByNoContractId(vo.getId());
        vo.setProjectList(projectList);
        List<OaContractPurchasePlanEntity> purchasePlanList = this.oaContractPurchasePlanService.getPlanListByNoContractId(id);
        vo.setPurchasePlanList(purchasePlanList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<SaleNoContractInfoVO> detailInfo(@PathVariable(value="id") String id) {
        SaleQuotationProfitEntity profit;
        String userSelectValue;
        SaleQuotationEntity quotation;
        RkAgentEntity agent;
        SaleNoContractEntity entity = this.saleNoContractService.getInfo(id);
        SaleNoContractInfoVO vo = (SaleNoContractInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleNoContractInfoVO.class);
        vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
        vo.setIncomeTypeName(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
        vo.setContractTypeName(this.baseDataUtil.getDictName(entity.getContractType(), "contractType"));
        vo.setBiddingStatusName(this.baseDataUtil.getDictName(entity.getBiddingStatus(), "biddingStatus"));
        vo.setContractSigningStatusName(this.baseDataUtil.getDictName(entity.getContractSigningStatus(), "contractSigningStatus"));
        vo.setBusinessRiskAssessmentName(this.baseDataUtil.getDictName(entity.getBusinessRiskAssessment(), "businessRiskAssessment"));
        vo.setBidWinningSituationName(this.baseDataUtil.getDictName(entity.getBidWinningSituation(), "bidWinningSituation"));
        if ("1".equals(vo.getIsAgent()) && StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.agentService.getInfo(vo.getAgentId()))) {
            vo.setAgentName(agent.getName());
        }
        if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
            vo.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId()));
            vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
        }
        vo.setCustomerAddressName(this.baseDataUtil.provinceData(vo.getCustomerAddress()));
        if (StringUtils.isNotEmpty((String)entity.getOpportunityId())) {
            List<String> idList = Arrays.asList(entity.getOpportunityId().split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(RkProjectReportingEntity::getId, idList);
            List reportingList = this.rkProjectReportingService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)reportingList)) {
                String opportunityName = reportingList.stream().map(RkProjectReportingEntity::getReportingProject).collect(Collectors.joining(","));
                vo.setOpportunityName(opportunityName);
            }
        }
        String quotationPrefix = "";
        if (StringUtils.isNotEmpty((String)entity.getQuotationId()) && null != (quotation = this.saleQuotationService.getInfo(entity.getQuotationId()))) {
            if (StringUtils.isNotEmpty((String)quotation.getSerialNumber())) {
                quotationPrefix = quotation.getSerialNumber();
            } else {
                CrmCustomerEntity customer;
                RkProjectReportingEntity reporting = this.rkProjectReportingService.getInfo(quotation.getOpportunityId());
                if (StringUtils.isNotEmpty((String)reporting.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(reporting.getCustomerId()))) {
                    quotationPrefix = customer.getName();
                }
            }
            userSelectValue = this.baseDataUtil.userSelectValue(quotation.getQuotationUser());
            String quotationName = quotationPrefix + "-" + userSelectValue;
            vo.setQuotationName(quotationName);
        }
        if (StringUtils.isNotEmpty((String)entity.getQuotationProfitId()) && null != (profit = this.saleQuotationProfitService.getInfo(entity.getQuotationProfitId()))) {
            userSelectValue = this.baseDataUtil.userSelectValue(profit.getSaleId());
            vo.setQuotationProfitName(quotationPrefix + "-" + userSelectValue);
        }
        List<RkAttachmentEntity> oaAttachmentEntityList = this.rkAttachmentService.getListByContractId(id);
        vo.setAttachmentList(oaAttachmentEntityList);
        List<OaContractPurchasePlanEntity> purchasePlanList = this.oaContractPurchasePlanService.getPlanListByNoContractId(id);
        vo.setPurchasePlanList(purchasePlanList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid SaleNoContractUpForm saleNoContractUpForm) throws DataException {
        SaleNoContractEntity entity = this.saleNoContractService.getInfo(id);
        if (null == entity) {
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saleNoContractService.editInfo(saleNoContractUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        this.saleNoContractService.removeInfo(id);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/countByStatus"})
    public ActionResult countByStatus(@RequestBody SaleNoContractPagination saleNoContractPagination) throws IOException {
        Map<String, Integer> map = this.saleNoContractService.countByStatus(saleNoContractPagination);
        return ActionResult.success(map);
    }

    @GetMapping(value={"/getSimpleAndProjectCount/{noContractId}"})
    public ActionResult getSimpleAndProjectCount(@PathVariable(value="noContractId") String noContractId) {
        SaleNoContractInfoVO vo = this.saleNoContractService.getSimpleAndProjectCount(noContractId);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/writeOff/{id}/{contractId}"})
    public ActionResult writeOff(@PathVariable(value="id") String id, @PathVariable(value="contractId") String contractId) throws DataException {
        this.saleNoContractService.writeOff(id, contractId);
        return ActionResult.success((String)"\u6838\u9500\u6210\u529f");
    }

    @GetMapping(value={"/getNoContractForContract/{noContractId}"})
    public ActionResult getNoContractForContract(@PathVariable(value="noContractId") String noContractId) {
        SaleNoContractInfoVO vo = this.saleNoContractService.getNoContractForContract(noContractId);
        return ActionResult.success((Object)vo);
    }
}

