/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.model.rkagent.RkCustomerAndAgentListQuery;
import com.bringspring.contract.model.rkcontract.RkContractQueryVO;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.ContractEnableMarkEnum;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.service.UserRelationService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import sun.misc.BASE64Decoder;

@RestController
@RequestMapping(value={"/api/contract/user"})
public class UserInfoController {
    @Autowired
    private ProvinceService provinceService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkAgentService rkAgentService;

    @GetMapping(value={"/getAuthArea/{id}"})
    public ActionResult getAuthArea(@PathVariable(value="id") String id) {
        List area = this.userRelationService.getListByUserIdAndObjType(id, "Area");
        List areaIdList = CollectionUtil.list((boolean)false);
        area.stream().forEach(a -> {
            String[] split = a.getObjectId().replace("[\"", "").replace("\"]", "").replaceAll("\"", "").split(",");
            areaIdList.add(split[0]);
        });
        List proList = this.provinceService.getProList(areaIdList);
        if (CollectionUtil.isEmpty((Collection)proList)) {
            proList = this.provinceService.getListByParentId("-1");
        }
        return ActionResult.success((Object)proList);
    }

    @GetMapping(value={"getHaveContract"})
    public ActionResult getHaveContract(String agentId) {
        List<ContractEnableMarkEnum> allToList;
        List<String> collect1;
        UserInfo userInfo = this.userProvider.get();
        RkContractQueryVO queryVO = new RkContractQueryVO();
        if (StrUtil.isNotEmpty((CharSequence)agentId)) {
            queryVO.setAgentId(agentId);
        }
        if (CollectionUtil.isNotEmpty(collect1 = (allToList = ContractEnableMarkEnum.getAllToList()).stream().map(ContractEnableMarkEnum::getEnableMark).collect(Collectors.toList()))) {
            queryVO.setEnableMarkList(collect1);
        }
        List<RkContractEntity> list = this.contractService.getListByCompanyIdAndEnableMarkIn(queryVO);
        List list2 = CollectionUtil.list((boolean)false);
        list.stream().forEach(c -> {
            if (StrUtil.isNotEmpty((CharSequence)c.getCustomerIds())) {
                List<String> list1 = Arrays.asList(c.getCustomerIds().split(","));
                list2.addAll(list1);
            }
        });
        return ActionResult.success((Object)list2);
    }

    @GetMapping(value={"getAgentIdHaveContract"})
    public ActionResult getAgentIdHaveContract(String customerId) {
        UserInfo userInfo = this.userProvider.get();
        List<RkContractEntity> list = this.contractService.getListByCompanyIdAndNotDraft(userInfo.getOrganizeId(), customerId);
        List collect = list.stream().map(RkContractEntity::getAgentId).collect(Collectors.toList());
        return ActionResult.success(collect);
    }

    @PostMapping(value={"getCustomerAndAgent"})
    public ActionResult getCustomerAndAgent(@RequestBody RkCustomerAndAgentListQuery listQuery) {
        if (!ObjectUtil.isEmpty((Object)listQuery.getName())) {
            listQuery.setName(listQuery.getName().replaceAll("\\s", "").toUpperCase());
        }
        if (StrUtil.isBlank((CharSequence)listQuery.getCompanyId())) {
            listQuery.setCompanyId(this.userProvider.get().getOrganizeId());
        }
        List customerAndAgent = this.rkAgentService.getCustomerAndAgent(listQuery);
        PageListVO vo = new PageListVO();
        vo.setList(customerAndAgent);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)listQuery), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    public static void main(String[] args) throws Exception {
        StringBuilder base64Str = new StringBuilder();
        UserInfoController.base64StringToPdf(base64Str, "D:\\output.pdf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void base64StringToPdf(StringBuilder base64Content, String filePath) {
        BASE64Decoder decoder = new BASE64Decoder();
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            FileInputStream inputStream = new FileInputStream(new File("C:\\Users\\Admin\\Desktop\\13.txt"));
            byte[] bytes = decoder.decodeBuffer((InputStream)inputStream);
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(bytes);
            bis = new BufferedInputStream(byteInputStream);
            File file = new File(filePath);
            File path = file.getParentFile();
            if (!path.exists()) {
                path.mkdirs();
            }
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            byte[] buffer = new byte[1024];
            int length = bis.read(buffer);
            while (length != -1) {
                bos.write(buffer, 0, length);
            }
            length = bis.read(buffer);
            bos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

