/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.AfterSalesProjectWarrantyStateEnum;
import com.bringspring.contract.entity.AfterSalesProjectsEntity;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProductEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.mapper.AfterSalesProjectsMapper;
import com.bringspring.contract.mapper.RkContractMapper;
import com.bringspring.contract.model.aftersalesprojects.AfterSalesProjectsPagination;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.AllMaintenanceTypeEnum;
import com.bringspring.contract.utils.DateUtils;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.AfterSalesMaintenanceEntity;
import com.bringspring.visit.entity.AfterSalesQuestionEntity;
import com.bringspring.visit.model.after_inspecttask.AfterInspectTaskListVO;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionListVO;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionPagination;
import com.bringspring.visit.service.AfterInspectTaskService;
import com.bringspring.visit.service.AfterSalesMaintenanceService;
import com.bringspring.visit.service.AfterSalesQuestionService;
import com.bringspring.visit.utils.DeleteMarkEnum;
import com.bringspring.visit.utils.HolidayUtil;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AfterSalesProjectsServiceImpl
extends ServiceImpl<AfterSalesProjectsMapper, AfterSalesProjectsEntity>
implements AfterSalesProjectsService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractMapper rkContractMapper;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private AfterSalesQuestionService afterSalesQuestionService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private UserService userService;
    @Autowired
    private AfterInspectTaskService afterInspectTaskService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private AfterSalesProjectsMapper afterSalesProjectsMapper;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private AfterSalesMaintenanceService afterSalesMaintenanceService;
    @Autowired
    private RkContractProductService rkContractProductService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private SaleNoContractService saleNoContractService;

    @Override
    public List<AfterSalesProjectsEntity> getList(AfterSalesProjectsPagination afterSalesProjectsPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean afterSalesProjectsNum = false;
        QueryWrapper afterSalesProjectsQueryWrapper = this.appendWrapper(afterSalesProjectsPagination);
        if (ObjectUtil.isNull(afterSalesProjectsQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if (AllIdList.size() > 0) {
            afterSalesProjectsQueryWrapper.lambda().in(AfterSalesProjectsEntity::getId, AllIdList);
        }
        if (StrUtil.isEmpty((CharSequence)afterSalesProjectsPagination.getSidx())) {
            afterSalesProjectsQueryWrapper.lambda().orderByDesc(AfterSalesProjectsEntity::getCreatorTime, (Object[])new SFunction[]{AfterSalesProjectsEntity::getCreatorTime});
        } else {
            try {
                String sidx = afterSalesProjectsPagination.getSidx();
                AfterSalesProjectsEntity afterSalesProjectsEntity = new AfterSalesProjectsEntity();
                Field declaredField = afterSalesProjectsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                afterSalesProjectsQueryWrapper = "asc".equals(afterSalesProjectsPagination.getSort().toLowerCase()) ? (QueryWrapper)afterSalesProjectsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)afterSalesProjectsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(afterSalesProjectsPagination.getCurrentPage(), afterSalesProjectsPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)afterSalesProjectsQueryWrapper);
            return afterSalesProjectsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return afterSalesProjectsPagination.setData(list, list.size());
    }

    @Override
    public List<AfterSalesProjectsEntity> getProjectCustomerList(AfterSalesProjectsPagination afterSalesProjectsPagination) {
        List contractSignDateEarlylist;
        Object afterSalesProjectsObj;
        UserInfo userInfo = this.userProvider.get();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean afterSalesProjectsNum = false;
        List<AfterSalesProjectsEntity> listAll = this.afterSalesProjectsMapper.getCustomerGroupBy(afterSalesProjectsPagination.getCompanyId());
        List signTimeList = listAll.stream().map(AfterSalesProjectsEntity::getContractSignDate).collect(Collectors.toList());
        List customerList = listAll.stream().map(AfterSalesProjectsEntity::getCustomerId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtil.isNotEmpty(listAll)) {
            queryWrapper.lambda().and(x -> ((LambdaQueryWrapper)x.in(AfterSalesProjectsEntity::getCustomerId, (Collection)customerList)).in(AfterSalesProjectsEntity::getContractSignDate, (Collection)signTimeList));
        } else {
            queryWrapper.lambda().in(AfterSalesProjectsEntity::getId, new Object[]{""});
        }
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            afterSalesProjectsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, afterSalesProjectsPagination.getMenuId(), "after_sales_projects"));
            if (ObjectUtil.isEmpty((Object)afterSalesProjectsObj)) {
                return null;
            }
            queryWrapper = (QueryWrapper)afterSalesProjectsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            afterSalesProjectsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, afterSalesProjectsPagination.getMenuId(), "after_sales_projects"));
            if (ObjectUtil.isEmpty((Object)afterSalesProjectsObj)) {
                return null;
            }
            queryWrapper = (QueryWrapper)afterSalesProjectsObj;
        }
        if (CollectionUtil.isNotEmpty((Collection)(contractSignDateEarlylist = this.list((Wrapper)queryWrapper)))) {
            contractSignDateEarlylist = contractSignDateEarlylist.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AfterSalesProjectsEntity>(Comparator.comparing(f -> f.getCustomerId() + ";" + f.getCompanyId()))), ArrayList::new));
        }
        List ids = contractSignDateEarlylist.stream().map(AfterSalesProjectsEntity::getId).collect(Collectors.toList());
        QueryWrapper afterSalesProjectsQueryWrapper = this.appendWrapper(afterSalesProjectsPagination);
        if (ObjectUtil.isEmpty(afterSalesProjectsQueryWrapper)) {
            ArrayList list = new ArrayList();
            return afterSalesProjectsPagination.setData(list, list.size());
        }
        if (CollectionUtil.isNotEmpty(ids)) {
            afterSalesProjectsQueryWrapper.lambda().in(AfterSalesProjectsEntity::getId, ids);
        } else {
            afterSalesProjectsQueryWrapper.lambda().in(AfterSalesProjectsEntity::getId, new Object[]{""});
        }
        if (ObjectUtil.isNull(afterSalesProjectsQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if (AllIdList.size() > 0) {
            afterSalesProjectsQueryWrapper.lambda().in(AfterSalesProjectsEntity::getId, AllIdList);
        }
        if (StrUtil.isEmpty((CharSequence)afterSalesProjectsPagination.getSidx())) {
            afterSalesProjectsQueryWrapper.lambda().orderByDesc(AfterSalesProjectsEntity::getCustomerId, (Object[])new SFunction[]{AfterSalesProjectsEntity::getContractSignDate});
        } else {
            try {
                String sidx = afterSalesProjectsPagination.getSidx();
                AfterSalesProjectsEntity afterSalesProjectsEntity = new AfterSalesProjectsEntity();
                Field declaredField = afterSalesProjectsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                afterSalesProjectsQueryWrapper = "asc".equals(afterSalesProjectsPagination.getSort().toLowerCase()) ? (QueryWrapper)afterSalesProjectsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)afterSalesProjectsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(afterSalesProjectsPagination.getCurrentPage(), afterSalesProjectsPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)afterSalesProjectsQueryWrapper);
            return afterSalesProjectsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return afterSalesProjectsPagination.setData(list, list.size());
    }

    @Override
    public long getByCustomerIdQuantity(String customerId, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesProjectsEntity::getCustomerId, (Object)customerId);
        queryWrapper.lambda().eq(AfterSalesProjectsEntity::getCompanyId, (Object)companyId);
        long count = this.count((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public AfterSalesProjectsEntity byProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesProjectsEntity::getProjectId, (Object)projectId);
        AfterSalesProjectsEntity entity = (AfterSalesProjectsEntity)this.getOne((Wrapper)queryWrapper);
        return entity;
    }

    @Override
    public AfterSalesProjectsEntity byProjectCode(String projectCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesProjectsEntity::getProjectCode, (Object)projectCode);
        AfterSalesProjectsEntity entity = (AfterSalesProjectsEntity)this.getOne((Wrapper)queryWrapper);
        return entity;
    }

    @Override
    public List<AfterSalesProjectsEntity> getProjectByCompanyId(AfterSalesProjectsPagination afterSalesProjectsPagination) {
        Page page;
        IPage userIPage;
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesProjectsEntity::getCompanyId, (Object)userInfo.getOrganizeId());
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getKeyword())) {
            queryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.like(AfterSalesProjectsEntity::getProjectName, (Object)afterSalesProjectsPagination.getKeyword())).or()).like(AfterSalesProjectsEntity::getCustomerName, (Object)afterSalesProjectsPagination.getKeyword()));
        }
        if (CollectionUtil.isNotEmpty((Collection)(userIPage = this.page((IPage)(page = new Page(afterSalesProjectsPagination.getCurrentPage(), afterSalesProjectsPagination.getPageSize())), (Wrapper)queryWrapper)).getRecords())) {
            return afterSalesProjectsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return afterSalesProjectsPagination.setData(list, list.size());
    }

    @Override
    public List<AfterSalesProjectsEntity> getListAll() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().isNotNull(AfterSalesProjectsEntity::getWarrantyEndDate);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<AfterSalesProjectsEntity> getByCustomerId(AfterSalesProjectsPagination afterSalesProjectsPagination) {
        QueryWrapper<AfterSalesProjectsEntity> queryWrapper = this.appendWrapper(afterSalesProjectsPagination);
        queryWrapper.lambda().eq(AfterSalesProjectsEntity::getCustomerId, (Object)afterSalesProjectsPagination.getCustomerId());
        List list = this.list((Wrapper)queryWrapper);
        return afterSalesProjectsPagination.setData(list, list.size());
    }

    private QueryWrapper<AfterSalesProjectsEntity> appendWrapper(AfterSalesProjectsPagination afterSalesProjectsPagination) {
        Long sec;
        Long fir;
        List<String> TransferDateList;
        Object afterSalesProjectsObj;
        boolean isPc;
        QueryWrapper afterSalesProjectsQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        if (ObjectUtil.equals((Object)afterSalesProjectsPagination.getIsAuth(), (Object)0)) {
            pcPermission = false;
            appPermission = false;
        }
        if ((isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc")) && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            afterSalesProjectsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(afterSalesProjectsQueryWrapper, afterSalesProjectsPagination.getMenuId(), "after_sales_projects"));
            if (ObjectUtil.isEmpty((Object)afterSalesProjectsObj)) {
                return null;
            }
            afterSalesProjectsQueryWrapper = (QueryWrapper)afterSalesProjectsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            afterSalesProjectsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(afterSalesProjectsQueryWrapper, afterSalesProjectsPagination.getMenuId(), "after_sales_projects"));
            if (ObjectUtil.isEmpty((Object)afterSalesProjectsObj)) {
                return null;
            }
            afterSalesProjectsQueryWrapper = (QueryWrapper)afterSalesProjectsObj;
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getManHourState())) {
            afterSalesProjectsQueryWrapper.lambda().eq(AfterSalesProjectsEntity::getManHourState, (Object)afterSalesProjectsPagination.getManHourState());
        }
        afterSalesProjectsQueryWrapper.lambda().eq(AfterSalesProjectsEntity::getEnabledMark, (Object)DeleteMarkEnum.DELETE.getDeleteMark());
        if (CollectionUtil.isNotEmpty(afterSalesProjectsPagination.getCompanyIdList())) {
            afterSalesProjectsQueryWrapper.lambda().and(x -> x.in(AfterSalesProjectsEntity::getCompanyId, afterSalesProjectsPagination.getCompanyIdList()));
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getProjectId())) {
            afterSalesProjectsQueryWrapper.lambda().like(AfterSalesProjectsEntity::getProjectId, (Object)afterSalesProjectsPagination.getProjectId());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getWarrantyState())) {
            afterSalesProjectsQueryWrapper.lambda().eq(AfterSalesProjectsEntity::getWarrantyState, (Object)afterSalesProjectsPagination.getWarrantyState());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getKeyword())) {
            afterSalesProjectsQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.like(AfterSalesProjectsEntity::getProjectName, (Object)afterSalesProjectsPagination.getKeyword())).or()).like(AfterSalesProjectsEntity::getCustomerName, (Object)afterSalesProjectsPagination.getKeyword()));
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getProjectName())) {
            afterSalesProjectsQueryWrapper.lambda().like(AfterSalesProjectsEntity::getProjectName, (Object)afterSalesProjectsPagination.getProjectName());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getProjectCode())) {
            afterSalesProjectsQueryWrapper.lambda().like(AfterSalesProjectsEntity::getProjectCode, (Object)afterSalesProjectsPagination.getProjectCode());
        }
        if (ObjectUtil.isNotEmpty(afterSalesProjectsPagination.getDepartmentList())) {
            String dept = afterSalesProjectsPagination.getDepartmentList().get(afterSalesProjectsPagination.getDepartmentList().size() - 1);
            afterSalesProjectsQueryWrapper.lambda().like(AfterSalesProjectsEntity::getDepartment, (Object)dept);
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getProduct())) {
            afterSalesProjectsQueryWrapper.lambda().like(AfterSalesProjectsEntity::getProduct, (Object)afterSalesProjectsPagination.getProduct());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getCompanyId())) {
            afterSalesProjectsQueryWrapper.lambda().like(AfterSalesProjectsEntity::getCompanyId, (Object)afterSalesProjectsPagination.getCompanyId());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getProv())) {
            afterSalesProjectsQueryWrapper.lambda().like(AfterSalesProjectsEntity::getProv, (Object)afterSalesProjectsPagination.getProv());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getCity())) {
            afterSalesProjectsQueryWrapper.lambda().like(AfterSalesProjectsEntity::getCity, (Object)afterSalesProjectsPagination.getCity());
        }
        if (CollectionUtil.isNotEmpty(afterSalesProjectsPagination.getTransferDate())) {
            TransferDateList = afterSalesProjectsPagination.getTransferDate();
            fir = Long.valueOf(TransferDateList.get(0));
            sec = Long.valueOf(TransferDateList.get(1));
            ((LambdaQueryWrapper)afterSalesProjectsQueryWrapper.lambda().ge(AfterSalesProjectsEntity::getTransferDate, (Object)new Date(fir))).le(AfterSalesProjectsEntity::getTransferDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (CollectionUtil.isNotEmpty(afterSalesProjectsPagination.getContractSignDate())) {
            TransferDateList = afterSalesProjectsPagination.getContractSignDate();
            fir = Long.valueOf(TransferDateList.get(0));
            sec = Long.valueOf(TransferDateList.get(1));
            ((LambdaQueryWrapper)afterSalesProjectsQueryWrapper.lambda().ge(AfterSalesProjectsEntity::getContractSignDate, (Object)new Date(fir))).le(AfterSalesProjectsEntity::getContractSignDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getIncomeType())) {
            afterSalesProjectsQueryWrapper.lambda().like(AfterSalesProjectsEntity::getIncomeType, (Object)afterSalesProjectsPagination.getIncomeType());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getCustomerId())) {
            afterSalesProjectsQueryWrapper.lambda().like(AfterSalesProjectsEntity::getCustomerId, (Object)afterSalesProjectsPagination.getCustomerId());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getCustomerName())) {
            afterSalesProjectsQueryWrapper.lambda().like(AfterSalesProjectsEntity::getCustomerName, (Object)afterSalesProjectsPagination.getCustomerName());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getProjectAmount())) {
            afterSalesProjectsQueryWrapper.lambda().like(AfterSalesProjectsEntity::getProjectAmount, (Object)afterSalesProjectsPagination.getProjectAmount());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getAfterSalesPerson())) {
            afterSalesProjectsQueryWrapper.lambda().eq(AfterSalesProjectsEntity::getAfterSalesPerson, (Object)afterSalesProjectsPagination.getAfterSalesPerson());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getAssistantsUser())) {
            afterSalesProjectsQueryWrapper.lambda().eq(AfterSalesProjectsEntity::getAssistantsUser, (Object)afterSalesProjectsPagination.getAssistantsUser());
        }
        if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsPagination.getAfterSalesManager())) {
            afterSalesProjectsQueryWrapper.lambda().eq(AfterSalesProjectsEntity::getAfterSalesManager, (Object)afterSalesProjectsPagination.getAfterSalesManager());
        }
        if (!ObjectUtil.isEmpty((Object)afterSalesProjectsPagination.getAgentId())) {
            List<RkContractEntity> listBySignDate = this.contractService.getListBySignDateAndAgentId(afterSalesProjectsPagination.getSignDate(), afterSalesProjectsPagination.getAgentId());
            if (CollectionUtil.isEmpty(listBySignDate)) {
                return null;
            }
            List collect = listBySignDate.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            afterSalesProjectsQueryWrapper.lambda().in(AfterSalesProjectsEntity::getContractId, collect);
        }
        if (CollectionUtil.isNotEmpty(afterSalesProjectsPagination.getCustomerAddress())) {
            afterSalesProjectsPagination.getCustomerAddress().stream().filter(x -> {
                boolean flag = x.size() < 2 && ((String)x.get(0)).equals("10");
                return !flag;
            }).collect(Collectors.toList());
            if (afterSalesProjectsPagination.getCustomerAddress().size() < 2 && afterSalesProjectsPagination.getCustomerAddress().get(0).equals("10")) {
                afterSalesProjectsPagination.setCustomerAddress(null);
            }
        }
        if (StringUtils.isNotEmpty(afterSalesProjectsPagination.getCustomerAddress())) {
            QueryWrapper crmCustomerWrapper = new QueryWrapper();
            crmCustomerWrapper.lambda().and(x -> {
                for (List<String> ll : afterSalesProjectsPagination.getCustomerAddress()) {
                    List addressList = JsonUtil.getJsonToList(ll, String.class);
                    if (addressList.size() > 1) {
                        String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                        collect = "[" + collect;
                        ((LambdaQueryWrapper)x.or()).like(RkContractEntity::getCustomerAddress, (Object)collect);
                        continue;
                    }
                    String s2 = (String)addressList.get(addressList.size() - 1);
                    s2 = "[\"" + s2 + "\"";
                    ((LambdaQueryWrapper)x.or()).like(RkContractEntity::getCustomerAddress, (Object)s2);
                }
            });
            List list = this.rkContractMapper.selectList((Wrapper)crmCustomerWrapper);
            List ids = list.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            if (StringUtils.isNotEmpty(ids)) {
                afterSalesProjectsQueryWrapper.lambda().in(AfterSalesProjectsEntity::getContractId, ids);
            } else {
                afterSalesProjectsQueryWrapper.lambda().in(AfterSalesProjectsEntity::getContractId, new Object[]{""});
            }
        }
        return afterSalesProjectsQueryWrapper;
    }

    @Override
    public List<AfterSalesProjectsEntity> getTypeList(AfterSalesProjectsPagination afterSalesProjectsPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean afterSalesProjectsNum = false;
        QueryWrapper afterSalesProjectsQueryWrapper = this.appendWrapper(afterSalesProjectsPagination);
        if (ObjectUtil.isNull(afterSalesProjectsQueryWrapper)) {
            ArrayList list = new ArrayList();
            return afterSalesProjectsPagination.setData(list, list.size());
        }
        if (AllIdList.size() > 0) {
            afterSalesProjectsQueryWrapper.lambda().in(AfterSalesProjectsEntity::getId, AllIdList);
        }
        if (StrUtil.isEmpty((CharSequence)afterSalesProjectsPagination.getSidx())) {
            afterSalesProjectsQueryWrapper.lambda().orderByDesc(AfterSalesProjectsEntity::getId);
        } else {
            try {
                String sidx = afterSalesProjectsPagination.getSidx();
                AfterSalesProjectsEntity afterSalesProjectsEntity = new AfterSalesProjectsEntity();
                Field declaredField = afterSalesProjectsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                afterSalesProjectsQueryWrapper = "asc".equals(afterSalesProjectsPagination.getSort().toLowerCase()) ? (QueryWrapper)afterSalesProjectsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)afterSalesProjectsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(afterSalesProjectsPagination.getCurrentPage(), afterSalesProjectsPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)afterSalesProjectsQueryWrapper);
                return afterSalesProjectsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return afterSalesProjectsPagination.setData(list, list.size());
        }
        return this.list((Wrapper)afterSalesProjectsQueryWrapper);
    }

    @Override
    public AfterSalesProjectsEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesProjectsEntity::getId, (Object)id);
        return (AfterSalesProjectsEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(AfterSalesProjectsEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, AfterSalesProjectsEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(AfterSalesProjectsEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<AfterSalesProjectsEntity> getListProductInAndCustomerId(String productId, String customerId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)customerId)) {
            queryWrapper.lambda().eq(AfterSalesProjectsEntity::getCustomerId, (Object)customerId);
        }
        if (StringUtils.isNotEmpty((String)productId)) {
            queryWrapper.apply(" FIND_IN_SET(" + productId + ",PRODUCT)", new Object[0]);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void saveProject(RkContractProjectEntity projectEntity, String afterSalesManager, String assistantsUser, String afterSalesPerson, String product, String creatorUserId, String department, String departmentTree, String warrantyState, List<RkAttachmentEntity> attachments) {
        AfterSalesMaintenanceEntity entity;
        CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)projectEntity.getCustomerId()));
        AfterSalesProjectsEntity afterSalesProjectsEntity = new AfterSalesProjectsEntity();
        afterSalesProjectsEntity.setAfterSaleExecuteUser(projectEntity.getAfterSaleExecuteUser());
        afterSalesProjectsEntity.setAfterSalesAssistant(projectEntity.getAfterSalesAssistant());
        afterSalesProjectsEntity.setProjectId(projectEntity.getId());
        afterSalesProjectsEntity.setContractId(projectEntity.getContractId());
        afterSalesProjectsEntity.setProjectName(projectEntity.getProjectName());
        afterSalesProjectsEntity.setProjectCode(projectEntity.getProjectCode());
        afterSalesProjectsEntity.setIncomeType(projectEntity.getIncomeType());
        afterSalesProjectsEntity.setCustomerId(projectEntity.getCustomerId());
        afterSalesProjectsEntity.setCustomerName(byId.getName());
        afterSalesProjectsEntity.setAfterSalesManager(afterSalesManager);
        afterSalesProjectsEntity.setAssistantsUser(assistantsUser);
        afterSalesProjectsEntity.setAfterSalesPerson(afterSalesPerson);
        afterSalesProjectsEntity.setProduct(product);
        afterSalesProjectsEntity.setAddress(byId.getAddress());
        afterSalesProjectsEntity.setAddress(this.baseDataUtil.provinceData(byId.getAddress()));
        afterSalesProjectsEntity.setId(RandomUtil.uuId());
        afterSalesProjectsEntity.setCompanyId(projectEntity.getCompanyId());
        afterSalesProjectsEntity.setProjectAmount(projectEntity.getProjectAmount());
        afterSalesProjectsEntity.setIsWarrantyWarning(0);
        afterSalesProjectsEntity.setWarrantyWarningDays(30);
        afterSalesProjectsEntity.setIsAuthorizedWarning(0);
        afterSalesProjectsEntity.setAuthorizedWarningDays(30);
        afterSalesProjectsEntity.setTransferDate(new Date());
        afterSalesProjectsEntity.setCreatorUserId(creatorUserId);
        afterSalesProjectsEntity.setWarrantyState(warrantyState);
        afterSalesProjectsEntity.setWarrantyStartDate(DateUtil.dateAddDays((Date)projectEntity.getAcceptanceTime(), (int)1));
        Integer warrantyMonth = 12;
        RkContractEntity contractEntity = (RkContractEntity)this.contractService.getById((Serializable)((Object)projectEntity.getContractId()));
        if (ObjectUtil.isNotNull((Object)contractEntity)) {
            afterSalesProjectsEntity.setContractSignDate(contractEntity.getSignDate());
            afterSalesProjectsEntity.setSalerName(contractEntity.getSalerName());
            afterSalesProjectsEntity.setSalerId(contractEntity.getSalerId());
        }
        if (ObjectUtil.isNotNull((Object)contractEntity) && ObjectUtil.isNotNull((Object)contractEntity.getWarranty())) {
            warrantyMonth = contractEntity.getWarranty();
        }
        afterSalesProjectsEntity.setWarrantyEndDate(DateUtil.dateAddMonths((Date)afterSalesProjectsEntity.getWarrantyStartDate(), (int)warrantyMonth));
        afterSalesProjectsEntity.setDepartment(department);
        afterSalesProjectsEntity.setDepartmentTree(departmentTree);
        String[] split = byId.getAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
        for (int i = 0; i < split.length; ++i) {
            if (i == 1) {
                afterSalesProjectsEntity.setProv(split[1]);
            }
            if (i != 2) continue;
            afterSalesProjectsEntity.setCity(split[2]);
        }
        afterSalesProjectsEntity.setDescription("\u8f6c\u552e\u540e\u9879\u76ee");
        this.save(afterSalesProjectsEntity);
        AfterSalesMaintenanceEntity entity1 = this.afterSalesMaintenanceService.getMaintenanceByCustomerId(projectEntity);
        if (ObjectUtil.isNotNull((Object)entity1)) {
            entity1.setTransferDate(afterSalesProjectsEntity.getTransferDate());
            entity1.setExpirationDate(afterSalesProjectsEntity.getWarrantyEndDate());
            entity1.setAfterSalesRegional(afterSalesProjectsEntity.getAfterSalesManager());
            entity1.setAfterSalesPerson(afterSalesProjectsEntity.getAfterSalesAssistant());
            entity1.setAssistantsUser(assistantsUser);
            entity1.setState(afterSalesProjectsEntity.getWarrantyState());
            this.afterSalesMaintenanceService.updateById(entity1);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(AfterSalesMaintenanceEntity::getCustomerId, (Object)projectEntity.getCustomerId())).eq(AfterSalesMaintenanceEntity::getMaintenanceType, (Object)AllMaintenanceTypeEnum.PRODUCTLINE.getType())).eq(AfterSalesMaintenanceEntity::getIncomeType, (Object)projectEntity.getIncomeType())).isNotNull(AfterSalesMaintenanceEntity::getExpirationDate)).orderByDesc(AfterSalesMaintenanceEntity::getExpirationDate);
        List list = this.afterSalesMaintenanceService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            list.remove(0);
            List<String> idlist = list.stream().map(AfterSalesMaintenanceEntity::getId).collect(Collectors.toList());
            this.afterSalesMaintenanceService.deleteBatchIds(idlist);
        }
        if (ObjectUtil.isNull((Object)(entity = this.afterSalesMaintenanceService.getCustomerId(projectEntity)))) {
            LocalDate endDate;
            LocalDate now;
            String productList;
            String collect;
            List<RkContractProductEntity> listByContractId;
            AfterSalesMaintenanceEntity maintenanceEntity = new AfterSalesMaintenanceEntity();
            maintenanceEntity.setMaintenanceType(AllMaintenanceTypeEnum.MAINTENANCEFOLLOW.getType());
            maintenanceEntity.setFollowStatus(AllMaintenanceTypeEnum.FOLLOWED.getType());
            maintenanceEntity.setProjectId(projectEntity.getId());
            maintenanceEntity.setProjectName(projectEntity.getProjectName());
            maintenanceEntity.setProjectCode(projectEntity.getProjectCode());
            maintenanceEntity.setProjectAmount(projectEntity.getProjectAmount());
            maintenanceEntity.setSalerId(projectEntity.getSalerId());
            maintenanceEntity.setSalerName(projectEntity.getSalerName());
            maintenanceEntity.setCompanyId(afterSalesProjectsEntity.getCompanyId());
            maintenanceEntity.setProductId(afterSalesProjectsEntity.getProduct());
            maintenanceEntity.setTransferDate(afterSalesProjectsEntity.getTransferDate());
            maintenanceEntity.setCustomerId(afterSalesProjectsEntity.getCustomerId());
            maintenanceEntity.setCustomerName(afterSalesProjectsEntity.getCustomerName());
            maintenanceEntity.setState(afterSalesProjectsEntity.getWarrantyState());
            maintenanceEntity.setExpirationDate(afterSalesProjectsEntity.getWarrantyEndDate());
            maintenanceEntity.setContractSignDate(afterSalesProjectsEntity.getContractSignDate());
            maintenanceEntity.setAfterSalesRegional(afterSalesProjectsEntity.getAfterSalesManager());
            maintenanceEntity.setAfterSalesPerson(afterSalesProjectsEntity.getAfterSalesAssistant());
            maintenanceEntity.setDepartmentId(projectEntity.getDepartment());
            maintenanceEntity.setAssistantsUser(afterSalesProjectsEntity.getAssistantsUser());
            maintenanceEntity.setIncomeType(afterSalesProjectsEntity.getIncomeType());
            maintenanceEntity.setCustomerAddress(afterSalesProjectsEntity.getAddress());
            if (!StrUtil.isBlank((CharSequence)projectEntity.getContractId())) {
                listByContractId = this.rkContractProductService.getListByContractId(projectEntity.getContractId());
                collect = listByContractId.stream().map(RkContractProductEntity::getProductName).collect(Collectors.joining(","));
                productList = listByContractId.stream().map(RkContractProductEntity::getProductId).collect(Collectors.joining(","));
                maintenanceEntity.setProductId(productList);
                maintenanceEntity.setProductName(collect);
                if (ObjectUtil.isNotEmpty((Object)contractEntity)) {
                    maintenanceEntity.setContractId(contractEntity.getId());
                    maintenanceEntity.setContractCode(contractEntity.getContractCode());
                    maintenanceEntity.setContractName(contractEntity.getContractName());
                    maintenanceEntity.setContractAmount(contractEntity.getContractAmount());
                    maintenanceEntity.setAgentId(contractEntity.getAgentId());
                    if (ObjectUtil.equals((Object)contractEntity.getIsAgent(), (Object)1)) {
                        RkAgentEntity agent;
                        if (StringUtils.isNotEmpty((String)contractEntity.getAgentId()) && null != (agent = this.agentService.getInfo(contractEntity.getAgentId()))) {
                            maintenanceEntity.setAgentName(agent.getName());
                        }
                    } else if (StringUtils.isNotEmpty((String)contractEntity.getCustomerIds())) {
                        maintenanceEntity.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(contractEntity.getId()));
                    }
                }
            } else if (!StrUtil.isBlank((CharSequence)projectEntity.getNoContractId())) {
                listByContractId = this.rkContractProductService.getListByContractId(projectEntity.getNoContractId());
                collect = listByContractId.stream().map(RkContractProductEntity::getProductName).collect(Collectors.joining(","));
                productList = listByContractId.stream().map(RkContractProductEntity::getProductId).collect(Collectors.joining(","));
                maintenanceEntity.setProductId(productList);
                maintenanceEntity.setProductName(collect);
                SaleNoContractEntity noContract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)projectEntity.getNoContractId()));
                if (null != noContract) {
                    maintenanceEntity.setContractId(noContract.getId());
                    maintenanceEntity.setContractCode(noContract.getContractCode());
                    maintenanceEntity.setContractName(noContract.getContractName());
                    maintenanceEntity.setContractAmount(noContract.getExpectedContractAmount());
                    maintenanceEntity.setAgentId(noContract.getCustomerId());
                    if (StringUtils.isNotEmpty((String)noContract.getCustomerIds())) {
                        maintenanceEntity.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(noContract.getId()));
                    }
                }
            }
            if (ObjectUtil.isNotEmpty((Object)maintenanceEntity.getState()) && ObjectUtil.isNotEmpty((Object)maintenanceEntity.getExpirationDate()) && !StrUtil.equals((CharSequence)maintenanceEntity.getState(), (CharSequence)"derelivery")) {
                now = LocalDate.now();
                long between = ChronoUnit.DAYS.between(now, endDate = LocalDate.ofEpochDay(maintenanceEntity.getExpirationDate().getTime() / 86400000L));
                if ((int)between <= 60) {
                    maintenanceEntity.setWarrantyState(AllMaintenanceTypeEnum.NORMAL.getType());
                }
                if ((int)between <= 0 && (int)between >= -60) {
                    maintenanceEntity.setWarrantyState(AllMaintenanceTypeEnum.OVERDUEWARNING.getType());
                }
            }
            if (StrUtil.equals((CharSequence)maintenanceEntity.getState(), (CharSequence)"derelivery") && ObjectUtil.isNotEmpty((Object)maintenanceEntity.getExpirationDate())) {
                now = LocalDate.now();
                endDate = LocalDate.ofEpochDay(maintenanceEntity.getExpirationDate().getTime() / 86400000L);
                long between = ChronoUnit.DAYS.between(endDate, now);
                if ((int)between <= 60) {
                    maintenanceEntity.setWarrantyState(AllMaintenanceTypeEnum.NORMAL.getType());
                }
                if ((int)between <= 0 && (int)between >= -60) {
                    maintenanceEntity.setWarrantyState(AllMaintenanceTypeEnum.OVERDUEWARNING.getType());
                }
            }
            this.afterSalesMaintenanceService.create(maintenanceEntity);
        } else if (!HolidayUtil.judgmentDate(entity.getExpirationDate(), afterSalesProjectsEntity.getWarrantyEndDate()).booleanValue()) {
            LocalDate endDate;
            LocalDate now;
            String productList;
            String collect;
            List<RkContractProductEntity> listByContractId;
            AfterSalesMaintenanceEntity maintenanceEntity = new AfterSalesMaintenanceEntity();
            maintenanceEntity.setProjectId(projectEntity.getId());
            maintenanceEntity.setProjectName(projectEntity.getProjectName());
            maintenanceEntity.setProjectCode(projectEntity.getProjectCode());
            maintenanceEntity.setProjectAmount(projectEntity.getProjectAmount());
            maintenanceEntity.setSalerId(projectEntity.getSalerId());
            maintenanceEntity.setSalerName(projectEntity.getSalerName());
            maintenanceEntity.setCompanyId(afterSalesProjectsEntity.getCompanyId());
            maintenanceEntity.setProductId(afterSalesProjectsEntity.getProduct());
            maintenanceEntity.setTransferDate(afterSalesProjectsEntity.getTransferDate());
            maintenanceEntity.setCustomerId(afterSalesProjectsEntity.getCustomerId());
            maintenanceEntity.setCustomerName(afterSalesProjectsEntity.getCustomerName());
            maintenanceEntity.setState(afterSalesProjectsEntity.getWarrantyState());
            maintenanceEntity.setExpirationDate(afterSalesProjectsEntity.getWarrantyEndDate());
            maintenanceEntity.setContractSignDate(afterSalesProjectsEntity.getContractSignDate());
            maintenanceEntity.setAfterSalesRegional(afterSalesProjectsEntity.getAfterSalesManager());
            maintenanceEntity.setAfterSalesPerson(afterSalesProjectsEntity.getAfterSalesAssistant());
            maintenanceEntity.setDepartmentId(projectEntity.getDepartment());
            maintenanceEntity.setAssistantsUser(afterSalesProjectsEntity.getAssistantsUser());
            maintenanceEntity.setIncomeType(afterSalesProjectsEntity.getIncomeType());
            maintenanceEntity.setCustomerAddress(afterSalesProjectsEntity.getAddress());
            if (!StrUtil.isBlank((CharSequence)projectEntity.getContractId())) {
                listByContractId = this.rkContractProductService.getListByContractId(projectEntity.getContractId());
                collect = listByContractId.stream().map(RkContractProductEntity::getProductName).collect(Collectors.joining(","));
                productList = listByContractId.stream().map(RkContractProductEntity::getProductId).collect(Collectors.joining(","));
                maintenanceEntity.setProductId(productList);
                maintenanceEntity.setProductName(collect);
                if (ObjectUtil.isNotEmpty((Object)contractEntity)) {
                    maintenanceEntity.setContractId(contractEntity.getId());
                    maintenanceEntity.setContractCode(contractEntity.getContractCode());
                    maintenanceEntity.setContractName(contractEntity.getContractName());
                    maintenanceEntity.setContractAmount(contractEntity.getContractAmount());
                    maintenanceEntity.setAgentId(contractEntity.getAgentId());
                    if (ObjectUtil.equals((Object)contractEntity.getIsAgent(), (Object)1)) {
                        RkAgentEntity agent;
                        if (StringUtils.isNotEmpty((String)contractEntity.getAgentId()) && null != (agent = this.agentService.getInfo(contractEntity.getAgentId()))) {
                            maintenanceEntity.setAgentName(agent.getName());
                        }
                    } else if (StringUtils.isNotEmpty((String)contractEntity.getCustomerIds())) {
                        maintenanceEntity.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(contractEntity.getId()));
                    }
                }
            } else if (!StrUtil.isBlank((CharSequence)projectEntity.getNoContractId())) {
                listByContractId = this.rkContractProductService.getListByContractId(projectEntity.getNoContractId());
                collect = listByContractId.stream().map(RkContractProductEntity::getProductName).collect(Collectors.joining(","));
                productList = listByContractId.stream().map(RkContractProductEntity::getProductId).collect(Collectors.joining(","));
                maintenanceEntity.setProductId(productList);
                maintenanceEntity.setProductName(collect);
                SaleNoContractEntity noContract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)projectEntity.getNoContractId()));
                if (null != noContract) {
                    maintenanceEntity.setContractId(noContract.getId());
                    maintenanceEntity.setContractCode(noContract.getContractCode());
                    maintenanceEntity.setContractName(noContract.getContractName());
                    maintenanceEntity.setContractAmount(noContract.getExpectedContractAmount());
                    maintenanceEntity.setAgentId(noContract.getCustomerId());
                    if (StringUtils.isNotEmpty((String)noContract.getCustomerIds())) {
                        maintenanceEntity.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(noContract.getId()));
                    }
                }
            }
            if (ObjectUtil.isNotEmpty((Object)maintenanceEntity.getState()) && ObjectUtil.isNotEmpty((Object)maintenanceEntity.getExpirationDate()) && !StrUtil.equals((CharSequence)maintenanceEntity.getState(), (CharSequence)"derelivery")) {
                now = LocalDate.now();
                long between = ChronoUnit.DAYS.between(now, endDate = LocalDate.ofEpochDay(maintenanceEntity.getExpirationDate().getTime() / 86400000L));
                if ((int)between <= 60) {
                    maintenanceEntity.setWarrantyState(AllMaintenanceTypeEnum.NORMAL.getType());
                }
                if ((int)between <= 0 && (int)between >= -60) {
                    maintenanceEntity.setWarrantyState(AllMaintenanceTypeEnum.OVERDUEWARNING.getType());
                }
            }
            if (StrUtil.equals((CharSequence)maintenanceEntity.getState(), (CharSequence)"derelivery") && ObjectUtil.isNotEmpty((Object)maintenanceEntity.getExpirationDate())) {
                now = LocalDate.now();
                endDate = LocalDate.ofEpochDay(maintenanceEntity.getExpirationDate().getTime() / 86400000L);
                long between = ChronoUnit.DAYS.between(endDate, now);
                if ((int)between <= 60) {
                    maintenanceEntity.setWarrantyState(AllMaintenanceTypeEnum.NORMAL.getType());
                }
                if ((int)between <= 0 && (int)between >= -60) {
                    maintenanceEntity.setWarrantyState(AllMaintenanceTypeEnum.OVERDUEWARNING.getType());
                }
            }
            maintenanceEntity.setMaintenanceType(AllMaintenanceTypeEnum.MAINTENANCEFOLLOW.getType());
            this.afterSalesMaintenanceService.update(entity.getId(), maintenanceEntity);
        }
        if (CollectionUtil.isNotEmpty(attachments)) {
            this.attachmentService.saveBatch(attachments);
        }
    }

    @Override
    public List<Map<String, Object>> countTabs(AfterSalesProjectsPagination afterSalesProjectsPagination) {
        List map = CollectionUtil.list((boolean)false);
        QueryWrapper<AfterSalesProjectsEntity> queryWrapper = this.appendWrapper(afterSalesProjectsPagination);
        if (ObjectUtil.isNull(queryWrapper)) {
            return map;
        }
        queryWrapper.select(new String[]{"warranty_state as warrantyState,count(*) as count"});
        queryWrapper.groupBy((Object)"warranty_state");
        List listMaps = this.listMaps((Wrapper)queryWrapper);
        return listMaps;
    }

    @Override
    public void updateStateEnd() {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(AfterSalesProjectsEntity::getWarrantyState, (Object)AfterSalesProjectWarrantyStateEnum.DERELIVERY_STATE.getState())).ne(AfterSalesProjectsEntity::getWarrantyState, (Object)AfterSalesProjectWarrantyStateEnum.DERELIVERY_STATE.getState())).lt(AfterSalesProjectsEntity::getWarrantyEndDate, (Object)DateUtil.getDayBegin());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public List<String[]> afterSalesQuestionExportDetail(String id) {
        ArrayList<String[]> testList = new ArrayList<String[]>();
        AfterSalesQuestionPagination afterSalesQuestionPagination = new AfterSalesQuestionPagination();
        afterSalesQuestionPagination.setProjectId(id);
        afterSalesQuestionPagination.setIsAudit(0);
        List<AfterSalesQuestionEntity> list = this.afterSalesQuestionService.getList(afterSalesQuestionPagination);
        if (CollectionUtil.isEmpty(list)) {
            testList.add(new String[13]);
            return testList;
        }
        List<AfterSalesQuestionListVO> afterSalesQuestionListVOS = this.appendVo(list);
        for (int i = 0; i < afterSalesQuestionListVOS.size(); ++i) {
            String[] employee = new String[13];
            AfterSalesQuestionListVO listVO = afterSalesQuestionListVOS.get(i);
            employee[0] = String.valueOf(i + 1);
            employee[1] = DateUtil.dateFormat((Date)listVO.getCreatorTime());
            employee[2] = listVO.getDescription();
            employee[3] = listVO.getType();
            employee[4] = listVO.getContactsName();
            employee[5] = listVO.getContactsPhone();
            employee[6] = ObjectUtils.isNotEmpty((Object)listVO.getReservationEstimatedTime()) ? DateUtil.dateFormat((Date)listVO.getReservationEstimatedTime()) : "---";
            employee[7] = ObjectUtils.isNotEmpty((Object)listVO.getReservationEstimatedTime()) ? DateUtil.dateFormat((Date)listVO.getDealTime()) : "---";
            testList.add(employee);
        }
        return testList;
    }

    @Override
    public List<String[]> afterInspectTaskExportDetail(String id) {
        ArrayList<String[]> testList = new ArrayList<String[]>();
        List<AfterInspectTaskListVO> taskListVO = this.afterInspectTaskService.getListByProjectId(id);
        if (CollectionUtil.isEmpty(taskListVO)) {
            testList.add(new String[13]);
            return testList;
        }
        List allCompanyList = this.organizeService.getAllCompanyList("");
        block0: for (AfterInspectTaskListVO task : taskListVO) {
            task.setEnabledMark(this.baseDataUtil.getDictName(task.getEnabledMark(), "executingState"));
            for (OrganizeEntity company : allCompanyList) {
                if (!StringUtils.isNotEmpty((String)task.getCompanyId()) || !company.getId().equals(task.getCompanyId())) continue;
                task.setCompanyName(company.getFullName());
                continue block0;
            }
        }
        for (int i = 0; i < taskListVO.size(); ++i) {
            String[] employee = new String[13];
            AfterInspectTaskListVO listVO = taskListVO.get(i);
            employee[0] = String.valueOf(i + 1);
            employee[1] = listVO.getProjectName();
            employee[2] = listVO.getProjectCode();
            employee[3] = listVO.getInspectionContent();
            employee[4] = listVO.getEnabledMark();
            employee[5] = listVO.getInspectUserName();
            employee[6] = DateUtil.dateFormat((Date)listVO.getCreatorTime());
            testList.add(employee);
        }
        return testList;
    }

    @Override
    public List<String[]> rkContractExportDetail(String id) {
        ArrayList<String[]> testList = new ArrayList<String[]>();
        RkContractEntity info = this.rkContractService.getInfo(id);
        if (ObjectUtil.isEmpty((Object)info)) {
            testList.add(new String[13]);
            return testList;
        }
        String[] employee = new String[13];
        employee[0] = "1";
        employee[1] = info.getContractName();
        employee[2] = info.getContractCode();
        employee[3] = String.valueOf(info.getContractAmount());
        employee[4] = ObjectUtil.isNotEmpty((Object)info.getReturnAmount()) ? String.valueOf(info.getReturnAmount()) : "0";
        employee[5] = ObjectUtil.isNotEmpty((Object)info.getWarranty()) ? String.valueOf(info.getWarranty()) : "0";
        testList.add(employee);
        return testList;
    }

    private List<AfterSalesQuestionListVO> appendVo(List<AfterSalesQuestionEntity> list) {
        for (AfterSalesQuestionEntity entity : list) {
            entity.setType(this.baseDataUtil.getDictName(entity.getType(), "problemType"));
            entity.setPriority(this.baseDataUtil.getDictName(entity.getPriority(), "problemPriority"));
            entity.setDealUser(this.baseDataUtil.userSelectValueNoAccount(entity.getDealUser()));
            if (entity.getFeedbackSource() == 3) {
                entity.setCreatorUserId(entity.getContactsName());
                continue;
            }
            entity.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(entity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, AfterSalesQuestionListVO.class);
        for (AfterSalesQuestionListVO afterSalesQuestionVO : listVO) {
            OrganizeEntity byId1;
            String companyId;
            OrganizeEntity info1;
            UserEntity info2;
            UserEntity info;
            OrganizeEntity byId12;
            afterSalesQuestionVO.setProcessedById(afterSalesQuestionVO.getProcessedBy());
            afterSalesQuestionVO.setProcessedBy(this.baseDataUtil.userSelectValueNoAccount(afterSalesQuestionVO.getProcessedBy()));
            afterSalesQuestionVO.setRegionManager(this.baseDataUtil.userSelectValue(afterSalesQuestionVO.getRegionManager()));
            afterSalesQuestionVO.setCreatorTimel(afterSalesQuestionVO.getCreatorTime());
            afterSalesQuestionVO.setEnabledMarkCode(afterSalesQuestionVO.getEnabledMark());
            afterSalesQuestionVO.setEnabledMark(this.baseDataUtil.getDictName(afterSalesQuestionVO.getEnabledMark(), "problemStatus"));
            afterSalesQuestionVO.setFourStateCode(afterSalesQuestionVO.getFourState());
            afterSalesQuestionVO.setFourState(this.baseDataUtil.getDictName(afterSalesQuestionVO.getFourState(), "problemStatus"));
            afterSalesQuestionVO.setFeedbackSourceDec(this.baseDataUtil.getDictName(afterSalesQuestionVO.getFeedbackSource() + "", "questionFeedbackSource"));
            String s = DateUtils.dateDiffStr(afterSalesQuestionVO.getCreatorTime(), new Date());
            afterSalesQuestionVO.setOverTimeStr(s);
            afterSalesQuestionVO.setOverTime(DateUtil.dateDiff((Date)afterSalesQuestionVO.getCreatorTime(), (Date)new Date()));
            if (StrUtil.isNotEmpty((CharSequence)afterSalesQuestionVO.getProductId())) {
                List<String> productIdList = Arrays.asList(afterSalesQuestionVO.getProductId().split(","));
                List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(productIdList);
                String collect = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
                afterSalesQuestionVO.setProductName(collect);
            }
            if (StrUtil.isNotEmpty((CharSequence)afterSalesQuestionVO.getCustomerId())) {
                CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)afterSalesQuestionVO.getCustomerId()));
                afterSalesQuestionVO.setCustomerName(byId.getName());
            }
            if (StringUtil.isNotEmpty((String)afterSalesQuestionVO.getCompanyId()) && ObjectUtil.isNull((Object)(byId12 = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)afterSalesQuestionVO.getCompanyId()))))) {
                afterSalesQuestionVO.setCompanyName(byId12.getFullName());
            }
            if (StringUtils.isNotEmpty((String)afterSalesQuestionVO.getCreatorUserId()) && ObjectUtil.isNotEmpty((Object)(info = this.userService.getByRealName(afterSalesQuestionVO.getCreatorUserId()))) && ObjectUtil.isNotEmpty((Object)(info2 = this.userService.getInfo(info.getId()))) && ObjectUtil.isNotEmpty((Object)(info1 = this.organizeService.getInfo(info2.getOrganizeId())))) {
                afterSalesQuestionVO.setDepartmentName(info1.getFullName());
            }
            if (!StrUtil.isNotEmpty((CharSequence)(companyId = afterSalesQuestionVO.getCompanyId())) || ObjectUtil.isNull((Object)(byId1 = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)companyId))))) continue;
            afterSalesQuestionVO.setCompanyName(byId1.getFullName());
        }
        return listVO;
    }
}

