/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.OaContractCustomerEntity;
import com.bringspring.contract.mapper.OaContractCustomerMapper;
import com.bringspring.contract.model.oacontractcustomer.OaContractCustomerCrForm;
import com.bringspring.contract.model.oacontractcustomer.OaContractCustomerPagination;
import com.bringspring.contract.model.oacontractcustomer.OaContractCustomerUpForm;
import com.bringspring.contract.service.OaContractCustomerService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaContractCustomerServiceImpl
extends ServiceImpl<OaContractCustomerMapper, OaContractCustomerEntity>
implements OaContractCustomerService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Override
    public List<OaContractCustomerEntity> getList(OaContractCustomerPagination oaContractCustomerPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean oaContractCustomerNum = false;
        QueryWrapper oaContractCustomerQueryWrapper = new QueryWrapper();
        if (AllIdList.size() > 0) {
            oaContractCustomerQueryWrapper.lambda().in(OaContractCustomerEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaContractCustomerPagination.getSidx())) {
            oaContractCustomerQueryWrapper.lambda().orderByDesc(OaContractCustomerEntity::getId);
        } else {
            try {
                String sidx = oaContractCustomerPagination.getSidx();
                OaContractCustomerEntity oaContractCustomerEntity = new OaContractCustomerEntity();
                Field declaredField = oaContractCustomerEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaContractCustomerQueryWrapper = "asc".equals(oaContractCustomerPagination.getSort().toLowerCase()) ? (QueryWrapper)oaContractCustomerQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaContractCustomerQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(oaContractCustomerPagination.getCurrentPage(), oaContractCustomerPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)oaContractCustomerQueryWrapper);
            return oaContractCustomerPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return oaContractCustomerPagination.setData(list, list.size());
    }

    @Override
    public List<OaContractCustomerEntity> getTypeList(OaContractCustomerPagination oaContractCustomerPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean oaContractCustomerNum = false;
        QueryWrapper oaContractCustomerQueryWrapper = new QueryWrapper();
        if (AllIdList.size() > 0) {
            oaContractCustomerQueryWrapper.lambda().in(OaContractCustomerEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)oaContractCustomerPagination.getSidx())) {
            oaContractCustomerQueryWrapper.lambda().orderByDesc(OaContractCustomerEntity::getId);
        } else {
            try {
                String sidx = oaContractCustomerPagination.getSidx();
                OaContractCustomerEntity oaContractCustomerEntity = new OaContractCustomerEntity();
                Field declaredField = oaContractCustomerEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaContractCustomerQueryWrapper = "asc".equals(oaContractCustomerPagination.getSort().toLowerCase()) ? (QueryWrapper)oaContractCustomerQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaContractCustomerQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(oaContractCustomerPagination.getCurrentPage(), oaContractCustomerPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)oaContractCustomerQueryWrapper);
                return oaContractCustomerPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return oaContractCustomerPagination.setData(list, list.size());
        }
        return this.list((Wrapper)oaContractCustomerQueryWrapper);
    }

    @Override
    public OaContractCustomerEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaContractCustomerEntity::getId, (Object)id);
        return (OaContractCustomerEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(OaContractCustomerCrForm oaContractCustomerCrForm) {
        String mainId = RandomUtil.uuId();
        OaContractCustomerEntity entity = (OaContractCustomerEntity)JsonUtil.getJsonToBean((Object)oaContractCustomerCrForm, OaContractCustomerEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, OaContractCustomerUpForm oaContractCustomerUpForm) {
        UserInfo userInfo = this.userProvider.get();
        OaContractCustomerEntity entity = this.getInfo(id);
        if (entity != null) {
            OaContractCustomerEntity subentity = (OaContractCustomerEntity)JsonUtil.getJsonToBean((Object)oaContractCustomerUpForm, OaContractCustomerEntity.class);
            subentity.setContractId(DateUtil.getNow());
            this.updateById(subentity);
        }
    }

    @Override
    @DSTransactional
    public void delete(OaContractCustomerEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<OaContractCustomerEntity> getListByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaContractCustomerEntity::getContractId, (Object)contractId);
        List list = this.list((Wrapper)queryWrapper);
        for (OaContractCustomerEntity entity : list) {
            if (!StringUtils.isEmpty((String)entity.getAddressName()) || !StringUtils.isNotEmpty((String)entity.getAddress())) continue;
            entity.setAddressName(this.baseDataUtil.provinceData(entity.getAddress()));
        }
        return list;
    }

    @Override
    public String getCustomerNamesByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaContractCustomerEntity::getContractId, (Object)contractId);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return list.stream().map(OaContractCustomerEntity::getCustomerName).collect(Collectors.joining(","));
        }
        return "";
    }

    @Override
    public void removeByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaContractCustomerEntity::getContractId, (Object)contractId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<OaContractCustomerEntity> insertListByCustomerIds(String contractId, String customerIds) {
        if (StringUtils.isNotEmpty((String)contractId) && StringUtils.isNotEmpty((String)customerIds)) {
            ArrayList<OaContractCustomerEntity> entityList = new ArrayList<OaContractCustomerEntity>();
            List<String> customerList = Arrays.asList(customerIds.split(","));
            OaContractCustomerEntity entity = null;
            CrmCustomerEntity customer = null;
            List addressList = null;
            for (String customerId : customerList) {
                entity = new OaContractCustomerEntity();
                entity.setId(RandomUtil.uuId());
                entity.setContractId(contractId);
                entity.setCustomerId(customerId);
                customer = this.crmCustomerService.getInfo(customerId);
                if (null != customer) {
                    entity.setCustomerName(customer.getName());
                    entity.setAddress(customer.getAddress());
                    entity.setAddressName(this.baseDataUtil.provinceData(entity.getAddress()));
                    if (StringUtils.isNotEmpty((String)customer.getAddress())) {
                        addressList = JSON.parseArray((String)customer.getAddress(), String.class);
                        if (!addressList.isEmpty()) {
                            entity.setRegion((String)addressList.get(0));
                            entity.setRegionName(this.baseDataUtil.provinceData(entity.getRegion()));
                        }
                        if (addressList.size() > 1) {
                            entity.setProv((String)addressList.get(1));
                            entity.setProvName(this.baseDataUtil.provinceData(entity.getProv()));
                        }
                        if (addressList.size() > 2) {
                            entity.setCity((String)addressList.get(2));
                            entity.setCityName(this.baseDataUtil.provinceData(entity.getCity()));
                        }
                    }
                }
                entityList.add(entity);
            }
            this.saveBatch(entityList);
        }
        return Collections.emptyList();
    }
}

