/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.OaFileEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.mapper.OaFileMapper;
import com.bringspring.contract.model.oafile.FileImportReturnVO;
import com.bringspring.contract.model.oafile.FileImportVO;
import com.bringspring.contract.model.oafile.OaFilePagination;
import com.bringspring.contract.model.oafile.OaFileUpForm;
import com.bringspring.contract.model.rkattachment.RkAttachmentUpForm;
import com.bringspring.contract.service.OaFileService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.FileEncodeEnum;
import com.bringspring.contract.utils.Records;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaFileServiceImpl
extends ServiceImpl<OaFileMapper, OaFileEntity>
implements OaFileService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Override
    public List<OaFileEntity> getList(OaFilePagination oaFilePagination) {
        Object oaFileObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaFileNum = 0;
        QueryWrapper oaFileQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaFileObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaFileQueryWrapper, oaFilePagination.getMenuId(), "oaFile"));
            if (ObjectUtil.isEmpty((Object)oaFileObj)) {
                return new ArrayList<OaFileEntity>();
            }
            oaFileQueryWrapper = (QueryWrapper)oaFileObj;
            ++oaFileNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaFileObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaFileQueryWrapper, oaFilePagination.getMenuId(), "oaFile"));
            if (ObjectUtil.isEmpty((Object)oaFileObj)) {
                return new ArrayList<OaFileEntity>();
            }
            oaFileQueryWrapper = (QueryWrapper)oaFileObj;
            ++oaFileNum;
        }
        if (ObjectUtil.isNotEmpty((Object)oaFilePagination.getFileCode())) {
            ++oaFileNum;
            oaFileQueryWrapper.lambda().like(OaFileEntity::getFileCode, (Object)oaFilePagination.getFileCode());
        }
        if (ObjectUtil.isNotEmpty((Object)oaFilePagination.getChoseType())) {
            ++oaFileNum;
            oaFileQueryWrapper.lambda().eq(OaFileEntity::getChoseType, (Object)oaFilePagination.getChoseType());
        }
        if (ObjectUtil.isNotEmpty((Object)oaFilePagination.getFileName())) {
            ++oaFileNum;
            oaFileQueryWrapper.lambda().like(OaFileEntity::getFileName, (Object)oaFilePagination.getFileName());
        }
        if (ObjectUtil.isNotEmpty((Object)oaFilePagination.getRecordStatus())) {
            ++oaFileNum;
            oaFileQueryWrapper.lambda().like(OaFileEntity::getRecordStatus, (Object)oaFilePagination.getRecordStatus());
        }
        if (AllIdList.size() > 0) {
            oaFileQueryWrapper.lambda().in(OaFileEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)oaFilePagination.getSidx())) {
            oaFileQueryWrapper.lambda().orderByDesc(OaFileEntity::getFileDate);
        } else {
            try {
                String sidx = oaFilePagination.getSidx();
                OaFileEntity oaFileEntity = new OaFileEntity();
                Field declaredField = oaFileEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaFileQueryWrapper = "asc".equals(oaFilePagination.getSort().toLowerCase()) ? (QueryWrapper)oaFileQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaFileQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(oaFilePagination.getCurrentPage(), oaFilePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)oaFileQueryWrapper);
            return oaFilePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return oaFilePagination.setData(list, list.size());
    }

    @Override
    public List<OaFileEntity> getTypeList(OaFilePagination oaFilePagination, String dataType) {
        Object oaFileObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int oaFileNum = 0;
        QueryWrapper oaFileQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaFileObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaFileQueryWrapper, oaFilePagination.getMenuId(), "oaFile"));
            if (ObjectUtil.isEmpty((Object)oaFileObj)) {
                return new ArrayList<OaFileEntity>();
            }
            oaFileQueryWrapper = (QueryWrapper)oaFileObj;
            ++oaFileNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            oaFileObj = this.authorizeService.getCondition(new AuthorizeConditionModel(oaFileQueryWrapper, oaFilePagination.getMenuId(), "oaFile"));
            if (ObjectUtil.isEmpty((Object)oaFileObj)) {
                return new ArrayList<OaFileEntity>();
            }
            oaFileQueryWrapper = (QueryWrapper)oaFileObj;
            ++oaFileNum;
        }
        if (ObjectUtil.isNotEmpty((Object)oaFilePagination.getFileCode())) {
            ++oaFileNum;
            oaFileQueryWrapper.lambda().like(OaFileEntity::getFileCode, (Object)oaFilePagination.getFileCode());
        }
        if (ObjectUtil.isNotEmpty((Object)oaFilePagination.getChoseType())) {
            ++oaFileNum;
            oaFileQueryWrapper.lambda().eq(OaFileEntity::getChoseType, (Object)oaFilePagination.getChoseType());
        }
        if (ObjectUtil.isNotEmpty((Object)oaFilePagination.getFileName())) {
            ++oaFileNum;
            oaFileQueryWrapper.lambda().like(OaFileEntity::getFileName, (Object)oaFilePagination.getFileName());
        }
        if (ObjectUtil.isNotEmpty((Object)oaFilePagination.getRecordStatus())) {
            ++oaFileNum;
            oaFileQueryWrapper.lambda().like(OaFileEntity::getRecordStatus, (Object)oaFilePagination.getRecordStatus());
        }
        if (AllIdList.size() > 0) {
            oaFileQueryWrapper.lambda().in(OaFileEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)oaFilePagination.getSidx())) {
            oaFileQueryWrapper.lambda().orderByDesc(OaFileEntity::getFileDate);
        } else {
            try {
                String sidx = oaFilePagination.getSidx();
                OaFileEntity oaFileEntity = new OaFileEntity();
                Field declaredField = oaFileEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                oaFileQueryWrapper = "asc".equals(oaFilePagination.getSort().toLowerCase()) ? (QueryWrapper)oaFileQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)oaFileQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(oaFilePagination.getCurrentPage(), oaFilePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)oaFileQueryWrapper);
                return oaFilePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return oaFilePagination.setData(list, list.size());
        }
        return this.list((Wrapper)oaFileQueryWrapper);
    }

    @Override
    public OaFileEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaFileEntity::getId, (Object)id);
        return (OaFileEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaFileEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OaFileEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public boolean updateFile(String id, OaFileUpForm oaFileUpForm) {
        if (CollectionUtil.isNotEmpty(oaFileUpForm.getAttachmentList())) {
            this.rkAttachmentService.deleteByContractId(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
            List<RkAttachmentUpForm> attachmentList = oaFileUpForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(id);
                attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
            this.rkAttachmentService.saveBatch(attachmentEntityList);
        }
        OaFileEntity entity = (OaFileEntity)JsonUtil.getJsonToBean((Object)oaFileUpForm, OaFileEntity.class);
        entity.setIsEdit(1);
        return this.updateById(entity);
    }

    @Override
    public void delete(OaFileEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public Map<String, Object> importPreview(List<Object> fileImportList, Object o) {
        int i;
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        for (i = 0; i < fileImportList.size(); ++i) {
            Map dataRowMap = new HashMap();
            Object fileImportVO = fileImportList.get(i);
            dataRowMap = (Map)JsonUtil.getJsonToBean((Object)fileImportVO, Map.class);
            dataRow.add(dataRowMap);
        }
        for (i = 1; i <= fileImportList.size(); ++i) {
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("AllowDBNull", true);
            columnsMap.put("AutoIncrement", false);
            columnsMap.put("AutoIncrementSeed", 0);
            columnsMap.put("AutoIncrementStep", 1);
            columnsMap.put("Caption", this.getColumns(o, i));
            columnsMap.put("ColumnMapping", 1);
            columnsMap.put("ColumnName", this.getColumns(o, i));
            columnsMap.put("Container", null);
            columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
            columnsMap.put("DateTimeMode", 3);
            columnsMap.put("DefaultValue", null);
            columnsMap.put("DesignMode", false);
            columnsMap.put("Expression", "");
            columnsMap.put("ExtendedProperties", "");
            columnsMap.put("MaxLength", -1);
            columnsMap.put("Namespace", "");
            columnsMap.put("Ordinal", 0);
            columnsMap.put("Prefix", "");
            columnsMap.put("ReadOnly", false);
            columnsMap.put("Site", null);
            columnsMap.put("Table", fileImportList);
            columnsMap.put("Unique", false);
            columns.add(columnsMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Object o, Integer key) {
        Map declaredFieldsInfo = MapUtil.newHashMap();
        try {
            declaredFieldsInfo = ReflectionUtil.getDeclaredFieldsInfo2((Object)o, (Map)MapUtil.newHashMap());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int i = 1;
        for (String s : declaredFieldsInfo.keySet()) {
            map.put(i, s);
            ++i;
        }
        return (String)map.get(key);
    }

    @Override
    public FileImportReturnVO importData(List<FileImportVO> dataList) {
        UserInfo userInfo = this.userProvider.get();
        String companyId = userInfo.getOrganizeId();
        HashMap dictMap = MapUtil.newHashMap();
        List<FileEncodeEnum> allToList = FileEncodeEnum.getAllToList();
        allToList.stream().forEach(fileEncodeEnum -> {
            String encode = fileEncodeEnum.getEncode();
            DictionaryTypeEntity typeEntityList = this.dictionaryTypeService.getInfoByEnCode(encode);
            String dictionaryTypeId = typeEntityList.getId();
            List data = this.dictionaryDataService.getList(dictionaryTypeId, Boolean.valueOf(true));
            Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getEnCode));
            dictMap.put(encode, collect);
        });
        List oaFileList = CollectionUtil.list((boolean)false);
        List errorList = CollectionUtil.list((boolean)false);
        boolean successNum = false;
        int errorNum = 0;
        List errorMsgList = CollectionUtil.list((boolean)false);
        for (FileImportVO fileImportVO : dataList) {
            String choseType = "";
            if (StrUtil.isNotEmpty((CharSequence)fileImportVO.getChoseType())) {
                Map stringStringMap = (Map)dictMap.get(FileEncodeEnum.CHOSE_TYPE_DICT.getEncode());
                String s = (String)stringStringMap.get(fileImportVO.getChoseType());
                if (StrUtil.isEmpty((CharSequence)s)) {
                    ++errorNum;
                    fileImportVO.setErrMsg("\u7c7b\u578b\u4e0d\u5b58\u5728");
                    errorMsgList.add(fileImportVO.getErrMsg());
                } else {
                    choseType = s;
                }
            }
            String recordPattern = "";
            if (StrUtil.isNotEmpty((CharSequence)fileImportVO.getSubitemType())) {
                Map stringStringMap = (Map)dictMap.get(FileEncodeEnum.RECORD_PATTERN_DICT.getEncode());
                String s = (String)stringStringMap.get(fileImportVO.getSubitemType());
                if (StrUtil.isEmpty((CharSequence)s)) {
                    ++errorNum;
                    fileImportVO.setErrMsg("\u5f62\u6001\u4e0d\u5b58\u5728");
                    errorMsgList.add(fileImportVO.getErrMsg());
                } else {
                    recordPattern = s;
                }
            }
            String secrecyLevel = "";
            if (StrUtil.isNotEmpty((CharSequence)fileImportVO.getSecrecyLevel())) {
                Map stringStringMap = (Map)dictMap.get(FileEncodeEnum.SECRECY_LEVEL_DICT.getEncode());
                String s = (String)stringStringMap.get(fileImportVO.getSecrecyLevel());
                if (StrUtil.isEmpty((CharSequence)s)) {
                    ++errorNum;
                    fileImportVO.setErrMsg("\u7ea7\u522b\u4e0d\u5b58\u5728");
                    errorMsgList.add(fileImportVO.getErrMsg());
                } else {
                    secrecyLevel = s;
                }
            }
            if (ObjectUtil.isNotEmpty((Object)fileImportVO.getFileCode())) {
                if (CollectionUtil.isNotEmpty(this.getListByCode(fileImportVO.getFileCode()))) {
                    ++errorNum;
                    fileImportVO.setErrMsg("\u6863\u6848\u7f16\u7801\u91cd\u590d");
                    errorMsgList.add(fileImportVO.getErrMsg());
                }
            } else {
                ++errorNum;
                fileImportVO.setErrMsg("\u8bf7\u586b\u5199\u6863\u6848\u7f16\u7801");
                errorMsgList.add(fileImportVO.getErrMsg());
            }
            if (ObjectUtil.isNotEmpty((Object)fileImportVO.getFileCode())) {
                fileImportVO.setFileCode(StrUtil.trim((CharSequence)fileImportVO.getFileCode()));
                if (CollectionUtil.isNotEmpty(this.getListByCode(fileImportVO.getFileCode()))) {
                    ++errorNum;
                    fileImportVO.setErrMsg("\u5f52\u6863\u7f16\u7801\u91cd\u590d");
                    errorMsgList.add(fileImportVO.getErrMsg());
                }
            } else {
                ++errorNum;
                fileImportVO.setErrMsg("\u8bf7\u586b\u5199\u5f52\u6863\u7f16\u7801");
                errorMsgList.add(fileImportVO.getErrMsg());
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                fileImportVO.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                fileImportVO.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(fileImportVO);
                continue;
            }
            fileImportVO.setChoseType(choseType);
            fileImportVO.setSecrecyLevel(secrecyLevel);
            OaFileEntity jsonToBean = (OaFileEntity)JsonUtil.getJsonToBean((Object)fileImportVO, OaFileEntity.class);
            oaFileList.add(jsonToBean);
            oaFileList.stream().forEach(file -> {
                file.setChoseTypeName(this.baseDataUtil.getDictName(file.getChoseType(), Records.CHOSE_TYPE_DICT));
                file.setRecordPatternName(this.baseDataUtil.getDictName(file.getRecordPattern(), Records.RECORD_PATTERN_DICT));
                file.setSecrecyLevelName(this.baseDataUtil.getDictName(file.getSecrecyLevel(), Records.SECRECY_LEVEL_DICT));
                file.setRecordStatus("not Archived");
                file.setRecordStatusName(this.baseDataUtil.getDictName(file.getRecordStatus(), Records.RECORD_STATUS_DICT));
                file.setCompanyId(userInfo.getOrganizeId());
                file.setFileId(userInfo.getUserId());
                file.setFileDate(new Date());
            });
        }
        this.saveBatch(oaFileList);
        FileImportReturnVO vo = new FileImportReturnVO();
        vo.setSnum(oaFileList.size());
        vo.setFnum(errorList.size());
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, FileImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @Override
    public List<OaFileEntity> getListByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaFileEntity::getRecordCode, (Object)code);
        return this.list((Wrapper)queryWrapper);
    }
}

