/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.OaProjectPlanApplyEntity;
import com.bringspring.contract.entity.OaProjectPlanDetailApplyEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectPlanDetailEntity;
import com.bringspring.contract.entity.RkProjectPlanEntity;
import com.bringspring.contract.entity.RkProjectTrendsEntity;
import com.bringspring.contract.mapper.OaProjectPlanApplyMapper;
import com.bringspring.contract.model.oaProjectStartWorkApply.OaProjectStartWorkApplyCrForm;
import com.bringspring.contract.model.rkprojectplan.RkProjectPlanCrForm;
import com.bringspring.contract.service.OaProjectPlanApplyService;
import com.bringspring.contract.service.OaProjectPlanDetailApplyService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectPlanDetailService;
import com.bringspring.contract.service.RkProjectPlanService;
import com.bringspring.contract.service.RkProjectTrendsService;
import com.bringspring.contract.utils.ProjectTrendsEnum;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaProjectPlanApplyServiceImpl
extends ServiceImpl<OaProjectPlanApplyMapper, OaProjectPlanApplyEntity>
implements OaProjectPlanApplyService {
    @Autowired
    private OaProjectPlanDetailApplyService OaProjectPlanDetailApplyService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private RkProjectTrendsService rkProjectTrendsService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProjectPlanService rkProjectPlanService;
    @Autowired
    private OaProjectPlanApplyService oaProjectPlanApplyService;
    @Autowired
    private RkProjectPlanDetailService rkProjectPlanDetailService;
    @Autowired
    private OaProjectPlanDetailApplyService oaProjectPlanDetailApplyService;

    @Override
    public OaProjectPlanApplyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectPlanApplyEntity::getId, (Object)id);
        return (OaProjectPlanApplyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel flowModel) throws Exception {
        Map formData = flowModel.getFormData();
        OaProjectPlanApplyEntity byId = (OaProjectPlanApplyEntity)this.getById((Serializable)((Object)id));
        if (ObjectUtil.isNull((Object)byId)) {
            return false;
        }
        RkContractProjectEntity projectEntity = this.rkContractProjectService.getInfo(byId.getProjectId());
        if (enableMark == 2) {
            if ("1".equals(byId.getIsProjectPlan())) {
                RkProjectPlanEntity planTemplateEntity = (RkProjectPlanEntity)JsonUtil.getJsonToBean((Object)byId, RkProjectPlanEntity.class);
                this.rkProjectPlanService.create(planTemplateEntity);
                List<OaProjectPlanDetailApplyEntity> rkProjectPlanDetailList = this.oaProjectPlanDetailApplyService.listByProjectId(projectEntity.getId());
                if (CollectionUtil.isNotEmpty(rkProjectPlanDetailList)) {
                    for (OaProjectPlanDetailApplyEntity rkProjectPlanDetail : rkProjectPlanDetailList) {
                        RkProjectPlanDetailEntity templateDetailEntity = (RkProjectPlanDetailEntity)JsonUtil.getJsonToBean((Object)rkProjectPlanDetail, RkProjectPlanDetailEntity.class);
                        this.rkProjectPlanDetailService.create(templateDetailEntity);
                    }
                }
            }
            projectEntity.setState("inOperation");
        }
        this.rkContractProjectService.updateById(projectEntity);
        return false;
    }

    @Override
    public Boolean create(OaProjectStartWorkApplyCrForm form) {
        UserInfo userInfo = this.userProvider.get();
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)form.getProjectId()));
        String mainId = form.getMainId();
        byId.setStartWorkApplyId(mainId);
        this.rkContractProjectService.updateById(byId);
        RkProjectTrendsEntity trendsEntity = new RkProjectTrendsEntity();
        trendsEntity.setId(RandomUtil.uuId());
        trendsEntity.setDescription(form.getDescription());
        trendsEntity.setProjectId(byId.getId());
        trendsEntity.setContractId(byId.getContractId());
        trendsEntity.setCustomerId(byId.getCustomerId());
        trendsEntity.setNodeType(ProjectTrendsEnum.START.getNode());
        trendsEntity.setNodeDesc(ProjectTrendsEnum.START.getDesc());
        this.rkProjectTrendsService.save(trendsEntity);
        RkProjectPlanCrForm rkProjectPlanCrForm = (RkProjectPlanCrForm)JsonUtil.getJsonToBean((Object)((Object)form), RkProjectPlanCrForm.class);
        Boolean isSuccess = this.createForm(rkProjectPlanCrForm, mainId, userInfo, "create");
        if (!isSuccess.booleanValue()) {
            return false;
        }
        if (CollectionUtil.isNotEmpty(form.getAttachmentList())) {
            List jsonToList = JsonUtil.getJsonToList(form.getAttachmentList(), RkAttachmentEntity.class);
            String finalFileType = "start";
            jsonToList.stream().forEach(att -> {
                att.setId(RandomUtil.uuId());
                att.setObjId(mainId);
                att.setProjectId(form.getProjectId());
                att.setFileType("project_start");
            });
            this.attachmentService.saveBatch(jsonToList);
        }
        return true;
    }

    @Override
    public Boolean createForm(RkProjectPlanCrForm rkProjectPlanCrForm, String mainId, UserInfo userInfo, String type) {
        OaProjectPlanApplyEntity entity = new OaProjectPlanApplyEntity();
        if (type.equals("create")) {
            OaProjectPlanApplyEntity infoByProjectId;
            if (CollectionUtil.isNotEmpty(rkProjectPlanCrForm.getPlanTime())) {
                rkProjectPlanCrForm.setPlanEndTime(rkProjectPlanCrForm.getPlanTime().get(1));
                rkProjectPlanCrForm.setPlanStartTime(rkProjectPlanCrForm.getPlanTime().get(0));
            }
            if (ObjectUtil.isNotNull((Object)(infoByProjectId = this.oaProjectPlanApplyService.getInfoByProjectId(rkProjectPlanCrForm.getProjectId())))) {
                return false;
            }
            entity = (OaProjectPlanApplyEntity)JsonUtil.getJsonToBean((Object)rkProjectPlanCrForm, OaProjectPlanApplyEntity.class);
            RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkProjectPlanCrForm.getProjectId()));
            if (ObjectUtil.isNotNull((Object)byId)) {
                entity.setContractId(byId.getContractId());
                entity.setCustomerId(byId.getCustomerId());
            }
            entity.setId(mainId);
            entity.setCompanyId(userInfo.getOrganizeId());
            this.oaProjectPlanApplyService.save(entity);
        }
        if (type.equals("update")) {
            entity = this.oaProjectPlanApplyService.getInfo(mainId);
        }
        rkProjectPlanCrForm.getRkprojectplandetailList().stream().forEach(detail -> {
            if (CollectionUtil.isNotEmpty(detail.getPlanTime())) {
                detail.setPlanStartTime(detail.getPlanTime().get(0));
                detail.setPlanEndTime(detail.getPlanTime().get(1));
            }
        });
        List RkProjectPlanDetailList = JsonUtil.getJsonToList(rkProjectPlanCrForm.getRkprojectplandetailList(), OaProjectPlanDetailApplyEntity.class);
        if (CollectionUtil.isNotEmpty((Collection)RkProjectPlanDetailList)) {
            for (OaProjectPlanDetailApplyEntity entitys : RkProjectPlanDetailList) {
                entitys.setTemplateDetailId(entitys.getId());
                entitys.setId(RandomUtil.uuId());
                entitys.setPlanId(entity.getId());
                entitys.setCompanyId(userInfo.getOrganizeId());
                entitys.setContractId(entity.getContractId());
                entitys.setCustomerId(entity.getCustomerId());
                entitys.setProjectId(entity.getProjectId());
                entitys.setTemplateId(entity.getPlanTemplateId());
                this.oaProjectPlanDetailApplyService.save(entitys);
                if (!CollectionUtil.isNotEmpty(entitys.getSubPlanChildren())) continue;
                entitys.getSubPlanChildren().stream().forEach(detail -> {
                    if (CollectionUtil.isNotEmpty(detail.getPlanTime())) {
                        detail.setPlanStartTime(detail.getPlanTime().get(0));
                        detail.setPlanEndTime(detail.getPlanTime().get(1));
                    }
                });
                List rkProjectPlanDetailSubPlanIdList = JsonUtil.getJsonToList(entitys.getSubPlanChildren(), OaProjectPlanDetailApplyEntity.class);
                for (OaProjectPlanDetailApplyEntity entitysSub : rkProjectPlanDetailSubPlanIdList) {
                    entitysSub.setTemplateDetailId(entitys.getId());
                    entitysSub.setId(RandomUtil.uuId());
                    entitysSub.setCompanyId(userInfo.getOrganizeId());
                    entitysSub.setContractId(entity.getContractId());
                    entitysSub.setCustomerId(entity.getCustomerId());
                    entitysSub.setProjectId(entity.getProjectId());
                    entitysSub.setTemplateId(entity.getPlanTemplateId());
                    entitysSub.setSubPlanId(entitys.getId());
                    this.oaProjectPlanDetailApplyService.save(entitysSub);
                }
            }
        }
        return true;
    }

    @Override
    public OaProjectPlanApplyEntity getInfoByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OaProjectPlanApplyEntity::getProjectId, (Object)projectId)).eq(OaProjectPlanApplyEntity::getEnabledMark, (Object)1);
        return (OaProjectPlanApplyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void updatePlan(OaProjectStartWorkApplyCrForm rkProjectPlanCrForm, String id) {
        UserInfo userInfo = this.userProvider.get();
        if (CollectionUtil.isNotEmpty(rkProjectPlanCrForm.getPlanTime())) {
            rkProjectPlanCrForm.setPlanEndTime(rkProjectPlanCrForm.getPlanTime().get(1));
            rkProjectPlanCrForm.setPlanStartTime(rkProjectPlanCrForm.getPlanTime().get(0));
        }
        OaProjectPlanApplyEntity entity = (OaProjectPlanApplyEntity)JsonUtil.getJsonToBean((Object)((Object)rkProjectPlanCrForm), OaProjectPlanApplyEntity.class);
        entity.setId(id);
        entity.setCompanyId(userInfo.getOrganizeId());
        this.updateById(entity);
        this.OaProjectPlanDetailApplyService.removeSubPlanId(id);
        RkProjectPlanCrForm planCrForm = (RkProjectPlanCrForm)JsonUtil.getJsonToBean((Object)((Object)rkProjectPlanCrForm), RkProjectPlanCrForm.class);
        Boolean isSuccess = this.createForm(planCrForm, id, userInfo, "update");
    }

    @Override
    public List<OaProjectPlanApplyEntity> getByProjectId(String projectId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(OaProjectPlanApplyEntity::getProjectId, (Object)projectId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public long countByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectPlanApplyEntity::getProjectId, (Object)projectId);
        return this.count((Wrapper)queryWrapper);
    }
}

