/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.contract.entity.OaProjectPlanDetailApplyEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectPlanChangeEntity;
import com.bringspring.contract.mapper.OaProjectPlanDetailApplyMapper;
import com.bringspring.contract.model.rkprojectplanchange.RkProjectPlanChangeCrForm;
import com.bringspring.contract.service.OaProjectPlanDetailApplyService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectPlanChangeService;
import com.bringspring.contract.utils.ProjectPlanChangeEnum;
import com.bringspring.contract.utils.ProjectPlanExecutionResultEnum;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OaProjectPlanDetailApplyServiceImpl
extends ServiceImpl<OaProjectPlanDetailApplyMapper, OaProjectPlanDetailApplyEntity>
implements OaProjectPlanDetailApplyService {
    @Autowired
    private RkProjectPlanChangeService rkProjectPlanChangeService;
    @Autowired
    private RkContractProjectService rkContractProjectService;

    @Override
    public List<OaProjectPlanDetailApplyEntity> listByPlanId(String planId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OaProjectPlanDetailApplyEntity::getPlanId, (Object)planId)).eq(OaProjectPlanDetailApplyEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().orderByAsc(OaProjectPlanDetailApplyEntity::getSortCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OaProjectPlanDetailApplyEntity> listByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OaProjectPlanDetailApplyEntity::getProjectId, (Object)projectId)).eq(OaProjectPlanDetailApplyEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().orderByAsc(OaProjectPlanDetailApplyEntity::getSortCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void planChange(RkProjectPlanChangeCrForm projectPlanChangeCrForm) {
        OaProjectPlanDetailApplyEntity byId = (OaProjectPlanDetailApplyEntity)this.getById((Serializable)((Object)projectPlanChangeCrForm.getPlanDetailId()));
        if (CollectionUtil.isNotEmpty(projectPlanChangeCrForm.getChangeTime())) {
            projectPlanChangeCrForm.setChangeStartTime(projectPlanChangeCrForm.getChangeTime().get(0));
            projectPlanChangeCrForm.setChangeEndTime(projectPlanChangeCrForm.getChangeTime().get(1));
        }
        if (StrUtil.equals((CharSequence)projectPlanChangeCrForm.getChangeType(), (CharSequence)ProjectPlanChangeEnum.CHANGE_TYPE.getChange())) {
            if (CollectionUtil.isNotEmpty(projectPlanChangeCrForm.getChangeTime())) {
                byId.setChangeStartTime((Date)DateUtil.date((long)projectPlanChangeCrForm.getChangeTime().get(0)));
                byId.setChangeEndTime((Date)DateUtil.date((long)projectPlanChangeCrForm.getChangeTime().get(1)));
            }
        } else {
            byId.setExecutionResult(projectPlanChangeCrForm.getChangeType());
            if (StrUtil.equals((CharSequence)projectPlanChangeCrForm.getChangeType(), (CharSequence)ProjectPlanChangeEnum.COMPLETE_TYPE.getChange())) {
                byId.setActStartTime(ObjectUtil.isNull((Object)byId.getChangeStartTime()) ? byId.getPlanStartTime() : byId.getChangeStartTime());
                byId.setActEndTime((Date)DateUtil.date((long)projectPlanChangeCrForm.getCompleteTime()));
            }
        }
        byId.setExecutionDesc(projectPlanChangeCrForm.getDescription());
        this.updateById(byId);
        projectPlanChangeCrForm.setProjectId(byId.getProjectId());
        projectPlanChangeCrForm.setPlanId(byId.getPlanId());
        RkProjectPlanChangeEntity jsonToBean = (RkProjectPlanChangeEntity)JsonUtil.getJsonToBean((Object)projectPlanChangeCrForm, RkProjectPlanChangeEntity.class);
        jsonToBean.setId(RandomUtil.uuId());
        this.rkProjectPlanChangeService.save(jsonToBean);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractProjectEntity::getProjectPlanRatio, (Object)projectPlanChangeCrForm.getProjectPlanRatio())).eq(RkContractProjectEntity::getId, (Object)projectPlanChangeCrForm.getProjectId());
        this.rkContractProjectService.update((Wrapper)updateWrapper);
    }

    @Override
    public void updateStop(String projectId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(OaProjectPlanDetailApplyEntity::getExecutionResult, (Object)ProjectPlanExecutionResultEnum.stop.getResult())).eq(OaProjectPlanDetailApplyEntity::getProjectId, (Object)projectId)).isNull(OaProjectPlanDetailApplyEntity::getExecutionResult);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void updateStart(String projectId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(OaProjectPlanDetailApplyEntity::getExecutionResult, null)).eq(OaProjectPlanDetailApplyEntity::getProjectId, (Object)projectId)).eq(OaProjectPlanDetailApplyEntity::getExecutionResult, (Object)ProjectPlanExecutionResultEnum.stop.getResult());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public long countByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectPlanDetailApplyEntity::getProjectId, (Object)projectId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public OaProjectPlanDetailApplyEntity getInfo(String id) {
        return (OaProjectPlanDetailApplyEntity)this.getById((Serializable)((Object)id));
    }

    @Override
    public void delete(OaProjectPlanDetailApplyEntity entity) {
        this.removeById(entity);
    }

    @Override
    public List<OaProjectPlanDetailApplyEntity> GetRkProjectPlanDetailList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectPlanDetailApplyEntity::getPlanId, (Object)id);
        queryWrapper.lambda().orderByAsc(OaProjectPlanDetailApplyEntity::getSortCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void removeSubPlanId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectPlanDetailApplyEntity::getPlanId, (Object)id);
        this.list((Wrapper)queryWrapper).forEach(item -> {
            QueryWrapper queryWrapperSub = new QueryWrapper();
            queryWrapperSub.lambda().eq(OaProjectPlanDetailApplyEntity::getSubPlanId, (Object)item.getId());
            this.list((Wrapper)queryWrapperSub).forEach(subItem -> {
                if (ObjectUtil.isNotNull((Object)subItem)) {
                    this.delete((OaProjectPlanDetailApplyEntity)subItem);
                }
            });
            if (ObjectUtil.isNotNull((Object)item)) {
                this.delete((OaProjectPlanDetailApplyEntity)item);
            }
        });
    }

    @Override
    public List<OaProjectPlanDetailApplyEntity> getSubPlan(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaProjectPlanDetailApplyEntity::getSubPlanId, (Object)id);
        return this.list((Wrapper)queryWrapper);
    }
}

