/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.PurchaseGoodsListEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.mapper.PurchaseGoodsListMapper;
import com.bringspring.contract.model.purchasegoodslist.ProcureGoodsListPaginationExportModel;
import com.bringspring.contract.model.purchasegoodslist.PurchaseGoodsListPagination;
import com.bringspring.contract.service.PurchaseGoodsListService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseGoodsListServiceImpl
extends ServiceImpl<PurchaseGoodsListMapper, PurchaseGoodsListEntity>
implements PurchaseGoodsListService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractProcureService rkContractProcureService;

    @Override
    public List<PurchaseGoodsListEntity> getList(PurchaseGoodsListPagination purchaseGoodsListPagination) {
        Object purchaseGoodsListObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int purchaseGoodsListNum = 0;
        QueryWrapper purchaseGoodsListQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            purchaseGoodsListObj = this.authorizeService.getCondition(new AuthorizeConditionModel(purchaseGoodsListQueryWrapper, purchaseGoodsListPagination.getMenuId(), "purchase_goods_list"));
            if (ObjectUtil.isEmpty((Object)purchaseGoodsListObj)) {
                return new ArrayList<PurchaseGoodsListEntity>();
            }
            purchaseGoodsListQueryWrapper = (QueryWrapper)purchaseGoodsListObj;
            ++purchaseGoodsListNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            purchaseGoodsListObj = this.authorizeService.getCondition(new AuthorizeConditionModel(purchaseGoodsListQueryWrapper, purchaseGoodsListPagination.getMenuId(), "purchase_goods_list"));
            if (ObjectUtil.isEmpty((Object)purchaseGoodsListObj)) {
                return new ArrayList<PurchaseGoodsListEntity>();
            }
            purchaseGoodsListQueryWrapper = (QueryWrapper)purchaseGoodsListObj;
            ++purchaseGoodsListNum;
        }
        if (StrUtil.isNotEmpty((CharSequence)purchaseGoodsListPagination.getCompanyId())) {
            ++purchaseGoodsListNum;
            purchaseGoodsListQueryWrapper.lambda().eq(PurchaseGoodsListEntity::getCompanyId, (Object)purchaseGoodsListPagination.getCompanyId());
        }
        if (ObjectUtil.isNotEmpty((Object)purchaseGoodsListPagination.getMaterialCode())) {
            ++purchaseGoodsListNum;
            purchaseGoodsListQueryWrapper.lambda().like(PurchaseGoodsListEntity::getMaterialCode, (Object)purchaseGoodsListPagination.getMaterialCode());
        }
        if (ObjectUtil.isNotEmpty((Object)purchaseGoodsListPagination.getXsCode())) {
            ++purchaseGoodsListNum;
            purchaseGoodsListQueryWrapper.lambda().like(PurchaseGoodsListEntity::getXsCode, (Object)purchaseGoodsListPagination.getXsCode());
        }
        if (ObjectUtil.isNotEmpty((Object)purchaseGoodsListPagination.getHtCode())) {
            ++purchaseGoodsListNum;
            purchaseGoodsListQueryWrapper.lambda().like(PurchaseGoodsListEntity::getHtCode, (Object)purchaseGoodsListPagination.getHtCode());
        }
        if (AllIdList.size() > 0) {
            purchaseGoodsListQueryWrapper.lambda().in(PurchaseGoodsListEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)purchaseGoodsListPagination.getSidx())) {
            purchaseGoodsListQueryWrapper.lambda().orderByDesc(PurchaseGoodsListEntity::getId);
        } else {
            try {
                String sidx = purchaseGoodsListPagination.getSidx();
                PurchaseGoodsListEntity purchaseGoodsListEntity = new PurchaseGoodsListEntity();
                Field declaredField = purchaseGoodsListEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                purchaseGoodsListQueryWrapper = "asc".equals(purchaseGoodsListPagination.getSort().toLowerCase()) ? (QueryWrapper)purchaseGoodsListQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)purchaseGoodsListQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(purchaseGoodsListPagination.getCurrentPage(), purchaseGoodsListPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)purchaseGoodsListQueryWrapper);
            return purchaseGoodsListPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return purchaseGoodsListPagination.setData(list, list.size());
    }

    @Override
    public List<PurchaseGoodsListEntity> getTypeList(PurchaseGoodsListPagination purchaseGoodsListPagination, String dataType) {
        Object purchaseGoodsListObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int purchaseGoodsListNum = 0;
        QueryWrapper purchaseGoodsListQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            purchaseGoodsListObj = this.authorizeService.getCondition(new AuthorizeConditionModel(purchaseGoodsListQueryWrapper, purchaseGoodsListPagination.getMenuId(), "purchase_goods_list"));
            if (ObjectUtil.isEmpty((Object)purchaseGoodsListObj)) {
                return new ArrayList<PurchaseGoodsListEntity>();
            }
            purchaseGoodsListQueryWrapper = (QueryWrapper)purchaseGoodsListObj;
            ++purchaseGoodsListNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            purchaseGoodsListObj = this.authorizeService.getCondition(new AuthorizeConditionModel(purchaseGoodsListQueryWrapper, purchaseGoodsListPagination.getMenuId(), "purchase_goods_list"));
            if (ObjectUtil.isEmpty((Object)purchaseGoodsListObj)) {
                return new ArrayList<PurchaseGoodsListEntity>();
            }
            purchaseGoodsListQueryWrapper = (QueryWrapper)purchaseGoodsListObj;
            ++purchaseGoodsListNum;
        }
        if (ObjectUtil.isNotEmpty((Object)purchaseGoodsListPagination.getMaterialCode())) {
            ++purchaseGoodsListNum;
            purchaseGoodsListQueryWrapper.lambda().like(PurchaseGoodsListEntity::getMaterialCode, (Object)purchaseGoodsListPagination.getMaterialCode());
        }
        if (ObjectUtil.isNotEmpty((Object)purchaseGoodsListPagination.getXsCode())) {
            ++purchaseGoodsListNum;
            purchaseGoodsListQueryWrapper.lambda().like(PurchaseGoodsListEntity::getXsCode, (Object)purchaseGoodsListPagination.getXsCode());
        }
        if (ObjectUtil.isNotEmpty((Object)purchaseGoodsListPagination.getHtCode())) {
            ++purchaseGoodsListNum;
            purchaseGoodsListQueryWrapper.lambda().like(PurchaseGoodsListEntity::getHtCode, (Object)purchaseGoodsListPagination.getHtCode());
        }
        if (AllIdList.size() > 0) {
            purchaseGoodsListQueryWrapper.lambda().in(PurchaseGoodsListEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)purchaseGoodsListPagination.getSidx())) {
            purchaseGoodsListQueryWrapper.lambda().orderByDesc(PurchaseGoodsListEntity::getId);
        } else {
            try {
                String sidx = purchaseGoodsListPagination.getSidx();
                PurchaseGoodsListEntity purchaseGoodsListEntity = new PurchaseGoodsListEntity();
                Field declaredField = purchaseGoodsListEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                purchaseGoodsListQueryWrapper = "asc".equals(purchaseGoodsListPagination.getSort().toLowerCase()) ? (QueryWrapper)purchaseGoodsListQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)purchaseGoodsListQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(purchaseGoodsListPagination.getCurrentPage(), purchaseGoodsListPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)purchaseGoodsListQueryWrapper);
                return purchaseGoodsListPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return purchaseGoodsListPagination.setData(list, list.size());
        }
        return this.list((Wrapper)purchaseGoodsListQueryWrapper);
    }

    @Override
    public PurchaseGoodsListEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PurchaseGoodsListEntity::getId, (Object)id);
        return (PurchaseGoodsListEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(PurchaseGoodsListEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, PurchaseGoodsListEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(PurchaseGoodsListEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<PurchaseGoodsListEntity> getListByApplyCode(String applyCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PurchaseGoodsListEntity::getApplyCode, (Object)applyCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<PurchaseGoodsListEntity> findGoodsByIdAndKey(PurchaseGoodsListPagination purchaseGoodsListPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PurchaseGoodsListEntity::getHtId, (Object)purchaseGoodsListPagination.getHtCode());
        if (StringUtils.isNotEmpty((String)purchaseGoodsListPagination.getKeyword())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().like(PurchaseGoodsListEntity::getMaterialName, (Object)purchaseGoodsListPagination.getKeyword())).or()).like(PurchaseGoodsListEntity::getMaterialModel, (Object)purchaseGoodsListPagination.getKeyword());
        }
        queryWrapper.lambda().eq(PurchaseGoodsListEntity::getCloseFlowStatus, (Object)"0");
        Page page = new Page(purchaseGoodsListPagination.getCurrentPage(), purchaseGoodsListPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return purchaseGoodsListPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public List<PurchaseGoodsListEntity> findGoodsByProcureId(String procureId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PurchaseGoodsListEntity::getHtId, (Object)procureId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<PurchaseGoodsListEntity> findContractGoodsExport(ProcureGoodsListPaginationExportModel goodsModel) {
        QueryWrapper purchaseGoodsListQueryWrapper = new QueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)goodsModel.getMaterialCode())) {
            purchaseGoodsListQueryWrapper.lambda().like(PurchaseGoodsListEntity::getMaterialCode, (Object)goodsModel.getMaterialCode());
        }
        if (ObjectUtil.isNotEmpty((Object)goodsModel.getContractCode())) {
            purchaseGoodsListQueryWrapper.lambda().like(PurchaseGoodsListEntity::getXsCode, (Object)goodsModel.getContractCode());
        }
        if (ObjectUtil.isNotEmpty((Object)goodsModel.getProcureCode())) {
            purchaseGoodsListQueryWrapper.lambda().like(PurchaseGoodsListEntity::getHtCode, (Object)goodsModel.getProcureCode());
        }
        if (ObjectUtil.isNotEmpty((Object)goodsModel.getProcureName())) {
            List<RkContractProcureEntity> contractList = this.rkContractProcureService.getByName(goodsModel.getProcureName());
            if (CollectionUtil.isNotEmpty(contractList)) {
                List contractIds = contractList.stream().map(a -> a.getId()).collect(Collectors.toList());
                purchaseGoodsListQueryWrapper.lambda().in(PurchaseGoodsListEntity::getHtId, contractIds);
            } else {
                purchaseGoodsListQueryWrapper.lambda().eq(PurchaseGoodsListEntity::getId, (Object)0);
            }
        }
        ((LambdaQueryWrapper)purchaseGoodsListQueryWrapper.lambda().isNotNull(PurchaseGoodsListEntity::getHtId)).ne(PurchaseGoodsListEntity::getHtId, (Object)"0");
        return this.list((Wrapper)purchaseGoodsListQueryWrapper);
    }
}

