/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.mapper.RkAgentMapper;
import com.bringspring.contract.model.rkagent.RkAgentPagination;
import com.bringspring.contract.model.rkagent.RkCustomerAndAgentListQuery;
import com.bringspring.contract.model.rkagent.RkCustomerAndAgentVO;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkAgentServiceImpl
extends ServiceImpl<RkAgentMapper, RkAgentEntity>
implements RkAgentService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<RkAgentEntity> getList(RkAgentPagination rkAgentPagination) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper rkAgentQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)rkAgentPagination.getName())) {
            rkAgentQueryWrapper.lambda().like(RkAgentEntity::getName, (Object)rkAgentPagination.getName());
        }
        if (StringUtils.isNotEmpty((String)rkAgentPagination.getKeyword())) {
            rkAgentQueryWrapper.lambda().and(query -> {
                query.like(RkAgentEntity::getName, (Object)rkAgentPagination.getKeyword());
                ((LambdaQueryWrapper)query.or()).like(RkAgentEntity::getContact, (Object)rkAgentPagination.getKeyword());
                ((LambdaQueryWrapper)query.or()).like(RkAgentEntity::getContactNo, (Object)rkAgentPagination.getKeyword());
            });
        }
        if (ObjectUtil.isNotEmpty(rkAgentPagination.getRegion())) {
            List<List<String>> region = rkAgentPagination.getRegion();
            rkAgentQueryWrapper.lambda().and(query -> {
                for (List list : region) {
                    ArrayList<String> objects = new ArrayList<String>();
                    for (String s : list) {
                        objects.add("\"" + s + "\"");
                    }
                    String reg = ((Object)objects).toString().replaceAll(" ", "").replace("]", "");
                    ((LambdaQueryWrapper)query.or()).like(RkAgentEntity::getRegion, (Object)reg);
                }
            });
        }
        if (ObjectUtil.isNotEmpty(rkAgentPagination.getType())) {
            rkAgentQueryWrapper.lambda().in(RkAgentEntity::getType, rkAgentPagination.getType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkAgentPagination.getCompanyId())) {
            rkAgentQueryWrapper.apply("FIND_IN_SET(company_id,'" + rkAgentPagination.getCompanyId() + "' )", new Object[0]);
        }
        if (ObjectUtil.isNotEmpty((Object)rkAgentPagination.getAgentProduct())) {
            rkAgentQueryWrapper.apply("FIND_IN_SET(agent_product,'" + rkAgentPagination.getAgentProduct() + "' )", new Object[0]);
        }
        if (ObjectUtil.isNotEmpty((Object)rkAgentPagination.getSaleId())) {
            rkAgentQueryWrapper.apply("FIND_IN_SET(sale_id,'" + rkAgentPagination.getSaleId() + "' )", new Object[0]);
        }
        if (ObjectUtil.isNotEmpty((Object)rkAgentPagination.getChannelType())) {
            rkAgentQueryWrapper.lambda().eq(RkAgentEntity::getChannelType, (Object)rkAgentPagination.getChannelType());
        }
        HashMap roleSearchMap = rkAgentPagination.getRoleSearchMap();
        if (!ObjectUtil.isEmpty((Object)rkAgentPagination.getRoleSearchMap()) && rkAgentPagination.getRoleSearchMap().size() > 0) {
            List salerIdList;
            if (!((Boolean)roleSearchMap.get("isAll")).booleanValue() && CollectionUtil.isNotEmpty((Collection)(salerIdList = (List)roleSearchMap.get("idList")))) {
                rkAgentQueryWrapper.lambda().in(RkAgentEntity::getCreatorUserId, (Collection)salerIdList);
            }
        } else if (ObjectUtil.isNotEmpty((Object)rkAgentPagination.getCreatorUserId())) {
            rkAgentQueryWrapper.lambda().eq(RkAgentEntity::getCreatorUserId, (Object)rkAgentPagination.getCreatorUserId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkAgentPagination.getParentId())) {
            rkAgentQueryWrapper.lambda().eq(RkAgentEntity::getParentId, (Object)rkAgentPagination.getParentId());
        }
        if (CollectionUtil.isNotEmpty(rkAgentPagination.getCompanyIdList())) {
            rkAgentQueryWrapper.lambda().and(wrapper -> ((LambdaQueryWrapper)wrapper.and(w1 -> {
                w1.apply("find_in_set('" + rkAgentPagination.getCompanyIdList().get(0) + "',company_id)", new Object[0]);
                for (int i = 1; i < rkAgentPagination.getCompanyIdList().size(); ++i) {
                    ((LambdaQueryWrapper)w1.or()).apply("find_in_set('" + rkAgentPagination.getCompanyIdList().get(i) + "',company_id)", new Object[0]);
                }
            })).or(w2 -> w2.in(RkAgentEntity::getCompanyId, rkAgentPagination.getCompanyIdList())));
        }
        if (CollectionUtil.isNotEmpty(rkAgentPagination.getSalerCompanyIdList())) {
            rkAgentQueryWrapper.lambda().in(RkAgentEntity::getSalerCompanyId, rkAgentPagination.getSalerCompanyIdList());
        }
        if (StringUtils.isNotEmpty(rkAgentPagination.getCreatorTime())) {
            List<Date> CreatorTimeList = rkAgentPagination.getCreatorTime();
            Long fir = CreatorTimeList.get(0).getTime();
            Long sec = CreatorTimeList.get(1).getTime();
            ((LambdaQueryWrapper)rkAgentQueryWrapper.lambda().ge(RkAgentEntity::getCreatorTime, (Object)new Date(fir))).le(RkAgentEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            rkAgentQueryWrapper.lambda().in(RkAgentEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkAgentPagination.getSidx())) {
            rkAgentQueryWrapper.lambda().orderByDesc(RkAgentEntity::getId);
        } else {
            try {
                String sidx = rkAgentPagination.getSidx();
                RkAgentEntity rkAgentEntity = new RkAgentEntity();
                Field declaredField = rkAgentEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkAgentQueryWrapper = "asc".equals(rkAgentPagination.getSort().toLowerCase()) ? (QueryWrapper)rkAgentQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkAgentQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkAgentPagination.getCurrentPage(), rkAgentPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkAgentQueryWrapper);
            return rkAgentPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkAgentPagination.setData(list, list.size());
    }

    private Consumer<QueryWrapper<RkAgentEntity>> defaultWrapper() {
        final UserInfo userInfo = this.userProvider.get();
        return new Consumer<QueryWrapper<RkAgentEntity>>(){

            @Override
            public void accept(QueryWrapper<RkAgentEntity> saleQuotationTemplateQueryWrapper) {
                saleQuotationTemplateQueryWrapper.lambda().eq(RkAgentEntity::getCompanyId, (Object)userInfo.getOrganizeId());
            }
        };
    }

    @Override
    public List<RkAgentEntity> getTypeList(RkAgentPagination rkAgentPagination, String dataType) {
        Object rkAgentObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkAgentNum = 0;
        QueryWrapper rkAgentQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkAgentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkAgentQueryWrapper, rkAgentPagination.getMenuId(), "rkAgent"));
            if (ObjectUtil.isEmpty((Object)rkAgentObj)) {
                return new ArrayList<RkAgentEntity>();
            }
            rkAgentQueryWrapper = (QueryWrapper)rkAgentObj;
            ++rkAgentNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkAgentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkAgentQueryWrapper, rkAgentPagination.getMenuId(), "rkAgent"));
            if (ObjectUtil.isEmpty((Object)rkAgentObj)) {
                return new ArrayList<RkAgentEntity>();
            }
            rkAgentQueryWrapper = (QueryWrapper)rkAgentObj;
            ++rkAgentNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkAgentPagination.getName())) {
            ++rkAgentNum;
            rkAgentQueryWrapper.lambda().like(RkAgentEntity::getName, (Object)rkAgentPagination.getName());
        }
        if (ObjectUtil.isNotEmpty(rkAgentPagination.getSearchRegion())) {
            ++rkAgentNum;
            rkAgentQueryWrapper.lambda().in(RkAgentEntity::getRegion, rkAgentPagination.getSearchRegion());
        }
        if (CollectionUtil.isNotEmpty(rkAgentPagination.getCompanyIdList())) {
            rkAgentQueryWrapper.lambda().and(wrapper -> ((LambdaQueryWrapper)wrapper.and(w1 -> {
                w1.apply("find_in_set('" + rkAgentPagination.getCompanyIdList().get(0) + "',company_id)", new Object[0]);
                for (int i = 1; i < rkAgentPagination.getCompanyIdList().size(); ++i) {
                    ((LambdaQueryWrapper)w1.or()).apply("find_in_set('" + rkAgentPagination.getCompanyIdList().get(i) + "',company_id)", new Object[0]);
                }
            })).or(w2 -> w2.in(RkAgentEntity::getCompanyId, rkAgentPagination.getCompanyIdList())));
        }
        if (CollectionUtil.isNotEmpty(rkAgentPagination.getSalerCompanyIdList())) {
            rkAgentQueryWrapper.lambda().in(RkAgentEntity::getSalerCompanyId, rkAgentPagination.getSalerCompanyIdList());
        }
        if (StringUtils.isNotEmpty(rkAgentPagination.getCreatorTime())) {
            List<Date> CreatorTimeList = rkAgentPagination.getCreatorTime();
            Long fir = CreatorTimeList.get(0).getTime();
            Long sec = CreatorTimeList.get(1).getTime();
            ((LambdaQueryWrapper)rkAgentQueryWrapper.lambda().ge(RkAgentEntity::getCreatorTime, (Object)new Date(fir))).le(RkAgentEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            rkAgentQueryWrapper.lambda().in(RkAgentEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkAgentPagination.getSidx())) {
            rkAgentQueryWrapper.lambda().orderByDesc(RkAgentEntity::getId);
        } else {
            try {
                String sidx = rkAgentPagination.getSidx();
                RkAgentEntity rkAgentEntity = new RkAgentEntity();
                Field declaredField = rkAgentEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkAgentQueryWrapper = "asc".equals(rkAgentPagination.getSort().toLowerCase()) ? (QueryWrapper)rkAgentQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkAgentQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkAgentPagination.getCurrentPage(), rkAgentPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkAgentQueryWrapper);
                return rkAgentPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkAgentPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkAgentQueryWrapper);
    }

    @Override
    public List<RkAgentEntity> getListByCompanyId(String companyId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkAgentEntity::getCompanyId, (Object)companyId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public RkAgentEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkAgentEntity::getId, (Object)id);
        return (RkAgentEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkAgentEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkAgentEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkAgentEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<RkAgentEntity> getListByCreateDate(List<Date> list) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtil.isEmpty(list)) {
            return CollectionUtil.list((boolean)false);
        }
        queryWrapper.lambda().between(RkAgentEntity::getCreatorTime, (Object)list.get(0), (Object)list.get(1));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean checkExistNameAndCompanyId(String name, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkAgentEntity::getName, (Object)name)).eq(RkAgentEntity::getCompanyId, (Object)companyId);
        return !CollectionUtil.isEmpty((Collection)this.list((Wrapper)queryWrapper));
    }

    @Override
    public boolean checkExistNameAndCompanyId(String name, String companyId, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkAgentEntity::getName, (Object)name)).eq(RkAgentEntity::getCompanyId, (Object)companyId);
        if (StrUtil.isNotEmpty((CharSequence)id)) {
            queryWrapper.lambda().ne(RkAgentEntity::getId, (Object)id);
        }
        return !CollectionUtil.isEmpty((Collection)this.list((Wrapper)queryWrapper));
    }

    @Override
    public boolean checkExistName(String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkAgentEntity::getName, (Object)name);
        return !CollectionUtil.isEmpty((Collection)this.list((Wrapper)queryWrapper));
    }

    @Override
    public boolean checkExistName(String name, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkAgentEntity::getName, (Object)name);
        queryWrapper.lambda().ne(RkAgentEntity::getId, (Object)id);
        return !CollectionUtil.isEmpty((Collection)this.list((Wrapper)queryWrapper));
    }

    @Override
    public boolean checkExistNameAndCompanyIdAndAgentId(String name, String companyId, String agentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkAgentEntity::getName, (Object)name)).eq(RkAgentEntity::getCompanyId, (Object)companyId)).ne(RkAgentEntity::getId, (Object)agentId);
        return !CollectionUtil.isEmpty((Collection)this.list((Wrapper)queryWrapper));
    }

    @Override
    public List getCustomerAndAgent(RkCustomerAndAgentListQuery listQuery) {
        PageHelper.startPage((int)((int)listQuery.getCurrentPage()), (int)((int)listQuery.getPageSize()));
        List<RkCustomerAndAgentVO> list = ((RkAgentMapper)this.baseMapper).getCustomerAndAgent(listQuery);
        PageInfo pageInfo = new PageInfo(list);
        return listQuery.setData(pageInfo.getList(), pageInfo.getTotal());
    }

    @Override
    public List<RkAgentEntity> findByAgentNameAndCompanyId(String agentName, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkAgentEntity::getName, (Object)agentName)).eq(RkAgentEntity::getCompanyId, (Object)companyId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public RkAgentEntity getInfoHandleRegionDate(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkAgentEntity::getId, (Object)id);
        RkAgentEntity vo = (RkAgentEntity)this.getOne((Wrapper)queryWrapper);
        if (StringUtils.isNotEmpty((String)vo.getAgentProduct())) {
            String agentProduct = vo.getAgentProduct();
            List<String> list = Arrays.asList(agentProduct.split(","));
            ArrayList<String> newList = new ArrayList<String>();
            for (String s : list) {
                String str = "\"" + s + "\"";
                newList.add(str);
            }
            vo.setAgentProduct(((Object)newList).toString().replaceAll(" ", ""));
        }
        return vo;
    }

    @Override
    public long agentCountByParent(String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkAgentEntity::getParentId, (Object)parentId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public List<RkAgentEntity> getManagerListByParentId(String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkAgentEntity::getParentId, (Object)parentId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkAgentEntity> listSimpleIdAndName() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{RkAgentEntity::getId, RkAgentEntity::getName});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public RkAgentEntity getInfoByFullNameAndCompanyId(String fullName, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkAgentEntity::getName, (Object)fullName)).eq(RkAgentEntity::getCompanyId, (Object)companyId);
        return (RkAgentEntity)this.getOne((Wrapper)queryWrapper);
    }
}

