/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.mapper.RkAttachmentMapper;
import com.bringspring.contract.model.rkattachment.RkAttachmentFileListVO;
import com.bringspring.contract.model.rkattachment.RkAttachmentPagination;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkAttachmentServiceImpl
extends ServiceImpl<RkAttachmentMapper, RkAttachmentEntity>
implements RkAttachmentService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    public static String temporaryZip = "temporaryZip" + File.separator;

    @Override
    public List<RkAttachmentEntity> getList(RkAttachmentPagination rkAttachmentPagination) {
        Object rkAttachmentObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkAttachmentNum = 0;
        QueryWrapper rkAttachmentQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkAttachmentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkAttachmentQueryWrapper, rkAttachmentPagination.getMenuId(), "rkAttachment"));
            if (ObjectUtil.isEmpty((Object)rkAttachmentObj)) {
                return new ArrayList<RkAttachmentEntity>();
            }
            rkAttachmentQueryWrapper = (QueryWrapper)rkAttachmentObj;
            ++rkAttachmentNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkAttachmentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkAttachmentQueryWrapper, rkAttachmentPagination.getMenuId(), "rkAttachment"));
            if (ObjectUtil.isEmpty((Object)rkAttachmentObj)) {
                return new ArrayList<RkAttachmentEntity>();
            }
            rkAttachmentQueryWrapper = (QueryWrapper)rkAttachmentObj;
            ++rkAttachmentNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkAttachmentPagination.getContractId())) {
            ++rkAttachmentNum;
            rkAttachmentQueryWrapper.lambda().like(RkAttachmentEntity::getContractId, (Object)rkAttachmentPagination.getContractId());
        }
        if (AllIdList.size() > 0) {
            rkAttachmentQueryWrapper.lambda().in(RkAttachmentEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkAttachmentPagination.getSidx())) {
            rkAttachmentQueryWrapper.lambda().orderByDesc(RkAttachmentEntity::getId);
        } else {
            try {
                String sidx = rkAttachmentPagination.getSidx();
                RkAttachmentEntity rkAttachmentEntity = new RkAttachmentEntity();
                Field declaredField = rkAttachmentEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkAttachmentQueryWrapper = "asc".equals(rkAttachmentPagination.getSort().toLowerCase()) ? (QueryWrapper)rkAttachmentQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkAttachmentQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkAttachmentPagination.getCurrentPage(), rkAttachmentPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkAttachmentQueryWrapper);
            return rkAttachmentPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkAttachmentPagination.setData(list, list.size());
    }

    @Override
    public List<RkAttachmentEntity> getTypeList(RkAttachmentPagination rkAttachmentPagination, String dataType) {
        Object rkAttachmentObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkAttachmentNum = 0;
        QueryWrapper rkAttachmentQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkAttachmentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkAttachmentQueryWrapper, rkAttachmentPagination.getMenuId(), "rkAttachment"));
            if (ObjectUtil.isEmpty((Object)rkAttachmentObj)) {
                return new ArrayList<RkAttachmentEntity>();
            }
            rkAttachmentQueryWrapper = (QueryWrapper)rkAttachmentObj;
            ++rkAttachmentNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkAttachmentObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkAttachmentQueryWrapper, rkAttachmentPagination.getMenuId(), "rkAttachment"));
            if (ObjectUtil.isEmpty((Object)rkAttachmentObj)) {
                return new ArrayList<RkAttachmentEntity>();
            }
            rkAttachmentQueryWrapper = (QueryWrapper)rkAttachmentObj;
            ++rkAttachmentNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkAttachmentPagination.getContractId())) {
            ++rkAttachmentNum;
            rkAttachmentQueryWrapper.lambda().like(RkAttachmentEntity::getContractId, (Object)rkAttachmentPagination.getContractId());
        }
        if (AllIdList.size() > 0) {
            rkAttachmentQueryWrapper.lambda().in(RkAttachmentEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkAttachmentPagination.getSidx())) {
            rkAttachmentQueryWrapper.lambda().orderByDesc(RkAttachmentEntity::getId);
        } else {
            try {
                String sidx = rkAttachmentPagination.getSidx();
                RkAttachmentEntity rkAttachmentEntity = new RkAttachmentEntity();
                Field declaredField = rkAttachmentEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkAttachmentQueryWrapper = "asc".equals(rkAttachmentPagination.getSort().toLowerCase()) ? (QueryWrapper)rkAttachmentQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkAttachmentQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkAttachmentPagination.getCurrentPage(), rkAttachmentPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkAttachmentQueryWrapper);
                return rkAttachmentPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkAttachmentPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkAttachmentQueryWrapper);
    }

    @Override
    public RkAttachmentEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkAttachmentEntity::getId, (Object)id);
        return (RkAttachmentEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkAttachmentEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkAttachmentEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkAttachmentEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<RkAttachmentEntity> getListByContractId(String contractId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkAttachmentEntity::getContractId, (Object)contractId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public long countByContractId(String contractId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkAttachmentEntity::getContractId, (Object)contractId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public long countByProjectId(String projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkAttachmentEntity::getProjectId, (Object)projectId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public List<RkAttachmentEntity> getListByContractIdAndFileType(String contractId, String fileType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RkAttachmentEntity::getContractId, (Object)contractId)).eq(RkAttachmentEntity::getFileType, (Object)fileType);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkAttachmentEntity> getListByProjectId(String projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkAttachmentEntity::getProjectId, (Object)projectId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkAttachmentEntity> getListByObjId(String objId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkAttachmentEntity::getObjId, (Object)objId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkAttachmentEntity> getListByObjIdIn(List<String> objIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(RkAttachmentEntity::getObjId, objIdList);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean deleteByObjId(String objId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkAttachmentEntity::getObjId, (Object)objId);
        return this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<RkAttachmentEntity> getListByProjectTypeId(String objId, String type) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkAttachmentEntity::getObjId, (Object)objId);
        queryWrapper.eq(RkAttachmentEntity::getFileType, (Object)type);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean deleteByProjectTypeId(String objId, String fileType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkAttachmentEntity::getObjId, (Object)objId);
        queryWrapper.eq(RkAttachmentEntity::getFileType, (Object)fileType);
        return this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<RkAttachmentEntity> getListByProjectIdType(String projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkAttachmentEntity::getProjectId, (Object)projectId);
        queryWrapper.groupBy(RkAttachmentEntity::getFileType);
        queryWrapper.orderByDesc(RkAttachmentEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkAttachmentEntity> getListByProjectIdTypeInit(String fileType, String projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkAttachmentEntity::getFileType, (Object)fileType);
        queryWrapper.eq(RkAttachmentEntity::getProjectId, (Object)projectId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public DownloadVO getAllByProjectId(RkAttachmentFileListVO vo) {
        String zipPath;
        ArrayList<RkAttachmentEntity> list = new ArrayList<RkAttachmentEntity>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkAttachmentEntity::getProjectId, (Object)vo.getProjectId());
        if (StringUtils.isNotEmpty((String)vo.getFileType())) {
            queryWrapper.lambda().eq(RkAttachmentEntity::getFileType, (Object)vo.getFileType());
        }
        List entitie = this.list((Wrapper)queryWrapper);
        UserInfo userInfo = this.userProvider.get();
        this.getAllChildrenDoc(list, vo.getProjectId());
        String fromPath = this.configValueUtil.getWebAnnexFilePath();
        String toPath = this.configValueUtil.getDocumentFilePath() + temporaryZip;
        String fileList = "";
        String uuid = DateUtil.daFormat((Date)new Date()) + "_" + RandomUtil.uuId();
        for (RkAttachmentEntity documentEntity : entitie) {
            boolean b;
            String result;
            int lastIndex;
            String fileTypeName = this.baseDataUtil.getDictName(documentEntity.getFileType(), "projectAccessoryType") + "_" + uuid + "\u6587\u4ef6";
            vo.setFileTypeName(fileTypeName);
            if (StringUtils.isNull((Object)documentEntity.getSecondFilePath()) && (lastIndex = (result = documentEntity.getUrl().replaceAll("^\\D+", "")).lastIndexOf(Character.toString('/'))) != -1) {
                documentEntity.setSecondFilePath(result.substring(0, lastIndex) + "/");
            }
            if (StringUtils.isNull((Object)vo.getCreatorTime())) {
                b = false;
                List dictionName = this.dictionaryDataService.getDicList("581831540237958021");
                if (CollectionUtil.isNotEmpty((Collection)dictionName) && StringUtils.isNotEmpty((String)documentEntity.getFileType())) {
                    for (DictionaryDataEntity dictionaryDataEntity : dictionName) {
                        if (!dictionaryDataEntity.getEnCode().equals(documentEntity.getFileType())) continue;
                        b = FileUtil.copyFile((String)(fromPath + documentEntity.getSecondFilePath() + documentEntity.getFileId()), (String)(toPath + vo.getFileTypeName() + File.separator), (String)documentEntity.getName());
                        fileList = fileList + toPath + vo.getFileTypeName() + File.separator + ",";
                    }
                    if (vo.getFileTypeName().equals("_" + uuid + "\u6587\u4ef6")) {
                        b = FileUtil.copyFile((String)(fromPath + documentEntity.getSecondFilePath() + documentEntity.getFileId()), (String)(toPath + "_" + uuid + "\u9879\u76ee" + File.separator), (String)documentEntity.getName());
                        fileList = fileList + toPath + "_" + uuid + "\u9879\u76ee" + File.separator + ",";
                    }
                }
                if (b) continue;
                return new DownloadVO();
            }
            if (!(vo.getFileTypeName().equals("\u6587\u4ef6") ? !(b = FileUtil.copyFile((String)(fromPath + documentEntity.getSecondFilePath() + documentEntity.getFileId()), (String)(toPath + uuid + "\u9879\u76ee" + File.separator), (String)documentEntity.getName())) : !(b = FileUtil.copyFile((String)(fromPath + documentEntity.getSecondFilePath() + documentEntity.getFileId()), (String)(toPath + vo.getFileTypeName() + File.separator), (String)documentEntity.getName())))) continue;
            return new DownloadVO();
        }
        String zipName = "";
        if (StringUtils.isNull((Object)vo.getCreatorTime())) {
            zipName = vo.getProjectName() + DateUtil.daFormat((Date)new Date()) + "_" + RandomUtil.uuId();
            zipPath = toPath + zipName + ".zip";
            if (new File(zipPath).exists()) {
                new File(zipPath).delete();
            }
            String lastChar = fileList.substring(0, fileList.length() - 1);
            List<String> fileNameList = Arrays.asList(lastChar.split(","));
            List collect = fileNameList.stream().distinct().collect(Collectors.toList());
            FileUtil.toZipAll((String)zipPath, (boolean)true, collect);
        } else {
            zipName = vo.getFileTypeName();
            zipPath = toPath + zipName + ".zip";
            if (new File(zipPath).exists()) {
                new File(zipPath).delete();
            }
            String outPath = toPath + vo.getFileTypeName() + File.separator;
            FileUtil.toZip((String)zipPath, (boolean)true, (String[])new String[]{outPath + File.separator});
        }
        String fileName = userInfo.getId() + "#" + zipName + ".zip#documentZip#";
        DownloadVO downloadVO = DownloadVO.builder().name(zipName + ".zip").url(UploaderUtil.uploaderFile((String)fileName)).build();
        return downloadVO;
    }

    public void getAllChildrenDoc(List<RkAttachmentEntity> childrenList, String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkAttachmentEntity::getProjectId, (Object)parentId);
        List list = this.list((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            for (RkAttachmentEntity entity : list) {
                childrenList.add(entity);
            }
        }
    }

    @Override
    public boolean deleteByContractId(String contractId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkAttachmentEntity::getContractId, (Object)contractId);
        return this.remove((Wrapper)queryWrapper);
    }

    @Override
    public boolean deleteByContractId(String contractId, String fileType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RkAttachmentEntity::getContractId, (Object)contractId)).eq(RkAttachmentEntity::getFileType, (Object)fileType);
        return this.remove((Wrapper)queryWrapper);
    }
}

