/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractAssetsLedgerEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.mapper.RkcontractAssetsLedgerMapper;
import com.bringspring.contract.model.contract_assets_ledger.RkContractAssetsLedgerExportVO;
import com.bringspring.contract.model.contract_assets_ledger.RkContractAssetsLedgerInfoVO;
import com.bringspring.contract.model.contract_assets_ledger.RkContractAssetsLedgerPagination;
import com.bringspring.contract.model.contract_assets_ledger.RkContractAssetsLedgerPaginationExportModel;
import com.bringspring.contract.model.rkcontract.RkContractListVO;
import com.bringspring.contract.model.rkcontract.RkContractPagination;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkcontrActassetsLedgerService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.ContractEnableMarkEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractAssetsLedgerServiceImpl
extends ServiceImpl<RkcontractAssetsLedgerMapper, RkContractAssetsLedgerEntity>
implements RkcontrActassetsLedgerService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkcontractAssetsLedgerMapper rkcontractAssetsLedgerMapper;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private UserService userService;

    @Override
    public List<RkContractAssetsLedgerEntity> getList(RkContractAssetsLedgerPagination rkcontractassetsledgerPagination) {
        Object rkcontractassetsledgerObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkcontractassetsledgerNum = 0;
        QueryWrapper rkcontractassetsledgerQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkcontractassetsledgerObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkcontractassetsledgerQueryWrapper, rkcontractassetsledgerPagination.getMenuId(), "rk_contract_assets_ledger"));
            if (ObjectUtil.isEmpty((Object)rkcontractassetsledgerObj)) {
                return new ArrayList<RkContractAssetsLedgerEntity>();
            }
            rkcontractassetsledgerQueryWrapper = (QueryWrapper)rkcontractassetsledgerObj;
            ++rkcontractassetsledgerNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkcontractassetsledgerObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkcontractassetsledgerQueryWrapper, rkcontractassetsledgerPagination.getMenuId(), "rk_contract_assets_ledger"));
            if (ObjectUtil.isEmpty((Object)rkcontractassetsledgerObj)) {
                return new ArrayList<RkContractAssetsLedgerEntity>();
            }
            rkcontractassetsledgerQueryWrapper = (QueryWrapper)rkcontractassetsledgerObj;
            ++rkcontractassetsledgerNum;
        }
        rkcontractassetsledgerQueryWrapper.lambda().eq(RkContractAssetsLedgerEntity::getEnabledMark, (Object)0);
        if (ObjectUtil.isNotEmpty(rkcontractassetsledgerPagination.getExecDate())) {
            ++rkcontractassetsledgerNum;
            rkcontractassetsledgerQueryWrapper.lambda().between(RkContractAssetsLedgerEntity::getExecDate, (Object)rkcontractassetsledgerPagination.getExecDate().get(0), (Object)rkcontractassetsledgerPagination.getExecDate().get(1));
        }
        if (StringUtil.isNotEmpty((String)rkcontractassetsledgerPagination.getCreateUserId())) {
            ++rkcontractassetsledgerNum;
            rkcontractassetsledgerQueryWrapper.lambda().eq(RkContractAssetsLedgerEntity::getCreatorUserId, (Object)rkcontractassetsledgerPagination.getCreateUserId());
        }
        if (StringUtil.isNotEmpty((String)rkcontractassetsledgerPagination.getCompanyId())) {
            ++rkcontractassetsledgerNum;
            rkcontractassetsledgerQueryWrapper.lambda().eq(RkContractAssetsLedgerEntity::getCompanyId, (Object)rkcontractassetsledgerPagination.getCompanyId());
        }
        if (StringUtil.isNotEmpty((String)rkcontractassetsledgerPagination.getYongYou())) {
            ++rkcontractassetsledgerNum;
            rkcontractassetsledgerQueryWrapper.lambda().like(RkContractAssetsLedgerEntity::getYongYou, (Object)rkcontractassetsledgerPagination.getYongYou());
        }
        if (StringUtil.isNotEmpty((String)rkcontractassetsledgerPagination.getContractCode())) {
            ++rkcontractassetsledgerNum;
            rkcontractassetsledgerQueryWrapper.lambda().like(RkContractAssetsLedgerEntity::getContractCode, (Object)rkcontractassetsledgerPagination.getContractCode());
        }
        if (StringUtil.isNotEmpty((String)rkcontractassetsledgerPagination.getContractName())) {
            ++rkcontractassetsledgerNum;
            rkcontractassetsledgerQueryWrapper.lambda().like(RkContractAssetsLedgerEntity::getContractName, (Object)rkcontractassetsledgerPagination.getContractName());
        }
        if (StringUtil.isNotEmpty((String)rkcontractassetsledgerPagination.getAgentName())) {
            ++rkcontractassetsledgerNum;
            rkcontractassetsledgerQueryWrapper.lambda().like(RkContractAssetsLedgerEntity::getAgentName, (Object)rkcontractassetsledgerPagination.getAgentName());
        }
        if (StringUtil.isNotEmpty((String)rkcontractassetsledgerPagination.getCustomerName())) {
            ++rkcontractassetsledgerNum;
            rkcontractassetsledgerQueryWrapper.lambda().like(RkContractAssetsLedgerEntity::getCustomerName, (Object)rkcontractassetsledgerPagination.getCustomerName());
        }
        if (AllIdList.size() > 0) {
            rkcontractassetsledgerQueryWrapper.lambda().in(RkContractAssetsLedgerEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkcontractassetsledgerPagination.getSidx())) {
            rkcontractassetsledgerQueryWrapper.lambda().orderByDesc(RkContractAssetsLedgerEntity::getExecDate);
        } else {
            try {
                String sidx = rkcontractassetsledgerPagination.getSidx();
                RkContractAssetsLedgerEntity rkcontractassetsledgerEntity = new RkContractAssetsLedgerEntity();
                Field declaredField = rkcontractassetsledgerEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkcontractassetsledgerQueryWrapper = "asc".equals(rkcontractassetsledgerPagination.getSort().toLowerCase()) ? (QueryWrapper)rkcontractassetsledgerQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkcontractassetsledgerQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkcontractassetsledgerPagination.getCurrentPage(), rkcontractassetsledgerPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkcontractassetsledgerQueryWrapper);
            return rkcontractassetsledgerPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkcontractassetsledgerPagination.setData(list, list.size());
    }

    @Override
    public List<RkContractAssetsLedgerEntity> getTypeList(RkContractAssetsLedgerPagination rkcontractassetsledgerPagination, String dataType) {
        Object rkcontractassetsledgerObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkcontractassetsledgerNum = 0;
        QueryWrapper rkcontractassetsledgerQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkcontractassetsledgerObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkcontractassetsledgerQueryWrapper, rkcontractassetsledgerPagination.getMenuId(), "rk_contract_assets_ledger"));
            if (ObjectUtil.isEmpty((Object)rkcontractassetsledgerObj)) {
                return new ArrayList<RkContractAssetsLedgerEntity>();
            }
            rkcontractassetsledgerQueryWrapper = (QueryWrapper)rkcontractassetsledgerObj;
            ++rkcontractassetsledgerNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkcontractassetsledgerObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkcontractassetsledgerQueryWrapper, rkcontractassetsledgerPagination.getMenuId(), "rk_contract_assets_ledger"));
            if (ObjectUtil.isEmpty((Object)rkcontractassetsledgerObj)) {
                return new ArrayList<RkContractAssetsLedgerEntity>();
            }
            rkcontractassetsledgerQueryWrapper = (QueryWrapper)rkcontractassetsledgerObj;
            ++rkcontractassetsledgerNum;
        }
        if (ObjectUtil.isNotEmpty(rkcontractassetsledgerPagination.getExecDate())) {
            ++rkcontractassetsledgerNum;
            rkcontractassetsledgerQueryWrapper.lambda().eq(RkContractAssetsLedgerEntity::getExecDate, rkcontractassetsledgerPagination.getExecDate());
        }
        if (AllIdList.size() > 0) {
            rkcontractassetsledgerQueryWrapper.lambda().in(RkContractAssetsLedgerEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkcontractassetsledgerPagination.getSidx())) {
            rkcontractassetsledgerQueryWrapper.lambda().orderByDesc(RkContractAssetsLedgerEntity::getExecDate);
        } else {
            try {
                String sidx = rkcontractassetsledgerPagination.getSidx();
                RkContractAssetsLedgerEntity rkcontractassetsledgerEntity = new RkContractAssetsLedgerEntity();
                Field declaredField = rkcontractassetsledgerEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkcontractassetsledgerQueryWrapper = "asc".equals(rkcontractassetsledgerPagination.getSort().toLowerCase()) ? (QueryWrapper)rkcontractassetsledgerQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkcontractassetsledgerQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkcontractassetsledgerPagination.getCurrentPage(), rkcontractassetsledgerPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkcontractassetsledgerQueryWrapper);
                return rkcontractassetsledgerPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkcontractassetsledgerPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkcontractassetsledgerQueryWrapper);
    }

    @Override
    public RkContractAssetsLedgerEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractAssetsLedgerEntity::getId, (Object)id);
        return (RkContractAssetsLedgerEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkContractAssetsLedgerEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkContractAssetsLedgerEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public List<RkContractListVO> getRkContractAssetsLedgerList(RkContractPagination rkContractPagination) {
        UserInfo userInfo = this.userProvider.get();
        List<ContractEnableMarkEnum> allToList = ContractEnableMarkEnum.getAllToList();
        allToList.remove((Object)ContractEnableMarkEnum.ENABLE_DRAFT);
        List<String> collect = allToList.stream().map(ContractEnableMarkEnum::getEnableMark).collect(Collectors.toList());
        rkContractPagination.setEnableMark(collect);
        List<RkContractEntity> list = this.rkContractService.getList(rkContractPagination);
        List listContractVO = JsonUtil.getJsonToList(list, RkContractListVO.class);
        LambdaQueryWrapper queryWrapperAss = new LambdaQueryWrapper();
        queryWrapperAss.orderByDesc(RkContractAssetsLedgerEntity::getExecDate, (Object[])new SFunction[]{RkContractAssetsLedgerEntity::getContractId});
        queryWrapperAss.eq(RkContractAssetsLedgerEntity::getEnabledMark, (Object)0);
        List listAccets = this.list((Wrapper)queryWrapperAss);
        ArrayList<RkContractAssetsLedgerEntity> addAssetsList = null;
        RkAgentEntity agent = null;
        for (RkContractListVO vo : listContractVO) {
            addAssetsList = new ArrayList<RkContractAssetsLedgerEntity>();
            for (RkContractAssetsLedgerEntity assetsLedgerVO : listAccets) {
                if (ObjectUtil.isNull((Object)vo.getId()) || ObjectUtil.isNull((Object)assetsLedgerVO.getContractId()) || !vo.getId().equals(assetsLedgerVO.getContractId())) continue;
                addAssetsList.add(assetsLedgerVO);
            }
            if (ObjectUtil.isNotEmpty(addAssetsList)) {
                vo.setAssetsLedgerList(addAssetsList);
            }
            vo.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
            vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            vo.setIncomeTypeName(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
            vo.setIndustryTypeName(this.baseDataUtil.getDictName(vo.getIndustryType(), "industryType"));
            vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
            if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
                vo.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId()));
                vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            }
            if ("1".equals(vo.getIsAgent())) {
                if (!StringUtils.isNotEmpty((String)vo.getAgentId()) || null == (agent = this.rkAgentService.getInfo(vo.getAgentId()))) continue;
                vo.setAgentName(agent.getName());
                continue;
            }
            vo.setAgentName(vo.getCustomerNames());
        }
        return listContractVO;
    }

    RkContractListVO setCustomerAngerName(RkContractListVO contractVO, List<CrmCustomerEntity> custList, List<RkAgentEntity> agentList) {
        for (CrmCustomerEntity cust : custList) {
            if (ObjectUtil.isNull((Object)contractVO.getCustomerId()) || !contractVO.getCustomerId().equals(cust.getId())) continue;
            contractVO.setCustomerName(cust.getName());
            break;
        }
        if (!ObjectUtil.isNull((Object)contractVO.getAgentId())) {
            if (contractVO.getCustomerId().equals(contractVO.getAgentId())) {
                contractVO.setAgentId(contractVO.getCustomerName());
            } else {
                for (RkAgentEntity agent : agentList) {
                    if (ObjectUtil.isNull((Object)contractVO.getAgentId()) || !contractVO.getAgentId().equals(agent.getId())) continue;
                    contractVO.setAgentId(agent.getName());
                    break;
                }
            }
        } else {
            contractVO.setAgentId(contractVO.getCustomerName());
        }
        return contractVO;
    }

    @Override
    public RkContractListVO getDetailInfo(String contractId) {
        RkContractEntity aa = this.rkContractService.getInfo(contractId);
        RkContractListVO vo = (RkContractListVO)JsonUtil.getJsonToBean((Object)aa, RkContractListVO.class);
        vo.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo.setIncomeTypeName(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
        vo.setIndustryTypeName(this.baseDataUtil.getDictName(vo.getIndustryType(), "industryType"));
        vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
        if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
            vo.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId()));
            vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
        }
        if ("1".equals(vo.getIsAgent())) {
            RkAgentEntity agent;
            if (StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.rkAgentService.getInfo(vo.getAgentId()))) {
                vo.setAgentName(agent.getName());
            }
        } else {
            vo.setAgentName(vo.getCustomerNames());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkContractProjectEntity::getContractId, (Object)contractId);
        List projectEntityList = this.rkContractProjectService.list((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)projectEntityList) && ObjectUtil.isNotEmpty(projectEntityList.get(0))) {
            vo.setAcceptanceDate(((RkContractProjectEntity)projectEntityList.get(0)).getAcceptanceTime());
            int isUpload = ((RkContractProjectEntity)projectEntityList.get(0)).getIsUploadAcceptFile();
            if (isUpload == 1) {
                vo.setIsUploadAcceptFile("\u662f");
            } else if (isUpload == 0) {
                vo.setIsUploadAcceptFile("\u5426");
            }
        }
        LambdaQueryWrapper queryWrapperAss = new LambdaQueryWrapper();
        queryWrapperAss.eq(RkContractAssetsLedgerEntity::getContractId, (Object)contractId);
        queryWrapperAss.eq(RkContractAssetsLedgerEntity::getEnabledMark, (Object)0);
        queryWrapperAss.orderByDesc(RkContractAssetsLedgerEntity::getExecDate);
        List listAccets = this.list((Wrapper)queryWrapperAss);
        RkContractAssetsLedgerPaginationExportModel assetsModel = new RkContractAssetsLedgerPaginationExportModel();
        assetsModel.setContractId(vo.getId());
        List<RkContractAssetsLedgerExportVO> exportReturnAmount = this.rkcontractAssetsLedgerMapper.getContractReturnAmountList(assetsModel);
        List<RkContractAssetsLedgerExportVO> exportInvoiceAmount = this.rkcontractAssetsLedgerMapper.getContractInvoiceAmountList(assetsModel);
        for (RkContractAssetsLedgerEntity accets : listAccets) {
            if (!ObjectUtil.isNotEmpty((Object)accets.getExecDate())) continue;
            String accDate = DateUtil.daFormat((Date)accets.getExecDate()).substring(0, 7);
            for (RkContractAssetsLedgerExportVO returnAmount : exportReturnAmount) {
                if (!ObjectUtil.isNotEmpty((Object)accets.getExecDate()) || !accDate.equals(returnAmount.get\u5e74\u6708())) continue;
                accets.setAmountCashed(returnAmount.get\u56de\u6b3e\u91d1\u989d());
            }
            for (RkContractAssetsLedgerExportVO invoiceAmount : exportInvoiceAmount) {
                if (!ObjectUtil.isNotEmpty((Object)accets.getExecDate()) || !accDate.equals(invoiceAmount.get\u5e74\u6708())) continue;
                accets.setInvoiceAmount(invoiceAmount.get\u5f00\u7968\u91d1\u989d());
            }
        }
        vo.setAssetsLedgerList(listAccets);
        return vo;
    }

    @Override
    public DownloadVO exportContractAssets(RkContractAssetsLedgerPaginationExportModel assetsModel) {
        assetsModel.setCompanyId(this.userProvider.get().getOrganizeId());
        List<RkContractAssetsLedgerExportVO> exportList = this.rkcontractAssetsLedgerMapper.exportContractAssetsList(assetsModel);
        if (ObjectUtil.isNotEmpty(exportList)) {
            for (int i = 0; i < exportList.size(); ++i) {
                exportList.get(i).setNum(i + 1);
                String hardware = exportList.get(i).getHardwareRatio();
                String soft = exportList.get(i).getSoftwareRatio();
                String service = exportList.get(i).getServiceRatio();
                exportList.get(i).setRatio(this.getRatio(hardware, soft, service));
                exportList.get(i).set\u884c\u4e1a\u7c7b\u578b(this.baseDataUtil.getDictName(exportList.get(i).getIndustry_type(), "industryType"));
                exportList.get(i).set\u5408\u540c\u7c7b\u578b(this.baseDataUtil.getDictName(exportList.get(i).getContract_type(), Constants.CONTRACT_TYPE_DICT_ID));
            }
        }
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList(exportList, RkContractAssetsLedgerExportVO.class));
        String tableName = "\u5408\u540c\u8d44\u4ea7\u8868_\u7b7e\u7ea6" + assetsModel.getContractStartDate().substring(0, 10) + "\u622a\u81f3" + assetsModel.getContractEndDate().substring(0, 10) + "\u91d1\u989d" + assetsModel.getAssetsStartDate().substring(0, 10) + "\u622a\u81f3" + assetsModel.getAssetsEndDate().substring(0, 10) + "_";
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        entitys.add(new ExcelExportEntity("\u5e8f\u53f7", (Object)"num"));
        entitys.add(new ExcelExportEntity("\u7b7e\u7ea6\u65e5\u671f", (Object)"\u7b7e\u7ea6\u65e5\u671f"));
        entitys.add(new ExcelExportEntity("\u5927\u533a", (Object)"\u5927\u533a"));
        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"\u5ba2\u6237\u540d\u79f0"));
        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u5ba2\u6237", (Object)"\u6700\u7ec8\u5ba2\u6237"));
        entitys.add(new ExcelExportEntity("\u5546\u52a1", (Object)"\u5546\u52a1"));
        entitys.add(new ExcelExportEntity("\u5408\u540c\u91d1\u989d(H)", (Object)"\u5408\u540c\u91d1\u989d"));
        entitys.add(new ExcelExportEntity("\u7528\u53cbU8\u7f16\u7801", (Object)"\u7528\u53cbU8\u7f16\u7801"));
        entitys.add(new ExcelExportEntity("\u5b9e\u6536\u6b3e", (Object)"\u5b9e\u6536\u6b3e"));
        entitys.add(new ExcelExportEntity("\u514d\u8d39\u7ef4\u4fdd\u671f", (Object)"\u514d\u8d39\u7ef4\u4fdd\u671f"));
        entitys.add(new ExcelExportEntity("\u5408\u540c\u72b6\u6001", (Object)"\u5408\u540c\u72b6\u6001"));
        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u91d1\u6bd4\u4f8b", (Object)"\u8d28\u4fdd\u91d1\u6bd4\u4f8b"));
        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u91d1\u91d1\u989d(Z)", (Object)"\u8d28\u4fdd\u91d1\u91d1\u989d"));
        entitys.add(new ExcelExportEntity("\u662f\u5426\u6709\u9a8c\u6536\u5355", (Object)"\u662f\u5426\u6709\u9a8c\u6536\u5355"));
        entitys.add(new ExcelExportEntity("U8\u9a8c\u6536\u65f6\u95f4", (Object)"\u9a8c\u6536\u65f6\u95f4"));
        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u5408\u8ba1(C)", (Object)"\u56de\u6b3e\u5408\u8ba1"));
        entitys.add(new ExcelExportEntity("\u5f00\u7968\u5408\u8ba1(D)", (Object)"\u5f00\u7968\u5408\u8ba1"));
        entitys.add(new ExcelExportEntity("\u53d1\u7968-\u6536\u6b3e(D-C)", (Object)"\u53d1\u7968\u51cf\u6536\u6b3e"));
        entitys.add(new ExcelExportEntity("\u603b\u68c0\u67e5\u503c(E)", (Object)"\u603b\u68c0\u67e5\u503c"));
        entitys.add(new ExcelExportEntity("\u5408\u540c\u91d1\u989d-\u603b\u68c0\u67e5\u503c(H-E)", (Object)"\u5408\u540c\u91d1\u989d\u51cf\u603b\u68c0\u67e5\u503c"));
        entitys.add(new ExcelExportEntity("\u6536\u5165(\u542b\u7a0e)-\u6536\u6b3e(E-C)", (Object)"\u6536\u5165\u542b\u7a0e\u51cf\u6536\u6b3e"));
        entitys.add(new ExcelExportEntity("\u5408\u540c\u8d44\u4ea7(IF(AND(E-C)>0,Z>0),MIN((E-C)),Z),))", (Object)"\u5408\u540c\u8d44\u4ea7"));
        entitys.add(new ExcelExportEntity("\u5408\u540c\u6709\u6548\u72b6\u6001", (Object)"\u5408\u540c\u6709\u6548\u72b6\u6001"));
        return this.exportDate(list, entitys, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadVO exportContractLedger(RkContractAssetsLedgerPaginationExportModel assetsModel) throws ParseException {
        assetsModel.setCompanyId(this.userProvider.get().getOrganizeId());
        List<RkContractAssetsLedgerExportVO> exportList = this.rkcontractAssetsLedgerMapper.exportContractAssetsList(assetsModel);
        List<RkContractAssetsLedgerExportVO> exportLedger = this.rkcontractAssetsLedgerMapper.getContractLedgerList(assetsModel);
        List<RkContractAssetsLedgerExportVO> exportReturn = this.rkcontractAssetsLedgerMapper.getContractReturnAmountList(assetsModel);
        List<RkContractAssetsLedgerExportVO> exportInvoice = this.rkcontractAssetsLedgerMapper.getContractInvoiceAmountList(assetsModel);
        List<RkContractAssetsLedgerExportVO> assetsInvoice = this.rkcontractAssetsLedgerMapper.getContractAssetsInvoiceAmountList(assetsModel);
        ArrayList<Map> exList = new ArrayList<Map>();
        List<String> monthList = RkContractAssetsLedgerServiceImpl.getMonthBetweenDate(assetsModel.getAssetsStartDate(), assetsModel.getAssetsEndDate());
        List<RkContractAssetsLedgerExportVO> acceptanceDateList = this.rkcontractAssetsLedgerMapper.getContractAcceptanceDate(assetsModel);
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        for (String string : monthList) {
            ExcelExportEntity aa = new ExcelExportEntity(this.getYearMonth(string) + "\u786c\u4ef6\u6536\u5165", (Object)(string + "\u786c\u4ef6\u6536\u5165"));
            aa.setType(10);
            entitys.add(aa);
            entitys.add(new ExcelExportEntity(this.getYearMonth(string) + "\u8f6f\u4ef6\u6536\u5165", (Object)(string + "\u8f6f\u4ef6\u6536\u5165")));
            entitys.add(new ExcelExportEntity(this.getYearMonth(string) + "\u670d\u52a1\u6536\u5165", (Object)(string + "\u670d\u52a1\u6536\u5165")));
            entitys.add(new ExcelExportEntity(this.getYearMonth(string) + "\u786c\u4ef6\u6210\u672c", (Object)(string + "\u786c\u4ef6\u6210\u672c")));
            entitys.add(new ExcelExportEntity(this.getYearMonth(string) + "\u8f6f\u4ef6\u6210\u672c", (Object)(string + "\u8f6f\u4ef6\u6210\u672c")));
            entitys.add(new ExcelExportEntity(this.getYearMonth(string) + "\u76f4\u63a5\u8d39\u7528", (Object)(string + "\u76f4\u63a5\u8d39\u7528")));
            entitys.add(new ExcelExportEntity(this.getYearMonth(string) + "\u76f4\u63a5\u4eba\u5de5", (Object)(string + "\u76f4\u63a5\u4eba\u5de5")));
            entitys.add(new ExcelExportEntity(this.getYearMonth(string) + "\u56de\u6b3e\u91d1\u989d", (Object)(string + "\u56de\u6b3e\u91d1\u989d")));
            entitys.add(new ExcelExportEntity(this.getYearMonth(string) + "\u5f00\u7968\u91d1\u989d", (Object)(string + "\u5f00\u7968\u91d1\u989d")));
        }
        int i = 0;
        for (RkContractAssetsLedgerExportVO assets : exportList) {
            assets.setNum(i + 1);
            ++i;
            String hardware = assets.getHardwareRatio();
            String soft = assets.getSoftwareRatio();
            String service = assets.getServiceRatio();
            assets.setRatio(this.getRatio(hardware, soft, service));
            assets.set\u884c\u4e1a\u7c7b\u578b(this.baseDataUtil.getDictName(assets.getIndustry_type(), "industryType"));
            assets.set\u5408\u540c\u7c7b\u578b(this.baseDataUtil.getDictName(assets.getContract_type(), Constants.CONTRACT_TYPE_DICT_ID));
            assets.set\u9a8c\u6536\u65f6\u95f4(null);
            for (RkContractAssetsLedgerExportVO rkContractAssetsLedgerExportVO : acceptanceDateList) {
                if (!assets.get\u5408\u540c\u4e3b\u952e().equals(rkContractAssetsLedgerExportVO.get\u5408\u540c\u4e3b\u952e()) || !ObjectUtil.isNotEmpty((Object)assets.get\u6536\u5165\u5408\u8ba1()) || assets.get\u6536\u5165\u5408\u8ba1().compareTo(BigDecimal.ZERO) <= 0) continue;
                assets.set\u9a8c\u6536\u65f6\u95f4(rkContractAssetsLedgerExportVO.get\u9a8c\u6536\u65f6\u95f4());
            }
            Map map = JsonUtil.entityToMap((Object)assets);
            for (RkContractAssetsLedgerExportVO ledger : exportLedger) {
                if (!assets.get\u5408\u540c\u4e3b\u952e().equals(ledger.get\u5408\u540c\u4e3b\u952e())) continue;
                map.put(ledger.get\u5e74\u6708() + "\u786c\u4ef6\u6536\u5165", ledger.get\u786c\u4ef6\u6536\u5165());
                map.put(ledger.get\u5e74\u6708() + "\u8f6f\u4ef6\u6536\u5165", ledger.get\u8f6f\u4ef6\u6536\u5165());
                map.put(ledger.get\u5e74\u6708() + "\u670d\u52a1\u6536\u5165", ledger.get\u670d\u52a1\u6536\u5165());
                map.put(ledger.get\u5e74\u6708() + "\u786c\u4ef6\u6210\u672c", ledger.get\u786c\u4ef6\u6210\u672c());
                map.put(ledger.get\u5e74\u6708() + "\u8f6f\u4ef6\u6210\u672c", ledger.get\u8f6f\u4ef6\u6210\u672c());
                map.put(ledger.get\u5e74\u6708() + "\u76f4\u63a5\u8d39\u7528", ledger.get\u76f4\u63a5\u8d39\u7528());
                map.put(ledger.get\u5e74\u6708() + "\u76f4\u63a5\u4eba\u5de5", ledger.get\u76f4\u63a5\u4eba\u5de5());
            }
            for (RkContractAssetsLedgerExportVO ledger : exportReturn) {
                if (!assets.get\u5408\u540c\u4e3b\u952e().equals(ledger.get\u5408\u540c\u4e3b\u952e())) continue;
                map.put(ledger.get\u5e74\u6708() + "\u56de\u6b3e\u91d1\u989d", ledger.get\u56de\u6b3e\u91d1\u989d());
            }
            for (RkContractAssetsLedgerExportVO ai : assetsInvoice) {
                if (!assets.get\u5408\u540c\u4e3b\u952e().equals(ai.get\u5408\u540c\u4e3b\u952e())) continue;
                map.put(ai.get\u5e74\u6708() + "\u5f00\u7968\u91d1\u989d", ai.get\u5f00\u7968\u91d1\u989d());
            }
            for (RkContractAssetsLedgerExportVO ledger : exportInvoice) {
                if (!assets.get\u5408\u540c\u4e3b\u952e().equals(ledger.get\u5408\u540c\u4e3b\u952e())) continue;
                map.put(ledger.get\u5e74\u6708() + "\u5f00\u7968\u91d1\u989d", ledger.get\u5f00\u7968\u91d1\u989d());
            }
            exList.add(map);
        }
        List<ExcelExportEntity> list = this.getExportEntityInfo(entitys);
        String tableName = "\u5408\u540c\u53f0\u8d26\u8868_\u7b7e\u7ea6" + assetsModel.getContractStartDate().substring(0, 10) + "\u622a\u81f3" + assetsModel.getContractEndDate().substring(0, 10) + "\u91d1\u989d" + assetsModel.getAssetsStartDate().substring(0, 10) + "\u622a\u81f3" + assetsModel.getAssetsEndDate().substring(0, 10) + "_";
        DownloadVO vo = DownloadVO.builder().build();
        ExportParams exportParams = new ExportParams(null, tableName);
        exportParams.setType(ExcelType.XSSF);
        try {
            UserInfo userInfo = this.userProvider.get();
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, list, exList);
                }
                String string = tableName + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + string;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)string);
                    vo.setName(string);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + string + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}" + e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public List<RkContractAssetsLedgerInfoVO> getRkContractAssetsLedgerInfoVO(RkContractAssetsLedgerPagination ledgerPagination) {
        UserInfo userInfo = this.userProvider.get();
        List<RkContractAssetsLedgerEntity> list = this.getList(ledgerPagination);
        List listLedgerInfo = JsonUtil.getJsonToList(list, RkContractAssetsLedgerInfoVO.class);
        if (ObjectUtil.isNotEmpty((Object)listLedgerInfo)) {
            for (RkContractAssetsLedgerInfoVO vo : listLedgerInfo) {
                vo.setCreateUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
            }
        }
        return listLedgerInfo;
    }

    @Override
    public boolean updateContractassetsledgerCheckAmoutn(RkContractAssetsLedgerEntity subentity) {
        LambdaQueryWrapper queryWrapperAss = new LambdaQueryWrapper();
        queryWrapperAss.eq(RkContractAssetsLedgerEntity::getContractId, (Object)subentity.getContractId());
        queryWrapperAss.eq(RkContractAssetsLedgerEntity::getEnabledMark, (Object)0);
        this.update(subentity, (Wrapper)queryWrapperAss);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DownloadVO exportDate(List<RkContractAssetsLedgerExportVO> list, List<ExcelExportEntity> entitys, String tableName) {
        DownloadVO vo = DownloadVO.builder().build();
        ExportParams exportParams = new ExportParams(null, tableName);
        exportParams.setType(ExcelType.XSSF);
        try {
            UserInfo userInfo = this.userProvider.get();
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = tableName + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}" + e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    List<ExcelExportEntity> getExportEntityInfo(List<ExcelExportEntity> entity) {
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        entitys.add(new ExcelExportEntity("\u5e8f\u53f7", (Object)"num"));
        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u7801", (Object)"\u5408\u540c\u7f16\u7801"));
        entitys.add(new ExcelExportEntity("\u7528\u53cbU8\u7f16\u7801", (Object)"\u7528\u53cbU8\u7f16\u7801"));
        entitys.add(new ExcelExportEntity("\u7b7e\u7ea6\u65e5\u671f", (Object)"\u7b7e\u7ea6\u65e5\u671f"));
        entitys.add(new ExcelExportEntity("\u6536\u5165\u7c7b\u578b", (Object)"\u6536\u5165\u7c7b\u578b"));
        entitys.add(new ExcelExportEntity("\u884c\u4e1a\u7c7b\u578b", (Object)"\u884c\u4e1a\u7c7b\u578b"));
        entitys.add(new ExcelExportEntity("\u516c\u544a\u884c\u4e1a", (Object)"\u516c\u544a\u884c\u4e1a"));
        entitys.add(new ExcelExportEntity("\u516c\u544a\u9500\u552e\u6a21\u5f0f", (Object)"\u516c\u544a\u9500\u552e\u6a21\u5f0f"));
        entitys.add(new ExcelExportEntity("\u7ecf\u8425\u62a5\u7c7b\u522b", (Object)"\u7ecf\u8425\u62a5\u7c7b\u522b"));
        entitys.add(new ExcelExportEntity("\u6536\u5165\u786e\u8ba4\u65b9\u5f0f", (Object)"\u6536\u5165\u786e\u8ba4\u65b9\u5f0f"));
        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"\u5408\u540c\u7c7b\u578b"));
        entitys.add(new ExcelExportEntity("\u5927\u533a", (Object)"\u5927\u533a"));
        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"\u5ba2\u6237\u540d\u79f0"));
        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u5ba2\u6237", (Object)"\u6700\u7ec8\u5ba2\u6237"));
        entitys.add(new ExcelExportEntity("\u5546\u52a1", (Object)"\u5546\u52a1"));
        entitys.add(new ExcelExportEntity("\u5408\u540c\u91d1\u989d(H)", (Object)"\u5408\u540c\u91d1\u989d"));
        entitys.add(new ExcelExportEntity("\u5408\u540c\u6bdb\u5229\u7387", (Object)"\u5408\u540c\u6bdb\u5229\u7387"));
        entitys.add(new ExcelExportEntity("\u5b9e\u6536\u6b3e", (Object)"\u5b9e\u6536\u6b3e"));
        entitys.add(new ExcelExportEntity("\u8fd4\u56de\u7c7b\u522b", (Object)"\u8fd4\u56de\u7c7b\u522b"));
        entitys.add(new ExcelExportEntity("\u514d\u8d39\u7ef4\u4fdd\u671f", (Object)"\u514d\u8d39\u7ef4\u4fdd\u671f"));
        entitys.add(new ExcelExportEntity("\u5408\u540c\u72b6\u6001", (Object)"\u5408\u540c\u72b6\u6001"));
        entitys.add(new ExcelExportEntity("\u4ed8\u6b3e\u65b9\u5f0f", (Object)"\u4ed8\u6b3e\u65b9\u5f0f"));
        entitys.add(new ExcelExportEntity("\u6027\u8d28", (Object)"\u6027\u8d28"));
        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u91d1\u6bd4\u4f8b", (Object)"\u8d28\u4fdd\u91d1\u6bd4\u4f8b"));
        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u91d1\u91d1\u989d(Z)", (Object)"\u8d28\u4fdd\u91d1\u91d1\u989d"));
        entitys.add(new ExcelExportEntity("\u662f\u5426\u6709\u9a8c\u6536\u5355", (Object)"\u662f\u5426\u6709\u9a8c\u6536\u5355"));
        entitys.add(new ExcelExportEntity("U8\u9a8c\u6536\u65f6\u95f4", (Object)"\u9a8c\u6536\u65f6\u95f4"));
        entitys.addAll(entity);
        entitys.add(new ExcelExportEntity("\u786c\u4ef6\u6536\u5165\u5c0f\u8ba1(A1)", (Object)"\u786c\u4ef6\u6536\u5165\u5c0f\u8ba1"));
        entitys.add(new ExcelExportEntity("\u8f6f\u4ef6\u6536\u5165\u5c0f\u8ba1(A2)", (Object)"\u8f6f\u4ef6\u6536\u5165\u5c0f\u8ba1"));
        entitys.add(new ExcelExportEntity("\u670d\u52a1\u6536\u5165\u5c0f\u8ba1(A3)", (Object)"\u670d\u52a1\u6536\u5165\u5c0f\u8ba1"));
        entitys.add(new ExcelExportEntity("\u6536\u5165\u5408\u8ba1(A1+A2+A3)", (Object)"\u6536\u5165\u5408\u8ba1"));
        entitys.add(new ExcelExportEntity("\u786c\u4ef6\u6210\u672c\u5c0f\u8ba1(B1)", (Object)"\u786c\u4ef6\u6210\u672c\u5c0f\u8ba1"));
        entitys.add(new ExcelExportEntity("\u8f6f\u4ef6\u6210\u672c\u5c0f\u8ba1(B2)", (Object)"\u8f6f\u4ef6\u6210\u672c\u5c0f\u8ba1"));
        entitys.add(new ExcelExportEntity("\u76f4\u63a5\u8d39\u7528(B3)", (Object)"\u76f4\u63a5\u8d39\u7528"));
        entitys.add(new ExcelExportEntity("\u76f4\u63a5\u4eba\u5de5(B4)", (Object)"\u76f4\u63a5\u4eba\u5de5"));
        entitys.add(new ExcelExportEntity("\u6210\u672c\u5408\u8ba1(B1+B2+B3+B4)", (Object)"\u6210\u672c\u5408\u8ba1"));
        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u5408\u8ba1(C)", (Object)"\u56de\u6b3e\u5408\u8ba1"));
        entitys.add(new ExcelExportEntity("\u5f00\u7968\u5408\u8ba1(D)", (Object)"\u5f00\u7968\u5408\u8ba1"));
        entitys.add(new ExcelExportEntity("\u603b\u68c0\u67e5\u503c(E)", (Object)"\u603b\u68c0\u67e5\u503c"));
        entitys.add(new ExcelExportEntity("\u5408\u540c\u91d1\u989d-\u603b\u68c0\u67e5\u503c(H-E)", (Object)"\u5408\u540c\u91d1\u989d\u51cf\u603b\u68c0\u67e5\u503c"));
        entitys.add(new ExcelExportEntity("\u7a0e\u7387", (Object)"ratio"));
        entitys.add(new ExcelExportEntity("\u5408\u540c\u6709\u6548\u72b6\u6001", (Object)"\u5408\u540c\u6709\u6548\u72b6\u6001"));
        return entitys;
    }

    String getYearMonth(String yearMonth) {
        yearMonth = yearMonth.replace("-", "\u5e74");
        yearMonth = yearMonth + "\u6708";
        return yearMonth;
    }

    String getRatio(String hardware, String soft, String service) {
        String ratio = "";
        if (hardware != null) {
            ratio = ratio + hardware;
        }
        if (soft != null && !ratio.contains(soft)) {
            ratio = ObjectUtil.isNotEmpty((Object)ratio) ? ratio + "," + soft : ratio + soft;
        }
        if (service != null && !ratio.contains(service)) {
            ratio = ObjectUtil.isNotEmpty((Object)ratio) ? ratio + "," + service : ratio + service;
        }
        return ratio;
    }

    @Override
    public void delete(RkContractAssetsLedgerEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    public static List<String> getMonthBetweenDate(String startTime, String endTime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        ArrayList<String> list = new ArrayList<String>();
        Date startDate = sdf.parse(startTime);
        Date endDate = sdf.parse(endTime);
        Calendar calendar = Calendar.getInstance();
        while (startDate.getTime() <= endDate.getTime()) {
            list.add(sdf.format(startDate));
            calendar.setTime(startDate);
            calendar.add(2, 1);
            startDate = calendar.getTime();
        }
        return list;
    }

    @Override
    public long countByContractId(String contractId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RkContractAssetsLedgerEntity::getContractId, (Object)contractId)).eq(RkContractAssetsLedgerEntity::getEnabledMark, (Object)0);
        return this.count((Wrapper)queryWrapper);
    }
}

