/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.bonus.model.salebonusaudit.ReturnAmountDTO;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.ConvertUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.PageUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkCollectionPlanRelationEntity;
import com.bringspring.contract.entity.RkContractCollectionRecordEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.mapper.RkContractCollectionRecordMapper;
import com.bringspring.contract.model.countAmount.CountAmountVO;
import com.bringspring.contract.model.rkcontract.RkContractPagination;
import com.bringspring.contract.model.rkcontract.RkContractUpForm;
import com.bringspring.contract.model.rkcontractcollectionrecord.ContractCollectionImportReturnVO;
import com.bringspring.contract.model.rkcontractcollectionrecord.ContractCollectionImportVO;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordCrForm;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordPagination;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanCrForm;
import com.bringspring.contract.service.RkCollectionPlanRelationService;
import com.bringspring.contract.service.RkContractCollectionRecordService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.ContractEnableMarkEnum;
import com.bringspring.contract.utils.DictEncodeEnum;
import com.bringspring.contract.utils.EnableMarkEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ReturnPlanEnum;
import com.bringspring.contract.utils.RoleUtils;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.model.datacenter.SaleDataSummaryVo;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractCollectionRecordServiceImpl
extends ServiceImpl<RkContractCollectionRecordMapper, RkContractCollectionRecordEntity>
implements RkContractCollectionRecordService {
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkContractReturnPlanService contractReturnPlanService;
    @Autowired
    private RkCollectionPlanRelationService collectionPlanRelationService;
    @Autowired
    private RoleUtils roleUtils;
    @Autowired
    private RkContractProjectService contractProjectService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkContractCollectionRecordMapper rkContractCollectionRecordMapper;

    @Override
    public List<RkContractCollectionRecordEntity> getList(RkContractCollectionRecordPagination rkContractCollectionRecordPagination) {
        QueryWrapper rkContractCollectionRecordQueryWrapper = this.appendWrapper(rkContractCollectionRecordPagination);
        if (ObjectUtil.isEmpty(rkContractCollectionRecordQueryWrapper)) {
            ArrayList list = new ArrayList();
            return rkContractCollectionRecordPagination.setData(list, list.size());
        }
        if (ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getSidx())) {
            rkContractCollectionRecordQueryWrapper.lambda().orderByDesc(RkContractCollectionRecordEntity::getReturnDate);
        } else {
            try {
                String sidx = rkContractCollectionRecordPagination.getSidx();
                RkContractCollectionRecordEntity rkContractCollectionRecordEntity = new RkContractCollectionRecordEntity();
                Field declaredField = rkContractCollectionRecordEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractCollectionRecordQueryWrapper = "asc".equals(rkContractCollectionRecordPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractCollectionRecordQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractCollectionRecordQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        Page page = new Page(rkContractCollectionRecordPagination.getCurrentPage(), rkContractCollectionRecordPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)rkContractCollectionRecordQueryWrapper);
        if (ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordPagination.getCommissionType())) {
            List<Object> list = new ArrayList();
            list = this.list((Wrapper)rkContractCollectionRecordQueryWrapper);
            ArrayList<Object> resultList = new ArrayList();
            if (CollectionUtil.isNotEmpty(list)) {
                List contractList = this.contractService.listByIds(list.stream().map(RkContractCollectionRecordEntity::getContractId).collect(Collectors.toList()));
                contractList.stream().forEach(contract -> {
                    if (ObjectUtil.isEmpty((Object)contract.getReturnSettlementStatus())) {
                        contract.setReturnSettlementStatus("notSettled");
                        this.contractService.updateById(contract);
                    }
                });
                if (ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordPagination.getSource())) {
                    List filterIdList = contractList.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getReturnRatio()) && t.getReturnRatio().compareTo(BigDecimal.valueOf(90L)) >= 0).filter(t -> ObjectUtil.isNotEmpty((Object)t.getReturnSettlementStatus()) && (!t.getReturnSettlementStatus().equals("settled") || !t.getReturnSettlementStatus().equals("inSettlement"))).map(RkContractEntity::getId).collect(Collectors.toList());
                    list = list.stream().filter(t -> filterIdList.contains(t.getContractId())).collect(Collectors.toList());
                }
                Map<String, BigDecimal> sumByContractId = list.stream().collect(Collectors.groupingBy(RkContractCollectionRecordEntity::getContractId, Collectors.reducing(BigDecimal.ZERO, RkContractCollectionRecordEntity::getReturnAmount, BigDecimal::add)));
                Map<String, BigDecimal> sumRate = list.stream().collect(Collectors.groupingBy(RkContractCollectionRecordEntity::getContractId, Collectors.reducing(BigDecimal.ZERO, entity -> entity.getReturnRate() != null ? new BigDecimal(entity.getReturnRate()) : BigDecimal.ZERO, BigDecimal::add)));
                list.stream().forEach(vo -> {
                    if (sumByContractId.containsKey(vo.getContractId()) && sumRate.containsKey(vo.getContractId())) {
                        vo.setReturnAmount((BigDecimal)sumByContractId.get(vo.getContractId()));
                        vo.setReturnRate(((BigDecimal)sumRate.get(vo.getContractId())).toString());
                    }
                });
                Map<String, RkContractCollectionRecordEntity> uniqueByContractId = list.stream().filter(vo -> ObjectUtil.isNotEmpty((Object)vo.getReturnDate())).collect(Collectors.toMap(RkContractCollectionRecordEntity::getContractId, vo -> vo, (existing, replacement) -> existing.getReturnDate().compareTo(replacement.getReturnDate()) > 0 ? existing : replacement));
                resultList = new ArrayList<RkContractCollectionRecordEntity>(uniqueByContractId.values());
            }
            return rkContractCollectionRecordPagination.setData(PageUtil.getPage((int)((int)rkContractCollectionRecordPagination.getCurrentPage()), (int)((int)rkContractCollectionRecordPagination.getPageSize()), resultList), resultList.size());
        }
        return rkContractCollectionRecordPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public List<RkContractCollectionRecordEntity> getListByNoPage(RkContractCollectionRecordPagination rkContractCollectionRecordPagination) {
        QueryWrapper rkContractCollectionRecordQueryWrapper = this.appendWrapper(rkContractCollectionRecordPagination);
        if (ObjectUtil.isEmpty(rkContractCollectionRecordQueryWrapper)) {
            ArrayList list = new ArrayList();
            return rkContractCollectionRecordPagination.setData(list, list.size());
        }
        if (ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getSidx())) {
            rkContractCollectionRecordQueryWrapper.lambda().orderByDesc(RkContractCollectionRecordEntity::getCreatorTime);
        } else {
            try {
                String sidx = rkContractCollectionRecordPagination.getSidx();
                RkContractCollectionRecordEntity rkContractCollectionRecordEntity = new RkContractCollectionRecordEntity();
                Field declaredField = rkContractCollectionRecordEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractCollectionRecordQueryWrapper = "asc".equals(rkContractCollectionRecordPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractCollectionRecordQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractCollectionRecordQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        List list = this.list((Wrapper)rkContractCollectionRecordQueryWrapper);
        Map<String, RkContractCollectionRecordEntity> uniqueByContractId = list.stream().filter(vo -> ObjectUtil.isNotEmpty((Object)vo.getReturnDate())).collect(Collectors.toMap(RkContractCollectionRecordEntity::getContractId, vo -> vo, (existing, replacement) -> existing.getReturnDate().compareTo(replacement.getReturnDate()) > 0 ? existing : replacement));
        ArrayList<RkContractCollectionRecordEntity> resultList = new ArrayList<RkContractCollectionRecordEntity>(uniqueByContractId.values());
        return resultList;
    }

    @Override
    public Map<String, Object> countAmount(RkContractCollectionRecordPagination rkContractCollectionRecordPagination) {
        QueryWrapper<RkContractCollectionRecordEntity> queryWrapper = this.appendWrapper(rkContractCollectionRecordPagination);
        Map map = MapUtil.newHashMap();
        map.put("totalReturnAmount", "0");
        map.put("totalReturnNum", "0");
        if (ObjectUtil.isEmpty(queryWrapper)) {
            return map;
        }
        queryWrapper.select(new String[]{" IFNULL(sum(return_amount),0) as totalReturnAmount  ,count(id) as totalReturnNum"});
        map = this.getMap((Wrapper)queryWrapper);
        return map;
    }

    private QueryWrapper<RkContractCollectionRecordEntity> appendWrapper(RkContractCollectionRecordPagination rkContractCollectionRecordPagination) {
        Object rkContractObj;
        QueryWrapper rkContractCollectionRecordQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractCollectionRecordQueryWrapper, rkContractCollectionRecordPagination.getMenuId(), "rk_contract_collection_record"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return null;
            }
            rkContractCollectionRecordQueryWrapper = (QueryWrapper)rkContractObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractCollectionRecordQueryWrapper, rkContractCollectionRecordPagination.getMenuId(), "rk_contract_collection_record"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return null;
            }
            rkContractCollectionRecordQueryWrapper = (QueryWrapper)rkContractObj;
        }
        rkContractCollectionRecordQueryWrapper.lambda().eq(RkContractCollectionRecordEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        if (ObjectUtil.isNotEmpty(rkContractCollectionRecordPagination.getReturnDate())) {
            List<Date> ReturnDateList = rkContractCollectionRecordPagination.getReturnDate();
            Date fir = ReturnDateList.get(0);
            Date sec = ReturnDateList.get(1);
            rkContractCollectionRecordQueryWrapper.lambda().between(RkContractCollectionRecordEntity::getReturnDate, (Object)fir, (Object)sec);
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordPagination.getDigitalRecord()) && "1".equals(rkContractCollectionRecordPagination.getDigitalRecord())) {
            rkContractCollectionRecordQueryWrapper.lambda().like(RkContractCollectionRecordEntity::getContractType, (Object)"636567520685427789");
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordPagination.getReturnAmount())) {
            rkContractCollectionRecordQueryWrapper.lambda().like(RkContractCollectionRecordEntity::getReturnAmount, (Object)rkContractCollectionRecordPagination.getReturnAmount());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordPagination.getReturnRate())) {
            rkContractCollectionRecordQueryWrapper.lambda().like(RkContractCollectionRecordEntity::getReturnRate, (Object)rkContractCollectionRecordPagination.getReturnRate());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getReturnMonth()) && !ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getReturnMonth())) {
            rkContractCollectionRecordQueryWrapper.lambda().apply("DATE_FORMAT(return_date,'%Y-%m') = '" + rkContractCollectionRecordPagination.getReturnMonth() + "'", new Object[0]);
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordPagination.getDescription())) {
            rkContractCollectionRecordQueryWrapper.lambda().like(RkContractCollectionRecordEntity::getDescription, (Object)rkContractCollectionRecordPagination.getDescription());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordPagination.getCompanyId())) {
            rkContractCollectionRecordQueryWrapper.lambda().eq(RkContractCollectionRecordEntity::getCompanyId, (Object)rkContractCollectionRecordPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(rkContractCollectionRecordPagination.getCompanyIdList())) {
            rkContractCollectionRecordQueryWrapper.lambda().in(RkContractCollectionRecordEntity::getCompanyId, rkContractCollectionRecordPagination.getCompanyIdList());
        }
        if (CollectionUtil.isNotEmpty(rkContractCollectionRecordPagination.getSalerCompanyIdList())) {
            rkContractCollectionRecordQueryWrapper.lambda().in(RkContractCollectionRecordEntity::getSalerCompanyId, rkContractCollectionRecordPagination.getSalerCompanyIdList());
        }
        if (CollectionUtil.isNotEmpty(rkContractCollectionRecordPagination.getRegionIdList())) {
            rkContractCollectionRecordQueryWrapper.lambda().in(RkContractCollectionRecordEntity::getCustomerProv, rkContractCollectionRecordPagination.getRegionIdList());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordPagination.getReturnSettlementStatus())) {
            List<RkContractEntity> listBySettlementStage = this.contractService.getListBySettlementStage(rkContractCollectionRecordPagination.getReturnSettlementStatus());
            if (CollectionUtil.isNotEmpty(listBySettlementStage)) {
                List idList = listBySettlementStage.stream().map(RkContractEntity::getId).collect(Collectors.toList());
                if (rkContractCollectionRecordPagination.getReturnSettlementStatus().equals("notSettled")) {
                    List list = this.list((Wrapper)rkContractCollectionRecordQueryWrapper);
                    List collect = list.stream().map(RkContractCollectionRecordEntity::getContractId).collect(Collectors.toList());
                    collect.stream().forEach(t -> {
                        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)t));
                        if (!idList.contains(t) && ObjectUtil.isEmpty((Object)byId.getReturnSettlementStatus())) {
                            idList.add(t);
                        }
                    });
                }
                rkContractCollectionRecordQueryWrapper.lambda().in(RkContractCollectionRecordEntity::getContractId, idList);
            } else {
                return null;
            }
        }
        if (CollectionUtil.isNotEmpty(rkContractCollectionRecordPagination.getCustomerAddress())) {
            rkContractCollectionRecordPagination.getCustomerAddress().stream().filter(x -> {
                boolean flag = x.size() < 2 && ((String)x.get(0)).equals("10");
                return !flag;
            }).collect(Collectors.toList());
            if (rkContractCollectionRecordPagination.getCustomerAddress().size() < 2 && rkContractCollectionRecordPagination.getCustomerAddress().get(0).equals("10")) {
                rkContractCollectionRecordPagination.setCustomerAddress(null);
            }
        }
        if (CollectionUtil.isNotEmpty(rkContractCollectionRecordPagination.getCustomerAddress())) {
            rkContractCollectionRecordQueryWrapper.lambda().and(x -> {
                for (List<String> ll : rkContractCollectionRecordPagination.getCustomerAddress()) {
                    List addressList = JsonUtil.getJsonToList(ll, String.class);
                    if (addressList.size() > 1) {
                        String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                        collect = "[" + collect;
                        ((LambdaQueryWrapper)x.or()).like(RkContractCollectionRecordEntity::getCustomerAddress, (Object)collect);
                        continue;
                    }
                    String s2 = (String)addressList.get(addressList.size() - 1);
                    s2 = "[\"" + s2 + "\"";
                    ((LambdaQueryWrapper)x.or()).like(RkContractCollectionRecordEntity::getCustomerAddress, (Object)s2);
                }
            });
        }
        if (!(ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getCustomerId()) && ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getContractCode()) && ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getIncomeType()) && ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getContractType()) && ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getContractName()) && ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getAgentId()) && ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getSalerId()) && !CollectionUtil.isNotEmpty(rkContractCollectionRecordPagination.getSignDate()) && !CollectionUtil.isNotEmpty(rkContractCollectionRecordPagination.getArchivedDate()))) {
            List<RkContractEntity> listBy = this.contractService.getListBy(rkContractCollectionRecordPagination);
            if (CollectionUtil.isEmpty(listBy)) {
                return null;
            }
            List collect = listBy.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            rkContractCollectionRecordQueryWrapper.lambda().in(RkContractCollectionRecordEntity::getContractId, collect);
        }
        return rkContractCollectionRecordQueryWrapper;
    }

    @Override
    public List<RkContractCollectionRecordEntity> getTypeList(RkContractCollectionRecordPagination rkContractCollectionRecordPagination, String dataType) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper rkContractCollectionRecordQueryWrapper = this.appendWrapper(rkContractCollectionRecordPagination);
        if (ObjectUtil.isEmpty(rkContractCollectionRecordQueryWrapper)) {
            ArrayList list = new ArrayList();
            return rkContractCollectionRecordPagination.setData(list, list.size());
        }
        if (AllIdList.size() > 0) {
            rkContractCollectionRecordQueryWrapper.lambda().in(RkContractCollectionRecordEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getSidx())) {
            rkContractCollectionRecordQueryWrapper.lambda().orderByDesc(RkContractCollectionRecordEntity::getId);
        } else {
            try {
                String sidx = rkContractCollectionRecordPagination.getSidx();
                RkContractCollectionRecordEntity rkContractCollectionRecordEntity = new RkContractCollectionRecordEntity();
                Field declaredField = rkContractCollectionRecordEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractCollectionRecordQueryWrapper = "asc".equals(rkContractCollectionRecordPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractCollectionRecordQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractCollectionRecordQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractCollectionRecordPagination.getCurrentPage(), rkContractCollectionRecordPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractCollectionRecordQueryWrapper);
                return rkContractCollectionRecordPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractCollectionRecordPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractCollectionRecordQueryWrapper);
    }

    @Override
    public RkContractCollectionRecordEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractCollectionRecordEntity::getId, (Object)id);
        return (RkContractCollectionRecordEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkContractCollectionRecordEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkContractCollectionRecordEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkContractCollectionRecordEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    @DSTransactional
    public HashMap saveCollectionRecord(RkContractCollectionRecordCrForm crForm) {
        RkContractProjectEntity projectEntity;
        HashMap map = MapUtil.newHashMap();
        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)crForm.getContractId()));
        if (ObjectUtil.isEmpty((Object)byId)) {
            map.put("error", "\u5408\u540c\u4e0d\u5b58\u5728");
            return map;
        }
        List<RkContractReturnPlanCrForm> planCrFormList = crForm.getPlanCrFormList();
        AtomicBoolean flag = new AtomicBoolean(false);
        planCrFormList.stream().forEach(plan -> {
            String add;
            if (!ObjectUtil.isEmpty((Object)plan.getCheckAmount()) && MathUtils.toBigDecimal(add = MathUtils.add(ObjectUtil.isEmpty((Object)plan.getReturnAmount()) ? "0" : plan.getReturnAmount().toString(), plan.getCheckAmount())).compareTo(MathUtils.toBigDecimal(plan.getReceivableAmount())) == 1) {
                flag.set(true);
                return;
            }
        });
        if (flag.get()) {
            map.put("error", "\u5b9e\u9645\u52fe\u5151\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u6b3e\u91d1\u989d");
            return map;
        }
        String s = RandomUtil.uuId();
        RkContractProjectEntity info = this.contractProjectService.getInfo(crForm.getProjectId());
        RkContractCollectionRecordEntity entity = (RkContractCollectionRecordEntity)JsonUtil.getJsonToBean((Object)crForm, RkContractCollectionRecordEntity.class);
        entity.setContractType(byId.getContractType());
        entity.setId(s);
        entity.setSalerId(byId.getSalerId());
        entity.setSalerName(byId.getSalerName());
        entity.setSalerCompanyId(byId.getSalerCompanyId());
        entity.setSalerPlatFormCompanyId(byId.getSalerPlatFormCompanyId());
        if (ObjectUtil.isNotEmpty((Object)info)) {
            entity.setCustomerId(info.getCustomerId());
            entity.setProjectManagerId(info.getProjectHeader());
        }
        if (!ObjectUtil.isEmpty((Object)entity.getCustomerId())) {
            CrmCustomerEntity customerEntity = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()));
            entity.setCustomerAddress(customerEntity.getAddress());
            entity.setCustomerAddressName(this.baseDataUtil.provinceData(entity.getCustomerAddress()));
            String[] split = customerEntity.getAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    entity.setCustomerRegion(split[0]);
                    entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
                }
                if (i == 1) {
                    entity.setCustomerProv(split[1]);
                    entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
                }
                if (i != 2) continue;
                entity.setCustomerCity(split[2]);
                entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
            }
        }
        this.save(entity);
        List relationEntityList = CollectionUtil.list((boolean)false);
        planCrFormList.stream().forEach(plan -> {
            if (ObjectUtil.isEmpty((Object)plan.getCheckAmount())) {
                plan.setCheckAmount("0");
            }
            BigDecimal bigDecimal = MathUtils.toBigDecimal(MathUtils.add(ObjectUtil.isEmpty((Object)plan.getReturnAmount()) ? "0" : plan.getReturnAmount().toString(), ObjectUtil.isEmpty((Object)plan.getCheckAmount()) ? "0" : plan.getCheckAmount()));
            plan.setReturnAmount(bigDecimal);
            if (!ObjectUtil.isEmpty((Object)plan.getCheckAmount())) {
                if (MathUtils.toBigDecimal(plan.getCheckAmount()).compareTo(BigDecimal.ZERO) == 1) {
                    plan.setReturnState(ReturnPlanEnum.START.getState());
                } else {
                    plan.setReturnState(ReturnPlanEnum.NOT_START.getState());
                }
                if (MathUtils.toBigDecimal(plan.getCheckAmount()).compareTo(BigDecimal.ZERO) != 0 && null != crForm.getReturnDate()) {
                    plan.setLatestPaymentDate((Date)DateUtil.date((long)crForm.getReturnDate()));
                }
            }
            if (bigDecimal.compareTo(MathUtils.toBigDecimal(plan.getReceivableAmount())) != -1) {
                plan.setReturnState(ReturnPlanEnum.END.getState());
            }
            String divide = MathUtils.divide(MathUtils.multiply(ObjectUtil.isEmpty((Object)plan.getReturnAmount()) ? "0" : plan.getReturnAmount().toString(), "100"), plan.getReceivableAmount(), 2);
            plan.setReturnRate(divide);
            RkCollectionPlanRelationEntity relationEntity = new RkCollectionPlanRelationEntity();
            relationEntity.setPlanId(plan.getId());
            relationEntity.setCollectionId(s);
            relationEntity.setAmount(MathUtils.toBigDecimal(plan.getCheckAmount()));
            relationEntity.setId(RandomUtil.uuId());
            relationEntityList.add(relationEntity);
        });
        List jsonToList = JsonUtil.getJsonToList(planCrFormList, RkContractReturnPlanEntity.class);
        jsonToList.stream().forEach(plan -> plan.setAgentId(byId.getAgentId()));
        this.contractReturnPlanService.updateBatchById(jsonToList);
        this.collectionPlanRelationService.saveBatch(relationEntityList);
        if (StrUtil.isNotBlank((CharSequence)crForm.getProjectId()) && !StrUtil.equals((CharSequence)byId.getContractType(), (CharSequence)"636567520685427789") && ObjectUtil.isNotNull((Object)(projectEntity = (RkContractProjectEntity)this.contractProjectService.getById((Serializable)((Object)crForm.getProjectId()))))) {
            String add = MathUtils.add(ObjectUtil.isEmpty((Object)projectEntity.getReceivedAmount()) ? "0" : projectEntity.getReceivedAmount().toString(), crForm.getReturnAmount());
            projectEntity.setReceivedAmount(MathUtils.toBigDecimal(add));
            String divide = MathUtils.divide(MathUtils.multiply(add, "100"), projectEntity.getProjectAmount().toString(), 2);
            projectEntity.setReceivedRatio(MathUtils.toBigDecimal(divide));
            projectEntity.setReceivedState(ReturnPlanEnum.START.getState());
            if (ObjectUtil.isNull((Object)projectEntity.getReceivedAmount()) || projectEntity.getReceivedAmount().compareTo(BigDecimal.ZERO) != 1) {
                projectEntity.setReceivedState(ReturnPlanEnum.NOT_START.getState());
            }
            if (projectEntity.getReceivedRatio().compareTo(new BigDecimal("100")) != -1) {
                projectEntity.setReceivedState(ReturnPlanEnum.END.getState());
            }
            this.contractProjectService.update(projectEntity.getId(), projectEntity);
        }
        if (!StrUtil.equals((CharSequence)byId.getContractType(), (CharSequence)"636567520685427789")) {
            String add = MathUtils.add(ObjectUtil.isEmpty((Object)byId.getReturnAmount()) ? "0" : byId.getReturnAmount().toString(), crForm.getReturnAmount());
            byId.setReturnAmount(MathUtils.toBigDecimal(add));
            String divide = MathUtils.divide(MathUtils.multiply(add, "100"), byId.getContractAmount().toString(), 2);
            byId.setReturnRatio(MathUtils.toBigDecimal(divide));
            byId.setReturnState(ReturnPlanEnum.START.getState() + "");
            if (ObjectUtil.isNull((Object)byId.getReturnAmount()) || byId.getReturnAmount().compareTo(BigDecimal.ZERO) != 1) {
                byId.setReturnState(ReturnPlanEnum.NOT_START.getState() + "");
            }
            if (byId.getReturnRatio().compareTo(new BigDecimal("100")) != -1) {
                byId.setEnableMark(ContractEnableMarkEnum.ENABLE_COMPLETED.getEnableMark());
                byId.setReturnState(ReturnPlanEnum.END.getState() + "");
                byId.setIsChangeNow(0);
            }
            this.contractService.update(byId.getId(), byId);
        }
        return map;
    }

    @Override
    public List<RkContractCollectionRecordEntity> getListByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractCollectionRecordEntity::getContractId, (Object)contractId)).eq(RkContractCollectionRecordEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractCollectionRecordEntity> getListByContractIdList(List<String> contractIdList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().in(RkContractCollectionRecordEntity::getContractId, contractIdList)).eq(RkContractCollectionRecordEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractCollectionRecordEntity> getListByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractCollectionRecordEntity::getProjectId, (Object)projectId)).eq(RkContractCollectionRecordEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public HashMap deleteCollectionRecord(String id) {
        UserInfo userInfo = this.userProvider.get();
        HashMap map = MapUtil.newHashMap();
        RkContractCollectionRecordEntity byId = (RkContractCollectionRecordEntity)this.getById((Serializable)((Object)id));
        if (ObjectUtil.isEmpty((Object)byId) || byId.getEnabledMark() == EnableMarkEnum.INVALID.getEnableMark()) {
            map.put("error", "\u6536\u6b3e\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return map;
        }
        byId.setEnabledMark(EnableMarkEnum.INVALID.getEnableMark());
        byId.setDeleteTime(new Date());
        byId.setDeleteUserId(userInfo.getUserId());
        this.update(id, byId);
        HashMap planAmountMap = MapUtil.newHashMap();
        List planIdList = CollectionUtil.list((boolean)false);
        List<RkCollectionPlanRelationEntity> byCollectionId = this.collectionPlanRelationService.getByCollectionId(id);
        if (CollectionUtil.isNotEmpty(byCollectionId)) {
            byCollectionId.stream().forEach(relation -> {
                relation.setEnabledMark(EnableMarkEnum.INVALID.getEnableMark());
                relation.setDeleteTime(new Date());
                relation.setDeleteUserId(userInfo.getUserId());
                planAmountMap.put(relation.getPlanId(), relation.getAmount());
                planIdList.add(relation.getPlanId());
            });
            this.collectionPlanRelationService.updateBatchById(byCollectionId);
        }
        List updateLastReturnDateEmptyList = CollectionUtil.list((boolean)false);
        if (CollectionUtil.isNotEmpty((Collection)planIdList)) {
            List<RkContractReturnPlanEntity> listByIdList = this.contractReturnPlanService.getListByIdList(planIdList);
            listByIdList.stream().forEach(plan -> {
                String substract = MathUtils.substract(plan.getReturnAmount().toString(), ((BigDecimal)planAmountMap.get(plan.getId())).toString());
                plan.setReturnAmount(MathUtils.toBigDecimal(substract));
                if (plan.getReturnAmount().compareTo(BigDecimal.ZERO) != 1) {
                    plan.setReturnState(ReturnPlanEnum.NOT_START.getState());
                } else if (plan.getReturnAmount().compareTo(plan.getReceivableAmount()) != -1) {
                    plan.setReturnState(ReturnPlanEnum.END.getState());
                } else {
                    plan.setReturnState(ReturnPlanEnum.START.getState());
                }
                String divide = MathUtils.divide(MathUtils.multiply(plan.getReturnAmount().toString(), "100"), plan.getReceivableAmount().toString(), 2);
                plan.setReturnRate(divide);
                List<RkCollectionPlanRelationEntity> byPlanId = this.collectionPlanRelationService.getByPlanId(plan.getId());
                if (CollectionUtil.isEmpty(byPlanId)) {
                    updateLastReturnDateEmptyList.add(plan);
                } else {
                    RkContractCollectionRecordEntity info = this.getInfo(byPlanId.get(0).getCollectionId());
                    plan.setLatestPaymentDate(info.getReturnDate());
                }
            });
            this.contractReturnPlanService.updateBatchById(listByIdList);
        }
        if (CollectionUtil.isNotEmpty((Collection)updateLastReturnDateEmptyList)) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractReturnPlanEntity::getLatestPaymentDate, null)).in(RkContractReturnPlanEntity::getId, (Collection)updateLastReturnDateEmptyList.stream().map(RkContractReturnPlanEntity::getId).collect(Collectors.toList()));
            this.contractReturnPlanService.update((Wrapper)updateWrapper);
        }
        RkContractEntity contractEntity = (RkContractEntity)this.contractService.getById((Serializable)((Object)byId.getContractId()));
        contractEntity.setReturnAmount(MathUtils.toBigDecimal(MathUtils.substract(contractEntity.getReturnAmount().toString(), byId.getReturnAmount().toString())));
        String divide = MathUtils.divide(MathUtils.multiply(contractEntity.getReturnAmount().toString(), "100").toString(), contractEntity.getContractAmount().toString(), 2);
        contractEntity.setReturnRatio(MathUtils.toBigDecimal(divide));
        if (contractEntity.getReturnRatio().compareTo(BigDecimal.ZERO) == 1) {
            contractEntity.setReturnState(ReturnPlanEnum.START.getState() + "");
        }
        if (contractEntity.getReturnRatio().compareTo(BigDecimal.ZERO) == 0) {
            contractEntity.setReturnState(ReturnPlanEnum.NOT_START.getState() + "");
        }
        contractEntity.setEnableMark(ContractEnableMarkEnum.ENABLE_EXECUTE.getEnableMark());
        this.contractService.updateById(contractEntity);
        if (StrUtil.isNotBlank((CharSequence)byId.getProjectId())) {
            RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.contractProjectService.getById((Serializable)((Object)byId.getProjectId()));
            projectEntity.setReceivedAmount(MathUtils.toBigDecimal(MathUtils.substract(projectEntity.getReceivedAmount().toString(), byId.getReturnAmount().toString())));
            String divide2 = MathUtils.divide(MathUtils.multiply(projectEntity.getReceivedAmount().toString(), "100").toString(), projectEntity.getProjectAmount().toString(), 2);
            projectEntity.setReceivedRatio(MathUtils.toBigDecimal(divide2));
            if (projectEntity.getReceivedRatio().compareTo(BigDecimal.ZERO) == 1) {
                projectEntity.setReceivedState(ReturnPlanEnum.START.getState());
            }
            if (projectEntity.getReceivedRatio().compareTo(BigDecimal.ZERO) == 0) {
                projectEntity.setReceivedState(ReturnPlanEnum.NOT_START.getState());
            }
            this.contractProjectService.updateById(projectEntity);
        }
        return map;
    }

    public static void main(String[] args) {
        BigDecimal d = new BigDecimal("0.00");
        int i = d.compareTo(BigDecimal.ZERO);
        System.out.println(i);
    }

    @Override
    public Map<String, Object> countAmount(CountAmountVO countAmountVO) {
        Map map1;
        Map map = MapUtil.newHashMap();
        map.put("totalReturnAmount", "0");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"IFNULL(sum(return_amount),0) as totalReturnAmount "});
        queryWrapper.lambda().eq(RkContractCollectionRecordEntity::getCompanyId, (Object)countAmountVO.getCompanyId());
        if (StrUtil.isNotEmpty((CharSequence)countAmountVO.getContractId())) {
            queryWrapper.lambda().eq(RkContractCollectionRecordEntity::getContractId, (Object)countAmountVO.getContractId());
        }
        queryWrapper.lambda().eq(RkContractCollectionRecordEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        if (CollectionUtil.isNotEmpty(countAmountVO.getSearchDate())) {
            queryWrapper.lambda().between(RkContractCollectionRecordEntity::getReturnDate, (Object)countAmountVO.getSearchDate().get(0), (Object)countAmountVO.getSearchDate().get(1));
        }
        if (!ObjectUtil.isEmpty((Object)(map1 = this.getMap((Wrapper)queryWrapper)))) {
            map = map1;
        }
        return map;
    }

    @Override
    public Map<String, Object> countAmountByContractIdList(CountAmountVO countAmountVO) {
        Map map1;
        Map map = MapUtil.newHashMap();
        map.put("totalReturnAmount", "0");
        if (CollectionUtil.isEmpty(countAmountVO.getContractIdList())) {
            return map;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"IFNULL(sum(return_amount),0) as totalReturnAmount "});
        queryWrapper.lambda().eq(RkContractCollectionRecordEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        queryWrapper.lambda().in(RkContractCollectionRecordEntity::getContractId, countAmountVO.getContractIdList());
        if (CollectionUtil.isNotEmpty(countAmountVO.getSearchDate())) {
            queryWrapper.lambda().between(RkContractCollectionRecordEntity::getReturnDate, (Object)countAmountVO.getSearchDate().get(0), (Object)countAmountVO.getSearchDate().get(1));
        }
        if (!ObjectUtil.isEmpty((Object)(map1 = this.getMap((Wrapper)queryWrapper)))) {
            map = map1;
        }
        return map;
    }

    @Override
    public Map<String, Object> importPreview(List<ContractCollectionImportVO> collectionImportVOList) {
        int i;
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        for (i = 0; i < collectionImportVOList.size(); ++i) {
            Map dataRowMap = new HashMap();
            ContractCollectionImportVO model = collectionImportVOList.get(i);
            dataRowMap = (Map)JsonUtil.getJsonToBean((Object)model, Map.class);
            dataRow.add(dataRowMap);
        }
        for (i = 1; i <= collectionImportVOList.size(); ++i) {
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("AllowDBNull", true);
            columnsMap.put("AutoIncrement", false);
            columnsMap.put("AutoIncrementSeed", 0);
            columnsMap.put("AutoIncrementStep", 1);
            columnsMap.put("Caption", this.getColumns(i));
            columnsMap.put("ColumnMapping", 1);
            columnsMap.put("ColumnName", this.getColumns(i));
            columnsMap.put("Container", null);
            columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
            columnsMap.put("DateTimeMode", 3);
            columnsMap.put("DefaultValue", null);
            columnsMap.put("DesignMode", false);
            columnsMap.put("Expression", "");
            columnsMap.put("ExtendedProperties", "");
            columnsMap.put("MaxLength", -1);
            columnsMap.put("Namespace", "");
            columnsMap.put("Ordinal", 0);
            columnsMap.put("Prefix", "");
            columnsMap.put("ReadOnly", false);
            columnsMap.put("Site", null);
            columnsMap.put("Table", collectionImportVOList);
            columnsMap.put("Unique", false);
            columns.add(columnsMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u5408\u540c\u540d\u79f0");
        map.put(2, "\u5408\u540c\u7f16\u53f7");
        map.put(3, "\u6b3e\u9879\u7c7b\u578b");
        map.put(4, "\u5230\u6b3e\u6bd4\u4f8b");
        map.put(5, "\u5230\u6b3e\u65b9\u5f0f");
        map.put(6, "\u5230\u6b3e\u91d1\u989d");
        map.put(6, "\u5230\u6b3e\u65f6\u95f4");
        return (String)map.get(key);
    }

    @Override
    public ContractCollectionImportReturnVO importData(List<ContractCollectionImportVO> dataList) {
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        List errorMsgList = CollectionUtil.list((boolean)false);
        HashMap dictMap = MapUtil.newHashMap();
        List<DictEncodeEnum> allToList = DictEncodeEnum.getAllToList();
        allToList.stream().forEach(dictEncodeEnum -> {
            String encode = dictEncodeEnum.getEncode();
            DictionaryTypeEntity typeEntityList = this.dictionaryTypeService.getInfoByEnCode(encode);
            String dictionaryTypeId = typeEntityList.getId();
            List data = this.dictionaryDataService.getList(dictionaryTypeId, Boolean.valueOf(true));
            if (StrUtil.equals((CharSequence)encode, (CharSequence)DictEncodeEnum.ENABLEMARK_DICT.getEncode())) {
                Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getEnCode));
                dictMap.put(encode, collect);
            } else {
                Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getId));
                dictMap.put(encode, collect);
            }
        });
        List errorList = CollectionUtil.list((boolean)false);
        List successList = CollectionUtil.list((boolean)false);
        List contractEntities = CollectionUtil.list((boolean)false);
        for (ContractCollectionImportVO collectionImportVO : dataList) {
            String collectionWay;
            if (StrUtil.isEmpty((CharSequence)collectionImportVO.getContractName()) && StrUtil.isEmpty((CharSequence)collectionImportVO.getContractCode())) {
                collectionImportVO.setErrMsg("\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u5fc5\u987b\u586b\u4e00\u4e2a");
                errorMsgList.add(collectionImportVO.getErrMsg());
            }
            String contractId = "";
            if (StrUtil.isNotEmpty((CharSequence)collectionImportVO.getContractCode()) && StrUtil.isNotEmpty((CharSequence)collectionImportVO.getContractName())) {
                List<RkContractEntity> listByCodeAndName = this.contractService.getListByCodeAndName(collectionImportVO.getContractCode(), collectionImportVO.getContractName());
                boolean isError = false;
                if (CollectionUtil.isEmpty(listByCodeAndName)) {
                    collectionImportVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u672a\u67e5\u8be2\u5230\u5408\u540c\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(collectionImportVO.getErrMsg());
                    isError = true;
                }
                if (listByCodeAndName.size() > 1) {
                    collectionImportVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(collectionImportVO.getErrMsg());
                    isError = true;
                }
                if (!isError) {
                    contractId = listByCodeAndName.get(0).getId();
                }
            } else {
                if (StrUtil.isNotEmpty((CharSequence)collectionImportVO.getContractCode())) {
                    List<RkContractEntity> listByCode = this.contractService.getListByCode(collectionImportVO.getContractCode(), organizeId);
                    if (CollectionUtil.isNotEmpty(listByCode) && listByCode.size() > 1) {
                        collectionImportVO.setErrMsg("\u5408\u540c\u7f16\u7801\u91cd\u590d");
                        errorMsgList.add(collectionImportVO.getErrMsg());
                    }
                    if (CollectionUtil.isNotEmpty(listByCode)) {
                        contractId = listByCode.get(0).getId();
                    }
                }
                if (StrUtil.isNotEmpty((CharSequence)collectionImportVO.getContractName())) {
                    List<RkContractEntity> listByName = this.contractService.getListByNameAndCompanyId(collectionImportVO.getContractName(), organizeId);
                    if (CollectionUtil.isNotEmpty(listByName) && listByName.size() > 1) {
                        if (StrUtil.isEmpty((CharSequence)contractId)) {
                            collectionImportVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u67e5\u8be2\u5230\u591a\u4e2a\u5408\u540c\uff0c\u8bf7\u6839\u636e\u5408\u540c\u7f16\u53f7\u4e0a\u4f20");
                            errorMsgList.add(collectionImportVO.getErrMsg());
                        } else {
                            String finalContractId = contractId;
                            List collect = listByName.stream().filter(x -> StrUtil.equals((CharSequence)x.getId(), (CharSequence)finalContractId)).collect(Collectors.toList());
                            if (CollectionUtil.isEmpty(collect)) {
                                collectionImportVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u67e5\u8be2\u5230\u7684\u5408\u540c\u4e0d\u4e00\u6837\uff0c\u8bf7\u786e\u8ba4");
                                errorMsgList.add(collectionImportVO.getErrMsg());
                            }
                        }
                    }
                    if (CollectionUtil.isNotEmpty(listByName)) {
                        String id = listByName.get(0).getId();
                        if (StrUtil.isNotEmpty((CharSequence)contractId)) {
                            if (!StrUtil.equals((CharSequence)id, (CharSequence)contractId)) {
                                collectionImportVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u67e5\u8be2\u5230\u7684\u5408\u540c\u4e0d\u4e00\u6837\uff0c\u8bf7\u786e\u8ba4");
                                errorMsgList.add(collectionImportVO.getErrMsg());
                            }
                        } else {
                            contractId = id;
                        }
                    }
                }
            }
            String projectId = "";
            if (StrUtil.isNotEmpty((CharSequence)collectionImportVO.getProjectCode())) {
                List<RkContractProjectEntity> listByProjectCode = this.contractProjectService.getListByProjectCode(collectionImportVO.getProjectCode());
                if (CollectionUtil.isEmpty(listByProjectCode)) {
                    collectionImportVO.setErrMsg("\u6839\u636e\u9879\u76ee\u7f16\u7801\u672a\u67e5\u5230\u9879\u76ee\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(collectionImportVO.getErrMsg());
                } else if (listByProjectCode.size() > 1) {
                    collectionImportVO.setErrMsg("\u6839\u636e\u9879\u76ee\u7f16\u7801\u67e5\u5230\u591a\u4e2a\u9879\u76ee\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(collectionImportVO.getErrMsg());
                } else {
                    projectId = listByProjectCode.get(0).getId();
                }
            } else if (StrUtil.isNotEmpty((CharSequence)contractId)) {
                List<RkContractProjectEntity> listByContractId = this.contractProjectService.getListByContractId(contractId);
                if (CollectionUtil.isEmpty(listByContractId)) {
                    collectionImportVO.setErrMsg("\u6839\u636e\u5408\u540c\u672a\u67e5\u5230\u9879\u76ee\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(collectionImportVO.getErrMsg());
                } else if (listByContractId.size() > 1) {
                    collectionImportVO.setErrMsg("\u6839\u636e\u5408\u540c\u67e5\u5230\u591a\u4e2a\u9879\u76ee\uff0c\u8bf7\u6839\u636e\u9879\u76ee\u7f16\u53f7\u67e5\u8be2");
                    errorMsgList.add(collectionImportVO.getErrMsg());
                } else {
                    projectId = listByContractId.get(0).getId();
                }
            }
            if (StrUtil.isEmpty((CharSequence)contractId)) {
                collectionImportVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u672a\u67e5\u8be2\u5230\u5408\u540c\uff0c\u8bf7\u786e\u8ba4");
                errorMsgList.add(collectionImportVO.getErrMsg());
            }
            if (StrUtil.isEmpty((CharSequence)collectionImportVO.getReturnAmount())) {
                collectionImportVO.setErrMsg("\u8bf7\u586b\u5199\u5230\u6b3e\u91d1\u989d");
                errorMsgList.add(collectionImportVO.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)collectionImportVO.getReturnDate())) {
                collectionImportVO.setErrMsg("\u8bf7\u586b\u5199\u5230\u6b3e\u65f6\u95f4");
                errorMsgList.add(collectionImportVO.getErrMsg());
            }
            if (StrUtil.isNotEmpty((CharSequence)collectionImportVO.getPaymentName())) {
                Map stringStringMap = (Map)dictMap.get(DictEncodeEnum.PAYMENT_TYPE_DICT.getEncode());
                String s = (String)stringStringMap.get(collectionImportVO.getPaymentName());
                if (StrUtil.isEmpty((CharSequence)s)) {
                    collectionImportVO.setErrMsg("\u6b3e\u9879\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u6570\u636e\u5b57\u5178\u7ef4\u62a4");
                    errorMsgList.add(collectionImportVO.getErrMsg());
                } else {
                    collectionImportVO.setPaymentType(s);
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)(collectionWay = collectionImportVO.getCollectionWay()))) {
                Map stringStringMap = (Map)dictMap.get(DictEncodeEnum.COLLECTION_WAY_DICT.getEncode());
                String s = (String)stringStringMap.get(collectionWay);
                if (StrUtil.isEmpty((CharSequence)s)) {
                    collectionImportVO.setErrMsg("\u5230\u6b3e\u65b9\u5f0f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u6570\u636e\u5b57\u5178\u7ef4\u62a4");
                    errorMsgList.add(collectionImportVO.getErrMsg());
                } else {
                    collectionWay = s;
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                collectionImportVO.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                collectionImportVO.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(collectionImportVO);
                continue;
            }
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)contractId));
            String divide = MathUtils.divide(MathUtils.multiply(collectionImportVO.getReturnAmount(), "100"), byId.getContractAmount().toString(), 2);
            collectionImportVO.setReturnRate(divide);
            collectionImportVO.setReturnDate(DateUtil.cstFormat((String)collectionImportVO.getReturnDate()));
            RkContractCollectionRecordEntity jsonToBean1 = (RkContractCollectionRecordEntity)JsonUtil.getJsonToBean((Object)collectionImportVO, RkContractCollectionRecordEntity.class);
            successList.add(jsonToBean1);
            RkContractCollectionRecordCrForm jsonToBean = (RkContractCollectionRecordCrForm)JsonUtil.getJsonToBean((Object)collectionImportVO, RkContractCollectionRecordCrForm.class);
            jsonToBean.setContractId(contractId);
            jsonToBean.setCompanyId(organizeId);
            jsonToBean.setCollectionWay(collectionWay);
            jsonToBean.setPlanCrFormList(CollectionUtil.list((boolean)false));
            jsonToBean.setProjectId(projectId);
            HashMap map = this.saveCollectionRecord(jsonToBean);
            if (ObjectUtil.isEmpty(map.get("error"))) continue;
            collectionImportVO.setErrMsg(map.get("error").toString());
            errorList.add(collectionImportVO);
        }
        ContractCollectionImportReturnVO vo = new ContractCollectionImportReturnVO();
        vo.setSnum(successList.size());
        vo.setFnum(errorList.size());
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, ContractCollectionImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @Override
    public Map<String, Object> sumAmountBySaleDataSummary(SaleDataSummaryVo saleDataSummaryVo) {
        Map map1;
        UserInfo userInfo = this.userProvider.get();
        Map map = MapUtil.newHashMap();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum(return_amount) as totalReturnAmount"});
        queryWrapper.lambda().eq(RkContractCollectionRecordEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        if (ObjectUtil.isNotNull((Object)saleDataSummaryVo.getStartDate())) {
            queryWrapper.lambda().ge(RkContractCollectionRecordEntity::getCreatorTime, (Object)saleDataSummaryVo.getStartDate());
        }
        if (ObjectUtil.isNotNull((Object)saleDataSummaryVo.getEndDate())) {
            queryWrapper.lambda().eq(RkContractCollectionRecordEntity::getCreatorTime, (Object)saleDataSummaryVo.getEndDate());
        }
        if (CollectionUtil.isNotEmpty(saleDataSummaryVo.getUserIdList())) {
            RkContractPagination contractPagination = new RkContractPagination();
            contractPagination.setCompanyId(userInfo.getOrganizeId());
            HashMap map12 = this.roleUtils.canSeeUserId(userInfo);
            contractPagination.setRoleSearchMap(map12);
            List<RkContractEntity> all = this.contractService.getTypeList(contractPagination, "all");
            if (CollectionUtil.isEmpty(all)) {
                return map;
            }
            List collect = all.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            queryWrapper.lambda().in(RkContractCollectionRecordEntity::getContractId, collect);
        }
        if (!ObjectUtil.isEmpty((Object)(map1 = this.getMap((Wrapper)queryWrapper)))) {
            map = map1;
        }
        return map;
    }

    @Override
    public long countByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractCollectionRecordEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark())).eq(RkContractCollectionRecordEntity::getContractId, (Object)contractId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateByChange(RkContractUpForm rkContractUpForm) {
        BigDecimal amount;
        String contractId = rkContractUpForm.getId();
        List<RkContractCollectionRecordEntity> list = this.getListByContractId(contractId);
        if (CollectionUtil.isNotEmpty(list) && (amount = ConvertUtil.toBigDecimal((Object)rkContractUpForm.getContractAmount(), (BigDecimal)BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) != 0) {
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)contractId));
            list.stream().forEach(plan -> {
                BigDecimal multiply = MathUtils.multiply(plan.getReturnAmount(), new BigDecimal(100));
                BigDecimal divide = MathUtils.divide(multiply, amount, 2);
                plan.setReturnRate(divide.toString());
            });
            this.updateBatchById(list);
        }
        return true;
    }

    @Override
    public HashMap updateDigitalRecord(RkContractCollectionRecordCrForm crForm) {
        RkContractProjectEntity projectEntity;
        HashMap map = MapUtil.newHashMap();
        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)crForm.getContractId()));
        if (ObjectUtil.isEmpty((Object)byId)) {
            map.put("error", "\u5408\u540c\u4e0d\u5b58\u5728");
            return map;
        }
        List<RkContractReturnPlanCrForm> planCrFormList = crForm.getPlanCrFormList();
        AtomicBoolean flag = new AtomicBoolean(false);
        planCrFormList.stream().forEach(plan -> {
            String add;
            if (!ObjectUtil.isEmpty((Object)plan.getCheckAmount()) && MathUtils.toBigDecimal(add = MathUtils.add(ObjectUtil.isEmpty((Object)plan.getReturnAmount()) ? "0" : plan.getReturnAmount().toString(), plan.getCheckAmount())).compareTo(MathUtils.toBigDecimal(plan.getReceivableAmount())) == 1) {
                flag.set(true);
                return;
            }
        });
        if (flag.get()) {
            map.put("error", "\u5b9e\u9645\u52fe\u5151\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5e94\u6536\u6b3e\u91d1\u989d");
            return map;
        }
        RkContractCollectionRecordEntity info = this.getInfo(crForm.getId());
        if (ObjectUtil.isEmpty((Object)info)) {
            map.put("error", "\u56de\u6b3e\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return map;
        }
        List relationEntityList = CollectionUtil.list((boolean)false);
        planCrFormList.stream().forEach(plan -> {
            if (ObjectUtil.isEmpty((Object)plan.getCheckAmount())) {
                plan.setCheckAmount("0");
            }
            BigDecimal bigDecimal = MathUtils.toBigDecimal(MathUtils.add(ObjectUtil.isEmpty((Object)plan.getReturnAmount()) ? "0" : plan.getReturnAmount().toString(), ObjectUtil.isEmpty((Object)plan.getCheckAmount()) ? "0" : plan.getCheckAmount()));
            plan.setReturnAmount(bigDecimal);
            if (!ObjectUtil.isEmpty((Object)plan.getCheckAmount())) {
                if (MathUtils.toBigDecimal(plan.getCheckAmount()).compareTo(BigDecimal.ZERO) == 1) {
                    plan.setReturnState(ReturnPlanEnum.START.getState());
                } else {
                    plan.setReturnState(ReturnPlanEnum.NOT_START.getState());
                }
                if (MathUtils.toBigDecimal(plan.getCheckAmount()).compareTo(BigDecimal.ZERO) != 0 && null != crForm.getReturnDate()) {
                    plan.setLatestPaymentDate((Date)DateUtil.date((long)crForm.getReturnDate()));
                }
            }
            if (bigDecimal.compareTo(MathUtils.toBigDecimal(plan.getReceivableAmount())) != -1) {
                plan.setReturnState(ReturnPlanEnum.END.getState());
            }
            String divide = MathUtils.divide(MathUtils.multiply(ObjectUtil.isEmpty((Object)plan.getReturnAmount()) ? "0" : plan.getReturnAmount().toString(), "100"), plan.getReceivableAmount(), 2);
            plan.setReturnRate(divide);
            RkCollectionPlanRelationEntity relationEntity = new RkCollectionPlanRelationEntity();
            relationEntity.setPlanId(plan.getId());
            relationEntity.setCollectionId(info.getId());
            relationEntity.setAmount(MathUtils.toBigDecimal(plan.getCheckAmount()));
            relationEntity.setId(RandomUtil.uuId());
            relationEntityList.add(relationEntity);
        });
        List jsonToList = JsonUtil.getJsonToList(planCrFormList, RkContractReturnPlanEntity.class);
        jsonToList.stream().forEach(plan -> plan.setAgentId(byId.getAgentId()));
        this.contractReturnPlanService.updateBatchById(jsonToList);
        BigDecimal sum = relationEntityList.stream().map(RkCollectionPlanRelationEntity::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (ObjectUtil.isNotEmpty((Object)sum)) {
            info.setMatchAmount(sum);
            this.updateById(info);
        }
        this.collectionPlanRelationService.saveBatch(relationEntityList);
        if (StrUtil.isNotBlank((CharSequence)crForm.getProjectId()) && ObjectUtil.isNotNull((Object)(projectEntity = (RkContractProjectEntity)this.contractProjectService.getById((Serializable)((Object)crForm.getProjectId()))))) {
            String add = MathUtils.add(ObjectUtil.isEmpty((Object)projectEntity.getReceivedAmount()) ? "0" : projectEntity.getReceivedAmount().toString(), crForm.getReturnAmount());
            projectEntity.setReceivedAmount(MathUtils.toBigDecimal(add));
            String divide = MathUtils.divide(MathUtils.multiply(add, "100"), projectEntity.getProjectAmount().toString(), 2);
            projectEntity.setReceivedRatio(MathUtils.toBigDecimal(divide));
            projectEntity.setReceivedState(ReturnPlanEnum.START.getState());
            if (ObjectUtil.isNull((Object)projectEntity.getReceivedAmount()) || projectEntity.getReceivedAmount().compareTo(BigDecimal.ZERO) != 1) {
                projectEntity.setReceivedState(ReturnPlanEnum.NOT_START.getState());
            }
            if (projectEntity.getReceivedRatio().compareTo(new BigDecimal("100")) != -1) {
                projectEntity.setReceivedState(ReturnPlanEnum.END.getState());
            }
            this.contractProjectService.update(projectEntity.getId(), projectEntity);
        }
        String add = MathUtils.add(ObjectUtil.isEmpty((Object)byId.getReturnAmount()) ? "0" : byId.getReturnAmount().toString(), crForm.getReturnAmount());
        byId.setReturnAmount(MathUtils.toBigDecimal(add));
        String divide = MathUtils.divide(MathUtils.multiply(add, "100"), byId.getContractAmount().toString(), 2);
        byId.setReturnRatio(MathUtils.toBigDecimal(divide));
        byId.setReturnState(ReturnPlanEnum.START.getState() + "");
        if (ObjectUtil.isNull((Object)byId.getReturnAmount()) || byId.getReturnAmount().compareTo(BigDecimal.ZERO) != 1) {
            byId.setReturnState(ReturnPlanEnum.NOT_START.getState() + "");
        }
        if (byId.getReturnRatio().compareTo(new BigDecimal("100")) != -1) {
            byId.setEnableMark(ContractEnableMarkEnum.ENABLE_COMPLETED.getEnableMark());
            byId.setReturnState(ReturnPlanEnum.END.getState() + "");
            byId.setIsChangeNow(0);
        }
        this.contractService.update(byId.getId(), byId);
        return map;
    }

    @Override
    public List<ReturnAmountDTO> getListForBonus(String contractId) {
        return this.rkContractCollectionRecordMapper.getListForBonus(contractId);
    }
}

