/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractInvoiceDetailEntity;
import com.bringspring.contract.entity.RkContractInvoiceEntity;
import com.bringspring.contract.mapper.RkContractInvoiceDetailMapper;
import com.bringspring.contract.model.countAmount.CountAmountVO;
import com.bringspring.contract.model.rkcontract.RkContractPagination;
import com.bringspring.contract.service.RkContractInvoiceDetailService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.EnableMarkEnum;
import com.bringspring.contract.utils.RoleUtils;
import com.bringspring.crm.model.datacenter.SaleDataSummaryVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractInvoiceDetailServiceImpl
extends ServiceImpl<RkContractInvoiceDetailMapper, RkContractInvoiceDetailEntity>
implements RkContractInvoiceDetailService {
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RoleUtils roleUtils;
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<RkContractInvoiceDetailEntity> getListByInvoiceNumberIn(List<String> invoiceNumberList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().in(RkContractInvoiceDetailEntity::getInvoiceNumber, invoiceNumberList)).eq(RkContractInvoiceDetailEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void deleteByInvoceId(String invoiceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(RkContractInvoiceDetailEntity::getInvoiceId, new Object[]{invoiceId});
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractInvoiceDetailEntity> getListByInvoiceId(String invoiceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractInvoiceDetailEntity::getInvoiceId, (Object)invoiceId)).eq(RkContractInvoiceDetailEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> countAmount(List<RkContractInvoiceEntity> invoiceEntityList) {
        Map map = MapUtil.newHashMap();
        map.put("totalAmount", "0");
        map.put("totalExcludingTax", "0");
        map.put("totalTax", "0");
        map.put("invoiceNum", "0");
        if (CollectionUtil.isEmpty(invoiceEntityList)) {
            return map;
        }
        List collect = invoiceEntityList.stream().map(RkContractInvoiceEntity::getId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().in(RkContractInvoiceDetailEntity::getInvoiceId, collect)).eq(RkContractInvoiceDetailEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        queryWrapper.select(new String[]{"sum(invoice_amount) as totalAmount,sum(amount_excluding_tax) as totalExcludingTax,sum(tax_amount) as totalTax,count(*) as invoiceNum"});
        Map map1 = this.getMap((Wrapper)queryWrapper);
        if (!ObjectUtil.isEmpty((Object)map1)) {
            map = map1;
        }
        return map;
    }

    @Override
    public Map<String, Object> countAmount(CountAmountVO countAmountVO) {
        Map map = MapUtil.newHashMap();
        map.put("totalInvoiceAmount", "0");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum(invoice_amount) as totalInvoiceAmount "});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractInvoiceDetailEntity::getCompanyId, (Object)countAmountVO.getCompanyId())).eq(RkContractInvoiceDetailEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark())).between(RkContractInvoiceDetailEntity::getInvoiceDate, (Object)countAmountVO.getSearchDate().get(0), (Object)countAmountVO.getSearchDate().get(1));
        Map map1 = this.getMap((Wrapper)queryWrapper);
        if (!ObjectUtil.isEmpty((Object)map1)) {
            map = map1;
        }
        return map;
    }

    @Override
    public Map<String, Object> sumAmountBySaleDataSummary(SaleDataSummaryVo saleDataSummaryVo) {
        Map map1;
        UserInfo userInfo = this.userProvider.get();
        Map map = MapUtil.newHashMap();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum(invoice_amount) as totalInvoiceAmount"});
        queryWrapper.lambda().eq(RkContractInvoiceDetailEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        if (ObjectUtil.isNotNull((Object)saleDataSummaryVo.getStartDate())) {
            queryWrapper.lambda().ge(RkContractInvoiceDetailEntity::getCreatorTime, (Object)saleDataSummaryVo.getStartDate());
        }
        if (ObjectUtil.isNotNull((Object)saleDataSummaryVo.getEndDate())) {
            queryWrapper.lambda().eq(RkContractInvoiceDetailEntity::getCreatorTime, (Object)saleDataSummaryVo.getEndDate());
        }
        if (CollectionUtil.isNotEmpty(saleDataSummaryVo.getUserIdList())) {
            RkContractPagination contractPagination = new RkContractPagination();
            contractPagination.setCompanyId(userInfo.getOrganizeId());
            HashMap map12 = this.roleUtils.canSeeUserId(userInfo);
            contractPagination.setRoleSearchMap(map12);
            List<RkContractEntity> all = this.contractService.getTypeList(contractPagination, "all");
            if (CollectionUtil.isEmpty(all)) {
                return map;
            }
            List collect = all.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            queryWrapper.lambda().in(RkContractInvoiceDetailEntity::getContractId, collect);
        }
        if (!ObjectUtil.isEmpty((Object)(map1 = this.getMap((Wrapper)queryWrapper)))) {
            map = map1;
        }
        return map;
    }

    @Override
    public boolean updateByChange(String agentId, String contractId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractInvoiceDetailEntity::getAgentId, (Object)agentId)).eq(RkContractInvoiceDetailEntity::getContractId, (Object)contractId);
        return this.update((Wrapper)updateWrapper);
    }
}

