/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractInvoiceDetailEntity;
import com.bringspring.contract.entity.RkContractInvoiceEntity;
import com.bringspring.contract.mapper.RkContractInvoiceMapper;
import com.bringspring.contract.model.countAmount.CountAmountVO;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordPagination;
import com.bringspring.contract.model.rkcontractinvoice.ContractInvoiceImportReturnVO;
import com.bringspring.contract.model.rkcontractinvoice.ContractInvoiceImportVO;
import com.bringspring.contract.model.rkcontractinvoice.RkContractInvoiceCrForm;
import com.bringspring.contract.model.rkcontractinvoice.RkContractInvoicePagination;
import com.bringspring.contract.model.rkcontractinvoice.RkContractInvoiceUpForm;
import com.bringspring.contract.model.rkcontractinvoicedetail.RkContractInvoiceDetailModel;
import com.bringspring.contract.service.RkContractInvoiceDetailService;
import com.bringspring.contract.service.RkContractInvoiceService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.DateUtils;
import com.bringspring.contract.utils.EnableMarkEnum;
import com.bringspring.contract.utils.InvoiceStateEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractInvoiceServiceImpl
extends ServiceImpl<RkContractInvoiceMapper, RkContractInvoiceEntity>
implements RkContractInvoiceService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkContractInvoiceDetailService contractInvoiceDetailService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private RkContractInvoiceDetailService rkContractInvoiceDetailService;

    @Override
    public List<RkContractInvoiceEntity> getList(RkContractInvoicePagination rkContractInvoicePagination) {
        QueryWrapper rkContractInvoiceQueryWrapper = this.appendWrapper(rkContractInvoicePagination);
        if (ObjectUtil.isEmpty(rkContractInvoiceQueryWrapper)) {
            ArrayList list = new ArrayList();
            return rkContractInvoicePagination.setData(list, list.size());
        }
        if (ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getSidx())) {
            rkContractInvoiceQueryWrapper.lambda().orderByDesc(RkContractInvoiceEntity::getId);
        } else {
            try {
                String sidx = rkContractInvoicePagination.getSidx();
                RkContractInvoiceEntity rkContractInvoiceEntity = new RkContractInvoiceEntity();
                Field declaredField = rkContractInvoiceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractInvoiceQueryWrapper = "asc".equals(rkContractInvoicePagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractInvoiceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractInvoiceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        Page page = new Page(rkContractInvoicePagination.getCurrentPage(), rkContractInvoicePagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)rkContractInvoiceQueryWrapper);
        return rkContractInvoicePagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<RkContractInvoiceEntity> appendWrapper(RkContractInvoicePagination rkContractInvoicePagination) {
        Object rkContractObj;
        QueryWrapper rkContractInvoiceQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractInvoiceQueryWrapper, rkContractInvoicePagination.getMenuId(), "rk_contract_invoice"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return null;
            }
            rkContractInvoiceQueryWrapper = (QueryWrapper)rkContractObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractInvoiceQueryWrapper, rkContractInvoicePagination.getMenuId(), "rk_contract_invoice"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return null;
            }
            rkContractInvoiceQueryWrapper = (QueryWrapper)rkContractObj;
        }
        if (ObjectUtil.isNotEmpty(rkContractInvoicePagination.getInvoiceDate())) {
            rkContractInvoiceQueryWrapper.lambda().between(RkContractInvoiceEntity::getInvoiceDate, (Object)rkContractInvoicePagination.getInvoiceDate().get(0), (Object)rkContractInvoicePagination.getInvoiceDate().get(1));
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractInvoicePagination.getState())) {
            rkContractInvoiceQueryWrapper.lambda().eq(RkContractInvoiceEntity::getState, (Object)rkContractInvoicePagination.getState());
        } else if (CollectionUtil.isNotEmpty(rkContractInvoicePagination.getStateList())) {
            rkContractInvoiceQueryWrapper.lambda().in(RkContractInvoiceEntity::getState, rkContractInvoicePagination.getStateList());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractInvoicePagination.getCompanyId())) {
            rkContractInvoiceQueryWrapper.lambda().eq(RkContractInvoiceEntity::getCompanyId, (Object)rkContractInvoicePagination.getCompanyId());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getIsReceiver())) {
            rkContractInvoiceQueryWrapper.lambda().eq(RkContractInvoiceEntity::getIsReceiver, (Object)rkContractInvoicePagination.getIsReceiver());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getContractId())) {
            rkContractInvoiceQueryWrapper.lambda().eq(RkContractInvoiceEntity::getContractId, (Object)rkContractInvoicePagination.getContractId());
        }
        rkContractInvoiceQueryWrapper.lambda().eq(RkContractInvoiceEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        if (!(ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getAgentId()) && ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getContractCode()) && ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getContractName()) && ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getCustomerId()) && ObjectUtil.isEmpty(rkContractInvoicePagination.getSearchRegion()))) {
            List<RkContractEntity> invoiceListBy = this.contractService.getInvoiceListBy(rkContractInvoicePagination);
            if (ObjectUtil.isEmpty(invoiceListBy)) {
                return null;
            }
            List collect = invoiceListBy.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            rkContractInvoiceQueryWrapper.lambda().in(RkContractInvoiceEntity::getContractId, collect);
        }
        return rkContractInvoiceQueryWrapper;
    }

    @Override
    public List<RkContractInvoiceEntity> getListNotPage(RkContractInvoicePagination rkContractInvoicePagination) {
        QueryWrapper<RkContractInvoiceEntity> queryWrapper = this.appendWrapper(rkContractInvoicePagination);
        if (ObjectUtil.isEmpty(queryWrapper)) {
            ArrayList list = new ArrayList();
            return rkContractInvoicePagination.setData(list, list.size());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractInvoiceEntity> getTypeList(RkContractInvoicePagination rkContractInvoicePagination, String dataType) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper rkContractInvoiceQueryWrapper = this.appendWrapper(rkContractInvoicePagination);
        if (ObjectUtil.isEmpty(rkContractInvoiceQueryWrapper)) {
            ArrayList list = new ArrayList();
            return rkContractInvoicePagination.setData(list, list.size());
        }
        if (AllIdList.size() > 0) {
            rkContractInvoiceQueryWrapper.lambda().in(RkContractInvoiceEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getSidx())) {
            rkContractInvoiceQueryWrapper.lambda().orderByDesc(RkContractInvoiceEntity::getId);
        } else {
            try {
                String sidx = rkContractInvoicePagination.getSidx();
                RkContractInvoiceEntity rkContractInvoiceEntity = new RkContractInvoiceEntity();
                Field declaredField = rkContractInvoiceEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractInvoiceQueryWrapper = "asc".equals(rkContractInvoicePagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractInvoiceQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractInvoiceQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractInvoicePagination.getCurrentPage(), rkContractInvoicePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractInvoiceQueryWrapper);
                return rkContractInvoicePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractInvoicePagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractInvoiceQueryWrapper);
    }

    @Override
    public RkContractInvoiceEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractInvoiceEntity::getId, (Object)id);
        return (RkContractInvoiceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkContractInvoiceEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkContractInvoiceEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkContractInvoiceEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    @DSTransactional
    public void deleteInvoice(RkContractInvoiceEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        if (entity != null) {
            entity.setEnabledMark(EnableMarkEnum.INVALID.getEnableMark());
            entity.setDeleteTime(DateUtil.getNowDate());
            entity.setDeleteUserId(userInfo.getUserId());
            this.update(entity.getId(), entity);
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractInvoiceDetailEntity::getEnabledMark, (Object)EnableMarkEnum.INVALID.getEnableMark())).set(RkContractInvoiceDetailEntity::getDeleteTime, (Object)DateUtil.getNowDate())).set(RkContractInvoiceDetailEntity::getDeleteUserId, (Object)userInfo.getUserId())).eq(RkContractInvoiceDetailEntity::getInvoiceId, (Object)entity.getId());
            this.contractInvoiceDetailService.update((Wrapper)updateWrapper);
            if (!StrUtil.equals((CharSequence)entity.getState(), (CharSequence)InvoiceStateEnum.STATE_DRAFT.getState())) {
                RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)entity.getContractId()));
                String substract = MathUtils.substract(ObjectUtil.isEmpty((Object)byId.getInvoiceAmount()) ? "0" : byId.getInvoiceAmount().toString(), entity.getInvoiceAmount() + "");
                if (MathUtils.toBigDecimal(substract).compareTo(BigDecimal.ZERO) != 1) {
                    byId.setIsInvoice(0);
                    byId.setInvoiceAmount(MathUtils.toBigDecimal("0.00"));
                    byId.setInvoiceProportion(MathUtils.toBigDecimal("0.00"));
                } else {
                    byId.setInvoiceAmount(MathUtils.toBigDecimal(substract));
                    String divide = MathUtils.divide(MathUtils.multiply(byId.getInvoiceAmount().toString(), "100"), byId.getContractAmount().toString(), 2);
                    byId.setInvoiceProportion(MathUtils.toBigDecimal(divide));
                }
                this.contractService.updateById(byId);
            }
        }
    }

    @Override
    @DSTransactional
    public HashMap saveInvoice(RkContractInvoiceCrForm rkContractInvoiceCrForm) {
        List<RkContractInvoiceEntity> list;
        HashMap map = MapUtil.newHashMap();
        if (!ObjectUtil.isEmpty((Object)rkContractInvoiceCrForm.getInvoiceNumber()) && CollectionUtil.isNotEmpty(list = this.getByInvoiceNumber(rkContractInvoiceCrForm.getInvoiceNumber()))) {
            map.put("error", "\u53d1\u7968\u53f7\u91cd\u590d");
            return map;
        }
        String salerId = "";
        String salerName = "";
        if (!ObjectUtil.isEmpty((Object)rkContractInvoiceCrForm.getInvoiceAmount()) && !ObjectUtil.isEmpty((Object)rkContractInvoiceCrForm.getContractId())) {
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractInvoiceCrForm.getContractId()));
            salerId = byId.getSalerId();
            salerName = byId.getSalerName();
            rkContractInvoiceCrForm.setCompanyId(byId.getCompanyId());
            rkContractInvoiceCrForm.setCustomerId(byId.getCustomerId());
            rkContractInvoiceCrForm.setAgentId(byId.getAgentId());
            String add = MathUtils.add(rkContractInvoiceCrForm.getInvoiceAmount(), ObjectUtil.isEmpty((Object)byId.getInvoiceAmount()) ? "0" : byId.getInvoiceAmount().toString());
            List<RkContractInvoiceEntity> invoiceList = this.getListNotDraftByContractId(rkContractInvoiceCrForm.getContractId());
            BigDecimal reduce = invoiceList.stream().map(RkContractInvoiceEntity::getInvoiceAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            String string = MathUtils.add(reduce.toString(), add);
        }
        RkContractInvoiceEntity entity = (RkContractInvoiceEntity)JsonUtil.getJsonToBean((Object)rkContractInvoiceCrForm, RkContractInvoiceEntity.class);
        entity.setId(RandomUtil.uuId());
        entity.setIsReceiver(0);
        entity.setSalerId(salerId);
        entity.setSalerName(salerName);
        this.save(entity);
        if (!ObjectUtil.isEmpty((Object)entity.getInvoiceAmount()) && !ObjectUtil.isEmpty((Object)entity.getRate())) {
            Set collect;
            List detailList = rkContractInvoiceCrForm.getRkcontractinvoicedetailList();
            if (CollectionUtil.isEmpty(detailList)) {
                detailList = CollectionUtil.list((boolean)false);
                RkContractInvoiceDetailModel detailModel = new RkContractInvoiceDetailModel();
                detailModel.setInvoiceNumber(entity.getInvoiceNumber());
                detailModel.setInvoiceAmount(entity.getInvoiceAmount());
                detailModel.setTaxAmount(entity.getTaxAmount());
                detailModel.setInvoiceDate(entity.getInvoiceDate());
                detailModel.setAmountExcludingTax(entity.getAmountExcludingTax());
                detailList.add(detailModel);
            }
            if ((collect = detailList.stream().map(RkContractInvoiceDetailModel::getInvoiceNumber).collect(Collectors.toSet())).size() < detailList.size()) {
                map.put("error", "\u53d1\u7968\u53f7\u4e0d\u80fd\u91cd\u590d");
                return map;
            }
            List<String> numList = detailList.stream().map(RkContractInvoiceDetailModel::getInvoiceNumber).collect(Collectors.toList());
            List<RkContractInvoiceDetailEntity> listByInvoiceNumberIn = this.contractInvoiceDetailService.getListByInvoiceNumberIn(numList);
            if (CollectionUtil.isNotEmpty(listByInvoiceNumberIn)) {
                map.put("error", "\u53d1\u7968\u53f7\u4e0d\u80fd\u91cd\u590d");
                return map;
            }
            List jsonToList = JsonUtil.getJsonToList((Object)detailList, RkContractInvoiceDetailEntity.class);
            jsonToList.stream().forEach(detail -> {
                detail.setId(RandomUtil.uuId());
                detail.setInvoiceId(entity.getId());
                detail.setContractId(entity.getContractId());
                detail.setCompanyId(entity.getCompanyId());
                detail.setCustomerId(entity.getCustomerId());
                detail.setAgentId(entity.getAgentId());
                detail.setInvoiceDate(entity.getInvoiceDate());
            });
            BigDecimal totalInvoceAmount = jsonToList.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(ObjectUtil.isEmpty((Object)y.getInvoiceAmount()) ? BigDecimal.ZERO : y.getInvoiceAmount()), BigDecimal::add);
            if (totalInvoceAmount.compareTo(ObjectUtil.isEmpty((Object)entity.getInvoiceAmount()) ? BigDecimal.ZERO : entity.getInvoiceAmount()) != 0) {
                map.put("error", "\u53d1\u7968\u660e\u7ec6\u7d2f\u8ba1\u603b\u91d1\u989d\u4e0e\u53d1\u7968\u91d1\u989d\u4e0d\u76f8\u7b49");
                return map;
            }
            this.contractInvoiceDetailService.saveBatch(jsonToList);
        }
        if (StrUtil.equals((CharSequence)rkContractInvoiceCrForm.getState(), (CharSequence)InvoiceStateEnum.STATE_ISSUED.getState())) {
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractInvoiceCrForm.getContractId()));
            String add = MathUtils.add(ObjectUtil.isEmpty((Object)byId.getInvoiceAmount()) ? "0" : byId.getInvoiceAmount().toString(), rkContractInvoiceCrForm.getInvoiceAmount());
            byId.setInvoiceAmount(MathUtils.toBigDecimal(add));
            byId.setIsInvoice(1);
            String divide = MathUtils.divide(MathUtils.multiply(byId.getInvoiceAmount().toString(), "100"), byId.getContractAmount().toString(), 2);
            byId.setInvoiceProportion(MathUtils.toBigDecimal(divide));
            this.contractService.updateById(byId);
        }
        return map;
    }

    @Override
    @DSTransactional
    public HashMap updateInvoice(RkContractInvoiceUpForm rkContractInvoiceUpForm) throws DataException {
        HashMap map = MapUtil.newHashMap();
        if (StrUtil.equals((CharSequence)rkContractInvoiceUpForm.getState(), (CharSequence)InvoiceStateEnum.STATE_MAILED.getState())) {
            List<RkContractInvoiceEntity> expressNumberList;
            if (!ObjectUtil.isEmpty((Object)rkContractInvoiceUpForm.getExpressNumber()) && CollectionUtil.isNotEmpty(expressNumberList = this.getByExpressNumber(rkContractInvoiceUpForm.getExpressNumber()))) {
                throw new DataException("\u5feb\u9012\u53f7\u91cd\u590d");
            }
        } else {
            List<RkContractInvoiceEntity> byInvoiceNumber;
            if (!ObjectUtil.isEmpty((Object)rkContractInvoiceUpForm.getInvoiceNumber()) && CollectionUtil.isNotEmpty(byInvoiceNumber = this.getByInvoiceNumber(rkContractInvoiceUpForm.getInvoiceNumber()))) {
                if (byInvoiceNumber.size() > 1) {
                    throw new DataException("\u53d1\u7968\u53f7\u91cd\u590d");
                }
                if (!StrUtil.equals((CharSequence)byInvoiceNumber.get(0).getId(), (CharSequence)rkContractInvoiceUpForm.getId())) {
                    throw new DataException("\u53d1\u7968\u53f7\u91cd\u590d");
                }
            }
            if (!ObjectUtil.isEmpty((Object)rkContractInvoiceUpForm.getInvoiceAmount()) && !ObjectUtil.isEmpty((Object)rkContractInvoiceUpForm.getContractId())) {
                RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractInvoiceUpForm.getContractId()));
                rkContractInvoiceUpForm.setAgentId(byId.getAgentId());
                rkContractInvoiceUpForm.setCompanyId(byId.getCompanyId());
                rkContractInvoiceUpForm.setCustomerId(byId.getCustomerId());
                String add = MathUtils.add(rkContractInvoiceUpForm.getInvoiceAmount(), ObjectUtil.isEmpty((Object)byId.getInvoiceAmount()) ? "0" : byId.getInvoiceAmount().toString());
                List<RkContractInvoiceEntity> invoiceList = this.getListNotDraftByContractId(rkContractInvoiceUpForm.getContractId());
                BigDecimal reduce = invoiceList.stream().filter(x -> !ObjectUtil.equals((Object)x.getId(), (Object)rkContractInvoiceUpForm.getId())).map(RkContractInvoiceEntity::getInvoiceAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                String string = MathUtils.add(reduce.toString(), add);
            }
        }
        RkContractInvoiceEntity oldInvoice = this.getInfo(rkContractInvoiceUpForm.getId());
        RkContractInvoiceEntity newInvoice = (RkContractInvoiceEntity)JsonUtil.getJsonToBean((Object)rkContractInvoiceUpForm, RkContractInvoiceEntity.class);
        if (!ObjectUtil.isEmpty((Object)newInvoice.getInvoiceAmount()) && !ObjectUtil.isEmpty((Object)newInvoice.getRate())) {
            Set collect;
            List<RkContractInvoiceDetailModel> detailList = rkContractInvoiceUpForm.getRkcontractinvoicedetailList();
            if (CollectionUtil.isEmpty(detailList)) {
                RkContractInvoiceDetailModel detailModel = new RkContractInvoiceDetailModel();
                detailModel.setInvoiceNumber(newInvoice.getInvoiceNumber());
                detailModel.setInvoiceAmount(newInvoice.getInvoiceAmount());
                detailModel.setInvoiceDate(newInvoice.getInvoiceDate());
                detailModel.setTaxAmount(newInvoice.getTaxAmount());
                detailModel.setAmountExcludingTax(newInvoice.getAmountExcludingTax());
                detailList.add(detailModel);
            }
            if ((collect = detailList.stream().map(RkContractInvoiceDetailModel::getInvoiceNumber).collect(Collectors.toSet())).size() < detailList.size()) {
                throw new DataException("\u53d1\u7968\u53f7\u4e0d\u80fd\u91cd\u590d");
            }
            this.contractInvoiceDetailService.deleteByInvoceId(oldInvoice.getId());
            List<String> numList = detailList.stream().map(RkContractInvoiceDetailModel::getInvoiceNumber).collect(Collectors.toList());
            List<RkContractInvoiceDetailEntity> listByInvoiceNumberIn = this.contractInvoiceDetailService.getListByInvoiceNumberIn(numList);
            if (CollectionUtil.isNotEmpty(listByInvoiceNumberIn)) {
                throw new DataException("\u53d1\u7968\u53f7\u4e0d\u80fd\u91cd\u590d");
            }
            List jsonToList = JsonUtil.getJsonToList(detailList, RkContractInvoiceDetailEntity.class);
            jsonToList.stream().forEach(detail -> {
                detail.setId(RandomUtil.uuId());
                detail.setInvoiceId(oldInvoice.getId());
                detail.setContractId(newInvoice.getContractId());
                detail.setCustomerId(newInvoice.getCustomerId());
                detail.setAgentId(newInvoice.getAgentId());
                detail.setCompanyId(newInvoice.getCompanyId());
                detail.setInvoiceDate(newInvoice.getInvoiceDate());
            });
            BigDecimal totalInvoceAmount = jsonToList.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getInvoiceAmount()), BigDecimal::add);
            if (totalInvoceAmount.compareTo(newInvoice.getInvoiceAmount()) != 0) {
                throw new DataException("\u53d1\u7968\u660e\u7ec6\u7d2f\u8ba1\u603b\u91d1\u989d\u4e0e\u53d1\u7968\u91d1\u989d\u4e0d\u76f8\u7b49");
            }
            this.update(rkContractInvoiceUpForm.getId(), newInvoice);
            this.contractInvoiceDetailService.saveBatch(jsonToList);
        } else {
            this.update(rkContractInvoiceUpForm.getId(), newInvoice);
        }
        String substract = "0";
        substract = !StrUtil.equals((CharSequence)oldInvoice.getState(), (CharSequence)InvoiceStateEnum.STATE_DRAFT.getState()) ? MathUtils.substract(rkContractInvoiceUpForm.getInvoiceAmount(), ObjectUtil.isEmpty((Object)oldInvoice.getInvoiceAmount()) ? "0" : oldInvoice.getInvoiceAmount().toString()) : rkContractInvoiceUpForm.getInvoiceAmount();
        if (StrUtil.equals((CharSequence)rkContractInvoiceUpForm.getState(), (CharSequence)InvoiceStateEnum.STATE_ISSUED.getState())) {
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractInvoiceUpForm.getContractId()));
            String add = MathUtils.add(ObjectUtil.isEmpty((Object)byId.getInvoiceAmount()) ? "0" : byId.getInvoiceAmount().toString(), substract);
            byId.setIsInvoice(1);
            byId.setInvoiceAmount(MathUtils.toBigDecimal(add));
            String divide = MathUtils.divide(MathUtils.multiply(byId.getInvoiceAmount().toString(), "100"), byId.getContractAmount().toString(), 2);
            byId.setInvoiceProportion(MathUtils.toBigDecimal(divide));
            this.contractService.updateById(byId);
        }
        return map;
    }

    @Override
    public List<RkContractInvoiceEntity> getByInvoiceNumber(String invoiceNumber) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RkContractInvoiceEntity::getInvoiceNumber, (Object)invoiceNumber)).eq(RkContractInvoiceEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractInvoiceEntity> getByExpressNumber(String expressNumber) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RkContractInvoiceEntity::getExpressNumber, (Object)expressNumber)).eq(RkContractInvoiceEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractInvoiceEntity> getListNotDraftByContractId(String contractId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkContractInvoiceEntity::getContractId, (Object)contractId);
        ((LambdaQueryWrapper)queryWrapper.ne(RkContractInvoiceEntity::getState, (Object)InvoiceStateEnum.STATE_DRAFT.getState())).eq(RkContractInvoiceEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> countAmount(CountAmountVO countAmountVO) {
        Map map1;
        Map map = MapUtil.newHashMap();
        map.put("totalInvoiceAmount", "0");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum(invoice_amount) as totalInvoiceAmount "});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractInvoiceEntity::getCompanyId, (Object)countAmountVO.getCompanyId())).ne(RkContractInvoiceEntity::getState, (Object)InvoiceStateEnum.STATE_DRAFT.getState())).eq(RkContractInvoiceEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        if (CollectionUtil.isNotEmpty(countAmountVO.getSearchDate())) {
            queryWrapper.lambda().between(RkContractInvoiceEntity::getInvoiceDate, (Object)countAmountVO.getSearchDate().get(0), (Object)countAmountVO.getSearchDate().get(1));
        }
        if (!ObjectUtil.isEmpty((Object)(map1 = this.getMap((Wrapper)queryWrapper)))) {
            map = map1;
        }
        return map;
    }

    @Override
    public Map<String, Object> countAmountByContractIdList(CountAmountVO countAmountVO) {
        Map map1;
        Map map = MapUtil.newHashMap();
        map.put("totalInvoiceAmount", "0");
        if (CollectionUtil.isEmpty(countAmountVO.getContractIdList())) {
            return map;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum(invoice_amount) as totalInvoiceAmount "});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractInvoiceEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark())).ne(RkContractInvoiceEntity::getState, (Object)InvoiceStateEnum.STATE_DRAFT.getState())).in(RkContractInvoiceEntity::getContractId, countAmountVO.getContractIdList());
        if (CollectionUtil.isNotEmpty(countAmountVO.getSearchDate())) {
            queryWrapper.lambda().between(RkContractInvoiceEntity::getInvoiceDate, (Object)countAmountVO.getSearchDate().get(0), (Object)countAmountVO.getSearchDate().get(1));
        }
        if (!ObjectUtil.isEmpty((Object)(map1 = this.getMap((Wrapper)queryWrapper)))) {
            map = map1;
        }
        return map;
    }

    @Override
    public long countByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractInvoiceEntity::getContractId, (Object)contractId)).ne(RkContractInvoiceEntity::getState, (Object)InvoiceStateEnum.STATE_DRAFT.getState())).eq(RkContractInvoiceEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> importPreview(List<ContractInvoiceImportVO> importList) {
        int i;
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        for (i = 0; i < importList.size(); ++i) {
            Map dataRowMap = new HashMap();
            ContractInvoiceImportVO ImportVO = importList.get(i);
            dataRowMap = (Map)JsonUtil.getJsonToBean((Object)ImportVO, Map.class);
            dataRow.add(dataRowMap);
        }
        for (i = 1; i <= importList.size(); ++i) {
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("AllowDBNull", true);
            columnsMap.put("AutoIncrement", false);
            columnsMap.put("AutoIncrementSeed", 0);
            columnsMap.put("AutoIncrementStep", 1);
            columnsMap.put("Caption", this.getColumns(i));
            columnsMap.put("ColumnMapping", 1);
            columnsMap.put("ColumnName", this.getColumns(i));
            columnsMap.put("Container", null);
            columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
            columnsMap.put("DateTimeMode", 3);
            columnsMap.put("DefaultValue", null);
            columnsMap.put("DesignMode", false);
            columnsMap.put("Expression", "");
            columnsMap.put("ExtendedProperties", "");
            columnsMap.put("MaxLength", -1);
            columnsMap.put("Namespace", "");
            columnsMap.put("Ordinal", 0);
            columnsMap.put("Prefix", "");
            columnsMap.put("ReadOnly", false);
            columnsMap.put("Site", null);
            columnsMap.put("Table", importList);
            columnsMap.put("Unique", false);
            columns.add(columnsMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u5408\u540c\u7f16\u53f7");
        map.put(2, "\u5f00\u7968\u4eba");
        map.put(3, "\u5f00\u7968\u65e5\u671f");
        map.put(4, "\u7a0e\u7387\uff08%\uff09");
        map.put(5, "\u53d1\u7968\u7c7b\u578b");
        map.put(6, "\u5907\u6ce8");
        map.put(7, "\u53d1\u7968\u53f7");
        map.put(8, "\u53d1\u7968\u91d1\u989d");
        return (String)map.get(key);
    }

    @Override
    public ContractInvoiceImportReturnVO importData(List<ContractInvoiceImportVO> dataList) {
        UserInfo userInfo = this.userProvider.get();
        String companyId = userInfo.getOrganizeId();
        List invoiceList = CollectionUtil.list((boolean)false);
        List invoiceDetailList = CollectionUtil.list((boolean)false);
        List errorList = CollectionUtil.list((boolean)false);
        List<RkContractEntity> contractAllList = this.contractService.getListBy(new RkContractCollectionRecordPagination());
        List dic1List = this.dictionaryDataService.getDicList("4412015332126938291");
        List dicList = this.dictionaryDataService.getDicList("4412014237665252531");
        boolean successNum = false;
        int errorNum = 0;
        List errorMsgList = CollectionUtil.list((boolean)false);
        for (ContractInvoiceImportVO ImportVO : dataList) {
            String s;
            List typeList;
            if (StringUtil.isEmpty((String)ImportVO.getContractId())) {
                ++errorNum;
                ImportVO.setErrMsg("\u8bf7\u586b\u5199\u5408\u540c\u7f16\u53f7");
                errorMsgList.add(ImportVO.getErrMsg());
            } else {
                List findContract = contractAllList.stream().filter(b -> ImportVO.getContractId().equals(b.getContractCode())).collect(Collectors.toList());
                if (findContract.isEmpty()) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u5408\u540c\u7f16\u53f7");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    RkContractEntity obj = (RkContractEntity)findContract.get(0);
                    if (ObjectUtil.isNotEmpty((Object)obj)) {
                        ImportVO.setContractId(obj.getId());
                        ImportVO.setCustomerId(obj.getCustomerId());
                        ImportVO.setAgentId(obj.getAgentId());
                    } else {
                        ++errorNum;
                        ImportVO.setErrMsg("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u5408\u540c\u7f16\u53f7");
                        errorMsgList.add(ImportVO.getErrMsg());
                    }
                }
            }
            UserEntity byRealName = this.userService.getByRealName(ImportVO.getHandledBy());
            if (ObjectUtil.isEmpty((Object)byRealName)) {
                ++errorNum;
                ImportVO.setErrMsg("\u5f00\u7968\u4eba\u672a\u5339\u914d\u5230\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            } else {
                ImportVO.setHandledBy(byRealName.getId());
            }
            String rate = "";
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getRate())) {
                rate = ImportVO.getRate();
                if (!NumberUtils.isParsable((String)rate)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u7a0e\u7387\u8bf7\u586b\u5199\u6570\u5b57\uff01");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    typeList = dicList.stream().filter(b -> b.getFullName().equals(ImportVO.getRate().concat("%"))).collect(Collectors.toList());
                    s = "";
                    if (!typeList.isEmpty()) {
                        s = ((DictionaryDataEntity)typeList.get(0)).getId();
                    }
                    if (StrUtil.isEmpty((CharSequence)s)) {
                        ++errorNum;
                        ImportVO.setErrMsg("\u7a0e\u7387\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
                        errorMsgList.add(ImportVO.getErrMsg());
                    } else {
                        ImportVO.setRate(s);
                    }
                }
            } else {
                ++errorNum;
                ImportVO.setErrMsg("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StrUtil.isNotEmpty((CharSequence)ImportVO.getInvoiceType())) {
                typeList = dic1List.stream().filter(b -> b.getFullName().equals(ImportVO.getInvoiceType())).collect(Collectors.toList());
                s = "";
                if (!typeList.isEmpty()) {
                    s = ((DictionaryDataEntity)typeList.get(0)).getId();
                }
                if (StrUtil.isEmpty((CharSequence)s)) {
                    ++errorNum;
                    ImportVO.setErrMsg("\u53d1\u7968\u7c7b\u578b\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
                    errorMsgList.add(ImportVO.getErrMsg());
                } else {
                    ImportVO.setInvoiceType(s);
                }
            } else {
                ++errorNum;
                ImportVO.setErrMsg("\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StrUtil.isEmpty((CharSequence)ImportVO.getInvoiceNumber())) {
                ++errorNum;
                ImportVO.setErrMsg("\u53d1\u7968\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            }
            if (StrUtil.isEmpty((CharSequence)ImportVO.getInvoiceAmount())) {
                ++errorNum;
                ImportVO.setErrMsg("\u53d1\u7968\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            } else if (!NumberUtils.isParsable((String)ImportVO.getInvoiceAmount())) {
                ++errorNum;
                ImportVO.setErrMsg("\u53d1\u7968\u91d1\u989d\u8bf7\u586b\u5199\u6570\u5b57\uff01");
                errorMsgList.add(ImportVO.getErrMsg());
            } else {
                BigDecimal amount = new BigDecimal(ImportVO.getInvoiceAmount());
                BigDecimal rateDecimal = new BigDecimal(rate);
                BigDecimal amountExcludingTax = amount.divide(rateDecimal.divide(new BigDecimal(100), 2, 4).add(new BigDecimal("1")), 2, 4);
                BigDecimal taxAmount = amount.subtract(amountExcludingTax);
                ImportVO.setAmountExcludingTax(amountExcludingTax.toString());
                ImportVO.setTaxAmount(taxAmount.toString());
            }
            ImportVO.setCompanyId(companyId);
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                ImportVO.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                ImportVO.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(ImportVO);
                continue;
            }
            String mainId = RandomUtil.uuId();
            String childId = RandomUtil.uuId().concat("001");
            RkContractInvoiceEntity jsonToBean = (RkContractInvoiceEntity)JsonUtil.getJsonToBean((Object)ImportVO, RkContractInvoiceEntity.class);
            jsonToBean.setId(mainId);
            invoiceList.add(jsonToBean);
            invoiceList.stream().forEach(i -> {
                i.setState("issued");
                i.setCreatorTime(DateUtils.getNowDate());
                i.setCreatorUserId(userInfo.getUserId());
                i.setEnabledMark(EnableMarkEnum.NORMAL.getEnableMark());
                i.setIsReceiver(0);
            });
            RkContractInvoiceDetailEntity jsonToBean1 = (RkContractInvoiceDetailEntity)JsonUtil.getJsonToBean((Object)ImportVO, RkContractInvoiceDetailEntity.class);
            jsonToBean1.setInvoiceId(mainId);
            jsonToBean1.setId(childId);
            invoiceDetailList.add(jsonToBean1);
            invoiceDetailList.stream().forEach(i -> {
                i.setCreatorTime(DateUtils.getNowDate());
                i.setCreatorUserId(userInfo.getUserId());
                i.setEnabledMark(EnableMarkEnum.NORMAL.getEnableMark());
            });
        }
        this.saveBatch(invoiceList);
        this.rkContractInvoiceDetailService.saveBatch(invoiceDetailList);
        ContractInvoiceImportReturnVO vo = new ContractInvoiceImportReturnVO();
        vo.setSnum(invoiceList.size());
        vo.setFnum(errorList.size());
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, ContractInvoiceImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @Override
    public DownloadVO exportExceptionData(List<Object> dataList, ContractInvoiceImportVO o) {
        Map declaredFieldsInfo2 = MapUtil.newHashMap();
        try {
            declaredFieldsInfo2 = ReflectionUtil.getDeclaredFieldsInfo2((Object)o, (Map)MapUtil.newHashMap());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        DownloadVO vo = this.exportUtil(declaredFieldsInfo2, "\u9519\u8bef\u62a5\u544a", dataList);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadVO exportUtil(Map<String, String> fileds, String explain, List<Object> modeList) {
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList(modeList, Object.class));
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        for (String s : fileds.keySet()) {
            ExcelExportEntity excelExportEntity = new ExcelExportEntity(s, (Object)fileds.get(s));
            entitys.add(excelExportEntity);
        }
        ExportParams exportParams = new ExportParams(null, "\u9519\u8bef\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        DownloadVO vo = DownloadVO.builder().build();
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, (Collection)list);
                    Iterator sheetIterator = workbook.sheetIterator();
                    while (sheetIterator.hasNext()) {
                        Iterator rowIterator = ((Sheet)sheetIterator.next()).rowIterator();
                        while (rowIterator.hasNext()) {
                            Iterator cellIterator = ((Row)rowIterator.next()).cellIterator();
                            while (cellIterator.hasNext()) {
                                Cell cell = (Cell)cellIterator.next();
                                String cellValue = cell.getStringCellValue().trim();
                                CellStyle groundStyle = workbook.createCellStyle();
                                Font font = workbook.createFont();
                                if (cell.getColumnIndex() != 0) continue;
                                groundStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                                groundStyle.setFillForegroundColor(IndexedColors.RED.getIndex());
                                cell.setCellStyle(groundStyle);
                            }
                        }
                    }
                }
                String name = explain + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(fileName);
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(this.userProvider.get().getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u7528\u6237\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return vo;
    }

    @Override
    public boolean updateByChange(String agentId, String customerId, String contractId) {
        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)contractId));
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractInvoiceEntity::getAgentId, (Object)agentId)).set(RkContractInvoiceEntity::getCustomerId, (Object)customerId)).eq(RkContractInvoiceEntity::getContractId, (Object)contractId);
        return this.update((Wrapper)updateWrapper);
    }
}

