/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkContractProcureRelationEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractTaxEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.entity.RkpurchaseapplydetaillistEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.mapper.RkContractProcureMapper;
import com.bringspring.contract.model.rkattachment.RkAttachmentUpForm;
import com.bringspring.contract.model.rkcontract.RkContractInfoVO;
import com.bringspring.contract.model.rkcontract.RkContractPaymentVO;
import com.bringspring.contract.model.rkcontractprocure.OaRecordSubitemCrCrmForm;
import com.bringspring.contract.model.rkcontractprocure.ProcureImportReturnVO;
import com.bringspring.contract.model.rkcontractprocure.ProcureImportVO;
import com.bringspring.contract.model.rkcontractprocure.RkContractProcurePagination;
import com.bringspring.contract.model.rkcontractprocure.RkContractProcureUpForm;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.service.CrmErpEnterService;
import com.bringspring.contract.service.OaFileCrmServic;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProcureRelationService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractTaxService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.service.RkpurchaseapplydetaillistService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.DictEncodeEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ProcureEncodeEnum;
import com.bringspring.contract.utils.ProjectStateEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.supplier.entity.SupplierEntity;
import com.bringspring.supplier.model.supplier.SupplierPagination;
import com.bringspring.supplier.service.SupplierService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractProcureServiceImpl
extends ServiceImpl<RkContractProcureMapper, RkContractProcureEntity>
implements RkContractProcureService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkContractPaymentService contractPaymentService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkContractProcureRelationService contractProcureRelationService;
    @Autowired
    private SupplierService supplierService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private OaFileCrmServic oaFileCrmServic;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkpurchaseapplydetaillistService rkpurchaseapplydetaillistService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProcureRelationService rkContractProcureRelationService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkContractTaxService rkContractTaxService;
    @Autowired
    private RkProcureManageService rkProcureManageService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private CrmErpEnterService crmErpEnterService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private UserService userService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<RkContractProcureEntity> getList(RkContractProcurePagination rkContractProcurePagination) {
        List collect;
        List list;
        Object rkContractProsureObj;
        QueryWrapper rkContractProcureWrapper = new QueryWrapper();
        QueryWrapper procureRelationQueryWrapper = new QueryWrapper();
        if (ObjectUtil.isEmpty((Object)rkContractProcureWrapper)) {
            ArrayList list2 = new ArrayList();
            return rkContractProcurePagination.setData(list2, list2.size());
        }
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractProsureNum = 0;
        QueryWrapper rkContractProsureQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProsureObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProsureQueryWrapper, rkContractProcurePagination.getMenuId(), "rk_contract_procure"));
            if (ObjectUtil.isEmpty((Object)rkContractProsureObj)) {
                return new ArrayList<RkContractProcureEntity>();
            }
            rkContractProsureQueryWrapper = (QueryWrapper)rkContractProsureObj;
            ++rkContractProsureNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProsureObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProsureQueryWrapper, rkContractProcurePagination.getMenuId(), "rk_contract_procure"));
            if (ObjectUtil.isEmpty((Object)rkContractProsureObj)) {
                return new ArrayList<RkContractProcureEntity>();
            }
            rkContractProsureQueryWrapper = (QueryWrapper)rkContractProsureObj;
            ++rkContractProsureNum;
        }
        rkContractProsureQueryWrapper.lambda().orderByDesc(RkContractProcureEntity::getApplyDate);
        this.appendWrapper(rkContractProcurePagination, (QueryWrapper<RkContractProcureEntity>)rkContractProcureWrapper);
        if (ObjectUtil.isEmpty((Object)rkContractProcurePagination.getProcureType())) {
            rkContractProsureQueryWrapper.lambda().eq(RkContractProcureEntity::getProcureType, (Object)"0");
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getProcureName())) {
            ++rkContractProsureNum;
            rkContractProsureQueryWrapper.lambda().like(RkContractProcureEntity::getProcureName, (Object)rkContractProcurePagination.getProcureName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getCompanyId())) {
            ++rkContractProsureNum;
            rkContractProsureQueryWrapper.lambda().eq(RkContractProcureEntity::getCompanyId, (Object)rkContractProcurePagination.getCompanyId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getProcureCode())) {
            ++rkContractProsureNum;
            rkContractProsureQueryWrapper.lambda().like(RkContractProcureEntity::getProcureCode, (Object)rkContractProcurePagination.getProcureCode());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getSupplierId())) {
            ++rkContractProsureNum;
            rkContractProsureQueryWrapper.lambda().like(RkContractProcureEntity::getSupplierId, (Object)rkContractProcurePagination.getSupplierId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getSupplierName())) {
            ++rkContractProsureNum;
            rkContractProsureQueryWrapper.lambda().like(RkContractProcureEntity::getSupplierName, (Object)rkContractProcurePagination.getSupplierName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getUserId())) {
            ++rkContractProsureNum;
            rkContractProsureQueryWrapper.lambda().eq(RkContractProcureEntity::getCreatorUserId, (Object)rkContractProcurePagination.getUserId());
        }
        if (CollectionUtil.isNotEmpty(rkContractProcurePagination.getEnableMark())) {
            ++rkContractProsureNum;
            rkContractProsureQueryWrapper.lambda().in(RkContractProcureEntity::getEnableMark, rkContractProcurePagination.getEnableMark());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getSource()) && rkContractProcurePagination.getSource().equals("cancel")) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)rkContractProsureQueryWrapper.lambda().eq(RkContractProcureEntity::getProcureStatus, (Object)"execute")).or()).eq(RkContractProcureEntity::getProcureStatus, (Object)"change")).eq(RkContractProcureEntity::getProcureType, (Object)"0")).eq(RkContractProcureEntity::getEnableMark, (Object)"complete");
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getProjectCode())) {
            List<RkContractProjectEntity> listByCode = this.rkContractProjectService.getListByCode(rkContractProcurePagination.getProjectCode());
            if (!CollectionUtil.isNotEmpty(listByCode)) return new ArrayList<RkContractProcureEntity>();
            List projectIdList = listByCode.stream().map(project -> project.getId()).collect(Collectors.toList());
            LambdaQueryWrapper in = (LambdaQueryWrapper)rkContractProcureWrapper.lambda().in(RkContractProcureEntity::getProjectId, projectIdList);
            list = this.rkContractProcureService.list((Wrapper)in);
            collect = list.stream().map(t -> t.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(collect)) return new ArrayList<RkContractProcureEntity>();
            rkContractProsureQueryWrapper.lambda().in(RkContractProcureEntity::getId, collect);
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getContractCode())) {
            List<RkContractEntity> byCode = this.rkContractService.getListByContractCodeLike(rkContractProcurePagination.getContractCode());
            if (!CollectionUtil.isNotEmpty(byCode)) return new ArrayList<RkContractProcureEntity>();
            List contractIdList = byCode.stream().map(contract -> contract.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(contractIdList)) return new ArrayList<RkContractProcureEntity>();
            LambdaQueryWrapper relationList = (LambdaQueryWrapper)procureRelationQueryWrapper.lambda().in(RkContractProcureRelationEntity::getContractId, contractIdList);
            list = this.rkContractProcureRelationService.list((Wrapper)relationList);
            collect = list.stream().map(relation -> relation.getProcureId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                rkContractProsureQueryWrapper.lambda().in(RkContractProcureEntity::getId, collect);
            }
        }
        if (AllIdList.size() > 0) {
            rkContractProsureQueryWrapper.lambda().in(RkContractProcureEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractProcurePagination.getSidx())) {
            rkContractProsureQueryWrapper.lambda().orderByDesc(RkContractProcureEntity::getId);
        } else {
            try {
                String sidx = rkContractProcurePagination.getSidx();
                RkContractProcureEntity rkContractProcureEntity = new RkContractProcureEntity();
                Field declaredField = rkContractProcureEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractProsureQueryWrapper = "asc".equals(rkContractProcurePagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractProsureQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractProsureQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkContractProcurePagination.getCurrentPage(), rkContractProcurePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkContractProsureQueryWrapper);
            return rkContractProcurePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list3 = new ArrayList();
        return rkContractProcurePagination.setData(list3, list3.size());
    }

    private QueryWrapper<RkContractProcureEntity> appendWrapper(RkContractProcurePagination rkContractProcurePagination, QueryWrapper<RkContractProcureEntity> rkContractProcureWrapper) {
        QueryWrapper rkContractProcureQueryWrapper = new QueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getCreatorUserId())) {
            rkContractProcureQueryWrapper.lambda().eq(RkContractProcureEntity::getCreatorUserId, (Object)rkContractProcurePagination.getCreatorUserId());
        }
        if (ObjectUtil.isNotEmpty(rkContractProcurePagination.getEnableMark())) {
            rkContractProcureQueryWrapper.lambda().in(RkContractProcureEntity::getEnableMark, rkContractProcurePagination.getEnableMark());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getProcureName())) {
            rkContractProcureQueryWrapper.lambda().like(RkContractProcureEntity::getProcureName, (Object)rkContractProcurePagination.getProcureName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getProcureCode())) {
            rkContractProcureQueryWrapper.lambda().like(RkContractProcureEntity::getProcureCode, (Object)rkContractProcurePagination.getProcureCode());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getSupplierName())) {
            rkContractProcureQueryWrapper.lambda().like(RkContractProcureEntity::getSupplierName, (Object)rkContractProcurePagination.getSupplierName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getInvoiceTax())) {
            rkContractProcureQueryWrapper.lambda().eq(RkContractProcureEntity::getInvoiceTax, (Object)rkContractProcurePagination.getInvoiceTax());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getInvoiceType())) {
            rkContractProcureQueryWrapper.lambda().eq(RkContractProcureEntity::getInvoiceType, (Object)rkContractProcurePagination.getInvoiceType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getStampType())) {
            rkContractProcureQueryWrapper.lambda().eq(RkContractProcureEntity::getStampType, (Object)rkContractProcurePagination.getStampType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getPaymentMethodType())) {
            rkContractProcureQueryWrapper.lambda().eq(RkContractProcureEntity::getPaymentMethodType, (Object)rkContractProcurePagination.getPaymentMethodType());
        }
        if (CollectionUtil.isNotEmpty(rkContractProcurePagination.getContractList())) {
            rkContractProcureQueryWrapper.lambda().in(RkContractProcureEntity::getContractList, rkContractProcurePagination.getContractList());
        }
        return rkContractProcureQueryWrapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<RkContractProcureEntity> getTypeList(RkContractProcurePagination rkContractProcurePagination, String dataType) {
        Object rkContractProsureObj;
        String userId = this.userProvider.get().getUserId();
        String company = this.userProvider.get().getOrganizeId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractProsureNum = 0;
        QueryWrapper rkContractProsureQueryWrapper = new QueryWrapper();
        QueryWrapper procureRelationQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProsureObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProsureQueryWrapper, rkContractProcurePagination.getMenuId(), "rk_contract_procure"));
            if (ObjectUtil.isEmpty((Object)rkContractProsureObj)) {
                return new ArrayList<RkContractProcureEntity>();
            }
            rkContractProsureQueryWrapper = (QueryWrapper)rkContractProsureObj;
            ++rkContractProsureNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProsureObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProsureQueryWrapper, rkContractProcurePagination.getMenuId(), "rk_contract_procure"));
            if (ObjectUtil.isEmpty((Object)rkContractProsureObj)) {
                return new ArrayList<RkContractProcureEntity>();
            }
            rkContractProsureQueryWrapper = (QueryWrapper)rkContractProsureObj;
            ++rkContractProsureNum;
        }
        rkContractProsureQueryWrapper.lambda().orderByDesc(RkContractProcureEntity::getApplyDate);
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getProcureName())) {
            ++rkContractProsureNum;
            rkContractProsureQueryWrapper.lambda().like(RkContractProcureEntity::getProcureName, (Object)rkContractProcurePagination.getProcureName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getProcureCode())) {
            ++rkContractProsureNum;
            rkContractProsureQueryWrapper.lambda().like(RkContractProcureEntity::getProcureCode, (Object)rkContractProcurePagination.getProcureCode());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getSupplierName())) {
            rkContractProsureQueryWrapper.lambda().eq(RkContractProcureEntity::getSupplierName, (Object)rkContractProcurePagination.getSupplierName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getSupplierBank())) {
            rkContractProsureQueryWrapper.lambda().eq(RkContractProcureEntity::getSupplierBank, (Object)rkContractProcurePagination.getSupplierBank());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getSupplierAccount())) {
            rkContractProsureQueryWrapper.lambda().eq(RkContractProcureEntity::getSupplierAccount, (Object)rkContractProcurePagination.getSupplierAccount());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getProcureAmount())) {
            rkContractProsureQueryWrapper.lambda().eq(RkContractProcureEntity::getProcureAmount, (Object)rkContractProcurePagination.getProcureAmount());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getApplyId())) {
            rkContractProsureQueryWrapper.lambda().eq(RkContractProcureEntity::getApplyId, (Object)rkContractProcurePagination.getApplyId());
        }
        if (CollectionUtil.isNotEmpty(rkContractProcurePagination.getApplyDate())) {
            rkContractProsureQueryWrapper.lambda().between(RkContractProcureEntity::getApplyDate, (Object)rkContractProcurePagination.getApplyDate().get(0), (Object)rkContractProcurePagination.getApplyDate().get(1));
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getWarranty())) {
            rkContractProsureQueryWrapper.lambda().eq(RkContractProcureEntity::getWarranty, (Object)rkContractProcurePagination.getWarranty());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getDeliveryTime())) {
            rkContractProsureQueryWrapper.lambda().eq(RkContractProcureEntity::getDeliveryTime, (Object)rkContractProcurePagination.getDeliveryTime());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getCompanyId())) {
            ++rkContractProsureNum;
            rkContractProsureQueryWrapper.lambda().eq(RkContractProcureEntity::getCompanyId, (Object)rkContractProcurePagination.getCompanyId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProcurePagination.getContractCode())) {
            QueryWrapper rkContractEntityQueryWrapper = new QueryWrapper();
            LambdaQueryWrapper rkContractEntityLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)rkContractEntityQueryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)company)).like(RkContractEntity::getContractCode, (Object)rkContractProcurePagination.getContractCode());
            List byCode = this.rkContractService.list((Wrapper)rkContractEntityLambdaQueryWrapper);
            if (!CollectionUtil.isNotEmpty((Collection)byCode)) return new ArrayList<RkContractProcureEntity>();
            List contractIdList = byCode.stream().map(contract -> contract.getId()).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(contractIdList)) return new ArrayList<RkContractProcureEntity>();
            LambdaQueryWrapper relationList = (LambdaQueryWrapper)procureRelationQueryWrapper.lambda().in(RkContractProcureRelationEntity::getContractId, contractIdList);
            List list = this.rkContractProcureRelationService.list((Wrapper)relationList);
            List collect = list.stream().map(relation -> relation.getProcureId()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                rkContractProsureQueryWrapper.lambda().in(RkContractProcureEntity::getId, collect);
            }
        }
        if (AllIdList.size() > 0) {
            rkContractProsureQueryWrapper.lambda().in(RkContractProcureEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractProcurePagination.getSidx())) {
            rkContractProsureQueryWrapper.lambda().orderByDesc(RkContractProcureEntity::getId);
        } else {
            try {
                String sidx = rkContractProcurePagination.getSidx();
                RkContractProcureEntity rkContractProcureEntity = new RkContractProcureEntity();
                Field declaredField = rkContractProcureEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractProsureQueryWrapper = "asc".equals(rkContractProcurePagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractProsureQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractProsureQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (!"0".equals(dataType)) return this.list((Wrapper)rkContractProsureQueryWrapper);
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkContractProcurePagination.getCurrentPage(), rkContractProcurePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkContractProsureQueryWrapper);
            return rkContractProcurePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkContractProcurePagination.setData(list, list.size());
    }

    @Override
    public List<RkContractProcureEntity> getByName(String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(RkContractProcureEntity::getProcureName, (Object)name);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProcureEntity> getByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(RkContractProcureEntity::getProcureCode, (Object)code);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public RkContractProcureEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProcureEntity::getId, (Object)id);
        return (RkContractProcureEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProcureEntity> getBySupplierName(String supplierName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(RkContractProcureEntity::getSupplierName, (Object)supplierName);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkContractProcureEntity entity) {
        this.save(entity);
    }

    @Override
    @DSTransactional
    public boolean update(String id, RkContractProcureEntity entity) {
        RkContractProcureUpForm rkContractProcureUpForm = (RkContractProcureUpForm)((Object)JsonUtil.getJsonToBean((Object)entity, RkContractProcureUpForm.class));
        if (CollectionUtil.isNotEmpty(rkContractProcureUpForm.getPaymentMethodList())) {
            List<RkContractPaymentVO> paymentMethodList = rkContractProcureUpForm.getPaymentMethodList();
            paymentMethodList.stream().forEach(payment -> {
                if (!ObjectUtil.isEmpty((Object)payment.getPaymentName()) && ObjectUtil.isEmpty((Object)payment.getPaymentType())) {
                    payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                }
            });
            String objectToString = JsonUtil.getObjectToString(paymentMethodList);
            entity.setPaymentJson(objectToString);
            entity.setEnableMark(entity.getEnableMark());
            List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
            List oldIdList = listByContractId.stream().map(RkContractPaymentEntity::getId).collect(Collectors.toList());
            List newIdList = paymentMethodList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getId())).map(RkContractPaymentVO::getId).collect(Collectors.toList());
            List needRemoveIdList = oldIdList.stream().filter(x -> !newIdList.contains(x)).collect(Collectors.toList());
            this.contractPaymentService.removeBatchByIds(needRemoveIdList);
            List jsonToList = JsonUtil.getJsonToList(paymentMethodList, RkContractPaymentEntity.class);
            jsonToList.stream().forEach(x -> {
                x.setContractId(id);
                if (ObjectUtil.isEmpty((Object)x.getId())) {
                    x.setId(RandomUtil.uuId());
                }
            });
            this.contractPaymentService.saveOrUpdateBatch(jsonToList);
        }
        this.attachmentService.deleteByContractId(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
        List<RkAttachmentUpForm> attachmentList = rkContractProcureUpForm.getAttachmentList();
        attachmentList.stream().forEach(attach -> {
            attach.setContractId(id);
            attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
        });
        List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
        this.attachmentService.saveBatch(attachmentEntityList);
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public boolean updateForm(String id, RkContractProcureUpForm rkContractProcureUpForm) {
        RkContractProjectListVO projectList = rkContractProcureUpForm.getProjectList();
        RkContractProjectEntity projectInfo = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)projectList.getId()));
        if (CollectionUtil.isNotEmpty(rkContractProcureUpForm.getPaymentMethodList())) {
            List<RkContractPaymentVO> paymentMethodList = rkContractProcureUpForm.getPaymentMethodList();
            paymentMethodList.stream().forEach(payment -> {
                if (!ObjectUtil.isEmpty((Object)payment.getPaymentName()) && ObjectUtil.isEmpty((Object)payment.getPaymentType())) {
                    payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                }
            });
            String objectToString = JsonUtil.getObjectToString(paymentMethodList);
            rkContractProcureUpForm.setPaymentJson(objectToString);
            rkContractProcureUpForm.setEnableMark(rkContractProcureUpForm.getEnableMark());
            List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
            List oldIdList = listByContractId.stream().map(RkContractPaymentEntity::getId).collect(Collectors.toList());
            List newIdList = paymentMethodList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getId())).map(RkContractPaymentVO::getId).collect(Collectors.toList());
            List needRemoveIdList = oldIdList.stream().filter(x -> !newIdList.contains(x)).collect(Collectors.toList());
            this.contractPaymentService.removeBatchByIds(needRemoveIdList);
            List jsonToList = JsonUtil.getJsonToList(paymentMethodList, RkContractPaymentEntity.class);
            jsonToList.stream().forEach(x -> {
                x.setContractId(id);
                if (ObjectUtil.isEmpty((Object)x.getId())) {
                    x.setId(RandomUtil.uuId());
                }
            });
            this.contractPaymentService.saveOrUpdateBatch(jsonToList);
        }
        if (CollectionUtil.isNotEmpty(rkContractProcureUpForm.getTaxList())) {
            List jsonToList = JsonUtil.getJsonToList(rkContractProcureUpForm.getTaxList(), RkContractTaxEntity.class);
            jsonToList.stream().forEach(tax -> {
                tax.setContractId(id);
                tax.setId(RandomUtil.uuId());
            });
            this.rkContractTaxService.deleteByContractId(id);
            this.rkContractTaxService.saveBatch(jsonToList);
        }
        this.attachmentService.deleteByContractId(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
        List<RkAttachmentUpForm> attachmentList = rkContractProcureUpForm.getAttachmentList();
        attachmentList.stream().forEach(attach -> {
            attach.setContractId(id);
            attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
        });
        List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
        this.attachmentService.saveBatch(attachmentEntityList);
        RkContractProcureEntity entity = (RkContractProcureEntity)JsonUtil.getJsonToBean((Object)((Object)rkContractProcureUpForm), RkContractProcureEntity.class);
        if (ObjectUtil.isEmpty((Object)entity.getProjectId())) {
            entity.setProjectId(projectList.getId());
        }
        if (ObjectUtil.isNotEmpty((Object)projectInfo) && ObjectUtil.isNotEmpty((Object)projectInfo.getProjectHeader())) {
            entity.setProjectManager(projectInfo.getProjectHeader());
            entity.setProjectManagerName(this.baseDataUtil.userSelectValue(entity.getProjectManager()));
        }
        if (ObjectUtil.isNotEmpty((Object)projectList.getSalesPerson())) {
            entity.setSalesPerson(projectList.getSalesPerson());
        }
        return this.updateById(entity);
    }

    @Override
    public Map<String, Object> importPreview(List<ProcureImportVO> fileImportList) {
        int i;
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        for (i = 0; i < fileImportList.size(); ++i) {
            Map dataRowMap = new HashMap();
            ProcureImportVO procureImportVO = fileImportList.get(i);
            dataRowMap = (Map)JsonUtil.getJsonToBean((Object)procureImportVO, Map.class);
            dataRow.add(dataRowMap);
        }
        for (i = 1; i <= fileImportList.size(); ++i) {
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("AllowDBNull", true);
            columnsMap.put("AutoIncrement", false);
            columnsMap.put("AutoIncrementSeed", 0);
            columnsMap.put("AutoIncrementStep", 1);
            columnsMap.put("Caption", this.getColumns(i));
            columnsMap.put("ColumnMapping", 1);
            columnsMap.put("ColumnName", this.getColumns(i));
            columnsMap.put("Container", null);
            columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
            columnsMap.put("DateTimeMode", 3);
            columnsMap.put("DefaultValue", null);
            columnsMap.put("DesignMode", false);
            columnsMap.put("Expression", "");
            columnsMap.put("ExtendedProperties", "");
            columnsMap.put("MaxLength", -1);
            columnsMap.put("Namespace", "");
            columnsMap.put("Ordinal", 0);
            columnsMap.put("Prefix", "");
            columnsMap.put("ReadOnly", false);
            columnsMap.put("Site", null);
            columnsMap.put("Table", fileImportList);
            columnsMap.put("Unique", false);
            columns.add(columnsMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    @Override
    public ProcureImportReturnVO importData(List<ProcureImportVO> dataList) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        String companyId = userInfo.getOrganizeId();
        HashMap dictMap = MapUtil.newHashMap();
        List<ProcureEncodeEnum> allToList = ProcureEncodeEnum.getAllToList();
        allToList.stream().forEach(procureEncodeEnum -> {
            String encode = procureEncodeEnum.getEncode();
            DictionaryTypeEntity typeEntityList = this.dictionaryTypeService.getInfoByEnCode(encode);
            String dictionaryTypeId = typeEntityList.getId();
            List data = this.dictionaryDataService.getList(dictionaryTypeId, Boolean.valueOf(true));
            if (StrUtil.equals((CharSequence)encode, (CharSequence)DictEncodeEnum.ENABLEMARK_DICT.getEncode())) {
                Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getEnCode));
                dictMap.put(encode, collect);
            } else {
                Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getId));
                dictMap.put(encode, collect);
            }
        });
        OrganizeEntity organizeEntity = this.organizeService.getInfo(userInfo.getDepartmentId());
        String[] departmentTree = organizeEntity.getOrganizeIdTree().split(",");
        List<String> o1 = Arrays.asList(departmentTree);
        String ApplyDepartmentTree = o1.toString();
        String ApplyDepartmentTreeName = this.baseDataUtil.comSelectValues(organizeEntity.getOrganizeIdTree());
        String ApplyDepartmentOne = departmentTree[departmentTree.length - 2];
        String ApplyDepartmentOneName = this.baseDataUtil.comSelectValues(ApplyDepartmentOne);
        String ApplyDepartment = departmentTree[departmentTree.length - 1];
        String ApplyDepartmentName = this.baseDataUtil.comSelectValues(ApplyDepartment);
        List supplierList = this.supplierService.list((Wrapper)new QueryWrapper());
        List procureList = CollectionUtil.list((boolean)false);
        List procureRelationList = CollectionUtil.list((boolean)false);
        List errorList = CollectionUtil.list((boolean)false);
        int sum = 0;
        int errNum = 0;
        List errorMsgList = CollectionUtil.list((boolean)false);
        for (ProcureImportVO procureImportVO : dataList) {
            String invoiceType = "";
            if (ObjectUtil.isNotEmpty((Object)procureImportVO.getInvoiceType())) {
                Map stringMap = (Map)dictMap.get(ProcureEncodeEnum.INVOICE_TYPE_ENCODE.getEncode());
                String s = (String)stringMap.get(procureImportVO.getInvoiceType());
                if (ObjectUtil.isEmpty((Object)s)) {
                    ++errNum;
                    procureImportVO.setErrMsg("\u53d1\u7968\u7c7b\u578b\u672a\u5728\u5b57\u5178\u4e2d\u7ef4\u62a4");
                    errorMsgList.add(procureImportVO.getErrMsg());
                } else {
                    invoiceType = s;
                }
            }
            String invoiceTax = "";
            if (ObjectUtil.isNotEmpty((Object)procureImportVO.getInvoiceTax())) {
                Map stringMap = (Map)dictMap.get(ProcureEncodeEnum.INVOICE_TAX_ENCODE.getEncode());
                String s = (String)stringMap.get(procureImportVO.getInvoiceTax());
                if (ObjectUtil.isEmpty((Object)s)) {
                    ++errNum;
                    procureImportVO.setErrMsg("\u53d1\u7968\u7a0e\u7387\u672a\u5728\u5b57\u5178\u4e2d\u7ef4\u62a4");
                    errorMsgList.add(procureImportVO.getErrMsg());
                } else {
                    invoiceTax = s;
                }
            }
            String paymentMethodType = "";
            if (ObjectUtil.isNotEmpty((Object)procureImportVO.getPaymentMethodType())) {
                Map stringMap = (Map)dictMap.get(ProcureEncodeEnum.PAYMENT_METHOD_TYPE.getEncode());
                String s = (String)stringMap.get(procureImportVO.getPaymentMethodType());
                if (ObjectUtil.isEmpty((Object)s)) {
                    ++errNum;
                    procureImportVO.setErrMsg("\u4ed8\u6b3e\u5f62\u5f0f\u672a\u5728\u5b57\u5178\u4e2d\u7ef4\u62a4");
                    errorMsgList.add(procureImportVO.getErrMsg());
                } else {
                    paymentMethodType = s;
                }
            } else {
                ++errNum;
                procureImportVO.setErrMsg("\u8bf7\u9009\u62e9\u4ed8\u6b3e\u5f62\u5f0f");
                errorMsgList.add(procureImportVO.getErrMsg());
            }
            String stampType = "";
            if (ObjectUtil.isNotEmpty((Object)procureImportVO.getStampType())) {
                Map stringMap = (Map)dictMap.get(ProcureEncodeEnum.STAMP_TYPE_ENCODE.getEncode());
                String s = (String)stringMap.get(procureImportVO.getStampType());
                if (ObjectUtil.isEmpty((Object)s)) {
                    ++errNum;
                    procureImportVO.setErrMsg("\u76d6\u7ae0\u7c7b\u578b\u672a\u5728\u5b57\u5178\u4e2d\u7ef4\u62a4");
                    errorMsgList.add(procureImportVO.getErrMsg());
                } else {
                    stampType = s;
                }
            } else {
                ++errNum;
                procureImportVO.setErrMsg("\u8bf7\u9009\u62e9\u76d6\u7ae0\u7c7b\u578b");
                errorMsgList.add(procureImportVO.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)procureImportVO.getProcureAmount())) {
                ++errNum;
                procureImportVO.setErrMsg("\u5408\u540c\u91d1\u989d\u672a\u586b\u5199");
                errorMsgList.add(procureImportVO.getErrMsg());
            }
            if (ObjectUtil.isNotEmpty((Object)procureImportVO.getWarranty()) && !NumberUtil.isInteger((String)procureImportVO.getWarranty())) {
                ++errNum;
                procureImportVO.setErrMsg("\u8d28\u4fdd\u671f\u9650\u5fc5\u987b\u662f\u6574\u6570");
                errorMsgList.add(procureImportVO.getErrMsg());
            }
            if (ObjectUtil.isNotEmpty((Object)procureImportVO.getDeliveryTime()) && !NumberUtil.isInteger((String)procureImportVO.getDeliveryTime())) {
                ++errNum;
                procureImportVO.setErrMsg("\u8d27\u671f\u9650\u5fc5\u987b\u662f\u6574\u6570");
                errorMsgList.add(procureImportVO.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)procureImportVO.getProcureName())) {
                ++errNum;
                procureImportVO.setErrMsg("\u91c7\u8d2d\u5408\u540c\u540d\u79f0\u672a\u586b\u5199");
                errorMsgList.add(procureImportVO.getErrMsg());
            }
            String supplierId = "";
            if (ObjectUtil.isEmpty((Object)procureImportVO.getSupplierName())) {
                ++errNum;
                procureImportVO.setErrMsg("\u4f9b\u5e94\u5546\u540d\u79f0\u672a\u586b\u5199");
                errorMsgList.add(procureImportVO.getErrMsg());
            } else {
                List matchSupplier = supplierList.stream().filter(a -> procureImportVO.getSupplierName().equals(a.getSupplierName())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(matchSupplier)) {
                    SupplierEntity supplier = (SupplierEntity)matchSupplier.get(0);
                    supplierId = supplier.getId();
                } else {
                    ++errNum;
                    procureImportVO.setErrMsg("\u4f9b\u5e94\u5546\u540d\u79f0\u672a\u5339\u914d\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(procureImportVO.getErrMsg());
                }
            }
            procureImportVO.setProcureAmount(MathUtils.toBigDecimal(procureImportVO.getProcureAmount()).toString());
            procureImportVO.setStampType(stampType);
            if (StringUtils.isEmpty((String)procureImportVO.getProcureCode())) {
                procureImportVO.setProcureCode(this.baseDataUtil.getBillNumber("procureCode", Boolean.valueOf(false)));
            }
            if (ObjectUtil.isNull((Object)procureImportVO.getApplyDate())) {
                procureImportVO.setApplyDate(new Date());
            }
            RkContractProcureEntity jsonToBean = (RkContractProcureEntity)JsonUtil.getJsonToBean((Object)procureImportVO, RkContractProcureEntity.class);
            jsonToBean.setCompanyId(userInfo.getOrganizeId());
            String mainId = RandomUtil.uuId();
            jsonToBean.setId(mainId);
            jsonToBean.setProcureStatus("execute");
            jsonToBean.setInvoiceTypeName(procureImportVO.getInvoiceType());
            jsonToBean.setInvoiceType(invoiceType);
            jsonToBean.setPaymentMethodTypeName(procureImportVO.getPaymentMethodType());
            jsonToBean.setPaymentMethodType(paymentMethodType);
            jsonToBean.setInvoiceTaxName(procureImportVO.getInvoiceTax());
            jsonToBean.setInvoiceTax(invoiceTax);
            jsonToBean.setAccumulatePaymentAmount(BigDecimal.ZERO);
            jsonToBean.setAccumulateInvoiceAmount(BigDecimal.ZERO);
            jsonToBean.setNotPaymentAmount(BigDecimal.ZERO);
            jsonToBean.setEnableMark("history");
            jsonToBean.setApplyDepartmentTree(ApplyDepartmentTree);
            jsonToBean.setApplyDepartmentTreeName(ApplyDepartmentTreeName);
            jsonToBean.setApplyDepartment(userInfo.getDepartmentId());
            jsonToBean.setApplyDepartmentName(ApplyDepartmentName);
            jsonToBean.setApplyDepartmentOne(ApplyDepartmentOne);
            jsonToBean.setApplyDepartmentOneName(ApplyDepartmentOneName);
            jsonToBean.setSupplierId(supplierId);
            jsonToBean.setProcureType("0");
            jsonToBean.setApplyName(userInfo.getRealName());
            jsonToBean.setApplyId(userInfo.getUserId());
            procureList.add(jsonToBean);
            if (StringUtils.isNotEmpty((String)procureImportVO.getContractCode())) {
                Arrays.asList(procureImportVO.getContractCode().split(";")).stream().forEach(a -> {
                    List<RkContractEntity> rkContractList = this.rkContractService.getListByCode((String)a);
                    if (CollectionUtil.isNotEmpty(rkContractList)) {
                        RkContractEntity tempContract = rkContractList.get(0);
                        RkContractProcureRelationEntity b = new RkContractProcureRelationEntity();
                        b.setContractId(tempContract.getId());
                        b.setProcureId(mainId);
                        b.setCreatorTime(new Date());
                        b.setCreatorUserId(userInfo.getUserId());
                        procureRelationList.add(b);
                    }
                });
            }
            if (!CollectionUtil.isEmpty((Collection)errorMsgList)) continue;
            procureImportVO.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
            procureImportVO.setErrMsgList(errorMsgList);
            errorMsgList = CollectionUtil.list((boolean)false);
            errorList.add(procureImportVO);
        }
        this.saveBatch(procureList);
        this.contractProcureRelationService.saveBatch(procureRelationList);
        ProcureImportReturnVO vo = new ProcureImportReturnVO();
        vo.setSnum(sum);
        vo.setFnum(errNum);
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, ProcureImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u91c7\u8d2d\u5408\u540c\u540d\u79f0");
        map.put(2, "\u4f9b\u5e94\u5546\u540d\u79f0");
        map.put(3, "\u4f9b\u5e94\u5546\u5f00\u6237\u884c");
        map.put(4, "\u4f9b\u5e94\u5546\u5361\u53f7");
        map.put(5, "\u91c7\u8d2d\u5408\u540c\u91d1\u989d");
        map.put(6, "\u53d1\u7968\u7c7b\u578b");
        map.put(7, "\u53d1\u7968\u7a0e\u7387");
        map.put(8, "\u4ed8\u6b3e\u5f62\u5f0f");
        map.put(9, "\u76d6\u7ae0\u7c7b\u578b");
        map.put(10, "\u8d28\u4fdd\u671f");
        map.put(11, "\u8d27\u671f");
        return (String)map.get(key);
    }

    @Override
    public List<RkContractInfoVO> getListById(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractInfoVO::getId, (Object)contractId);
        return null;
    }

    @Override
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        RkContractProcureUpForm rkContractProcureUpForm;
        List<RkpurchaseapplydetaillistEntity> listByHt;
        RkContractProcureEntity entity = this.getInfo(id);
        UserInfo userInfo = this.userProvider.get();
        entity.setEnableMark(String.valueOf(enableMark));
        if (enableMark == 2) {
            RkContractProjectEntity project;
            OaRecordSubitemCrCrmForm oaRecordSubitemCrForm = new OaRecordSubitemCrCrmForm();
            String procureFileRemark = "\u5173\u8054\u7c7b\u578b\uff1a\u91c7\u8d2d\u5408\u540c\uff0c";
            procureFileRemark = procureFileRemark + "\u4f9b\u5e94\u5546\u540d\u79f0\uff1a" + entity.getSupplierName();
            RkContractProjectEntity projectInfo = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()));
            RkContractEntity contractInfo = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)projectInfo.getContractId()));
            if (ObjectUtil.isNotEmpty((Object)contractInfo)) {
                contractInfo.setIndustryTypeDesc(this.baseDataUtil.getDictName(contractInfo.getIndustryType(), "industryType"));
                procureFileRemark = procureFileRemark + "\uff0c\u5408\u540c\u540d\u79f0\uff1a" + contractInfo.getContractName() + "\uff0c\u5408\u540c\u7f16\u7801" + contractInfo.getContractCode() + "\uff0c\u5408\u540c\u7c7b\u578b\uff1a" + contractInfo.getIndustryTypeDesc();
            }
            if (StringUtils.isNotEmpty((String)entity.getProcureCode())) {
                oaRecordSubitemCrForm.setProcureCode(entity.getProcureCode());
            }
            oaRecordSubitemCrForm.setRemark(procureFileRemark);
            oaRecordSubitemCrForm.setBusinessId(entity.getId());
            oaRecordSubitemCrForm.setBusinessType("purchase");
            oaRecordSubitemCrForm.setRecordSubitemName(entity.getProcureName());
            oaRecordSubitemCrForm.setSubitemType("paper");
            oaRecordSubitemCrForm.setNumber(1);
            oaRecordSubitemCrForm.setPages(1);
            oaRecordSubitemCrForm.setAccessory("[]");
            oaRecordSubitemCrForm.setCreatorUserId(entity.getCreatorUserId());
            oaRecordSubitemCrForm.setBusinessCompanyId(entity.getCompanyId());
            this.oaFileCrmServic.businessRecordSonAddCrm(oaRecordSubitemCrForm);
            entity.setEnableMark("complete");
            entity.setProcureStatus("execute");
            entity.setArchiveTime(new Date());
            RkProcureManageEntity jsonToBean = (RkProcureManageEntity)JsonUtil.getJsonToBean((Object)entity, RkProcureManageEntity.class);
            jsonToBean.setProcureStatus("execute");
            RkProcureManageEntity existData = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)entity.getId()));
            if (ObjectUtil.isNotEmpty((Object)existData)) {
                this.rkProcureManageService.updateById(jsonToBean);
            } else {
                this.rkProcureManageService.save(jsonToBean);
            }
            List<RkpurchaseapplydetaillistEntity> purchaseList = this.rkpurchaseapplydetaillistService.getListByHt(id);
            if (CollectionUtil.isNotEmpty(purchaseList)) {
                this.crmErpEnterService.save(entity, purchaseList);
            }
            if (ObjectUtil.isNotEmpty((Object)(project = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()))))) {
                project.setIsPurchase(1);
                this.rkContractProjectService.updateById(project);
            }
        } else if (enableMark == 3 && CollectionUtil.isNotEmpty(listByHt = this.rkpurchaseapplydetaillistService.getListByHt(id))) {
            listByHt.stream().forEach(purchase -> purchase.setHtId("0"));
            this.rkpurchaseapplydetaillistService.updateBatchById(listByHt);
        }
        if (enableMark == 4 && ObjectUtil.isNotEmpty((Object)((Object)(rkContractProcureUpForm = (RkContractProcureUpForm)((Object)JsonUtil.getJsonToBean((Object)model.getFormData(), RkContractProcureUpForm.class)))))) {
            entity.setFileClassification(rkContractProcureUpForm.getFileClassification());
            entity.setFileClassificationName(rkContractProcureUpForm.getFileClassificationName());
        }
        return this.updateById(entity);
    }

    @Override
    public RkContractProjectListVO getProjectInfo(String projectId) {
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)projectId));
        if (ObjectUtil.isNotEmpty((Object)byId)) {
            RkContractProjectListVO projectInfo;
            RkContractEntity contractInfo = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)byId.getContractId()));
            SaleNoContractEntity noContractEntity = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)byId.getNoContractId()));
            Map<String, ProjectStateEnum> allToMap = ProjectStateEnum.getAllToMap();
            projectInfo.setState(StringUtils.isEmpty((String)(projectInfo = (RkContractProjectListVO)JsonUtil.getJsonToBean((Object)byId, RkContractProjectListVO.class)).getState()) ? "" : allToMap.get(projectInfo.getState()).getDesc());
            projectInfo.setProjectHeaderDesc(this.baseDataUtil.userSelectValue(projectInfo.getProjectHeader()));
            if (ObjectUtil.isNotEmpty((Object)contractInfo)) {
                projectInfo.setContractName(contractInfo.getContractName());
                projectInfo.setContractType(this.baseDataUtil.getDictName(contractInfo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
                projectInfo.setTaxRate(this.baseDataUtil.getDictName(projectInfo.getTaxRate(), "projectTaxRate"));
                projectInfo.setSaler(this.baseDataUtil.userSelectValue(contractInfo.getSalerId()));
                projectInfo.setSalesPerson(contractInfo.getSalerId());
                projectInfo.setStartContractTime(contractInfo.getStartContractTime());
                projectInfo.setEndContractTime(contractInfo.getEndContractTime());
                projectInfo.setCustomerId(contractInfo.getCustomerId());
                projectInfo.setCustomerName(ObjectUtil.isEmpty((Object)contractInfo.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)contractInfo.getCustomerId()))).getName());
                if (!ObjectUtil.isEmpty((Object)contractInfo.getIsAgent()) && contractInfo.getIsAgent() == 1) {
                    projectInfo.setAgentName(((RkAgentEntity)this.rkAgentService.getById((Serializable)((Object)contractInfo.getAgentId()))).getName());
                } else {
                    projectInfo.setAgentName(projectInfo.getCustomerName());
                }
                projectInfo.setReturnAmount(ObjectUtil.isEmpty((Object)contractInfo.getReturnAmount()) ? BigDecimal.valueOf(0L) : contractInfo.getReturnAmount());
                projectInfo.setReturnRatio(ObjectUtil.isEmpty((Object)contractInfo.getReturnRatio()) ? BigDecimal.valueOf(0L) : contractInfo.getReturnRatio());
                projectInfo.setNotReturnAmount(MathUtils.substract(contractInfo.getContractAmount(), contractInfo.getReturnAmount()));
                projectInfo.setNotReturnAmountPro(BigDecimal.valueOf(100L).subtract(projectInfo.getReturnRatio()));
                projectInfo.setInvoiceAmount(ObjectUtil.isEmpty((Object)contractInfo.getInvoiceAmount()) ? BigDecimal.valueOf(0L) : contractInfo.getInvoiceAmount());
                projectInfo.setInvoiceProportion(ObjectUtil.isEmpty((Object)contractInfo.getInvoiceProportion()) ? BigDecimal.valueOf(0L) : contractInfo.getInvoiceProportion());
                projectInfo.setNotInvoiceAmount(MathUtils.substract(contractInfo.getContractAmount(), contractInfo.getInvoiceAmount()));
                projectInfo.setNotInvoiceAmountPro(BigDecimal.valueOf(100L).subtract(projectInfo.getInvoiceProportion()));
                projectInfo.setConfirmedRevenue(MathUtils.add(contractInfo.getReturnAmount(), contractInfo.getInvoiceAmount()));
                projectInfo.setConfirmedRevenuePro(MathUtils.add(contractInfo.getReturnRatio(), contractInfo.getInvoiceProportion()));
                projectInfo.setNotConfirmedRevenue(MathUtils.substract(contractInfo.getContractAmount(), contractInfo.getConfirmedRevenue()));
                projectInfo.setSaleDepartment(contractInfo.getDepartment());
            } else if (ObjectUtil.isNotEmpty((Object)noContractEntity)) {
                projectInfo.setContractName(noContractEntity.getContractName());
                projectInfo.setContractType(this.baseDataUtil.getDictName(noContractEntity.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
                projectInfo.setTaxRate(this.baseDataUtil.getDictName(projectInfo.getTaxRate(), "projectTaxRate"));
                projectInfo.setSaler(this.baseDataUtil.userSelectValue(noContractEntity.getSalerId()));
                projectInfo.setSalesPerson(noContractEntity.getSalerId());
                projectInfo.setCustomerId(noContractEntity.getCustomerId());
                projectInfo.setCustomerName(ObjectUtil.isEmpty((Object)noContractEntity.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)noContractEntity.getCustomerId()))).getName());
                if (!ObjectUtil.isEmpty((Object)noContractEntity.getIsAgent()) && StrUtil.equals((CharSequence)"1", (CharSequence)noContractEntity.getIsAgent())) {
                    projectInfo.setAgentName(((RkAgentEntity)this.rkAgentService.getById((Serializable)((Object)noContractEntity.getAgentId()))).getName());
                } else {
                    projectInfo.setAgentName(projectInfo.getCustomerName());
                }
                projectInfo.setReturnAmount(BigDecimal.valueOf(0L));
                projectInfo.setReturnRatio(BigDecimal.valueOf(0L));
                projectInfo.setNotReturnAmount(BigDecimal.valueOf(0L));
                projectInfo.setNotReturnAmountPro(BigDecimal.valueOf(0L));
                projectInfo.setInvoiceAmount(BigDecimal.valueOf(0L));
                projectInfo.setInvoiceProportion(BigDecimal.valueOf(0L));
                UserEntity saler = this.userService.getInfo(noContractEntity.getSalerId());
                projectInfo.setSaleDepartment(ObjectUtil.isNotEmpty((Object)saler) ? saler.getOrganizeId() : "");
            } else {
                projectInfo.setReturnAmount(BigDecimal.valueOf(0L));
                projectInfo.setReturnRatio(BigDecimal.valueOf(0L));
                projectInfo.setNotReturnAmount(BigDecimal.valueOf(0L));
                projectInfo.setNotReturnAmountPro(BigDecimal.valueOf(0L));
                projectInfo.setInvoiceAmount(BigDecimal.valueOf(0L));
                projectInfo.setInvoiceProportion(BigDecimal.valueOf(0L));
            }
            return projectInfo;
        }
        return null;
    }

    @Override
    public void delete(RkContractProcureEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List getProcureListBySupplier(SupplierPagination supplierPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProcureManageEntity::getSupplierId, (Object)supplierPagination.getSupplierName());
        queryWrapper.lambda().eq(RkProcureManageEntity::getEnableMark, (Object)"complete");
        if (StrUtil.isNotEmpty((CharSequence)supplierPagination.getStartDate()) && StrUtil.isNotEmpty((CharSequence)supplierPagination.getStartDate())) {
            queryWrapper.lambda().between(RkProcureManageEntity::getApplyDate, (Object)DateUtil.date((long)Long.parseLong(supplierPagination.getStartDate())), (Object)DateUtil.date((long)Long.parseLong(supplierPagination.getEndDate())));
        }
        return this.rkProcureManageService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProcureEntity> getByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProcureEntity::getProjectId, (Object)projectId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public long countByProjectId(String projectId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(RkContractProcureEntity::getProjectId, (Object)projectId);
        return this.count((Wrapper)queryWrapper);
    }
}

