/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProductEntity;
import com.bringspring.contract.mapper.RkContractProductMapper;
import com.bringspring.contract.model.rkcontractproduct.ContractProductImportReturnVO;
import com.bringspring.contract.model.rkcontractproduct.ContractProductImportVO;
import com.bringspring.contract.model.rkcontractproduct.RkContractProductPagination;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.ContractEnableMarkEnum;
import com.bringspring.contract.utils.DictEncodeEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.crm.entity.CrmProductBuyEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductRelationEntity;
import com.bringspring.crm.entity.CrmProductVersionEntity;
import com.bringspring.crm.service.CrmProductBuyService;
import com.bringspring.crm.service.CrmProductRelationService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.CrmProductVersionService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractProductServiceImpl
extends ServiceImpl<RkContractProductMapper, RkContractProductEntity>
implements RkContractProductService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductBuyService crmProductBuyService;
    @Autowired
    private CrmProductVersionService crmProductVersionService;
    @Autowired
    private CrmProductRelationService crmProductRelationService;

    @Override
    public List<RkContractProductEntity> getList(RkContractProductPagination rkContractProductPagination) {
        Object rkContractProductObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractProductNum = 0;
        QueryWrapper rkContractProductQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProductQueryWrapper, rkContractProductPagination.getMenuId(), "rkContractProduct"));
            if (ObjectUtil.isEmpty((Object)rkContractProductObj)) {
                return new ArrayList<RkContractProductEntity>();
            }
            rkContractProductQueryWrapper = (QueryWrapper)rkContractProductObj;
            ++rkContractProductNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProductQueryWrapper, rkContractProductPagination.getMenuId(), "rkContractProduct"));
            if (ObjectUtil.isEmpty((Object)rkContractProductObj)) {
                return new ArrayList<RkContractProductEntity>();
            }
            rkContractProductQueryWrapper = (QueryWrapper)rkContractProductObj;
            ++rkContractProductNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProductPagination.getContractId())) {
            ++rkContractProductNum;
            rkContractProductQueryWrapper.lambda().like(RkContractProductEntity::getContractId, (Object)rkContractProductPagination.getContractId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProductPagination.getProductId())) {
            ++rkContractProductNum;
            rkContractProductQueryWrapper.lambda().like(RkContractProductEntity::getProductId, (Object)rkContractProductPagination.getProductId());
        }
        if (AllIdList.size() > 0) {
            rkContractProductQueryWrapper.lambda().in(RkContractProductEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractProductPagination.getSidx())) {
            rkContractProductQueryWrapper.lambda().orderByDesc(RkContractProductEntity::getId);
        } else {
            try {
                String sidx = rkContractProductPagination.getSidx();
                RkContractProductEntity rkContractProductEntity = new RkContractProductEntity();
                Field declaredField = rkContractProductEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractProductQueryWrapper = "asc".equals(rkContractProductPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractProductQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractProductQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkContractProductPagination.getCurrentPage(), rkContractProductPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkContractProductQueryWrapper);
            return rkContractProductPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkContractProductPagination.setData(list, list.size());
    }

    @Override
    public List<RkContractProductEntity> getTypeList(RkContractProductPagination rkContractProductPagination, String dataType) {
        Object rkContractProductObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractProductNum = 0;
        QueryWrapper rkContractProductQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProductQueryWrapper, rkContractProductPagination.getMenuId(), "rkContractProduct"));
            if (ObjectUtil.isEmpty((Object)rkContractProductObj)) {
                return new ArrayList<RkContractProductEntity>();
            }
            rkContractProductQueryWrapper = (QueryWrapper)rkContractProductObj;
            ++rkContractProductNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProductQueryWrapper, rkContractProductPagination.getMenuId(), "rkContractProduct"));
            if (ObjectUtil.isEmpty((Object)rkContractProductObj)) {
                return new ArrayList<RkContractProductEntity>();
            }
            rkContractProductQueryWrapper = (QueryWrapper)rkContractProductObj;
            ++rkContractProductNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProductPagination.getContractId())) {
            ++rkContractProductNum;
            rkContractProductQueryWrapper.lambda().like(RkContractProductEntity::getContractId, (Object)rkContractProductPagination.getContractId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProductPagination.getProductId())) {
            ++rkContractProductNum;
            rkContractProductQueryWrapper.lambda().like(RkContractProductEntity::getProductId, (Object)rkContractProductPagination.getProductId());
        }
        if (AllIdList.size() > 0) {
            rkContractProductQueryWrapper.lambda().in(RkContractProductEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractProductPagination.getSidx())) {
            rkContractProductQueryWrapper.lambda().orderByDesc(RkContractProductEntity::getId);
        } else {
            try {
                String sidx = rkContractProductPagination.getSidx();
                RkContractProductEntity rkContractProductEntity = new RkContractProductEntity();
                Field declaredField = rkContractProductEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractProductQueryWrapper = "asc".equals(rkContractProductPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractProductQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractProductQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractProductPagination.getCurrentPage(), rkContractProductPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractProductQueryWrapper);
                return rkContractProductPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractProductPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractProductQueryWrapper);
    }

    @Override
    public RkContractProductEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProductEntity::getId, (Object)id);
        return (RkContractProductEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkContractProductEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkContractProductEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkContractProductEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void deleteByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProductEntity::getContractId, (Object)contractId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProductEntity> getListByContractId(String contractId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkContractProductEntity::getContractId, (Object)contractId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProductEntity> getListByProductId(String productId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkContractProductEntity::getProductId, (Object)productId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public ContractProductImportReturnVO importData(List<ContractProductImportVO> dataList) {
        List errorMsgList = CollectionUtil.list((boolean)false);
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        HashMap dictMap = MapUtil.newHashMap();
        List<DictEncodeEnum> allToList = DictEncodeEnum.getAllToList();
        allToList.stream().forEach(dictEncodeEnum -> {
            String encode = dictEncodeEnum.getEncode();
            DictionaryTypeEntity typeEntityList = this.dictionaryTypeService.getInfoByEnCode(encode);
            String dictionaryTypeId = typeEntityList.getId();
            List data = this.dictionaryDataService.getList(dictionaryTypeId, Boolean.valueOf(true));
            if (StrUtil.equals((CharSequence)encode, (CharSequence)DictEncodeEnum.ENABLEMARK_DICT.getEncode())) {
                Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getEnCode));
                dictMap.put(encode, collect);
            } else {
                Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getId));
                dictMap.put(encode, collect);
            }
        });
        List errorList = CollectionUtil.list((boolean)false);
        List successList = CollectionUtil.list((boolean)false);
        List contractEntities = CollectionUtil.list((boolean)false);
        for (ContractProductImportVO importVO : dataList) {
            if (StrUtil.isEmpty((CharSequence)importVO.getContractName()) && StrUtil.isEmpty((CharSequence)importVO.getContractCode())) {
                importVO.setErrMsg("\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u5fc5\u987b\u586b\u4e00\u4e2a");
                errorMsgList.add(importVO.getErrMsg());
            }
            String contractId = "";
            if (StrUtil.isNotEmpty((CharSequence)importVO.getContractCode()) && StrUtil.isNotEmpty((CharSequence)importVO.getContractName())) {
                List<RkContractEntity> listByCodeAndName = this.contractService.getListByCodeAndName(importVO.getContractCode(), importVO.getContractName());
                boolean isError = false;
                if (CollectionUtil.isEmpty(listByCodeAndName)) {
                    importVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u672a\u67e5\u8be2\u5230\u5408\u540c\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(importVO.getErrMsg());
                    isError = true;
                }
                if (listByCodeAndName.size() > 1) {
                    importVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e\uff0c\u8bf7\u786e\u8ba4");
                    errorMsgList.add(importVO.getErrMsg());
                    isError = true;
                }
                if (!isError) {
                    contractId = listByCodeAndName.get(0).getId();
                }
            } else {
                if (StrUtil.isNotEmpty((CharSequence)importVO.getContractCode())) {
                    List<RkContractEntity> listByCode = this.contractService.getListByCode(importVO.getContractCode(), organizeId);
                    if (CollectionUtil.isNotEmpty(listByCode) && listByCode.size() > 1) {
                        importVO.setErrMsg("\u5408\u540c\u7f16\u7801\u91cd\u590d");
                        errorMsgList.add(importVO.getErrMsg());
                    }
                    if (CollectionUtil.isNotEmpty(listByCode)) {
                        contractId = listByCode.get(0).getId();
                    }
                }
                if (StrUtil.isNotEmpty((CharSequence)importVO.getContractName())) {
                    List<RkContractEntity> listByName = this.contractService.getListByNameAndCompanyId(importVO.getContractName(), organizeId);
                    if (CollectionUtil.isNotEmpty(listByName) && listByName.size() > 1) {
                        if (StrUtil.isEmpty((CharSequence)contractId)) {
                            importVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u67e5\u8be2\u5230\u591a\u4e2a\u5408\u540c\uff0c\u8bf7\u6839\u636e\u5408\u540c\u7f16\u53f7\u4e0a\u4f20");
                            errorMsgList.add(importVO.getErrMsg());
                        } else {
                            String finalContractId = contractId;
                            List collect = listByName.stream().filter(x -> StrUtil.equals((CharSequence)x.getId(), (CharSequence)finalContractId)).collect(Collectors.toList());
                            if (CollectionUtil.isEmpty(collect)) {
                                importVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u67e5\u8be2\u5230\u7684\u5408\u540c\u4e0d\u4e00\u6837\uff0c\u8bf7\u786e\u8ba4");
                                errorMsgList.add(importVO.getErrMsg());
                            }
                        }
                    }
                    if (CollectionUtil.isNotEmpty(listByName)) {
                        String id = listByName.get(0).getId();
                        if (StrUtil.isNotEmpty((CharSequence)contractId)) {
                            if (!StrUtil.equals((CharSequence)id, (CharSequence)contractId)) {
                                importVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u67e5\u8be2\u5230\u7684\u5408\u540c\u4e0d\u4e00\u6837\uff0c\u8bf7\u786e\u8ba4");
                                errorMsgList.add(importVO.getErrMsg());
                            }
                        } else {
                            contractId = id;
                        }
                    }
                }
            }
            if (StrUtil.isEmpty((CharSequence)contractId)) {
                importVO.setErrMsg("\u6839\u636e\u5408\u540c\u540d\u79f0\u4e0e\u5408\u540c\u7f16\u7801\u672a\u67e5\u8be2\u5230\u5408\u540c\uff0c\u8bf7\u786e\u8ba4");
                errorMsgList.add(importVO.getErrMsg());
            }
            if (StrUtil.isEmpty((CharSequence)importVO.getProductName())) {
                importVO.setErrMsg("\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(importVO.getErrMsg());
            }
            if (!NumberUtil.isNumber((CharSequence)importVO.getNum())) {
                importVO.setErrMsg("\u6570\u91cf\u5fc5\u987b\u662f\u6b63\u6570");
                errorMsgList.add(importVO.getErrMsg());
            }
            RkContractProductEntity jsonToBean = (RkContractProductEntity)JsonUtil.getJsonToBean((Object)importVO, RkContractProductEntity.class);
            jsonToBean.setContractId(contractId);
            List<CrmProductEntity> listByNameAndCompanyId = this.crmProductService.getListByNameAndCompanyId(importVO.getProductName(), organizeId);
            CrmProductEntity productEntity = null;
            int i = 0;
            if (CollectionUtil.isNotEmpty(listByNameAndCompanyId) && listByNameAndCompanyId.size() == 1) {
                productEntity = listByNameAndCompanyId.get(0);
                ++i;
            }
            List<CrmProductBuyEntity> byNameAndCompanyId = this.crmProductBuyService.getByNameAndCompanyId(importVO.getProductName(), organizeId);
            CrmProductBuyEntity productBuyEntity = null;
            if (CollectionUtil.isNotEmpty(byNameAndCompanyId) && byNameAndCompanyId.size() == 1) {
                productBuyEntity = byNameAndCompanyId.get(0);
                ++i;
            }
            if (i == 1) {
                List<CrmProductVersionEntity> listByProductId;
                List collect;
                if (ObjectUtil.isNotNull((Object)productEntity)) {
                    jsonToBean.setProductId(productEntity.getId());
                    jsonToBean.setProductCode(productEntity.getProductCode());
                }
                if (ObjectUtil.isNotNull(productBuyEntity)) {
                    jsonToBean.setProductId(productBuyEntity.getId());
                    jsonToBean.setProductCode(productBuyEntity.getProductCode());
                }
                if (StrUtil.isNotEmpty((CharSequence)importVO.getProductVersionName()) && CollectionUtil.isNotEmpty(collect = (listByProductId = this.crmProductVersionService.getListByProductId(jsonToBean.getProductId())).stream().filter(x -> StrUtil.equals((CharSequence)x.getProductVersion(), (CharSequence)importVO.getProductVersionName())).collect(Collectors.toList()))) {
                    jsonToBean.setProductVersion(((CrmProductVersionEntity)collect.get(0)).getId());
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                importVO.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                importVO.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(importVO);
                continue;
            }
            jsonToBean.setId(RandomUtil.uuId());
            HashMap map = this.saveProduct(jsonToBean);
            if (ObjectUtil.isNotNull(map.get("error"))) {
                importVO.setErrMsg(map.get("error").toString());
                errorMsgList.add(importVO.getErrMsg());
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                importVO.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                importVO.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(importVO);
                continue;
            }
            successList.add(jsonToBean);
        }
        ContractProductImportReturnVO vo = new ContractProductImportReturnVO();
        vo.setSnum(successList.size());
        vo.setFnum(errorList.size());
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, ContractProductImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @DSTransactional
    public HashMap saveProduct(RkContractProductEntity entity) {
        BigDecimal add;
        HashMap<String, String> map = new HashMap<String, String>();
        List<RkContractProductEntity> listByContractId = this.getListByContractId(entity.getContractId());
        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)entity.getContractId()));
        if (ObjectUtil.isEmpty((Object)byId.getContractAmount())) {
            map.put("error", "\u5408\u540c\u672a\u5f55\u5165\u5408\u540c\u989d");
            return map;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        if (CollectionUtil.isNotEmpty(listByContractId)) {
            bigDecimal = listByContractId.stream().filter(x -> ObjectUtil.isNotEmpty((Object)x.getProductAmount())).map(RkContractProductEntity::getProductAmount).reduce(BigDecimal::add).get();
        }
        if ((add = MathUtils.add(entity.getProductAmount(), bigDecimal)).compareTo(byId.getContractAmount()) == 1) {
            map.put("error", "\u7d2f\u8ba1\u4ea7\u54c1\u91d1\u989d\u8d85\u8fc7\u5408\u540c\u989d");
            return map;
        }
        BigDecimal divide = MathUtils.divide(MathUtils.multiply(entity.getProductAmount(), new BigDecimal(100)), byId.getContractAmount(), 2);
        entity.setAllocationRatio(divide);
        this.save(entity);
        listByContractId.add(entity);
        this.synCustomerProductRelation(entity);
        return map;
    }

    public void synCustomerProductRelation(RkContractProductEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)entity.getContractId()));
        if (StrUtil.equals((CharSequence)byId.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark())) {
            return;
        }
        CrmProductBuyEntity productBuyEntity = (CrmProductBuyEntity)this.crmProductBuyService.getById((Serializable)((Object)entity.getProductId()));
        if (ObjectUtil.isNotNull((Object)productBuyEntity)) {
            return;
        }
        CrmProductRelationEntity infoByProductId = this.crmProductRelationService.getInfoByProductId(entity.getProductId(), byId.getCustomerId());
        if (ObjectUtil.isEmpty((Object)infoByProductId)) {
            infoByProductId = new CrmProductRelationEntity();
            infoByProductId.setId(RandomUtil.uuId());
            infoByProductId.setCreatorUserId(userInfo.getUserId());
            infoByProductId.setCreatorTime(DateUtil.getNowDate());
            infoByProductId.setSalesmanId(byId.getSalerId());
            infoByProductId.setContractId(byId.getId());
            infoByProductId.setCustomerId(byId.getCustomerId());
            infoByProductId.setProductId(entity.getProductId());
            infoByProductId.setCompanyId(byId.getCompanyId());
            infoByProductId.setIsStop(0);
            infoByProductId.setIsInspect(0);
            infoByProductId.setNotInspectReason("\u901a\u8fc7\u5408\u540c\u5bfc\u5165\uff0c\u9ed8\u8ba4\u4e0d\u5de1\u68c0");
            infoByProductId.setProductVersion(entity.getProductVersionName());
            this.crmProductRelationService.save(infoByProductId);
        }
    }
}

