/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractProjectCostEntity;
import com.bringspring.contract.mapper.RkContractProjectCostMapper;
import com.bringspring.contract.model.rkContractCost.RkContractProjectCostPagination;
import com.bringspring.contract.service.RkContractProjectCostService;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractProjectCostServiceImpl
extends ServiceImpl<RkContractProjectCostMapper, RkContractProjectCostEntity>
implements RkContractProjectCostService {
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<RkContractProjectCostEntity> getList(RkContractProjectCostPagination rkContractProjectCostPagination) {
        Object rkContractObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean rkContractProjectCostNum = false;
        boolean pcPermission = true;
        boolean appPermission = true;
        if (ObjectUtil.equals((Object)rkContractProjectCostPagination.getIsAuth(), (Object)0)) {
            pcPermission = false;
            appPermission = false;
        }
        QueryWrapper rkContractProjectCostQueryWrapper = new QueryWrapper();
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProjectCostQueryWrapper, rkContractProjectCostPagination.getMenuId(), "rk_contract_project_cost"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                rkContractProjectCostQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(RkContractProjectCostEntity::getCreatorUserId, (Object)userId)).or()).eq(RkContractProjectCostEntity::getProjectHeader, (Object)userId)).or()).like(RkContractProjectCostEntity::getRegionalHead, (Object)userId)).or()).like(RkContractProjectCostEntity::getAffirmUserId, (Object)userId));
            } else {
                rkContractProjectCostQueryWrapper = (QueryWrapper)rkContractObj;
            }
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProjectCostQueryWrapper, rkContractProjectCostPagination.getMenuId(), "rk_contract_project_cost"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                rkContractProjectCostQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(RkContractProjectCostEntity::getCreatorUserId, (Object)userId)).or()).eq(RkContractProjectCostEntity::getProjectHeader, (Object)userId)).or()).like(RkContractProjectCostEntity::getRegionalHead, (Object)userId)).or()).like(RkContractProjectCostEntity::getAffirmUserId, (Object)userId));
            } else {
                rkContractProjectCostQueryWrapper = (QueryWrapper)rkContractObj;
            }
        }
        if (StringUtil.isNotEmpty((String)rkContractProjectCostPagination.getCompanyId())) {
            rkContractProjectCostQueryWrapper.lambda().eq(RkContractProjectCostEntity::getCompanyId, (Object)rkContractProjectCostPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)rkContractProjectCostPagination.getRkContractProjectId())) {
            rkContractProjectCostQueryWrapper.lambda().eq(RkContractProjectCostEntity::getProjectId, (Object)rkContractProjectCostPagination.getRkContractProjectId());
        }
        if (StringUtils.isNotEmpty((String)rkContractProjectCostPagination.getKeyword())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)rkContractProjectCostQueryWrapper.lambda().like(RkContractProjectCostEntity::getCustomerName, (Object)rkContractProjectCostPagination.getKeyword())).or()).like(RkContractProjectCostEntity::getProjectName, (Object)rkContractProjectCostPagination.getKeyword());
        }
        if (StringUtils.isNotEmpty((String)rkContractProjectCostPagination.getCostType())) {
            rkContractProjectCostQueryWrapper.lambda().eq(RkContractProjectCostEntity::getCostType, (Object)rkContractProjectCostPagination.getCostType());
        }
        if (StringUtils.isNotEmpty((String)rkContractProjectCostPagination.getState())) {
            rkContractProjectCostQueryWrapper.lambda().eq(RkContractProjectCostEntity::getState, (Object)rkContractProjectCostPagination.getState());
        }
        if (StringUtils.isNotEmpty((String)rkContractProjectCostPagination.getExecutorUser())) {
            rkContractProjectCostQueryWrapper.lambda().eq(RkContractProjectCostEntity::getCreatorUserId, (Object)rkContractProjectCostPagination.getExecutorUser());
        }
        if (AllIdList.size() > 0) {
            rkContractProjectCostQueryWrapper.lambda().in(RkContractProjectCostEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkContractProjectCostPagination.getSidx())) {
            rkContractProjectCostQueryWrapper.lambda().orderByDesc(RkContractProjectCostEntity::getId);
        } else {
            try {
                String sidx = rkContractProjectCostPagination.getSidx();
                RkContractProjectCostEntity rkContractProjectCostEntity = new RkContractProjectCostEntity();
                Field declaredField = rkContractProjectCostEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractProjectCostQueryWrapper = "asc".equals(rkContractProjectCostPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractProjectCostQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractProjectCostQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkContractProjectCostPagination.getCurrentPage(), rkContractProjectCostPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkContractProjectCostQueryWrapper);
            return rkContractProjectCostPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkContractProjectCostPagination.setData(list, list.size());
    }

    @Override
    public List<RkContractProjectCostEntity> getTypeList(RkContractProjectCostPagination rkContractProjectCostPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        boolean rkContractProjectCostNum = false;
        QueryWrapper rkContractProjectCostQueryWrapper = new QueryWrapper();
        if (AllIdList.size() > 0) {
            rkContractProjectCostQueryWrapper.lambda().in(RkContractProjectCostEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkContractProjectCostPagination.getSidx())) {
            rkContractProjectCostQueryWrapper.lambda().orderByDesc(RkContractProjectCostEntity::getId);
        } else {
            try {
                String sidx = rkContractProjectCostPagination.getSidx();
                RkContractProjectCostEntity rkContractProjectCostEntity = new RkContractProjectCostEntity();
                Field declaredField = rkContractProjectCostEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractProjectCostQueryWrapper = "asc".equals(rkContractProjectCostPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractProjectCostQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractProjectCostQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractProjectCostPagination.getCurrentPage(), rkContractProjectCostPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractProjectCostQueryWrapper);
                return rkContractProjectCostPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractProjectCostPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractProjectCostQueryWrapper);
    }

    @Override
    public RkContractProjectCostEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProjectCostEntity::getId, (Object)id);
        return (RkContractProjectCostEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkContractProjectCostEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkContractProjectCostEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkContractProjectCostEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public long countByProjectId(String projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkContractProjectCostEntity::getProjectId, (Object)projectId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public BigDecimal totalityCostByProject(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProjectCostEntity::getProjectId, (Object)id);
        queryWrapper.lambda().eq(RkContractProjectCostEntity::getState, (Object)"1");
        List rkContractProjectCostEntities = this.list((Wrapper)queryWrapper);
        BigDecimal sum = rkContractProjectCostEntities.stream().map(RkContractProjectCostEntity::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum;
    }
}

