/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractProjectHelpEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkReturnPlanFollowEntity;
import com.bringspring.contract.mapper.RkContractProjectHelpMapper;
import com.bringspring.contract.model.rkcontractprojecthelp.RkContractProjectHelpCrForm;
import com.bringspring.contract.model.rkcontractprojecthelp.RkContractProjectHelpPagination;
import com.bringspring.contract.model.rkcontractprojecthelp.RkContractProjectHelpUpForm;
import com.bringspring.contract.service.RkContractProjectHelpService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkReturnPlanFollowService;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractProjectHelpServiceImpl
extends ServiceImpl<RkContractProjectHelpMapper, RkContractProjectHelpEntity>
implements RkContractProjectHelpService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;
    @Autowired
    private RkReturnPlanFollowService rkReturnPlanFollowService;

    @Override
    public List<RkContractProjectHelpEntity> getList(RkContractProjectHelpPagination rkContractProjectHelpPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractProjectHelpNum = 0;
        QueryWrapper rkContractProjectHelpQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)rkContractProjectHelpPagination.getIsCompleteHelp())) {
            ++rkContractProjectHelpNum;
            rkContractProjectHelpQueryWrapper.lambda().eq(RkContractProjectHelpEntity::getIsCompleteHelp, (Object)rkContractProjectHelpPagination.getIsCompleteHelp());
        }
        if (StringUtils.isNotEmpty((String)rkContractProjectHelpPagination.getCompleteDescribe())) {
            ++rkContractProjectHelpNum;
            rkContractProjectHelpQueryWrapper.lambda().like(RkContractProjectHelpEntity::getCompleteDescribe, (Object)rkContractProjectHelpPagination.getCompleteDescribe());
        }
        if (AllIdList.size() > 0) {
            rkContractProjectHelpQueryWrapper.lambda().in(RkContractProjectHelpEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)rkContractProjectHelpPagination.getSidx())) {
            rkContractProjectHelpQueryWrapper.lambda().orderByDesc(RkContractProjectHelpEntity::getId);
        } else {
            try {
                String sidx = rkContractProjectHelpPagination.getSidx();
                RkContractProjectHelpEntity rkContractProjectHelpEntity = new RkContractProjectHelpEntity();
                Field declaredField = rkContractProjectHelpEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractProjectHelpQueryWrapper = "asc".equals(rkContractProjectHelpPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractProjectHelpQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractProjectHelpQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkContractProjectHelpPagination.getCurrentPage(), rkContractProjectHelpPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkContractProjectHelpQueryWrapper);
            return rkContractProjectHelpPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkContractProjectHelpPagination.setData(list, list.size());
    }

    @Override
    public List<RkContractProjectHelpEntity> getTypeList(RkContractProjectHelpPagination rkContractProjectHelpPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractProjectHelpNum = 0;
        QueryWrapper rkContractProjectHelpQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)rkContractProjectHelpPagination.getIsCompleteHelp())) {
            ++rkContractProjectHelpNum;
            rkContractProjectHelpQueryWrapper.lambda().eq(RkContractProjectHelpEntity::getIsCompleteHelp, (Object)rkContractProjectHelpPagination.getIsCompleteHelp());
        }
        if (StringUtils.isNotEmpty((String)rkContractProjectHelpPagination.getCompleteDescribe())) {
            ++rkContractProjectHelpNum;
            rkContractProjectHelpQueryWrapper.lambda().like(RkContractProjectHelpEntity::getCompleteDescribe, (Object)rkContractProjectHelpPagination.getCompleteDescribe());
        }
        if (AllIdList.size() > 0) {
            rkContractProjectHelpQueryWrapper.lambda().in(RkContractProjectHelpEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)rkContractProjectHelpPagination.getSidx())) {
            rkContractProjectHelpQueryWrapper.lambda().orderByDesc(RkContractProjectHelpEntity::getId);
        } else {
            try {
                String sidx = rkContractProjectHelpPagination.getSidx();
                RkContractProjectHelpEntity rkContractProjectHelpEntity = new RkContractProjectHelpEntity();
                Field declaredField = rkContractProjectHelpEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractProjectHelpQueryWrapper = "asc".equals(rkContractProjectHelpPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractProjectHelpQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractProjectHelpQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractProjectHelpPagination.getCurrentPage(), rkContractProjectHelpPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractProjectHelpQueryWrapper);
                return rkContractProjectHelpPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractProjectHelpPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractProjectHelpQueryWrapper);
    }

    @Override
    public RkContractProjectHelpEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProjectHelpEntity::getId, (Object)id);
        return (RkContractProjectHelpEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(RkContractProjectHelpCrForm rkContractProjectHelpCrForm) {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkContractProjectHelpEntity entity = (RkContractProjectHelpEntity)JsonUtil.getJsonToBean((Object)rkContractProjectHelpCrForm, RkContractProjectHelpEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(new Date());
        if (ObjectUtil.isNotEmpty((Object)entity.getProjectId())) {
            RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()));
            List<RkContractReturnPlanEntity> planByProjectId = this.rkContractReturnPlanService.getPlanByProjectId(entity.getProjectId());
            if (ObjectUtil.isNotEmpty(planByProjectId)) {
                for (RkContractReturnPlanEntity plan : planByProjectId) {
                    List<RkReturnPlanFollowEntity> byPlanIdForCompleteState = this.rkReturnPlanFollowService.getByPlanIdForCompleteState(plan.getId());
                    byPlanIdForCompleteState.stream().forEach(follow -> {
                        follow.setCompleteState(entity.getIsCompleteHelp());
                        follow.setProjectHelpId(entity.getId());
                        this.rkReturnPlanFollowService.updateById(follow);
                    });
                }
            }
            if (ObjectUtil.isNotEmpty((Object)projectEntity)) {
                projectEntity.setIsCompleteHelp(entity.getIsCompleteHelp());
                this.rkContractProjectService.updateById(projectEntity);
            }
        }
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, RkContractProjectHelpUpForm rkContractProjectHelpUpForm) {
        UserInfo userInfo = this.userProvider.get();
        RkContractProjectHelpEntity entity = this.getInfo(id);
        if (entity != null) {
            RkContractProjectHelpEntity subentity = (RkContractProjectHelpEntity)JsonUtil.getJsonToBean((Object)rkContractProjectHelpUpForm, RkContractProjectHelpEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    @DSTransactional
    public void delete(RkContractProjectHelpEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

