/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractProjectMarkTrendsEntity;
import com.bringspring.contract.mapper.RkContractProjectMarkTrendsMapper;
import com.bringspring.contract.model.rkcontractprojectmark.RkContractProjectMarkTrendsCrForm;
import com.bringspring.contract.service.RkContractProjectMarkTrendsService;
import com.bringspring.contract.service.RkContractProjectService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractProjectMarkTrendsServiceImpl
extends ServiceImpl<RkContractProjectMarkTrendsMapper, RkContractProjectMarkTrendsEntity>
implements RkContractProjectMarkTrendsService {
    @Autowired
    private RkContractProjectService rkContractProjectService;

    @Override
    public Boolean create(RkContractProjectMarkTrendsCrForm form) {
        if (CollectionUtil.isEmpty(form.getProjectListId()) && StrUtil.equals((CharSequence)"single", (CharSequence)form.getChooseType())) {
            form.setProjectListId(Collections.singletonList(form.getProjectId()));
        }
        if (CollectionUtil.isNotEmpty(form.getProjectListId())) {
            for (String projectId : form.getProjectListId()) {
                String mainId = RandomUtil.uuId();
                RkContractProjectMarkTrendsEntity entity = (RkContractProjectMarkTrendsEntity)JsonUtil.getJsonToBean((Object)form, RkContractProjectMarkTrendsEntity.class);
                entity.setProjectId(projectId);
                entity.setId(mainId);
                entity.setMarkStatus(form.getStatus());
                this.save(entity);
                RkContractProjectEntity info = this.rkContractProjectService.getInfo(projectId);
                if (!ObjectUtil.isNotEmpty((Object)info)) continue;
                info.setMarkType(form.getMarkType());
                this.rkContractProjectService.update(projectId, info);
            }
            return true;
        }
        return false;
    }

    @Override
    public RkContractProjectMarkTrendsEntity byProjectId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProjectMarkTrendsEntity::getProjectId, (Object)id);
        queryWrapper.lambda().orderByDesc(RkContractProjectMarkTrendsEntity::getCreatorTime);
        queryWrapper.last("LIMIT 1");
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return (RkContractProjectMarkTrendsEntity)list.get(0);
        }
        return null;
    }
}

