/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractProjectMemberEntity;
import com.bringspring.contract.mapper.RkContractProjectMemberMapper;
import com.bringspring.contract.model.rkcontractprojectmember.RkContractProjectMemberPagination;
import com.bringspring.contract.service.RkContractProjectMemberService;
import com.bringspring.contract.utils.ProjectRoleEnum;
import com.bringspring.system.permission.service.UserService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractProjectMemberServiceImpl
extends ServiceImpl<RkContractProjectMemberMapper, RkContractProjectMemberEntity>
implements RkContractProjectMemberService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;

    @Override
    public void dealProjectMember(String type, RkContractProjectEntity project) {
        if ("department".equals(type) || "changeRegionHeader".equals(type)) {
            this.inAndOutMember(project.getRegionalHead(), project.getId(), ProjectRoleEnum.REGIONAL_HEAD.getEncode());
        } else if ("user".equals(type)) {
            this.inAndOutMember(project.getProjectHeader(), project.getId(), ProjectRoleEnum.PROJECT_MANAGER.getEncode());
            this.inAndOutMember(project.getAssistantsUser(), project.getId(), ProjectRoleEnum.PROJECT_ASSISTANT.getEncode());
        } else if ("execute".equals(type) || "changeExecute".equals(type)) {
            this.inAndOutMember(project.getExecuteUser(), project.getId(), ProjectRoleEnum.IMPL_PERSON.getEncode());
            this.inAndOutMember(project.getExecuteAssistantsUser(), project.getId(), ProjectRoleEnum.IMPL_ASSISTANT.getEncode());
        } else if ("afterSale".equals(type)) {
            this.inAndOutMember(project.getAfterSalesManager(), project.getId(), ProjectRoleEnum.AFTER_SALES_REGIONAL_HEAD.getEncode());
            this.inAndOutMember(project.getAfterSaleHeader(), project.getId(), ProjectRoleEnum.AFTER_SALES_HEAD.getEncode());
            this.inAndOutMember(project.getAfterSaleExecuteAssistantsUser(), project.getId(), ProjectRoleEnum.AFTER_SALES_ASSISTANT.getEncode());
            this.inAndOutMember(project.getAfterSalesAssistant(), project.getId(), ProjectRoleEnum.AFTER_SALES_ASSISTANT_MANAGER.getEncode());
        } else if (StrUtil.isEmpty((CharSequence)type)) {
            this.inAndOutMember(project.getRegionalHead(), project.getId(), ProjectRoleEnum.REGIONAL_HEAD.getEncode());
            this.inAndOutMember(project.getProjectHeader(), project.getId(), ProjectRoleEnum.PROJECT_MANAGER.getEncode());
            this.inAndOutMember(project.getAssistantsUser(), project.getId(), ProjectRoleEnum.PROJECT_ASSISTANT.getEncode());
            this.inAndOutMember(project.getExecuteUser(), project.getId(), ProjectRoleEnum.IMPL_PERSON.getEncode());
            this.inAndOutMember(project.getExecuteAssistantsUser(), project.getId(), ProjectRoleEnum.IMPL_ASSISTANT.getEncode());
            this.inAndOutMember(project.getAfterSalesManager(), project.getId(), ProjectRoleEnum.AFTER_SALES_REGIONAL_HEAD.getEncode());
            this.inAndOutMember(project.getAfterSaleHeader(), project.getId(), ProjectRoleEnum.AFTER_SALES_HEAD.getEncode());
            this.inAndOutMember(project.getAfterSaleExecuteAssistantsUser(), project.getId(), ProjectRoleEnum.AFTER_SALES_ASSISTANT.getEncode());
            this.inAndOutMember(project.getAfterSalesAssistant(), project.getId(), ProjectRoleEnum.AFTER_SALES_ASSISTANT_MANAGER.getEncode());
        }
    }

    @Override
    public void inAndOutMember(String userIds, String projectId, String projectRole) {
        if (StrUtil.isNotEmpty((CharSequence)userIds)) {
            List<String> userIdList = Arrays.asList(userIds.split(","));
            List<RkContractProjectMemberEntity> memberEntityList = this.queryNotOutMember(userIdList, projectId, projectRole);
            Map<Object, Object> memberMap = new HashMap();
            if (CollectionUtil.isNotEmpty(memberEntityList)) {
                memberMap = memberEntityList.stream().collect(Collectors.toMap(RkContractProjectMemberEntity::getMemberUserId, s -> s));
            }
            RkContractProjectMemberEntity memberEntity = null;
            ArrayList<RkContractProjectMemberEntity> memberList = new ArrayList<RkContractProjectMemberEntity>();
            UserInfo userInfo = this.userProvider.get();
            Date nowDate = DateUtil.getNowDate();
            for (String userId : userIdList) {
                if (memberMap.containsKey(userId)) continue;
                memberEntity = new RkContractProjectMemberEntity();
                memberEntity.setId(RandomUtil.uuId());
                memberEntity.setMemberUserId(userId);
                memberEntity.setProjectId(projectId);
                memberEntity.setProjectRole(projectRole);
                memberEntity.setInDate(nowDate);
                memberEntity.setCompanyId(userInfo.getOrganizeId());
                memberEntity.setCreatorDeptId(userInfo.getDepartmentId());
                memberList.add(memberEntity);
            }
            if (memberList.size() > 0) {
                this.saveBatch(memberList);
            }
            this.outMember(userIdList, projectId, projectRole);
        } else {
            this.outMember(null, projectId, projectRole);
        }
    }

    @Override
    public List<RkContractProjectMemberEntity> queryNotOutMember(List<String> userIdList, String projectId, String projectRole) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtil.isNotEmpty(userIdList)) {
            queryWrapper.lambda().in(RkContractProjectMemberEntity::getMemberUserId, userIdList);
        }
        if (StrUtil.isNotEmpty((CharSequence)projectRole)) {
            queryWrapper.lambda().eq(RkContractProjectMemberEntity::getProjectRole, (Object)projectRole);
        }
        queryWrapper.lambda().eq(RkContractProjectMemberEntity::getProjectId, (Object)projectId);
        queryWrapper.lambda().isNull(RkContractProjectMemberEntity::getOutDate);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void outMember(List<String> userIdList, String projectId, String projectRole) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().set(RkContractProjectMemberEntity::getOutDate, (Object)new Date());
        if (CollectionUtil.isNotEmpty(userIdList)) {
            updateWrapper.lambda().notIn(RkContractProjectMemberEntity::getMemberUserId, userIdList);
        }
        if (StrUtil.isNotEmpty((CharSequence)projectRole)) {
            updateWrapper.lambda().eq(RkContractProjectMemberEntity::getProjectRole, (Object)projectRole);
        }
        updateWrapper.lambda().eq(RkContractProjectMemberEntity::getProjectId, (Object)projectId);
        updateWrapper.lambda().isNull(RkContractProjectMemberEntity::getOutDate);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public List<RkContractProjectMemberEntity> getList(RkContractProjectMemberPagination rkContractProjectPagination) {
        QueryWrapper<RkContractProjectMemberEntity> queryWrapper = this.appendWrapper(rkContractProjectPagination);
        Page page = new Page(rkContractProjectPagination.getCurrentPage(), rkContractProjectPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return rkContractProjectPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<RkContractProjectMemberEntity> appendWrapper(RkContractProjectMemberPagination rkContractProjectPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String userId = this.userProvider.get().getUserId();
        if (StringUtils.isNotEmpty((String)rkContractProjectPagination.getProjectId())) {
            queryWrapper.lambda().eq(RkContractProjectMemberEntity::getProjectId, (Object)rkContractProjectPagination.getProjectId());
        }
        if (StringUtils.isNotEmpty((String)rkContractProjectPagination.getCompanyId())) {
            queryWrapper.lambda().eq(RkContractProjectMemberEntity::getCompanyId, (Object)rkContractProjectPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(rkContractProjectPagination.getCreatorTime())) {
            List<String> creatorTimeList = rkContractProjectPagination.getCreatorTime();
            Long fir = Long.valueOf(creatorTimeList.get(0));
            Long sec = Long.valueOf(creatorTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(RkContractProjectMemberEntity::getCreatorTime, (Object)new Date(fir))).le(RkContractProjectMemberEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)rkContractProjectPagination.getCreatorUserId())) {
            queryWrapper.lambda().eq(RkContractProjectMemberEntity::getCreatorUserId, (Object)rkContractProjectPagination.getCreatorUserId());
        }
        if (StringUtils.isEmpty((String)rkContractProjectPagination.getSidx())) {
            ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(RkContractProjectMemberEntity::getOutDate)).orderByDesc(RkContractProjectMemberEntity::getId);
        } else {
            try {
                String sidx = rkContractProjectPagination.getSidx();
                RkContractProjectMemberEntity RkContractProjectMemberEntity2 = new RkContractProjectMemberEntity();
                Field declaredField = RkContractProjectMemberEntity2.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(rkContractProjectPagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return queryWrapper;
    }
}

