/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectCostEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectProductEntity;
import com.bringspring.contract.entity.RkProjectTrendsEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.mapper.RkContractMapper;
import com.bringspring.contract.mapper.RkContractProjectCostMapper;
import com.bringspring.contract.mapper.RkContractProjectMapper;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordPagination;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectCrForm;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectPagination;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectUpForm;
import com.bringspring.contract.model.rkcontractproject.RkProjectAssignedForm;
import com.bringspring.contract.model.rkcontractproject.RkProjectTotalVo;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractProjectMemberService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectPlanDetailService;
import com.bringspring.contract.service.RkProjectProductService;
import com.bringspring.contract.service.RkProjectTrendsService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ProjectStateEnum;
import com.bringspring.contract.utils.ProjectTrendsEnum;
import com.bringspring.contract.utils.ProjectTypeEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmDepartConnectEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.base.entity.AreagroupEntity;
import com.bringspring.system.base.service.AreagroupService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.MessageUtils;
import com.bringspring.visit.service.AfterSalesMaintenanceService;
import com.bringspring.visit.utils.CreateChatInfo;
import com.bringspring.visit.utils.QuestionTimeUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RkContractProjectServiceImpl
extends ServiceImpl<RkContractProjectMapper, RkContractProjectEntity>
implements RkContractProjectService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkProjectProductService projectProductService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkProjectTrendsService rkProjectTrendsService;
    @Autowired
    private RkProjectPlanDetailService rkProjectPlanDetailService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProjectMapper rkContractProjectMapper;
    @Autowired
    private RkContractMapper rkContractMapper;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private RkContractProjectCostMapper rkContractProjectCostMapper;
    @Autowired
    private AfterSalesProjectsService afterSalesProjectsService;
    @Autowired
    private RkContractProductService rkContractProductService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private RkContractProjectMemberService rkContractProjectMemberService;
    @Autowired
    private UserService userService;
    @Autowired
    private AfterSalesMaintenanceService afterSalesMaintenanceService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private AreagroupService areagroupService;

    @Override
    @Transactional
    public List<RkContractProjectEntity> getList(RkContractProjectPagination rkContractProjectPagination) {
        String userId = this.userProvider.get().getUserId();
        int total = 0;
        ArrayList AllIdList = new ArrayList();
        QueryWrapper rkContractProjectQueryWrapper = this.appendWrapper(rkContractProjectPagination);
        if (ObjectUtil.isNull(rkContractProjectQueryWrapper)) {
            ArrayList list = new ArrayList();
            return rkContractProjectPagination.setData(list, list.size());
        }
        if (AllIdList.size() > 0) {
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractProjectPagination.getSidx())) {
            rkContractProjectQueryWrapper.lambda().orderByDesc(RkContractProjectEntity::getId);
        } else {
            try {
                String sidx = rkContractProjectPagination.getSidx();
                RkContractProjectEntity rkContractProjectEntity = new RkContractProjectEntity();
                Field declaredField = rkContractProjectEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractProjectQueryWrapper = "asc".equals(rkContractProjectPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractProjectQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractProjectQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkContractProjectPagination.getCurrentPage(), rkContractProjectPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkContractProjectQueryWrapper);
            return rkContractProjectPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkContractProjectPagination.setData(list, list.size());
    }

    private Consumer<QueryWrapper<RkContractProjectEntity>> defaultWrapper() {
        final UserInfo userInfo = this.userProvider.get();
        return new Consumer<QueryWrapper<RkContractProjectEntity>>(){

            @Override
            public void accept(QueryWrapper<RkContractProjectEntity> rkContractProjectEntityQueryWrapper) {
                rkContractProjectEntityQueryWrapper.lambda().and(s -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)s.like(RkContractProjectEntity::getExecuteUser, (Object)userInfo.getUserId())).or()).like(RkContractProjectEntity::getExecuteAssistantsUser, (Object)userInfo.getUserId())).or()).like(RkContractProjectEntity::getExecuteUserDepartment, (Object)userInfo.getDepartmentId())).or()).like(RkContractProjectEntity::getExecuteAssistantsUserDepartment, (Object)userInfo.getDepartmentId())).or()).like(RkContractProjectEntity::getRegionalHead, (Object)userInfo.getUserId())).or()).like(RkContractProjectEntity::getProjectHeader, (Object)userInfo.getUserId())).or()).like(RkContractProjectEntity::getAssistantsUser, (Object)userInfo.getUserId())).or()).like(RkContractProjectEntity::getAfterSaleHeader, (Object)userInfo.getUserId())).or()).like(RkContractProjectEntity::getAfterSaleExecuteUser, (Object)userInfo.getUserId())).or()).like(RkContractProjectEntity::getAfterSaleExecuteAssistantsUser, (Object)userInfo.getUserId())).or()).like(RkContractProjectEntity::getAfterSalesManager, (Object)userInfo.getUserId())).or()).like(RkContractProjectEntity::getAfterSalesAssistant, (Object)userInfo.getUserId())).or()).eq(RkContractProjectEntity::getSendType, (Object)userInfo.getOrganizeId()));
            }
        };
    }

    private QueryWrapper<RkContractProjectEntity> appendWrapper(RkContractProjectPagination rkContractProjectPagination) {
        Long sec;
        Long fir;
        List collect;
        Object rkContractProjectObj;
        boolean isPc;
        UserInfo userInfo = this.userProvider.get();
        String userId = this.userProvider.get().getUserId();
        int rkContractProjectNum = 0;
        QueryWrapper rkContractProjectQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        if (ObjectUtil.equals((Object)rkContractProjectPagination.getIsAuth(), (Object)0)) {
            pcPermission = false;
            appPermission = false;
            if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getProjectLogState()) && rkContractProjectPagination.getProjectLogState().booleanValue()) {
                rkContractProjectQueryWrapper.and(this.defaultWrapper());
                if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getCustomerId())) {
                    rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getCustomerId, (Object)rkContractProjectPagination.getCustomerId());
                }
                ((LambdaQueryWrapper)rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getManHourState, (Object)"0")).ne(RkContractProjectEntity::getState, (Object)"stop");
            }
        }
        if ((isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc")) && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProjectObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProjectQueryWrapper, rkContractProjectPagination.getMenuId(), "rk_contract_project"));
            if (ObjectUtil.isEmpty((Object)rkContractProjectObj)) {
                rkContractProjectQueryWrapper.and(this.defaultWrapper());
            } else {
                rkContractProjectQueryWrapper = (QueryWrapper)rkContractProjectObj;
                ++rkContractProjectNum;
            }
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProjectObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProjectQueryWrapper, rkContractProjectPagination.getMenuId(), "rk_contract_project"));
            if (ObjectUtil.isEmpty((Object)rkContractProjectObj)) {
                rkContractProjectQueryWrapper.and(this.defaultWrapper());
            } else {
                rkContractProjectQueryWrapper = (QueryWrapper)rkContractProjectObj;
                ++rkContractProjectNum;
            }
        }
        rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        if (StrUtil.isNotEmpty((CharSequence)rkContractProjectPagination.getProjectCode())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().like(RkContractProjectEntity::getProjectCode, (Object)rkContractProjectPagination.getProjectCode().replaceAll("\\s+", ""));
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractProjectPagination.getContractCode()) || StrUtil.isNotEmpty((CharSequence)rkContractProjectPagination.getContractType())) {
            ++rkContractProjectNum;
            RkContractCollectionRecordPagination rkContractCollectionRecordPagination = new RkContractCollectionRecordPagination();
            rkContractCollectionRecordPagination.setContractCode(rkContractProjectPagination.getContractCode().replaceAll("\\s+", ""));
            rkContractCollectionRecordPagination.setContractType(rkContractProjectPagination.getContractType());
            List<RkContractEntity> listByContractCodeLike = this.rkContractService.getListBy(rkContractCollectionRecordPagination);
            if (CollectionUtil.isEmpty(listByContractCodeLike)) {
                return null;
            }
            List collect2 = listByContractCodeLike.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getContractId, collect2);
        }
        if (CollectionUtil.isNotEmpty(rkContractProjectPagination.getProjectIncomeType())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getProjectIncomeType, rkContractProjectPagination.getProjectIncomeType());
        }
        if (CollectionUtil.isNotEmpty(rkContractProjectPagination.getStateList())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getState, rkContractProjectPagination.getStateList());
        }
        if (CollectionUtil.isNotEmpty(rkContractProjectPagination.getCompanyIdList())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().and(x -> x.in(RkContractProjectEntity::getCompanyId, rkContractProjectPagination.getCompanyIdList()));
        }
        if (CollectionUtil.isNotEmpty(rkContractProjectPagination.getSalerCompanyIdList())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getSalerCompanyId, rkContractProjectPagination.getSalerCompanyIdList());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getSalerId())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getSalerId, (Object)rkContractProjectPagination.getSalerId());
        }
        if (CollectionUtil.isNotEmpty(rkContractProjectPagination.getMarkType())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getMarkType, rkContractProjectPagination.getMarkType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getKnowBy())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getKnowBy, (Object)rkContractProjectPagination.getKnowBy());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getIsKnow())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getIsKnow, (Object)rkContractProjectPagination.getIsKnow());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getDepartment())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getDepartment, (Object)rkContractProjectPagination.getDepartment());
        }
        if (CollectionUtil.isNotEmpty(rkContractProjectPagination.getIncomeType())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getIncomeType, rkContractProjectPagination.getIncomeType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getProjectName())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().like(RkContractProjectEntity::getProjectName, (Object)rkContractProjectPagination.getProjectName().replaceAll("\\s+", ""));
        }
        if (ObjectUtil.isEmpty((Object)rkContractProjectPagination.getSource()) && ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getState())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getState, (Object)rkContractProjectPagination.getState());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getState()) && ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getSource()) && rkContractProjectPagination.getSource().equals("export") && !"-1".equals(rkContractProjectPagination.getState())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getState, (Object)rkContractProjectPagination.getState());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getIsCompleteHelp())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getIsCompleteHelp, (Object)rkContractProjectPagination.getIsCompleteHelp());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getProjectHeader())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getProjectHeader, (Object)rkContractProjectPagination.getProjectHeader());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getProjectNature())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getProjectNature, (Object)rkContractProjectPagination.getProjectNature());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getIsAcceptance())) {
            ++rkContractProjectNum;
            if (rkContractProjectPagination.getIsAcceptance().equals("toBeAccepted")) {
                rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getState, (Object)"toBeAccepted");
            } else {
                rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getIsAcceptance, (Object)rkContractProjectPagination.getIsAcceptance());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getCompanyId())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getCompanyId, (Object)rkContractProjectPagination.getCompanyId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getCustomerId())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getCustomerId, (Object)rkContractProjectPagination.getCustomerId());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractProjectPagination.getIsUploadAcceptFile())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getIsUploadAcceptFile, (Object)rkContractProjectPagination.getIsUploadAcceptFile());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractProjectPagination.getAcceptIsArchived())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getAcceptIsArchived, (Object)rkContractProjectPagination.getAcceptIsArchived());
        }
        if (!ObjectUtil.isEmpty(rkContractProjectPagination.getSignDate()) || !ObjectUtil.isEmpty((Object)rkContractProjectPagination.getAgentId())) {
            List<RkContractEntity> listBySignDate = this.contractService.getListBySignDateAndAgentId(rkContractProjectPagination.getSignDate(), rkContractProjectPagination.getAgentId());
            if (CollectionUtil.isEmpty(listBySignDate)) {
                return null;
            }
            collect = listBySignDate.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getContractId, collect);
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getConnectType())) {
            if (rkContractProjectPagination.getConnectType() == 3) {
                rkContractProjectQueryWrapper.lambda().isNull(RkContractProjectEntity::getConnectType);
            } else {
                rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getConnectType, (Object)rkContractProjectPagination.getConnectType());
            }
        }
        if (CollectionUtil.isNotEmpty(rkContractProjectPagination.getAcceptanceTime())) {
            rkContractProjectQueryWrapper.lambda().between(RkContractProjectEntity::getAcceptanceTime, (Object)rkContractProjectPagination.getAcceptanceTime().get(0), (Object)rkContractProjectPagination.getAcceptanceTime().get(1));
        }
        if (!ObjectUtil.isEmpty(rkContractProjectPagination.getProductList())) {
            List<RkProjectProductEntity> productIdList = this.projectProductService.getListByProductIdList(rkContractProjectPagination.getProductList());
            if (CollectionUtil.isEmpty(productIdList)) {
                return null;
            }
            collect = productIdList.stream().map(RkProjectProductEntity::getProjectId).collect(Collectors.toList());
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getId, collect);
        }
        if (StringUtils.isNotEmpty(rkContractProjectPagination.getStartDateList())) {
            ++rkContractProjectNum;
            List<String> startDateList = rkContractProjectPagination.getStartDateList();
            fir = Long.valueOf(startDateList.get(0));
            sec = Long.valueOf(startDateList.get(1));
            ((LambdaQueryWrapper)rkContractProjectQueryWrapper.lambda().ge(RkContractProjectEntity::getStartDate, (Object)new Date(fir))).le(RkContractProjectEntity::getStartDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(rkContractProjectPagination.getStartApplyDateList())) {
            ++rkContractProjectNum;
            List<String> startApplyDateList = rkContractProjectPagination.getStartApplyDateList();
            fir = Long.valueOf(startApplyDateList.get(0));
            sec = Long.valueOf(startApplyDateList.get(1));
            ((LambdaQueryWrapper)rkContractProjectQueryWrapper.lambda().ge(RkContractProjectEntity::getStartApplyDate, (Object)new Date(fir))).le(RkContractProjectEntity::getStartApplyDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(rkContractProjectPagination.getAcceptanceTimeList())) {
            ++rkContractProjectNum;
            List<String> acceptanceTimeList = rkContractProjectPagination.getAcceptanceTimeList();
            fir = Long.valueOf(acceptanceTimeList.get(0));
            sec = Long.valueOf(acceptanceTimeList.get(1));
            ((LambdaQueryWrapper)rkContractProjectQueryWrapper.lambda().ge(RkContractProjectEntity::getAcceptanceTime, (Object)new Date(fir))).le(RkContractProjectEntity::getAcceptanceTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractProjectPagination.getSearchType())) {
            if (StrUtil.equals((CharSequence)rkContractProjectPagination.getSearchType(), (CharSequence)"1")) {
                rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getProjectHeader, (Object)userId);
            }
            if (StrUtil.equals((CharSequence)rkContractProjectPagination.getSearchType(), (CharSequence)"2")) {
                rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getRegionalHead, (Object)userId);
            }
            if (StrUtil.equals((CharSequence)rkContractProjectPagination.getSearchType(), (CharSequence)"3")) {
                rkContractProjectQueryWrapper.apply("FIND_IN_SET('" + userId + "',assistants_user) > 0 ", new Object[0]);
            }
            if (StrUtil.equals((CharSequence)rkContractProjectPagination.getSearchType(), (CharSequence)"4")) {
                rkContractProjectQueryWrapper.lambda().and(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(RkContractProjectEntity::getProjectHeader, (Object)userId)).or()).eq(RkContractProjectEntity::getSalerId, (Object)userId);
                });
            }
        }
        if (ObjectUtil.equals((Object)rkContractProjectPagination.getIsMaintenance(), (Object)1)) {
            Date dayBegin = DateUtil.getDayBegin();
            rkContractProjectQueryWrapper.lambda().lt(RkContractProjectEntity::getAcceptanceTime, (Object)dayBegin);
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractProjectPagination.getKeyword())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().and(s -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)s.or()).like(RkContractProjectEntity::getProjectName, (Object)rkContractProjectPagination.getKeyword())).or()).like(RkContractProjectEntity::getProjectCode, (Object)rkContractProjectPagination.getKeyword()));
        }
        if (ObjectUtil.isNotEmpty(rkContractProjectPagination.getSearchProjectTypeList())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getProjectType, rkContractProjectPagination.getSearchProjectTypeList());
        } else if (!ObjectUtil.isEmpty((Object)rkContractProjectPagination.getProjectType())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getProjectType, (Object)rkContractProjectPagination.getProjectType());
        } else {
            rkContractProjectQueryWrapper.lambda().and(s -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)s.ne(RkContractProjectEntity::getProjectType, (Object)ProjectTypeEnum.MANAGER.getEnCode())).or()).isNull(RkContractProjectEntity::getProjectType);
            });
        }
        if (CollectionUtil.isNotEmpty(rkContractProjectPagination.getCustomerAddress())) {
            rkContractProjectPagination.getCustomerAddress().stream().filter(x -> {
                boolean flag = x.size() < 2 && ((String)x.get(0)).equals("10");
                return !flag;
            }).collect(Collectors.toList());
            if (rkContractProjectPagination.getCustomerAddress().size() < 2 && rkContractProjectPagination.getCustomerAddress().get(0).equals("10")) {
                rkContractProjectPagination.setCustomerAddress(null);
            }
        }
        if (CollectionUtil.isNotEmpty(rkContractProjectPagination.getSignAddress())) {
            rkContractProjectPagination.getSignAddress().stream().filter(x -> {
                boolean flag = x.size() < 2 && ((String)x.get(0)).equals("10");
                return !flag;
            }).collect(Collectors.toList());
            if (rkContractProjectPagination.getSignAddress().size() < 2 && rkContractProjectPagination.getSignAddress().get(0).equals("10")) {
                rkContractProjectPagination.setSignAddress(null);
            }
        }
        if (StringUtils.isNotEmpty(rkContractProjectPagination.getCustomerAddress())) {
            rkContractProjectQueryWrapper.lambda().and(x -> {
                for (List<String> ll : rkContractProjectPagination.getCustomerAddress()) {
                    List addressList = JsonUtil.getJsonToList(ll, String.class);
                    if (addressList.size() > 1) {
                        String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                        collect = "[" + collect;
                        ((LambdaQueryWrapper)x.or()).like(RkContractProjectEntity::getCustomerAddress, (Object)collect);
                        continue;
                    }
                    String s2 = (String)addressList.get(addressList.size() - 1);
                    s2 = "[\"" + s2 + "\"";
                    ((LambdaQueryWrapper)x.or()).like(RkContractProjectEntity::getCustomerAddress, (Object)s2);
                }
            });
        }
        if (StringUtils.isNotEmpty(rkContractProjectPagination.getSignAddress())) {
            rkContractProjectQueryWrapper.lambda().and(x -> {
                String organizeId;
                for (List<String> ll : rkContractProjectPagination.getSignAddress()) {
                    List addressList = JsonUtil.getJsonToList(ll, String.class);
                    if (addressList.size() > 1) {
                        String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                        collect = "[" + collect;
                        ((LambdaQueryWrapper)x.or()).like(RkContractProjectEntity::getCustomerAddress, (Object)collect);
                        continue;
                    }
                    String s2 = (String)addressList.get(addressList.size() - 1);
                    s2 = "[\"" + s2 + "\"";
                    ((LambdaQueryWrapper)x.or()).like(RkContractProjectEntity::getCustomerAddress, (Object)s2);
                }
                AreagroupEntity info = this.areagroupService.getInfo(rkContractProjectPagination.getSignAddressList().get(0).get(0));
                if (ObjectUtil.isNotEmpty((Object)info) && ObjectUtil.isNotEmpty((Object)(organizeId = info.getOrganizeId()))) {
                    List jsonToList = JsonUtil.getJsonToList((String)organizeId, String.class);
                    List userIds = this.userService.getListByOraganizetionId((String)jsonToList.get(jsonToList.size() - 1)).stream().map(v -> v.getId()).collect(Collectors.toList());
                    ((LambdaQueryWrapper)x.or()).in(RkContractProjectEntity::getProjectHeader, userIds);
                }
            });
        }
        return rkContractProjectQueryWrapper;
    }

    @Override
    public List<RkContractProjectEntity> getTypeList(RkContractProjectPagination rkContractProjectPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper rkContractProjectQueryWrapper = this.appendWrapper(rkContractProjectPagination);
        if (ObjectUtil.isNull(rkContractProjectQueryWrapper)) {
            ArrayList list = new ArrayList();
            return rkContractProjectPagination.setData(list, list.size());
        }
        if (AllIdList.size() > 0) {
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractProjectPagination.getSidx())) {
            rkContractProjectQueryWrapper.lambda().orderByDesc(RkContractProjectEntity::getId);
        } else {
            try {
                String sidx = rkContractProjectPagination.getSidx();
                RkContractProjectEntity rkContractProjectEntity = new RkContractProjectEntity();
                Field declaredField = rkContractProjectEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractProjectQueryWrapper = "asc".equals(rkContractProjectPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractProjectQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractProjectQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractProjectPagination.getCurrentPage(), rkContractProjectPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractProjectQueryWrapper);
                return rkContractProjectPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractProjectPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractProjectQueryWrapper);
    }

    @Override
    public void updateIsUploadAcceptFile(String projectId, Integer isUpload) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractProjectEntity::getIsUploadAcceptFile, (Object)isUpload)).eq(RkContractProjectEntity::getId, (Object)projectId);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public RkContractProjectEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProjectEntity::getId, (Object)id);
        queryWrapper.lambda().eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        return (RkContractProjectEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public RkContractProjectEntity getInfoByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractProjectEntity::getProjectCode, (Object)code)).eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        return (RkContractProjectEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public RkContractProjectEntity getInfoByCode(String code, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractProjectEntity::getProjectCode, (Object)code)).eq(RkContractProjectEntity::getCompanyId, (Object)companyId)).eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        return (RkContractProjectEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkContractProjectEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkContractProjectEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkContractProjectEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public List<RkContractProjectEntity> getListByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProjectEntity::getContractId, (Object)contractId);
        queryWrapper.lambda().eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProjectEntity> getListByContractIdAndCustomerId(String contractId, String customerId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProjectEntity::getContractId, (Object)contractId);
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractProjectEntity::getEnabledMark, (Object)1)).eq(RkContractProjectEntity::getCustomerId, (Object)customerId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProjectEntity> getListByContractIdHaveDel(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProjectEntity::getContractId, (Object)contractId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProjectEntity> getListByCompanyId(String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)companyId)) {
            queryWrapper.lambda().eq(RkContractProjectEntity::getCompanyId, (Object)companyId);
        }
        queryWrapper.lambda().eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProjectEntity> getCanStartByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractProjectEntity::getIsAcceptance, (Object)0)).eq(RkContractProjectEntity::getEnabledMark, (Object)1)).and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.or()).eq(RkContractProjectEntity::getContractId, (Object)contractId)).or()).eq(RkContractProjectEntity::getNoContractId, (Object)contractId))).and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.or()).isNull(RkContractProjectEntity::getState)).or()).eq(RkContractProjectEntity::getState, (Object)ProjectStateEnum.notStartApply_state.getState()));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProjectEntity> getAcceptListByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractProjectEntity::getContractId, (Object)contractId)).eq(RkContractProjectEntity::getIsAcceptance, (Object)1)).eq(RkContractProjectEntity::getEnabledMark, (Object)1)).orderByDesc(RkContractProjectEntity::getAcceptanceTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProjectEntity> getListByCode(String projectCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(RkContractProjectEntity::getProjectCode, (Object)projectCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public long countByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractProjectEntity::getContractId, (Object)contractId)).eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void saveProject(RkContractProjectCrForm rkContractProjectCrForm) {
        SaleNoContractEntity noContract;
        UserInfo userInfo = this.userProvider.get();
        String mainId = RandomUtil.uuId();
        RkContractProjectEntity entity = (RkContractProjectEntity)JsonUtil.getJsonToBean((Object)rkContractProjectCrForm, RkContractProjectEntity.class);
        if (StringUtils.isNotEmpty((String)rkContractProjectCrForm.getContractId())) {
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractProjectCrForm.getContractId()));
            if (ObjectUtil.isNotEmpty((Object)byId)) {
                byId.setContractSureIncome(rkContractProjectCrForm.getContractIncome());
                this.contractService.update(byId.getId(), byId);
                entity.setSalerCompanyId(byId.getSalerCompanyId());
                entity.setSalerPlatFormCompanyId(byId.getSalerPlatFormCompanyId());
                entity.setId(mainId);
                entity.setCompanyId(byId.getCompanyId());
                entity.setIsUploadAcceptFile(0);
                entity.setIsAcceptance(0);
                entity.setSalerId(byId.getSalerId());
                entity.setSalerName(byId.getSalerName());
                entity.setContractType(byId.getContractType());
            }
        } else if (StringUtils.isNotEmpty((String)rkContractProjectCrForm.getNoContractId()) && null != (noContract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)rkContractProjectCrForm.getNoContractId())))) {
            entity.setId(mainId);
            entity.setCompanyId(noContract.getCompanyId());
            entity.setIsUploadAcceptFile(0);
            entity.setIsAcceptance(0);
            entity.setTaxRate("");
            entity.setSalerId(noContract.getSalerId());
            entity.setSalerName(this.baseDataUtil.userSelectValueNoAccount(entity.getSalerId()));
            entity.setContractType(noContract.getContractType());
        }
        if (StringUtils.isNotEmpty((String)rkContractProjectCrForm.getContractId()) || StringUtils.isNotEmpty((String)rkContractProjectCrForm.getNoContractId())) {
            entity.setState(ProjectStateEnum.notStartApply_state.getState());
            List<String> productList = rkContractProjectCrForm.getProductList();
            if (CollectionUtil.isNotEmpty(productList)) {
                List list = CollectionUtil.list((boolean)false);
                productList.stream().forEach(s -> {
                    RkProjectProductEntity productEntity = new RkProjectProductEntity();
                    productEntity.setProjectId(mainId);
                    productEntity.setProductId((String)s);
                    productEntity.setId(RandomUtil.uuId());
                    list.add(productEntity);
                });
                this.projectProductService.saveBatch(list);
            }
            this.afterSalesMaintenanceService.addCustomerProductLine(entity);
        }
        if (CollectionUtil.isNotEmpty((Collection)rkContractProjectCrForm.getTaxRate())) {
            entity.setTaxRate(CollectionUtil.join((Iterable)rkContractProjectCrForm.getTaxRate(), (CharSequence)","));
        } else {
            entity.setTaxRate("");
        }
        if (StringUtils.isBlank((CharSequence)entity.getDepartmentTree())) {
            entity.setDepartmentTree("[]");
        }
        entity.setOriginalCreatorUserId(entity.getSalerId());
        CrmCustomerEntity info = this.crmCustomerService.getInfo(entity.getCustomerId());
        if (ObjectUtil.isNotEmpty((Object)info)) {
            entity.setCustomerAddress(info.getAddress());
        }
        this.save(entity);
        if (CollectionUtil.isNotEmpty(rkContractProjectCrForm.getAttachmentList())) {
            List jsonToList = JsonUtil.getJsonToList(rkContractProjectCrForm.getAttachmentList(), RkAttachmentEntity.class);
            jsonToList.stream().forEach(attachment -> {
                attachment.setId(RandomUtil.uuId());
                attachment.setProjectId(mainId);
                attachment.setObjId(mainId);
                attachment.setFileType(AttachmentTypeEnum.PROJECT_DESENSITIZATION_CONTRACT_TYPE.getType());
            });
            this.attachmentService.saveBatch(jsonToList);
        }
        RkProjectTrendsEntity trendsEntity = new RkProjectTrendsEntity();
        trendsEntity.setId(RandomUtil.uuId());
        trendsEntity.setProjectId(mainId);
        trendsEntity.setContractId(entity.getContractId());
        trendsEntity.setCustomerId(entity.getCustomerId());
        trendsEntity.setNodeType(ProjectTrendsEnum.CREATE.getNode());
        trendsEntity.setNodeDesc(this.userProvider.get().getUserName() + "\u65b0\u5efa\u9879\u76ee");
        this.rkProjectTrendsService.save(trendsEntity);
    }

    @Override
    @DSTransactional
    public void updateProject(RkContractProjectUpForm rkContractProjectUpForm) {
        RkContractProjectEntity subentity = (RkContractProjectEntity)JsonUtil.getJsonToBean((Object)rkContractProjectUpForm, RkContractProjectEntity.class);
        if (CollectionUtil.isNotEmpty((Collection)rkContractProjectUpForm.getTaxRate())) {
            subentity.setTaxRate(CollectionUtil.join((Iterable)rkContractProjectUpForm.getTaxRate(), (CharSequence)","));
        } else {
            subentity.setTaxRate("");
        }
        this.update(rkContractProjectUpForm.getId(), subentity);
        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractProjectUpForm.getContractIds()));
        if (ObjectUtil.isNotEmpty((Object)byId)) {
            byId.setContractSureIncome(rkContractProjectUpForm.getContractIncome());
            this.contractService.update(byId.getId(), byId);
        }
        this.projectProductService.removeByProjectId(rkContractProjectUpForm.getId());
        List<String> productList = rkContractProjectUpForm.getProductList();
        if (CollectionUtil.isNotEmpty(productList)) {
            List list = CollectionUtil.list((boolean)false);
            productList.stream().forEach(s -> {
                RkProjectProductEntity productEntity = new RkProjectProductEntity();
                productEntity.setProjectId(rkContractProjectUpForm.getId());
                productEntity.setProductId((String)s);
                productEntity.setId(RandomUtil.uuId());
                list.add(productEntity);
            });
            this.projectProductService.saveBatch(list);
        }
        this.attachmentService.deleteByProjectTypeId(rkContractProjectUpForm.getId(), AttachmentTypeEnum.PROJECT_DESENSITIZATION_CONTRACT_TYPE.getType());
        if (CollectionUtil.isNotEmpty(rkContractProjectUpForm.getAttachmentList())) {
            List jsonToList = JsonUtil.getJsonToList(rkContractProjectUpForm.getAttachmentList(), RkAttachmentEntity.class);
            jsonToList.stream().forEach(attachment -> {
                attachment.setId(RandomUtil.uuId());
                attachment.setProjectId(rkContractProjectUpForm.getId());
                attachment.setObjId(rkContractProjectUpForm.getId());
                attachment.setFileType(AttachmentTypeEnum.PROJECT_DESENSITIZATION_CONTRACT_TYPE.getType());
            });
            this.attachmentService.saveBatch(jsonToList);
        }
    }

    @Override
    public void deleteByContractId(String contractId) {
        UpdateWrapper queryWrapper = new UpdateWrapper();
        queryWrapper.lambda().set(RkContractProjectEntity::getEnabledMark, (Object)0);
        queryWrapper.lambda().eq(RkContractProjectEntity::getContractId, (Object)contractId);
        this.update((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void startOrStopProject(RkProjectAssignedForm assignedForm) {
        UserInfo userInfo = this.userProvider.get();
        RkContractProjectEntity byId = (RkContractProjectEntity)this.getById((Serializable)((Object)assignedForm.getId()));
        String nodeDesc = "";
        if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)ProjectTrendsEnum.CANCELLATION.getNode())) {
            byId.setState(ProjectStateEnum.CANCELLATION_state.getState());
            byId.setInvalidRemark(assignedForm.getRemark());
            nodeDesc = "\u4f5c\u5e9f\u4e86\u9879\u76ee";
        }
        if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)ProjectTrendsEnum.STOP.getNode())) {
            byId.setState(ProjectStateEnum.stop_state.getState());
            byId.setStopRemark(assignedForm.getRemark());
            nodeDesc = "\u6682\u505c\u4e86\u9879\u76ee";
            this.rkProjectPlanDetailService.updateStop(assignedForm.getId());
        }
        if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)ProjectTrendsEnum.START.getNode())) {
            byId.setState(ProjectStateEnum.inOperation_state.getState());
            byId.setStartRemark(assignedForm.getRemark());
            byId.setStartDate(DateUtil.getNowDate());
            nodeDesc = "\u5f00\u5de5\u4e86\u9879\u76ee";
        }
        if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)ProjectTrendsEnum.RESTART.getNode())) {
            if (StrUtil.isEmpty((CharSequence)byId.getStartApplyId())) {
                byId.setState(ProjectStateEnum.notStartApply_state.getState());
            } else {
                byId.setState(ProjectStateEnum.inOperation_state.getState());
            }
            byId.setRestartRemark(assignedForm.getRemark());
            nodeDesc = "\u91cd\u65b0\u5f00\u5de5\u4e86\u9879\u76ee";
            this.rkProjectPlanDetailService.updateStart(assignedForm.getId());
        }
        this.updateById(byId);
        RkProjectTrendsEntity trendsEntity = new RkProjectTrendsEntity();
        trendsEntity.setId(RandomUtil.uuId());
        trendsEntity.setContractId(byId.getContractId());
        trendsEntity.setCustomerId(byId.getCustomerId());
        trendsEntity.setProjectId(assignedForm.getId());
        trendsEntity.setNodeType(assignedForm.getType());
        trendsEntity.setNodeDesc(userInfo.getUserName() + nodeDesc);
        trendsEntity.setDescription(assignedForm.getRemark());
        this.rkProjectTrendsService.save(trendsEntity);
        if (CollectionUtil.isNotEmpty(assignedForm.getAttachmentList())) {
            List jsonToList = JsonUtil.getJsonToList(assignedForm.getAttachmentList(), RkAttachmentEntity.class);
            jsonToList.stream().forEach(att -> {
                att.setId(RandomUtil.uuId());
                att.setObjId(assignedForm.getId());
                att.setProjectId(assignedForm.getId());
                att.setFileType("project_" + trendsEntity.getNodeType());
            });
            this.attachmentService.saveBatch(jsonToList);
        }
    }

    @Override
    @DSTransactional
    public void assignedProject(RkProjectAssignedForm assignedForm) throws Exception {
        ArrayList<String> addUserList;
        CreateChatInfo info;
        String fileType = "";
        UserInfo userInfo = this.userProvider.get();
        String userId = "";
        RkContractProjectEntity byId = (RkContractProjectEntity)this.getById((Serializable)((Object)assignedForm.getId()));
        RkProjectTrendsEntity trendsEntity = new RkProjectTrendsEntity();
        trendsEntity.setId(RandomUtil.uuId());
        if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)"department") || StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)"changeRegionHeader")) {
            info = new CreateChatInfo();
            info.setChatid(byId.getProjectCreateChatId());
            if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)"department") || StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)"changeRegionHeader")) {
                addUserList = new ArrayList<String>();
                addUserList.add(assignedForm.getRegionalHead());
                info.setAddUserList(addUserList);
                info.setOwner(assignedForm.getRegionalHead());
            }
            QuestionTimeUtil.updateCreateChat(info);
            userId = assignedForm.getRegionalHead();
            String oldRegionHeader = byId.getRegionalHead();
            byId.setRegionalHead(assignedForm.getRegionalHead());
            if (CollectionUtil.isNotEmpty(assignedForm.getDepartmentTree())) {
                if (CollectionUtil.isNotEmpty(assignedForm.getDepartmentTree())) {
                    byId.setDepartmentOne(assignedForm.getDepartmentTree().get(0));
                }
                byId.setDepartment(assignedForm.getDepartment());
                byId.setDepartmentTree(assignedForm.getDepartmentTree().toString());
            }
            byId.setAssignedRegionRemark(assignedForm.getRemark());
            if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)"department")) {
                byId.setState(ProjectStateEnum.unassigned_project_state.getState());
            }
            trendsEntity.setNodeType(ProjectTrendsEnum.ASSIGNED_REGIONAL.getNode());
            String desc = userInfo.getUserName() + "\u5206\u6d3e\u533a\u57df\u8d1f\u8d23\u4eba\u3010" + this.baseDataUtil.userSelectValueNoAccount(assignedForm.getRegionalHead()) + "\u3011";
            if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)"changeRegionHeader")) {
                trendsEntity.setNodeType(ProjectTrendsEnum.CHANGE_REGIONAL.getNode());
                desc = userInfo.getUserName() + "\u53d8\u66f4\u533a\u57df\u8d1f\u8d23\u4eba\u3010" + this.baseDataUtil.userSelectValueNoAccount(oldRegionHeader) + "\u3011\u4e3a\u3010" + this.baseDataUtil.userSelectValueNoAccount(assignedForm.getRegionalHead()) + "\u3011";
            }
            trendsEntity.setExecutorUser(assignedForm.getRegionalHead());
            trendsEntity.setNodeDesc(desc);
        }
        if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)"user")) {
            userId = assignedForm.getProjectHeader();
            byId.setState(ProjectStateEnum.notEntered_state.getState());
            byId.setProjectHeader(assignedForm.getProjectHeader());
            byId.setAssignedHeaderRemark(assignedForm.getRemark());
            byId.setAssistantsUser(assignedForm.getAssistantsUser());
            trendsEntity.setNodeType(ProjectTrendsEnum.ASSIGNED_PROJECT.getNode());
            trendsEntity.setExecutorUser(assignedForm.getProjectHeader());
            trendsEntity.setNodeDesc(userInfo.getUserName() + "\u6307\u5b9a\u9879\u76ee\u7ecf\u7406\u3010" + this.baseDataUtil.userSelectValueNoAccount(assignedForm.getProjectHeader()) + "\u3011");
            info = new CreateChatInfo();
            info.setChatid(byId.getProjectCreateChatId());
            addUserList = new ArrayList();
            addUserList.add(userId);
            List<String> list = Arrays.asList(assignedForm.getAssistantsUser().split(","));
            addUserList.addAll(list);
            info.setAddUserList(addUserList);
            QuestionTimeUtil.updateCreateChat(info);
        }
        if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)"execute")) {
            userId = assignedForm.getExecuteUser();
            byId.setExecuteUser(userId);
            byId.setExecuteRemark(assignedForm.getRemark());
            byId.setExecuteAssistantsUser(assignedForm.getExecuteAssistantsUser());
            byId.setExecuteUserDepartment(assignedForm.getExecuteUserDepartment());
            byId.setExecuteAssistantsUserDepartment(assignedForm.getExecuteAssistantsUserDepartment());
            byId.setSendType(assignedForm.getSendType());
            trendsEntity.setNodeType(ProjectTrendsEnum.EXECUTE_PROJECT.getNode());
            trendsEntity.setExecutorUser(userId);
            trendsEntity.setNodeDesc(userInfo.getUserName() + "\u6307\u5b9a\u5b9e\u65bd\u4eba\u5458\u3010" + this.baseDataUtil.userSelectValues(userId) + "\u3011");
            fileType = "execute";
        }
        if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)"changeExecute")) {
            fileType = "execute";
            String oldExecuteUser = byId.getExecuteUser();
            userId = assignedForm.getExecuteUser();
            byId.setExecuteUser(userId);
            byId.setExecuteRemark(assignedForm.getRemark());
            byId.setExecuteAssistantsUser(assignedForm.getExecuteAssistantsUser());
            byId.setExecuteUserDepartment(assignedForm.getExecuteUserDepartment());
            byId.setExecuteAssistantsUserDepartment(assignedForm.getExecuteAssistantsUserDepartment());
            byId.setSendType(assignedForm.getSendType());
            trendsEntity.setNodeType(ProjectTrendsEnum.CHANGE_EXECUTE_PROJECT.getNode());
            trendsEntity.setExecutorUser(userId);
            trendsEntity.setNodeDesc(userInfo.getUserName() + "\u66f4\u6362\u5b9e\u65bd\u4eba\u5458\uff1a\u3010" + this.baseDataUtil.userSelectValues(oldExecuteUser) + "\u3011\u53d8\u66f4\u4e3a\u3010" + this.baseDataUtil.userSelectValues(userId) + "\u3011");
        }
        this.updateById(byId);
        if (ObjectUtil.isNotEmpty((Object)byId)) {
            this.rkContractProjectMemberService.dealProjectMember(assignedForm.getType(), byId);
        }
        trendsEntity.setDescription(assignedForm.getRemark());
        trendsEntity.setProjectId(byId.getId());
        trendsEntity.setContractId(byId.getContractId());
        trendsEntity.setCustomerId(byId.getCustomerId());
        this.rkProjectTrendsService.save(trendsEntity);
        String string = fileType = StrUtil.isNotBlank((CharSequence)fileType) ? fileType : trendsEntity.getNodeType();
        if (CollectionUtil.isNotEmpty(assignedForm.getAttachmentList())) {
            List jsonToList = JsonUtil.getJsonToList(assignedForm.getAttachmentList(), RkAttachmentEntity.class);
            String finalFileType = fileType;
            jsonToList.stream().forEach(att -> {
                att.setId(RandomUtil.uuId());
                att.setObjId(assignedForm.getId());
                att.setProjectId(assignedForm.getId());
                att.setFileType("project_" + finalFileType);
            });
            this.attachmentService.saveBatch(jsonToList);
        }
        try {
            String taskCode = MessageTypeEnum.PROJECT_ASSIGNED_TEMPLATE.getMessage();
            String sendCode = MessageTypeEnum.PROJECT_ASSIGNED_TEMPLATE.getTemplateCode();
            HashMap keys = MapUtil.newHashMap();
            keys.put("title", "\u6709\u7ed9\u60a8\u5206\u6d3e\u7684\u9879\u76ee\uff0c\u8bf7\u67e5\u6536");
            keys.put("content", userInfo.getUserName() + "\u628a\u3010" + byId.getProjectName() + "\u3011\u9879\u76ee\u6307\u6d3e\u7ed9\u60a8\uff01");
            keys.put("projectName", byId.getProjectName());
            keys.put("assignUser", userInfo.getUserName());
            keys.put("MessageTime", DateUtil.getNow());
            String appUrl = "/#/pages/project/projectList/detail?menuId=550237317701308421&jurisdictionType=btn_detail&id=" + assignedForm.getId();
            String pcUrl = "/#/contract/project/list?id=" + assignedForm.getId();
            String type = TermTypeEnum.TERM_APP_PC.getCode();
            this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, userId, type, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Map<String, Object>> countByState(RkContractProjectPagination rkContractProjectPagination) {
        QueryWrapper<RkContractProjectEntity> queryWrapper = this.appendWrapper(rkContractProjectPagination);
        if (Objects.isNull(queryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        queryWrapper.select(new String[]{"count(*) as count,state as state"});
        queryWrapper.groupBy((Object)"state");
        List listMaps = this.listMaps((Wrapper)queryWrapper);
        return listMaps;
    }

    private QueryWrapper<RkContractProjectEntity> appendWhere(RkContractProjectPagination rkContractProjectPagination) {
        List collect;
        Object rkProjectProductObj;
        Object rkContractProjectObj;
        UserInfo userInfo = this.userProvider.get();
        String userId = userInfo.getUserId();
        boolean total = false;
        int rkContractProjectNum = 0;
        QueryWrapper rkContractProjectQueryWrapper = new QueryWrapper();
        int rkProjectProductNum = 0;
        QueryWrapper rkProjectProductQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProjectObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProjectQueryWrapper, rkContractProjectPagination.getMenuId(), "rk_contract_project"));
            if (ObjectUtil.isEmpty((Object)rkContractProjectObj)) {
                return null;
            }
            rkContractProjectQueryWrapper = (QueryWrapper)rkContractProjectObj;
            ++rkContractProjectNum;
            rkProjectProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProjectProductQueryWrapper, rkContractProjectPagination.getMenuId(), "rk_contract_project"));
            if (ObjectUtil.isEmpty((Object)rkProjectProductObj)) {
                return null;
            }
            rkProjectProductQueryWrapper = (QueryWrapper)rkProjectProductObj;
            ++rkProjectProductNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractProjectObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractProjectQueryWrapper, rkContractProjectPagination.getMenuId(), "rk_contract_project"));
            if (ObjectUtil.isEmpty((Object)rkContractProjectObj)) {
                return null;
            }
            rkContractProjectQueryWrapper = (QueryWrapper)rkContractProjectObj;
            ++rkContractProjectNum;
            rkProjectProductObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProjectProductQueryWrapper, rkContractProjectPagination.getMenuId(), "rk_contract_project"));
            if (ObjectUtil.isEmpty((Object)rkProjectProductObj)) {
                return null;
            }
            rkProjectProductQueryWrapper = (QueryWrapper)rkProjectProductObj;
            ++rkProjectProductNum;
        }
        rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getProjectCode())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().like(RkContractProjectEntity::getProjectCode, (Object)rkContractProjectPagination.getProjectCode());
        }
        if (ObjectUtil.isNotEmpty(rkContractProjectPagination.getIncomeType())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().like(RkContractProjectEntity::getIncomeType, rkContractProjectPagination.getIncomeType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getProjectName())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().like(RkContractProjectEntity::getProjectName, (Object)rkContractProjectPagination.getProjectName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getState())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getState, (Object)rkContractProjectPagination.getState());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getProjectHeader())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getProjectHeader, (Object)rkContractProjectPagination.getProjectHeader());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getProjectNature())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getProjectNature, (Object)rkContractProjectPagination.getProjectNature());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getIsAcceptance())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getIsAcceptance, (Object)rkContractProjectPagination.getIsAcceptance());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getCompanyId())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getCompanyId, (Object)rkContractProjectPagination.getCompanyId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectPagination.getCustomerId())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getCustomerId, (Object)rkContractProjectPagination.getCustomerId());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractProjectPagination.getIsUploadAcceptFile())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getIsUploadAcceptFile, (Object)rkContractProjectPagination.getIsUploadAcceptFile());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractProjectPagination.getAcceptIsArchived())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getAcceptIsArchived, (Object)rkContractProjectPagination.getAcceptIsArchived());
        }
        if (!ObjectUtil.isEmpty(rkContractProjectPagination.getSignDate()) || !ObjectUtil.isEmpty((Object)rkContractProjectPagination.getAgentId())) {
            List<RkContractEntity> listBySignDate = this.contractService.getListBySignDateAndAgentId(rkContractProjectPagination.getSignDate(), rkContractProjectPagination.getAgentId());
            if (ObjectUtil.isEmpty(listBySignDate)) {
                return null;
            }
            collect = listBySignDate.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getContractId, collect);
        }
        if (!ObjectUtil.isEmpty(rkContractProjectPagination.getProductList())) {
            List<RkProjectProductEntity> productIdList = this.projectProductService.getListByProductIdList(rkContractProjectPagination.getProductList());
            if (CollectionUtil.isEmpty(productIdList)) {
                return null;
            }
            collect = productIdList.stream().map(RkProjectProductEntity::getProjectId).collect(Collectors.toList());
            rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getId, collect);
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractProjectPagination.getSearchType())) {
            if (StrUtil.equals((CharSequence)rkContractProjectPagination.getSearchType(), (CharSequence)"1")) {
                rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getProjectHeader, (Object)userId);
            }
            if (StrUtil.equals((CharSequence)rkContractProjectPagination.getSearchType(), (CharSequence)"2")) {
                rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getRegionalHead, (Object)userId);
            }
            if (StrUtil.equals((CharSequence)rkContractProjectPagination.getSearchType(), (CharSequence)"3")) {
                rkContractProjectQueryWrapper.lambda().eq(RkContractProjectEntity::getAssistantsUser, (Object)userId);
            }
            if (StrUtil.equals((CharSequence)rkContractProjectPagination.getSearchType(), (CharSequence)"4")) {
                rkContractProjectQueryWrapper.lambda().and(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(RkContractProjectEntity::getProjectHeader, (Object)userId)).or()).eq(RkContractProjectEntity::getSalerId, (Object)userId);
                });
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractProjectPagination.getKeyword())) {
            ++rkContractProjectNum;
            rkContractProjectQueryWrapper.lambda().like(RkContractProjectEntity::getProjectName, (Object)rkContractProjectPagination.getKeyword());
        }
        if (StringUtils.isNotEmpty(rkContractProjectPagination.getCustomerAddress())) {
            QueryWrapper crmCustomerWrapper = new QueryWrapper();
            crmCustomerWrapper.lambda().and(x -> {
                for (List<String> ll : rkContractProjectPagination.getCustomerAddress()) {
                    List addressList = JsonUtil.getJsonToList(ll, String.class);
                    if (addressList.size() > 1) {
                        String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                        collect = "[" + collect;
                        ((LambdaQueryWrapper)x.or()).like(RkContractEntity::getCustomerAddress, (Object)collect);
                        continue;
                    }
                    String s2 = (String)addressList.get(addressList.size() - 1);
                    s2 = "[\"" + s2 + "\"";
                    ((LambdaQueryWrapper)x.or()).like(RkContractEntity::getCustomerAddress, (Object)s2);
                }
            });
            List list = this.rkContractMapper.selectList((Wrapper)crmCustomerWrapper);
            List ids = list.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            if (StringUtils.isNotEmpty(ids)) {
                rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getContractId, ids);
            } else {
                rkContractProjectQueryWrapper.lambda().in(RkContractProjectEntity::getContractId, new Object[]{""});
            }
        }
        return rkContractProjectQueryWrapper;
    }

    @Override
    public List<RkContractProjectEntity> getListByNameLike(String name) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RkContractProjectEntity::getEnabledMark, (Object)1)).like(RkContractProjectEntity::getProjectName, (Object)name.replaceAll("\\s+", ""));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProjectEntity> getListByNameLike(String name, String year) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RkContractProjectEntity::getEnabledMark, (Object)1)).like(RkContractProjectEntity::getProjectName, (Object)name);
        queryWrapper.like(RkContractProjectEntity::getProjectName, (Object)year);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProjectEntity> getProjectInfoByCustomerI(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractProjectEntity::getCustomerId, (Object)id)).eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        return this.rkContractProjectMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public void updateStateEnd() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractProjectEntity::getIsAcceptance, (Object)1)).ne(RkContractProjectEntity::getState, (Object)"end");
        List list = this.list((Wrapper)queryWrapper);
        List endList = CollectionUtil.list((boolean)false);
        for (RkContractProjectEntity entity : list) {
            Date date;
            Date date1;
            RkContractEntity byId = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)entity.getContractId()));
            if (ObjectUtil.isNull((Object)byId) || !ObjectUtil.isNotNull((Object)byId.getWarranty()) || !ObjectUtil.isNotNull((Object)entity.getAcceptanceTime()) || !(date1 = DateUtil.dateAddMonths((Date)(date = DateUtil.dateAddDays((Date)entity.getAcceptanceTime(), (int)1)), (int)byId.getWarranty())).before(DateUtil.getDayBegin())) continue;
            entity.setState(ProjectStateEnum.end_state.getState());
            endList.add(entity);
        }
        if (CollectionUtil.isNotEmpty((Collection)endList)) {
            this.updateBatchById(endList);
        }
    }

    @Override
    public List<RkContractProjectEntity> getListByProjectCode(String projectCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractProjectEntity::getProjectCode, (Object)projectCode)).eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProjectEntity> getListByCustomerIdAndCompanyId(String customerId, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractProjectEntity::getCustomerId, (Object)customerId)).eq(RkContractProjectEntity::getCompanyId, (Object)companyId)).eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public RkProjectTotalVo projectTotalByState(RkContractProjectPagination rkContractProjectPagination) {
        QueryWrapper<RkContractProjectEntity> queryWrapper = this.appendWrapper(rkContractProjectPagination);
        RkProjectTotalVo vo = new RkProjectTotalVo();
        if (Objects.isNull(queryWrapper)) {
            return vo;
        }
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            vo.setProjectSum(list.size());
            BigDecimal sum = list.stream().filter(x -> ObjectUtil.isNotEmpty((Object)x.getProjectAmount())).map(RkContractProjectEntity::getProjectAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setProjectMoney(sum);
            List collect = list.stream().map(RkContractProjectEntity::getId).collect(Collectors.toList());
            QueryWrapper queryWrapper2 = new QueryWrapper();
            queryWrapper2.lambda().in(RkContractProjectCostEntity::getProjectId, collect);
            queryWrapper2.lambda().eq(RkContractProjectCostEntity::getState, (Object)"1");
            List rkContractProjectCostEntities = this.rkContractProjectCostMapper.selectList((Wrapper)queryWrapper2);
            if (CollectionUtil.isNotEmpty((Collection)rkContractProjectCostEntities)) {
                BigDecimal costSum = rkContractProjectCostEntities.stream().map(RkContractProjectCostEntity::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                vo.setProjectSumCost(costSum);
            }
            vo.setProjectProportion(MathUtils.divide(MathUtils.multiply(vo.getProjectSumCost(), new BigDecimal(100)), vo.getProjectMoney(), 8));
        }
        return vo;
    }

    @Override
    public List<RkContractProjectEntity> getListByNoContractId(String noContractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProjectEntity::getNoContractId, (Object)noContractId);
        queryWrapper.lambda().eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProjectEntity> getListByNoContractIdHaveDel(String noContractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractProjectEntity::getNoContractId, (Object)noContractId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void updateUserAll(RkContractProjectEntity entity) {
        this.updateById(entity);
    }

    @Override
    public long countByCustomerId(String customerId, String menuId) {
        Object rkContractObj;
        QueryWrapper projectQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(projectQueryWrapper, menuId, "rk_contract_project"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return 0L;
            }
            projectQueryWrapper = (QueryWrapper)rkContractObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(projectQueryWrapper, menuId, "rk_contract_project"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return 0L;
            }
            projectQueryWrapper = (QueryWrapper)rkContractObj;
        }
        QueryWrapper queryWrapper = projectQueryWrapper;
        queryWrapper.lambda().eq(RkContractProjectEntity::getCustomerId, (Object)customerId);
        queryWrapper.lambda().eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractProjectEntity> rkContractProjectResource(CrmDepartConnectEntity connectEntity) {
        if (StrUtil.isBlank((CharSequence)connectEntity.getObjectId()) || StringUtils.isBlank((CharSequence)connectEntity.getConnectUser())) {
            return new ArrayList<RkContractProjectEntity>();
        }
        List<String> idsList = Arrays.asList(connectEntity.getObjectId().split(","));
        if (CollectionUtil.isNotEmpty(idsList)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(RkContractProjectEntity::getId, idsList);
            List projectEntity = this.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)projectEntity)) {
                projectEntity.forEach(x -> {
                    x.setSalerId(connectEntity.getConnectUser());
                    x.setConnectType(connectEntity.getConnectType());
                    x.setSalerName(this.baseDataUtil.userSelectValueNoAccount(x.getSalerId()));
                    if (StrUtil.isBlank((CharSequence)x.getConnectRecords())) {
                        ArrayList<CrmDepartConnectEntity> connectEntityList = new ArrayList<CrmDepartConnectEntity>();
                        connectEntityList.add(connectEntity);
                        x.setConnectRecords(JSON.toJSONString(connectEntityList));
                    } else {
                        List departConnectEntities = JsonUtil.getJsonToList((String)x.getConnectRecords(), CrmDepartConnectEntity.class);
                        departConnectEntities.add(connectEntity);
                        x.setConnectRecords(JSON.toJSONString((Object)departConnectEntities));
                    }
                });
            }
            this.updateBatchById(projectEntity);
            return projectEntity;
        }
        return new ArrayList<RkContractProjectEntity>();
    }
}

