/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.ConvertUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.CompanyIdEnum;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkReturnPlanSalerEntity;
import com.bringspring.contract.mapper.RkContractReturnPlanMapper;
import com.bringspring.contract.model.countAmount.CountAmountVO;
import com.bringspring.contract.model.rkcontract.RkContractUpForm;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordPagination;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanCrForm;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanPagination;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanUpForm;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkReturnPlanSalerService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.ContractEnableMarkEnum;
import com.bringspring.contract.utils.ContractReturnPlanUilts;
import com.bringspring.contract.utils.EnableMarkEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ReturnPlanEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmDepartConnectEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmDepartConnectService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractReturnPlanServiceImpl
extends ServiceImpl<RkContractReturnPlanMapper, RkContractReturnPlanEntity>
implements RkContractReturnPlanService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkContractPaymentService contractPaymentService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CrmDepartConnectService crmDepartConnectService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkReturnPlanSalerService rkReturnPlanSalerService;
    @Autowired
    private OrganizeService organizeService;

    @Override
    public List<RkContractReturnPlanEntity> getList(RkContractReturnPlanPagination rkContractReturnPlanPagination) {
        String userId = this.userProvider.get().getUserId();
        int total = 0;
        ArrayList AllIdList = new ArrayList();
        QueryWrapper<RkContractReturnPlanEntity> rkContractReturnPlanQueryWrapper = this.getQueryWrapper(rkContractReturnPlanPagination);
        if (ObjectUtil.isNull(rkContractReturnPlanQueryWrapper)) {
            return Collections.emptyList();
        }
        if (AllIdList.size() > 0) {
            rkContractReturnPlanQueryWrapper.lambda().in(RkContractReturnPlanEntity::getId, AllIdList);
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkContractReturnPlanPagination.getCurrentPage(), rkContractReturnPlanPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkContractReturnPlanQueryWrapper);
            return rkContractReturnPlanPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkContractReturnPlanPagination.setData(list, list.size());
    }

    @Override
    public List<RkContractReturnPlanEntity> getTypeList(RkContractReturnPlanPagination rkContractReturnPlanPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper<RkContractReturnPlanEntity> rkContractReturnPlanQueryWrapper = this.getQueryWrapper(rkContractReturnPlanPagination);
        if (ObjectUtil.isNull(rkContractReturnPlanQueryWrapper)) {
            return Collections.emptyList();
        }
        if (AllIdList.size() > 0) {
            rkContractReturnPlanQueryWrapper.lambda().in(RkContractReturnPlanEntity::getId, AllIdList);
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractReturnPlanPagination.getCurrentPage(), rkContractReturnPlanPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractReturnPlanQueryWrapper);
                return rkContractReturnPlanPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractReturnPlanPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractReturnPlanQueryWrapper);
    }

    private QueryWrapper<RkContractReturnPlanEntity> getQueryWrapper(RkContractReturnPlanPagination rkContractReturnPlanPagination) {
        DateTime parse;
        Object rkContractReturnPlanObj;
        QueryWrapper rkContractReturnPlanQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractReturnPlanObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractReturnPlanQueryWrapper, rkContractReturnPlanPagination.getMenuId(), "rk_contract_return_plan"));
            if (ObjectUtil.isEmpty((Object)rkContractReturnPlanObj)) {
                return null;
            }
            rkContractReturnPlanQueryWrapper = (QueryWrapper)rkContractReturnPlanObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractReturnPlanObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractReturnPlanQueryWrapper, rkContractReturnPlanPagination.getMenuId(), "rk_contract_return_plan"));
            if (ObjectUtil.isEmpty((Object)rkContractReturnPlanObj)) {
                return null;
            }
            rkContractReturnPlanQueryWrapper = (QueryWrapper)rkContractReturnPlanObj;
        }
        rkContractReturnPlanQueryWrapper.lambda().eq(RkContractReturnPlanEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        if (StrUtil.isNotEmpty((CharSequence)rkContractReturnPlanPagination.getCompanyId())) {
            rkContractReturnPlanQueryWrapper.lambda().eq(RkContractReturnPlanEntity::getCompanyId, (Object)rkContractReturnPlanPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getCompanyIdList())) {
            rkContractReturnPlanQueryWrapper.lambda().in(RkContractReturnPlanEntity::getCompanyId, rkContractReturnPlanPagination.getCompanyIdList());
        }
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getSalerCompanyIdList())) {
            rkContractReturnPlanQueryWrapper.lambda().in(RkContractReturnPlanEntity::getSalerCompanyId, rkContractReturnPlanPagination.getSalerCompanyIdList());
        }
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getReturnStateList())) {
            rkContractReturnPlanQueryWrapper.lambda().in(RkContractReturnPlanEntity::getReturnState, rkContractReturnPlanPagination.getReturnStateList());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractReturnPlanPagination.getConnectType())) {
            if (rkContractReturnPlanPagination.getConnectType() == 3) {
                rkContractReturnPlanQueryWrapper.lambda().isNull(RkContractReturnPlanEntity::getConnectType);
            } else {
                rkContractReturnPlanQueryWrapper.lambda().eq(RkContractReturnPlanEntity::getConnectType, (Object)rkContractReturnPlanPagination.getConnectType());
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractReturnPlanPagination.getPlanCode())) {
            rkContractReturnPlanQueryWrapper.lambda().like(RkContractReturnPlanEntity::getPlanCode, (Object)rkContractReturnPlanPagination.getPlanCode());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractReturnPlanPagination.getContractId())) {
            rkContractReturnPlanQueryWrapper.lambda().eq(RkContractReturnPlanEntity::getContractId, (Object)rkContractReturnPlanPagination.getContractId());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractReturnPlanPagination.getSalerId())) {
            rkContractReturnPlanQueryWrapper.lambda().eq(RkContractReturnPlanEntity::getSalerId, (Object)rkContractReturnPlanPagination.getSalerId());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractReturnPlanPagination.getCustomerId())) {
            rkContractReturnPlanQueryWrapper.lambda().eq(RkContractReturnPlanEntity::getCustomerId, (Object)rkContractReturnPlanPagination.getCustomerId());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractReturnPlanPagination.getAgentId())) {
            rkContractReturnPlanQueryWrapper.lambda().eq(RkContractReturnPlanEntity::getAgentId, (Object)rkContractReturnPlanPagination.getAgentId());
        }
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getMarkList())) {
            rkContractReturnPlanQueryWrapper.lambda().in(RkContractReturnPlanEntity::getMark, rkContractReturnPlanPagination.getMarkList());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractReturnPlanPagination.getIsAgreement())) {
            rkContractReturnPlanQueryWrapper.lambda().eq(RkContractReturnPlanEntity::getIsAgreement, (Object)rkContractReturnPlanPagination.getIsAgreement());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractReturnPlanPagination.getIsReceive())) {
            rkContractReturnPlanQueryWrapper.lambda().eq(RkContractReturnPlanEntity::getIsReceive, (Object)rkContractReturnPlanPagination.getIsReceive());
        }
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getCreateTime())) {
            parse = DateUtil.parse((CharSequence)(DateUtil.formatDate((Date)rkContractReturnPlanPagination.getCreateTime().get(1)) + " 23:59:59"));
            rkContractReturnPlanQueryWrapper.lambda().between(RkContractReturnPlanEntity::getCreatorTime, (Object)rkContractReturnPlanPagination.getCreateTime().get(0), (Object)parse);
        }
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getDueDateList())) {
            parse = DateUtil.parse((CharSequence)(DateUtil.formatDate((Date)rkContractReturnPlanPagination.getDueDateList().get(1)) + " 23:59:59"));
            rkContractReturnPlanQueryWrapper.lambda().between(RkContractReturnPlanEntity::getDueDate, (Object)rkContractReturnPlanPagination.getDueDateList().get(0), (Object)parse);
        }
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getAgainDateList())) {
            parse = DateUtil.parse((CharSequence)(DateUtil.formatDate((Date)rkContractReturnPlanPagination.getAgainDateList().get(1)) + " 23:59:59"));
            rkContractReturnPlanQueryWrapper.lambda().between(RkContractReturnPlanEntity::getAgainDate, (Object)rkContractReturnPlanPagination.getAgainDateList().get(0), (Object)parse);
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractReturnPlanPagination.getIsImplementHelp())) {
            rkContractReturnPlanQueryWrapper.lambda().eq(RkContractReturnPlanEntity::getIsImplementHelp, (Object)rkContractReturnPlanPagination.getIsImplementHelp());
        }
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getFollowTimeList())) {
            parse = DateUtil.parse((CharSequence)(DateUtil.formatDate((Date)rkContractReturnPlanPagination.getFollowTimeList().get(1)) + " 23:59:59"));
            rkContractReturnPlanQueryWrapper.lambda().between(RkContractReturnPlanEntity::getFollowTime, (Object)rkContractReturnPlanPagination.getFollowTimeList().get(0), (Object)parse);
        }
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getActualDueDateList())) {
            parse = DateUtil.parse((CharSequence)(DateUtil.formatDate((Date)rkContractReturnPlanPagination.getActualDueDateList().get(1)) + " 23:59:59"));
            rkContractReturnPlanQueryWrapper.lambda().between(RkContractReturnPlanEntity::getActualDueDate, (Object)rkContractReturnPlanPagination.getActualDueDateList().get(0), (Object)parse);
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractReturnPlanPagination.getIsHaveFollow())) {
            if (StrUtil.equals((CharSequence)rkContractReturnPlanPagination.getIsHaveFollow(), (CharSequence)"1")) {
                rkContractReturnPlanQueryWrapper.lambda().isNotNull(RkContractReturnPlanEntity::getFollowTime);
            } else {
                rkContractReturnPlanQueryWrapper.lambda().isNull(RkContractReturnPlanEntity::getFollowTime);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractReturnPlanPagination.getDepartment())) {
            List listByOraganizetionId = this.userService.getListByOraganizetionId(rkContractReturnPlanPagination.getDepartment());
            if (CollectionUtil.isEmpty((Collection)listByOraganizetionId)) {
                return null;
            }
            List userIds = listByOraganizetionId.stream().map(UserEntity::getId).collect(Collectors.toList());
            rkContractReturnPlanQueryWrapper.lambda().in(RkContractReturnPlanEntity::getSalerId, userIds);
        }
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getSearchOverdueDateList())) {
            String start = rkContractReturnPlanPagination.getSearchOverdueDateList().get(0);
            String end = rkContractReturnPlanPagination.getSearchOverdueDateList().get(1);
            if (StringUtils.isEmpty((String)start) && StringUtils.isEmpty((String)end)) {
                rkContractReturnPlanQueryWrapper.apply(" ( case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is  null  or actual_due_date >='" + ContractReturnPlanUilts.getCheckIsOverdueStrDate(CompanyIdEnum.MiJIAN.getId()) + "' else  due_date is  null  or  due_date>='" + com.bringspring.common.util.DateUtil.getNow() + "' end or return_state='2' ) ", new Object[0]);
            } else {
                if (StringUtils.isEmpty((String)start)) {
                    rkContractReturnPlanQueryWrapper.apply(" return_state !='2' and ( case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null  and actual_due_date <'" + ContractReturnPlanUilts.getCheckIsOverdueStrDate(CompanyIdEnum.MiJIAN.getId()) + "' else  due_date is not null  and  due_date<'" + com.bringspring.common.util.DateUtil.getNow() + "' end )", new Object[0]);
                } else {
                    rkContractReturnPlanQueryWrapper.apply(" return_state !='2' and ( case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null  and actual_due_date <'" + start + "' else  due_date is not null  and  due_date<'" + start + "' end )", new Object[0]);
                }
                if (StringUtils.isNotEmpty((String)end)) {
                    rkContractReturnPlanQueryWrapper.apply(" return_state !='2' and  ( case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null  and actual_due_date >='" + end + "' else  due_date is not null  and  due_date>='" + end + "' end )", new Object[0]);
                }
            }
        }
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getSearchOverdueDateListMulti())) {
            rkContractReturnPlanQueryWrapper.and(x -> {
                for (List<String> s : rkContractReturnPlanPagination.getSearchOverdueDateListMulti()) {
                    String start = s.get(0);
                    String end = s.get(1);
                    x.or(y -> {
                        if (StringUtils.isEmpty((String)start) && StringUtils.isEmpty((String)end)) {
                            y.apply(" ( case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is  null  or actual_due_date >='" + ContractReturnPlanUilts.getCheckIsOverdueStrDate(CompanyIdEnum.MiJIAN.getId()) + "' else  due_date is  null  or  due_date>='" + com.bringspring.common.util.DateUtil.getNow() + "' end or return_state='2' ) ", new Object[0]);
                        } else {
                            if (StringUtils.isEmpty((String)start)) {
                                y.apply(" return_state !='2' and ( case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null  and actual_due_date <'" + ContractReturnPlanUilts.getCheckIsOverdueStrDate(CompanyIdEnum.MiJIAN.getId()) + "' else  due_date is not null  and  due_date<'" + com.bringspring.common.util.DateUtil.getNow() + "' end )", new Object[0]);
                            } else {
                                y.apply(" return_state !='2' and ( case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null  and actual_due_date <'" + start + "' else  due_date is not null  and  due_date<'" + start + "' end )", new Object[0]);
                            }
                            if (StringUtils.isNotEmpty((String)end)) {
                                y.apply(" return_state !='2' and  ( case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null  and actual_due_date >='" + end + "' else  due_date is not null  and  due_date>='" + end + "' end )", new Object[0]);
                            }
                        }
                    });
                }
            });
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractReturnPlanPagination.getContractCode()) || StrUtil.isNotEmpty((CharSequence)rkContractReturnPlanPagination.getContractName()) || StrUtil.isNotEmpty((CharSequence)rkContractReturnPlanPagination.getContractType()) || CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getSignDate()) || CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getArchivedDate())) {
            RkContractCollectionRecordPagination recordPagination = new RkContractCollectionRecordPagination();
            recordPagination.setContractCode(rkContractReturnPlanPagination.getContractCode());
            recordPagination.setContractName(rkContractReturnPlanPagination.getContractName());
            recordPagination.setContractType(rkContractReturnPlanPagination.getContractType());
            recordPagination.setSignDate(rkContractReturnPlanPagination.getSignDate());
            recordPagination.setArchivedDate(rkContractReturnPlanPagination.getArchivedDate());
            List<RkContractEntity> listBy = this.contractService.getListBy(recordPagination);
            if (CollectionUtil.isEmpty(listBy)) {
                return null;
            }
            List contractIdList = listBy.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            rkContractReturnPlanQueryWrapper.lambda().in(RkContractReturnPlanEntity::getContractId, contractIdList);
        }
        if (ObjectUtil.isNotNull((Object)rkContractReturnPlanPagination.getReceivableAmountBalance())) {
            rkContractReturnPlanQueryWrapper.apply("case when company_id !=9 then (receivable_amount - return_amount) >" + rkContractReturnPlanPagination.getReceivableAmountBalance() + "  when company_id =9 and actual_due_date is not null and  actual_due_date <=now() then (receivable_amount - return_amount) >" + rkContractReturnPlanPagination.getReceivableAmountBalance() + " end ", new Object[0]);
        }
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanPagination.getCustomerAddress())) {
            rkContractReturnPlanPagination.getCustomerAddress().stream().filter(x -> {
                boolean flag = x.size() < 2 && ((String)x.get(0)).equals("10");
                return !flag;
            }).collect(Collectors.toList());
            if (rkContractReturnPlanPagination.getCustomerAddress().size() < 2 && rkContractReturnPlanPagination.getCustomerAddress().get(0).equals("10")) {
                rkContractReturnPlanPagination.setCustomerAddress(null);
            }
        }
        if (StringUtils.isNotEmpty(rkContractReturnPlanPagination.getCustomerAddress())) {
            rkContractReturnPlanQueryWrapper.lambda().and(x -> {
                for (List<String> ll : rkContractReturnPlanPagination.getCustomerAddress()) {
                    List addressList = JsonUtil.getJsonToList(ll, String.class);
                    if (addressList.size() > 1) {
                        String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                        collect = "[" + collect;
                        ((LambdaQueryWrapper)x.or()).like(RkContractReturnPlanEntity::getCustomerAddress, (Object)collect);
                        continue;
                    }
                    String s2 = (String)addressList.get(addressList.size() - 1);
                    s2 = "[\"" + s2 + "\"";
                    ((LambdaQueryWrapper)x.or()).like(RkContractReturnPlanEntity::getCustomerAddress, (Object)s2);
                }
            });
        }
        if (StrUtil.isEmpty((CharSequence)rkContractReturnPlanPagination.getSidx())) {
            rkContractReturnPlanQueryWrapper.lambda().orderByDesc(RkContractReturnPlanEntity::getPlanCode);
        } else {
            try {
                String sidx = rkContractReturnPlanPagination.getSidx();
                if (StrUtil.equals((CharSequence)sidx, (CharSequence)"dueAccountsReceivableBalance")) {
                    if ("asc".equals(rkContractReturnPlanPagination.getSort().toLowerCase())) {
                        rkContractReturnPlanQueryWrapper.orderByAsc((Object)" ( case when company_id =9 and actual_due_date is not null and actual_due_date < NOW() then  RECEIVABLE_AMOUNT - RETURN_AMOUNT  when company_id !=9 and due_date <NOW() then RECEIVABLE_AMOUNT - RETURN_AMOUNT else 1 end)");
                    } else {
                        rkContractReturnPlanQueryWrapper.orderByDesc((Object)"( case when company_id =9 and actual_due_date is not null and actual_due_date < NOW() then  RECEIVABLE_AMOUNT - RETURN_AMOUNT  when company_id !=9 and due_date <NOW() then RECEIVABLE_AMOUNT - RETURN_AMOUNT else 1 end)");
                    }
                } else if (StrUtil.equals((CharSequence)sidx, (CharSequence)"overdueDaysYearDesc")) {
                    if ("asc".equals(rkContractReturnPlanPagination.getSort().toLowerCase())) {
                        rkContractReturnPlanQueryWrapper.orderByAsc((Object)"  case when return_state =2  then 0 else 1 END, case when company_id =9 and actual_due_date is not null then NOW()-actual_due_date when  company_id = 9 and actual_due_date is null then 1 when  company_id !=9 and due_date is null then 1  when  company_id !=9 and due_date is not null then NOW()-due_date else 2 end ");
                    } else {
                        rkContractReturnPlanQueryWrapper.orderByDesc((Object)" case when return_state =2  then 1 else 0 END, case when company_id =9 and actual_due_date is not null then NOW()-actual_due_date when  company_id = 9 and actual_due_date is null then 1 when  company_id !=9 and due_date is null then 1  when  company_id !=9 and due_date is not null then NOW()-due_date else 2 end ");
                    }
                } else {
                    RkContractReturnPlanEntity rkContractReturnPlanEntity = new RkContractReturnPlanEntity();
                    Field declaredField = rkContractReturnPlanEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    rkContractReturnPlanQueryWrapper = "asc".equals(rkContractReturnPlanPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractReturnPlanQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractReturnPlanQueryWrapper.orderByDesc((Object)value);
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return rkContractReturnPlanQueryWrapper;
    }

    @Override
    public RkContractReturnPlanEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractReturnPlanEntity::getId, (Object)id);
        return (RkContractReturnPlanEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkContractReturnPlanEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkContractReturnPlanEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkContractReturnPlanEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    @DSTransactional
    public HashMap createPlan(RkContractReturnPlanCrForm rkContractReturnPlanCrForm) {
        RkContractPaymentEntity byId1;
        HashMap map = MapUtil.newHashMap();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractReturnPlanEntity::getContractId, (Object)rkContractReturnPlanCrForm.getContractId());
        List list = this.list((Wrapper)queryWrapper);
        BigDecimal reduce = list.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getReceivableAmount())).map(RkContractReturnPlanEntity::getReceivableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        String add = MathUtils.add(reduce.toString(), rkContractReturnPlanCrForm.getReceivableAmount());
        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractReturnPlanCrForm.getContractId()));
        if (new BigDecimal(add).compareTo(byId.getContractAmount()) == 1) {
            map.put("error", "\u56de\u6b3e\u8ba1\u5212\u603b\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u603b\u91d1\u989d");
            return map;
        }
        String mainId = RandomUtil.uuId();
        RkContractReturnPlanEntity entity = (RkContractReturnPlanEntity)JsonUtil.getJsonToBean((Object)rkContractReturnPlanCrForm, RkContractReturnPlanEntity.class);
        Date date = com.bringspring.common.util.DateUtil.dateAddMonths((Date)entity.getDueDate(), (int)Constants.RETURN_DEADLINE_ADD_MONTH);
        entity.setReturnDeadline(date);
        entity.setId(mainId);
        entity.setContractCode(byId.getContractCode());
        entity.setCompanyId(byId.getCompanyId());
        entity.setContractSalerCompanyId(byId.getSalerCompanyId());
        entity.setSalerPlatFormCompanyId(byId.getSalerPlatFormCompanyId());
        entity.setSalerCompanyId(byId.getSalerCompanyId());
        if (StrUtil.isNotEmpty((CharSequence)entity.getProjectId())) {
            RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()));
            entity.setCustomerId(ObjectUtil.isNotNull((Object)projectEntity) ? projectEntity.getCustomerId() : byId.getCustomerId());
        } else {
            entity.setCustomerId(byId.getCustomerId());
        }
        CrmCustomerEntity customerEntity = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()));
        entity.setAgentId(byId.getAgentId());
        entity.setReturnState(ReturnPlanEnum.NOT_START.getState());
        entity.setSalerId(byId.getSalerId());
        entity.setSalerName(byId.getSalerName());
        entity.setContractSaler(byId.getSalerName());
        entity.setContractSalerId(byId.getSalerId());
        entity.setInvoiceAmount(BigDecimal.ZERO);
        entity.setFreezeInvoicingAmount(BigDecimal.ZERO);
        entity.setRemainingInvoicedAmount(entity.getReceivableAmount());
        if (ObjectUtil.isNotNull((Object)customerEntity)) {
            entity.setCustomerAddress(customerEntity.getAddress());
            entity.setCustomerAddressName(this.baseDataUtil.provinceData(entity.getCustomerAddress()));
            String[] split = customerEntity.getAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    entity.setCustomerRegion(split[0]);
                    entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
                }
                if (i == 1) {
                    entity.setCustomerProv(split[1]);
                    entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
                }
                if (i != 2) continue;
                entity.setCustomerCity(split[2]);
                entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
            }
        }
        this.save(entity);
        if (!ObjectUtil.isEmpty((Object)byId.getIsChangeNow()) && byId.getIsChangeNow() == 1 && new BigDecimal(add).compareTo(byId.getContractAmount()) == 0) {
            byId.setIsChangeNow(0);
            this.contractService.updateById(byId);
        }
        List attachmentEntityList = CollectionUtil.list((boolean)false);
        if (CollectionUtil.isNotEmpty(rkContractReturnPlanCrForm.getProjectList())) {
            rkContractReturnPlanCrForm.getProjectList().stream().forEach(project -> {
                if (CollectionUtil.isNotEmpty(project.getAttachmentList())) {
                    project.getAttachmentList().stream().forEach(attach -> {
                        RkAttachmentEntity attachmentEntity = (RkAttachmentEntity)JsonUtil.getJsonToBean((Object)attach, RkAttachmentEntity.class);
                        attachmentEntity.setContractId(rkContractReturnPlanCrForm.getContractId());
                        attachmentEntity.setFileType(AttachmentTypeEnum.RETURN_PLAN_TYPE.getType());
                        attachmentEntity.setPlanId(mainId);
                        attachmentEntity.setProjectId(project.getId());
                        attachmentEntityList.add(attachmentEntity);
                    });
                }
            });
        }
        if (CollectionUtil.isNotEmpty((Collection)attachmentEntityList)) {
            this.attachmentService.saveBatch(attachmentEntityList);
        }
        if (!ObjectUtil.isEmpty((Object)rkContractReturnPlanCrForm.getPaymentId()) && !ObjectUtil.isEmpty((Object)(byId1 = (RkContractPaymentEntity)this.contractPaymentService.getById((Serializable)((Object)rkContractReturnPlanCrForm.getPaymentId()))))) {
            byId1.setPlanId(rkContractReturnPlanCrForm.getId());
            this.contractPaymentService.update(rkContractReturnPlanCrForm.getPaymentId(), byId1);
        }
        if (!ObjectUtil.isEmpty((Object)rkContractReturnPlanCrForm.getSendAmount()) && MathUtils.toBigDecimal(rkContractReturnPlanCrForm.getSendAmount()).compareTo(BigDecimal.ZERO) == 1) {
            if (ObjectUtil.isEmpty((Object)byId.getSendAmount())) {
                byId.setSendAmount(MathUtils.toBigDecimal(rkContractReturnPlanCrForm.getSendAmount()));
            } else {
                byId.setSendAmount(byId.getSendAmount().add(MathUtils.toBigDecimal(rkContractReturnPlanCrForm.getSendAmount())));
            }
            this.contractService.updateById(byId);
        }
        return map;
    }

    @Override
    public List<RkContractReturnPlanEntity> getPlanByContractId(String contractId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(RkContractReturnPlanEntity::getContractId, (Object)contractId)).eq(RkContractReturnPlanEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark())).orderByAsc(RkContractReturnPlanEntity::getDueDate);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getPlanByProjectId(String projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(RkContractReturnPlanEntity::getProjectId, (Object)projectId)).eq(RkContractReturnPlanEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getPlanByContractIdAndProjectId(String contractId, String projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(RkContractReturnPlanEntity::getContractId, (Object)contractId)).eq(RkContractReturnPlanEntity::getProjectId, (Object)projectId)).eq(RkContractReturnPlanEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark())).orderByAsc(RkContractReturnPlanEntity::getDueDate);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getPlanByContractIdAndProjectIdIsNull(String contractId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(RkContractReturnPlanEntity::getContractId, (Object)contractId)).eq(RkContractReturnPlanEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark())).isNull(RkContractReturnPlanEntity::getProjectId)).orderByAsc(RkContractReturnPlanEntity::getDueDate);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getPlanByContractCode(String contractCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(RkContractReturnPlanEntity::getContractCode, (Object)contractCode)).eq(RkContractReturnPlanEntity::getEnabledMark, (Object)EnableMarkEnum.NORMAL.getEnableMark())).orderByAsc(RkContractReturnPlanEntity::getDueDate);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public HashMap updatePlan(List<RkContractReturnPlanUpForm> list) {
        RkContractEntity byId;
        HashMap map = MapUtil.newHashMap();
        BigDecimal reduce = list.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getReceivableAmount())).map(RkContractReturnPlanUpForm::getReceivableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        List collect = list.stream().filter(x -> {
            if (ObjectUtil.isEmpty((Object)x.getReceivableAmount())) {
                return true;
            }
            if (ObjectUtil.isEmpty((Object)x.getReturnAmount())) {
                return false;
            }
            int i = x.getReceivableAmount().compareTo(x.getReturnAmount());
            return i < 0;
        }).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(collect)) {
            map.put("error", "\u5b58\u5728\u5e94\u6536\u6b3e\u91d1\u989d\u5c0f\u4e8e\u5df2\u6536\u6b3e\u91d1\u989d\u6216\u8005\u5e94\u6536\u6b3e\u91d1\u989d\u4e3a\u7a7a\u7684\u60c5\u51b5");
            return map;
        }
        List idList = list.stream().map(RkContractReturnPlanUpForm::getId).collect(Collectors.toList());
        List<RkContractReturnPlanEntity> planByContractId = this.getPlanByContractId(list.get(0).getContractId());
        BigDecimal otherAmount = planByContractId.stream().filter(plan -> !idList.contains(plan.getId())).map(RkContractReturnPlanEntity::getReceivableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmount = MathUtils.add(otherAmount, reduce);
        if (totalAmount.compareTo((byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)list.get(0).getContractId()))).getContractAmount()) == 1) {
            map.put("error", "\u603b\u5e94\u6536\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5408\u540c\u989d");
            return map;
        }
        if (!ObjectUtil.isEmpty((Object)byId.getIsChangeNow()) && byId.getIsChangeNow() == 1 && reduce.compareTo(byId.getContractAmount()) == 0) {
            byId.setIsChangeNow(0);
            this.contractService.updateById(byId);
        }
        List jsonToList = JsonUtil.getJsonToList(list, RkContractReturnPlanEntity.class);
        for (RkContractReturnPlanEntity entity : jsonToList) {
            entity.setReturnDeadline(com.bringspring.common.util.DateUtil.dateAddMonths((Date)entity.getDueDate(), (int)Constants.RETURN_DEADLINE_ADD_MONTH));
            if (!ObjectUtil.isEmpty((Object)entity.getReceivableAmount()) && !ObjectUtil.isEmpty((Object)entity.getReturnAmount())) {
                String multiply = MathUtils.multiply(entity.getReturnAmount().toString(), "100");
                String divide = MathUtils.divide(multiply, entity.getReceivableAmount().toString(), 2);
                entity.setReturnRate(divide);
                int i = new BigDecimal(divide.toString()).compareTo(new BigDecimal(100));
                if (i >= 0) {
                    entity.setReturnState(ReturnPlanEnum.END.getState());
                }
                BigDecimal multiply1 = MathUtils.multiply(entity.getReceivableAmount(), new BigDecimal(100));
                String divide1 = MathUtils.divide(multiply1.toString(), byId.getContractAmount().toString(), 2);
                entity.setPaymentRatio(new BigDecimal(divide1));
            }
            BigDecimal newSendAmount = ObjectUtil.isEmpty((Object)entity.getSendAmount()) ? BigDecimal.ZERO : entity.getSendAmount();
            BigDecimal oldSendAmount = ((RkContractReturnPlanEntity)this.getById((Serializable)((Object)entity.getId()))).getSendAmount();
            BigDecimal subtract = newSendAmount.subtract(oldSendAmount = ObjectUtil.isEmpty((Object)oldSendAmount) ? BigDecimal.ZERO : oldSendAmount);
            if (BigDecimal.ZERO.compareTo(subtract) != 0) {
                RkContractEntity contractEntity = (RkContractEntity)this.contractService.getById((Serializable)((Object)entity.getContractId()));
                BigDecimal returnSendAmount = MathUtils.add2(contractEntity.getSendAmount() + "", subtract + "");
                contractEntity.setSendAmount(MathUtils.toBigDecimal(returnSendAmount));
                this.contractService.updateById(contractEntity);
            }
            entity.setAgentId(byId.getAgentId());
        }
        this.saveOrUpdateBatch(jsonToList);
        return map;
    }

    @Override
    @DSTransactional
    public HashMap deleteBatch(List<String> idList) {
        BigDecimal bigDecimal;
        HashMap map = MapUtil.newHashMap();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(RkContractReturnPlanEntity::getId, idList);
        List list = this.list((Wrapper)queryWrapper);
        List collect = list.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getReturnState()) && x.getReturnState() != ReturnPlanEnum.NOT_START.getState()).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(collect)) {
            map.put("error", "\u5b58\u5728\u5df2\u7ecf\u52fe\u5151\u8fc7\u56de\u6b3e\u8bb0\u5f55\u7684\u56de\u6b3e\u8ba1\u5212,\u4e0d\u80fd\u5220\u9664");
            return map;
        }
        List ll = list.stream().filter(s -> !ObjectUtil.isEmpty((Object)s.getSendAmount())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(ll) && (bigDecimal = ll.stream().map(RkContractReturnPlanEntity::getSendAmount).reduce(BigDecimal::add).get()).compareTo(BigDecimal.ZERO) == 1) {
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)((RkContractReturnPlanEntity)list.get(0)).getContractId()));
            byId.setSendAmount(MathUtils.substract2(byId.getSendAmount() + "", bigDecimal + ""));
            this.contractService.updateById(byId);
        }
        this.removeBatchByIds(idList);
        return map;
    }

    @Override
    public List<RkContractReturnPlanEntity> getListByIdList(List<String> idList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(RkContractReturnPlanEntity::getId, idList);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getPlanAndStateAndEndDueTime(List<String> contractIdList, Date dueTime) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().ne(RkContractReturnPlanEntity::getReturnState, (Object)ReturnPlanEnum.END.getState())).in(RkContractReturnPlanEntity::getContractId, contractIdList)).eq(RkContractReturnPlanEntity::getDueDate, (Object)dueTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public RkContractReturnPlanEntity getOverdueMax(List<String> contractIdList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().in(RkContractReturnPlanEntity::getContractId, contractIdList)).orderByAsc(RkContractReturnPlanEntity::getDueDate);
        return (RkContractReturnPlanEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getListOverdueType(Integer isOverdue) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (isOverdue == 1) {
            ((LambdaQueryWrapper)queryWrapper.lambda().ne(RkContractReturnPlanEntity::getReturnState, (Object)ReturnPlanEnum.END.getState())).lt(RkContractReturnPlanEntity::getDueDate, (Object)com.bringspring.common.util.DateUtil.getDayBegin());
        }
        if (isOverdue == 0) {
            queryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(RkContractReturnPlanEntity::getReturnState, (Object)ReturnPlanEnum.END.getState())).or()).ge(RkContractReturnPlanEntity::getDueDate, (Object)com.bringspring.common.util.DateUtil.getDayBegin()));
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getListOverdueType() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().ne(RkContractReturnPlanEntity::getReturnState, (Object)ReturnPlanEnum.END.getState())).lt(RkContractReturnPlanEntity::getDueDate, (Object)com.bringspring.common.util.DateUtil.getDayBegin());
        List<RkContractEntity> listByEnableMark = this.contractService.getListByEnableMark(ContractEnableMarkEnum.ENABLE_COMPLETED.getEnableMark());
        if (CollectionUtil.isNotEmpty(listByEnableMark)) {
            List collect = listByEnableMark.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            queryWrapper.lambda().notIn(RkContractReturnPlanEntity::getContractId, collect);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getListOverdueTypeByCompanyId(String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractReturnPlanEntity::getCompanyId, (Object)companyId)).ne(RkContractReturnPlanEntity::getReturnState, (Object)ReturnPlanEnum.END.getState())).lt(RkContractReturnPlanEntity::getDueDate, (Object)com.bringspring.common.util.DateUtil.getDayBegin());
        List<RkContractEntity> listByEnableMark = this.contractService.getListByEnableMark(ContractEnableMarkEnum.ENABLE_COMPLETED.getEnableMark());
        if (CollectionUtil.isNotEmpty(listByEnableMark)) {
            List collect = listByEnableMark.stream().map(RkContractEntity::getId).collect(Collectors.toList());
            queryWrapper.lambda().notIn(RkContractReturnPlanEntity::getContractId, collect);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getListOverdueTypeByContractIdAndCompanyId(String contractId, String companyId, RkContractEntity entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractReturnPlanEntity::getContractId, (Object)contractId)).ne(RkContractReturnPlanEntity::getReturnState, (Object)ReturnPlanEnum.END.getState())).lt(RkContractReturnPlanEntity::getDueDate, (Object)com.bringspring.common.util.DateUtil.getDayBegin());
        if (ObjectUtil.isNotEmpty((Object)entity) && StrUtil.equals((CharSequence)entity.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_COMPLETED.getEnableMark())) {
            return new ArrayList<RkContractReturnPlanEntity>();
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getListByNotFollowOneMonth(Date date) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().apply("follow_time + interval 30 day < {0}", new Object[]{date});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getListByTwoWeekNextFollowDate(Date date) {
        Date tomorrow = com.bringspring.common.util.DateUtil.dateAddDays((Date)date, (int)1);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.apply("DATE_SUB(again_date, INTERVAL 14 DAY) > {0}", new Object[]{date})).apply("DATE_SUB(again_date, INTERVAL 14 DAY) < {0}", new Object[]{tomorrow});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getListByOneWeekNextFollowDate(Date date) {
        Date tomorrow = com.bringspring.common.util.DateUtil.dateAddDays((Date)date, (int)1);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.apply("DATE_SUB(again_date, INTERVAL 7 DAY) > {0}", new Object[]{date})).apply("DATE_SUB(again_date, INTERVAL 7 DAY) < {0}", new Object[]{tomorrow});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getListByThreeDaysNextFollowDate(Date date) {
        Date tomorrow = com.bringspring.common.util.DateUtil.dateAddDays((Date)date, (int)1);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.apply("DATE_SUB(again_date, INTERVAL 3 DAY) > {0}", new Object[]{date})).apply("DATE_SUB(again_date, INTERVAL 3 DAY) < {0}", new Object[]{tomorrow});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getListByTwoDaysNextFollowDate(Date date) {
        Date tomorrow = com.bringspring.common.util.DateUtil.dateAddDays((Date)date, (int)1);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.apply("DATE_SUB(again_date, INTERVAL 2 DAY) > {0}", new Object[]{date})).apply("DATE_SUB(again_date, INTERVAL 2 DAY) < {0}", new Object[]{tomorrow});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getListByOneDaysNextFollowDate(Date date) {
        Date tomorrow = com.bringspring.common.util.DateUtil.dateAddDays((Date)date, (int)1);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.apply("DATE_SUB(again_date, INTERVAL 1 DAY) > {0}", new Object[]{date})).apply("DATE_SUB(again_date, INTERVAL 1 DAY) < {0}", new Object[]{tomorrow});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractReturnPlanEntity> getListByMoreThanAgainDate(Date date) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.apply("{0} < {1}", new Object[]{"again_date", date});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> countSendAmount(CountAmountVO countAmountVO) {
        Map map1;
        Map map = MapUtil.newHashMap();
        map.put("totalSendAmount", "0");
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)countAmountVO.getCompanyId())) {
            queryWrapper.lambda().eq(RkContractReturnPlanEntity::getCompanyId, (Object)countAmountVO.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(countAmountVO.getSearchDate())) {
            queryWrapper.lambda().between(RkContractReturnPlanEntity::getSendDate, (Object)countAmountVO.getSearchDate().get(0), (Object)countAmountVO.getSearchDate().get(1));
        }
        if (!ObjectUtil.isEmpty((Object)(map1 = this.getMap((Wrapper)queryWrapper)))) {
            map = map1;
        }
        return map;
    }

    @Override
    public Map<String, Object> countSendAmountByContractIdList(CountAmountVO countAmountVO) {
        Map map1;
        Map map = MapUtil.newHashMap();
        map.put("totalSendAmount", "0");
        if (CollectionUtil.isEmpty(countAmountVO.getContractIdList())) {
            return map;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(RkContractReturnPlanEntity::getContractId, countAmountVO.getContractIdList());
        if (CollectionUtil.isNotEmpty(countAmountVO.getSearchDate())) {
            queryWrapper.lambda().between(RkContractReturnPlanEntity::getSendDate, (Object)countAmountVO.getSearchDate().get(0), (Object)countAmountVO.getSearchDate().get(1));
        }
        if (!ObjectUtil.isEmpty((Object)(map1 = this.getMap((Wrapper)queryWrapper)))) {
            map = map1;
        }
        return map;
    }

    @Override
    public Map<String, Object> countOverdueAmount(CountAmountVO countAmountVO) {
        HashMap map = MapUtil.newHashMap();
        map.put("totalArrearsAmount", "0");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().in(RkContractReturnPlanEntity::getCompanyId, new Object[]{countAmountVO.getCompanyId()})).ne(RkContractReturnPlanEntity::getReturnState, (Object)ReturnPlanEnum.END.getState());
        queryWrapper.apply("case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null and actual_due_date <'" + ContractReturnPlanUilts.getCheckIsOverdueStrDate(CompanyIdEnum.MiJIAN.getId()) + "' else  due_date is not null and due_date<'" + com.bringspring.common.util.DateUtil.getDayBegin() + "' end", new Object[0]);
        List planList = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)planList)) {
            BigDecimal arrearsAmount = planList.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
            map.put("totalArrearsAmount", arrearsAmount);
        }
        return map;
    }

    @Override
    public Map<String, Object> countOverdueAmountByContractIdListOrPlan(RkContractReturnPlanPagination rkContractReturnPlanPagination) {
        String key = StringUtils.isNotEmpty((String)rkContractReturnPlanPagination.getKey()) ? rkContractReturnPlanPagination.getKey() : "totalArrearsAmount";
        HashMap map = MapUtil.newHashMap();
        map.put(key, "0");
        QueryWrapper<RkContractReturnPlanEntity> queryWrapper = this.getQueryWrapper(rkContractReturnPlanPagination);
        if (ObjectUtil.isNull(queryWrapper)) {
            return map;
        }
        if (StrUtil.equals((CharSequence)rkContractReturnPlanPagination.getSearchType(), (CharSequence)"contract")) {
            if (CollectionUtil.isEmpty(rkContractReturnPlanPagination.getContractIdList())) {
                return map;
            }
            queryWrapper.lambda().in(RkContractReturnPlanEntity::getContractId, rkContractReturnPlanPagination.getContractIdList());
        }
        queryWrapper.lambda().ne(RkContractReturnPlanEntity::getReturnState, (Object)ReturnPlanEnum.END.getState());
        if (StringUtils.isNotEmpty((String)rkContractReturnPlanPagination.getCompanyId())) {
            queryWrapper.lambda().eq(RkContractReturnPlanEntity::getCompanyId, (Object)rkContractReturnPlanPagination.getCompanyId());
        }
        if (CollectionUtil.isEmpty(rkContractReturnPlanPagination.getOverdueDateList())) {
            queryWrapper.apply("  return_state !='2' and ( case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null  and actual_due_date <'" + ContractReturnPlanUilts.getCheckIsOverdueStrDate(CompanyIdEnum.MiJIAN.getId()) + "' else  due_date is not null  and  due_date<'" + com.bringspring.common.util.DateUtil.getNow() + "' end )", new Object[0]);
        } else {
            String start = rkContractReturnPlanPagination.getOverdueDateList().get(0);
            String end = rkContractReturnPlanPagination.getOverdueDateList().get(1);
            if (StringUtils.isEmpty((String)start)) {
                queryWrapper.apply("  return_state !='2' and ( case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null  and actual_due_date <'" + ContractReturnPlanUilts.getCheckIsOverdueStrDate(CompanyIdEnum.MiJIAN.getId()) + "' else  due_date is not null  and  due_date<'" + com.bringspring.common.util.DateUtil.getNow() + "' end )", new Object[0]);
            } else {
                queryWrapper.apply("  return_state !='2' and ( case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null  and actual_due_date <'" + start + "' else  due_date is not null  and  due_date<'" + start + "' end )", new Object[0]);
            }
            if (StringUtils.isNotEmpty((String)end)) {
                queryWrapper.apply("  return_state !='2' and ( case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null  and actual_due_date >='" + end + "' else  due_date is not null  and  due_date>='" + end + "' end )", new Object[0]);
            }
        }
        List planList = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)planList)) {
            BigDecimal arrearsAmount = planList.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
            map.put(key, arrearsAmount);
        }
        return map;
    }

    private QueryWrapper<RkContractReturnPlanEntity> appendCountWrapper(CountAmountVO countAmountVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object rkContractReturnPlanObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, countAmountVO.getMenuId(), "rk_contract_return_plan"));
            if (ObjectUtil.isEmpty((Object)rkContractReturnPlanObj)) {
                return null;
            }
            queryWrapper = (QueryWrapper)rkContractReturnPlanObj;
        }
        return queryWrapper;
    }

    @Override
    public Map<String, Object> countAmountOfDueReceivablesByContractIdListOrPlan(RkContractReturnPlanPagination rkContractReturnPlanPagination) {
        HashMap map = MapUtil.newHashMap();
        map.put("totalAmountOfDueReceivables", "0");
        map.put("balanceAmountOfDueReceivables", "0");
        QueryWrapper<RkContractReturnPlanEntity> queryWrapper = this.getQueryWrapper(rkContractReturnPlanPagination);
        if (ObjectUtil.isNull(queryWrapper)) {
            return map;
        }
        if (StrUtil.equals((CharSequence)rkContractReturnPlanPagination.getSearchType(), (CharSequence)"contract")) {
            if (CollectionUtil.isEmpty(rkContractReturnPlanPagination.getContractIdList())) {
                return map;
            }
            queryWrapper.lambda().in(RkContractReturnPlanEntity::getContractId, rkContractReturnPlanPagination.getContractIdList());
        }
        if (StringUtils.isNotEmpty((String)rkContractReturnPlanPagination.getCompanyId())) {
            queryWrapper.lambda().eq(RkContractReturnPlanEntity::getCompanyId, (Object)rkContractReturnPlanPagination.getCompanyId());
        }
        if (StrUtil.equals((CharSequence)rkContractReturnPlanPagination.getSearchType(), (CharSequence)"plan")) {
            // empty if block
        }
        queryWrapper.apply("  case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null and actual_due_date <'" + com.bringspring.common.util.DateUtil.getNow() + "' else  due_date is not null and due_date<'" + com.bringspring.common.util.DateUtil.getNow() + "' end", new Object[0]);
        List planList = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)planList)) {
            BigDecimal amountOfDueReceivables = planList.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount()), BigDecimal::add);
            map.put("totalAmountOfDueReceivables", amountOfDueReceivables);
            BigDecimal returnAmount = planList.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReturnAmount()), BigDecimal::add);
            map.put("balanceAmountOfDueReceivables", MathUtils.substract(amountOfDueReceivables, returnAmount));
        }
        return map;
    }

    @Override
    public Map<String, Object> countReceivableAmountByContractIdListOrPlan(RkContractReturnPlanPagination rkContractReturnPlanPagination) {
        List planList;
        HashMap map = MapUtil.newHashMap();
        map.put("totalReceivableAmount", "0");
        map.put("balanceReceivableAmount", "0");
        map.put("totalReturnAmount", "0");
        QueryWrapper<RkContractReturnPlanEntity> queryWrapper = this.getQueryWrapper(rkContractReturnPlanPagination);
        if (ObjectUtil.isNull(queryWrapper)) {
            return map;
        }
        if (StrUtil.equals((CharSequence)rkContractReturnPlanPagination.getSearchType(), (CharSequence)"contract")) {
            if (CollectionUtil.isEmpty(rkContractReturnPlanPagination.getContractIdList())) {
                return map;
            }
            queryWrapper.lambda().in(RkContractReturnPlanEntity::getContractId, rkContractReturnPlanPagination.getContractIdList());
        }
        if (StringUtils.isNotEmpty((String)rkContractReturnPlanPagination.getCompanyId())) {
            queryWrapper.lambda().eq(RkContractReturnPlanEntity::getCompanyId, (Object)rkContractReturnPlanPagination.getCompanyId());
        }
        if (StrUtil.equals((CharSequence)rkContractReturnPlanPagination.getSearchType(), (CharSequence)"plan")) {
            queryWrapper.apply("  case when company_id ='" + CompanyIdEnum.MiJIAN.getId() + "' then actual_due_date is not null   else  due_date is not null  end", new Object[0]);
        }
        if (CollectionUtil.isNotEmpty((Collection)(planList = this.list((Wrapper)queryWrapper)))) {
            BigDecimal receivableAmount = planList.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount()), BigDecimal::add);
            map.put("totalReceivableAmount", receivableAmount);
            BigDecimal returnAmount = planList.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReturnAmount()), BigDecimal::add);
            map.put("balanceReceivableAmount", MathUtils.substract(receivableAmount, returnAmount));
            map.put("totalReturnAmount", returnAmount);
        }
        return map;
    }

    @Override
    public boolean updateAgentAndCustomer(String agentId, String customerId, String contractId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractReturnPlanEntity::getAgentId, (Object)agentId)).set(RkContractReturnPlanEntity::getCustomerId, (Object)customerId)).eq(RkContractReturnPlanEntity::getContractId, (Object)contractId);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public long countByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractReturnPlanEntity::getContractId, (Object)contractId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateByChange(RkContractUpForm rkContractUpForm) {
        BigDecimal amount;
        String contractId = rkContractUpForm.getId();
        List<RkContractReturnPlanEntity> planByContractId = this.getPlanByContractId(contractId);
        if (CollectionUtil.isNotEmpty(planByContractId) && (amount = ConvertUtil.toBigDecimal((Object)rkContractUpForm.getContractAmount(), (BigDecimal)BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) != 0) {
            String agentId = rkContractUpForm.getAgentId();
            String customerId = rkContractUpForm.getCustomerId();
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)contractId));
            planByContractId.stream().forEach(plan -> {
                plan.setAgentId(agentId);
                plan.setCustomerId(customerId);
                BigDecimal multiply = MathUtils.multiply(plan.getReceivableAmount(), new BigDecimal(100));
                BigDecimal divide = MathUtils.divide(multiply, amount, 2);
                plan.setPaymentRatio(divide);
                BigDecimal multiply2 = MathUtils.multiply(plan.getReturnAmount(), new BigDecimal(100));
                BigDecimal divide2 = MathUtils.divide(multiply2, amount, 2);
                plan.setReturnRate(divide2.toString());
            });
            this.updateBatchById(planByContractId);
        }
        return true;
    }

    @Override
    public List<RkContractReturnPlanEntity> connectReturnMoney(CrmDepartConnectEntity connectEntity) {
        if (StrUtil.isBlank((CharSequence)connectEntity.getObjectId()) || StringUtils.isBlank((CharSequence)connectEntity.getConnectUser())) {
            return new ArrayList<RkContractReturnPlanEntity>();
        }
        List<String> idsList = Arrays.asList(connectEntity.getObjectId().split(","));
        if (CollectionUtil.isNotEmpty(idsList)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(RkContractReturnPlanEntity::getId, idsList);
            List contactsEntities = this.list((Wrapper)queryWrapper);
            ArrayList planSalerEntityList = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)contactsEntities)) {
                contactsEntities.forEach(x -> {
                    String userCompany = this.userService.getUserCompany(connectEntity.getConnectUser());
                    RkReturnPlanSalerEntity entity = new RkReturnPlanSalerEntity();
                    entity.setId(RandomUtil.uuId());
                    entity.setBeforeSaler(x.getSalerId());
                    entity.setBeforeSalerName(x.getSalerName());
                    entity.setSalerId(connectEntity.getConnectUser());
                    entity.setSalerName(this.baseDataUtil.userSelectValues(connectEntity.getConnectUser()));
                    entity.setCompanyId(userCompany);
                    entity.setPlanId(x.getId());
                    planSalerEntityList.add(entity);
                    x.setSalerId(connectEntity.getConnectUser());
                    x.setSalerName(this.baseDataUtil.userSelectValue(connectEntity.getConnectUser()));
                    x.setSalerCompanyId(userCompany);
                    x.setConnectType(connectEntity.getConnectType());
                    if (StrUtil.isBlank((CharSequence)x.getConnectRecords())) {
                        ArrayList<CrmDepartConnectEntity> connectEntityList = new ArrayList<CrmDepartConnectEntity>();
                        connectEntityList.add(connectEntity);
                        x.setConnectRecords(JSON.toJSONString(connectEntityList));
                    } else {
                        List departConnectEntities = JsonUtil.getJsonToList((String)x.getConnectRecords(), CrmDepartConnectEntity.class);
                        departConnectEntities.add(connectEntity);
                        x.setConnectRecords(JSON.toJSONString((Object)departConnectEntities));
                    }
                });
            }
            this.rkReturnPlanSalerService.saveBatch(planSalerEntityList);
            this.updateBatchById(contactsEntities);
            return contactsEntities;
        }
        return new ArrayList<RkContractReturnPlanEntity>();
    }
}

