/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractSendRecordEntity;
import com.bringspring.contract.mapper.RkContractSendRecordMapper;
import com.bringspring.contract.model.rkcontractsendrecord.RkContractSendRecordCrForm;
import com.bringspring.contract.model.rkcontractsendrecord.RkContractSendRecordPagination;
import com.bringspring.contract.service.RkContractSendRecordService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractSendRecordServiceImpl
extends ServiceImpl<RkContractSendRecordMapper, RkContractSendRecordEntity>
implements RkContractSendRecordService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractService contractService;

    @Override
    public List<RkContractSendRecordEntity> getList(RkContractSendRecordPagination rkContractSendRecordPagination) {
        Object rkContractSendRecordObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractSendRecordNum = 0;
        QueryWrapper rkContractSendRecordQueryWrapper = new QueryWrapper();
        rkContractSendRecordQueryWrapper.lambda().eq(RkContractSendRecordEntity::getEnabledMark, (Object)1);
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractSendRecordObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractSendRecordQueryWrapper, rkContractSendRecordPagination.getMenuId(), "rkContractSendRecord"));
            if (ObjectUtil.isEmpty((Object)rkContractSendRecordObj)) {
                return new ArrayList<RkContractSendRecordEntity>();
            }
            rkContractSendRecordQueryWrapper = (QueryWrapper)rkContractSendRecordObj;
            ++rkContractSendRecordNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractSendRecordObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractSendRecordQueryWrapper, rkContractSendRecordPagination.getMenuId(), "rkContractSendRecord"));
            if (ObjectUtil.isEmpty((Object)rkContractSendRecordObj)) {
                return new ArrayList<RkContractSendRecordEntity>();
            }
            rkContractSendRecordQueryWrapper = (QueryWrapper)rkContractSendRecordObj;
            ++rkContractSendRecordNum;
        }
        if (ObjectUtil.isNotEmpty(rkContractSendRecordPagination.getCreatorTime())) {
            ++rkContractSendRecordNum;
            List<String> CreatorTimeList = rkContractSendRecordPagination.getCreatorTime();
            Long fir = Long.valueOf(CreatorTimeList.get(0));
            Long sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)rkContractSendRecordQueryWrapper.lambda().ge(RkContractSendRecordEntity::getCreatorTime, (Object)new Date(fir))).le(RkContractSendRecordEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractSendRecordPagination.getSendAmount())) {
            ++rkContractSendRecordNum;
            rkContractSendRecordQueryWrapper.lambda().like(RkContractSendRecordEntity::getSendAmount, (Object)rkContractSendRecordPagination.getSendAmount());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractSendRecordPagination.getContractId())) {
            ++rkContractSendRecordNum;
            rkContractSendRecordQueryWrapper.lambda().like(RkContractSendRecordEntity::getContractId, (Object)rkContractSendRecordPagination.getContractId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractSendRecordPagination.getDescription())) {
            ++rkContractSendRecordNum;
            rkContractSendRecordQueryWrapper.lambda().like(RkContractSendRecordEntity::getDescription, (Object)rkContractSendRecordPagination.getDescription());
        }
        if (AllIdList.size() > 0) {
            rkContractSendRecordQueryWrapper.lambda().in(RkContractSendRecordEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractSendRecordPagination.getSidx())) {
            rkContractSendRecordQueryWrapper.lambda().orderByDesc(RkContractSendRecordEntity::getId);
        } else {
            try {
                String sidx = rkContractSendRecordPagination.getSidx();
                RkContractSendRecordEntity rkContractSendRecordEntity = new RkContractSendRecordEntity();
                Field declaredField = rkContractSendRecordEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractSendRecordQueryWrapper = "asc".equals(rkContractSendRecordPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractSendRecordQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractSendRecordQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkContractSendRecordPagination.getCurrentPage(), rkContractSendRecordPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkContractSendRecordQueryWrapper);
            return rkContractSendRecordPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkContractSendRecordPagination.setData(list, list.size());
    }

    @Override
    public List<RkContractSendRecordEntity> getTypeList(RkContractSendRecordPagination rkContractSendRecordPagination, String dataType) {
        Object rkContractSendRecordObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractSendRecordNum = 0;
        QueryWrapper rkContractSendRecordQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractSendRecordObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractSendRecordQueryWrapper, rkContractSendRecordPagination.getMenuId(), "rkContractSendRecord"));
            if (ObjectUtil.isEmpty((Object)rkContractSendRecordObj)) {
                return new ArrayList<RkContractSendRecordEntity>();
            }
            rkContractSendRecordQueryWrapper = (QueryWrapper)rkContractSendRecordObj;
            ++rkContractSendRecordNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractSendRecordObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractSendRecordQueryWrapper, rkContractSendRecordPagination.getMenuId(), "rkContractSendRecord"));
            if (ObjectUtil.isEmpty((Object)rkContractSendRecordObj)) {
                return new ArrayList<RkContractSendRecordEntity>();
            }
            rkContractSendRecordQueryWrapper = (QueryWrapper)rkContractSendRecordObj;
            ++rkContractSendRecordNum;
        }
        if (ObjectUtil.isNotEmpty(rkContractSendRecordPagination.getCreatorTime())) {
            ++rkContractSendRecordNum;
            List<String> CreatorTimeList = rkContractSendRecordPagination.getCreatorTime();
            Long fir = Long.valueOf(CreatorTimeList.get(0));
            Long sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)rkContractSendRecordQueryWrapper.lambda().ge(RkContractSendRecordEntity::getCreatorTime, (Object)new Date(fir))).le(RkContractSendRecordEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractSendRecordPagination.getSendAmount())) {
            ++rkContractSendRecordNum;
            rkContractSendRecordQueryWrapper.lambda().like(RkContractSendRecordEntity::getSendAmount, (Object)rkContractSendRecordPagination.getSendAmount());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractSendRecordPagination.getContractId())) {
            ++rkContractSendRecordNum;
            rkContractSendRecordQueryWrapper.lambda().like(RkContractSendRecordEntity::getContractId, (Object)rkContractSendRecordPagination.getContractId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractSendRecordPagination.getDescription())) {
            ++rkContractSendRecordNum;
            rkContractSendRecordQueryWrapper.lambda().like(RkContractSendRecordEntity::getDescription, (Object)rkContractSendRecordPagination.getDescription());
        }
        if (AllIdList.size() > 0) {
            rkContractSendRecordQueryWrapper.lambda().in(RkContractSendRecordEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractSendRecordPagination.getSidx())) {
            rkContractSendRecordQueryWrapper.lambda().orderByDesc(RkContractSendRecordEntity::getId);
        } else {
            try {
                String sidx = rkContractSendRecordPagination.getSidx();
                RkContractSendRecordEntity rkContractSendRecordEntity = new RkContractSendRecordEntity();
                Field declaredField = rkContractSendRecordEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractSendRecordQueryWrapper = "asc".equals(rkContractSendRecordPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractSendRecordQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractSendRecordQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractSendRecordPagination.getCurrentPage(), rkContractSendRecordPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractSendRecordQueryWrapper);
                return rkContractSendRecordPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractSendRecordPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractSendRecordQueryWrapper);
    }

    @Override
    public RkContractSendRecordEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractSendRecordEntity::getId, (Object)id);
        return (RkContractSendRecordEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkContractSendRecordEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkContractSendRecordEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkContractSendRecordEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void deleteByContractId(String contractId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractSendRecordEntity::getEnabledMark, (Object)0)).eq(RkContractSendRecordEntity::getContractId, (Object)contractId);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    @DSTransactional
    public void deleteSendRecord(RkContractSendRecordEntity entity) {
        if (entity != null) {
            entity.setEnabledMark(0);
            this.update(entity.getId(), entity);
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)entity.getContractId()));
            if (!ObjectUtil.isEmpty((Object)byId)) {
                BigDecimal substract = MathUtils.substract(byId.getActSendAmount(), entity.getSendAmount());
                byId.setActSendAmount(substract);
                List<RkContractSendRecordEntity> listByContractId = this.getListByContractId(entity.getContractId());
                if (CollectionUtil.isNotEmpty(listByContractId)) {
                    byId.setLastSendTime(listByContractId.get(0).getSendTime());
                }
                this.contractService.update(byId.getId(), byId);
                if (CollectionUtil.isEmpty(listByContractId)) {
                    UpdateWrapper updateWrapper = new UpdateWrapper();
                    ((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractEntity::getLastSendTime, null)).eq(RkContractEntity::getId, (Object)byId.getId());
                    this.contractService.update((Wrapper)updateWrapper);
                }
            }
        }
    }

    @Override
    @DSTransactional
    public HashMap createSend(RkContractSendRecordCrForm rkContractSendRecordCrForm) {
        HashMap map = MapUtil.newHashMap();
        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractSendRecordCrForm.getContractId()));
        if (ObjectUtil.isEmpty((Object)byId)) {
            map.put("error", "\u5408\u540c\u4e0d\u5b58\u5728");
            return map;
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkContractSendRecordEntity entity = (RkContractSendRecordEntity)JsonUtil.getJsonToBean((Object)rkContractSendRecordCrForm, RkContractSendRecordEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        this.save(entity);
        if (ObjectUtil.isEmpty((Object)byId.getLastSendTime())) {
            byId.setLastSendTime(rkContractSendRecordCrForm.getSendTime());
        } else if (byId.getLastSendTime().before(rkContractSendRecordCrForm.getSendTime())) {
            byId.setLastSendTime(rkContractSendRecordCrForm.getSendTime());
        }
        BigDecimal add = MathUtils.add(byId.getActSendAmount(), MathUtils.toBigDecimal(rkContractSendRecordCrForm.getSendAmount()));
        byId.setActSendAmount(add);
        this.contractService.update(byId.getId(), byId);
        return map;
    }

    @Override
    public List<RkContractSendRecordEntity> getListByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractSendRecordEntity::getEnabledMark, (Object)1)).eq(RkContractSendRecordEntity::getContractId, (Object)contractId)).orderByDesc(RkContractSendRecordEntity::getSendTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean updateAgent(String agentName, String agentId, String contractId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractSendRecordEntity::getAgentId, (Object)agentId)).set(RkContractSendRecordEntity::getAgentName, (Object)agentName)).eq(RkContractSendRecordEntity::getContractId, (Object)contractId);
        return this.update((Wrapper)updateWrapper);
    }
}

