/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.ConvertUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractChangeEntity;
import com.bringspring.contract.entity.RkContractDelEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProductEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkContractTaxEntity;
import com.bringspring.contract.entity.RkContractVerifyEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.mapper.RkContractMapper;
import com.bringspring.contract.model.rkarchived.RkArachivedUpForm;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkattachment.RkAttachmentUpForm;
import com.bringspring.contract.model.rkcontract.ContractImportReturnVO;
import com.bringspring.contract.model.rkcontract.ContractImportVO;
import com.bringspring.contract.model.rkcontract.RkCompanyContractStatisticsLedger;
import com.bringspring.contract.model.rkcontract.RkContractCrForm;
import com.bringspring.contract.model.rkcontract.RkContractExportImplementAccountsModel;
import com.bringspring.contract.model.rkcontract.RkContractListVO;
import com.bringspring.contract.model.rkcontract.RkContractPagination;
import com.bringspring.contract.model.rkcontract.RkContractPaginationExportModel;
import com.bringspring.contract.model.rkcontract.RkContractPaymentVO;
import com.bringspring.contract.model.rkcontract.RkContractQueryVO;
import com.bringspring.contract.model.rkcontract.RkContractUpForm;
import com.bringspring.contract.model.rkcontract.RkProductChannelInfoModel;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordPagination;
import com.bringspring.contract.model.rkcontractinvoice.RkContractInvoicePagination;
import com.bringspring.contract.model.rkcontractproduct.RkContractProductCrForm;
import com.bringspring.contract.model.rkcontractproduct.RkContractProductUpForm;
import com.bringspring.contract.model.rkcontracttax.RkContractTaxInfoVO;
import com.bringspring.contract.model.rkprocuremanage.RkProcureManagePagination;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractChangeService;
import com.bringspring.contract.service.RkContractCollectionRecordService;
import com.bringspring.contract.service.RkContractDelService;
import com.bringspring.contract.service.RkContractInvoiceDetailService;
import com.bringspring.contract.service.RkContractInvoiceService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractSendRecordService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractTaxService;
import com.bringspring.contract.service.RkContractVerifyService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.utils.AllContractTypeEnum;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.ContractEnableMarkEnum;
import com.bringspring.contract.utils.DictEncodeEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ReturnPlanEnum;
import com.bringspring.contract.utils.RoleUtils;
import com.bringspring.contract.utils.SpecialTypeEnum;
import com.bringspring.crm.entity.CrmCustomerCompanyRelationEntity;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmDepartConnectEntity;
import com.bringspring.crm.entity.CrmProductBuyEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductRelationEntity;
import com.bringspring.crm.model.crmcustomermy.CrmCustomerMyCrForm;
import com.bringspring.crm.model.datacenter.SaleDataSummaryVo;
import com.bringspring.crm.service.CrmCustomerCompanyRelationService;
import com.bringspring.crm.service.CrmCustomerMyService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductBuyService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductRelationService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.service.AreagroupService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.system.permission.util.PermissionUtil;
import com.bringspring.utils.CustomizeSortWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractServiceImpl
extends ServiceImpl<RkContractMapper, RkContractEntity>
implements RkContractService {
    private static final Logger log = LoggerFactory.getLogger(RkContractServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractProductService contractProductService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkContractChangeService contractChangeService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkContractPaymentService contractPaymentService;
    @Autowired
    private RkContractReturnPlanService contractReturnPlanService;
    @Autowired
    private RkContractDelService contractDelService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private ProvinceService provinceService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkContractTaxService contractTaxService;
    @Autowired
    private CrmCustomerCompanyRelationService crmCustomerCompanyRelationService;
    @Autowired
    private CrmProductRelationService crmProductRelationService;
    @Autowired
    private CrmProductBuyService crmProductBuyService;
    @Autowired
    private RoleUtils roleUtils;
    @Autowired
    private RkContractSendRecordService contractSendRecordService;
    @Autowired
    private RkContractCollectionRecordService contractCollectionRecordService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractVerifyService rkContractVerifyService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractInvoiceService contractInvoiceService;
    @Autowired
    private RkContractInvoiceDetailService contractInvoiceDetailService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkContractMapper rkContractMapper;
    @Autowired
    private CrmCustomerMyService crmCustomerMyService;
    @Autowired
    private RkProcureManageService rkProcureManageService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private AreagroupService areagroupService;

    @Override
    public List<RkContractEntity> getList(RkContractPagination rkContractPagination) {
        QueryWrapper<RkContractEntity> rkContractQueryWrapper = new QueryWrapper<RkContractEntity>();
        if (ObjectUtil.isNull(rkContractQueryWrapper = this.appendWrapper(rkContractPagination, rkContractQueryWrapper))) {
            return CollectionUtil.list((boolean)false);
        }
        if (ObjectUtil.isEmpty(rkContractQueryWrapper)) {
            ArrayList list = new ArrayList();
            return rkContractPagination.setData(list, list.size());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getServiceFeeType())) {
            List list = this.list((Wrapper)rkContractQueryWrapper);
            list.stream().forEach(contract -> {
                if (ObjectUtil.isEmpty((Object)contract.getSettlementStatus())) {
                    contract.setSettlementStatus("notSettled");
                    this.updateById(contract);
                }
            });
        }
        Page page = new Page(rkContractPagination.getCurrentPage(), rkContractPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)rkContractQueryWrapper);
        return rkContractPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public Map<String, Object> countAmount(RkContractPagination rkContractPagination) {
        QueryWrapper<RkContractEntity> queryWrapper = new QueryWrapper<RkContractEntity>();
        queryWrapper = this.appendWrapper(rkContractPagination, queryWrapper);
        Map map = MapUtil.newHashMap();
        map.put("totalContractAmount", "0");
        map.put("totalReturnAmount", "0");
        map.put("totalInvoiceAmount", "0");
        map.put("totalSendAmount", "0");
        map.put("contractNum", "0");
        if (ObjectUtil.isNull(queryWrapper)) {
            return map;
        }
        queryWrapper.select(new String[]{"sum(contract_amount) as totalContractAmount"});
        Map map1 = this.getMap((Wrapper)queryWrapper);
        if (!ObjectUtil.isEmpty((Object)map1)) {
            map = map1;
        }
        return map;
    }

    @Override
    public Map<String, Object> countAmountByPlan(RkContractPagination rkContractPagination) {
        Map<String, Object> map = MapUtil.newHashMap();
        map.put("totalContractAmount", "0");
        map.put("totalReturnAmount", "0");
        map.put("totalInvoiceAmount", "0");
        map.put("totalSendAmount", "0");
        map.put("contractNum", "0");
        map.put("totalArrearsAmount", "0");
        map.put("totalEffectiveAmount", "0");
        QueryWrapper<RkContractEntity> queryWrapper = new QueryWrapper<RkContractEntity>();
        queryWrapper = this.appendWrapper(rkContractPagination, queryWrapper);
        QueryWrapper<RkContractEntity> listQueryWrapper = new QueryWrapper<RkContractEntity>();
        listQueryWrapper = this.appendWrapper(rkContractPagination, listQueryWrapper);
        if (ObjectUtil.isEmpty(queryWrapper)) {
            return map;
        }
        queryWrapper.select(new String[]{"sum(contract_amount) as totalContractAmount,count(id) as contractNum,sum(valid_contract_amount) as totalEffectiveAmount"});
        queryWrapper.lambda().ne(RkContractEntity::getEnableMark, (Object)"voided");
        List list = this.list((Wrapper)listQueryWrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return map;
        }
        map = this.getMap((Wrapper)queryWrapper);
        List collect = list.stream().map(RkContractEntity::getId).collect(Collectors.toList());
        map.put("contractIdList", collect);
        QueryWrapper planEntityQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)planEntityQueryWrapper.lambda().in(RkContractReturnPlanEntity::getContractId, collect)).ne(RkContractReturnPlanEntity::getReturnState, (Object)ReturnPlanEnum.END.getState())).lt(RkContractReturnPlanEntity::getDueDate, (Object)DateUtil.getDayBegin());
        List planList = this.contractReturnPlanService.list((Wrapper)planEntityQueryWrapper);
        BigDecimal arrearsAmount = planList.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
        map.put("totalArrearsAmount", arrearsAmount);
        return map;
    }

    private QueryWrapper<RkContractEntity> appendWrapper(RkContractPagination rkContractPagination, QueryWrapper<RkContractEntity> rkContractQueryWrapper) {
        List<RkContractProductEntity> listByProductId;
        List salerIdList;
        DateTime parse;
        boolean permission = true;
        Integer isAuth = rkContractPagination.getIsAuth();
        if (0 == isAuth) {
            permission = false;
        }
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractQueryWrapper, rkContractPagination.getMenuId(), "rk_contract"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                rkContractQueryWrapper.lambda().eq(RkContractEntity::getSalerId, (Object)this.userProvider.get().getUserId());
            } else {
                rkContractQueryWrapper = (QueryWrapper)rkContractObj;
            }
        }
        if (!StrUtil.isBlank((CharSequence)rkContractPagination.getIncomeType())) {
            rkContractQueryWrapper.apply("find_in_set('" + rkContractPagination.getIncomeType() + "',income_type)", new Object[0]);
        }
        if (CollectionUtil.isNotEmpty(rkContractPagination.getCustomerAddress())) {
            rkContractPagination.getCustomerAddress().stream().filter(x -> {
                boolean flag = x.size() < 2 && ((String)x.get(0)).equals("10");
                return !flag;
            }).collect(Collectors.toList());
            if (rkContractPagination.getCustomerAddress().size() < 2 && rkContractPagination.getCustomerAddress().get(0).equals("10")) {
                rkContractPagination.setCustomerAddress(null);
            }
        }
        if (CollectionUtil.isNotEmpty(rkContractPagination.getCustomerAddress())) {
            rkContractQueryWrapper.lambda().and(x -> {
                for (List<String> ll : rkContractPagination.getCustomerAddress()) {
                    List addressList = JsonUtil.getJsonToList(ll, String.class);
                    if (addressList.size() > 1) {
                        String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                        collect = "[" + collect;
                        ((LambdaQueryWrapper)x.or()).like(RkContractEntity::getCustomerAddress, (Object)collect);
                        continue;
                    }
                    String s2 = (String)addressList.get(addressList.size() - 1);
                    s2 = "[\"" + s2 + "\"";
                    ((LambdaQueryWrapper)x.or()).like(RkContractEntity::getCustomerAddress, (Object)s2);
                }
            });
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getConnectType())) {
            if (rkContractPagination.getConnectType() == 3) {
                rkContractQueryWrapper.lambda().isNull(RkContractEntity::getConnectType);
            } else {
                rkContractQueryWrapper.lambda().eq(RkContractEntity::getConnectType, (Object)rkContractPagination.getConnectType());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getCustomerProv())) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getCustomerProv, (Object)rkContractPagination.getCustomerProv());
        }
        if (CollectionUtil.isNotEmpty(rkContractPagination.getSalerCompanyIdList())) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getSalerCompanyId, rkContractPagination.getSalerCompanyIdList());
        }
        if (CollectionUtil.isNotEmpty(rkContractPagination.getCompanyIdList())) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getCompanyId, rkContractPagination.getCompanyIdList());
        }
        if (CollectionUtil.isNotEmpty(rkContractPagination.getRegionIdList())) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getCustomerProv, rkContractPagination.getRegionIdList());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getContractType())) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getContractType, (Object)rkContractPagination.getContractType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getSource()) && rkContractPagination.getSource().equals("settlement")) {
            rkContractQueryWrapper.lambda().isNotNull(RkContractEntity::getInternalContractId);
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getSettlementStatus()) && ObjectUtil.isNotEmpty((Object)rkContractPagination.getSource()) && rkContractPagination.getSource().equals("flow")) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getSettlementStatus, (Object)rkContractPagination.getSettlementStatus());
        }
        if (CollectionUtil.isNotEmpty((Collection)rkContractPagination.getContractTypeList())) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getContractType, (Collection)rkContractPagination.getContractTypeList());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getIsStampType())) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getIsStampType, (Object)rkContractPagination.getIsStampType());
        }
        if (StringUtils.isNotEmpty((String)rkContractPagination.getCompanyId())) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)rkContractPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(rkContractPagination.getEnableMark())) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getEnableMark, rkContractPagination.getEnableMark());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getContractName())) {
            rkContractQueryWrapper.lambda().like(RkContractEntity::getContractName, (Object)rkContractPagination.getContractName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getYongYou())) {
            rkContractQueryWrapper.lambda().like(RkContractEntity::getYongYou, (Object)rkContractPagination.getYongYou());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getContractCode())) {
            rkContractQueryWrapper.lambda().like(RkContractEntity::getContractCode, (Object)rkContractPagination.getContractCode());
        }
        if (CollectionUtil.isNotEmpty(rkContractPagination.getSignDate())) {
            parse = cn.hutool.core.date.DateUtil.parse((CharSequence)(cn.hutool.core.date.DateUtil.formatDate((Date)rkContractPagination.getSignDate().get(1)) + " 23:59:59"));
            rkContractQueryWrapper.lambda().between(RkContractEntity::getSignDate, (Object)rkContractPagination.getSignDate().get(0), (Object)parse);
        }
        if (CollectionUtil.isNotEmpty(rkContractPagination.getArchivedDate())) {
            parse = cn.hutool.core.date.DateUtil.parse((CharSequence)(cn.hutool.core.date.DateUtil.formatDate((Date)rkContractPagination.getArchivedDate().get(1)) + " 23:59:59"));
            rkContractQueryWrapper.lambda().between(RkContractEntity::getArchivedTime, (Object)rkContractPagination.getArchivedDate().get(0), (Object)parse);
        }
        if (CollectionUtil.isNotEmpty(rkContractPagination.getCreatorTime())) {
            parse = cn.hutool.core.date.DateUtil.parse((CharSequence)(cn.hutool.core.date.DateUtil.formatDate((Date)rkContractPagination.getCreatorTime().get(1)) + " 23:59:59"));
            rkContractQueryWrapper.lambda().between(RkContractEntity::getCreatorTime, (Object)rkContractPagination.getCreatorTime().get(0), (Object)parse);
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractPagination.getCreatorUserId())) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getCreatorUserId, (Object)rkContractPagination.getCreatorUserId());
        }
        if (StrUtil.isNotEmpty((CharSequence)rkContractPagination.getSalesLiaison())) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getSalesLiaison, (Object)rkContractPagination.getSalesLiaison());
        }
        if (CollectionUtil.isNotEmpty(rkContractPagination.getLastSendTime())) {
            rkContractQueryWrapper.lambda().between(RkContractEntity::getLastSendTime, (Object)rkContractPagination.getLastSendTime().get(0), (Object)rkContractPagination.getLastSendTime().get(1));
        }
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getSignMonth())) {
            rkContractQueryWrapper.lambda().apply("DATE_FORMAT(sign_date,'%Y-%m') = '" + rkContractPagination.getSignMonth() + "'", new Object[0]);
        }
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getIsArchived())) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getIsArchived, (Object)rkContractPagination.getIsArchived());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getIsLess())) {
            if (StrUtil.equals((CharSequence)rkContractPagination.getIsLess(), (CharSequence)"1")) {
                rkContractQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.isNull(RkContractEntity::getActSendAmount)).or()).apply("act_send_amount < contract_amount", new Object[0]));
            }
            if (StrUtil.equals((CharSequence)rkContractPagination.getIsLess(), (CharSequence)"0")) {
                ((LambdaQueryWrapper)rkContractQueryWrapper.lambda().isNotNull(RkContractEntity::getActSendAmount)).apply("act_send_amount >= contract_amount", new Object[0]);
            }
        }
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getSpecialType())) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getSpecialType, (Object)rkContractPagination.getSpecialType());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getIndustryType())) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getIndustryType, (Object)rkContractPagination.getIndustryType());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getIsHaveAttachment())) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getIsHaveAttachment, (Object)rkContractPagination.getIsHaveAttachment());
        }
        HashMap roleSearchMap = rkContractPagination.getRoleSearchMap();
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getSalerId())) {
            List salerIdList2;
            String searchUserId = rkContractPagination.getSalerId();
            if (!(ObjectUtil.isEmpty((Object)roleSearchMap) || roleSearchMap.size() <= 0 || ((Boolean)roleSearchMap.get("isAll")).booleanValue() || (salerIdList2 = (List)roleSearchMap.get("idList")).contains(searchUserId))) {
                searchUserId = "";
            }
            if (!ObjectUtil.isEmpty((Object)searchUserId)) {
                rkContractQueryWrapper.lambda().eq(RkContractEntity::getSalerId, (Object)rkContractPagination.getSalerId());
            }
        } else if (!ObjectUtil.isEmpty((Object)roleSearchMap) && roleSearchMap.size() > 0 && !((Boolean)roleSearchMap.get("isAll")).booleanValue() && CollectionUtil.isNotEmpty((Collection)(salerIdList = (List)roleSearchMap.get("idList")))) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getSalerId, (Collection)salerIdList);
        }
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getIsSupplement())) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getIsSupplement, (Object)rkContractPagination.getIsSupplement());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getCompanyId())) {
            rkContractQueryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)rkContractPagination.getCompanyId());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getServiceFeeType())) {
            ((LambdaQueryWrapper)rkContractQueryWrapper.lambda().isNotNull(RkContractEntity::getArchivedTime)).ne(RkContractEntity::getEnableMark, (Object)"voided");
        }
        if (ObjectUtil.isNotEmpty(rkContractPagination.getSearchCustomerRegion())) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getCustomerRegion, rkContractPagination.getSearchCustomerRegion());
        }
        boolean flag = false;
        List contractIdList = CollectionUtil.list((boolean)false);
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getProductId()) && CollectionUtil.isEmpty(contractIdList = (listByProductId = this.contractProductService.getListByProductId(rkContractPagination.getProductId())).stream().map(RkContractProductEntity::getContractId).collect(Collectors.toList()))) {
            flag = true;
        }
        List customerIdList = CollectionUtil.list((boolean)false);
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getGrade()) || !ObjectUtil.isEmpty(rkContractPagination.getCustomerCreateDate())) {
            List<CrmCustomerEntity> listByGrade = this.crmCustomerService.getListByGradeAndCreateDate(rkContractPagination.getGrade(), rkContractPagination.getCustomerCreateDate());
            customerIdList = listByGrade.stream().map(CrmCustomerEntity::getId).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(customerIdList)) {
                flag = true;
            }
            if (!ObjectUtil.isEmpty((Object)rkContractPagination.getCustomerId()) && !customerIdList.contains(rkContractPagination.getCustomerId())) {
                flag = true;
            }
        }
        List idList = CollectionUtil.list((boolean)false);
        if (StrUtil.isNotEmpty((CharSequence)rkContractPagination.getCustomerName())) {
            List<CrmCustomerEntity> list = this.crmCustomerService.getInfoByCustomerName(rkContractPagination.getCustomerName());
            idList = list.stream().map(CrmCustomerEntity::getId).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(list)) {
                flag = true;
            }
        }
        List agentIdList = CollectionUtil.list((boolean)false);
        if (!ObjectUtil.isEmpty(rkContractPagination.getAgentCreateDate())) {
            List<RkAgentEntity> listByCreateDate = this.agentService.getListByCreateDate(rkContractPagination.getAgentCreateDate());
            agentIdList = listByCreateDate.stream().map(RkAgentEntity::getId).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(agentIdList)) {
                flag = true;
            }
            if (!ObjectUtil.isEmpty((Object)rkContractPagination.getAgentId()) && !agentIdList.contains(rkContractPagination.getAgentId())) {
                flag = true;
            }
        }
        if (flag) {
            return null;
        }
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getAgentId())) {
            rkContractQueryWrapper.lambda().like(RkContractEntity::getAgentIds, (Object)rkContractPagination.getAgentId());
        } else if (CollectionUtil.isNotEmpty((Collection)agentIdList)) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getAgentId, agentIdList);
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getCustomerId())) {
            rkContractQueryWrapper.lambda().like(RkContractEntity::getCustomerIds, (Object)rkContractPagination.getCustomerId());
        } else if (CollectionUtil.isNotEmpty(customerIdList)) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getCustomerId, customerIdList);
        } else if (CollectionUtil.isNotEmpty(idList)) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getCustomerId, idList);
        }
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getIsOverdue())) {
            List collect;
            List<RkContractReturnPlanEntity> listOverdueType = CollectionUtil.list((boolean)false);
            listOverdueType = !ObjectUtil.isEmpty((Object)rkContractPagination.getCompanyId()) ? this.contractReturnPlanService.getListOverdueTypeByCompanyId(rkContractPagination.getCompanyId()) : this.contractReturnPlanService.getListOverdueType();
            if (rkContractPagination.getIsOverdue() == 1) {
                if (CollectionUtil.isEmpty(listOverdueType)) {
                    return null;
                }
                collect = listOverdueType.stream().map(RkContractReturnPlanEntity::getContractId).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(contractIdList)) {
                    List intersection = contractIdList.stream().filter(item -> collect.contains(item)).collect(Collectors.toList());
                    contractIdList = intersection;
                } else {
                    contractIdList = collect;
                }
            } else if (CollectionUtil.isNotEmpty(listOverdueType)) {
                collect = listOverdueType.stream().map(RkContractReturnPlanEntity::getContractId).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(contractIdList)) {
                    contractIdList = contractIdList.stream().filter(x -> !collect.contains(x)).collect(Collectors.toList());
                } else {
                    rkContractQueryWrapper.lambda().notIn(RkContractEntity::getId, collect);
                }
            }
        }
        if (!ObjectUtil.isEmpty(contractIdList)) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getId, contractIdList);
        }
        if (!ObjectUtil.isNotEmpty((Object)rkContractPagination.getSource()) || rkContractPagination.getSource().equals("invoice")) {
            // empty if block
        }
        if (ObjectUtil.isEmpty((Object)rkContractPagination.getSidx())) {
            rkContractQueryWrapper.lambda().orderByDesc(RkContractEntity::getSignDate, (Object[])new SFunction[]{RkContractEntity::getCreatorTime});
        } else {
            try {
                QueryWrapper customSortWrapper = CustomizeSortWrapper.appendWrapper(rkContractPagination, new RkContractListVO(), rkContractQueryWrapper);
                if (ObjectUtil.isNull((Object)customSortWrapper)) {
                    String sidx = rkContractPagination.getSidx();
                    RkContractEntity rkContractEntity = new RkContractEntity();
                    Field declaredField = rkContractEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    rkContractQueryWrapper = "asc".equals(rkContractPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractQueryWrapper.orderByDesc((Object)value);
                } else {
                    rkContractQueryWrapper = customSortWrapper;
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return rkContractQueryWrapper;
    }

    @Override
    public List<RkContractEntity> getTypeList(RkContractPagination rkContractPagination, String dataType) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper<RkContractEntity> rkContractQueryWrapper = new QueryWrapper<RkContractEntity>();
        if (ObjectUtil.isNull(rkContractQueryWrapper = this.appendWrapper(rkContractPagination, rkContractQueryWrapper))) {
            return CollectionUtil.list((boolean)false);
        }
        if (AllIdList.size() > 0) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getId, AllIdList);
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractPagination.getCurrentPage(), rkContractPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractQueryWrapper);
                return rkContractPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractQueryWrapper);
    }

    @Override
    public List<RkContractEntity> getTypeListNoContract(RkContractPagination rkContractPagination, String dataType) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper rkContractQueryWrapper = new QueryWrapper();
        rkContractQueryWrapper = this.appendWrapper(rkContractPagination, (QueryWrapper<RkContractEntity>)rkContractQueryWrapper);
        ArrayList<String> specialTypeList = new ArrayList<String>();
        specialTypeList.add("noContract");
        specialTypeList.add("virtuallyContract");
        rkContractQueryWrapper.lambda().notIn(RkContractEntity::getSpecialType, specialTypeList);
        if (ObjectUtil.isNull(rkContractQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if (AllIdList.size() > 0) {
            rkContractQueryWrapper.lambda().in(RkContractEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractPagination.getSidx())) {
            rkContractQueryWrapper.lambda().orderByDesc(RkContractEntity::getId);
        } else {
            try {
                String sidx = rkContractPagination.getSidx();
                RkContractEntity rkContractEntity = new RkContractEntity();
                Field declaredField = rkContractEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractQueryWrapper = "asc".equals(rkContractPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractPagination.getCurrentPage(), rkContractPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractQueryWrapper);
                return rkContractPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractQueryWrapper);
    }

    @Override
    public RkContractEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractEntity::getId, (Object)id);
        return (RkContractEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public RkContractEntity getInfoByCode(String code, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractEntity::getContractCode, (Object)code)).eq(RkContractEntity::getCompanyId, (Object)companyId);
        return (RkContractEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkContractEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkContractEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkContractEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    @DSTransactional
    public void deleteContract(RkContractEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        if (entity != null) {
            RkContractEntity byId = (RkContractEntity)this.getById((Serializable)((Object)entity.getId()));
            RkContractDelEntity jsonToBean = (RkContractDelEntity)JsonUtil.getJsonToBean((Object)byId, RkContractDelEntity.class);
            jsonToBean.setDeleteUserId(userInfo.getUserId());
            jsonToBean.setDeleteTime(new Date());
            jsonToBean.setDeleteMark(1);
            this.contractDelService.save(jsonToBean);
            this.removeById((Serializable)((Object)entity.getId()));
            this.contractProductService.deleteByContractId(entity.getId());
            this.attachmentService.deleteByContractId(entity.getId());
            this.contractSendRecordService.deleteByContractId(entity.getId());
            this.rkContractProjectService.deleteByContractId(entity.getId());
        }
    }

    @Override
    @DSTransactional
    public HashMap createContract(RkContractCrForm rkContractCrForm) throws DataException {
        String[] split;
        Object byId;
        List<RkContractEntity> listByCode;
        DictionaryDataEntity info;
        HashMap map = MapUtil.newHashMap();
        UserInfo userInfo = this.userProvider.get();
        String mainId = RandomUtil.uuId();
        if (StrUtil.isNotEmpty((CharSequence)rkContractCrForm.getContractCode())) {
            rkContractCrForm.setContractCode(rkContractCrForm.getContractCode().trim());
        } else if (StringUtils.isNotEmpty((String)rkContractCrForm.getJcContractType()) && ObjectUtil.isNotNull((Object)(info = this.dictionaryDataService.getInfo(rkContractCrForm.getJcContractType())))) {
            String billNumber = this.baseDataUtil.getBillNumber("JCContractCode" + info.getEnCode(), Boolean.valueOf(false));
            rkContractCrForm.setContractCode(billNumber);
        }
        RkContractEntity entity = (RkContractEntity)JsonUtil.getJsonToBean((Object)rkContractCrForm, RkContractEntity.class);
        if (null == entity.getPassTime()) {
            entity.setPassTime(new Date());
        }
        entity.setId(mainId);
        entity.setIsArchived(0);
        entity.setActSendAmount(BigDecimal.ZERO);
        if (CollectionUtil.isNotEmpty(rkContractCrForm.getAttachmentList())) {
            entity.setIsHaveAttachment(1);
        } else {
            entity.setIsHaveAttachment(0);
        }
        List<RkAttachmentCrForm> doubleSignedAttachmentList = rkContractCrForm.getDoubleSignedAttachmentList();
        if (CollectionUtil.isNotEmpty(doubleSignedAttachmentList)) {
            doubleSignedAttachmentList.stream().forEach(attach -> {
                attach.setContractId(mainId);
                attach.setFileType(AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(doubleSignedAttachmentList, RkAttachmentEntity.class);
            this.attachmentService.saveBatch(attachmentEntityList);
            entity.setDoubleSignedAttachment(1);
        } else {
            entity.setDoubleSignedAttachment(0);
        }
        if (!ObjectUtil.isEmpty((Object)entity.getIsArchived()) && entity.getIsArchived() == 1) {
            entity.setArchivedBy(userInfo.getUserId());
            entity.setArchivedTime(new Date());
        }
        if (ObjectUtil.isEmpty((Object)entity.getInvoiceAmount())) {
            entity.setInvoiceAmount(BigDecimal.ZERO);
        }
        if (!(ObjectUtil.isEmpty((Object)rkContractCrForm.getEnableMark()) || StrUtil.equals((CharSequence)rkContractCrForm.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark()) || ObjectUtil.isEmpty((Object)rkContractCrForm.getContractAmount()) || ObjectUtil.isEmpty((Object)rkContractCrForm.getContractTaxRate()))) {
            entity.setContractTaxAmount(this.countContractTaxAmount(entity));
        }
        if (!ObjectUtil.isEmpty((Object)entity.getContractCode()) && CollectionUtil.isNotEmpty(listByCode = this.getListByCode(entity.getContractCode()))) {
            map.put("error", "\u5408\u540c\u53f7\u91cd\u590d");
            return map;
        }
        if (!ObjectUtil.isEmpty((Object)entity.getIsAgent()) && entity.getIsAgent() == 1 && !ObjectUtil.isEmpty((Object)entity.getAgentId()) && ObjectUtil.isEmpty((Object)(byId = (RkAgentEntity)this.agentService.getById((Serializable)((Object)entity.getAgentId())))) && !ObjectUtil.isEmpty((Object)entity.getAgentId())) {
            byId = new RkAgentEntity();
            ((RkAgentEntity)byId).setName(entity.getAgentId());
            ((RkAgentEntity)byId).setPinyin(PinyinUtil.getFirstLetter((String)((RkAgentEntity)byId).getName(), (String)"").toUpperCase());
            ((RkAgentEntity)byId).setCompanyId(entity.getCompanyId());
            ((RkAgentEntity)byId).setId(RandomUtil.uuId());
            this.agentService.save(byId);
            entity.setAgentId(((RkAgentEntity)byId).getId());
        }
        entity.setReturnState(ReturnPlanEnum.NOT_START.getState() + "");
        entity.setReturnAmount(BigDecimal.ZERO);
        entity.setReturnRatio(BigDecimal.ZERO);
        if (CollectionUtil.isNotEmpty(rkContractCrForm.getPaymentList())) {
            List<RkContractPaymentVO> paymentList = rkContractCrForm.getPaymentList();
            paymentList.stream().forEach(payment -> {
                if (!ObjectUtil.isEmpty((Object)payment.getPaymentName()) && ObjectUtil.isEmpty((Object)payment.getPaymentType())) {
                    payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                }
            });
            String objectToString = JsonUtil.getObjectToString(paymentList);
            entity.setPaymentJson(objectToString);
            List jsonToList = JsonUtil.getJsonToList(paymentList, RkContractPaymentEntity.class);
            jsonToList.stream().forEach(payment -> {
                payment.setContractId(entity.getId());
                payment.setId(RandomUtil.uuId());
            });
            this.contractPaymentService.saveBatch(jsonToList);
        }
        if (CollectionUtil.isNotEmpty(rkContractCrForm.getTaxList())) {
            List jsonToList = JsonUtil.getJsonToList(rkContractCrForm.getTaxList(), RkContractTaxEntity.class);
            jsonToList.stream().forEach(tax -> {
                tax.setContractId(mainId);
                tax.setId(RandomUtil.uuId());
            });
            this.contractTaxService.saveBatch(jsonToList);
        }
        if (!ObjectUtil.isEmpty((Object)entity.getCustomerId())) {
            byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()));
            entity.setCustomerAddress(((CrmCustomerEntity)byId).getAddress());
            entity.setCustomerAddressName(this.baseDataUtil.provinceData(entity.getCustomerAddress()));
            String[] split2 = ((CrmCustomerEntity)byId).getAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
            for (int i = 0; i < split2.length; ++i) {
                if (i == 0) {
                    entity.setCustomerRegion(split2[0]);
                    entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
                }
                if (i == 1) {
                    entity.setCustomerProv(split2[1]);
                    entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
                }
                if (i != 2) continue;
                entity.setCustomerCity(split2[2]);
                entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
            }
        }
        if (!ObjectUtil.isEmpty((Object)entity.getSalerId())) {
            entity.setSalerName(this.baseDataUtil.userSelectValueNoAccount(entity.getSalerId()));
        }
        if (!ObjectUtil.isEmpty((Object)entity.getRegion())) {
            entity.setRegionName(this.baseDataUtil.provinceData(entity.getRegion()));
        }
        if (!ObjectUtil.isEmpty((Object)entity.getDepartmentTree()) && (split = entity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
            entity.setDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getDepartmentTree()));
            entity.setDepartmentOne(split[0]);
            entity.setDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getDepartmentOne()));
            entity.setDepartment(split[split.length - 1]);
            entity.setDepartmentName(this.baseDataUtil.comSelectValues(entity.getDepartment()));
        }
        entity.setContractSource(1);
        if (!StrUtil.equals((CharSequence)entity.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark())) {
            CrmCustomerMyCrForm crForm = new CrmCustomerMyCrForm(entity.getCustomerId(), entity.getSalerId(), "1", 1, 1, "1");
            this.crmCustomerMyService.saveCrmCustomer(crForm);
        }
        if (StringUtils.isNotEmpty((String)entity.getCustomerIds())) {
            this.saleContractCustomerService.insertListByCustomerIds(entity.getId(), entity.getCustomerIds());
        }
        if (ObjectUtil.equals((Object)entity.getIsAgent(), (Object)1)) {
            entity.setAgentIds(entity.getAgentId());
        } else {
            entity.setAgentId(entity.getCustomerId());
            entity.setAgentIds(entity.getCustomerIds());
        }
        RkContractEntity contractEntity = new RkContractEntity();
        BeanUtils.copyProperties((Object)entity, (Object)contractEntity);
        if (this.rkContractService.checkContractIsExist(contractEntity)) {
            throw new DataException("\u5408\u540c\u5df2\u5b58\u5728\uff01");
        }
        this.save(entity);
        List<RkContractProductCrForm> productList = rkContractCrForm.getProductList();
        productList.stream().forEach(product -> product.setContractId(mainId));
        List productEntityList = JsonUtil.getJsonToList(productList, RkContractProductEntity.class);
        this.contractProductService.saveBatch(productEntityList);
        if (!StrUtil.equals((CharSequence)entity.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark())) {
            productEntityList.forEach(product -> {
                CrmProductBuyEntity byId = (CrmProductBuyEntity)this.crmProductBuyService.getById((Serializable)((Object)product.getProductId()));
                if (ObjectUtil.isNotNull((Object)byId)) {
                    return;
                }
                CrmProductRelationEntity infoByProductId = this.crmProductRelationService.getInfoByProductId(product.getProductId(), entity.getCustomerId());
                if (ObjectUtil.isEmpty((Object)infoByProductId)) {
                    infoByProductId = new CrmProductRelationEntity();
                    infoByProductId.setId(RandomUtil.uuId());
                    infoByProductId.setCreatorUserId(userInfo.getUserId());
                    infoByProductId.setCreatorTime(DateUtil.getNowDate());
                    infoByProductId.setSalesmanId(entity.getSalerId());
                    infoByProductId.setContractId(entity.getId());
                    infoByProductId.setCustomerId(entity.getCustomerId());
                    infoByProductId.setProductId(product.getProductId());
                    infoByProductId.setProductVersion(product.getProductVersionName());
                    infoByProductId.setCompanyId(entity.getCompanyId());
                    infoByProductId.setIsStop(0);
                    infoByProductId.setIsInspect(0);
                    infoByProductId.setNotInspectReason("\u901a\u8fc7\u65b0\u589e\u5408\u540c\u5bfc\u5165\uff0c\u9ed8\u8ba4\u4e0d\u5de1\u68c0");
                    this.crmProductRelationService.save(infoByProductId);
                }
            });
            CrmCustomerEntity byId2 = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()));
            if (!ObjectUtil.isEmpty((Object)byId2) && !StrUtil.equals((CharSequence)byId2.getEnabledMark(), (CharSequence)"company")) {
                byId2.setEnabledMark("company");
                this.crmCustomerService.update(byId2.getId(), byId2);
            }
        }
        List<RkAttachmentCrForm> attachmentList = rkContractCrForm.getAttachmentList();
        attachmentList.stream().forEach(attach -> {
            attach.setContractId(mainId);
            attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
        });
        List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
        this.attachmentService.saveBatch(attachmentEntityList);
        try {
            this.toCustomerCompany(entity.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    @DSTransactional
    public HashMap createPayment(RkContractUpForm rkContractUpForm) {
        RkContractEntity entity = (RkContractEntity)this.getById((Serializable)((Object)rkContractUpForm.getId()));
        if (CollectionUtil.isNotEmpty(rkContractUpForm.getPaymentList())) {
            List<RkContractPaymentVO> paymentList = rkContractUpForm.getPaymentList();
            paymentList.stream().forEach(payment -> {
                if (!ObjectUtil.isEmpty((Object)payment.getPaymentName()) && ObjectUtil.isEmpty((Object)payment.getPaymentType())) {
                    payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                }
            });
            String objectToString = JsonUtil.getObjectToString(paymentList);
            entity.setPaymentJson(objectToString);
            List jsonToList = JsonUtil.getJsonToList(paymentList, RkContractPaymentEntity.class);
            jsonToList.stream().forEach(payment -> {
                payment.setContractId(entity.getId());
                payment.setId(RandomUtil.uuId());
                if (!ObjectUtil.isEmpty((Object)entity.getContractAmount()) && !ObjectUtil.isEmpty((Object)payment.getPaymentRatio())) {
                    String multiply = MathUtils.multiply(entity.getContractAmount() + "", payment.getPaymentRatio() + "");
                    String divide = MathUtils.divide(multiply, "100", 2);
                    payment.setReceivableAmount(MathUtils.toBigDecimal(divide));
                }
            });
            this.contractPaymentService.saveBatch(jsonToList);
            this.update(rkContractUpForm.getId(), entity);
        }
        return null;
    }

    @Override
    @DSTransactional
    public HashMap updatePayment(RkContractUpForm rkContractUpForm) {
        String id = rkContractUpForm.getId();
        RkContractEntity subentity = (RkContractEntity)this.getById((Serializable)((Object)rkContractUpForm.getId()));
        if (CollectionUtil.isNotEmpty(rkContractUpForm.getPaymentList())) {
            List<RkContractPaymentVO> paymentList = rkContractUpForm.getPaymentList();
            paymentList.stream().forEach(payment -> {
                if (!ObjectUtil.isEmpty((Object)payment.getPaymentName()) && ObjectUtil.isEmpty((Object)payment.getPaymentType())) {
                    payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                }
            });
            String objectToString = JsonUtil.getObjectToString(paymentList);
            subentity.setPaymentJson(objectToString);
            subentity.setEnableMark(rkContractUpForm.getEnableMark());
            List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
            if (CollectionUtil.isNotEmpty(listByContractId)) {
                List oldIdList = listByContractId.stream().map(RkContractPaymentEntity::getId).collect(Collectors.toList());
                List newIdList = paymentList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getId())).map(RkContractPaymentVO::getId).collect(Collectors.toList());
                List needRemoveIdList = oldIdList.stream().filter(x -> !newIdList.contains(x)).collect(Collectors.toList());
                this.contractPaymentService.removeBatchByIds(needRemoveIdList);
            }
            List jsonToList = JsonUtil.getJsonToList(paymentList, RkContractPaymentEntity.class);
            jsonToList.stream().forEach(x -> {
                x.setContractId(id);
                if (ObjectUtil.isEmpty((Object)x.getId())) {
                    x.setId(RandomUtil.uuId());
                }
            });
            this.contractPaymentService.saveOrUpdateBatch(jsonToList);
            this.update(id, subentity);
        }
        try {
            this.toCustomerCompany(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return MapUtil.newHashMap();
    }

    @Override
    @DSTransactional
    public HashMap updateContractFile(String id, RkContractUpForm rkContractUpForm) {
        HashMap map = MapUtil.newHashMap();
        RkContractEntity entity = this.getInfo(id);
        this.attachmentService.deleteByContractId(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
        List<RkAttachmentUpForm> attachmentList = rkContractUpForm.getAttachmentList();
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(id);
                attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
            this.attachmentService.saveBatch(attachmentEntityList);
            entity.setIsHaveAttachment(1);
        } else {
            entity.setIsHaveAttachment(0);
        }
        this.attachmentService.deleteByContractId(id, AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType());
        List<RkAttachmentUpForm> doubleSignedAttachmentList = rkContractUpForm.getDoubleSignedAttachmentList();
        if (CollectionUtil.isNotEmpty(doubleSignedAttachmentList)) {
            doubleSignedAttachmentList.stream().forEach(attach -> {
                attach.setContractId(id);
                attach.setFileType(AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(doubleSignedAttachmentList, RkAttachmentEntity.class);
            this.attachmentService.saveBatch(attachmentEntityList);
            entity.setDoubleSignedAttachment(1);
        } else {
            entity.setDoubleSignedAttachment(0);
        }
        this.update(id, entity);
        return map;
    }

    @Override
    @DSTransactional
    public HashMap updateContract(String id, RkContractUpForm rkContractUpForm) throws DataException {
        String[] split;
        Object byId;
        List<RkContractEntity> listByCode;
        DictionaryDataEntity info;
        HashMap map = MapUtil.newHashMap();
        UserInfo userInfo = this.userProvider.get();
        if (StrUtil.isNotEmpty((CharSequence)rkContractUpForm.getContractCode())) {
            rkContractUpForm.setContractCode(rkContractUpForm.getContractCode().trim());
        } else if (StringUtils.isNotEmpty((String)rkContractUpForm.getJcContractType()) && ObjectUtil.isNotNull((Object)(info = this.dictionaryDataService.getInfo(rkContractUpForm.getJcContractType())))) {
            String billNumber = null;
            try {
                billNumber = this.baseDataUtil.getBillNumber("JCContractCode" + info.getEnCode(), Boolean.valueOf(false));
            }
            catch (DataException e) {
                throw new RuntimeException(e);
            }
            rkContractUpForm.setContractCode(billNumber);
        }
        RkContractEntity entity = this.getInfo(id);
        if (!ObjectUtil.isEmpty((Object)rkContractUpForm.getContractCode()) && CollectionUtil.isNotEmpty(listByCode = this.getListByCode(rkContractUpForm.getContractCode())) && (listByCode.size() > 1 || listByCode.size() == 1 && !StrUtil.equals((CharSequence)listByCode.get(0).getId(), (CharSequence)id))) {
            map.put("error", "\u5408\u540c\u53f7\u91cd\u590d");
            return map;
        }
        if (!StrUtil.equals((CharSequence)rkContractUpForm.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark())) {
            if (rkContractUpForm.getIsMoreTax() != null && rkContractUpForm.getIsMoreTax() == 1 || rkContractUpForm.getCostIsMoreTax() != null && StrUtil.equals((CharSequence)rkContractUpForm.getCostIsMoreTax(), (CharSequence)"1")) {
                if (CollectionUtil.isEmpty(rkContractUpForm.getTaxList())) {
                    map.put("error", "\u8bf7\u5b8c\u5584\u591a\u7a0e\u7387\u4fe1\u606f");
                    return map;
                }
            } else {
                rkContractUpForm.setTaxList(CollectionUtil.list((boolean)false));
            }
        }
        RkContractEntity subentity = (RkContractEntity)JsonUtil.getJsonToBean((Object)rkContractUpForm, RkContractEntity.class);
        if (rkContractUpForm.getIsChangeAmout().booleanValue()) {
            BigDecimal nowAmount = entity.getContractAmount().add(new BigDecimal(rkContractUpForm.getChangeAmout()));
            subentity.setContractAmount(nowAmount);
            subentity.setChangeTime(new Date());
            subentity.setChangeUser(userInfo.getUserId());
            subentity.setIsChange(1);
            if (ObjectUtil.isNull((Object)entity.getReturnAmount())) {
                entity.setReturnAmount(BigDecimal.ZERO);
            }
            if (nowAmount.compareTo(entity.getReturnAmount()) != -1) {
                if (StrUtil.equals((CharSequence)entity.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_COMPLETED.getEnableMark())) {
                    subentity.setEnableMark(ContractEnableMarkEnum.ENABLE_EXECUTE.getEnableMark());
                }
            } else {
                subentity.setEnableMark(ContractEnableMarkEnum.ENABLE_COMPLETED.getEnableMark());
            }
            if (MathUtils.toBigDecimal(rkContractUpForm.getChangeAmout()).compareTo(BigDecimal.ZERO) != 0) {
                subentity.setIsChangeNow(1);
                String divide = MathUtils.divide(MathUtils.multiply(!ObjectUtil.isEmpty((Object)entity.getReturnAmount()) ? entity.getReturnAmount().toString() : "0", "100"), nowAmount.toString());
                subentity.setReturnRatio(MathUtils.toBigDecimal(divide));
                if (StrUtil.equals((CharSequence)entity.getReturnState(), (CharSequence)(ReturnPlanEnum.END.getState() + "")) && subentity.getReturnRatio().compareTo(new BigDecimal("100")) == 0) {
                    subentity.setReturnState(ReturnPlanEnum.END.getState() + "");
                }
                String invoice = MathUtils.divide(MathUtils.multiply(!ObjectUtil.isEmpty((Object)entity.getInvoiceAmount()) ? entity.getInvoiceAmount().toString() : "0", "100"), nowAmount.toString());
                subentity.setInvoiceProportion(MathUtils.toBigDecimal(invoice));
                List<RkContractPaymentVO> paymentList = rkContractUpForm.getPaymentList();
                if (CollectionUtil.isNotEmpty(paymentList)) {
                    for (RkContractPaymentVO m : paymentList) {
                        String divide1 = MathUtils.divide(m.getPaymentRatio(), "100", 2);
                        String multiply = MathUtils.multiply(nowAmount.toString(), divide1);
                        m.setReceivableAmount(multiply);
                    }
                }
                rkContractUpForm.setPaymentList(paymentList);
            }
            subentity.setChangeReason(rkContractUpForm.getChangeReason());
        } else if (!StrUtil.equals((CharSequence)entity.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark())) {
            subentity.setContractAmount(entity.getContractAmount());
        }
        if (!ObjectUtil.isEmpty((Object)subentity.getContractAmount()) && !ObjectUtil.isEmpty((Object)subentity.getContractTaxRate())) {
            this.countContractTaxAmountNew(subentity);
        }
        if (!ObjectUtil.isEmpty((Object)subentity.getIsArchived()) && subentity.getIsArchived() == 1 && entity.getIsArchived() == 0) {
            subentity.setArchivedBy(userInfo.getUserId());
            subentity.setArchivedTime(new Date());
        }
        if (!ObjectUtil.isEmpty((Object)subentity.getIsAgent()) && subentity.getIsAgent() == 1 && ObjectUtil.isEmpty((Object)(byId = (RkAgentEntity)this.agentService.getById((Serializable)((Object)subentity.getAgentId()))))) {
            byId = new RkAgentEntity();
            ((RkAgentEntity)byId).setName(subentity.getAgentId());
            ((RkAgentEntity)byId).setCompanyId(entity.getCompanyId());
            ((RkAgentEntity)byId).setId(RandomUtil.uuId());
            this.agentService.save(byId);
            subentity.setAgentId(((RkAgentEntity)byId).getId());
        }
        if (CollectionUtil.isNotEmpty(rkContractUpForm.getPaymentList())) {
            List<RkContractPaymentVO> paymentList = rkContractUpForm.getPaymentList();
            paymentList.stream().forEach(payment -> {
                if (!ObjectUtil.isEmpty((Object)payment.getPaymentName()) && ObjectUtil.isEmpty((Object)payment.getPaymentType())) {
                    payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                }
            });
            String objectToString = JsonUtil.getObjectToString(paymentList);
            subentity.setPaymentJson(objectToString);
            List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
            List oldIdList = listByContractId.stream().map(RkContractPaymentEntity::getId).collect(Collectors.toList());
            List newIdList = paymentList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getId())).map(RkContractPaymentVO::getId).collect(Collectors.toList());
            List needRemoveIdList = oldIdList.stream().filter(x -> !newIdList.contains(x)).collect(Collectors.toList());
            this.contractPaymentService.removeBatchByIds(needRemoveIdList);
            List jsonToList = JsonUtil.getJsonToList(paymentList, RkContractPaymentEntity.class);
            jsonToList.stream().forEach(x -> {
                x.setContractId(id);
                if (ObjectUtil.isEmpty((Object)x.getId())) {
                    x.setId(RandomUtil.uuId());
                }
            });
            this.contractPaymentService.saveOrUpdateBatch(jsonToList);
        }
        if (CollectionUtil.isNotEmpty(rkContractUpForm.getTaxList())) {
            List jsonToList = JsonUtil.getJsonToList(rkContractUpForm.getTaxList(), RkContractTaxEntity.class);
            jsonToList.stream().forEach(tax -> {
                tax.setContractId(entity.getId());
                tax.setId(RandomUtil.uuId());
            });
            this.contractTaxService.deleteByContractId(entity.getId());
            this.contractTaxService.saveBatch(jsonToList);
        }
        if (!ObjectUtil.isEmpty((Object)subentity.getCustomerId())) {
            byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)subentity.getCustomerId()));
            subentity.setCustomerAddress(((CrmCustomerEntity)byId).getAddress());
            subentity.setCustomerAddressName(this.baseDataUtil.provinceData(subentity.getCustomerAddress()));
            String[] split2 = ((CrmCustomerEntity)byId).getAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
            for (int i = 0; i < split2.length; ++i) {
                if (i == 0) {
                    subentity.setCustomerRegion(split2[0]);
                    subentity.setCustomerRegionName(this.baseDataUtil.provinceData(subentity.getCustomerRegion()));
                }
                if (i == 1) {
                    subentity.setCustomerProv(split2[1]);
                    subentity.setCustomerProvName(this.baseDataUtil.provinceData(subentity.getCustomerProv()));
                }
                if (i != 2) continue;
                subentity.setCustomerCity(split2[2]);
                subentity.setCustomerCityName(this.baseDataUtil.provinceData(subentity.getCustomerCity()));
            }
        }
        if (!ObjectUtil.isEmpty((Object)subentity.getSalerId())) {
            subentity.setSalerName(this.baseDataUtil.userSelectValueNoAccount(subentity.getSalerId()));
        }
        if (!ObjectUtil.isEmpty((Object)subentity.getRegion())) {
            subentity.setRegionName(this.baseDataUtil.provinceData(subentity.getRegion()));
        }
        if (!ObjectUtil.isEmpty((Object)subentity.getDepartmentTree()) && (split = subentity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
            subentity.setDepartmentTreeName(this.baseDataUtil.comSelectValues(subentity.getDepartmentTree()));
            subentity.setDepartmentOne(split[0]);
            subentity.setDepartmentOneName(this.baseDataUtil.comSelectValues(subentity.getDepartmentOne()));
            subentity.setDepartment(split[split.length - 1]);
            subentity.setDepartmentName(this.baseDataUtil.comSelectValues(subentity.getDepartment()));
        }
        if (!StrUtil.equals((CharSequence)subentity.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark())) {
            CrmCustomerMyCrForm crForm = new CrmCustomerMyCrForm(subentity.getCustomerId(), subentity.getSalerId(), "1", 1, 1, "1");
            this.crmCustomerMyService.saveCrmCustomer(crForm);
        }
        this.saleContractCustomerService.removeByContractId(id);
        if (StringUtils.isNotEmpty((String)subentity.getCustomerIds())) {
            this.saleContractCustomerService.insertListByCustomerIds(id, subentity.getCustomerIds());
        }
        if (ObjectUtil.equals((Object)subentity.getIsAgent(), (Object)1)) {
            subentity.setAgentIds(subentity.getAgentId());
        } else {
            subentity.setAgentId(subentity.getCustomerId());
            subentity.setAgentIds(subentity.getCustomerIds());
        }
        RkContractEntity contractEntity = new RkContractEntity();
        BeanUtils.copyProperties((Object)subentity, (Object)contractEntity);
        if (this.rkContractService.checkContractIsExist(contractEntity)) {
            throw new DataException("\u5408\u540c\u5df2\u5b58\u5728\uff01");
        }
        this.update(id, subentity);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(RkContractEntity::getCompanyId, (Object)entity.getCompanyId());
        if (ObjectUtil.isEmpty((Object)subentity.getRetentionMoneyRatio())) {
            updateWrapper.set(RkContractEntity::getRetentionMoneyRatio, null);
        }
        if (ObjectUtil.isEmpty((Object)subentity.getRetentionMoneyAmount())) {
            updateWrapper.set(RkContractEntity::getRetentionMoneyAmount, null);
        }
        if (ObjectUtil.isEmpty((Object)subentity.getWarranty())) {
            updateWrapper.set(RkContractEntity::getWarranty, null);
        }
        if (ObjectUtil.isEmpty((Object)subentity.getAgreedAcceptanceDate())) {
            updateWrapper.set(RkContractEntity::getAgreedAcceptanceDate, null);
        }
        if (rkContractUpForm.isChangeFlow()) {
            updateWrapper.set(RkContractEntity::getChangeTaskId, null);
            updateWrapper.set(RkContractEntity::getChangeTaskEnable, null);
        }
        updateWrapper.eq(RkContractEntity::getId, (Object)id);
        this.update((Wrapper)updateWrapper);
        List<RkContractProjectEntity> projectEntityList = this.rkContractProjectService.getListByContractId(id);
        if (CollectionUtil.isNotEmpty(projectEntityList)) {
            boolean isChangeAmount = ConvertUtil.toBigDecimal((Object)entity.getContractAmount(), (BigDecimal)BigDecimal.ZERO).compareTo(ConvertUtil.toBigDecimal((Object)subentity.getContractAmount(), (BigDecimal)BigDecimal.ZERO)) != 0;
            projectEntityList.stream().forEach(project -> {
                project.setSalerId(subentity.getSalerId());
                project.setSalerName(subentity.getSalerName());
                if (isChangeAmount) {
                    if (null != project.getProjectRatio()) {
                        if (project.getProjectRatio().compareTo(new BigDecimal(100)) == 0) {
                            project.setProjectAmount(subentity.getContractAmount());
                        } else {
                            BigDecimal multiply = MathUtils.multiply(project.getProjectRatio(), new BigDecimal(rkContractUpForm.getContractAmount()));
                            BigDecimal divide = MathUtils.divide(multiply, new BigDecimal(100), 2);
                            project.setProjectAmount(divide);
                        }
                    } else {
                        project.setProjectAmount(BigDecimal.ZERO);
                    }
                }
                if (ObjectUtil.isNotNull((Object)project.getReceivedAmount())) {
                    BigDecimal divide = MathUtils.divide(MathUtils.multiply(project.getReceivedAmount(), new BigDecimal(100)), project.getProjectAmount(), 2);
                    project.setReceivedRatio(divide);
                    if (project.getReceivedRatio().compareTo(new BigDecimal("100")) != -1) {
                        project.setReceivedState(ReturnPlanEnum.END.getState());
                    } else {
                        project.setReceivedState(ReturnPlanEnum.START.getState());
                    }
                }
            });
            this.rkContractProjectService.saveOrUpdateBatch(projectEntityList);
        }
        this.contractProductService.deleteByContractId(id);
        List<RkContractProductUpForm> productList = rkContractUpForm.getProductList();
        productList.stream().forEach(product -> product.setContractId(id));
        if (!StrUtil.equals((CharSequence)subentity.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark())) {
            this.crmProductRelationService.deleteByContractId(entity.getId());
            productList.forEach(product -> {
                CrmProductBuyEntity byId = (CrmProductBuyEntity)this.crmProductBuyService.getById((Serializable)((Object)product.getProductId()));
                if (ObjectUtil.isNotNull((Object)byId)) {
                    return;
                }
                CrmProductRelationEntity infoByProductId = this.crmProductRelationService.getInfoByProductId(product.getProductId(), entity.getCustomerId());
                if (ObjectUtil.isEmpty((Object)infoByProductId)) {
                    infoByProductId = new CrmProductRelationEntity();
                    infoByProductId.setId(RandomUtil.uuId());
                    infoByProductId.setCreatorUserId(userInfo.getUserId());
                    infoByProductId.setCreatorTime(DateUtil.getNowDate());
                    infoByProductId.setSalesmanId(entity.getSalerId());
                    infoByProductId.setContractId(entity.getId());
                    infoByProductId.setCustomerId(entity.getCustomerId());
                    infoByProductId.setProductId(product.getProductId());
                    infoByProductId.setCompanyId(entity.getCompanyId());
                    infoByProductId.setProductVersion(product.getProductVersionName());
                    this.crmProductRelationService.save(infoByProductId);
                }
            });
            CrmCustomerEntity byId2 = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()));
            if (!ObjectUtil.isEmpty((Object)byId2) && !StrUtil.equals((CharSequence)byId2.getEnabledMark(), (CharSequence)"company")) {
                byId2.setEnabledMark("company");
                this.crmCustomerService.update(byId2.getId(), byId2);
            }
        }
        List productEntityList = JsonUtil.getJsonToList(productList, RkContractProductEntity.class);
        this.contractProductService.saveBatch(productEntityList);
        this.attachmentService.deleteByContractId(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
        List<RkAttachmentUpForm> attachmentList = rkContractUpForm.getAttachmentList();
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(id);
                attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
            this.attachmentService.saveBatch(attachmentEntityList);
            entity.setIsHaveAttachment(1);
        } else {
            entity.setIsHaveAttachment(0);
        }
        this.attachmentService.deleteByContractId(id, AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType());
        List<RkAttachmentUpForm> doubleSignedAttachmentList = rkContractUpForm.getDoubleSignedAttachmentList();
        if (CollectionUtil.isNotEmpty(doubleSignedAttachmentList)) {
            doubleSignedAttachmentList.stream().forEach(attach -> {
                attach.setContractId(id);
                attach.setFileType(AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(doubleSignedAttachmentList, RkAttachmentEntity.class);
            this.attachmentService.saveBatch(attachmentEntityList);
            entity.setDoubleSignedAttachment(1);
        } else {
            entity.setDoubleSignedAttachment(0);
        }
        if (rkContractUpForm.getIsChangeAmout().booleanValue()) {
            RkContractChangeEntity contractChangeEntity = new RkContractChangeEntity();
            contractChangeEntity.setContractId(id);
            contractChangeEntity.setId(RandomUtil.uuId());
            contractChangeEntity.setBeforeAmount(entity.getContractAmount());
            contractChangeEntity.setChangeAmount(new BigDecimal(rkContractUpForm.getChangeAmout()));
            contractChangeEntity.setAfterAmount(subentity.getContractAmount());
            contractChangeEntity.setAfterBody(JsonUtil.getObjectToString((Object)rkContractUpForm));
            List<RkContractProductEntity> listByContractId = this.contractProductService.getListByContractId(id);
            entity.setProductList(listByContractId);
            List<RkAttachmentEntity> listByContractId1 = this.attachmentService.getListByContractIdAndFileType(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
            entity.setAttachmentList(listByContractId1);
            contractChangeEntity.setBeforeBody(JsonUtil.getObjectToString((Object)entity));
            contractChangeEntity.setChangeReason(rkContractUpForm.getChangeReason());
            this.contractChangeService.save(contractChangeEntity);
        }
        if (!StrUtil.equals((CharSequence)entity.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark()) || rkContractUpForm.isChangeFlow()) {
            if (!StrUtil.equals((CharSequence)entity.getAgentId(), (CharSequence)subentity.getAgentId())) {
                Object byId3;
                String agentName = "";
                if (subentity.getIsAgent() == 1) {
                    byId3 = (RkAgentEntity)this.agentService.getById((Serializable)((Object)subentity.getAgentId()));
                    if (ObjectUtil.isNotNull((Object)byId3)) {
                        agentName = ((RkAgentEntity)byId3).getName();
                    }
                } else {
                    byId3 = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)subentity.getCustomerId()));
                    if (ObjectUtil.isNotNull((Object)byId3)) {
                        agentName = ((CrmCustomerEntity)byId3).getName();
                    }
                }
                this.contractSendRecordService.updateAgent(agentName, subentity.getAgentId(), subentity.getId());
            }
            if (!StrUtil.equals((CharSequence)entity.getCustomerId(), (CharSequence)subentity.getCustomerId()) || !StrUtil.equals((CharSequence)entity.getAgentId(), (CharSequence)subentity.getAgentId())) {
                this.contractReturnPlanService.updateAgentAndCustomer(subentity.getAgentId(), subentity.getCustomerId(), subentity.getId());
            }
        }
        this.contractReturnPlanService.updateByChange(rkContractUpForm);
        this.contractCollectionRecordService.updateByChange(rkContractUpForm);
        this.contractInvoiceService.updateByChange(rkContractUpForm.getAgentId(), rkContractUpForm.getCustomerId(), id);
        this.contractInvoiceDetailService.updateByChange(rkContractUpForm.getAgentId(), id);
        try {
            this.toCustomerCompany(entity.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private BigDecimal countContractTaxAmount(RkContractEntity entity) {
        String dicName = this.baseDataUtil.getDictName(entity.getContractTaxRate(), "4360623057975783732");
        dicName = dicName.replace("%", "");
        BigDecimal taxAmout = entity.getContractAmount().multiply(new BigDecimal(dicName)).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        return taxAmout;
    }

    private void countContractTaxAmountNew(RkContractEntity entity) {
        String dicName = this.baseDataUtil.getDictName(entity.getContractTaxRate(), "4360623057975783732").replace("%", "");
        String add = MathUtils.add("1", MathUtils.divide(dicName, "100", 2));
        String amountExcludingTax = MathUtils.divide(entity.getContractAmount().toString(), add, 2);
        String contractTaxAmount = MathUtils.substract(entity.getContractAmount().toString(), amountExcludingTax);
        entity.setAmountExcludingTax(MathUtils.toBigDecimal(amountExcludingTax));
        entity.setContractTaxAmount(MathUtils.toBigDecimal(contractTaxAmount));
        if (!ObjectUtil.isEmpty((Object)entity.getRetentionMoneyRatio())) {
            String divide1 = MathUtils.divide(entity.getRetentionMoneyRatio().toString(), "100", 2);
            String multiply = MathUtils.multiply(entity.getContractAmount().toString(), divide1);
            entity.setRetentionMoneyAmount(MathUtils.toBigDecimal(multiply));
        }
    }

    @Override
    public List<RkContractEntity> listSimpleByCustomerIdAndEnableMarkIn(String customerId, List<String> enableMark) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(RkContractEntity::getCustomerIds, (Object)customerId);
        queryWrapper.eq(RkContractEntity::getCompanyId, (Object)this.userProvider.get().getOrganizeId());
        if (CollectionUtil.isNotEmpty(enableMark)) {
            queryWrapper.in(RkContractEntity::getEnableMark, enableMark);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> listSimpleByAgentIdAndEnableMarkIn(String agentId, List<String> enableMark) {
        UserInfo userInfo = this.userProvider.get();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.like(RkContractEntity::getAgentIds, (Object)agentId)).eq(RkContractEntity::getCompanyId, (Object)userInfo.getOrganizeId())).in(RkContractEntity::getEnableMark, enableMark);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> listSimpleByAgentIdAndCustomerIdAndEnableMarkIn(String agentId, String customerId, List<String> enableMark) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        UserInfo userInfo = this.userProvider.get();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.like(RkContractEntity::getAgentIds, (Object)agentId)).eq(RkContractEntity::getCompanyId, (Object)userInfo.getOrganizeId())).like(RkContractEntity::getCustomerIds, (Object)customerId)).in(RkContractEntity::getEnableMark, enableMark);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> listByCompanyId(String companyId, RkContractPagination rkContractPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)companyId);
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getContractName())) {
            queryWrapper.lambda().like(RkContractEntity::getContractName, (Object)rkContractPagination.getContractName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getContractCode())) {
            queryWrapper.lambda().like(RkContractEntity::getContractCode, (Object)rkContractPagination.getContractCode());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getContractType())) {
            queryWrapper.lambda().eq(RkContractEntity::getContractType, (Object)rkContractPagination.getContractType());
        }
        boolean flag = false;
        List customerIdList = CollectionUtil.list((boolean)false);
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getGrade()) || !ObjectUtil.isEmpty(rkContractPagination.getCustomerCreateDate())) {
            List<CrmCustomerEntity> listByGrade = this.crmCustomerService.getListByGradeAndCreateDate(rkContractPagination.getGrade(), rkContractPagination.getCustomerCreateDate());
            customerIdList = listByGrade.stream().map(CrmCustomerEntity::getId).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(customerIdList)) {
                flag = true;
            }
            if (!ObjectUtil.isEmpty((Object)rkContractPagination.getCustomerId()) && !customerIdList.contains(rkContractPagination.getCustomerId())) {
                flag = true;
            }
        }
        List idList = CollectionUtil.list((boolean)false);
        if (StrUtil.isNotEmpty((CharSequence)rkContractPagination.getCustomerName())) {
            List<CrmCustomerEntity> list = this.crmCustomerService.getInfoByCustomerName(rkContractPagination.getCustomerName());
            idList = list.stream().map(CrmCustomerEntity::getId).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(list)) {
                flag = true;
            }
        }
        List agentIdList = CollectionUtil.list((boolean)false);
        if (!ObjectUtil.isEmpty(rkContractPagination.getAgentCreateDate())) {
            List<RkAgentEntity> listByCreateDate = this.agentService.getListByCreateDate(rkContractPagination.getAgentCreateDate());
            agentIdList = listByCreateDate.stream().map(RkAgentEntity::getId).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(agentIdList)) {
                flag = true;
            }
            if (!ObjectUtil.isEmpty((Object)rkContractPagination.getAgentId()) && !agentIdList.contains(rkContractPagination.getAgentId())) {
                flag = true;
            }
        }
        if (flag) {
            return null;
        }
        if (!ObjectUtil.isEmpty((Object)rkContractPagination.getAgentId())) {
            queryWrapper.lambda().like(RkContractEntity::getAgentIds, (Object)rkContractPagination.getAgentId());
        } else if (CollectionUtil.isNotEmpty((Collection)agentIdList)) {
            queryWrapper.lambda().in(RkContractEntity::getAgentId, agentIdList);
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getCustomerId())) {
            queryWrapper.lambda().like(RkContractEntity::getCustomerIds, (Object)rkContractPagination.getCustomerId());
        } else if (CollectionUtil.isNotEmpty(customerIdList)) {
            queryWrapper.lambda().in(RkContractEntity::getCustomerId, customerIdList);
        } else if (CollectionUtil.isNotEmpty(idList)) {
            queryWrapper.lambda().in(RkContractEntity::getCustomerId, idList);
        }
        Page page = new Page(rkContractPagination.getCurrentPage(), rkContractPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return rkContractPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    @Override
    public List<RkContractEntity> getListBy(RkContractCollectionRecordPagination rkContractCollectionRecordPagination) {
        DateTime parse;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getCompanyId())) {
            queryWrapper.eq(RkContractEntity::getCompanyId, (Object)rkContractCollectionRecordPagination.getCompanyId());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getCustomerId())) {
            queryWrapper.like(RkContractEntity::getCustomerIds, (Object)rkContractCollectionRecordPagination.getCustomerId());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getIncomeType())) {
            queryWrapper.like(RkContractEntity::getIncomeType, (Object)rkContractCollectionRecordPagination.getIncomeType());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getContractType())) {
            queryWrapper.eq(RkContractEntity::getContractType, (Object)rkContractCollectionRecordPagination.getContractType());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getSalerId())) {
            queryWrapper.eq(RkContractEntity::getSalerId, (Object)rkContractCollectionRecordPagination.getSalerId());
        }
        if (!ObjectUtil.isEmpty(rkContractCollectionRecordPagination.getSalerIds())) {
            queryWrapper.in(RkContractEntity::getSalerId, rkContractCollectionRecordPagination.getSalerIds());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getAgentId())) {
            queryWrapper.like(RkContractEntity::getAgentIds, (Object)rkContractCollectionRecordPagination.getAgentId());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getContractCode())) {
            queryWrapper.like(RkContractEntity::getContractCode, (Object)rkContractCollectionRecordPagination.getContractCode().replaceAll("\\s+", ""));
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getContractName())) {
            queryWrapper.like(RkContractEntity::getContractName, (Object)rkContractCollectionRecordPagination.getContractName());
        }
        if (CollectionUtil.isNotEmpty(rkContractCollectionRecordPagination.getSignDate())) {
            parse = cn.hutool.core.date.DateUtil.parse((CharSequence)(cn.hutool.core.date.DateUtil.formatDate((Date)rkContractCollectionRecordPagination.getSignDate().get(1)) + " 23:59:59"));
            queryWrapper.between(RkContractEntity::getSignDate, (Object)rkContractCollectionRecordPagination.getSignDate().get(0), (Object)parse);
        }
        if (CollectionUtil.isNotEmpty(rkContractCollectionRecordPagination.getArchivedDate())) {
            parse = cn.hutool.core.date.DateUtil.parse((CharSequence)(cn.hutool.core.date.DateUtil.formatDate((Date)rkContractCollectionRecordPagination.getArchivedDate().get(1)) + " 23:59:59"));
            queryWrapper.between(RkContractEntity::getArchivedTime, (Object)rkContractCollectionRecordPagination.getArchivedDate().get(0), (Object)parse);
        }
        if (StringUtils.isNotEmpty(rkContractCollectionRecordPagination.getCustomerAddress())) {
            queryWrapper.and(x -> {
                for (List<String> ll : rkContractCollectionRecordPagination.getCustomerAddress()) {
                    List addressList = JsonUtil.getJsonToList(ll, String.class);
                    if (addressList.size() > 1) {
                        String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                        collect = "[" + collect;
                        ((LambdaQueryWrapper)x.or()).like(RkContractEntity::getCustomerAddress, (Object)collect);
                        continue;
                    }
                    String s2 = (String)addressList.get(addressList.size() - 1);
                    s2 = "[\"" + s2 + "\"";
                    ((LambdaQueryWrapper)x.or()).like(RkContractEntity::getCustomerAddress, (Object)s2);
                }
            });
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getInvoiceListBy(RkContractInvoicePagination rkContractInvoicePagination) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (!ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getCompanyId())) {
            queryWrapper.eq(RkContractEntity::getCompanyId, (Object)rkContractInvoicePagination.getCompanyId());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getCustomerId())) {
            queryWrapper.like(RkContractEntity::getCustomerIds, (Object)rkContractInvoicePagination.getCustomerId());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getAgentId())) {
            queryWrapper.like(RkContractEntity::getAgentIds, (Object)rkContractInvoicePagination.getAgentId());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getContractCode())) {
            queryWrapper.like(RkContractEntity::getContractCode, (Object)rkContractInvoicePagination.getContractCode());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractInvoicePagination.getContractName())) {
            queryWrapper.like(RkContractEntity::getContractName, (Object)rkContractInvoicePagination.getContractName());
        }
        if (!ObjectUtil.isEmpty(rkContractInvoicePagination.getSearchRegion())) {
            queryWrapper.in(RkContractEntity::getRegion, rkContractInvoicePagination.getSearchRegion());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByAgentId(String agentId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(RkContractEntity::getAgentIds, (Object)agentId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByMasterId(String masterId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkContractEntity::getMasterId, (Object)masterId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListNotHaveAttachmentAndArrivalExpectedReturnTime(Date arrivalDate) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(RkContractEntity::getEnableMark, (Object)ContractEnableMarkEnum.ENABLE_EXECUTE.getEnableMark())).eq(RkContractEntity::getIsHaveAttachment, (Object)0)).lt(RkContractEntity::getExpectedReturnTime, (Object)arrivalDate);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByEnableMark(String enableMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractEntity::getEnableMark, (Object)enableMark);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByEnableMarkAndCompanyId(String enableMark, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)companyId)).eq(RkContractEntity::getEnableMark, (Object)enableMark);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractEntity::getContractCode, (Object)code);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByCode(String code, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractEntity::getContractCode, (Object)code)).eq(RkContractEntity::getCompanyId, (Object)companyId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByContractCodeLike(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(RkContractEntity::getContractCode, (Object)code);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByName(String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractEntity::getContractName, (Object)name);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByNameAndCompanyId(String name, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)companyId)).eq(RkContractEntity::getContractName, (Object)name);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByCodeOrName(String code, String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(RkContractEntity::getContractCode, (Object)code)).or()).eq(RkContractEntity::getContractName, (Object)name));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByCodeAndName(String code, String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractEntity::getContractCode, (Object)code)).eq(RkContractEntity::getContractName, (Object)name);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByCompanyIdAndNotDraft(String companyId, String customerId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)companyId);
        if (StrUtil.isNotEmpty((CharSequence)customerId)) {
            queryWrapper.lambda().like(RkContractEntity::getCustomerIds, (Object)customerId);
        }
        queryWrapper.lambda().ne(RkContractEntity::getEnableMark, (Object)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByCompanyIdAndNotDraftNotHaveProject(String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)companyId)).ne(RkContractEntity::getEnableMark, (Object)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark());
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.lambda().select(new SFunction[]{RkContractProjectEntity::getContractId}).eq(RkContractProjectEntity::getEnabledMark, (Object)1);
        List list = this.rkContractProjectService.list((Wrapper)queryWrapper1);
        List collect = list.stream().map(RkContractProjectEntity::getContractId).collect(Collectors.toList());
        queryWrapper.lambda().notIn(RkContractEntity::getId, collect);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByCompanyIdAndEnableMarkIn(RkContractQueryVO queryVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)queryVO.getCompanyId())) {
            queryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)queryVO.getCompanyId());
        }
        if (ObjectUtil.isNotEmpty((Object)queryVO.getAgentId())) {
            queryWrapper.lambda().like(RkContractEntity::getAgentIds, (Object)queryVO.getAgentId());
        }
        if (ObjectUtil.isNotEmpty((Object)queryVO.getCustomerId())) {
            queryWrapper.lambda().like(RkContractEntity::getCustomerIds, (Object)queryVO.getCustomerId());
        }
        if (CollectionUtil.isNotEmpty(queryVO.getEnableMarkList())) {
            queryWrapper.lambda().in(RkContractEntity::getEnableMark, queryVO.getEnableMarkList());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListBySignDate(List<Date> signDate) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().between(RkContractEntity::getSignDate, (Object)signDate.get(0), (Object)signDate.get(1));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListBySignDateAndAgentId(List<Date> signDate, String agentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtil.isNotEmpty(signDate)) {
            queryWrapper.lambda().between(RkContractEntity::getSignDate, (Object)signDate.get(0), (Object)signDate.get(1));
        }
        if (!ObjectUtil.isEmpty((Object)agentId)) {
            queryWrapper.lambda().like(RkContractEntity::getAgentIds, (Object)agentId);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> importPreview(List<ContractImportVO> contractList) {
        int i;
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        for (i = 0; i < contractList.size(); ++i) {
            Map dataRowMap = new HashMap();
            ContractImportVO model = contractList.get(i);
            dataRowMap = (Map)JsonUtil.getJsonToBean((Object)model, Map.class);
            dataRow.add(dataRowMap);
        }
        for (i = 1; i <= contractList.size(); ++i) {
            HashMap<String, Object> columnsMap = new HashMap<String, Object>();
            columnsMap.put("AllowDBNull", true);
            columnsMap.put("AutoIncrement", false);
            columnsMap.put("AutoIncrementSeed", 0);
            columnsMap.put("AutoIncrementStep", 1);
            columnsMap.put("Caption", this.getColumns(i));
            columnsMap.put("ColumnMapping", 1);
            columnsMap.put("ColumnName", this.getColumns(i));
            columnsMap.put("Container", null);
            columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
            columnsMap.put("DateTimeMode", 3);
            columnsMap.put("DefaultValue", null);
            columnsMap.put("DesignMode", false);
            columnsMap.put("Expression", "");
            columnsMap.put("ExtendedProperties", "");
            columnsMap.put("MaxLength", -1);
            columnsMap.put("Namespace", "");
            columnsMap.put("Ordinal", 0);
            columnsMap.put("Prefix", "");
            columnsMap.put("ReadOnly", false);
            columnsMap.put("Site", null);
            columnsMap.put("Table", contractList);
            columnsMap.put("Unique", false);
            columns.add(columnsMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u8d44\u4ea7\u540d\u79f0");
        map.put(2, "\u8d44\u4ea7\u7c7b\u578b");
        map.put(3, "RFID\u7f16\u53f7");
        map.put(4, "\u6240\u5c5e\u7a7a\u95f4");
        map.put(5, "\u91c7\u8d2d\u65e5\u671f");
        map.put(6, "\u89c4\u683c\u63cf\u8ff0");
        return (String)map.get(key);
    }

    @Override
    public ContractImportReturnVO importData(List<ContractImportVO> dataList) {
        UserInfo userInfo = this.userProvider.get();
        String companyId = userInfo.getOrganizeId();
        HashMap dictMap = MapUtil.newHashMap();
        List<DictEncodeEnum> allToList = DictEncodeEnum.getAllToList();
        allToList.stream().forEach(dictEncodeEnum -> {
            String encode = dictEncodeEnum.getEncode();
            DictionaryTypeEntity typeEntityList = this.dictionaryTypeService.getInfoByEnCode(encode);
            String dictionaryTypeId = typeEntityList.getId();
            List data = this.dictionaryDataService.getList(dictionaryTypeId, Boolean.valueOf(true));
            if (StrUtil.equals((CharSequence)encode, (CharSequence)DictEncodeEnum.ENABLEMARK_DICT.getEncode())) {
                Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getEnCode));
                dictMap.put(encode, collect);
            } else {
                Map<String, String> collect = data.stream().collect(Collectors.toMap(DictionaryDataEntity::getFullName, DictionaryDataEntity::getId));
                dictMap.put(encode, collect);
            }
        });
        HashMap<String, String> incomeTypeMap = new HashMap<String, String>();
        CrmProductCategoryEntity categoryEntity = null;
        QueryWrapper categoryQueryWrapper = new QueryWrapper();
        List contractList = CollectionUtil.list((boolean)false);
        List errorList = CollectionUtil.list((boolean)false);
        boolean successNum = false;
        int errorNum = 0;
        List errorMsgList = CollectionUtil.list((boolean)false);
        for (ContractImportVO contractImportVO : dataList) {
            UserEntity byRealName1;
            String a2;
            CrmCustomerEntity infoByFullName;
            contractImportVO.setEnableMark(ContractEnableMarkEnum.ENABLE_DRAFT.getDesc());
            String enableMark = "";
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getEnableMark())) {
                Map stringStringMap = (Map)dictMap.get(DictEncodeEnum.ENABLEMARK_DICT.getEncode());
                String s = (String)stringStringMap.get(contractImportVO.getEnableMark());
                if (StrUtil.isEmpty((CharSequence)s)) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u5408\u540c\u72b6\u6001\u4e0d\u5b58\u5728");
                    log.info("\u5408\u540c\u72b6\u6001\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getEnableMark());
                    errorMsgList.add(contractImportVO.getErrMsg());
                } else {
                    enableMark = s;
                }
            } else {
                ++errorNum;
                contractImportVO.setErrMsg("\u8bf7\u9009\u62e9\u5408\u540c\u72b6\u6001");
                errorMsgList.add(contractImportVO.getErrMsg());
            }
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getContractCode())) {
                contractImportVO.setContractCode(StrUtil.trim((CharSequence)contractImportVO.getContractCode()));
                if (CollectionUtil.isNotEmpty(this.getListByCode(contractImportVO.getContractCode()))) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u5408\u540c\u7f16\u53f7\u91cd\u590d");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.error("\u5408\u540c\u7f16\u53f7\u91cd\u590d:{}", (Object)contractImportVO.getContractCode());
                }
            } else {
                ++errorNum;
                contractImportVO.setErrMsg("\u8bf7\u586b\u5199\u5408\u540c\u7f16\u53f7");
                errorMsgList.add(contractImportVO.getErrMsg());
            }
            String customerId = "";
            if (StrUtil.isEmpty((CharSequence)contractImportVO.getCustomerId())) {
                ++errorNum;
                contractImportVO.setErrMsg("\u8bf7\u586b\u5199\u6700\u7ec8\u7528\u6237");
                errorMsgList.add(contractImportVO.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)(infoByFullName = this.crmCustomerService.getInfoByFullName(contractImportVO.getCustomerId())))) {
                ++errorNum;
                contractImportVO.setErrMsg("\u6700\u7ec8\u7528\u6237\u4e0d\u5b58\u5728");
                errorMsgList.add(contractImportVO.getErrMsg());
                log.info("\u6700\u7ec8\u7528\u6237\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getCustomerId());
            } else {
                customerId = infoByFullName.getId();
            }
            if (StrUtil.isEmpty((CharSequence)contractImportVO.getAgentId())) {
                ++errorNum;
                contractImportVO.setErrMsg("\u8bf7\u586b\u5199\u6700\u7ec8\u5bf9\u8c61");
                errorMsgList.add(contractImportVO.getErrMsg());
            }
            String a1 = StrUtil.isNotEmpty((CharSequence)contractImportVO.getCustomerId()) ? contractImportVO.getCustomerId().trim() : "";
            String string = a2 = StrUtil.isNotEmpty((CharSequence)contractImportVO.getAgentId()) ? contractImportVO.getAgentId().trim() : "";
            if (StrUtil.equals((CharSequence)a1, (CharSequence)a2)) {
                contractImportVO.setIsAgent("\u5426");
            } else {
                contractImportVO.setIsAgent("\u662f");
            }
            if (StrUtil.isEmpty((CharSequence)contractImportVO.getIsAgent())) {
                ++errorNum;
                contractImportVO.setErrMsg("\u8bf7\u9009\u62e9\u662f\u5426\u662f\u4ee3\u7406\u5546");
                errorMsgList.add(contractImportVO.getErrMsg());
            }
            String agentId = "";
            String isAgent = "0";
            if (StrUtil.isEmpty((CharSequence)contractImportVO.getIsAgent()) || StrUtil.equals((CharSequence)contractImportVO.getIsAgent(), (CharSequence)"\u5426")) {
                isAgent = "0";
                agentId = customerId;
            } else {
                List<RkAgentEntity> byAgentNameAndCompanyId;
                isAgent = "1";
                if (StrUtil.isEmpty((CharSequence)contractImportVO.getAgentId())) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u8bf7\u586b\u5199\u6700\u7ec8\u5bf9\u8c61");
                    errorMsgList.add(contractImportVO.getErrMsg());
                }
                if (CollectionUtil.isEmpty(byAgentNameAndCompanyId = this.agentService.findByAgentNameAndCompanyId(contractImportVO.getAgentId(), companyId))) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u5408\u540c\u5bf9\u8c61\u4e0d\u5b58\u5728");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.info("\u5408\u540c\u5bf9\u8c61\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getAgentId());
                } else {
                    agentId = byAgentNameAndCompanyId.get(0).getId();
                }
            }
            String incomeType = "";
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getIncomeType())) {
                if (incomeTypeMap.containsKey(contractImportVO.getIncomeType())) {
                    incomeType = (String)incomeTypeMap.get(contractImportVO.getIncomeType());
                } else {
                    categoryQueryWrapper.lambda().eq(CrmProductCategoryEntity::getName, (Object)contractImportVO.getIncomeType());
                    categoryEntity = (CrmProductCategoryEntity)this.crmProductCategoryService.getOne((Wrapper)categoryQueryWrapper);
                    if (null != categoryEntity) {
                        incomeTypeMap.put(contractImportVO.getIncomeType(), categoryEntity.getId());
                        incomeType = categoryEntity.getId();
                    } else {
                        incomeTypeMap.put(contractImportVO.getIncomeType(), null);
                    }
                }
                if (StrUtil.isEmpty((CharSequence)incomeType)) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u4ea7\u54c1\u5927\u7c7b\u672a\u5728\u4ea7\u54c1\u5e93\u7ef4\u62a4");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.info("\u4ea7\u54c1\u5927\u7c7b\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getIncomeType());
                }
            } else {
                ++errorNum;
                contractImportVO.setErrMsg("\u8bf7\u9009\u62e9\u4ea7\u54c1\u5927\u7c7b");
                errorMsgList.add(contractImportVO.getErrMsg());
            }
            String contractType = "";
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getContractType())) {
                Map stringStringMap = (Map)dictMap.get(DictEncodeEnum.CONTRACT_TYPE_DICT.getEncode());
                String s = (String)stringStringMap.get(contractImportVO.getContractType());
                if (StrUtil.isEmpty((CharSequence)s)) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u5408\u540c\u7c7b\u578b\u672a\u5728\u6570\u636e\u5b57\u5178\u7ef4\u62a4");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.info("\u5408\u540c\u7c7b\u578b\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getContractType());
                } else {
                    contractType = s;
                }
            } else {
                ++errorNum;
                contractImportVO.setErrMsg("\u8bf7\u9009\u62e9\u5408\u540c\u7c7b\u578b");
                errorMsgList.add(contractImportVO.getErrMsg());
            }
            String industryType = "";
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getIndustryType())) {
                Map stringStringMap = (Map)dictMap.get(DictEncodeEnum.INDUSTRY_TYPE_DICT.getEncode());
                String s = (String)stringStringMap.get(contractImportVO.getIndustryType());
                if (StrUtil.isEmpty((CharSequence)s)) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u884c\u4e1a\u7c7b\u578b\u672a\u5728\u6570\u636e\u5b57\u5178\u7ef4\u62a4");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.info("\u884c\u4e1a\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getIndustryType());
                } else {
                    industryType = s;
                }
            } else {
                ++errorNum;
                contractImportVO.setErrMsg("\u8bf7\u9009\u62e9\u884c\u4e1a\u7c7b\u578b");
                errorMsgList.add(contractImportVO.getErrMsg());
            }
            String specialType = "";
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getSpecialType())) {
                Map<String, SpecialTypeEnum> allToMap = SpecialTypeEnum.getAllToMap();
                if (ObjectUtil.isEmpty((Object)((Object)allToMap.get(contractImportVO.getSpecialType())))) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u7279\u6b8a\u5408\u540c\u7c7b\u578b\u4e0d\u5b58\u5728");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.error("\u7279\u6b8a\u5408\u540c\u7c7b\u578b\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getSpecialType());
                } else {
                    specialType = allToMap.get(contractImportVO.getSpecialType()).getSpecialType();
                }
            }
            if (StrUtil.isEmpty((CharSequence)contractImportVO.getContractAmount())) {
                ++errorNum;
                contractImportVO.setErrMsg("\u5408\u540c\u603b\u91d1\u989d\u672a\u586b\u5199");
                errorMsgList.add(contractImportVO.getErrMsg());
                log.info("\u672a\u586b\u5199\u5408\u540c\u603b\u91d1\u989d");
            }
            String contractTaxRate = "";
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getContractTaxRate())) {
                Map stringStringMap = (Map)dictMap.get(DictEncodeEnum.CONTRACT_RATE_DICT.getEncode());
                String s = (String)stringStringMap.get(contractImportVO.getContractTaxRate());
                if (StrUtil.isEmpty((CharSequence)s)) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u5408\u540c\u7a0e\u7387\u4e0d\u5b58\u5728");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.info("\u5408\u540c\u7a0e\u7387\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getContractTaxRate());
                } else {
                    contractTaxRate = s;
                }
            } else {
                ++errorNum;
                contractImportVO.setErrMsg("\u8bf7\u9009\u62e9\u5408\u540c\u7a0e\u7387");
                errorMsgList.add(contractImportVO.getErrMsg());
            }
            if (ObjectUtil.isEmpty((Object)contractImportVO.getSignDate())) {
                ++errorNum;
                contractImportVO.setErrMsg("\u8bf7\u586b\u5199\u7b7e\u8ba2\u65e5\u671f");
                errorMsgList.add(contractImportVO.getErrMsg());
            } else {
                Date date = DateUtil.dateAddMonths((Date)DateUtil.stringToDate((String)contractImportVO.getSignDate()), (int)1);
                contractImportVO.setExpectedReturnTime(date);
            }
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getProfit()) && MathUtils.toBigDecimal(contractImportVO.getProfit()).compareTo(MathUtils.toBigDecimal(contractImportVO.getContractAmount())) == 1) {
                ++errorNum;
                contractImportVO.setErrMsg("\u6bdb\u5229\u6da6\u5927\u4e8e\u5408\u540c\u989d");
                errorMsgList.add(contractImportVO.getErrMsg());
                log.info("\u5408\u540c\u72b6\u6001\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getEnableMark());
            }
            boolean isNoSaler = false;
            String salerId = "";
            String salerName = contractImportVO.getSalerId();
            String deparmentTreeName = "";
            String deparmentOneName = "";
            String deparmentName = "";
            StringBuffer sb = new StringBuffer();
            LinkedList strings = CollectionUtil.newLinkedList((Object[])new String[0]);
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getSalerId())) {
                List userEntityList = this.userService.getByRealName(contractImportVO.getSalerId(), userInfo.getOrganizeId());
                UserEntity byRealName = null;
                if (CollectionUtil.isEmpty((Collection)userEntityList)) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u9500\u552e\u4eba\u5458\u672a\u5f55\u5165\u7cfb\u7edf\u6216\u8005\u5df2\u7ecf\u79bb\u804c");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.info("\u9500\u552e\u4eba\u5458\u4e0d\u5728\u7cfb\u7edf:{}", (Object)contractImportVO.getSalerId());
                    isNoSaler = true;
                } else if (userEntityList.size() > 1) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u9500\u552e\u4eba\u5458\u5728\u516c\u53f8\u5b58\u5728\u591a\u4e2a");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.info("\u9500\u552e\u4eba\u5458\u5728\u516c\u53f8\u5b58\u5728\u591a\u4e2a:{}", (Object)contractImportVO.getSalerId());
                    isNoSaler = true;
                } else {
                    byRealName = (UserEntity)userEntityList.get(0);
                    salerId = byRealName.getId();
                }
                if (ObjectUtil.isNotNull((Object)byRealName)) {
                    QueryWrapper query = new QueryWrapper();
                    query.lambda().eq(UserRelationEntity::getUserId, (Object)byRealName.getId());
                    query.lambda().eq(UserRelationEntity::getObjectType, (Object)"Organize");
                    ArrayList organizeIds = new ArrayList();
                    List list = this.userRelationService.list((Wrapper)query);
                    list.forEach(u -> organizeIds.add(u.getObjectId()));
                    List organizeIdTree = PermissionUtil.getOrgIdsTree(organizeIds, (Integer)1, (OrganizeService)this.organizeService);
                    List organizeIdNoCompanyTree = CollectionUtil.list((boolean)false);
                    if (CollectionUtil.isNotEmpty((Collection)organizeIdTree)) {
                        strings = (LinkedList)organizeIdTree.get(0);
                        if (CollectionUtil.isNotEmpty((Collection)strings)) {
                            strings.remove(0);
                            strings.remove(0);
                            organizeIdNoCompanyTree.add(strings);
                        }
                        strings = (LinkedList)organizeIdNoCompanyTree.get(0);
                        String join = String.join((CharSequence)",", strings);
                        sb.append("[");
                        sb.append(join);
                        sb.append("]");
                        deparmentTreeName = this.baseDataUtil.comSelectValues(join);
                        deparmentOneName = this.baseDataUtil.comSelectValues((String)strings.get(0));
                        deparmentName = this.baseDataUtil.comSelectValues((String)strings.get(strings.size() - 1));
                    }
                }
            }
            Integer isSupplement = 0;
            String masterId = "";
            if (StrUtil.isEmpty((CharSequence)contractImportVO.getIsSupplement()) || StrUtil.equals((CharSequence)contractImportVO.getIsSupplement(), (CharSequence)"\u5426")) {
                isSupplement = 0;
            } else {
                List<RkContractEntity> listByCode;
                isSupplement = 1;
                if (StrUtil.isEmpty((CharSequence)contractImportVO.getMasterId())) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u672a\u586b\u5199\u4e3b\u5408\u540c");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.info("\u672a\u586b\u5199\u4e3b\u5408\u540c");
                }
                if (CollectionUtil.isEmpty(listByCode = this.getListByCode(contractImportVO.getMasterId()))) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u4e3b\u5408\u540c\u4e0d\u5b58\u5728");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.info("\u4e3b\u5408\u540c\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getMasterId());
                }
                masterId = listByCode.get(0).getMasterId();
            }
            String region = "";
            List data = this.provinceService.getListByParentId("-1");
            Map<String, String> collect = data.stream().collect(Collectors.toMap(ProvinceEntity::getFullName, ProvinceEntity::getId));
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getRegion())) {
                if (StrUtil.isEmpty((CharSequence)collect.get(contractImportVO.getRegion()))) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u5927\u533a\u4e0d\u5b58\u5728");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.error("\u5927\u533a\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getRegion());
                } else {
                    region = collect.get(contractImportVO.getRegion());
                }
            } else if (!isNoSaler) {
                List arealist = this.userRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"Area")).eq(UserRelationEntity::getUserId, (Object)salerId));
                if (CollectionUtil.isNotEmpty((Collection)arealist)) {
                    List authAreaIdList = arealist.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(authAreaIdList)) {
                        String s = (String)authAreaIdList.get(0);
                        String h = s.split(",")[0];
                        h = h.replace("[", "");
                        region = h = h.replace("]", "").replaceAll("\"", "");
                    } else {
                        ++errorNum;
                        contractImportVO.setErrMsg("\u9500\u552e\u4eba\u5458\u672a\u6388\u6743\u533a\u57df");
                        errorMsgList.add(contractImportVO.getErrMsg());
                    }
                } else {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u9500\u552e\u4eba\u5458\u672a\u6388\u6743\u533a\u57df");
                    errorMsgList.add(contractImportVO.getErrMsg());
                }
            }
            Integer isArchived = 0;
            isArchived = StrUtil.isEmpty((CharSequence)contractImportVO.getIsArchived()) || StrUtil.equals((CharSequence)contractImportVO.getIsArchived(), (CharSequence)"\u5426") ? Integer.valueOf(0) : Integer.valueOf(1);
            String archivedLocation = "";
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getArchivedLocation())) {
                Map stringStringMap = (Map)dictMap.get(DictEncodeEnum.ARCHIVE_LOCATION_DICT.getEncode());
                if (StrUtil.isEmpty((CharSequence)((CharSequence)stringStringMap.get(contractImportVO.getArchivedLocation())))) {
                    ++errorNum;
                    contractImportVO.setErrMsg("\u6863\u6848\u76d2\u4f4d\u7f6e\u672a\u5728\u6570\u636e\u5b57\u5178\u7ef4\u62a4");
                    errorMsgList.add(contractImportVO.getErrMsg());
                    log.info("\u6863\u6848\u76d2\u4f4d\u7f6e\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getArchivedLocation());
                } else {
                    archivedLocation = (String)stringStringMap.get(contractImportVO.getArchivedLocation());
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getArchivedBy()) && ObjectUtil.isEmpty((Object)(byRealName1 = this.userService.getByRealName(contractImportVO.getArchivedBy())))) {
                ++errorNum;
                contractImportVO.setErrMsg("\u5f52\u6863\u4eba\u4e0d\u5b58\u5728");
                errorMsgList.add(contractImportVO.getErrMsg());
                log.error("\u5f52\u6863\u4eba\u4e0d\u5b58\u5728:{}", (Object)contractImportVO.getArchivedBy());
            }
            if (StrUtil.isNotEmpty((CharSequence)contractImportVO.getWarranty()) && !NumberUtil.isInteger((String)contractImportVO.getWarranty())) {
                ++errorNum;
                contractImportVO.setErrMsg("\u8d28\u4fdd\u671f\u9650\u5fc5\u987b\u662f\u6574\u6570");
                errorMsgList.add(contractImportVO.getErrMsg());
                log.error("\u8d28\u4fdd\u671f\u9650\u5fc5\u987b\u662f\u6574\u6570:{}", (Object)contractImportVO.getWarranty());
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                contractImportVO.setErrMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                contractImportVO.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(contractImportVO);
                continue;
            }
            String dicName = contractImportVO.getContractTaxRate().replace("%", "");
            String add = MathUtils.add("1", MathUtils.divide(dicName, "100", 2));
            String amountExcludingTax = MathUtils.divide(contractImportVO.getContractAmount().toString(), add, 2);
            String contractTaxAmount = MathUtils.substract(contractImportVO.getContractAmount().toString(), amountExcludingTax);
            contractImportVO.setAmountExcludingTax(MathUtils.toBigDecimal(amountExcludingTax));
            contractImportVO.setContractTaxAmount(MathUtils.toBigDecimal(contractTaxAmount));
            if (!ObjectUtil.isEmpty((Object)contractImportVO.getRetentionMoneyRatio())) {
                String divide1 = MathUtils.divide(contractImportVO.getRetentionMoneyRatio().toString(), "100", 2);
                String multiply = MathUtils.multiply(contractImportVO.getContractAmount().toString(), divide1);
                contractImportVO.setRetentionMoneyAmount(MathUtils.toBigDecimal(multiply));
            }
            contractImportVO.setSignDate(DateUtil.cstFormat((String)contractImportVO.getSignDate()));
            contractImportVO.setAgreedAcceptanceDate(DateUtil.cstFormat((String)contractImportVO.getAgreedAcceptanceDate()));
            contractImportVO.setArchivedTime(DateUtil.cstFormat((String)contractImportVO.getArchivedTime()));
            contractImportVO.setContractAmount(MathUtils.toBigDecimal(contractImportVO.getContractAmount()).toString());
            contractImportVO.setProfit(MathUtils.toBigDecimal(contractImportVO.getProfit()).toString());
            contractImportVO.setSalerId(salerId);
            contractImportVO.setContractType(contractType);
            contractImportVO.setIndustryType(industryType);
            contractImportVO.setSpecialType(specialType);
            contractImportVO.setCustomerId(customerId);
            contractImportVO.setAgentId(agentId);
            contractImportVO.setIncomeType(incomeType);
            contractImportVO.setEnableMark(enableMark);
            contractImportVO.setContractTaxRate(contractTaxRate);
            contractImportVO.setIsSupplement(isSupplement + "");
            contractImportVO.setMasterId(masterId);
            contractImportVO.setIsAgent(isAgent);
            contractImportVO.setRegion(region);
            contractImportVO.setIsArchived(isArchived + "");
            contractImportVO.setArchivedLocation(archivedLocation);
            RkContractEntity jsonToBean = (RkContractEntity)JsonUtil.getJsonToBean((Object)contractImportVO, RkContractEntity.class);
            jsonToBean.setActSendAmount(BigDecimal.ZERO);
            jsonToBean.setCompanyId(userInfo.getOrganizeId());
            jsonToBean.setRegionName(region);
            if (StrUtil.isNotEmpty((CharSequence)salerId)) {
                jsonToBean.setSalerName(salerName);
                jsonToBean.setDepartmentTreeName(deparmentTreeName);
                jsonToBean.setDepartmentOneName(deparmentOneName);
                jsonToBean.setDepartmentName(deparmentName);
                if (CollectionUtil.isNotEmpty((Collection)strings)) {
                    jsonToBean.setDepartmentOne((String)strings.get(0));
                    if (strings.size() > 1) {
                        jsonToBean.setDepartment((String)strings.get(strings.size() - 1));
                    } else {
                        jsonToBean.setDepartment((String)strings.get(0));
                    }
                }
                jsonToBean.setDepartmentTree(sb.toString());
            } else {
                jsonToBean.setDepartmentTree("[]");
            }
            jsonToBean.setIsHaveAttachment(0);
            jsonToBean.setDoubleSignedAttachment(0);
            if (!ObjectUtil.isEmpty((Object)jsonToBean.getCustomerId())) {
                CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)jsonToBean.getCustomerId()));
                jsonToBean.setCustomerAddress(byId.getAddress());
                jsonToBean.setCustomerAddressName(this.baseDataUtil.provinceData(jsonToBean.getCustomerAddress()));
                String[] split = byId.getAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
                for (int i = 0; i < split.length; ++i) {
                    if (i == 0) {
                        jsonToBean.setCustomerRegion(split[0]);
                        jsonToBean.setCustomerRegionName(this.baseDataUtil.provinceData(jsonToBean.getCustomerRegion()));
                    }
                    if (i == 1) {
                        jsonToBean.setCustomerProv(split[1]);
                        jsonToBean.setCustomerProvName(this.baseDataUtil.provinceData(jsonToBean.getCustomerProv()));
                    }
                    if (i != 2) continue;
                    jsonToBean.setCustomerCity(split[2]);
                    jsonToBean.setCustomerCityName(this.baseDataUtil.provinceData(jsonToBean.getCustomerCity()));
                }
            }
            String mainId = RandomUtil.uuId();
            jsonToBean.setId(mainId);
            jsonToBean.setContractSource(2);
            contractList.add(jsonToBean);
        }
        this.saveBatch(contractList);
        contractList.stream().forEach(contract -> {
            try {
                this.toCustomerCompany(contract.getId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ContractImportReturnVO vo = new ContractImportReturnVO();
        vo.setSnum(contractList.size());
        vo.setFnum(errorList.size());
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, ContractImportVO.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    @Override
    public DownloadVO exportExceptionData(List<Object> dataList, Object o) {
        Map declaredFieldsInfo2 = MapUtil.newHashMap();
        try {
            declaredFieldsInfo2 = ReflectionUtil.getDeclaredFieldsInfo2((Object)o, (Map)MapUtil.newHashMap());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        DownloadVO vo = this.exportUtil(declaredFieldsInfo2, "\u9519\u8bef\u62a5\u544a", dataList);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadVO exportUtil(Map<String, String> fileds, String explain, List<Object> modeList) {
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList(modeList, Object.class));
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        for (String s : fileds.keySet()) {
            ExcelExportEntity excelExportEntity = new ExcelExportEntity(s, (Object)fileds.get(s));
            entitys.add(excelExportEntity);
        }
        ExportParams exportParams = new ExportParams(null, "\u9519\u8bef\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        DownloadVO vo = DownloadVO.builder().build();
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, (Collection)list);
                    Iterator sheetIterator = workbook.sheetIterator();
                    while (sheetIterator.hasNext()) {
                        Iterator rowIterator = ((Sheet)sheetIterator.next()).rowIterator();
                        while (rowIterator.hasNext()) {
                            Iterator cellIterator = ((Row)rowIterator.next()).cellIterator();
                            while (cellIterator.hasNext()) {
                                Cell cell = (Cell)cellIterator.next();
                                String cellValue = cell.getStringCellValue().trim();
                                CellStyle groundStyle = workbook.createCellStyle();
                                Font font = workbook.createFont();
                                if (cell.getColumnIndex() != 0) continue;
                                groundStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                                groundStyle.setFillForegroundColor(IndexedColors.RED.getIndex());
                                cell.setCellStyle(groundStyle);
                            }
                        }
                    }
                }
                String name = explain + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(fileName);
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(this.userProvider.get().getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return vo;
    }

    @Override
    public void toCustomerCompany(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().ne(RkContractEntity::getEnableMark, (Object)"draft");
        if (StrUtil.isNotEmpty((CharSequence)id)) {
            queryWrapper.lambda().eq(RkContractEntity::getId, (Object)id);
        }
        List list = this.list((Wrapper)queryWrapper);
        for (RkContractEntity entity : list) {
            CrmCustomerCompanyRelationEntity relationEntity;
            List<CrmCustomerCompanyRelationEntity> ll;
            CrmCustomerEntity byId;
            if (StrUtil.isNotEmpty((CharSequence)entity.getCustomerId()) && !ObjectUtil.isEmpty((Object)(byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()))))) {
                byId.setEnabledMark("company");
                this.crmCustomerService.update(byId.getId(), byId);
            }
            if (CollectionUtil.isEmpty(ll = this.crmCustomerCompanyRelationService.getByCustomerAndCompanyIdAndSource(entity.getCustomerId(), entity.getCompanyId(), null))) {
                relationEntity = new CrmCustomerCompanyRelationEntity();
                relationEntity.setCustomerId(entity.getCustomerId());
                relationEntity.setCompanyId(entity.getCompanyId());
                relationEntity.setSource("2");
                relationEntity.setId(RandomUtil.uuId());
                this.crmCustomerCompanyRelationService.save(relationEntity);
                continue;
            }
            relationEntity = ll.get(0);
            if (relationEntity.getSource().contains("2")) continue;
            relationEntity.setSource("1,2");
            this.crmCustomerCompanyRelationService.update(relationEntity.getId(), relationEntity);
        }
    }

    @Override
    public long countByCustomerId(String customerId) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)userInfo.getOrganizeId())).like(RkContractEntity::getCustomerIds, (Object)customerId)).ne(RkContractEntity::getEnableMark, (Object)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark());
        HashMap map = this.roleUtils.canSeeUserId(userInfo);
        if (!ObjectUtil.isEmpty((Object)map) && map.size() > 0) {
            List salerIdList;
            if (!((Boolean)map.get("isAll")).booleanValue() && CollectionUtil.isNotEmpty((Collection)(salerIdList = (List)map.get("idList")))) {
                queryWrapper.lambda().in(RkContractEntity::getSalerId, (Collection)salerIdList);
            }
        } else {
            queryWrapper.lambda().eq(RkContractEntity::getSalerId, (Object)userInfo.getUserId());
        }
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public long countByCustomerId(String customerId, String menuId) {
        Object rkContractObj;
        QueryWrapper rkContractQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractQueryWrapper, menuId, "rk_contract"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return 0L;
            }
            rkContractQueryWrapper = (QueryWrapper)rkContractObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractQueryWrapper, menuId, "rk_contract"));
            if (ObjectUtil.isEmpty((Object)rkContractObj)) {
                return 0L;
            }
            rkContractQueryWrapper = (QueryWrapper)rkContractObj;
        }
        QueryWrapper queryWrapper = rkContractQueryWrapper;
        ((LambdaQueryWrapper)queryWrapper.lambda().like(RkContractEntity::getCustomerIds, (Object)customerId)).ne(RkContractEntity::getEnableMark, (Object)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark());
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public long countBySaleDataSummary(SaleDataSummaryVo saleDataSummaryVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)saleDataSummaryVo.getCompanyId())).ne(RkContractEntity::getEnableMark, (Object)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark());
        if (CollectionUtil.isNotEmpty(saleDataSummaryVo.getUserIdList())) {
            queryWrapper.lambda().in(RkContractEntity::getSalerId, saleDataSummaryVo.getUserIdList());
        }
        if (ObjectUtil.isNotNull((Object)saleDataSummaryVo.getStartDate())) {
            queryWrapper.lambda().ge(RkContractEntity::getCreatorTime, (Object)saleDataSummaryVo.getStartDate());
        }
        if (ObjectUtil.isNotNull((Object)saleDataSummaryVo.getEndDate())) {
            queryWrapper.lambda().le(RkContractEntity::getCreatorTime, (Object)saleDataSummaryVo.getEndDate());
        }
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> sumAmountBySaleDataSummary(SaleDataSummaryVo saleDataSummaryVo) {
        Map map1;
        Map map = MapUtil.newHashMap();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum(contract_amount) as totalContractAmount,sum(profit) as totalProfit"});
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)saleDataSummaryVo.getCompanyId())).ne(RkContractEntity::getEnableMark, (Object)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark());
        if (CollectionUtil.isNotEmpty(saleDataSummaryVo.getUserIdList())) {
            queryWrapper.lambda().in(RkContractEntity::getSalerId, saleDataSummaryVo.getUserIdList());
        }
        if (ObjectUtil.isNotNull((Object)saleDataSummaryVo.getStartDate())) {
            queryWrapper.lambda().ge(RkContractEntity::getCreatorTime, (Object)saleDataSummaryVo.getStartDate());
        }
        if (ObjectUtil.isNotNull((Object)saleDataSummaryVo.getEndDate())) {
            queryWrapper.lambda().le(RkContractEntity::getCreatorTime, (Object)saleDataSummaryVo.getEndDate());
        }
        if (!ObjectUtil.isEmpty((Object)(map1 = this.getMap((Wrapper)queryWrapper)))) {
            map = map1;
        }
        return map;
    }

    @Override
    public List getContractComprehensiveInfo(RkContractPaginationExportModel rkContractPagination) {
        if (StringUtils.isEmpty((String)rkContractPagination.getDataType()) || !StringUtils.equals((CharSequence)rkContractPagination.getDataType(), (CharSequence)"1")) {
            PageHelper.startPage((int)((int)rkContractPagination.getCurrentPage()), (int)((int)rkContractPagination.getPageSize()));
        }
        if (!ObjectUtil.isEmpty(rkContractPagination.getSignDate())) {
            rkContractPagination.setStartDate(rkContractPagination.getSignDate().get(0));
            rkContractPagination.setEndDate(rkContractPagination.getSignDate().get(1));
        }
        List<RkContractExportImplementAccountsModel> contractComprehensiveInfo = ((RkContractMapper)this.baseMapper).getContractComprehensiveInfo(rkContractPagination);
        List contractTypeList = this.dictionaryDataService.getList("4360554102108073011");
        List contractLevelList = this.dictionaryDataService.getList("511876947723411077");
        List contractEnabledMarkList = this.dictionaryDataService.getList("437934151459446533");
        List procureEnabledMarkList = this.dictionaryDataService.getList("545230487157748805");
        List organizeEntityList = this.organizeService.list();
        for (RkContractExportImplementAccountsModel rkContractExportImplementAccountsModel : contractComprehensiveInfo) {
            StringBuffer stringBuffer;
            List<String> list;
            String str1 = rkContractExportImplementAccountsModel.getInvoiceAmount() == null ? "0.00" : rkContractExportImplementAccountsModel.getInvoiceAmount();
            String str2 = rkContractExportImplementAccountsModel.getContractAmount() == null ? "0.00" : rkContractExportImplementAccountsModel.getContractAmount();
            BigDecimal yInvoiceMent = new BigDecimal(str1);
            BigDecimal contractAmount = new BigDecimal(str2);
            BigDecimal wInvoiceMent = contractAmount.subtract(yInvoiceMent);
            if (!StrUtil.isBlank((CharSequence)rkContractExportImplementAccountsModel.getExpectedReturnTime())) {
                rkContractExportImplementAccountsModel.setExpectedReturnTime(rkContractExportImplementAccountsModel.getExpectedReturnTime().substring(0, 10));
            }
            if (contractAmount.compareTo(BigDecimal.ZERO) > 0) {
                Iterator ratio = wInvoiceMent.divide(contractAmount, 2, RoundingMode.HALF_UP);
                String multiply = ((BigDecimal)((Object)ratio)).multiply(new BigDecimal("100")) + "%";
                rkContractExportImplementAccountsModel.setNoInvoiceAmountRatio(multiply);
            }
            rkContractExportImplementAccountsModel.setNoInvoiceAmount(String.valueOf(wInvoiceMent));
            if (!StrUtil.isBlank((CharSequence)rkContractExportImplementAccountsModel.getContractType())) {
                for (DictionaryDataEntity dictionaryDataEntity : contractTypeList) {
                    if (!rkContractExportImplementAccountsModel.getContractType().equals(dictionaryDataEntity.getId())) continue;
                    rkContractExportImplementAccountsModel.setContractType(dictionaryDataEntity.getFullName());
                    break;
                }
            }
            if (!StrUtil.isBlank((CharSequence)rkContractExportImplementAccountsModel.getContractLevel())) {
                for (DictionaryDataEntity dictionaryDataEntity : contractLevelList) {
                    if (!rkContractExportImplementAccountsModel.getContractLevel().equals(dictionaryDataEntity.getId())) continue;
                    rkContractExportImplementAccountsModel.setContractLevel(dictionaryDataEntity.getFullName());
                    break;
                }
            }
            if (!StrUtil.isBlank((CharSequence)rkContractExportImplementAccountsModel.getEnabledMark())) {
                for (DictionaryDataEntity dictionaryDataEntity : contractEnabledMarkList) {
                    if (!rkContractExportImplementAccountsModel.getEnabledMark().equals(dictionaryDataEntity.getEnCode())) continue;
                    rkContractExportImplementAccountsModel.setEnabledMark(dictionaryDataEntity.getFullName());
                    break;
                }
            }
            if (!StrUtil.isBlank((CharSequence)rkContractExportImplementAccountsModel.getProcureEnabledMark())) {
                for (DictionaryDataEntity dictionaryDataEntity : procureEnabledMarkList) {
                    if (!rkContractExportImplementAccountsModel.getProcureEnabledMark().equals(dictionaryDataEntity.getEnCode())) continue;
                    rkContractExportImplementAccountsModel.setProcureEnabledMark(dictionaryDataEntity.getFullName());
                    break;
                }
            }
            if (!StrUtil.isBlank((CharSequence)rkContractExportImplementAccountsModel.getProjectManager())) {
                list = Arrays.asList(rkContractExportImplementAccountsModel.getProjectManager().split(","));
                stringBuffer = new StringBuffer();
                for (String s : list) {
                    if (StrUtil.isBlank((CharSequence)s)) continue;
                    UserEntity info = this.userService.getInfo(s);
                    stringBuffer.append(info.getRealName() + ",");
                }
                String projectManager = stringBuffer.toString();
                String projectManagerStr = "";
                if (!StrUtil.isBlank((CharSequence)projectManager) && projectManager.endsWith(",") && projectManager.length() > 3) {
                    projectManagerStr = projectManager.substring(0, projectManager.length() - 1);
                }
                rkContractExportImplementAccountsModel.setProjectManager(projectManagerStr);
            }
            if (StrUtil.isBlank((CharSequence)rkContractExportImplementAccountsModel.getBelongDepartment())) continue;
            list = Arrays.asList(rkContractExportImplementAccountsModel.getBelongDepartment().split(","));
            stringBuffer = new StringBuffer();
            for (String s : list) {
                for (OrganizeEntity organizeEntity : organizeEntityList) {
                    if (!organizeEntity.getId().equals(s)) continue;
                    stringBuffer.append(organizeEntity.getFullName() + ",");
                }
            }
            String organize = stringBuffer.toString();
            String organizeStr = "";
            if (!StrUtil.isBlank((CharSequence)organize) && organize.endsWith(",") && organize.length() > 3) {
                organizeStr = organize.substring(0, organize.length() - 1);
            }
            rkContractExportImplementAccountsModel.setBelongDepartment(organizeStr);
        }
        if (StringUtils.isEmpty((String)rkContractPagination.getDataType()) || !StringUtils.equals((CharSequence)rkContractPagination.getDataType(), (CharSequence)"1")) {
            PageInfo pageInfo = new PageInfo(contractComprehensiveInfo);
            return rkContractPagination.setData(pageInfo.getList(), pageInfo.getTotal());
        }
        return contractComprehensiveInfo;
    }

    @Override
    public List getProductChannelInfo(RkContractPaginationExportModel rkContractPagination) {
        if (StringUtils.isEmpty((String)rkContractPagination.getDataType()) || !StringUtils.equals((CharSequence)rkContractPagination.getDataType(), (CharSequence)"1")) {
            PageHelper.startPage((int)((int)rkContractPagination.getCurrentPage()), (int)((int)rkContractPagination.getPageSize()));
        }
        if (!ObjectUtil.isEmpty(rkContractPagination.getSignDate())) {
            rkContractPagination.setStartDate(rkContractPagination.getSignDate().get(0));
            DateTime parse = DateUtil.parse((CharSequence)(DateUtil.formatDate((Date)rkContractPagination.getSignDate().get(1)) + " 23:59:59"));
            rkContractPagination.setEndDate((Date)parse);
        }
        List<RkProductChannelInfoModel> contractComprehensiveInfo = ((RkContractMapper)this.baseMapper).getProductChannelInfo(rkContractPagination);
        List contractTypeList = this.dictionaryDataService.getList("4360554102108073011");
        List contractLevelList = this.dictionaryDataService.getList("511876947723411077");
        List contractEnabledMarkList = this.dictionaryDataService.getList("437934151459446533");
        List procureEnabledMarkList = this.dictionaryDataService.getList("545230487157748805");
        List changeTypeList = this.dictionaryDataService.getList("590558189825575877");
        List productCategoryList = this.crmProductCategoryService.list((Wrapper)new QueryWrapper());
        Map productCategoryMap = productCategoryList.stream().collect(Collectors.toMap(CrmProductCategoryEntity::getId, Function.identity()));
        List organizeEntityList = this.organizeService.list();
        for (RkProductChannelInfoModel rkContractExportImplementAccountsModel : contractComprehensiveInfo) {
            String str1 = rkContractExportImplementAccountsModel.getInvoiceAmount() == null ? "0.00" : rkContractExportImplementAccountsModel.getInvoiceAmount();
            String str2 = rkContractExportImplementAccountsModel.getContractAmount() == null ? "0.00" : rkContractExportImplementAccountsModel.getContractAmount();
            BigDecimal yInvoiceMent = new BigDecimal(str1);
            BigDecimal contractAmount = new BigDecimal(str2);
            BigDecimal wInvoiceMent = contractAmount.subtract(yInvoiceMent);
            if (contractAmount.compareTo(BigDecimal.ZERO) > 0) {
                Iterator ratio = wInvoiceMent.divide(contractAmount, 2, RoundingMode.HALF_UP);
                String multiply = ((BigDecimal)((Object)ratio)).multiply(new BigDecimal("100")) + "%";
                rkContractExportImplementAccountsModel.setNoInvoiceAmountRatio(multiply);
            }
            rkContractExportImplementAccountsModel.setNoInvoiceAmount(String.valueOf(wInvoiceMent));
            if (!StrUtil.isBlank((CharSequence)rkContractExportImplementAccountsModel.getEnabledMark())) {
                for (DictionaryDataEntity dictionaryDataEntity : contractEnabledMarkList) {
                    if (!rkContractExportImplementAccountsModel.getEnabledMark().equals(dictionaryDataEntity.getEnCode())) continue;
                    rkContractExportImplementAccountsModel.setEnabledMark(dictionaryDataEntity.getFullName());
                    break;
                }
            }
            if (!StrUtil.isBlank((CharSequence)rkContractExportImplementAccountsModel.getChannelType())) {
                for (DictionaryDataEntity dictionaryDataEntity : changeTypeList) {
                    if (!rkContractExportImplementAccountsModel.getChannelType().equals(dictionaryDataEntity.getEnCode())) continue;
                    rkContractExportImplementAccountsModel.setChannelType(dictionaryDataEntity.getFullName());
                    break;
                }
            }
            if (!StrUtil.isBlank((CharSequence)rkContractExportImplementAccountsModel.getProductName())) {
                String productName = rkContractExportImplementAccountsModel.getProductName().replace("\\", "").replace("[", "").replace("]", "");
                String[] productIds = productName.split(",");
                List names = CollectionUtil.list((boolean)false);
                for (int i = 0; i < productIds.length; ++i) {
                    CrmProductCategoryEntity e;
                    if (!ObjectUtil.isNotEmpty((Object)productIds[i]) || !ObjectUtil.isNotEmpty((Object)(e = (CrmProductCategoryEntity)productCategoryMap.get(productIds[i])))) continue;
                    names.add(e.getName());
                }
                rkContractExportImplementAccountsModel.setProductName(names.stream().collect(Collectors.joining(",")));
            }
            if (StrUtil.isNotEmpty((CharSequence)rkContractExportImplementAccountsModel.getSignDate())) {
                rkContractExportImplementAccountsModel.setSignDate(StrUtil.sub((CharSequence)rkContractExportImplementAccountsModel.getSignDate(), (int)0, (int)10));
            }
            if (StrUtil.isNotEmpty((CharSequence)rkContractExportImplementAccountsModel.getAcceptanceDate())) {
                rkContractExportImplementAccountsModel.setAcceptanceDate(StrUtil.sub((CharSequence)rkContractExportImplementAccountsModel.getAcceptanceDate(), (int)0, (int)10));
            }
            if (StrUtil.isNotEmpty((CharSequence)rkContractExportImplementAccountsModel.getWarrantyStartTime())) {
                rkContractExportImplementAccountsModel.setWarrantyStartTime(StrUtil.sub((CharSequence)rkContractExportImplementAccountsModel.getWarrantyStartTime(), (int)0, (int)10));
            }
            if (!StrUtil.isNotEmpty((CharSequence)rkContractExportImplementAccountsModel.getWarrantyEndTime())) continue;
            rkContractExportImplementAccountsModel.setWarrantyEndTime(StrUtil.sub((CharSequence)rkContractExportImplementAccountsModel.getWarrantyEndTime(), (int)0, (int)10));
        }
        if (StringUtils.isEmpty((String)rkContractPagination.getDataType()) || !StringUtils.equals((CharSequence)rkContractPagination.getDataType(), (CharSequence)"1")) {
            PageInfo pageInfo = new PageInfo(contractComprehensiveInfo);
            return rkContractPagination.setData(pageInfo.getList(), pageInfo.getTotal());
        }
        return contractComprehensiveInfo;
    }

    @Override
    public DownloadVO exportData(RkContractPaginationExportModel rkContractPagination) {
        List contractComprehensiveInfo = this.getContractComprehensiveInfo(rkContractPagination);
        List rkContractExportModels = JsonUtil.getJsonToList((Object)contractComprehensiveInfo, RkContractExportImplementAccountsModel.class);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)rkContractExportModels, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkContractPagination.getSelectKey()) ? rkContractPagination.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return vo;
    }

    @Override
    public DownloadVO exportProductChannelData(RkContractPaginationExportModel rkContractPagination) {
        List contractComprehensiveInfo = this.getProductChannelInfo(rkContractPagination);
        List rkContractExportModels = JsonUtil.getJsonToList((Object)contractComprehensiveInfo, RkProductChannelInfoModel.class);
        for (RkProductChannelInfoModel temp : rkContractExportModels) {
            temp.setCompanyId(this.baseDataUtil.comSelectValue(temp.getCompanyId(), "1"));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)rkContractExportModels, (String)"YYYY-MM-DD"));
        String[] keys = !StringUtil.isEmpty((String)rkContractPagination.getSelectKey()) ? rkContractPagination.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatProductChannelModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return vo;
    }

    @Override
    public List<RkCompanyContractStatisticsLedger> getCompanyContractStatisticsLedger(RkContractPagination rkContractPagination, String dataType) {
        RkProcureManagePagination rkProcurePagination = new RkProcureManagePagination();
        rkProcurePagination.setPageSize(rkContractPagination.getPageSize());
        rkProcurePagination.setCurrentPage(rkContractPagination.getCurrentPage());
        rkProcurePagination.setSidx(rkContractPagination.getSidx());
        rkProcurePagination.setProcureName(rkContractPagination.getContractName());
        rkProcurePagination.setProcureCode(rkContractPagination.getContractCode());
        rkProcurePagination.setMenuId(rkContractPagination.getMenuId());
        List<String> strings = Arrays.asList("execute", "change", "cancel", "termination", "break", "canceling", "terminating", "breaking", "changing");
        rkProcurePagination.setProcureStatusList(strings);
        Integer pageSize = Math.toIntExact(rkContractPagination.getPageSize());
        int parts = 2;
        int average = pageSize / parts;
        int remainder = pageSize % parts;
        rkProcurePagination.setPageSize(average);
        rkContractPagination.setPageSize(average);
        for (int i2 = 0; i2 < remainder; ++i2) {
            if (i2 != 0) continue;
            rkContractPagination.setPageSize(average + 1);
        }
        List<RkContractEntity> list = this.rkContractService.getTypeListNoContract(rkContractPagination, dataType);
        long contractTotal = rkContractPagination.getTotal();
        List companyContractStatisticsLedgers = JsonUtil.getJsonToList(list, RkCompanyContractStatisticsLedger.class);
        List contractTaxList = this.dictionaryDataService.getList("4360623057975783731");
        for (RkCompanyContractStatisticsLedger entity : companyContractStatisticsLedgers) {
            List<RkContractEntity> listByMasterId;
            RkAgentEntity byId;
            entity.setContractContent(entity.getContractName());
            entity.setContractTaxRate(this.baseDataUtil.getDictName(entity.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            entity.setSalerId(this.baseDataUtil.userSelectValueNoAccount(entity.getSalerId()));
            entity.setContractType(this.baseDataUtil.getDictName(entity.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            entity.setDepartment(entity.getDepartmentTreeName());
            entity.setArchivedTime(entity.getArchivedTime());
            if (ObjectUtil.isEmpty((Object)entity.getCustomerId())) {
                entity.setCustomerName("");
            } else {
                CrmCustomerEntity crmCustomerEntity = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()));
                entity.setCustomerName(ObjectUtil.isEmpty((Object)crmCustomerEntity) ? "" : crmCustomerEntity.getName());
            }
            if (!ObjectUtil.isEmpty((Object)entity.getIsAgent()) && entity.getIsAgent() == 1 && ObjectUtil.isNotEmpty((Object)(byId = (RkAgentEntity)this.agentService.getById((Serializable)((Object)entity.getAgentId()))))) {
                entity.setAgentId(ObjectUtil.isEmpty((Object)entity.getAgentId()) ? "" : byId.getName());
            }
            if (!ObjectUtil.isEmpty((Object)entity.getIsAgent()) && entity.getIsAgent() == 0) {
                entity.setAgentId(entity.getCustomerName());
            }
            if (!StrUtil.isBlank((CharSequence)entity.getCompanyId())) {
                entity.setCompanyId(this.baseDataUtil.getDictName(entity.getCompanyId(), "companyName"));
            }
            entity.setEnableMark(this.baseDataUtil.getDictName(entity.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
            if (entity.getIsMoreTax() != null && entity.getIsMoreTax() == 1) {
                List<RkContractTaxEntity> rkContractTaxEntities = this.contractTaxService.listByContractId(entity.getId());
                List jsonToList1 = JsonUtil.getJsonToList(rkContractTaxEntities, RkContractTaxInfoVO.class);
                entity.setTaxList(jsonToList1);
                if (CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (RkContractTaxInfoVO rkContractTaxInfoVO : jsonToList1) {
                        if (rkContractTaxInfoVO.getTaxType() != null && rkContractTaxInfoVO.getTaxType().equals("cost")) continue;
                        stringBuffer.append("\uff0c" + rkContractTaxInfoVO.getTaxName());
                    }
                    entity.setContractTaxRate(stringBuffer.toString().replaceFirst("\uff0c", ""));
                }
            }
            if (entity.getIsSupplement() == 0 && !(listByMasterId = this.rkContractService.getListByMasterId(entity.getId())).isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u5408\u540c\u91d1\u989d\uff1a" + entity.getContractAmount() + ";<br />");
                for (RkContractEntity rkContractEntity : listByMasterId) {
                    stringBuffer.append("\u8865\u5145\u5408\u540c\u91d1\u989d\uff1a" + rkContractEntity.getContractAmount() + ";<br />");
                }
                entity.setContractAmount(stringBuffer.toString());
            }
            entity.setManagerType(AllContractTypeEnum.MANAGER_TYPE_SALECONTRACT.getDesc());
            entity.setArchivesType(StrUtil.isBlank((CharSequence)entity.getFileClassification()) ? "\u4e70\u5356\u5408\u540c" : this.baseDataUtil.getDictName(entity.getFileClassification(), "fileClassificationOptions"));
        }
        List<RkProcureManageEntity> procureList = this.rkProcureManageService.getTypeList(rkProcurePagination, dataType);
        contractTotal += rkProcurePagination.getTotal();
        for (RkProcureManageEntity procureEntity : procureList) {
            RkCompanyContractStatisticsLedger ledger = (RkCompanyContractStatisticsLedger)JsonUtil.getJsonToBean((Object)procureEntity, RkCompanyContractStatisticsLedger.class);
            ledger.setContractName(procureEntity.getProcureName());
            ledger.setContractContent(procureEntity.getProcureName());
            ledger.setContractCode(procureEntity.getProcureCode());
            ledger.setAgentId(procureEntity.getSupplierName());
            ledger.setAgentName(procureEntity.getSupplierName());
            ledger.setContractAmount(String.valueOf(procureEntity.getProcureAmount()));
            ledger.setEnableMark(this.baseDataUtil.getDictName(procureEntity.getProcureStatus(), "procureStatus"));
            ledger.setContractTaxRate(this.baseDataUtil.getDictName(procureEntity.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            if (ObjectUtil.isNotEmpty((Object)procureEntity.getIsMoreTax()) && procureEntity.getIsMoreTax() == 1) {
                List<RkContractTaxEntity> rkContractTaxEntities = this.contractTaxService.listByContractId(procureEntity.getId());
                List jsonToList1 = JsonUtil.getJsonToList(rkContractTaxEntities, RkContractTaxInfoVO.class);
                BigDecimal sum = new BigDecimal(0.0);
                if (CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (RkContractTaxInfoVO rkContractTaxInfoVO : jsonToList1) {
                        stringBuffer.append("\uff0c" + rkContractTaxInfoVO.getTaxName());
                        sum.add(new BigDecimal(rkContractTaxInfoVO.getItemExcludingTax()));
                    }
                    ledger.setContractTaxRate(stringBuffer.toString().replaceFirst("\uff0c", ""));
                    ledger.setAmountExcludingTax(sum);
                }
            } else {
                String tax = "";
                List dictionaryDataEntities = contractTaxList.stream().filter(i -> !StrUtil.isBlank((CharSequence)procureEntity.getInvoiceTax()) && i.getId().equals(procureEntity.getInvoiceTax())).collect(Collectors.toList());
                if (ObjectUtil.isNotEmpty(dictionaryDataEntities)) {
                    tax = ((DictionaryDataEntity)dictionaryDataEntities.get(0)).getFullName();
                }
                if (!(StrUtil.isBlank((CharSequence)procureEntity.getInvoiceTax()) || procureEntity.getInvoiceTaxName().equals("0") || StrUtil.isBlank((CharSequence)tax))) {
                    tax = tax.substring(0, tax.length() - 1);
                    BigDecimal calculation = new BigDecimal(tax).divide(new BigDecimal("100"), 2, 4);
                    BigDecimal divide = procureEntity.getProcureAmount().divide(new BigDecimal(1.0).add(calculation), 2, 4);
                    ledger.setAmountExcludingTax(divide);
                } else {
                    ledger.setAmountExcludingTax(procureEntity.getProcureAmount());
                }
            }
            ledger.setArchivedTime(procureEntity.getArchiveTime());
            ledger.setSalerId(procureEntity.getApplyName());
            ledger.setDepartment(procureEntity.getApplyDepartmentName());
            String managerType = this.baseDataUtil.getDictName(procureEntity.getManagerType(), "managerType");
            ledger.setManagerType(StrUtil.isBlank((CharSequence)managerType) ? "\u91c7\u8d2d\u5408\u540c" : managerType);
            ledger.setArchivesType(StrUtil.isBlank((CharSequence)procureEntity.getFileClassification()) ? AllContractTypeEnum.ARCHIVES_SALECONTRACT.getDesc() : procureEntity.getFileClassificationName());
            if (!StrUtil.isBlank((CharSequence)ledger.getCompanyId())) {
                ledger.setCompanyId(this.baseDataUtil.getDictName(ledger.getCompanyId(), "companyName"));
            }
            companyContractStatisticsLedgers.add(ledger);
        }
        rkContractPagination.setTotal(contractTotal);
        rkContractPagination.setData(companyContractStatisticsLedgers, contractTotal);
        return rkContractPagination.setData(companyContractStatisticsLedgers, contractTotal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block84: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"customerName"));
                        continue block84;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block84;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block84;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u91d1\u989d(\u5143)", (Object)"contractAmount"));
                        continue block84;
                    }
                    case "contractType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractType"));
                        continue block84;
                    }
                    case "expectedReturnTime": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u8fd4\u56de\u65e5\u671f", (Object)"expectedReturnTime"));
                        continue block84;
                    }
                    case "contractLevel": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7ea7\u522b", (Object)"contractLevel"));
                        continue block84;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6267\u884c\u9636\u6bb5", (Object)"enabledMark"));
                        continue block84;
                    }
                    case "invoiceAmountYear": {
                        entitys.add(new ExcelExportEntity("\u672c\u5e74\u5ea6\u5f00\u5177\u53d1\u7968\u603b\u91d1\u989d", (Object)"invoiceAmountYear"));
                        continue block84;
                    }
                    case "invoiceAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u53d1\u7968\u603b\u91d1\u989d(\u5143)", (Object)"invoiceAmount"));
                        continue block84;
                    }
                    case "noInvoiceAmount": {
                        entitys.add(new ExcelExportEntity("\u672a\u5f00\u53d1\u7968\u91d1\u989d(\u5143)", (Object)"noInvoiceAmount"));
                        continue block84;
                    }
                    case "noInvoiceAmountRatio": {
                        entitys.add(new ExcelExportEntity("\u672a\u5f00\u53d1\u7968\u91d1\u989d\u6bd4\u4f8b", (Object)"noInvoiceAmountRatio"));
                        continue block84;
                    }
                    case "returnAmountYear": {
                        entitys.add(new ExcelExportEntity("\u672c\u5e74\u5ea6\u5df2\u56de\u6b3e\u603b\u91d1\u989d(\u5143)", (Object)"returnAmountYear"));
                        continue block84;
                    }
                    case "returnAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u5df2\u56de\u6b3e\u603b\u91d1\u989d(\u5143)", (Object)"returnAmount"));
                        continue block84;
                    }
                    case "ownAmount": {
                        entitys.add(new ExcelExportEntity("\u6b20\u6b3e\u91d1\u989d(\u5143)", (Object)"ownAmount"));
                        continue block84;
                    }
                    case "arrearsRatio": {
                        entitys.add(new ExcelExportEntity("\u6b20\u6b3e\u6bd4\u4f8b", (Object)"arrearsRatio"));
                        continue block84;
                    }
                    case "xmjl": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"xmjl"));
                        continue block84;
                    }
                    case "receivableAmount": {
                        entitys.add(new ExcelExportEntity("\u5e94\u6536\u6b3e\u91d1\u989d(\u5143)", (Object)"receivableAmount"));
                        continue block84;
                    }
                    case "arrearsAmount": {
                        entitys.add(new ExcelExportEntity("\u903e\u671f\u6b3e\u91d1\u989d(\u5143)", (Object)"arrearsAmount"));
                        continue block84;
                    }
                    case "payMentAmountYear": {
                        entitys.add(new ExcelExportEntity("\u672c\u5e74\u5ea6\u4ed8\u6b3e\u91d1\u989d(\u5143)", (Object)"payMentAmountYear"));
                        continue block84;
                    }
                    case "payMentAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d(\u5143)", (Object)"payMentAmount"));
                        continue block84;
                    }
                    case "acceptanceEnabledMark": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u9a8c\u6536", (Object)"acceptanceEnabledMark"));
                        continue block84;
                    }
                    case "acceptanceDate": {
                        entitys.add(new ExcelExportEntity("\u9a8c\u6536\u65f6\u95f4", (Object)"acceptanceDate"));
                        continue block84;
                    }
                    case "warrantyStartime": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u8d77\u59cb\u65f6\u95f4", (Object)"warrantyStartime"));
                        continue block84;
                    }
                    case "warrantyEndtime": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u7ed3\u675f\u65f6\u95f4", (Object)"warrantyEndtime"));
                        continue block84;
                    }
                    case "paymentMethod": {
                        entitys.add(new ExcelExportEntity("\u4ed8\u6b3e\u6761\u4ef6", (Object)"paymentMethod"));
                        continue block84;
                    }
                    case "projectProcess": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u8fdb\u5c55", (Object)"projectProcess"));
                        continue block84;
                    }
                    case "expectProcureAmount": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u91c7\u8d2d\u91d1\u989d(\u5143)", (Object)"expectProcureAmount"));
                        continue block84;
                    }
                    case "profit": {
                        entitys.add(new ExcelExportEntity("\u672a\u7a0e\u6bdb\u5229\u6da6(\u5143)", (Object)"profit"));
                        continue block84;
                    }
                    case "projectManager": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"projectManager"));
                        continue block84;
                    }
                    case "belongDepartment": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u90e8\u95e8", (Object)"belongDepartment"));
                        continue block84;
                    }
                    case "procureContractCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u53f7", (Object)"procureContractCode"));
                        continue block84;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546", (Object)"supplierName"));
                        continue block84;
                    }
                    case "procureAmount": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u91d1\u989d(\u5143)", (Object)"procureAmount"));
                        continue block84;
                    }
                    case "procurePayment": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u4ed8\u6b3e(\u5143)", (Object)"procurePayment"));
                        continue block84;
                    }
                    case "procureInvoice": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u53d1\u7968(\u5143)", (Object)"procureInvoice"));
                        continue block84;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatProductChannelModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block58: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "channelType": {
                        entitys.add(new ExcelExportEntity("\u7ea7\u522b", (Object)"channelType"));
                        continue block58;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block58;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block58;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u91d1\u989d(\u5143)", (Object)"contractAmount"));
                        continue block58;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u6e20\u9053\u540d\u79f0", (Object)"agentName"));
                        continue block58;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName"));
                        continue block58;
                    }
                    case "salerName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u4eba\u5458", (Object)"salerName"));
                        continue block58;
                    }
                    case "signDate": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u65e5\u671f", (Object)"signDate"));
                        continue block58;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6267\u884c\u9636\u6bb5", (Object)"enabledMark"));
                        continue block58;
                    }
                    case "productName": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u540d\u79f0", (Object)"productName"));
                        continue block58;
                    }
                    case "productAmount": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u91d1\u989d", (Object)"productAmount"));
                        continue block58;
                    }
                    case "invoiceAmountYear": {
                        entitys.add(new ExcelExportEntity("\u672c\u5e74\u5ea6\u5f00\u5177\u53d1\u7968\u603b\u91d1\u989d", (Object)"invoiceAmountYear"));
                        continue block58;
                    }
                    case "invoiceAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u53d1\u7968\u603b\u91d1\u989d(\u5143)", (Object)"invoiceAmount"));
                        continue block58;
                    }
                    case "noInvoiceAmount": {
                        entitys.add(new ExcelExportEntity("\u672a\u5f00\u53d1\u7968\u91d1\u989d(\u5143)", (Object)"noInvoiceAmount"));
                        continue block58;
                    }
                    case "returnAmountYear": {
                        entitys.add(new ExcelExportEntity("\u672c\u5e74\u5ea6\u5df2\u56de\u6b3e\u603b\u91d1\u989d(\u5143)", (Object)"returnAmountYear"));
                        continue block58;
                    }
                    case "returnAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u5df2\u56de\u6b3e\u603b\u91d1\u989d(\u5143)", (Object)"returnAmount"));
                        continue block58;
                    }
                    case "receivableAmount": {
                        entitys.add(new ExcelExportEntity("\u5e94\u6536\u6b3e\u91d1\u989d(\u5143)", (Object)"receivableAmount"));
                        continue block58;
                    }
                    case "arrearsAmount": {
                        entitys.add(new ExcelExportEntity("\u903e\u671f\u6b3e\u91d1\u989d(\u5143)", (Object)"arrearsAmount"));
                        continue block58;
                    }
                    case "acceptanceEnabledMark": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u9a8c\u6536", (Object)"acceptanceEnabledMark"));
                        continue block58;
                    }
                    case "acceptanceDate": {
                        entitys.add(new ExcelExportEntity("\u9a8c\u6536\u65f6\u95f4", (Object)"acceptanceDate"));
                        continue block58;
                    }
                    case "warrantyStartTime": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u8d77\u59cb\u65f6\u95f4", (Object)"warrantyStartTime"));
                        continue block58;
                    }
                    case "warrantyEndTime": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u7ed3\u675f\u65f6\u95f4", (Object)"warrantyEndTime"));
                        continue block58;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyId"));
                        continue block58;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public void voidedContract(String id, String reason, String userId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(RkContractEntity::getEnableMark, (Object)ContractEnableMarkEnum.ENABLE_VOIDED.getEnableMark())).set(RkContractEntity::getVoidedUser, (Object)userId)).set(RkContractEntity::getVoidedDate, (Object)new Date())).set(RkContractEntity::getVoidedReason, (Object)reason)).set(RkContractEntity::getIsChangeNow, (Object)0)).set(RkContractEntity::getVoidedTaskEnable, null)).set(RkContractEntity::getVoidedTaskId, null)).eq(RkContractEntity::getId, (Object)id);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public DownloadVO exportCompanyContract(RkContractPaginationExportModel rkContractPaginationExportModel) {
        RkContractPagination rkContractPagination = (RkContractPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractPaginationExportModel), RkContractPagination.class));
        List<RkCompanyContractStatisticsLedger> companyContractStatisticsLedger = this.getCompanyContractStatisticsLedger(rkContractPagination, rkContractPaginationExportModel.getDataType());
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(companyContractStatisticsLedger, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)rkContractPaginationExportModel.getSelectKey()) ? rkContractPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatCompanyContractExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatCompanyContractExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block44: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyId"));
                        continue block44;
                    }
                    case "agentId": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u5bf9\u8c61", (Object)"agentId"));
                        continue block44;
                    }
                    case "managerType": {
                        entitys.add(new ExcelExportEntity("\u7ba1\u7406\u7c7b\u578b", (Object)"managerType"));
                        continue block44;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block44;
                    }
                    case "contractContent": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5185\u5bb9", (Object)"contractContent"));
                        continue block44;
                    }
                    case "contractAmountDesc": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u91d1\u989d(\u5143)", (Object)"contractAmount"));
                        continue block44;
                    }
                    case "contractTaxRate": {
                        entitys.add(new ExcelExportEntity("\u7a0e\u7387", (Object)"contractTaxRate"));
                        continue block44;
                    }
                    case "amountExcludingTax": {
                        entitys.add(new ExcelExportEntity("\u4e0d\u542b\u7a0e\u91d1\u989d(\u5143)", (Object)"amountExcludingTax"));
                        continue block44;
                    }
                    case "signDate": {
                        entitys.add(new ExcelExportEntity("\u7b7e\u8ba2\u65e5\u671f", (Object)"signDate"));
                        continue block44;
                    }
                    case "enableMark": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u72b6\u6001", (Object)"enableMark"));
                        continue block44;
                    }
                    case "contractType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractType"));
                        continue block44;
                    }
                    case "salerId": {
                        entitys.add(new ExcelExportEntity("\u7b7e\u8ba2\u4eba\u5458", (Object)"salerId"));
                        continue block44;
                    }
                    case "department": {
                        entitys.add(new ExcelExportEntity("\u7b7e\u8ba2\u90e8\u95e8", (Object)"department"));
                        continue block44;
                    }
                    case "isArchived": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u5f52\u6863", (Object)"isArchived"));
                        continue block44;
                    }
                    case "archivedTime": {
                        entitys.add(new ExcelExportEntity("\u5f52\u6863\u65e5\u671f", (Object)"archivedTime"));
                        continue block44;
                    }
                    case "contractArchiveType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u6863\u6848\u5206\u7c7b", (Object)"archivesType"));
                        continue block44;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    public static void main(String[] args) {
        int i;
        int total = 10;
        int parts = 3;
        int average = total / parts;
        int remainder = total % parts;
        for (i = 0; i < remainder; ++i) {
            System.out.println("\u90e8\u5206" + (i + 1) + ": " + (average + 1));
        }
        for (i = remainder; i < parts; ++i) {
            System.out.println("\u90e8\u5206" + (i + 1) + ": " + average);
        }
    }

    @Override
    public List<RkContractListVO> getContractsForWriteOff(RkContractPagination rkContractPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)rkContractPagination.getCompanyId())) {
            queryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)rkContractPagination.getCompanyId());
        }
        queryWrapper.lambda().ne(RkContractEntity::getEnableMark, (Object)ContractEnableMarkEnum.ENABLE_VOIDED.getEnableMark());
        queryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(RkContractEntity::getNoContractId, (Object)"")).or()).isNull(RkContractEntity::getNoContractId));
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getContractName())) {
            queryWrapper.lambda().like(RkContractEntity::getContractName, (Object)rkContractPagination.getContractName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkContractPagination.getContractCode())) {
            queryWrapper.lambda().like(RkContractEntity::getContractCode, (Object)rkContractPagination.getContractCode());
        }
        queryWrapper.lambda().orderByDesc(RkContractEntity::getId);
        Page page = new Page(rkContractPagination.getCurrentPage(), rkContractPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        List list = rkContractPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        List listVO = JsonUtil.getJsonToList((Object)list, RkContractListVO.class);
        CrmCustomerEntity customer = null;
        for (RkContractListVO vo : listVO) {
            if (StringUtils.isNotEmpty((String)vo.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(vo.getCustomerId()))) {
                vo.setCustomerName(customer.getName());
            }
            vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), "contractType"));
        }
        return listVO;
    }

    @Override
    public List<RkContractEntity> getAfterSalesDaily() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ArrayList<String> enableMarkList = new ArrayList<String>();
        enableMarkList.add("improved");
        enableMarkList.add("execute");
        enableMarkList.add("completed");
        queryWrapper.lambda().select(new SFunction[]{RkContractEntity::getCustomerId, RkContractEntity::getCompanyId});
        queryWrapper.lambda().in(RkContractEntity::getEnableMark, enableMarkList);
        queryWrapper.lambda().groupBy(RkContractEntity::getCustomerId, (Object[])new SFunction[]{RkContractEntity::getCompanyId});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> connectContactResource(CrmDepartConnectEntity connectEntity) {
        if (StrUtil.isBlank((CharSequence)connectEntity.getObjectId()) || StringUtils.isBlank((CharSequence)connectEntity.getConnectUser())) {
            return new ArrayList<RkContractEntity>();
        }
        List<String> idsList = Arrays.asList(connectEntity.getObjectId().split(","));
        if (CollectionUtil.isNotEmpty(idsList)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(RkContractEntity::getId, idsList);
            List contractList = this.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)contractList)) {
                UserEntity connectUser = this.userService.getInfo(connectEntity.getConnectUser());
                String salerName = connectUser.getRealName();
                contractList.forEach(x -> {
                    x.setSalerId(connectEntity.getConnectUser());
                    x.setSalerName(salerName);
                    x.setConnectType(connectEntity.getConnectType());
                    if (StrUtil.isBlank((CharSequence)x.getConnectRecords())) {
                        ArrayList<CrmDepartConnectEntity> connectEntityList = new ArrayList<CrmDepartConnectEntity>();
                        connectEntityList.add(connectEntity);
                        x.setConnectRecords(JSON.toJSONString(connectEntityList));
                    } else {
                        List departConnectEntities = JsonUtil.getJsonToList((String)x.getConnectRecords(), CrmDepartConnectEntity.class);
                        departConnectEntities.add(connectEntity);
                        x.setConnectRecords(JSON.toJSONString((Object)departConnectEntities));
                    }
                });
                UpdateWrapper projectUpdateWrapper = new UpdateWrapper();
                projectUpdateWrapper.lambda().in(RkContractProjectEntity::getContractId, idsList);
                projectUpdateWrapper.lambda().set(RkContractProjectEntity::getSalerId, (Object)connectEntity.getConnectUser());
                projectUpdateWrapper.lambda().set(RkContractProjectEntity::getSalerName, (Object)salerName);
                this.rkContractProjectService.update((Wrapper)projectUpdateWrapper);
            }
            this.updateBatchById(contractList);
            return contractList;
        }
        return new ArrayList<RkContractEntity>();
    }

    @Override
    public boolean checkContractIsExist(RkContractEntity contract) {
        QueryWrapper verifyQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)contract.getSalerId())) {
            verifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getSalerId, (Object)contract.getSalerId());
        }
        if (StringUtils.isNotEmpty((String)contract.getCustomerId())) {
            verifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getCustomerId, (Object)contract.getCustomerId());
        }
        if (null != contract.getContractAmount()) {
            verifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getContractAmount, (Object)contract.getContractAmount());
        }
        if (StringUtils.isNotEmpty((String)contract.getIncomeType())) {
            verifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getIncomeType, (Object)contract.getIncomeType());
        }
        if (StringUtils.isNotEmpty((String)contract.getCompanyId())) {
            verifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getCompanyId, (Object)contract.getCompanyId());
        }
        if (null != contract.getStartContractTime() && null != contract.getEndContractTime()) {
            verifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getStartContractTime, (Object)contract.getStartContractTime());
            verifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getEndContractTime, (Object)contract.getEndContractTime());
        }
        verifyQueryWrapper.lambda().notIn(RkContractVerifyEntity::getEnableMark, new Object[]{"3", ""});
        verifyQueryWrapper.lambda().ne(RkContractVerifyEntity::getId, (Object)contract.getId());
        if (this.rkContractVerifyService.count((Wrapper)verifyQueryWrapper) > 0L) {
            return true;
        }
        QueryWrapper contractQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)contract.getSalerId())) {
            contractQueryWrapper.lambda().eq(RkContractEntity::getSalerId, (Object)contract.getSalerId());
        }
        if (StringUtils.isNotEmpty((String)contract.getCustomerId())) {
            contractQueryWrapper.lambda().eq(RkContractEntity::getCustomerId, (Object)contract.getCustomerId());
        }
        if (null != contract.getContractAmount()) {
            contractQueryWrapper.lambda().eq(RkContractEntity::getContractAmount, (Object)contract.getContractAmount());
        }
        if (StringUtils.isNotEmpty((String)contract.getIncomeType())) {
            contractQueryWrapper.lambda().eq(RkContractEntity::getIncomeType, (Object)contract.getIncomeType());
        }
        if (StringUtils.isNotEmpty((String)contract.getCompanyId())) {
            contractQueryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)contract.getCompanyId());
        }
        if (null != contract.getStartContractTime() && null != contract.getEndContractTime()) {
            contractQueryWrapper.lambda().eq(RkContractEntity::getStartContractTime, (Object)contract.getStartContractTime());
            contractQueryWrapper.lambda().eq(RkContractEntity::getEndContractTime, (Object)contract.getEndContractTime());
        }
        contractQueryWrapper.lambda().ne(RkContractEntity::getEnableMark, (Object)ContractEnableMarkEnum.ENABLE_VOIDED.getEnableMark());
        contractQueryWrapper.lambda().ne(RkContractEntity::getId, (Object)contract.getId());
        return this.rkContractService.count((Wrapper)contractQueryWrapper) > 0L;
    }

    @Override
    @DSTransactional
    public void contractArachived(RkArachivedUpForm rkArachivedUpForm) {
        RkContractEntity jsonToBean = (RkContractEntity)JsonUtil.getJsonToBean((Object)rkArachivedUpForm, RkContractEntity.class);
        jsonToBean.setIsArchived(1);
        this.attachmentService.deleteByContractId(rkArachivedUpForm.getContractId(), AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType());
        List<RkAttachmentUpForm> doubleSignedAttachmentList = rkArachivedUpForm.getDoubleSignedAttachmentList();
        if (CollectionUtil.isNotEmpty(doubleSignedAttachmentList)) {
            doubleSignedAttachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setContractId(rkArachivedUpForm.getContractId());
                attach.setFileType(AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(doubleSignedAttachmentList, RkAttachmentEntity.class);
            this.attachmentService.saveBatch(attachmentEntityList);
            jsonToBean.setDoubleSignedAttachment(1);
        } else {
            jsonToBean.setDoubleSignedAttachment(0);
        }
        this.rkContractService.update(rkArachivedUpForm.getContractId(), jsonToBean);
    }

    @Override
    public long countBySettlementStage(RkContractPagination rkContractPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractEntity::getSettlementStatus, (Object)rkContractPagination.getSettlementStatus());
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListBySettlementStage(String returnSettlementStatus) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractEntity::getReturnSettlementStatus, (Object)returnSettlementStatus);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractEntity> getListByNoPage(RkContractPagination rkContractPagination) {
        QueryWrapper<RkContractEntity> rkContractQueryWrapper = new QueryWrapper<RkContractEntity>();
        if (ObjectUtil.isNull(rkContractQueryWrapper = this.appendWrapper(rkContractPagination, rkContractQueryWrapper))) {
            return CollectionUtil.list((boolean)false);
        }
        if (ObjectUtil.isEmpty(rkContractQueryWrapper)) {
            ArrayList list = new ArrayList();
            return rkContractPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractQueryWrapper);
    }
}

