/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractSettlementEntity;
import com.bringspring.contract.entity.RkContractSettlementRecordEntity;
import com.bringspring.contract.mapper.RkContractSettlementMapper;
import com.bringspring.contract.model.rkcontractsettlement.RkContractSettlementCrForm;
import com.bringspring.contract.model.rkcontractsettlement.RkContractSettlementHandleVO;
import com.bringspring.contract.model.rkcontractsettlement.RkContractSettlementPagination;
import com.bringspring.contract.model.rkcontractsettlement.RkContractSettlementUpForm;
import com.bringspring.contract.service.RkContractSettlementRecordService;
import com.bringspring.contract.service.RkContractSettlementService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractSettlementServiceImpl
extends ServiceImpl<RkContractSettlementMapper, RkContractSettlementEntity>
implements RkContractSettlementService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractSettlementRecordService rkContractSettlementRecordService;
    @Autowired
    private ServiceAllUtil serviceAllUtil;

    @Override
    public List<RkContractSettlementEntity> getList(RkContractSettlementPagination rkContractSettlementPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractSettlementNum = 0;
        QueryWrapper rkContractSettlementQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)rkContractSettlementPagination.getContractCompanyId())) {
            ++rkContractSettlementNum;
            rkContractSettlementQueryWrapper.lambda().like(RkContractSettlementEntity::getContractCompanyId, (Object)rkContractSettlementPagination.getContractCompanyId());
        }
        if (AllIdList.size() > 0) {
            rkContractSettlementQueryWrapper.lambda().in(RkContractSettlementEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)rkContractSettlementPagination.getSidx())) {
            rkContractSettlementQueryWrapper.lambda().orderByDesc(RkContractSettlementEntity::getId);
        } else {
            try {
                String sidx = rkContractSettlementPagination.getSidx();
                RkContractSettlementEntity rkContractSettlementEntity = new RkContractSettlementEntity();
                Field declaredField = rkContractSettlementEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractSettlementQueryWrapper = "asc".equals(rkContractSettlementPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractSettlementQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractSettlementQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkContractSettlementPagination.getCurrentPage(), rkContractSettlementPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkContractSettlementQueryWrapper);
            return rkContractSettlementPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkContractSettlementPagination.setData(list, list.size());
    }

    @Override
    public List<RkContractSettlementEntity> getTypeList(RkContractSettlementPagination rkContractSettlementPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractSettlementNum = 0;
        QueryWrapper rkContractSettlementQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)rkContractSettlementPagination.getContractCompanyId())) {
            ++rkContractSettlementNum;
            rkContractSettlementQueryWrapper.lambda().like(RkContractSettlementEntity::getContractCompanyId, (Object)rkContractSettlementPagination.getContractCompanyId());
        }
        if (AllIdList.size() > 0) {
            rkContractSettlementQueryWrapper.lambda().in(RkContractSettlementEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)rkContractSettlementPagination.getSidx())) {
            rkContractSettlementQueryWrapper.lambda().orderByDesc(RkContractSettlementEntity::getId);
        } else {
            try {
                String sidx = rkContractSettlementPagination.getSidx();
                RkContractSettlementEntity rkContractSettlementEntity = new RkContractSettlementEntity();
                Field declaredField = rkContractSettlementEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractSettlementQueryWrapper = "asc".equals(rkContractSettlementPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractSettlementQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractSettlementQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractSettlementPagination.getCurrentPage(), rkContractSettlementPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractSettlementQueryWrapper);
                return rkContractSettlementPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractSettlementPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractSettlementQueryWrapper);
    }

    @Override
    public RkContractSettlementEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractSettlementEntity::getId, (Object)id);
        return (RkContractSettlementEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(RkContractSettlementCrForm rkContractSettlementCrForm) {
        this.saveSettlement(rkContractSettlementCrForm);
    }

    public void saveSettlement(RkContractSettlementCrForm rkContractSettlementCrForm) {
        UserInfo userInfo = this.userProvider.get();
        if (CollectionUtil.isEmpty(rkContractSettlementCrForm.getHandleList())) {
            RkContractSettlementEntity infoByContractId = this.getInfoByContractId(rkContractSettlementCrForm.getContractId());
            if (ObjectUtil.isNotEmpty((Object)infoByContractId)) {
                RkContractSettlementRecordEntity recordEntity = new RkContractSettlementRecordEntity();
                if (ObjectUtil.isNotEmpty((Object)rkContractSettlementCrForm.getBaseFeeRate())) {
                    infoByContractId.setBaseFeeRate(rkContractSettlementCrForm.getBaseFeeRate());
                    recordEntity.setBeforeBaseFeeRate(rkContractSettlementCrForm.getOldFeeRate());
                    recordEntity.setAfterBaseFeeRate(infoByContractId.getBaseFeeRate());
                    recordEntity.setAdjustTime(new Date());
                    recordEntity.setAdjustUserId(userInfo.getUserId());
                    recordEntity.setAdjustUserName(userInfo.getUserName());
                }
                if (ObjectUtil.isNotEmpty((Object)rkContractSettlementCrForm.getCommissionRate())) {
                    infoByContractId.setCommissionRate(rkContractSettlementCrForm.getCommissionRate());
                    recordEntity.setBeforeCommissionRate(rkContractSettlementCrForm.getOldCommissionRate());
                    recordEntity.setAfterCommissionRate(infoByContractId.getCommissionRate());
                    recordEntity.setPlanAdjustTime(new Date());
                    recordEntity.setPlanAdjustUserId(userInfo.getUserId());
                    recordEntity.setPlanAdjustUserName(userInfo.getUserName());
                }
                this.updateById(infoByContractId);
                recordEntity.setId(RandomUtil.uuId());
                recordEntity.setContractId(infoByContractId.getContractId());
                recordEntity.setSettlementId(infoByContractId.getId());
                this.rkContractSettlementRecordService.save(recordEntity);
            } else {
                String mainId = RandomUtil.uuId();
                RkContractSettlementEntity entity = (RkContractSettlementEntity)JsonUtil.getJsonToBean((Object)rkContractSettlementCrForm, RkContractSettlementEntity.class);
                entity.setId(mainId);
                entity.setCreatorUserId(userInfo.getUserId());
                entity.setCreatorTime(new Date());
                this.save(entity);
                RkContractSettlementRecordEntity recordEntity = new RkContractSettlementRecordEntity();
                recordEntity.setContractId(entity.getContractId());
                recordEntity.setId(RandomUtil.uuId());
                recordEntity.setSettlementId(entity.getId());
                recordEntity.setBeforeBaseFeeRate(rkContractSettlementCrForm.getOldFeeRate());
                recordEntity.setAfterBaseFeeRate(entity.getBaseFeeRate());
                recordEntity.setAdjustFeeRateDescription(rkContractSettlementCrForm.getAdjustFeeRateDescription());
                if (ObjectUtil.isNotEmpty((Object)recordEntity.getAfterBaseFeeRate())) {
                    recordEntity.setAdjustTime(new Date());
                    recordEntity.setAdjustUserId(userInfo.getUserId());
                    recordEntity.setAdjustUserName(userInfo.getUserName());
                }
                recordEntity.setBeforeCommissionRate(rkContractSettlementCrForm.getOldCommissionRate());
                recordEntity.setAfterCommissionRate(entity.getCommissionRate());
                if (ObjectUtil.isNotEmpty((Object)recordEntity.getAfterCommissionRate())) {
                    recordEntity.setPlanAdjustTime(new Date());
                    recordEntity.setPlanAdjustUserId(userInfo.getUserId());
                    recordEntity.setPlanAdjustUserName(userInfo.getUserName());
                }
                recordEntity.setPlanAdjustDescription(rkContractSettlementCrForm.getPlanAdjustDescription());
                this.rkContractSettlementRecordService.save(recordEntity);
            }
        } else {
            List<RkContractSettlementHandleVO> handleList = rkContractSettlementCrForm.getHandleList();
            handleList.stream().forEach(handle -> {
                RkContractSettlementEntity entity = null;
                RkContractSettlementEntity settlementEntity = this.getInfoByContractId(handle.getContractId());
                if (ObjectUtil.isNotEmpty((Object)settlementEntity)) {
                    settlementEntity.setBaseFeeRate(handle.getBaseFeeRate());
                    settlementEntity.setCommissionRate(handle.getCommissionRate());
                    this.updateById(settlementEntity);
                    entity = settlementEntity;
                } else {
                    String mainId = RandomUtil.uuId();
                    entity = new RkContractSettlementEntity();
                    entity.setId(mainId);
                    entity.setContractId(handle.getContractId());
                    entity.setBaseFeeRate(handle.getBaseFeeRate());
                    entity.setCreatorUserId(userInfo.getUserId());
                    entity.setCreatorTime(new Date());
                    this.save(entity);
                }
                RkContractSettlementRecordEntity recordEntity = new RkContractSettlementRecordEntity();
                recordEntity.setContractId(entity.getContractId());
                recordEntity.setId(RandomUtil.uuId());
                recordEntity.setSettlementId(entity.getId());
                recordEntity.setBeforeBaseFeeRate(handle.getOldFeeRate());
                recordEntity.setAfterBaseFeeRate(entity.getBaseFeeRate());
                recordEntity.setAdjustFeeRateDescription(handle.getAdjustFeeRateDescription());
                if (ObjectUtil.isNotEmpty((Object)recordEntity.getAfterBaseFeeRate())) {
                    recordEntity.setAdjustTime(new Date());
                    recordEntity.setAdjustUserId(userInfo.getUserId());
                    recordEntity.setAdjustUserName(userInfo.getUserName());
                }
                recordEntity.setBeforeCommissionRate(handle.getOldCommissionRate());
                recordEntity.setAfterCommissionRate(entity.getCommissionRate());
                if (ObjectUtil.isNotEmpty((Object)recordEntity.getAfterCommissionRate())) {
                    recordEntity.setPlanAdjustTime(new Date());
                    recordEntity.setPlanAdjustUserId(userInfo.getUserId());
                    recordEntity.setPlanAdjustUserName(userInfo.getUserName());
                }
                recordEntity.setPlanAdjustDescription(handle.getPlanAdjustDescription());
                this.rkContractSettlementRecordService.save(recordEntity);
            });
        }
    }

    @Override
    @DSTransactional
    public void update(String id, RkContractSettlementUpForm rkContractSettlementUpForm) {
        UserInfo userInfo = this.userProvider.get();
        RkContractSettlementEntity entity = this.getInfo(id);
        if (entity != null) {
            RkContractSettlementEntity subentity = (RkContractSettlementEntity)JsonUtil.getJsonToBean((Object)rkContractSettlementUpForm, RkContractSettlementEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public RkContractSettlementEntity getInfoByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractSettlementEntity::getContractId, (Object)contractId);
        return (RkContractSettlementEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractSettlementEntity> getListByContractId(String contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractSettlementEntity::getContractId, (Object)contractId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void delete(RkContractSettlementEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

