/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProductEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkContractVerifyEntity;
import com.bringspring.contract.entity.RkProjectStartEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.mapper.RkAgentMapper;
import com.bringspring.contract.mapper.RkContractVerifyMapper;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyPagination;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyUpForm;
import com.bringspring.contract.model.rkContractVerifyFileResponse.RkContractFileResponsePaymentModel;
import com.bringspring.contract.model.rkContractVerifyFileResponse.RkContractFileResponseSubjectModel;
import com.bringspring.contract.model.rkContractVerifyFileResponse.RkContractVerifyFileResponseUpForm;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkattachment.RkAttachmentUpForm;
import com.bringspring.contract.model.rkcontract.RkContractPaymentVO;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordPagination;
import com.bringspring.contract.model.rkcontractprocure.OaRecordSubitemCrCrmForm;
import com.bringspring.contract.model.rkcontractproduct.RkContractProductUpForm;
import com.bringspring.contract.service.OaContractCustomerService;
import com.bringspring.contract.service.OaFileCrmServic;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractChangeService;
import com.bringspring.contract.service.RkContractDelService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractTaxService;
import com.bringspring.contract.service.RkContractVerifyFileResponseService;
import com.bringspring.contract.service.RkContractVerifyService;
import com.bringspring.contract.service.RkProjectStartService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.ContractHttpClientUtil;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.SaleNoContractStatusEnum;
import com.bringspring.contract.utils.SpecialTypeEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.mapper.CrmCustomerMapper;
import com.bringspring.crm.model.crmcustomermy.CrmCustomerMyCrForm;
import com.bringspring.crm.service.CrmCustomerMyService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.purchase.entity.OaContractPurchasePlanEntity;
import com.bringspring.purchase.entity.OaPurchasePlanEntity;
import com.bringspring.purchase.service.OaContractPurchasePlanService;
import com.bringspring.purchase.service.OaPurchasePlanService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.AfterSalesMaintenanceService;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.utils.ProjectReportStageTrendsEnum;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkContractVerifyServiceImpl
extends ServiceImpl<RkContractVerifyMapper, RkContractVerifyEntity>
implements RkContractVerifyService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkContractProductService contractProductService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkContractChangeService contractChangeService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkContractPaymentService contractPaymentService;
    @Autowired
    private RkContractReturnPlanService contractReturnPlanService;
    @Autowired
    private RkContractDelService contractDelService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private ProvinceService provinceService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkContractTaxService contractTaxService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkContractVerifyService rkContractVerifyService;
    @Autowired
    private OaFileCrmServic oaFileCrmServic;
    @Autowired
    private RkAgentMapper rkAgentMapper;
    @Autowired
    private CrmCustomerMapper crmCustomerMapper;
    @Autowired
    private CrmCustomerMyService crmCustomerMyService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkProjectStartService rkProjectStartService;
    @Autowired
    private RkContractVerifyMapper rkContractVerifyMapper;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private OaContractCustomerService oaContractCustomerService;
    @Autowired
    private AfterSalesMaintenanceService afterSalesMaintenanceService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private OaContractPurchasePlanService oaContractPurchasePlanService;
    @Autowired
    private OaPurchasePlanService oaPurchasePlanService;
    @Autowired
    private ContractHttpClientUtil contractHttpClientUtil;
    @Autowired
    private RkContractVerifyFileResponseService rkContractVerifyFileResponseService;

    @Override
    public List<RkContractVerifyEntity> getList(RkContractVerifyPagination rkContractVerifyPagination) {
        Object rkContractVerifyObj;
        QueryWrapper rkContractVerifyQueryWrapper = this.appendWrapper(rkContractVerifyPagination);
        if (ObjectUtil.isEmpty(rkContractVerifyQueryWrapper)) {
            ArrayList list = new ArrayList();
            return rkContractVerifyPagination.setData(list, list.size());
        }
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractVerifyNum = 0;
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractVerifyObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractVerifyQueryWrapper, rkContractVerifyPagination.getMenuId(), "rk_contract_verify"));
            if (ObjectUtil.isEmpty((Object)rkContractVerifyObj)) {
                return new ArrayList<RkContractVerifyEntity>();
            }
            rkContractVerifyQueryWrapper = (QueryWrapper)rkContractVerifyObj;
            ++rkContractVerifyNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractVerifyObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractVerifyQueryWrapper, rkContractVerifyPagination.getMenuId(), "rk_contract_verify"));
            if (ObjectUtil.isEmpty((Object)rkContractVerifyObj)) {
                return new ArrayList<RkContractVerifyEntity>();
            }
            rkContractVerifyQueryWrapper = (QueryWrapper)rkContractVerifyObj;
            ++rkContractVerifyNum;
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getContractName())) {
            ++rkContractVerifyNum;
            rkContractVerifyQueryWrapper.lambda().like(RkContractVerifyEntity::getContractName, (Object)rkContractVerifyPagination.getContractName());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getContractType())) {
            ++rkContractVerifyNum;
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getContractType, (Object)rkContractVerifyPagination.getContractType());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getCompanyId())) {
            ++rkContractVerifyNum;
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getCompanyId, (Object)rkContractVerifyPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(rkContractVerifyPagination.getSalerCompanyIdList())) {
            ++rkContractVerifyNum;
            rkContractVerifyQueryWrapper.lambda().in(RkContractVerifyEntity::getSalerCompanyId, rkContractVerifyPagination.getSalerCompanyIdList());
        }
        if (CollectionUtil.isNotEmpty(rkContractVerifyPagination.getCompanyIdList())) {
            ++rkContractVerifyNum;
            rkContractVerifyQueryWrapper.lambda().in(RkContractVerifyEntity::getCompanyId, rkContractVerifyPagination.getCompanyIdList());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getSpecialType())) {
            ++rkContractVerifyNum;
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getSpecialType, (Object)rkContractVerifyPagination.getSpecialType());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getUserId())) {
            ++rkContractVerifyNum;
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getCreatorUserId, (Object)rkContractVerifyPagination.getUserId());
        }
        if (AllIdList.size() > 0) {
            rkContractVerifyQueryWrapper.lambda().in(RkContractVerifyEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getSidx())) {
            rkContractVerifyQueryWrapper.lambda().orderByDesc(RkContractVerifyEntity::getId);
        } else {
            try {
                String sidx = rkContractVerifyPagination.getSidx();
                RkContractVerifyEntity rkContractVerifyEntity = new RkContractVerifyEntity();
                Field declaredField = rkContractVerifyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractVerifyQueryWrapper = "asc".equals(rkContractVerifyPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractVerifyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractVerifyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkContractVerifyPagination.getCurrentPage(), rkContractVerifyPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkContractVerifyQueryWrapper);
            return rkContractVerifyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkContractVerifyPagination.setData(list, list.size());
    }

    private QueryWrapper<RkContractVerifyEntity> appendWrapper(RkContractVerifyPagination rkContractVerifyPagination) {
        List<RkContractProductEntity> listByProductId;
        List salerIdList;
        QueryWrapper rkContractVerifyQueryWrapper = new QueryWrapper();
        if (CollectionUtil.isNotEmpty(rkContractVerifyPagination.getSalerCompanyIdList())) {
            rkContractVerifyQueryWrapper.lambda().in(RkContractVerifyEntity::getSalerCompanyId, rkContractVerifyPagination.getSalerCompanyIdList());
        }
        if (CollectionUtil.isNotEmpty(rkContractVerifyPagination.getCompanyIdList())) {
            rkContractVerifyQueryWrapper.lambda().in(RkContractVerifyEntity::getCompanyId, rkContractVerifyPagination.getCompanyIdList());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getContractType())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getContractType, (Object)rkContractVerifyPagination.getContractType());
        }
        if (!ObjectUtil.isEmpty(rkContractVerifyPagination.getEnableMark())) {
            rkContractVerifyQueryWrapper.lambda().in(RkContractVerifyEntity::getEnableMark, rkContractVerifyPagination.getEnableMark());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getContractName())) {
            rkContractVerifyQueryWrapper.lambda().like(RkContractVerifyEntity::getContractName, (Object)rkContractVerifyPagination.getContractName());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getContractCode())) {
            rkContractVerifyQueryWrapper.lambda().like(RkContractVerifyEntity::getContractCode, (Object)rkContractVerifyPagination.getContractCode());
        }
        if (!ObjectUtil.isEmpty(rkContractVerifyPagination.getSignDate())) {
            rkContractVerifyQueryWrapper.lambda().between(RkContractVerifyEntity::getSignDate, (Object)rkContractVerifyPagination.getSignDate().get(0), (Object)rkContractVerifyPagination.getSignDate().get(1));
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getSignMonth())) {
            rkContractVerifyQueryWrapper.lambda().apply("DATE_FORMAT(sign_date,'%Y-%m') = '" + rkContractVerifyPagination.getSignMonth() + "'", new Object[0]);
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getIsArchived())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getIsArchived, (Object)rkContractVerifyPagination.getIsArchived());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getSpecialType())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getSpecialType, (Object)rkContractVerifyPagination.getSpecialType());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getIndustryType())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getIndustryType, (Object)rkContractVerifyPagination.getIndustryType());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getIsNeedPayAdvance())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getIsNeedPayAdvance, (Object)rkContractVerifyPagination.getIsNeedPayAdvance());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getIsStamp())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getIsStamp, (Object)rkContractVerifyPagination.getIsStamp());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getIsStampType())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getIsStampType, (Object)rkContractVerifyPagination.getIsStampType());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getIsHaveAttachment())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getIsHaveAttachment, (Object)rkContractVerifyPagination.getIsHaveAttachment());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getIsCrossRegion())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getIsCrossRegion, (Object)rkContractVerifyPagination.getIsCrossRegion());
        }
        HashMap roleSearchMap = rkContractVerifyPagination.getRoleSearchMap();
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getSalerId())) {
            List salerIdList2;
            String searchUserId = rkContractVerifyPagination.getSalerId();
            if (!(ObjectUtil.isEmpty((Object)roleSearchMap) || roleSearchMap.size() <= 0 || ((Boolean)roleSearchMap.get("isAll")).booleanValue() || (salerIdList2 = (List)roleSearchMap.get("idList")).contains(searchUserId))) {
                searchUserId = "";
            }
            if (!ObjectUtil.isEmpty((Object)searchUserId)) {
                rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getSalerId, (Object)rkContractVerifyPagination.getSalerId());
            }
        } else if (!(ObjectUtil.isEmpty((Object)roleSearchMap) || roleSearchMap.size() <= 0 || ((Boolean)roleSearchMap.get("isAll")).booleanValue() || ObjectUtil.isEmpty((Object)(salerIdList = (List)roleSearchMap.get("idList"))))) {
            rkContractVerifyQueryWrapper.lambda().in(RkContractVerifyEntity::getSalerId, (Collection)salerIdList);
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getIsSupplement())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getIsSupplement, (Object)rkContractVerifyPagination.getIsSupplement());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getIsNeedPayAdvance())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getIsNeedPayAdvance, (Object)rkContractVerifyPagination.getIsNeedPayAdvance());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getIsStamp())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getIsStamp, (Object)rkContractVerifyPagination.getIsStamp());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getCompanyId())) {
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getCompanyId, (Object)rkContractVerifyPagination.getCompanyId());
        }
        if (!ObjectUtil.isEmpty(rkContractVerifyPagination.getSearchCustomerRegion())) {
            rkContractVerifyQueryWrapper.lambda().in(RkContractVerifyEntity::getCustomerRegion, rkContractVerifyPagination.getSearchCustomerRegion());
        }
        boolean flag = false;
        List contractIdList = CollectionUtil.list((boolean)false);
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getProductId()) && CollectionUtil.isEmpty(contractIdList = (listByProductId = this.contractProductService.getListByProductId(rkContractVerifyPagination.getProductId())).stream().map(RkContractProductEntity::getContractId).collect(Collectors.toList()))) {
            flag = true;
        }
        List customerIdList = CollectionUtil.list((boolean)false);
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getGrade()) || !ObjectUtil.isEmpty(rkContractVerifyPagination.getCustomerCreateDate())) {
            List<CrmCustomerEntity> listByGrade = this.crmCustomerService.getListByGradeAndCreateDate(rkContractVerifyPagination.getGrade(), rkContractVerifyPagination.getCustomerCreateDate());
            customerIdList = listByGrade.stream().map(CrmCustomerEntity::getId).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(customerIdList)) {
                flag = true;
            }
            if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getCustomerId()) && !customerIdList.contains(rkContractVerifyPagination.getCustomerId())) {
                flag = true;
            }
        }
        List agentIdList = CollectionUtil.list((boolean)false);
        if (!ObjectUtil.isEmpty(rkContractVerifyPagination.getAgentCreateDate())) {
            List<RkAgentEntity> listByCreateDate = this.agentService.getListByCreateDate(rkContractVerifyPagination.getAgentCreateDate());
            agentIdList = listByCreateDate.stream().map(RkAgentEntity::getId).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(agentIdList)) {
                flag = true;
            }
            if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getAgentId()) && !agentIdList.contains(rkContractVerifyPagination.getAgentId())) {
                flag = true;
            }
        }
        if (flag) {
            return null;
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getAgentId())) {
            rkContractVerifyQueryWrapper.lambda().like(RkContractVerifyEntity::getAgentIds, (Object)rkContractVerifyPagination.getAgentId());
        } else if (!ObjectUtil.isEmpty((Object)agentIdList)) {
            rkContractVerifyQueryWrapper.lambda().in(RkContractVerifyEntity::getAgentId, agentIdList);
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getCustomerId())) {
            rkContractVerifyQueryWrapper.lambda().like(RkContractVerifyEntity::getCustomerIds, (Object)rkContractVerifyPagination.getCustomerId());
        } else if (!ObjectUtil.isEmpty(customerIdList)) {
            rkContractVerifyQueryWrapper.lambda().in(RkContractVerifyEntity::getCustomerId, customerIdList);
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getIsOverdue())) {
            List<RkContractReturnPlanEntity> listOverdueType = this.contractReturnPlanService.getListOverdueType();
            if (rkContractVerifyPagination.getIsOverdue() == 1) {
                if (CollectionUtil.isEmpty(listOverdueType)) {
                    return null;
                }
                List collect = listOverdueType.stream().map(RkContractReturnPlanEntity::getContractId).collect(Collectors.toList());
                if (!ObjectUtil.isEmpty(contractIdList)) {
                    List intersection = contractIdList.stream().filter(item -> collect.contains(item)).collect(Collectors.toList());
                    contractIdList = intersection;
                } else {
                    contractIdList = collect;
                }
            } else if (!ObjectUtil.isEmpty(listOverdueType)) {
                List collect = listOverdueType.stream().map(RkContractReturnPlanEntity::getContractId).collect(Collectors.toList());
                if (!ObjectUtil.isEmpty(contractIdList)) {
                    contractIdList = contractIdList.stream().filter(x -> !collect.contains(x)).collect(Collectors.toList());
                } else {
                    rkContractVerifyQueryWrapper.lambda().notIn(RkContractVerifyEntity::getId, collect);
                }
            }
        }
        if (!ObjectUtil.isEmpty(contractIdList)) {
            rkContractVerifyQueryWrapper.lambda().in(RkContractVerifyEntity::getId, contractIdList);
        }
        return rkContractVerifyQueryWrapper;
    }

    @Override
    public List<RkContractVerifyEntity> getListBy(RkContractCollectionRecordPagination rkContractCollectionRecordPagination) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getCompanyId())) {
            queryWrapper.eq(RkContractVerifyEntity::getCompanyId, (Object)rkContractCollectionRecordPagination.getCompanyId());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getCustomerId())) {
            queryWrapper.eq(RkContractVerifyEntity::getCustomerId, (Object)rkContractCollectionRecordPagination.getCustomerId());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getIncomeType())) {
            queryWrapper.like(RkContractVerifyEntity::getIncomeType, (Object)rkContractCollectionRecordPagination.getIncomeType());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getContractType())) {
            queryWrapper.eq(RkContractVerifyEntity::getContractType, (Object)rkContractCollectionRecordPagination.getContractType());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getAgentId())) {
            queryWrapper.like(RkContractVerifyEntity::getAgentIds, (Object)rkContractCollectionRecordPagination.getAgentId());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractCollectionRecordPagination.getContractCode())) {
            queryWrapper.like(RkContractVerifyEntity::getContractCode, (Object)rkContractCollectionRecordPagination.getContractCode());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractVerifyEntity> getTypeList(RkContractVerifyPagination rkContractVerifyPagination, String dataType) {
        Object rkContractVerifyObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkContractVerifyNum = 0;
        QueryWrapper rkContractVerifyQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractVerifyObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractVerifyQueryWrapper, rkContractVerifyPagination.getMenuId(), "rk_contract_verify"));
            if (ObjectUtil.isEmpty((Object)rkContractVerifyObj)) {
                return new ArrayList<RkContractVerifyEntity>();
            }
            rkContractVerifyQueryWrapper = (QueryWrapper)rkContractVerifyObj;
            ++rkContractVerifyNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkContractVerifyObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkContractVerifyQueryWrapper, rkContractVerifyPagination.getMenuId(), "rk_contract_verify"));
            if (ObjectUtil.isEmpty((Object)rkContractVerifyObj)) {
                return new ArrayList<RkContractVerifyEntity>();
            }
            rkContractVerifyQueryWrapper = (QueryWrapper)rkContractVerifyObj;
            ++rkContractVerifyNum;
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getContractName())) {
            ++rkContractVerifyNum;
            rkContractVerifyQueryWrapper.lambda().like(RkContractVerifyEntity::getContractName, (Object)rkContractVerifyPagination.getContractName());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getContractType())) {
            ++rkContractVerifyNum;
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getContractType, (Object)rkContractVerifyPagination.getContractType());
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getSpecialType())) {
            ++rkContractVerifyNum;
            rkContractVerifyQueryWrapper.lambda().eq(RkContractVerifyEntity::getSpecialType, (Object)rkContractVerifyPagination.getSpecialType());
        }
        if (AllIdList.size() > 0) {
            rkContractVerifyQueryWrapper.lambda().in(RkContractVerifyEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkContractVerifyPagination.getSidx())) {
            rkContractVerifyQueryWrapper.lambda().orderByDesc(RkContractVerifyEntity::getId);
        } else {
            try {
                String sidx = rkContractVerifyPagination.getSidx();
                RkContractVerifyEntity rkContractVerifyEntity = new RkContractVerifyEntity();
                Field declaredField = rkContractVerifyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkContractVerifyQueryWrapper = "asc".equals(rkContractVerifyPagination.getSort().toLowerCase()) ? (QueryWrapper)rkContractVerifyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkContractVerifyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkContractVerifyPagination.getCurrentPage(), rkContractVerifyPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkContractVerifyQueryWrapper);
                return rkContractVerifyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkContractVerifyPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkContractVerifyQueryWrapper);
    }

    @Override
    public RkContractVerifyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractVerifyEntity::getId, (Object)id);
        return (RkContractVerifyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkContractVerifyEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkContractVerifyEntity entity) {
        String[] split;
        entity.setId(id);
        RkContractVerifyUpForm rkContractVerifyUpForm = (RkContractVerifyUpForm)((Object)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyUpForm.class));
        if (!ObjectUtil.isEmpty(rkContractVerifyUpForm.getPaymentList())) {
            List<RkContractPaymentVO> paymentList = rkContractVerifyUpForm.getPaymentList();
            paymentList.stream().forEach(payment -> {
                if (!ObjectUtil.isEmpty((Object)payment.getPaymentName()) && ObjectUtil.isEmpty((Object)payment.getPaymentType())) {
                    payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                }
            });
            String objectToString = JsonUtil.getObjectToString(paymentList);
            entity.setPaymentJson(objectToString);
            List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
            List oldIdList = listByContractId.stream().map(RkContractPaymentEntity::getId).collect(Collectors.toList());
            List newIdList = paymentList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getId())).map(RkContractPaymentVO::getId).collect(Collectors.toList());
            List needRemoveIdList = oldIdList.stream().filter(x -> !newIdList.contains(x)).collect(Collectors.toList());
            this.contractPaymentService.removeBatchByIds(needRemoveIdList);
            List jsonToList = JsonUtil.getJsonToList(paymentList, RkContractPaymentEntity.class);
            jsonToList.stream().forEach(x -> {
                x.setContractId(id);
                if (ObjectUtil.isEmpty((Object)x.getId())) {
                    x.setId(RandomUtil.uuId());
                }
            });
            this.contractPaymentService.saveOrUpdateBatch(jsonToList);
        }
        this.contractProductService.deleteByContractId(id);
        List<RkContractProductUpForm> productList = rkContractVerifyUpForm.getProductList();
        productList.stream().forEach(product -> product.setContractId(id));
        List productEntityList = JsonUtil.getJsonToList(productList, RkContractProductEntity.class);
        this.contractProductService.saveBatch(productEntityList);
        this.attachmentService.deleteByContractId(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
        List<RkAttachmentUpForm> attachmentList = rkContractVerifyUpForm.getAttachmentList();
        attachmentList.stream().forEach(attach -> {
            attach.setContractId(id);
            attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
        });
        List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
        this.attachmentService.saveBatch(attachmentEntityList);
        if (!ObjectUtil.isEmpty((Object)entity.getCustomerId())) {
            CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()));
            entity.setCustomerAddress(byId.getAddress());
            entity.setCustomerAddressName(this.baseDataUtil.provinceData(entity.getCustomerAddress()));
            String[] split2 = byId.getAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
            for (int i = 0; i < split2.length; ++i) {
                if (i == 0) {
                    entity.setCustomerRegion(split2[0]);
                    entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
                }
                if (i == 1) {
                    entity.setCustomerProv(split2[1]);
                    entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
                }
                if (i != 2) continue;
                entity.setCustomerCity(split2[2]);
                entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
            }
        }
        if (!ObjectUtil.isEmpty((Object)entity.getSalerId())) {
            entity.setSalerName(this.baseDataUtil.userSelectValueNoAccount(entity.getSalerId()));
        }
        if (!ObjectUtil.isEmpty((Object)entity.getRegion())) {
            entity.setRegionName(this.baseDataUtil.provinceData(entity.getRegion()));
        }
        if (!ObjectUtil.isEmpty((Object)entity.getDepartmentTree()) && (split = entity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
            entity.setDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getDepartmentTree()));
            entity.setDepartmentOne(split[0]);
            entity.setDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getDepartmentOne()));
            entity.setDepartment(split[split.length - 1]);
            entity.setDepartmentName(this.baseDataUtil.comSelectValues(entity.getDepartment()));
        }
        return this.updateById(entity);
    }

    @Override
    public boolean update(String id, RkContractVerifyEntity entity, List<RkAttachmentUpForm> attachmentList) throws DataException {
        String[] split;
        entity.setId(id);
        RkContractVerifyUpForm rkContractVerifyUpForm = (RkContractVerifyUpForm)((Object)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyUpForm.class));
        if (!ObjectUtil.isEmpty(rkContractVerifyUpForm.getPaymentList())) {
            List<RkContractPaymentVO> paymentList = rkContractVerifyUpForm.getPaymentList();
            paymentList.stream().forEach(payment -> {
                if (!ObjectUtil.isEmpty((Object)payment.getPaymentName()) && ObjectUtil.isEmpty((Object)payment.getPaymentType())) {
                    payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                }
            });
            String objectToString = JsonUtil.getObjectToString(paymentList);
            entity.setPaymentJson(objectToString);
            List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
            List oldIdList = listByContractId.stream().map(RkContractPaymentEntity::getId).collect(Collectors.toList());
            List newIdList = paymentList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getId())).map(RkContractPaymentVO::getId).collect(Collectors.toList());
            List needRemoveIdList = oldIdList.stream().filter(x -> !newIdList.contains(x)).collect(Collectors.toList());
            this.contractPaymentService.removeBatchByIds(needRemoveIdList);
            List jsonToList = JsonUtil.getJsonToList(paymentList, RkContractPaymentEntity.class);
            jsonToList.stream().forEach(x -> {
                x.setContractId(id);
                if (ObjectUtil.isEmpty((Object)x.getId())) {
                    x.setId(RandomUtil.uuId());
                }
            });
            this.contractPaymentService.saveOrUpdateBatch(jsonToList);
        }
        this.contractProductService.deleteByContractId(id);
        List<RkContractProductUpForm> productList = rkContractVerifyUpForm.getProductList();
        productList.stream().forEach(product -> product.setContractId(id));
        List productEntityList = JsonUtil.getJsonToList(productList, RkContractProductEntity.class);
        this.contractProductService.saveBatch(productEntityList);
        this.attachmentService.deleteByContractId(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
        attachmentList.stream().forEach(attach -> {
            attach.setContractId(id);
            attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
        });
        List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
        this.attachmentService.saveBatch(attachmentEntityList);
        if (!ObjectUtil.isEmpty((Object)entity.getCustomerId())) {
            CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()));
            entity.setCustomerAddress(byId.getAddress());
            entity.setCustomerAddressName(this.baseDataUtil.provinceData(entity.getCustomerAddress()));
            String[] split2 = byId.getAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
            for (int i = 0; i < split2.length; ++i) {
                if (i == 0) {
                    entity.setCustomerRegion(split2[0]);
                    entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
                }
                if (i == 1) {
                    entity.setCustomerProv(split2[1]);
                    entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
                }
                if (i != 2) continue;
                entity.setCustomerCity(split2[2]);
                entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
            }
        }
        if (!ObjectUtil.isEmpty((Object)entity.getSalerId())) {
            entity.setSalerName(this.baseDataUtil.userSelectValueNoAccount(entity.getSalerId()));
        }
        if (!ObjectUtil.isEmpty((Object)entity.getRegion())) {
            entity.setRegionName(this.baseDataUtil.provinceData(entity.getRegion()));
        }
        if (!ObjectUtil.isEmpty((Object)entity.getDepartmentTree()) && (split = entity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
            entity.setDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getDepartmentTree()));
            entity.setDepartmentOne(split[0]);
            entity.setDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getDepartmentOne()));
            entity.setDepartment(split[split.length - 1]);
            entity.setDepartmentName(this.baseDataUtil.comSelectValues(entity.getDepartment()));
        }
        return this.updateById(entity);
    }

    @Override
    public boolean updateForm(String id, RkContractVerifyUpForm rkContractVerifyUpForm) {
        if (CollectionUtil.isNotEmpty(rkContractVerifyUpForm.getPaymentList())) {
            List<RkContractPaymentVO> paymentList = rkContractVerifyUpForm.getPaymentList();
            paymentList.stream().forEach(payment -> {
                if (!ObjectUtil.isNull((Object)payment.getPaymentName()) && ObjectUtil.isNull((Object)payment.getPaymentType())) {
                    payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                }
            });
            String objectToString = JsonUtil.getObjectToString(paymentList);
            rkContractVerifyUpForm.setPaymentJson(objectToString);
            List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
            List oldIdList = listByContractId.stream().map(RkContractPaymentEntity::getId).collect(Collectors.toList());
            List newIdList = paymentList.stream().filter(x -> !ObjectUtil.isNull((Object)x.getId())).map(RkContractPaymentVO::getId).collect(Collectors.toList());
            List needRemoveIdList = oldIdList.stream().filter(x -> !newIdList.contains(x)).collect(Collectors.toList());
            this.contractPaymentService.removeBatchByIds(needRemoveIdList);
            List jsonToList = JsonUtil.getJsonToList(paymentList, RkContractPaymentEntity.class);
            jsonToList.stream().forEach(x -> {
                x.setContractId(id);
                if (ObjectUtil.isNull((Object)x.getId())) {
                    x.setId(RandomUtil.uuId());
                }
            });
            this.contractPaymentService.saveOrUpdateBatch(jsonToList);
        }
        this.contractProductService.deleteByContractId(id);
        List<RkContractProductUpForm> productList = rkContractVerifyUpForm.getProductList();
        productList.stream().forEach(product -> product.setContractId(id));
        List productEntityList = JsonUtil.getJsonToList(productList, RkContractProductEntity.class);
        this.contractProductService.saveBatch(productEntityList);
        this.attachmentService.deleteByContractId(id, AttachmentTypeEnum.CONTRACT_TYPE.getType());
        List<RkAttachmentUpForm> attachmentList = rkContractVerifyUpForm.getAttachmentList();
        attachmentList.stream().forEach(attach -> {
            attach.setContractId(id);
            attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
        });
        List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
        this.attachmentService.saveBatch(attachmentEntityList);
        RkContractVerifyEntity rkContractVerifyEntity = (RkContractVerifyEntity)JsonUtil.getJsonToBean((Object)((Object)rkContractVerifyUpForm), RkContractVerifyEntity.class);
        if (ObjectUtil.isNotNull((Object)rkContractVerifyEntity.getDepartmentTree())) {
            String replace1 = rkContractVerifyEntity.getDepartmentTree().replace("\\", "").replace("[\"[", "[").replace("]\"]", "]");
            rkContractVerifyEntity.setDepartmentTree(replace1);
        }
        if (ObjectUtil.isNotNull((Object)rkContractVerifyEntity.getIsStampType())) {
            String replace = rkContractVerifyEntity.getIsStampType().replace("[", "").replace("]", "").replace("\"", "");
            rkContractVerifyEntity.setIsStampType(replace);
        }
        return this.updateById(rkContractVerifyEntity);
    }

    private BigDecimal countContractTaxAmount(RkContractVerifyEntity entity) {
        String dicName = this.baseDataUtil.getDictName(entity.getContractTaxRate(), "");
        dicName = dicName.replace("%", "");
        BigDecimal taxAmout = entity.getContractAmount().multiply(new BigDecimal(dicName)).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        return taxAmout;
    }

    @Override
    public List<RkContractVerifyEntity> getListByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkContractVerifyEntity::getContractCode, (Object)code);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractVerifyEntity> getListByAgentId(String agentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(RkContractVerifyEntity::getAgentIds, (Object)agentId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkContractVerifyEntity> getListByCode(String code, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(RkContractVerifyEntity::getContractCode, (Object)code)).eq(RkContractVerifyEntity::getCompanyId, (Object)companyId);
        return this.list((Wrapper)queryWrapper);
    }

    private void countContractTaxAmountNew(RkContractVerifyEntity entity) {
        String dicName = this.baseDataUtil.getDictName(entity.getContractTaxRate(), "").replace("%", "");
        String add = MathUtils.add("1", MathUtils.divide(dicName, "100", 2));
        String amountExcludingTax = MathUtils.divide(entity.getContractAmount().toString(), add, 2);
        String contractTaxAmount = MathUtils.substract(entity.getContractAmount().toString(), amountExcludingTax);
        entity.setAmountExcludingTax(MathUtils.toBigDecimal(amountExcludingTax));
        entity.setContractTaxAmount(MathUtils.toBigDecimal(contractTaxAmount));
        if (!ObjectUtil.isEmpty((Object)entity.getRetentionMoneyRatio())) {
            String divide1 = MathUtils.divide(entity.getRetentionMoneyRatio().toString(), "100", 2);
            String multiply = MathUtils.multiply(entity.getContractAmount().toString(), divide1);
            entity.setRetentionMoneyAmount(MathUtils.toBigDecimal(multiply));
        }
    }

    @Override
    @FlowCallBackMethod(fullName="\u9500\u552e\u5408\u540c\u7533\u8bf7")
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) throws JsonProcessingException {
        SaleNoContractEntity noContract;
        boolean isPc = true;
        String header = ServletUtils.getHeader((String)"jsbos-origin");
        if (StringUtils.isNull((Object)header) || !StringUtils.equals((CharSequence)header, (CharSequence)"pc")) {
            isPc = false;
        }
        RkContractVerifyEntity rkContractVerifyEntity = this.getInfo(id);
        rkContractVerifyEntity.setEnableMark(String.valueOf(enableMark));
        UserInfo userInfo = this.userProvider.get();
        rkContractVerifyEntity.setCustomerName(ObjectUtil.isEmpty((Object)rkContractVerifyEntity.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)rkContractVerifyEntity.getCustomerId()))).getName());
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyEntity.getSalerId())) {
            rkContractVerifyEntity.setSalerName(this.baseDataUtil.userSelectValueNoAccount(rkContractVerifyEntity.getSalerId()));
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyEntity.getRegion())) {
            rkContractVerifyEntity.setRegionName(this.baseDataUtil.provinceData(rkContractVerifyEntity.getRegion()));
        }
        if (!ObjectUtil.isEmpty((Object)rkContractVerifyEntity.getCustomerId())) {
            CrmCustomerEntity byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)rkContractVerifyEntity.getCustomerId()));
            rkContractVerifyEntity.setCustomerAddress(byId.getAddress());
            rkContractVerifyEntity.setCustomerAddressName(this.baseDataUtil.provinceData(rkContractVerifyEntity.getCustomerAddress()));
            String[] split = byId.getAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    rkContractVerifyEntity.setCustomerRegion(split[0]);
                    rkContractVerifyEntity.setCustomerRegionName(this.baseDataUtil.provinceData(rkContractVerifyEntity.getCustomerRegion()));
                }
                if (i == 1) {
                    rkContractVerifyEntity.setCustomerProv(split[1]);
                    rkContractVerifyEntity.setCustomerProvName(this.baseDataUtil.provinceData(rkContractVerifyEntity.getCustomerProv()));
                }
                if (i != 2) continue;
                rkContractVerifyEntity.setCustomerCity(split[2]);
                rkContractVerifyEntity.setCustomerCityName(this.baseDataUtil.provinceData(rkContractVerifyEntity.getCustomerCity()));
            }
        }
        if (StringUtils.isNotEmpty((String)rkContractVerifyEntity.getIncomeType()) && rkContractVerifyEntity.getIncomeType().startsWith("[")) {
            rkContractVerifyEntity.setIncomeType(rkContractVerifyEntity.getIncomeType().replace("[\"", "").replace("\"]", "").replaceAll("\"", ""));
        }
        if (enableMark == 4) {
            RkContractVerifyUpForm jsonToBean = (RkContractVerifyUpForm)((Object)JsonUtil.getJsonToBean((Object)model.getFormData(), RkContractVerifyUpForm.class));
            if (StringUtils.isNotEmpty((String)jsonToBean.getIncomeType()) && jsonToBean.getIncomeType().startsWith("[")) {
                jsonToBean.setIncomeType(rkContractVerifyEntity.getIncomeType().replace("[\"", "").replace("\"]", "").replaceAll("\"", ""));
            }
            if (isPc) {
                this.rkContractVerifyService.updateForm(id, jsonToBean);
            }
            return false;
        }
        if (enableMark == 2) {
            RkProjectReportingEntity reporting;
            rkContractVerifyEntity.setPassTime(new Date());
            if (!rkContractVerifyEntity.getCompanyId().equals("2") && !rkContractVerifyEntity.getCompanyId().equals("3")) {
                rkContractVerifyEntity.setIsArchived(1);
                rkContractVerifyEntity.setArchivedTime(new Date());
                rkContractVerifyEntity.setArchivedBy(userInfo.getUserId());
            }
            OaRecordSubitemCrCrmForm oaRecordSubitemCrForm = new OaRecordSubitemCrCrmForm();
            String procureFileRemark = "\u5173\u8054\u7c7b\u578b\uff1a\u9500\u552e\u5408\u540c  ";
            String agentName = "";
            if (ObjectUtil.equals((Object)rkContractVerifyEntity.getIsAgent(), (Object)1)) {
                RkAgentEntity agent;
                if (StringUtils.isNotEmpty((String)rkContractVerifyEntity.getAgentId()) && null != (agent = this.agentService.getInfo(rkContractVerifyEntity.getAgentId()))) {
                    agentName = agent.getName();
                }
            } else {
                agentName = this.oaContractCustomerService.getCustomerNamesByContractId(rkContractVerifyEntity.getId());
            }
            rkContractVerifyEntity.setContractTypeDesc(this.baseDataUtil.getDictName(rkContractVerifyEntity.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            procureFileRemark = procureFileRemark + "\u9500\u552e\u5408\u540c\u53f7\uff1a" + rkContractVerifyEntity.getContractCode() + "\uff0c\u5173\u8054\u540d\u79f0\uff1a" + rkContractVerifyEntity.getContractName() + "\uff0c\u5173\u8054\u5bf9\u8c61\uff1a" + agentName + "\uff0c\u5408\u540c\u7c7b\u578b\uff1a" + rkContractVerifyEntity.getContractTypeDesc();
            oaRecordSubitemCrForm.setRemark(procureFileRemark);
            oaRecordSubitemCrForm.setBusinessId(rkContractVerifyEntity.getId());
            oaRecordSubitemCrForm.setBusinessType("market");
            oaRecordSubitemCrForm.setRecordSubitemName(rkContractVerifyEntity.getContractName());
            oaRecordSubitemCrForm.setSubitemCode(rkContractVerifyEntity.getContractCode());
            oaRecordSubitemCrForm.setSubitemType("paper");
            oaRecordSubitemCrForm.setNumber(1);
            oaRecordSubitemCrForm.setPages(1);
            oaRecordSubitemCrForm.setCreatorUserId(rkContractVerifyEntity.getCreatorUserId());
            oaRecordSubitemCrForm.setBusinessCompanyId(rkContractVerifyEntity.getCompanyId());
            RkContractEntity entity = (RkContractEntity)JsonUtil.getJsonToBean((Object)rkContractVerifyEntity, RkContractEntity.class);
            List<RkAttachmentEntity> attachmentList = this.attachmentService.getListByContractId(entity.getId());
            if (CollectionUtil.isNotEmpty(attachmentList)) {
                ObjectMapper mapper = new ObjectMapper();
                String jsonString = mapper.writeValueAsString(attachmentList);
                oaRecordSubitemCrForm.setAccessory(jsonString);
            }
            oaRecordSubitemCrForm.setBusinessCompanyId(rkContractVerifyEntity.getCompanyId());
            this.oaFileCrmServic.businessRecordSonAddCrm(oaRecordSubitemCrForm);
            entity.setEnableMark("draft");
            entity.setContractLevel(rkContractVerifyEntity.getContractLevel());
            entity.setContractSource(3);
            if (CollectionUtil.isNotEmpty(attachmentList)) {
                entity.setIsHaveAttachment(1);
            } else {
                entity.setIsHaveAttachment(0);
            }
            entity.setDoubleSignedAttachment(0);
            entity.setBusinessAmount(entity.getContractAmount());
            entity.setShallMentionAmount(entity.getContractAmount());
            if (StringUtils.isNotEmpty((String)entity.getCustomerIds())) {
                this.saleContractCustomerService.insertListByCustomerIds(entity.getId(), entity.getCustomerIds());
            }
            entity.setOriginalSalerId(entity.getSalerId());
            this.contractService.save(entity);
            CrmCustomerMyCrForm crForm = new CrmCustomerMyCrForm(entity.getCustomerId(), entity.getSalerId(), "1", 1, 1, "1");
            this.crmCustomerMyService.saveCrmCustomer(crForm);
            if (StringUtils.isNotEmpty((String)rkContractVerifyEntity.getOpportunityId()) && null != (reporting = this.rkProjectReportingService.getInfo(rkContractVerifyEntity.getOpportunityId()))) {
                reporting.setSaleStage(ProjectReportStageTrendsEnum.WIN_STAGE.getStage());
                reporting.setWinOrLose(1);
                this.rkProjectReportingService.updateById(reporting);
            }
            List<OaContractPurchasePlanEntity> planList = this.oaContractPurchasePlanService.getPlanListByContractId(id);
            this.oaContractPurchasePlanService.insertPlan(planList);
            if (StrUtil.isNotEmpty((CharSequence)entity.getNoContractId())) {
                List<OaPurchasePlanEntity> detailList = this.oaPurchasePlanService.getByNoContractId(entity.getNoContractId());
                detailList.stream().forEach(a -> a.setContractId(id));
                this.oaPurchasePlanService.updateBatchById(detailList);
            }
        }
        if (StringUtils.isNotEmpty((String)rkContractVerifyEntity.getNoContractId()) && null != (noContract = this.saleNoContractService.getInfo(rkContractVerifyEntity.getNoContractId()))) {
            noContract.setStatus(SaleNoContractStatusEnum.VERIFICATION_IN_PROGRESS_STATUS.getStatus());
            noContract.setContractId(rkContractVerifyEntity.getId());
            if (enableMark == 2) {
                List<RkProjectStartEntity> projectStartList;
                Integer num;
                List<RkContractProjectEntity> list;
                noContract.setStatus(SaleNoContractStatusEnum.VERIFIED_OFF_STATUS.getStatus());
                RkContractEntity contract = this.contractService.getInfo(rkContractVerifyEntity.getId());
                if (null != contract && SpecialTypeEnum.NO_CONTRACT.getSpecialType().equals(contract.getSpecialType())) {
                    contract.setSpecialType(noContract.getSpecialType());
                    this.contractService.updateById(contract);
                }
                if (CollectionUtil.isNotEmpty(list = this.rkContractProjectService.getListByNoContractIdHaveDel(noContract.getId()))) {
                    list.stream().forEach(item -> {
                        item.setContractId(rkContractVerifyEntity.getId());
                        item.setSalerId(rkContractVerifyEntity.getSalerId());
                        item.setSalerName(rkContractVerifyEntity.getSalerName());
                        this.afterSalesMaintenanceService.updateStatusByContractId((RkContractProjectEntity)item);
                    });
                    this.rkContractProjectService.updateBatchById(list);
                }
                if ((num = this.rkContractVerifyMapper.updateProjectStartByNoContractId(noContract.getId(), rkContractVerifyEntity.getId())) > 0 && CollectionUtil.isNotEmpty(projectStartList = this.rkProjectStartService.getListByContractId(noContract.getId()))) {
                    projectStartList.stream().forEach(item -> item.setContractId(rkContractVerifyEntity.getId()));
                    this.rkProjectStartService.updateBatchById(projectStartList);
                }
            }
            if (enableMark == 3 || enableMark == 5 || enableMark == 6) {
                noContract.setStatus(SaleNoContractStatusEnum.UNRECOGNIZED_STATUS.getStatus());
                noContract.setContractId("");
            }
            this.saleNoContractService.updateById(noContract);
        }
        return this.updateById(rkContractVerifyEntity);
    }

    @Override
    public Map<String, Object> countAmountByPlan(RkContractVerifyPagination rkContractVerifyPagination) {
        Map map = MapUtil.newHashMap();
        map.put("totalContractAmount", "0");
        map.put("contractNum", "0");
        map.put("totalEffectiveAmount", "0");
        QueryWrapper<RkContractVerifyEntity> queryWrapper = new QueryWrapper<RkContractVerifyEntity>();
        queryWrapper = this.appendWrapper(rkContractVerifyPagination);
        if (ObjectUtil.isEmpty(queryWrapper)) {
            return map;
        }
        queryWrapper.select(new String[]{"sum(contract_amount) as totalContractAmount,sum(valid_contract_amount) as totalEffectiveAmount,count(id) as contractNum"});
        map = this.getMap((Wrapper)queryWrapper);
        return map;
    }

    @Override
    public void delete(RkContractVerifyEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public RkContractVerifyFileResponseUpForm getContractFileContent(List<RkAttachmentCrForm> fileList, String companyId) {
        if (CollectionUtil.isNotEmpty(fileList)) {
            RkAttachmentCrForm file = fileList.get(0);
            String url = file.getUrl();
            Map<String, Object> responseXml = this.contractHttpClientUtil.sendRequest(url, file.getUrl());
            if (StringUtils.equals((CharSequence)"200", (CharSequence)responseXml.get("responseCode").toString())) {
                List paymentModels;
                List partyBList;
                List matchB;
                Object entity = responseXml.get("responseXml");
                RkContractVerifyFileResponseUpForm upForm = (RkContractVerifyFileResponseUpForm)JsonUtil.getJsonToBean((Object)JSONUtil.parseObj((Object)entity), RkContractVerifyFileResponseUpForm.class);
                RkAgentEntity agentEntity = this.agentService.getInfoByFullNameAndCompanyId(upForm.getContractJia(), companyId);
                if (ObjectUtil.isNotEmpty((Object)agentEntity)) {
                    upForm.setAgentId(agentEntity.getId());
                    upForm.setIsAgent("1");
                }
                if (StringUtils.isNotEmpty((String)upForm.getCustomerName())) {
                    CrmCustomerEntity crmCustomer = this.crmCustomerService.getInfoByFullName(upForm.getCustomerName());
                    if (ObjectUtil.isNotEmpty((Object)crmCustomer)) {
                        upForm.setCustomerId(crmCustomer.getId());
                        upForm.setCustomerAddress(crmCustomer.getAddress());
                        if (StrUtil.equals((CharSequence)upForm.getCustomerName(), (CharSequence)upForm.getContractJia())) {
                            upForm.setIsAgent("0");
                        } else {
                            upForm.setIsAgent("1");
                        }
                    } else {
                        upForm.setIsAgent("1");
                    }
                } else {
                    upForm.setIsAgent("1");
                }
                String partyB = upForm.getContractYi();
                if (StrUtil.isNotEmpty((CharSequence)partyB) && CollectionUtil.isNotEmpty(matchB = (partyBList = this.dictionaryDataService.getDicList("ContractInternalTransactionSignSubject")).stream().filter(a -> a.getFullName().equals(partyB)).collect(Collectors.toList()))) {
                    upForm.setPartyB(((DictionaryDataEntity)matchB.get(0)).getEnCode());
                }
                if (ObjectUtil.isNotNull((Object)upForm.getPaymentList())) {
                    JSONArray paymentJson = JSONUtil.parseArray((String)upForm.getPaymentList());
                    paymentModels = JsonUtil.getJsonToList((Object)paymentJson, RkContractFileResponsePaymentModel.class);
                    this.rkContractVerifyFileResponseService.savePaymentList(paymentModels, upForm.getId());
                    upForm.setPaymentListModel(paymentModels);
                }
                if (ObjectUtil.isNotNull((Object)upForm.getSubjectMatterList())) {
                    JSONArray subjectMatterJson = JSONUtil.parseArray((String)upForm.getSubjectMatterList());
                    paymentModels = JsonUtil.getJsonToList((Object)subjectMatterJson, RkContractFileResponseSubjectModel.class);
                    this.rkContractVerifyFileResponseService.saveSubjectMatterList(paymentModels, upForm.getId());
                    upForm.setSubjectMatterListModel(paymentModels);
                }
                return upForm;
            }
            return null;
        }
        return null;
    }
}

