/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkMaterialEntity;
import com.bringspring.contract.mapper.RkMaterialMapper;
import com.bringspring.contract.model.rkmaterial.RkMaterialExcelModel;
import com.bringspring.contract.model.rkmaterial.RkMaterialImportVO;
import com.bringspring.contract.model.rkmaterial.RkMaterialPagination;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkMaterialService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkMaterialServiceImpl
extends ServiceImpl<RkMaterialMapper, RkMaterialEntity>
implements RkMaterialService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkContractService rkContractService;

    @Override
    public List<RkMaterialEntity> getList(RkMaterialPagination rkmaterialPagination) {
        Object rkmaterialObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkmaterialNum = 0;
        QueryWrapper rkmaterialQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkmaterialObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkmaterialQueryWrapper, rkmaterialPagination.getMenuId(), "rkmaterial"));
            if (ObjectUtil.isEmpty((Object)rkmaterialObj)) {
                return new ArrayList<RkMaterialEntity>();
            }
            rkmaterialQueryWrapper = (QueryWrapper)rkmaterialObj;
            ++rkmaterialNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkmaterialObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkmaterialQueryWrapper, rkmaterialPagination.getMenuId(), "rkmaterial"));
            if (ObjectUtil.isEmpty((Object)rkmaterialObj)) {
                return new ArrayList<RkMaterialEntity>();
            }
            rkmaterialQueryWrapper = (QueryWrapper)rkmaterialObj;
            ++rkmaterialNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkmaterialPagination.getMaterialCode())) {
            ++rkmaterialNum;
            rkmaterialQueryWrapper.lambda().like(RkMaterialEntity::getMaterialCode, (Object)rkmaterialPagination.getMaterialCode());
        }
        if (ObjectUtil.isNotEmpty((Object)rkmaterialPagination.getMaterialProperties())) {
            ++rkmaterialNum;
            rkmaterialQueryWrapper.lambda().eq(RkMaterialEntity::getMaterialProperties, (Object)rkmaterialPagination.getMaterialProperties());
        }
        if (ObjectUtil.isNotEmpty((Object)rkmaterialPagination.getMaterialName())) {
            ++rkmaterialNum;
            rkmaterialQueryWrapper.lambda().like(RkMaterialEntity::getMaterialName, (Object)rkmaterialPagination.getMaterialName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkmaterialPagination.getMaterialModel())) {
            ++rkmaterialNum;
            rkmaterialQueryWrapper.lambda().like(RkMaterialEntity::getMaterialModel, (Object)rkmaterialPagination.getMaterialModel());
        }
        if (ObjectUtil.isNotEmpty((Object)rkmaterialPagination.getMaterialType())) {
            ++rkmaterialNum;
            rkmaterialQueryWrapper.lambda().eq(RkMaterialEntity::getMaterialType, (Object)rkmaterialPagination.getMaterialType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkmaterialPagination.getMaterialBrand())) {
            ++rkmaterialNum;
            rkmaterialQueryWrapper.lambda().eq(RkMaterialEntity::getMaterialBrand, (Object)rkmaterialPagination.getMaterialBrand());
        }
        rkmaterialQueryWrapper.lambda().eq(RkMaterialEntity::getCompanyId, (Object)this.userProvider.get().getOrganizeId());
        if (AllIdList.size() > 0) {
            rkmaterialQueryWrapper.lambda().in(RkMaterialEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkmaterialPagination.getSidx())) {
            rkmaterialQueryWrapper.lambda().orderByDesc(RkMaterialEntity::getCreatorTime);
        } else {
            try {
                String sidx = rkmaterialPagination.getSidx();
                RkMaterialEntity rkmaterialEntity = new RkMaterialEntity();
                Field declaredField = rkmaterialEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkmaterialQueryWrapper = "asc".equals(rkmaterialPagination.getSort().toLowerCase()) ? (QueryWrapper)rkmaterialQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkmaterialQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkmaterialPagination.getCurrentPage(), rkmaterialPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkmaterialQueryWrapper);
            return rkmaterialPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkmaterialPagination.setData(list, list.size());
    }

    @Override
    public List<RkMaterialEntity> getTypeList(RkMaterialPagination rkmaterialPagination, String dataType) {
        Object rkmaterialObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkmaterialNum = 0;
        QueryWrapper rkmaterialQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkmaterialObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkmaterialQueryWrapper, rkmaterialPagination.getMenuId(), "rkmaterial"));
            if (ObjectUtil.isEmpty((Object)rkmaterialObj)) {
                return new ArrayList<RkMaterialEntity>();
            }
            rkmaterialQueryWrapper = (QueryWrapper)rkmaterialObj;
            ++rkmaterialNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkmaterialObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkmaterialQueryWrapper, rkmaterialPagination.getMenuId(), "rkmaterial"));
            if (ObjectUtil.isEmpty((Object)rkmaterialObj)) {
                return new ArrayList<RkMaterialEntity>();
            }
            rkmaterialQueryWrapper = (QueryWrapper)rkmaterialObj;
            ++rkmaterialNum;
        }
        if (ObjectUtil.isNotEmpty((Object)rkmaterialPagination.getMaterialCode())) {
            ++rkmaterialNum;
            rkmaterialQueryWrapper.lambda().like(RkMaterialEntity::getMaterialCode, (Object)rkmaterialPagination.getMaterialCode());
        }
        if (ObjectUtil.isNotEmpty((Object)rkmaterialPagination.getMaterialProperties())) {
            ++rkmaterialNum;
            rkmaterialQueryWrapper.lambda().eq(RkMaterialEntity::getMaterialProperties, (Object)rkmaterialPagination.getMaterialProperties());
        }
        if (ObjectUtil.isNotEmpty((Object)rkmaterialPagination.getMaterialName())) {
            ++rkmaterialNum;
            rkmaterialQueryWrapper.lambda().like(RkMaterialEntity::getMaterialName, (Object)rkmaterialPagination.getMaterialName());
        }
        if (ObjectUtil.isNotEmpty((Object)rkmaterialPagination.getMaterialModel())) {
            ++rkmaterialNum;
            rkmaterialQueryWrapper.lambda().like(RkMaterialEntity::getMaterialModel, (Object)rkmaterialPagination.getMaterialModel());
        }
        if (ObjectUtil.isNotEmpty((Object)rkmaterialPagination.getMaterialType())) {
            ++rkmaterialNum;
            rkmaterialQueryWrapper.lambda().eq(RkMaterialEntity::getMaterialType, (Object)rkmaterialPagination.getMaterialType());
        }
        if (ObjectUtil.isNotEmpty((Object)rkmaterialPagination.getMaterialBrand())) {
            ++rkmaterialNum;
            rkmaterialQueryWrapper.lambda().eq(RkMaterialEntity::getMaterialBrand, (Object)rkmaterialPagination.getMaterialBrand());
        }
        rkmaterialQueryWrapper.lambda().eq(RkMaterialEntity::getCompanyId, (Object)this.userProvider.get().getOrganizeId());
        if (AllIdList.size() > 0) {
            rkmaterialQueryWrapper.lambda().in(RkMaterialEntity::getId, AllIdList);
        }
        if (ObjectUtil.isEmpty((Object)rkmaterialPagination.getSidx())) {
            rkmaterialQueryWrapper.lambda().orderByDesc(RkMaterialEntity::getCreatorTime);
        } else {
            try {
                String sidx = rkmaterialPagination.getSidx();
                RkMaterialEntity rkmaterialEntity = new RkMaterialEntity();
                Field declaredField = rkmaterialEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkmaterialQueryWrapper = "asc".equals(rkmaterialPagination.getSort().toLowerCase()) ? (QueryWrapper)rkmaterialQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkmaterialQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkmaterialPagination.getCurrentPage(), rkmaterialPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkmaterialQueryWrapper);
                return rkmaterialPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkmaterialPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkmaterialQueryWrapper);
    }

    @Override
    public RkMaterialEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkMaterialEntity::getId, (Object)id);
        return (RkMaterialEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkMaterialEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkMaterialEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkMaterialEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public String getMaxCode(RkMaterialPagination rkmaterialPagination) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String year = sdf.format(new Date());
        String maxCode = "";
        int rkmaterialNum = 0;
        QueryWrapper rkmaterialQueryWrapper = new QueryWrapper();
        ++rkmaterialNum;
        rkmaterialQueryWrapper.lambda().like(RkMaterialEntity::getMaterialCode, (Object)year);
        rkmaterialQueryWrapper.lambda().orderByDesc(RkMaterialEntity::getMaterialCode);
        List list = this.list((Wrapper)rkmaterialQueryWrapper);
        if (list.size() > 0) {
            RkMaterialEntity e = (RkMaterialEntity)list.get(0);
            String maxCodeYear = e.getMaterialCode();
            Integer max_code = Integer.parseInt(maxCodeYear.replace(year + "3", "")) + 1;
            maxCode = year + "3" + String.format("%05d", max_code);
        } else {
            maxCode = year + "300001";
        }
        return maxCode;
    }

    @Override
    public Map<String, Object> importPreview(List<RkMaterialExcelModel> pList) {
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        if (pList != null) {
            int i;
            String msg = "";
            for (i = 0; i < pList.size(); ++i) {
                HashMap<String, String> dataRowMap = new HashMap<String, String>();
                RkMaterialExcelModel model = pList.get(i);
                dataRowMap.put("materialUnit", model.getMaterialUnit());
                dataRowMap.put("materialModel", model.getMaterialModel());
                dataRowMap.put("materialBrand", model.getMaterialBrand());
                dataRowMap.put("materialName", model.getMaterialName());
                dataRowMap.put("materialType", model.getMaterialType());
                dataRowMap.put("materialProperties", model.getMaterialProperties());
                dataRow.add(dataRowMap);
            }
            for (i = 1; i < 6; ++i) {
                HashMap<String, Object> columnsMap = new HashMap<String, Object>();
                columnsMap.put("AllowDBNull", true);
                columnsMap.put("AutoIncrement", false);
                columnsMap.put("AutoIncrementSeed", 0);
                columnsMap.put("AutoIncrementStep", 1);
                columnsMap.put("Caption", this.getColumns(i));
                columnsMap.put("ColumnMapping", 1);
                columnsMap.put("ColumnName", this.getColumns(i));
                columnsMap.put("Container", null);
                columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
                columnsMap.put("DateTimeMode", 3);
                columnsMap.put("DefaultValue", null);
                columnsMap.put("DesignMode", false);
                columnsMap.put("Expression", "");
                columnsMap.put("ExtendedProperties", "");
                columnsMap.put("MaxLength", -1);
                columnsMap.put("Namespace", "");
                columnsMap.put("Ordinal", 0);
                columnsMap.put("Prefix", "");
                columnsMap.put("ReadOnly", false);
                columnsMap.put("Site", null);
                columnsMap.put("Table", pList);
                columnsMap.put("Unique", false);
                columns.add(columnsMap);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    @Override
    public RkMaterialImportVO importData(List<RkMaterialExcelModel> dt) {
        String msg = "";
        String maxCode = this.getMaxCode(null);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String year = sdf.format(new Date());
        List propertiesList = this.dictionaryDataService.getList("523060482374910725", Boolean.valueOf(true));
        List typeList = this.dictionaryDataService.getList("495138245651205189", Boolean.valueOf(true));
        List unitList = this.dictionaryDataService.getList("495138486265842757", Boolean.valueOf(true));
        List brandList = this.dictionaryDataService.getList("495138354195598405", Boolean.valueOf(true));
        List errorMsgList = CollectionUtil.list((boolean)false);
        List errorList = CollectionUtil.list((boolean)false);
        List successList = CollectionUtil.list((boolean)false);
        for (RkMaterialExcelModel model : dt) {
            if (ObjectUtil.isEmpty((Object)model.getMaterialProperties())) {
                model.setErrorMsg("\u7269\u6599\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrorMsg());
            } else if (propertiesList.stream().noneMatch(dictionaryDataEntity -> dictionaryDataEntity.getFullName().equals(model.getMaterialProperties()))) {
                model.setErrorMsg("\u7269\u6599\u5c5e\u6027\u4e0d\u5b58\u5728");
                errorMsgList.add(model.getErrorMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getMaterialType())) {
                model.setErrorMsg("\u7269\u6599\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrorMsg());
            } else if (typeList.stream().noneMatch(dictionaryDataEntity -> dictionaryDataEntity.getFullName().equals(model.getMaterialType()))) {
                model.setErrorMsg("\u7269\u6599\u5206\u7c7b\u4e0d\u5b58\u5728");
                errorMsgList.add(model.getErrorMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getMaterialUnit())) {
                model.setErrorMsg("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrorMsg());
            } else if (unitList.stream().noneMatch(dictionaryDataEntity -> dictionaryDataEntity.getFullName().equals(model.getMaterialUnit()))) {
                model.setErrorMsg("\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728");
                errorMsgList.add(model.getErrorMsg());
            }
            if (ObjectUtil.isEmpty((Object)model.getMaterialBrand())) {
                model.setErrorMsg("\u7269\u6599\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a");
                errorMsgList.add(model.getErrorMsg());
            } else if (brandList.stream().noneMatch(dictionaryDataEntity -> dictionaryDataEntity.getFullName().equals(model.getMaterialBrand()))) {
                model.setErrorMsg("\u54c1\u724c\u4e0d\u5b58\u5728");
                errorMsgList.add(model.getErrorMsg());
            }
            if (CollectionUtil.isNotEmpty((Collection)errorMsgList)) {
                model.setErrorMsg(CollectionUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                model.setErrMsgList(errorMsgList);
                errorMsgList = CollectionUtil.list((boolean)false);
                errorList.add(model);
                continue;
            }
            RkMaterialEntity entity = (RkMaterialEntity)JsonUtil.getJsonToBean((Object)model, RkMaterialEntity.class);
            RkMaterialEntity entity_new = new RkMaterialEntity();
            propertiesList.stream().forEach(p -> {
                if (p.getFullName().equals(entity.getMaterialProperties())) {
                    entity_new.setMaterialProperties(p.getEnCode());
                }
            });
            typeList.stream().forEach(p -> {
                if (p.getFullName().equals(entity.getMaterialType())) {
                    entity_new.setMaterialType(p.getEnCode());
                }
            });
            unitList.stream().forEach(p -> {
                if (p.getFullName().equals(entity.getMaterialUnit())) {
                    entity_new.setMaterialUnit(p.getEnCode());
                }
            });
            brandList.stream().forEach(p -> {
                if (p.getFullName().equals(entity.getMaterialBrand())) {
                    entity_new.setMaterialBrand(p.getEnCode());
                }
            });
            entity_new.setMaterialCode(maxCode);
            Integer max_code = Integer.parseInt(maxCode.replace(year + "3", "")) + 1;
            maxCode = year + "3" + String.format("%05d", max_code);
            entity_new.setId(RandomUtil.uuId());
            entity_new.setCreatorUserId(this.userProvider.get().getUserId());
            entity_new.setCreatorTime(new Date());
            entity_new.setMaterialName(entity.getMaterialName());
            entity_new.setMaterialModel(entity.getMaterialModel());
            successList.add(entity_new);
        }
        this.saveBatch(successList);
        RkMaterialImportVO vo = new RkMaterialImportVO();
        vo.setSnum(successList.size());
        vo.setFnum(errorList.size());
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList((Object)errorList, RkMaterialExcelModel.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u7269\u6599\u5c5e\u6027");
        map.put(2, "\u7269\u6599\u5206\u7c7b");
        map.put(3, "\u7269\u6599\u54c1\u724c");
        map.put(4, "\u7269\u6599\u540d\u79f0");
        map.put(5, "\u8ba1\u91cf\u5355\u4f4d");
        map.put(6, "\u7269\u6599\u578b\u53f7");
        return (String)map.get(key);
    }

    @Override
    public RkMaterialEntity getOneMatch(RkMaterialEntity rkMaterialEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(RkMaterialEntity::getMaterialProperties, (Object)rkMaterialEntity.getMaterialProperties())).eq(RkMaterialEntity::getMaterialType, (Object)rkMaterialEntity.getMaterialType())).eq(RkMaterialEntity::getMaterialBrand, (Object)rkMaterialEntity.getMaterialBrand())).eq(RkMaterialEntity::getMaterialName, (Object)rkMaterialEntity.getMaterialName())).eq(RkMaterialEntity::getMaterialModel, (Object)rkMaterialEntity.getMaterialModel())).eq(RkMaterialEntity::getMaterialUnit, (Object)rkMaterialEntity.getMaterialUnit());
        return (RkMaterialEntity)this.getOne((Wrapper)queryWrapper);
    }
}

